/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __BOOT_CLOCK_V_2_2_H__
#define __BOOT_CLOCK_V_2_2_H__

#ifdef __cplusplus
extern "C"{
#endif

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "boot_hw_type.h"

/**
 * @brief Initialize the system clock.
 *
 * @param nPllClkFreq PLL clock frequency.
 * @param nOscFreq Oscillator clock frequency.
 * @param nSysClkDiv System clock divider.
 * @param nAhbClkDiv AHB clock divider.
 * @param nApbClkDiv APB clock divider.
 * @param hse_en enable/disable external high-speed clock.
 * @param hse_type 1 - external oscillator, 0 - external crystal
 */
BOOT_TEXT void boot_sysctl_clock_init(uint32_t nPllClkFreq, uint32_t nOscFreq, uint32_t nSysClkDiv, uint32_t nAhbClkDiv, uint32_t nApbClkDiv, bool hse_en, uint8_t hse_type);

#endif

#ifdef __cplusplus
}
#endif

#endif
