/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __FDP_RT_UART_V3_0_H__
#define __FDP_RT_UART_V3_0_H__ 

#if (GS32F00xx == 0x3000)

#if defined(FDP_RT_FW)

#include "boot_uart.h"
#include "boot_hw_type.h"
#include "fdp_rt.h"

typedef struct {
	uintptr_t base;
	uint32_t irq_number;
	uint32_t rx_pin_number;
	uint32_t tx_pin_number;
	uint32_t rx_pinmux;
	uint32_t tx_pinmux;
	uint32_t bitrate;
	void (*irq_handler) (void);
} fdp_rt_uart_dev_priv_t;

BOOT_FDP_RT_SEC int fdp_rt_uart_init(fdp_rt_uart_dev_priv_t *uart_priv,
										uint32_t uart_clk);

BOOT_FDP_RT_SEC int fdp_rt_uart_deinit(fdp_rt_uart_dev_priv_t *uart_priv);

BOOT_FDP_RT_SEC int fdp_rt_uart_write(fdp_rt_uart_dev_priv_t *uart_priv,
										uint8_t *buf, uint32_t len);

BOOT_FDP_RT_SEC int fdp_rt_uart_read(fdp_rt_uart_dev_priv_t *uart_priv, uint8_t *buf,
										uint32_t *put_index, uint32_t *get_index,
										uint32_t rx_buf_size);

#endif

#endif

#endif
