/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#if ((GS32F3xx == 0x2200) ||(GS32F3xx == 0x2203))

#include "boot_sysctl_subcrg_clock_v2_2.h"

BOOT_SUBCRG_CLOCK_FUNC_SECTION void boot_sysctl_set_can_clk_src_sel(BootCanClkSrc_t type)
{
	HWREG(CRG_CFG_BASE + CRG_CFG_O_CAN_CORE_CLK_SEL) = type;
}

BOOT_SUBCRG_CLOCK_FUNC_SECTION void boot_sysctl_set_can_clk_div(uint32_t div)
{
	if (div > 1 && div <= 27)
		HWREG(CRG_CFG_BASE + CRG_CFG_O_CFG_DIV_CAN) = ((div-1)<<27) | (((0x7FFFFFF << div) & 0x7FFFFFF) | 0x01);
}

#endif
