import zlib
import struct
import argparse

input_bin_file0 = '../../../app_ex3_dsp_bootload_37x/FLASH_CORE0/app_ex3_dsp_bootload_37x.bin'
output_bin_file0 = '../../../app_ex3_dsp_bootload_37x/FLASH_CORE0/app0.bin'

input_bin_file1 = '../../../app_ex3_dsp_bootload_37x/FLASH_CORE1/app_ex3_dsp_bootload_37x.bin'
output_bin_file1 = '../../../app_ex3_dsp_bootload_37x/FLASH_CORE1/app1.bin'

def calculate_crc32(data) :
	return zlib.crc32(data) & 0xffffffff

app_info_size = 28

key_check_offset = 4

image_check_offset = 8

image_size_offset = 12

image_offset = 20

app_start_offset = 0

def modify_bin_file(input_file, output_file) :
	with open(input_file, 'rb') as f:
		header = f.read(app_info_size)

		# Obtain image offset
		app_start_offset = struct.unpack('<I', header[image_offset : image_offset + 4])[0]
		print(f"app_offset : {app_start_offset:#010x}")

		jump_header = f.read(app_start_offset - app_info_size)
		image_data = f.read()

		#Image CRC32 Check Code
		image_check = calculate_crc32(image_data)
		print(f"image check : {image_check:#010x}")
		header = header[:image_check_offset] + struct.pack('<I', image_check) + header[image_check_offset+4:]

		#Key Check CRC32 Check Code
		key = struct.unpack('<I', header[:4])[0]
		key_check = calculate_crc32(struct.pack('<I', key))
		print(f"key : {key:#010x}")
		print(f"key check : {key_check:#010x}")
		header = header[:key_check_offset] + struct.pack('<I', key_check) + header[key_check_offset+4:]

		#Image size
		header = header[:image_size_offset] + struct.pack('<I', len(image_data)) + header[image_size_offset+4:]
		print(f"Image size : {len(image_data)}")

	with open(output_file, 'wb') as f:
		f.write(header)
		f.write(jump_header)
		f.write(image_data)

def main(number) :
	image_number = int(number, 0)

	if (image_number == 0) :
		modify_bin_file(input_bin_file0, output_bin_file0)
	elif (image_number == 1) :
		modify_bin_file(input_bin_file1, output_bin_file1)


if __name__ == '__main__': 
	parser = argparse.ArgumentParser(description='Input bank number.')
	parser.add_argument('number', type=str, help='Save bank number.')
	args = parser.parse_args()

	main(args.number)