#include <stdint.h>
#include <string.h>

#include "fdp_err.h"
#include "fdp.h"

#include "device.h"

#include "spi_dev.h"

#include "fdp.h"

#define SPI_BASE	SPIA_BASE

#define GPIO_SPI_FLAG 4
#define FLAG_HIGH		    GPIO_writePin(GPIO_SPI_FLAG,1);
#define FLAG_LOW		    GPIO_writePin(GPIO_SPI_FLAG,0);

void PinMux_init(void)
{
	/* SPIA_STE */
	GPIO_setPinConfig(GPIO_0_SPIA_STE);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);
	GPIO_setQualificationMode(0, GPIO_QUAL_ASYNC);

	/* SPIA_CLK */
	GPIO_setPinConfig(GPIO_3_SPIA_CLK);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(3, GPIO_QUAL_ASYNC);

	/* SPIA_SIMO */
	GPIO_setPinConfig(GPIO_2_SPIA_SIMO);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(2, GPIO_QUAL_ASYNC);

	/* SPIA_SOMI */
	GPIO_setPinConfig(GPIO_1_SPIA_SOMI);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
	GPIO_setQualificationMode(1, GPIO_QUAL_ASYNC);

}

__INTERRUPT void spi_interrupt_irq_handler(void)
{
	uint16_t irq_status = SPI_getInterruptStatus(SPI_BASE);

	if (irq_status & SPI_RISR_RXFIR){
		fdp_receive_data_to_buffer();
	}

	SPI_clearInterruptStatus(SPI_BASE, SPI_RISR_RXFIR);
	__DSB();

}

int spi_init(void)
{
	GPIO_setDirectionMode(GPIO_SPI_FLAG,GPIO_DIR_MODE_OUT);
	FLAG_HIGH;

	PinMux_init();

	// Disabling the SPI module before initialization, using SPIA
	SPI_disableModule(SPI_BASE);

	// Initialize the SPIA module
	SPI_setConfig(SPI_BASE, DEVICE_SYSCLK_FREQ/4, SPI_PROT_POL1PHA1, SPI_MODE_PERIPHERAL, 500 * 1000, 8);

	// Set the FIFO threshold
	SPI_setFIFOInterruptLevel(SPI_BASE, SPI_FIFO_TX8, SPI_FIFO_RX4);

	// Disabling all interruptions
	SPI_disableAllInterrupt(SPI_BASE);

	// Clear all interruptions
	SPI_clearInterruptStatus(SPI_BASE, SPI_INT_RXFF);

	// Enable all interrupts
	SPI_enableInterrupt(SPI_BASE, SPI_INT_RXFF);

	// Turn off loopback
	SPI_disableLoopback(SPI_BASE);

    // Enable the SPI module
    SPI_enableModule(SPI_BASE);

	Interrupt_register(INT_SPIA, &spi_interrupt_irq_handler);
	Interrupt_enable(INT_SPIA);

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);

	return FDP_SUCCESS;
}

int Spi_Recevier(uint8_t *buf, uint32_t *index, uint32_t buf_len)
{

	if (buf == NULL || index == NULL)
		return -FDP_ERRINPARAM;

	while(SPI_getRxFIFOStatus(SPI_BASE)) {
		buf[(*index)++] = (uint8_t)SPI_readDataNonBlocking(SPI_BASE);
		if (*index >= buf_len)
			*index = 0;
	}

	return FDP_SUCCESS;
}

int Spi_Transmit(uint8_t *buf, uint32_t len)
{
	uint16_t temp;
	uint32_t i;

	SPI_resetTxFIFO(SPI_BASE);

	if (buf == NULL || len == 0)
		return -FDP_ERRINPARAM;

	for (i = 0; i < len; i++) {
		SPI_writeDataNonBlocking(SPI_BASE, buf[i]);
	}

	Interrupt_disable(INT_SPIA);

	FLAG_LOW;

	while((SPI_getStatus(SPI_BASE)&SPI_SR_TFE) == 0);
	FLAG_HIGH;
	while(SPI_isBusy(SPI_BASE));

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);

	Interrupt_enable(INT_SPIA);

	return FDP_SUCCESS;
}

