/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/******************************************************************************
 * @file
 * @brief    GNU Linker Script
 * @version  V1.0.0
 * @date     10. Sept 2024
 * @author   Jihong
 ******************************************************************************/

OUTPUT_ARCH( "riscv" )

/* Bootload region */
FLASH_BOOT_ADDR					= 0x08000000;
FLASH_BOOT_SIZE					= 0x8000;		/* 32KB */

/* Flash bank 1 rest region */
FLASH_BANK1_ADDR				= 0x08008000;
FLASH_BANK1_SIZE				= 0x78000;		/* 480KB */

/* Flash bank 2 region */
FLASH_BANK2_ADDR				= 0x08080000;
FLASH_BANK2_SIZE				= 0x80000;		/* 512KB */

/* FLASH APP region */
FLASH_APP_ADDR					= FLASH_BANK1_ADDR;
FLASH_APP_SIZE					= 0x20000 - 0x10;		/* 128KB - 0x10 */

/* FLASH APP END MARK region */
FLASH_ENDM_ADDR					= FLASH_APP_ADDR+FLASH_APP_SIZE;
FLASH_ENDM_SIZE					= 0x10;
 
/* DLM region */
DLM_ADDR						= 0x20140000;
DLM_SIZE						= 0x10000;		/* 64KB */

/* ILM region */
ILM_ADDR						= 0x20100000;
ILM_SIZE						= 0x40000;		/* 256KB */

/* GSRAM region */
GSRAM_ADDR						= 0x20038000;
GSRAM_SIZE						= 0x8000;		/* 32KB */
