/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __FDP_MEM_H__
#define __FDP_MEM_H__

#include <stdint.h>

#include "fdp.h"

/**
 * @brief Get the current state instance pointer of FDP.
 * 
 * @return fdp_record_stat_t* Return fdp_current_stat instance pointer.
 */
fdp_record_stat_t *fdp_get_current_stat(void);

/**
 * @brief Get the check buffer instance pointer of FDP.
 * 
 * @return uint8_t* Return check buffer instance pointer.
 */
uint8_t *fdp_get_check_buffer(void);

/**
 * @brief Get the frame buffer instance pointer of FDP.
 * 
 * @return uint8_t* Return frame buffer instance pointer.
 */
uint8_t *fdp_get_frame_buffer(void);

/**
 * @brief Get the receive data buffer instance pointer of FDP.
 * 
 * @return uint8_t* Return receive data buffer instance pointer.
 */
uint8_t *fdp_get_recv_buffer(void);

#endif
