import zlib

def crc16_modbus(data: bytes, length: int) -> int:
	"""
	Calculate CRC16 (Modbus) checksum for a given length of data.

	:param data: The byte data to calculate the checksum for.
	:param length: The length of the data to consider for the checksum calculation.
	:return: The CRC16 checksum as an integer.
	"""
	if length > len(data) :
		raise ValueError("Length exceeds the length of the data.\n")

	crc = 0xFFFF
	for i in range(length) :
		crc ^= data[i]
		for _ in range(0, 8) :
			if crc & 0x0001 :
				crc = (crc >> 1) ^ 0xA001
			else:
				crc = crc >> 1
	return crc

# def fdp_crc32(data: bytes) -> int:
# 	crc = 0xffffffff
# 	POLYNOMIAL = 0xEDB88320

# 	for byte in data:
# 		crc ^= byte
# 		for _ in range(8):
# 			if crc & 1:
# 				crc = (crc >> 1) ^ POLYNOMIAL
# 			else:
# 				crc = crc >> 1

# 	return ~crc & 0xffffffff

# def calculate_file_crc32(file_path: str) -> int:
# 	with open(file_path, 'rb') as file:
# 		file_data = file.read()
# 		crc32_value = fdp_crc32(file_data)
# 	return crc32_value

def calculate_file_crc32(file_path):
	with open(file_path, 'rb') as file:
		crc_value = zlib.crc32(b"") & 0xffffffff
		for chunk in iter(lambda: file.read(4096), b""):
			crc_value = zlib.crc32(chunk, crc_value) & 0xffffffff
	return crc_value