/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/******************************************************************************
 * @file
 * @brief    GNU Linker Script
 * @version  V1.0.0
 * @date     19. Nov 2024
 * @author   Jihong
 ******************************************************************************/
OUTPUT_ARCH( "riscv" )

/* Total flash memory region */
FLASH_MEMORY_ADDR				= 0x08000000;
FLASH_MEMORY_SIZE				= 0x00200000;		/* 2048KB */

/* Bootload region */
FLASH_BOOT_ADDR					= 0x08000000;
FLASH_BOOT_SIZE					= 0x8000;			/* 32KB */

/* Flash band1 for CPU1 rest region */
FLASH_BAND1_ADDR				= 0x08008000;
FLASH_BAND1_SIZE				= 0x000F8000;		/* 992KB */

/* Flash band2 for CPU2 rest region */
FLASH_BAND2_ADDR				= 0x08100000;
FLASH_BAND2_SIZE				= 0x00100000;		/* 1024KB */

/* Flash APP1 region (CPU1) */
FLASH_APP1_ADDR					= FLASH_BAND1_ADDR;
FLASH_APP1_SIZE					= 0x20000 - 0x10;	/* 128KB - 0x10 */

/* FLASH APP1 END MARK region */
FLASH_ENDM1_ADDR				= FLASH_APP1_ADDR + FLASH_APP1_SIZE;
FLASH_ENDM1_SIZE				= 0x10;

/* Flash APP2 region (CPU2) */
FLASH_APP2_ADDR					= FLASH_BAND2_ADDR;
FLASH_APP2_SIZE					= 0x20000 - 0x10;	/* 128KB - 0x10 */

/* FLASH APP1 END MARK region */
FLASH_ENDM2_ADDR				= FLASH_APP2_ADDR + FLASH_APP2_SIZE;
FLASH_ENDM2_SIZE				= 0x10;

/* DLM region */
DLM_REGION_ADDR					= 0x10840000;
DLM_REGION_SIZE					= 0x00010000;		/* 64KB */

/* ILM region */
ILM_REGION_ADDR					= 0x10800000;
ILM_REGION_SIZE					= 0x00040000;		/* 256KB */




/* The following defines in AXI RAMS (total 128KB, divied by customer required) */

/* alloc in AXI ram, Bootloader/Aapp shared memory region */
BOOTAPP_SHARE_ADDR				= 0x10200000;
BOOTAPP_SHARE_SIZE				= 0x1000;			/* 4KB */			

/* alloc in AXI ram, AXI_RAM region */
CPU1_AXI_ADDR					= BOOTAPP_SHARE_ADDR + BOOTAPP_SHARE_SIZE;
CPU1_AXI_SIZE					= 0x7000;			/* 28KB */

/* alloc in AXI ram, CPU1 RAMBOOT text region */
CPU1_RAMBOOT_ADDR				= CPU1_AXI_ADDR + CPU1_AXI_SIZE;
CPU1_RAMBOOT_SIZE				= 0x8000;			/* 32KB */

/* alloc in AXI ram, CPU1/CPU2 shared ram region */
MSG_SHARE_ADDR					= CPU1_RAMBOOT_ADDR + CPU1_RAMBOOT_SIZE;
MSG_SHARE_SIZE					= 0x10000;			/* 640KB */