#include <stdint.h>
#include <string.h>

#include "fdp_err.h"
#include "fdp.h"

#include "device.h"

#include "spi_dev.h"

#include "fdp.h"

#define SPI_BASE	SPIA_BASE

#define GPIO_SPI_FLAG 4
#if (GS32_PART_NUM == 0x035 || GS32_PART_NUM == 0x027)
#define FLAG_HIGH			HAL_GPIO_Set(A, 4);		//	GPIO_SPI_FLAG is GPIO4
#define FLAG_LOW		    HAL_GPIO_Clr(A, 4);		//  GPIO_SPI_FLAG is GPIO4
#else
#define FLAG_HIGH		    GPIO_writePin(GPIO_SPI_FLAG,1);
#define FLAG_LOW		    GPIO_writePin(GPIO_SPI_FLAG,0);
#endif

void PinMux_init(void)
{
	/* SPIA_STE */
	GPIO_setPinConfig(GPIO_19_SPIA_STEn);
	GPIO_setPadConfig(0, GPIO_PIN_TYPE_STD|GPIO_PIN_TYPE_PULLUP);

	/* SPIA_CLK */
	GPIO_setPinConfig(GPIO_18_SPIA_CLK);
	GPIO_setPadConfig(3, GPIO_PIN_TYPE_STD);

	/* SPIA_SIMO */
	GPIO_setPinConfig(GPIO_5_SPIA_SIMO);
	GPIO_setPadConfig(2, GPIO_PIN_TYPE_STD);

	/* SPIA_SOMI */
	GPIO_setPinConfig(GPIO_3_SPIA_SOMI);
	GPIO_setPadConfig(1, GPIO_PIN_TYPE_STD);
}

__INTERRUPT void spi_interrupt_irq_handler(void)
{
	uint16_t irq_status = SPI_getInterruptStatus(SPI_BASE);

	if (irq_status & SPI_FFRX_RXFFINT){
		fdp_receive_data_to_buffer();
	}

	SPI_clearInterruptStatus(SPI_BASE, SPI_INT_RXFF);
	__DSB();
}

int spi_init(void)
{
#if (GS32_PART_NUM == 0x035 || GS32_PART_NUM == 0x027)
	GpioCtrlRegs.GPADIR.bit.GPIO4 = 1U;
#else
	GPIO_setDirectionMode(GPIO_SPI_FLAG,GPIO_DIR_MODE_OUT);
#endif
	FLAG_HIGH;

	PinMux_init();

	// Disabling the SPI module before initialization, using SPIA
	SPI_disableModule(SPI_BASE);

	// Initialize the SPIA module
	SPI_setConfig(SPI_BASE, DEVICE_SYSCLK_FREQ/4, SPI_PROT_POL1PHA1, SPI_MODE_PERIPHERAL, 500 * 1000, 8);

	// Set the FIFO threshold
	SPI_setFIFOInterruptLevel(SPI_BASE, SPI_FIFO_TX8, SPI_FIFO_RX4);

	// Disabling RX interruptions
	SPI_disableInterrupt(SPI_BASE, SPI_INT_RXFF);

	// Clear all interruptions
	SPI_clearInterruptStatus(SPI_BASE, SPI_INT_RXFF);

	// Enable all interrupts
	SPI_enableInterrupt(SPI_BASE, SPI_INT_RXFF);

	// Turn off loopback
	SPI_disableLoopback(SPI_BASE);

    // Enable the SPI module
    SPI_enableModule(SPI_BASE);

	Interrupt_register(INT_SPIA_RX, &spi_interrupt_irq_handler);
	Interrupt_enable(INT_SPIA_RX);

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);

	return FDP_SUCCESS;
}

int Spi_Recevier(uint8_t *buf, uint32_t *index, uint32_t buf_len)
{

	if (buf == NULL || index == NULL)
		return -FDP_ERRINPARAM;

	while(SPI_getRxFIFOStatus(SPI_BASE)) {
		buf[(*index)++] = (uint8_t)SPI_readDataNonBlocking(SPI_BASE);
		if (*index >= buf_len)
			*index = 0;
	}

	return FDP_SUCCESS;
}

int Spi_Transmit(uint8_t *buf, uint32_t len)
{
	uint16_t temp;
	uint32_t i;

	SPI_resetTxFIFO(SPI_BASE);

	if (buf == NULL || len == 0)
		return -FDP_ERRINPARAM;

	for (i = 0; i < len; i++) {
		SPI_writeDataNonBlocking(SPI_BASE, buf[i]);
	}

	Interrupt_disable(INT_SPIA_RX);

	FLAG_LOW;

	while(SPI_getTxFIFOStatus(SPI_BASE) != SPI_FIFO_TXEMPTY);
	FLAG_HIGH;
	while(SPI_isBusy(SPI_BASE));

	SPI_resetTxFIFO(SPI_BASE);
	SPI_resetRxFIFO(SPI_BASE);

	Interrupt_enable(INT_SPIA_RX);

	return FDP_SUCCESS;
}

