/*--------------------------------------------------------*/
/* F021\F021.h                                            */
/* F021 Flash API                                   */
/*--------------------------------------------------------*/

/*!
    \file F021\F021.h
    \brief Main include file for F021 devices.
*/
#ifndef __F021_H__
#define __F021_H__

#include "Registers.h"

//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

/* Flash C API functions*/

/* Flash State Machine commands */
extern RAMFUNC_T Fapi_FlashStatusType Fapi_getFsmStatus(Fapi_FlashBankType iFlashBank);

extern RAMFUNC_T Fapi_StatusType Fapi_checkFsmForReady(Fapi_FlashBankType iFlashBank);

extern RAMFUNC_T Fapi_StatusType Fapi_setActiveFlashBank(Fapi_FlashBankType oNewFlashBank);

extern RAMFUNC_T Fapi_StatusType Fapi_issueFsmSuspendCommand(void);

extern RAMFUNC_T void Fapi_flushPipeline(void);

extern RAMFUNC_T Fapi_StatusType Fapi_setupBankSectorEnable(void);

/* Device Family Dependent FSM commands */
extern RAMFUNC_T uint32 * Fapi_remapEccAddress(uint32 u32EccAddress);

extern RAMFUNC_T boolean Fapi_isAddressEcc(uint32 u32Address);

/* Async Commands */
extern RAMFUNC_T Fapi_StatusType Fapi_issueAsyncCommandWithAddress(
														Fapi_FlashBankType iFlashBank,
                                                        Fapi_FlashStateCommandsType oCommand,
                                                        uint32 *pu32StartAddress
                                                        );

extern RAMFUNC_T Fapi_StatusType Fapi_issueAsyncCommand(Fapi_FlashBankType iFlashBank, Fapi_FlashStateCommandsType oCommand);

extern RAMFUNC_T Fapi_StatusType Fapi_issueBankEraseCommand(
                                          	uint32 *pu32StartAddress,
											uint16 oSectorMask
                                          );

/* Info Commands */
extern RAMFUNC_T Fapi_LibraryInfoType Fapi_getLibraryInfo(void);

/* Init */
//extern Fapi_InitStruct Fapi_GlobalInit;
extern RAMFUNC_T Fapi_StatusType Fapi_initializeAPI(
                                         Fapi_FmcRegistersType *poFlashControlRegister,
                                         uint32 u32HclkFrequency
                                         );

/* Read commands */
extern RAMFUNC_T Fapi_StatusType Fapi_doBlankCheck(
										Fapi_FlashBankType iFlashBank,
                                        uint32 *pu32StartAddress,
                                        uint32 u32Length,
                                        Fapi_FlashStatusWordType *poFlashStatusWord
                                        );

extern RAMFUNC_T Fapi_StatusType Fapi_doVerify(
                                    uint32 *pu32StartAddress,
                                    uint32 u32Length,
                                    uint32 *pu32CheckValueBuffer,
                                    Fapi_FlashStatusWordType *poFlashStatusWord
                                    );

extern RAMFUNC_T Fapi_StatusType Fapi_doVerifyBy16bits(
                             uint16 *pu16StartAddress,
                             uint32 u16Length,
                             uint16 *pu16CheckValueBuffer,
                             Fapi_FlashStatusWordType *poFlashStatusWord
                             );

extern RAMFUNC_T uint32 Fapi_calculatePsa(
                                uint32 *pu32StartAddress,
                                uint32 u32Length,
                                uint32 u32PsaSeed,
                                Fapi_FlashReadMarginModeType oReadMode
                               );

extern RAMFUNC_T Fapi_StatusType Fapi_doPsaVerify(
                                       uint32 *pu32StartAddress,
                                       uint32 u32Length,
                                       uint32 u32PsaValue,
                                       Fapi_FlashStatusWordType *poFlashStatusWord
                                       );


/* Programming Commands */
extern RAMFUNC_T Fapi_StatusType Fapi_issueProgrammingCommand(
											Fapi_FlashBankType iFlashBank,
                                            uint32 *pu32StartAddress,
                                            uint16 *pu32DataBuffer,
                                            uint16  u32DataBufferSizeInWords,
                                            uint16 *pu16EccBuffer,
                                            uint16  u16EccBufferSizeInBytes,
                                            Fapi_FlashProgrammingCommandsType oMode
                                            );
extern RAMFUNC_T Fapi_StatusType Fapi_issueProgrammingCommandByteSwap(
			Fapi_FlashBankType iFlashBank,
			uint32 *pu32StartAddress,
			uint16 *pu16DataBuffer,
			uint16  u16DataBufferSizeInWords,
			uint16 *pu16EccBuffer,
			uint16  u16EccBufferSizeInBytes,
			Fapi_FlashProgrammingCommandsType oMode
		);

extern RAMFUNC_T Fapi_StatusType Fapi_issueProgrammingCommandForEccAddresses(
                                                           uint32 *pu32StartAddress,
                                                           uint16 *pu16EccBuffer,
                                                           uint16 u16EccBufferSizeInBytes
                                                           );


/* Utility Commands */
extern RAMFUNC_T uint32 Fapi_calculateFletcherChecksum(
                                            uint16 const * pu16Data,
                                            uint16 u16Length
                                            );

extern RAMFUNC_T uint8 Fapi_calculateEcc(
                               uint32 u32Address,
                               uint64 u64Data
                               );

extern RAMFUNC_T Fapi_StatusType Fapi_configureFMAC(uint32 u32Address);

extern RAMFUNC_T _Bool Fapi_WriteReadBack(volatile uint32 * pu32TargetRegisterAddress, uint32 u32TargetData, uint32 u32Mask);

/* flash modules */
extern RAMFUNC_T void Flash_initModule(uint32_t ctrlBase, uint32_t eccBase, uint32 sysClk);
extern RAMFUNC_T uint32 Fapi_getWriteAddByAddr(Fapi_FlashBankType iFlashBank, uint32 Address);
extern RAMFUNC_T uint32 Fapi_GetIndexByAddr(uint32 addr);
extern RAMFUNC_T uint32 Fapi_GetIndexByCtlAddr(uint32 ctlAddr);
extern RAMFUNC_T uint32 Fapi_GetEfcCount(void);


extern RAMFUNC_T uint32 GS32Fapi_Init(uint32 inu32SysClk);
extern RAMFUNC_T uint32 GS32Fapi_EraseSector(uint32 inu32SectorAddr);
extern RAMFUNC_T uint32 GS32Fapi_EraseRegion(uint32 inu32Address, uint32 inu32LenthIn32BitsWords);
extern RAMFUNC_T uint32 GS32Fapi_Program(uint32 inu32Address, uint32 inu32DataAddr,uint32 inu32LenthIn32BitsWords);


#if IS_GS32F00xx(0x30)
extern RAMFUNC_T bool Fapi_isAddressMain(uint32 sectorAddress);
extern RAMFUNC_T uint32 Fapi_GetBankMode(void);
extern RAMFUNC_T uint32 Fapi_GetIndexByEraseAddr(uint32 addr);
#endif

#if IS_GS32F00xx(0x30,0x12)
extern RAMFUNC_T Fapi_StatusType GS32Fapi_OPT_SetClkRateSel(uint32 fieldValue);
extern RAMFUNC_T Fapi_StatusType GS32Fapi_OPT_SetBootDef(uint32 fieldValue);
extern RAMFUNC_T Fapi_StatusType GS32Fapi_OPT_SetRDP(GS32OPT_RdpLevelType RdpValue);
extern RAMFUNC_T GS32OPT_RdpLevelType GS32Fapi_OPT_GetRDP(void);
extern RAMFUNC_T void GS32Fapi_OPT_Launch(void);
#endif

//*****************************************************************************
//
// Mark the end of the C bindings section for C++ compilers.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif
#endif /*__F021_H__*/
