/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __STL_MATH_LIB_H__
#define __STL_MATH_LIB_H__

#include <stdint.h>
#include "stl_err.h"
#include "gs32_math.h"
#include "IQMathLib.h"

typedef enum {
    MATH_TEST_SIN,
    MATH_TEST_COS,
    MATH_TEST_TAN,
    MATH_TEST_SINPU,
    MATH_TEST_COSPU,
    MATH_TEST_ATANPU,
    MATH_TEST_ATAN2PU,
    MATH_TEST_ASIN,
    MATH_TEST_ACOS,
    MATH_TEST_ATAN,
    MATH_TEST_ATAN2,
    MATH_TEST_DIVF32,
    MATH_TEST_SQSUMF,
    MATH_TEST_SQRT,
    MATH_TEST_FABS,
    MATH_TEST_FMIN,
    MATH_TEST_FMAX,
    MATH_TEST_FSAT,
    MATH_TEST_FTRUNC,
    MATH_TEST_FFRACT,
    MATH_TEST_MPY2PIF32,
    MATH_TEST_DIV2PIF32,
    MATH_TEST_FDIV3SQRT,
    MATH_TEST_FMUL2,
    MATH_TEST_FDIV2,
    MATH_TEST_FDIV3,
    MATH_TEST_FDIV4,
    MATH_TEST_FMUL3SQRT,
    MATH_TEST_FMUL2_DIV3,
    MATH_TEST_FMUL3SQRT_DIV2,
    MATH_TEST_FMUL3SQRT_DIV6,
    MATH_TEST_FDIV3SQRT_MUL2,
    MATH_TEST_FMUL2PI_NEG,
    MATH_TEST_FDIV2PI_NEG,
    MATH_TEST_NEG1_FADD_CONST,
    MATH_TEST_NEG1_FSUB_CONST,
    MATH_TEST_FADD_ONE,
    MATH_TEST_FSUB_ONE,
    MATH_TEST_FADD_3SQRT,
    MATH_TEST_FSUB_3SQRT,
    MATH_TEST_FADD_PI3RD,
    MATH_TEST_FSUB_PI3RD,
    MATH_TEST_NEG1_FADD_ONE,
    MATH_TEST_NEG1_FSUB_ONE,
    MATH_TEST_NEG1_FADD_3SQRT,
    MATH_TEST_NEG1_FSUB_3SQRT,
    MATH_TEST_NEG1_FADD_PI3RD,
    MATH_TEST_EXPF32,
    MATH_TEST_LOGF32,
    MATH_TEST_POWF32,
    MATH_TEST_IQ8TOF,
    MATH_TEST_IQ8FRAC,
    MATH_TEST_IQ8SINPU,
    MATH_TEST_IQ8COSPU,
    MATH_TEST_IQ16SIN,
    MATH_TEST_IQ16COS,
    MATH_TEST_IQ16ASIN,
    MATH_TEST_IQ16ACOS,
    MATH_TEST_IQ24ATAN,
    MATH_TEST_IQ16ATAN2,
    MATH_TEST_IQNSAT,
    MATH_TEST_IQ16MPY,
    MATH_TEST_IQ16RMPY,
    MATH_TEST_IQ24MPYIQX,
    MATH_TEST_IQ18DIV,
    MATH_TEST_ATOIQ14,
    MATH_TEST_IQ24TOA,
    MATH_TEST_IQ15LOG,
    MATH_TEST_IQ8EXP,
    MATH_TEST_IQ10SQRT,
    MATH_TEST_SMIN,
    MATH_TEST_SMAX,
    MATH_TEST_UMIN,
    MATH_TEST_UMAX,
    MATH_TEST_RBIT,
    MATH_TEST_FLIP32,
    MATH_TEST_RBIT_MSBI,
    MATH_TEST_ANDN,
    MATH_TEST_ORN,
    MATH_TEST_NXOR,
    MATH_TEST_SAT16,
    MATH_TEST_SAT16U,
    MATH_TEST_SAT32U,
    MATH_TEST_ABS_SAT,
    MATH_TEST_CLO,
    MATH_TEST_CLZ,
    MATH_TEST_CTZ,
    MATH_TEST_CLRSB,
    MATH_TEST_BSWAP32,
    MATH_TEST_BSWAP16,
    MATH_TEST_ROUNDF,
    MATH_TEST_FLOORF,
    MATH_TEST_CEILF,
    MATH_TEST_LABS,
    MATH_TEST_COUNT
} math_test_id_t;

stl_err_t stl_mathlib_test(math_test_id_t test_id);

#endif
