/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __STL_SOFT_CRC_H__
#define __STL_SOFT_CRC_H__

#include "inc/hw_types.h"

/**
 * @brief CRC16 modbus verification algorithm
 *
 * @param data Data buffer.
 * @param length Data length.
 * @return uint16_t Return the CRC16 modbus verification value.
 */
static inline uint16_t stl_crc16_modbus(uint8_t *data, uint32_t length)
{
	uint16_t crc = 0xffff;
	/* Polynomial: x^16 + x^15 + x^2 + 1 */
	uint16_t polynomial = 0xa001;

	for (uint32_t i = 0; i < length; i++) {
	crc ^= data[i];

		for (uint8_t j = 0; j < 8; j++) {
			if (crc & 0x0001)
				crc = (crc >> 1) ^ polynomial;
			else
				crc >>= 1;
		}
	}

	return crc;
}

#endif
