/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __STL_VARIABLE_MEM_H__
#define __STL_VARIABLE_MEM_H__

#include <stdint.h>
#include <string.h>

#include "stl_err.h"

/**
 * @brief March-X MBIST memory algorithm.
 * 
 * @param address Address of the memory.
 * @param size Checked memory size.
 * @return stl_err_t If the memory is successfully checked, return STL_SUCCESS.
 * Otherwise, return non-zero values.
 */
stl_err_t stl_mbist_march_x_algorithm(uintptr_t address, uint32_t size);

/**
 * @brief March-C MBIST memory algorithm.
 * 
 * @param address Address of the memory.
 * @param size Checked memory size.
 * @return stl_err_t If the memory is successfully checked, return STL_SUCCESS.
 * Otherwise, return non-zero values.
 */
stl_err_t stl_mbist_march_c_algorithm(uintptr_t address, uint32_t size);

#endif
