/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <stdint.h>

#include "stl_cpu_register.h"
#include "stl_err.h"

stl_err_t stl_access_x_register(uint32_t x_reg_num)
{
	unsigned long saved_reg = 0;
	unsigned long read_value = 0;
	unsigned long tmp_x_reg_val = 0x2;

	switch(x_reg_num) {
		case 0 :
			asm volatile ("mv %[result], x0" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x0, %0" : : "r" (tmp_x_reg_val) : "x0");

			asm volatile ("mv %[result], x0" : [result] "=r" (read_value) : :);

			asm volatile ("mv x0, %0" : : "r" (saved_reg) : "x0");

			if (read_value != tmp_x_reg_val && read_value != 0)
				return STL_ERR_CHECK_FAILED;
			else
				return STL_SUCCESS;

		case 1 :
			asm volatile ("mv %[result], x1" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x1, %0" : : "r" (tmp_x_reg_val) : "x1");

			asm volatile ("mv %[result], x1" : [result] "=r" (read_value) : :);

			asm volatile ("mv x1, %0" : : "r" (saved_reg) : "x1");

			break;

		case 3 :
			asm volatile ("mv %[result], x3" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x3, %0" : : "r" (tmp_x_reg_val) : "x3");

			asm volatile ("mv %[result], x3" : [result] "=r" (read_value) : :);

			asm volatile ("mv x3, %0" : : "r" (saved_reg) : "x3");

			break;

		case 4 :
			asm volatile ("mv %[result], x4" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x4, %0" : : "r" (tmp_x_reg_val) : "x4");

			asm volatile ("mv %[result], x4" : [result] "=r" (read_value) : :);

			asm volatile ("mv x4, %0" : : "r" (saved_reg) : "x4");

			break;

		case 5 :
			asm volatile ("mv %[result], x5" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x5, %0" : : "r" (tmp_x_reg_val) : "x5");

			asm volatile ("mv %[result], x5" : [result] "=r" (read_value) : :);

			asm volatile ("mv x5, %0" : : "r" (saved_reg) : "x5");

			break;

		case 6 :
			asm volatile ("mv %[result], x6" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x6, %0" : : "r" (tmp_x_reg_val) : "x6");

			asm volatile ("mv %[result], x6" : [result] "=r" (read_value) : :);

			asm volatile ("mv x6, %0" : : "r" (saved_reg) : "x6");

			break;

		case 7 :
			asm volatile ("mv %[result], x7" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x7, %0" : : "r" (tmp_x_reg_val) : "x7");

			asm volatile ("mv %[result], x7" : [result] "=r" (read_value) : :);

			asm volatile ("mv x7, %0" : : "r" (saved_reg) : "x7");

			break;

		case 9 :
			asm volatile ("mv %[result], x9" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x9, %0" : : "r" (tmp_x_reg_val) : "x9");

			asm volatile ("mv %[result], x9" : [result] "=r" (read_value) : :);

			asm volatile ("mv x9, %0" : : "r" (saved_reg) : "x9");

			break;

		case 10 :
			asm volatile ("mv %[result], x10" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x10, %0" : : "r" (tmp_x_reg_val) : "x10");

			asm volatile ("mv %[result], x10" : [result] "=r" (read_value) : :);

			asm volatile ("mv x10, %0" : : "r" (saved_reg) : "x10");

			break;

		case 11 :
			asm volatile ("mv %[result], x11" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x11, %0" : : "r" (tmp_x_reg_val) : "x11");

			asm volatile ("mv %[result], x11" : [result] "=r" (read_value) : :);

			asm volatile ("mv x11, %0" : : "r" (saved_reg) : "x11");

			break;

		case 12 :
			asm volatile ("mv %[result], x12" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x12, %0" : : "r" (tmp_x_reg_val) : "x12");

			asm volatile ("mv %[result], x12" : [result] "=r" (read_value) : :);

			asm volatile ("mv x12, %0" : : "r" (saved_reg) : "x12");

			break;

		case 13 :
			asm volatile ("mv %[result], x13" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x13, %0" : : "r" (tmp_x_reg_val) : "x13");

			asm volatile ("mv %[result], x13" : [result] "=r" (read_value) : :);

			asm volatile ("mv x13, %0" : : "r" (saved_reg) : "x13");

			break;

		case 14 :
			asm volatile ("mv %[result], x14" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x14, %0" : : "r" (tmp_x_reg_val) : "x14");

			asm volatile ("mv %[result], x14" : [result] "=r" (read_value) : :);

			asm volatile ("mv x14, %0" : : "r" (saved_reg) : "x14");

			break;

		case 15 :
			asm volatile ("mv %[result], x15" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x15, %0" : : "r" (tmp_x_reg_val) : "x15");

			asm volatile ("mv %[result], x15" : [result] "=r" (read_value) : :);

			asm volatile ("mv x15, %0" : : "r" (saved_reg) : "x15");

			break;

		case 16 :
			asm volatile ("mv %[result], x16" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x16, %0" : : "r" (tmp_x_reg_val) : "x16");

			asm volatile ("mv %[result], x16" : [result] "=r" (read_value) : :);

			asm volatile ("mv x16, %0" : : "r" (saved_reg) : "x16");

			break;

		case 17 :
			asm volatile ("mv %[result], x17" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x17, %0" : : "r" (tmp_x_reg_val) : "x17");

			asm volatile ("mv %[result], x17" : [result] "=r" (read_value) : :);

			asm volatile ("mv x17, %0" : : "r" (saved_reg) : "x17");

			break;

		case 18 :
			asm volatile ("mv %[result], x18" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x18, %0" : : "r" (tmp_x_reg_val) : "x18");

			asm volatile ("mv %[result], x18" : [result] "=r" (read_value) : :);

			asm volatile ("mv x18, %0" : : "r" (saved_reg) : "x18");

			break;

		case 19 :
			asm volatile ("mv %[result], x19" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x19, %0" : : "r" (tmp_x_reg_val) : "x19");

			asm volatile ("mv %[result], x19" : [result] "=r" (read_value) : :);

			asm volatile ("mv x19, %0" : : "r" (saved_reg) : "x19");

			break;

		case 20 :
			asm volatile ("mv %[result], x20" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x20, %0" : : "r" (tmp_x_reg_val) : "x20");

			asm volatile ("mv %[result], x20" : [result] "=r" (read_value) : :);

			asm volatile ("mv x20, %0" : : "r" (saved_reg) : "x20");

			break;

		case 21 :
			asm volatile ("mv %[result], x21" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x21, %0" : : "r" (tmp_x_reg_val) : "x21");

			asm volatile ("mv %[result], x21" : [result] "=r" (read_value) : :);

			asm volatile ("mv x21, %0" : : "r" (saved_reg) : "x21");

			break;

		case 22 :
			asm volatile ("mv %[result], x22" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x22, %0" : : "r" (tmp_x_reg_val) : "x22");

			asm volatile ("mv %[result], x22" : [result] "=r" (read_value) : :);

			asm volatile ("mv x22, %0" : : "r" (saved_reg) : "x22");

			break;

		case 23 :
			asm volatile ("mv %[result], x23" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x23, %0" : : "r" (tmp_x_reg_val) : "x23");

			asm volatile ("mv %[result], x23" : [result] "=r" (read_value) : :);

			asm volatile ("mv x23, %0" : : "r" (saved_reg) : "x23");

			break;

		case 24 :
			asm volatile ("mv %[result], x24" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x24, %0" : : "r" (tmp_x_reg_val) : "x24");

			asm volatile ("mv %[result], x24" : [result] "=r" (read_value) : :);

			asm volatile ("mv x24, %0" : : "r" (saved_reg) : "x24");

			break;

		case 25 :
			asm volatile ("mv %[result], x25" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x25, %0" : : "r" (tmp_x_reg_val) : "x25");

			asm volatile ("mv %[result], x25" : [result] "=r" (read_value) : :);

			asm volatile ("mv x25, %0" : : "r" (saved_reg) : "x25");

			break;

		case 26 :
			asm volatile ("mv %[result], x26" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x26, %0" : : "r" (tmp_x_reg_val) : "x26");

			asm volatile ("mv %[result], x26" : [result] "=r" (read_value) : :);

			asm volatile ("mv x26, %0" : : "r" (saved_reg) : "x26");

			break;

		case 27 :
			asm volatile ("mv %[result], x27" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x27, %0" : : "r" (tmp_x_reg_val) : "x27");

			asm volatile ("mv %[result], x27" : [result] "=r" (read_value) : :);

			asm volatile ("mv x27, %0" : : "r" (saved_reg) : "x27");

			break;

		case 28 :
			asm volatile ("mv %[result], x28" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x28, %0" : : "r" (tmp_x_reg_val) : "x28");

			asm volatile ("mv %[result], x28" : [result] "=r" (read_value) : :);

			asm volatile ("mv x28, %0" : : "r" (saved_reg) : "x28");

			break;

		case 29 :
			asm volatile ("mv %[result], x29" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x29, %0" : : "r" (tmp_x_reg_val) : "x29");

			asm volatile ("mv %[result], x29" : [result] "=r" (read_value) : :);

			asm volatile ("mv x29, %0" : : "r" (saved_reg) : "x29");

			break;

		case 30 :
			asm volatile ("mv %[result], x30" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x30, %0" : : "r" (tmp_x_reg_val) : "x30");

			asm volatile ("mv %[result], x30" : [result] "=r" (read_value) : :);

			asm volatile ("mv x30, %0" : : "r" (saved_reg) : "x30");

			break;

		case 31 :
			asm volatile ("mv %[result], x31" : [result] "=r" (saved_reg) : :);

			asm volatile ("mv x31, %0" : : "r" (tmp_x_reg_val) : "x31");

			asm volatile ("mv %[result], x31" : [result] "=r" (read_value) : :);

			asm volatile ("mv x31, %0" : : "r" (saved_reg) : "x31");

			break;

		default :
			return STL_ERR_INVALID_PARAM;

	}

	if (read_value != tmp_x_reg_val)
		return STL_ERR_CHECK_FAILED;

	return STL_SUCCESS;
}
