/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include "stl_dma.h"
#include "dma.h"

stl_err_t stl_dma_test(uint32_t dma_base, uint32_t dma_ch_base)
{
	uint8_t src[4]={1,2,3,4};
	uint8_t dest[4]={0};
	DMA_ConfigParams dmaCfg = {0};

	/* DMA global enable */
	DMA_initController(dma_base);

	DMA_stopChannel(dma_base);

	dmaCfg.enableInterrupt = 1;
	dmaCfg.srcAddr = (uint32_t)src;
	dmaCfg.destAddr = (uint32_t)dest;
	dmaCfg.blockTS = 4;
	dmaCfg.ttfc = DMA_TT_FC_0_M2M_DMAC;
	dmaCfg.srcBtl = DMA_BTL_1;
	dmaCfg.destBtl = DMA_BTL_1;
	dmaCfg.srcAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.destAddrDirect = DMA_ADDR_INCRE;
	dmaCfg.srcTrWidthBytes = DMA_TR_WIDTH_BYTE_1;
	dmaCfg.destTrWidthBytes= DMA_TR_WIDTH_BYTE_1;
	DMA_configChannel(dma_ch_base, &dmaCfg);

	DMA_clearInterrupt(dma_ch_base, DMA_INT_TFR);
	DMA_unMaskInterrupt(dma_ch_base, DMA_INT_TFR);

	/* DMA channel enable */
	DMA_startChannel(dma_ch_base);

	while((DMA_getInterruptStatus(dma_ch_base) & DMA_INT_TFR) == 0);

	for (uint32_t i = 0; i < 4; i++) {
		if (((uint8_t *)src)[i] != ((uint8_t *)dest)[i])
			return STL_ERR_CHECK_FAILED;
	}

	return STL_SUCCESS;
}
