/*
 *   Copyright (c) GeJian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#include <stdint.h>

#include "stl_program_counter.h"
#include "stl_err.h"
#include "nmsis_bench.h"

int math_add_test(uint32_t *flag)
{
	uint32_t count = 0;

	count++;

	if (count != 0)
		*flag = STL_SUCCESS;

	return STL_SUCCESS;
}

/**
 * @brief Verify if the Program counter is vaild.
 * 
 * @return stl_err_t If the flag is non-zero, the function will return STL_ERR_CHECK_FAILED.
 * Otherwise, return success.
 */
stl_err_t stl_program_counter_test(void)
{
	int ret;
	uint32_t flag = STL_ERR_CHECK_FAILED;

	math_add_test(&flag);

	if (flag == STL_ERR_CHECK_FAILED)
		return STL_ERR_CHECK_FAILED;

	return STL_SUCCESS;
}
