/**************************************************************************//**
 * @file     os_systick.c
 * @brief    CMSIS OS Tick SysTick implementation
 * @version  V1.0.1
 * @date     29. November 2017
 ******************************************************************************/
/*
 * Copyright (c) 2017-2017 Arm Limited. All rights reserved.
 *
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the License); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __OS_TICK_H__
#define __OS_TICK_H__

// Setup OS Tick.
int32_t OS_Tick_Setup (uint32_t freq, void *handler);

// Get OS Tick interval.
uint32_t OS_Tick_GetInterval (void);

// Get OS Tick count value.
uint32_t OS_Tick_GetCount (void);

// Get OS Tick overflow status.
uint32_t OS_Tick_GetOverflow (void);

#endif
