/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    dlog.h
*   @brief   
*
*/

#ifndef COMMON_DLOG_H_
#define COMMON_DLOG_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define DLOG_ENABLE         1
#define DLOG_U32_SIZE0      512U
#define DLOG_U32_SIZE2      512U
#define DLOG_U16_SIZE0      512U
#define DLOG_U16_SIZE2      512U
#define DLOG_F32_SIZE0      128U
#define DLOG_F32_SIZE2      128U

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

//*********** DLOG Structure Definition: log 2 channel float32 data ********//
typedef struct{
	float32_t *input_ptr1;
	float32_t *input_ptr2;
	float32_t *output_ptr1;
	float32_t *output_ptr2;
	float32_t prev_value;
	float32_t trig_value;
	int16_t status;
	int16_t pre_scalar;
	int16_t skip_count;
	int16_t size;
	int16_t count;
}DLOG_2CH_F;

typedef struct{
	uint32_t *input_ptr1;
	uint32_t *input_ptr2;
	uint32_t *output_ptr1;
	uint32_t *output_ptr2;
	uint32_t prev_value;
	uint32_t trig_value;
	int16_t status;
	int16_t pre_scalar;
	int16_t skip_count;
	int16_t size;
	int16_t count;
}DLOG_2CH_U32;

typedef struct{
	uint16_t *input_ptr1;
	uint16_t *input_ptr2;
	uint16_t *output_ptr1;
	uint16_t *output_ptr2;
	uint16_t prev_value;
	uint16_t trig_value;
	int16_t status;
	int16_t pre_scalar;
	int16_t skip_count;
	int16_t size;
	int16_t count;
}DLOG_2CH_U16;


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

void dlog_2ch_f32_start0(void);
void dlog_2ch_f32_stop0(void);
void dlog_2ch_f32_run0_once(float32_t input0, float32_t input1);
void dlog_2ch_f32_run0_cont(float32_t input0, float32_t input1);

void dlog_2ch_u32_start0(void);
void dlog_2ch_u32_stop0(void);
void dlog_2ch_u32_run0_once(uint32_t input0, uint32_t input1);
void dlog_2ch_u32_run0_cont(uint32_t input0, uint32_t input1);

void dlog_2ch_u16_start0(void);
void dlog_2ch_u16_stop0(void);
void dlog_2ch_u16_run0_once(uint16_t input0, uint16_t input1);
void dlog_2ch_u16_run0_cont(uint16_t input0, uint16_t input1);

void dlog_2ch_f32_start2(void);
void dlog_2ch_f32_stop2(void);
void dlog_2ch_f32_run2_once(float32_t input2, float32_t input3);
void dlog_2ch_f32_run2_cont(float32_t input2, float32_t input3);

void dlog_2ch_u32_start2(void);
void dlog_2ch_u32_stop2(void);
void dlog_2ch_u32_run2_once(uint32_t input2, uint32_t input3);
void dlog_2ch_u32_run2_cont(uint32_t input2, uint32_t input3);

void dlog_2ch_u16_start2(void);
void dlog_2ch_u16_stop2(void);
void dlog_2ch_u16_run2_once(uint16_t input2, uint16_t input3);
void dlog_2ch_u16_run2_cont(uint16_t input2, uint16_t input3);


void DLOG_2CH_F_start(DLOG_2CH_F *v, uint32_t nStatus);
void DLOG_2CH_F32_init(DLOG_2CH_F *v);
void DLOG_2CH_F32_FUNC(DLOG_2CH_F *v);

void DLOG_2CH_U32_start(DLOG_2CH_F *v, uint32_t nStatus);
void DLOG_2CH_U32_init(DLOG_2CH_F *v);
void DLOG_2CH_U32_FUNC(DLOG_2CH_F *v);

void DLOG_2CH_U16_start(DLOG_2CH_F *v, uint32_t nStatus);
void DLOG_2CH_U16_init(DLOG_2CH_F *v);
void DLOG_2CH_U16_FUNC(DLOG_2CH_F *v);

#ifdef __cplusplus
}
#endif


#endif /* COMMON_DLOG_H_ */
