#include "dac.h"

/*
 * DAC_setPhaseDelay()
 */

GS32_DRIVER_INIT_FUNC_T void DAC_setPhaseDelay(uint32_t base, uint16_t delay)
{
    //ASSERT(DAC_isBaseValid(base));
    //ASSERT(delay <= DAC_PHASE_DELAY_M);

    HWREG(base + DAC_O_ANACLKCFG) = (HWREG(base + DAC_O_ANACLKCFG) &
    								(~DAC_ANACLKCDG_PHASE_DELAY_M))|
									(delay << DAC_ANACLKCDG_PHASE_DELAY_S);
}
