/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    device_support_gs32f00xx.h
*   @brief
*
*   commit history
*   2024/03/07, Xu Haoze, add bit field registers of CRC.
*   2024/03/12, Zhao Lei, Modify peripheral instances control.
*
*/

#ifndef DEVICE_SUPPORT_GS32F00xx_H_
#define DEVICE_SUPPORT_GS32F00xx_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
//#include "regs/regs_version.h"
#include "gs32_version.h"
#include "regs/regs_adc.h"
#include "regs/regs_cmpss.h"

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
#include "regs/regs_epwm.h"
#elif IS_GS32F00xx(0x30)
#include "regs/regs_epwm.h"
#endif

#include "regs/regs_ecap.h"
#include "regs/regs_eqep.h"
#include "regs/regs_xbar.h"
#include "regs/regs_epwmxbar.h"
#include "regs/regs_outputxbar.h"
#include "regs/regs_clboutputxbar.h"
#include "regs/regs_clbxbar.h"
#include "regs/regs_input_xbar.h"
#include "regs/regs_sci.h"
#include "regs/regs_ptr.h"
#include "regs/regs_epg.h"
#include "regs/regs_sdfm.h"
#include "regs/regs_crc.h"
#include "regs/regs_dac.h"
#include "regs/regs_cputimer.h"
#include "regs/regs_wd.h"
#include "regs/regs_ana_sysctrl_para.h"
#include "regs/regs_ahb_comm_para.h"
#include "regs/regs_apb_comm_para.h"
#include "regs/regs_can.h"
#include "regs/regs_dma.h"
#include "regs/regs_eflash.h"
#include "regs/regs_sci.h"
#include "regs/regs_i2c.h"
#include "regs/regs_i2c_v30.h"
#include "regs/regs_spi.h"
#include "regs/regs_gpio.h"
#include "regs/regs_lin.h"
#include "regs/regs_mcan.h"
//#include "regs/regs_qspi.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

extern volatile struct ADC_REGS AdcaRegs;
extern volatile struct ADC_REGS AdcbRegs;
extern volatile struct ADC_REGS AdccRegs;
extern volatile struct ADC_REGS AdcdRegs;
extern volatile struct ADC_RESULT_REGS AdcaResultRegs;
extern volatile struct ADC_RESULT_REGS AdcbResultRegs;
extern volatile struct ADC_RESULT_REGS AdccResultRegs;
extern volatile struct ADC_RESULT_REGS AdcdResultRegs;

extern volatile struct CMPSS_REGS Cmpss1Regs;
extern volatile struct CMPSS_REGS Cmpss2Regs;
extern volatile struct CMPSS_REGS Cmpss3Regs;
extern volatile struct CMPSS_REGS Cmpss4Regs;
#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
extern volatile struct CMPSS_REGS Cmpss5Regs;
extern volatile struct CMPSS_REGS Cmpss6Regs;
extern volatile struct CMPSS_REGS Cmpss7Regs;
extern volatile struct CMPSS_REGS Cmpss8Regs;
extern volatile struct CMPSS_REGS Cmpss9Regs;
extern volatile struct CMPSS_REGS Cmpss10Regs;
extern volatile struct CMPSS_REGS Cmpss11Regs;
extern volatile struct CMPSS_REGS Cmpss12Regs;
#endif
extern volatile struct EPWM_REGS EPwm1Regs;
extern volatile struct EPWM_REGS EPwm2Regs;
extern volatile struct EPWM_REGS EPwm3Regs;
extern volatile struct EPWM_REGS EPwm4Regs;
extern volatile struct EPWM_REGS EPwm5Regs;
extern volatile struct EPWM_REGS EPwm6Regs;
extern volatile struct EPWM_REGS EPwm7Regs;
extern volatile struct EPWM_REGS EPwm8Regs;
extern volatile struct EPWM_REGS EPwm9Regs;
extern volatile struct EPWM_REGS EPwm10Regs;
extern volatile struct EPWM_REGS EPwm11Regs;
extern volatile struct EPWM_REGS EPwm12Regs;
extern volatile struct EPWM_REGS EPwm13Regs;
extern volatile struct EPWM_REGS EPwm14Regs;
extern volatile struct EPWM_REGS EPwm15Regs;
extern volatile struct EPWM_REGS EPwm16Regs;
extern volatile struct EPWM_TOP_REGS EPwmTopRegs;

extern volatile struct EPWM_EXTEND_REGS EPwm1ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm2ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm3ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm4ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm5ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm6ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm7ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm8ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm9ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm10ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm11ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm12ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm13ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm14ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm15ExtRegs;
extern volatile struct EPWM_EXTEND_REGS EPwm16ExtRegs;

extern volatile struct EQEP_REGS EQep1Regs;
extern volatile struct EQEP_REGS EQep2Regs;
extern volatile struct EQEP_REGS EQep3Regs;

extern volatile struct ECAP_REGS ECap1Regs;
extern volatile struct ECAP_REGS ECap2Regs;
extern volatile struct ECAP_REGS ECap3Regs;
extern volatile struct ECAP_REGS ECap4Regs;
extern volatile struct ECAP_REGS ECap5Regs;
extern volatile struct ECAP_REGS ECap6Regs;
extern volatile struct ECAP_REGS ECap7Regs;

extern volatile struct INPUT_XBAR_REGS InputXbarRegs;
extern volatile struct INPUT_XBAR_REGS ClbInputXbarRegs;
extern volatile struct OUTPUT_XBAR_REGS OutputXbarRegs;
extern volatile struct CLB_OUTPUTXBAR_REGS ClbOutputXbarRegs;
extern volatile struct XBAR_REGS XbarRegs;
extern volatile struct EPWM_XBAR_REGS EPwmXbarRegs;
extern volatile struct CLB_XBAR_REGS ClbXbarRegs;

extern volatile struct DAC_REGS DacaRegs;
extern volatile struct DAC_REGS DacbRegs;

extern volatile struct SDFM_REGS Sdfm1Regs;
extern volatile struct SDFM_REGS Sdfm2Regs;

extern volatile struct CPUTIMER_REGS CpuTimer0Regs;
extern volatile struct CPUTIMER_REGS CpuTimer1Regs;
extern volatile struct CPUTIMER_REGS CpuTimer2Regs;
extern volatile struct CPUTIMER_REGS CpuTimer3Regs;

extern volatile struct WD_REGS Wd0Regs;
extern volatile struct WD_REGS Wd1Regs;

extern volatile struct ANALOG_SUBSYS_REGS AnalogSubsysRegs;
extern volatile struct SYSCTL_DIG_REGS SysctlDigRegs;
extern volatile struct SYSCTL_APB_REGS SysctlApbRegs;
extern volatile struct SYSCTL_AHB_REGS SysctlAhbRegs;

extern volatile struct GPIO_REGS GpioPortaRegs;
extern volatile struct GPIO_REGS GpioPortbRegs;
extern volatile struct GPIO_REGS GpioPortcRegs;
extern volatile struct GPIO_REGS GpioPortdRegs;
extern volatile struct GPIO_REGS GpioPorteRegs;
extern volatile struct GPIO_REGS GpioPortfRegs;
extern volatile struct GPIO_REGS GpioPortgRegs;
extern volatile struct GPIO_CTRL_REGS GpioCtrlRegs;
extern volatile struct GPIO_DATA_REGS GpioDataRegs;
extern volatile struct GPIO_DATA_READ_REGS GpioDataReadRegs;
extern volatile struct GPIO_INT_REGS GpioIntRegs;
extern volatile struct IO_CFG_PARA_REGS IoCfgPapaRegs;

extern volatile struct DMA_CH_REGS DmaCh0Regs;
extern volatile struct DMA_CH_REGS DmaCh1Regs;
extern volatile struct DMA_CH_REGS DmaCh2Regs;
extern volatile struct DMA_CH_REGS DmaCh3Regs;
extern volatile struct DMA_CH_REGS DmaCh4Regs;
extern volatile struct DMA_CH_REGS DmaCh5Regs;
extern volatile struct DMA_CH_REGS DmaCh6Regs;
extern volatile struct DMA_CH_REGS DmaCh7Regs;


#if 0
/* xBAR */
#define XbarRegs (*(volatile struct XBAR_REGS *)XBAR_BASE)
#define InputXbarRegs (*(volatile struct INPUT_XBAR_REGS *)INPUTXBAR_BASE)
#define OutputXbarRegs (*(volatile struct OUTPUT_XBAR_REGS *)OUTPUTXBAR_BASE)
#define ClbOutputXbarRegs (*(volatile struct OUTPUT_XBAR_REGS *)CLBOUTPUTXBAR_BASE)
#define EPwmXbarRegs (*(volatile struct EPWM_XBAR_REGS *)EPWMXBAR_BASE)
#define ClbXbarRegs (*(volatile struct CLB_XBAR_REGS *)CLBXBAR_BASE)
#define ClbInputXbarRegs (*(volatile struct INPUT_XBAR_REGS *)CLBINPUTXBAR_BASE)


/* SCI */
#define SciaRegs (*(volatile struct SCI_REGS *) SCIA_BASE)
#define ScibRegs (*(volatile struct SCI_REGS *) SCIB_BASE)
#define ScicRegs (*(volatile struct SCI_REGS *) SCIC_BASE)

/* SDFM */
#if defined(SDFM1_BASE)
#define Sdfm1Regs		(* (volatile struct SDFM_REGS *) SDFM1_BASE)
#endif

#if defined(SDFM2_BASE)
#define Sdfm2Regs		(* (volatile struct SDFM_REGS *) SDFM2_BASE)
#endif

#if defined(SDFM3_BASE)
#define Sdfm2Regs       (* (volatile struct SDFM_REGS *) SDFM2_BASE)
#endif

#if defined(SDFM4_BASE)
#define Sdfm2Regs       (* (volatile struct SDFM_REGS *) SDFM2_BASE)
#endif

#if defined(CRC_BASE)
#define CRCRegs         (* (volatile struct CRC_REGS *) CRC_BASE)
#endif

#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */



#ifdef __cplusplus
}
#endif


#endif /* DEVICE_SUPPORT_GS32F00xx_H_ */
