/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    gcc_gs32f00xx_regs.ld
*   @brief   
*   @details
*
*/

/*
 * commit history
 * 20240704, Hezhiyuan, initial release
 */
/********************  EPWM registers *********************/
__EPWM1_REGS_BASE = 0x40008800;
__EPWM2_REGS_BASE = 0x40009000;
__EPWM3_REGS_BASE = 0x40009800;
__EPWM4_REGS_BASE = 0x4000A000;
__EPWM5_REGS_BASE = 0x4000A800;
__EPWM6_REGS_BASE = 0x4000B000;
__EPWM7_REGS_BASE = 0x4000B800;
__EPWM8_REGS_BASE = 0x4000C000;
__EPWM9_REGS_BASE = 0x4000C800;
__EPWM10_REGS_BASE = 0x4000D000;
__EPWM11_REGS_BASE = 0x4000D800;
__EPWM12_REGS_BASE = 0x4000E000;
__EPWM_REGS_SIZE = 0x00000800;

__EPWM1_EXTEND_REGS_BASE = 0x40008BFC;
__EPWM2_EXTEND_REGS_BASE = 0x400093FC;
__EPWM3_EXTEND_REGS_BASE = 0x40008BFC;
__EPWM4_EXTEND_REGS_BASE = 0x4000A3FC;
__EPWM5_EXTEND_REGS_BASE = 0x4000ABFC;
__EPWM6_EXTEND_REGS_BASE = 0x4000B3FC;
__EPWM7_EXTEND_REGS_BASE = 0x4000BBFC;
__EPWM8_EXTEND_REGS_BASE = 0x4000C3FC;
__EPWM9_EXTEND_REGS_BASE = 0x4000CBFC;
__EPWM10_EXTEND_REGS_BASE = 0x4000D3FC;
__EPWM11_EXTEND_REGS_BASE = 0x4000DBFC;
__EPWM12_EXTEND_REGS_BASE = 0x4000E3FC;
__EPWM_EXTEND_REGS_SIZE = 0x00000300;

__EPWMTOP_REGS_BASE = 0x40008000;
__EPWMTOP_REGS_SIZE = 0x00000400;
    

/********************  ADC registers *********************/
__ADCA_REGS_BASE = 0x40000000;
__ADCB_REGS_BASE = 0x40000800;
__ADCC_REGS_BASE = 0x40001000;
__ADC_REGS_SIZE = 0x00000800;

/********************  ADC result registers *********************/
__ADCARESULT_REGS_BASE = 0x40000400;
__ADCBRESULT_REGS_BASE = 0x40000C00;
__ADCCRESULT_REGS_BASE = 0x40001400;
__ADCRESULT_REGS_SIZE = 0x00000800;

/********************  CMPSS registers *********************/
__CMPSS1_REGS_BASE = 0x40040000;
__CMPSS2_REGS_BASE = 0x40040200;
__CMPSS3_REGS_BASE = 0x40040400;
__CMPSS4_REGS_BASE = 0x40040600;
__CMPSS5_REGS_BASE = 0x40040800;
__CMPSS6_REGS_BASE = 0x40040A00;
__CMPSS7_REGS_BASE = 0x40040C00;
__CMPSS_REGS_SIZE = 0x00000200;

/********************  ECAP registers *********************/
__ECAP1_REGS_BASE = 0x40028000;
__ECAP2_REGS_BASE = 0x40028200;
__ECAP3_REGS_BASE = 0x40028400;
__ECAP4_REGS_BASE = 0x40028600;
__ECAP5_REGS_BASE = 0x40028800;
__ECAP6_REGS_BASE = 0x40028A00;
__ECAP7_REGS_BASE = 0x40028C00;
__ECAP_REGS_SIZE = 0x00000200;

/********************  EQEP registers *********************/
__EQEP1_REGS_BASE = 0x40030000;
__EQEP2_REGS_BASE = 0x40030200;
__EQEP_REGS_SIZE = 0x00000200;

/********************  DAC registers *********************/
__DACA_REGS_BASE = 0x40080000;
__DACB_REGS_BASE = 0x40080200;
__DAC_REGS_SIZE = 0x00000200;

/********************  SDFM registers *********************/
__SDFM1_REGS_BASE = 0x40043000;
__SDFM2_REGS_BASE = 0x40043200;
__SDFM_REGS_SIZE = 0x00000200;

/********************  EPG registers *********************/
__EPG_REGS_BASE = 0x40086000;
__EPG_REGS_SIZE = 0x00000200;

/********************  CPUTimer registers *********************/
__CPUTIME0_REGS_BASE = 0x400C8000;
__CPUTIME1_REGS_BASE = 0x400C8020;
__CPUTIME2_REGS_BASE = 0x400C9000;
__CPUTIME3_REGS_BASE = 0x400C9020;
__CPUTIME_REGS_SIZE = 0x00000020;

  /***************** XBAR - XBAR instance base addresses ***************/
__INPUTXBAR_REGS_BASE    = 0x4006D000;
__INPUTXBAR_REGS_SIZE    = 0X00000040;

__XBAR_REGS_BASE         = 0x4006D040;
__XBAR_REGS_SIZE         = 0x00000080;

__CLBINPUTXBAR_REGS_BASE = 0x4006D0C0;
__CLBINPUTXBAR_REGS_SIZE = 0X00000040;

__EPWMXBAR_REGS_BASE = 0x4006D100;
__EPWMXBAR_REGS_SIZE = 0x00000300;

__CLBXBAR_REGS_BASE = 0x4006D400;
__CLBXBAR_REGS_SIZE = 0x00000300;

__OUTPUTXBAR1_REGS_BASE = 0x4006D700;
__OUTPUTXBAR2_REGS_BASE = 0x4006D800;
__OUTPUTXBAR_REGS_SIZE = 0x00000100;

__CLBOUTPUTXBAR1_REGS_BASE = 0x4006D900;
__CLBOUTPUTXBAR2_REGS_BASE = 0x4006DA00;
__CLBOUTPUTXBAR_REGS_SIZE = 0x00000100;

  /********************  GPIO data registers *********************/
__GPIOA_REGS_BASE = 0x40045000;
__GPIOB_REGS_BASE = 0x40046000;
__GPIOC_REGS_BASE = 0x40047000;
__GPIOD_REGS_BASE = 0x40048000;
__GPIOE_REGS_BASE = 0x40049000;
__GPIOF_REGS_BASE = 0x4004A000;
__GPIOG_REGS_BASE = 0x4004B000;
__GPIO_REGS_SIZE = 0X00001000;

  /***************** Watchdog ***************/
 __WD1_REGS_BASE =  0x400D1000;
 __WD_REGS_SIZE = 0X00001000;

 /********************  SysCtl *********************/
 __AHB1COMMPAPA_REGS_BASE = 0x4003F000;
 __AHB1COMMPAPA_REGS_SIZE = 0x00001000;

__ANACFG_REGS_BASE = 0x400CD000;
__ANACFG_REGS_SIZE = 0x00001000;

__APBCOMMPARA_REGS_BASE = 0x400C0000;
__APBCOMMPARA_REGS_SIZE = 0X00001000;

__CRGCFGPAPA_REGS_BASE = 0x400CE000;
__CRGCFGPAPA_REGS_SIZE = 0x00001000;

__IO_CFG_REGS_BASE = 0x400CC000;
__IO_CFG_REGS_SIZE = 0x00001000;

__SUBCRG_REGS_BASE = 0x400C6000;
__SUBCRG_REGS_SIZE = 0x00001000;

__SYSCTL_REGS_BASE = 0x400CF000;
__SYSCTL_REGS_SIZE = 0x00001000;

 /********************  DMA *********************/
__DMA1_CH1_REGS_BASE = 0x40082000;
__DMA1_CH2_REGS_BASE = 0x40082058;
__DMA1_CH3_REGS_BASE = 0x400820B0;
__DMA1_CH4_REGS_BASE = 0x40082108;
__DMA1_CH5_REGS_BASE = 0x40082160;
__DMA1_CH6_REGS_BASE = 0x400821B8;
__DMA1_CH7_REGS_BASE = 0x40082210;
__DMA1_CH8_REGS_BASE = 0x40082268;

__DMA2_CH1_REGS_BASE = 0x400FC000;
__DMA2_CH2_REGS_BASE = 0x400FC058;
__DMA2_CH3_REGS_BASE = 0x400FC0B0;
__DMA2_CH4_REGS_BASE = 0x400FC108;
__DMA2_CH5_REGS_BASE = 0x400FC160;
__DMA2_CH6_REGS_BASE = 0x400FC1B8;
__DMA2_CH7_REGS_BASE = 0x400FC210;
__DMA2_CH8_REGS_BASE = 0x400FC268;

__DMA_CH_REGS_SIZE = 0x00000058;
__DMA_MUX_REGS_BASE = 0x40085000;
__DMA_MUX_REGS_SIZE = 0x00001000;

 /********************  eFlash *********************/
 __FLASH_ICACHE_REGS_BASE = 0x50000000;
__FLASH_DCACHE_REGS_BASE = 0x50001000;
__FLASH_EFC_REGS_BASE    = 0x50002000;
__FLASH_EFC2_REGS_BASE   = 0x50003000;
__FLASH_INTERFACE_REGS_SIZE = 0x00001000;

/********************  CRC registers *********************/
__CRC_REGS_BASE = 0x40088000;
__CRC_REGS_SIZE = 0x00000200;

/********************  SCI registers *********************/
__SCIA_REGS_BASE = 0x400C1000;
__SCIB_REGS_BASE = 0x400C1200;
__SCI_REGS_SIZE  = 0x00000200;

/********************  SPI registers *********************/
__SPIA_REGS_BASE = 0x400C3000;
__SPIB_REGS_BASE = 0x400C3200;
__SPI_REGS_SIZE  = 0x00000200;

/********************  I2C registers *********************/
__I2CA_REGS_BASE = 0x400C2000;
__I2CB_REGS_BASE = 0x400C2200;
__I2CC_REGS_BASE = 0x400C2400;
__I2C_REGS_SIZE  = 0x00000200;

/********************  CAN registers *********************/
__CANA_REGS_BASE = 0x400C4000;
__CANB_REGS_BASE = 0x400C4200;
__CAN_REGS_SIZE  = 0x00000200;

/********************  LIN registers *********************/
__LINA_REGS_BASE = 0x400C5000;
__LINB_REGS_BASE = 0x400C5200;
__LIN_REGS_SIZE  = 0x00000200;

/********************  QSPI registers *********************/
__QSPI_REGS_BASE = 0xA0001000;
__QSPI_REGS_SIZE  = 0x00000400;


MEMORY
{  

  MEM_CMPSS1_REGS (rw) : ORIGIN = __CMPSS1_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS2_REGS (rw) : ORIGIN = __CMPSS2_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS3_REGS (rw) : ORIGIN = __CMPSS3_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS4_REGS (rw) : ORIGIN = __CMPSS4_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS5_REGS (rw) : ORIGIN = __CMPSS5_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS6_REGS (rw) : ORIGIN = __CMPSS6_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE
  MEM_CMPSS7_REGS (rw) : ORIGIN = __CMPSS7_REGS_BASE, LENGTH = __CMPSS_REGS_SIZE

  MEM_EPWM1_REGS (rw) : ORIGIN = __EPWM1_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM2_REGS (rw) : ORIGIN = __EPWM2_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM3_REGS (rw) : ORIGIN = __EPWM3_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM4_REGS (rw) : ORIGIN = __EPWM4_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM5_REGS (rw) : ORIGIN = __EPWM5_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM6_REGS (rw) : ORIGIN = __EPWM6_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM7_REGS (rw) : ORIGIN = __EPWM7_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM8_REGS (rw) : ORIGIN = __EPWM8_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM9_REGS (rw) : ORIGIN = __EPWM9_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM10_REGS (rw) : ORIGIN = __EPWM10_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM11_REGS (rw) : ORIGIN = __EPWM11_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWM12_REGS (rw) : ORIGIN = __EPWM12_REGS_BASE, LENGTH = __EPWM_REGS_SIZE
  MEM_EPWMTOP_REGS (rw) : ORIGIN = __EPWMTOP_REGS_BASE, LENGTH = __EPWMTOP_REGS_SIZE
  
  MEM_EPWM1_EXTEND_REGS (rw) : ORIGIN = __EPWM1_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM2_EXTEND_REGS (rw) : ORIGIN = __EPWM2_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM3_EXTEND_REGS (rw) : ORIGIN = __EPWM3_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM4_EXTEND_REGS (rw) : ORIGIN = __EPWM4_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM5_EXTEND_REGS (rw) : ORIGIN = __EPWM5_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM6_EXTEND_REGS (rw) : ORIGIN = __EPWM6_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM7_EXTEND_REGS (rw) : ORIGIN = __EPWM7_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM8_EXTEND_REGS (rw) : ORIGIN = __EPWM8_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM9_EXTEND_REGS (rw) : ORIGIN = __EPWM9_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM10_EXTEND_REGS (rw) : ORIGIN = __EPWM10_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM11_EXTEND_REGS (rw) : ORIGIN = __EPWM11_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE
  MEM_EPWM12_EXTEND_REGS (rw) : ORIGIN = __EPWM12_EXTEND_REGS_BASE, LENGTH = __EPWM_EXTEND_REGS_SIZE

  
  MEM_ADCA_REGS (rw) : ORIGIN = __ADCA_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  MEM_ADCB_REGS (rw) : ORIGIN = __ADCB_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  MEM_ADCC_REGS (rw) : ORIGIN = __ADCC_REGS_BASE, LENGTH = __ADC_REGS_SIZE
  
  MEM_ADCARESULT_REGS (rw) : ORIGIN = __ADCARESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  MEM_ADCBRESULT_REGS (rw) : ORIGIN = __ADCBRESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  MEM_ADCCRESULT_REGS (rw) : ORIGIN = __ADCCRESULT_REGS_BASE, LENGTH = __ADCRESULT_REGS_SIZE
  
  MEM_ECAP1_REGS (rw) : ORIGIN = __ECAP1_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP2_REGS (rw) : ORIGIN = __ECAP2_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP3_REGS (rw) : ORIGIN = __ECAP3_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP4_REGS (rw) : ORIGIN = __ECAP4_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP5_REGS (rw) : ORIGIN = __ECAP5_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP6_REGS (rw) : ORIGIN = __ECAP6_REGS_BASE, LENGTH = __ECAP_REGS_SIZE
  MEM_ECAP7_REGS (rw) : ORIGIN = __ECAP7_REGS_BASE, LENGTH = __ECAP_REGS_SIZE

  MEM_EQEP1_REGS (rw) : ORIGIN = __EQEP1_REGS_BASE, LENGTH = __EQEP_REGS_SIZE
  MEM_EQEP2_REGS (rw) : ORIGIN = __EQEP2_REGS_BASE, LENGTH = __EQEP_REGS_SIZE

  MEM_DACA_REGS (rw) : ORIGIN = __DACA_REGS_BASE, LENGTH = __DAC_REGS_SIZE
  MEM_DACB_REGS (rw) : ORIGIN = __DACB_REGS_BASE, LENGTH = __DAC_REGS_SIZE

  MEM_SDFM1_REGS (rw) : ORIGIN = __SDFM1_REGS_BASE, LENGTH = __SDFM_REGS_SIZE
  MEM_SDFM2_REGS (rw) : ORIGIN = __SDFM2_REGS_BASE, LENGTH = __SDFM_REGS_SIZE
  
  MEM_EPG_REGS (rw) : ORIGIN = __EPG_REGS_BASE, LENGTH = __EPG_REGS_SIZE

  MEM_CPUTIME0_REGS (rw) : ORIGIN = __CPUTIME0_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME1_REGS (rw) : ORIGIN = __CPUTIME1_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME2_REGS (rw) : ORIGIN = __CPUTIME2_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE
  MEM_CPUTIME3_REGS (rw) : ORIGIN = __CPUTIME3_REGS_BASE, LENGTH = __CPUTIME_REGS_SIZE

  MEM_INPUTXBAR_REGS (rw) : ORIGIN = __INPUTXBAR_REGS_BASE, LENGTH = __INPUTXBAR_REGS_SIZE
  MEM_XBAR_REGS (rw) : ORIGIN = __XBAR_REGS_BASE, LENGTH = __XBAR_REGS_SIZE
  MEM_CLBINPUTXBAR_REGS (rw) : ORIGIN = __CLBINPUTXBAR_REGS_BASE, LENGTH = __CLBINPUTXBAR_REGS_SIZE
  MEM_EPWMXBAR_REGS (rw) : ORIGIN = __EPWMXBAR_REGS_BASE, LENGTH = __EPWMXBAR_REGS_SIZE
  MEM_CLBXBAR_REGS (rw) : ORIGIN = __CLBXBAR_REGS_BASE, LENGTH = __CLBXBAR_REGS_SIZE
  MEM_OUTPUTXBAR1_REGS (rw) : ORIGIN = __OUTPUTXBAR1_REGS_BASE, LENGTH = __OUTPUTXBAR_REGS_SIZE
  MEM_OUTPUTXBAR2_REGS (rw) : ORIGIN = __OUTPUTXBAR2_REGS_BASE, LENGTH = __OUTPUTXBAR_REGS_SIZE
  MEM_CLBOUTPUTXBAR1_REGS (rw) : ORIGIN = __CLBOUTPUTXBAR1_REGS_BASE, LENGTH = __CLBOUTPUTXBAR_REGS_SIZE
  MEM_CLBOUTPUTXBAR2_REGS (rw) : ORIGIN = __CLBOUTPUTXBAR2_REGS_BASE, LENGTH = __CLBOUTPUTXBAR_REGS_SIZE

  MEM_GPIOA_REGS (rw) : ORIGIN = __GPIOA_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOB_REGS (rw) : ORIGIN = __GPIOB_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOC_REGS (rw) : ORIGIN = __GPIOC_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOD_REGS (rw) : ORIGIN = __GPIOD_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOE_REGS (rw) : ORIGIN = __GPIOE_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOF_REGS (rw) : ORIGIN = __GPIOF_REGS_BASE, LENGTH = __GPIO_REGS_SIZE
  MEM_GPIOG_REGS (rw) : ORIGIN = __GPIOG_REGS_BASE, LENGTH = __GPIO_REGS_SIZE

  MEM_WD1_REGS (rw) : ORIGIN = __WD1_REGS_BASE, LENGTH = __WD_REGS_SIZE

  MEM_AHB1COMMPAPA_REGS (rw) :  ORIGIN = __AHB1COMMPAPA_REGS_BASE, LENGTH = __AHB1COMMPAPA_REGS_SIZE
  MEM_ANACFG_REGS (rw) :        ORIGIN = __ANACFG_REGS_BASE, LENGTH = __ANACFG_REGS_SIZE
  MEM_APBCOMMPARA_REGS (rw) :   ORIGIN = __APBCOMMPARA_REGS_BASE, LENGTH = __APBCOMMPARA_REGS_SIZE
  MEM_CRGCFGPAPA_REGS (rw) :    ORIGIN = __CRGCFGPAPA_REGS_BASE, LENGTH = __CRGCFGPAPA_REGS_SIZE
  MEM_IO_CFG_REGS (rw) :     ORIGIN = __IO_CFG_REGS_BASE, LENGTH = __IO_CFG_REGS_SIZE
  MEM_SUBCRG_REGS (rw) :        ORIGIN = __SUBCRG_REGS_BASE, LENGTH = __SUBCRG_REGS_SIZE
  MEM_SYSCTL_REGS (rw) :        ORIGIN = __SYSCTL_REGS_BASE, LENGTH = __SYSCTL_REGS_SIZE

  MEM_DMA1_CH1_REGS (rw) : ORIGIN = __DMA1_CH1_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH2_REGS (rw) : ORIGIN = __DMA1_CH2_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH3_REGS (rw) : ORIGIN = __DMA1_CH3_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH4_REGS (rw) : ORIGIN = __DMA1_CH4_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH5_REGS (rw) : ORIGIN = __DMA1_CH5_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH6_REGS (rw) : ORIGIN = __DMA1_CH6_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH7_REGS (rw) : ORIGIN = __DMA1_CH7_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA1_CH8_REGS (rw) : ORIGIN = __DMA1_CH8_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE

  MEM_DMA2_CH1_REGS (rw) : ORIGIN = __DMA2_CH1_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH2_REGS (rw) : ORIGIN = __DMA2_CH2_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH3_REGS (rw) : ORIGIN = __DMA2_CH3_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH4_REGS (rw) : ORIGIN = __DMA2_CH4_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH5_REGS (rw) : ORIGIN = __DMA2_CH5_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH6_REGS (rw) : ORIGIN = __DMA2_CH6_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH7_REGS (rw) : ORIGIN = __DMA2_CH7_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  MEM_DMA2_CH8_REGS (rw) : ORIGIN = __DMA2_CH8_REGS_BASE, LENGTH = __DMA_CH_REGS_SIZE
  
  MEM_DMA_MUX_REGS (rw) : ORIGIN = __DMA_MUX_REGS_BASE, LENGTH = __DMA_MUX_REGS_SIZE

  MEM_FLASH_ICACHE_REGS (rw) : ORIGIN = __FLASH_ICACHE_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE
  MEM_FLASH_DCACHE_REGS (rw) : ORIGIN = __FLASH_DCACHE_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE
  MEM_FLASH_EFC_REGS (rw) : ORIGIN = __FLASH_EFC_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE
  MEM_FLASH_EFC2_REGS (rw) : ORIGIN = __FLASH_EFC2_REGS_BASE, LENGTH = __FLASH_INTERFACE_REGS_SIZE

  MEM_CRC_REGS (rw) : ORIGIN = __CRC_REGS_BASE, LENGTH = __CRC_REGS_SIZE

  MEM_SCIA_REGS (rw) : ORIGIN = __SCIA_REGS_BASE, LENGTH = __SCI_REGS_SIZE
  MEM_SCIB_REGS (rw) : ORIGIN = __SCIB_REGS_BASE, LENGTH = __SCI_REGS_SIZE

  MEM_SPIA_REGS (rw) : ORIGIN = __SPIA_REGS_BASE, LENGTH = __SPI_REGS_SIZE
  MEM_SPIB_REGS (rw) : ORIGIN = __SPIB_REGS_BASE, LENGTH = __SPI_REGS_SIZE

  MEM_I2CA_REGS (rw) : ORIGIN = __I2CA_REGS_BASE, LENGTH = __I2C_REGS_SIZE
  MEM_I2CB_REGS (rw) : ORIGIN = __I2CB_REGS_BASE, LENGTH = __I2C_REGS_SIZE
  MEM_I2CC_REGS (rw) : ORIGIN = __I2CC_REGS_BASE, LENGTH = __I2C_REGS_SIZE

  MEM_CANA_REGS (rw) : ORIGIN = __CANA_REGS_BASE, LENGTH = __CAN_REGS_SIZE
  MEM_CANB_REGS (rw) : ORIGIN = __CANB_REGS_BASE, LENGTH = __CAN_REGS_SIZE

  MEM_LINA_REGS (rw) : ORIGIN = __LINA_REGS_BASE, LENGTH = __LIN_REGS_SIZE
  MEM_LINB_REGS (rw) : ORIGIN = __LINB_REGS_BASE, LENGTH = __LIN_REGS_SIZE

  MEM_QSPI_REGS (rw) : ORIGIN = __QSPI_REGS_BASE, LENGTH = __QSPI_REGS_SIZE

}

SECTIONS
{
  /*******************************************************************************/
  /**************** Start of Peripherals Registers sections define ***************/
  /*******************************************************************************/
  
  /***************** CMPSS registers sections ***************/
  .cmpss1_regs (NOLOAD):
  {
    KEEP(*(.cmpss1_regs))
    KEEP(*(.cmpss1_regs.*))
  } > MEM_CMPSS1_REGS
  
  .cmpss2_regs (NOLOAD):
  {
    KEEP(*(.cmpss2_regs))
    KEEP(*(.cmpss2_regs.*))
  } > MEM_CMPSS2_REGS
  
  .cmpss3_regs (NOLOAD):
  {
    KEEP(*(.cmpss3_regs))
    KEEP(*(.cmpss3_regs.*))
  } > MEM_CMPSS3_REGS
  
  .cmpss4_regs (NOLOAD):
  {
    KEEP(*(.cmpss4_regs))
    KEEP(*(.cmpss4_regs.*))
  } > MEM_CMPSS4_REGS
  
  .cmpss5_regs (NOLOAD):
  {
    KEEP(*(.cmpss5_regs))
    KEEP(*(.cmpss5_regs.*))
  } > MEM_CMPSS5_REGS
  
  .cmpss6_regs (NOLOAD):
  {
    KEEP(*(.cmpss6_regs))
    KEEP(*(.cmpss6_regs.*))
  } > MEM_CMPSS6_REGS
  
  .cmpss7_regs (NOLOAD):
  {
    KEEP(*(.cmpss7_regs))
    KEEP(*(.cmpss7_regs.*))
  } > MEM_CMPSS7_REGS
  

  /***************** EPWM registers sections ***************/
  .epwm1_regs (NOLOAD):
  {
    KEEP(*(.epwm1_regs))
    KEEP(*(.epwm1_regs.*))
  } > MEM_EPWM1_REGS

  .epwm2_regs (NOLOAD):
  {
    KEEP(*(.epwm2_regs))
    KEEP(*(.epwm2_regs.*))
  } > MEM_EPWM2_REGS
  
  .epwm3_regs (NOLOAD):
  {
    KEEP(*(.epwm3_regs))
    KEEP(*(.epwm3_regs.*))
  } > MEM_EPWM3_REGS
  
  .epwm4_regs (NOLOAD):
  {
    KEEP(*(.epwm4_regs))
    KEEP(*(.epwm4_regs.*))
  } > MEM_EPWM4_REGS
  
  .epwm5_regs (NOLOAD):
  {
    KEEP(*(.epwm5_regs))
    KEEP(*(.epwm5_regs.*))
  } > MEM_EPWM5_REGS
  
  .epwm6_regs (NOLOAD):
  {
    KEEP(*(.epwm6_regs))
    KEEP(*(.epwm6_regs.*))
  } > MEM_EPWM6_REGS
  
  .epwm7_regs (NOLOAD):
  {
    KEEP(*(.epwm7_regs))
    KEEP(*(.epwm7_regs.*))
  } > MEM_EPWM7_REGS
  
  .epwm8_regs (NOLOAD):
  {
    KEEP(*(.epwm8_regs))
    KEEP(*(.epwm8_regs.*))
  } > MEM_EPWM8_REGS
  
  .epwm9_regs (NOLOAD):
  {
    KEEP(*(.epwm9_regs))
    KEEP(*(.epwm9_regs.*))
  } > MEM_EPWM9_REGS
  
  .epwm10_regs (NOLOAD):
  {
    KEEP(*(.epwm10_regs))
    KEEP(*(.epwm10_regs.*))
  } > MEM_EPWM10_REGS
  
  .epwm11_regs (NOLOAD):
  {
    KEEP(*(.epwm11_regs))
    KEEP(*(.epwm11_regs.*))
  } > MEM_EPWM11_REGS
  
  .epwm12_regs (NOLOAD):
  {
    KEEP(*(.epwm12_regs))
    KEEP(*(.epwm12_regs.*))
  } > MEM_EPWM12_REGS

  .epwmtop_regs (NOLOAD):
  {
    KEEP(*(.epwmtop_regs))
    KEEP(*(.epwmtop_regs.*))
  } > MEM_EPWMTOP_REGS

  /***************** EPWM EXTEND registers sections ***************/

  .epwm1_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm1_extend_regs))
    KEEP(*(.epwm1_extend_regs.*))
  } > MEM_EPWM1_EXTEND_REGS
  
  .epwm2_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm2_extend_regs))
    KEEP(*(.epwm2_extend_regs.*))
  } > MEM_EPWM2_EXTEND_REGS

  .epwm3_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm3_extend_regs))
    KEEP(*(.epwm3_extend_regs.*))
  } > MEM_EPWM3_EXTEND_REGS
  
  .epwm4_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm4_extend_regs))
    KEEP(*(.epwm4_extend_regs.*))
  } > MEM_EPWM4_EXTEND_REGS
 
  .epwm5_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm5_extend_regs))
    KEEP(*(.epwm5_extend_regs.*))
  } > MEM_EPWM5_EXTEND_REGS
 
  .epwm6_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm6_extend_regs))
    KEEP(*(.epwm6_extend_regs.*))
  } > MEM_EPWM6_EXTEND_REGS
  
  .epwm7_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm7_extend_regs))
    KEEP(*(.epwm7_extend_regs.*))
  } > MEM_EPWM7_EXTEND_REGS
  
  .epwm8_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm8_extend_regs))
    KEEP(*(.epwm8_extend_regs.*))
  } > MEM_EPWM8_EXTEND_REGS
  
  .epwm9_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm9_extend_regs))
    KEEP(*(.epwm9_extend_regs.*))
  } > MEM_EPWM9_EXTEND_REGS
  
  .epwm10_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm10_extend_regs))
    KEEP(*(.epwm10_extend_regs.*))
  } > MEM_EPWM10_EXTEND_REGS
  
  .epwm11_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm11_extend_regs))
    KEEP(*(.epwm11_extend_regs.*))
  } > MEM_EPWM11_EXTEND_REGS
  
  .epwm12_extend_regs (NOLOAD):
  {
    KEEP(*(.epwm12_extend_regs))
    KEEP(*(.epwm12_extend_regs.*))
  } > MEM_EPWM12_EXTEND_REGS
 
  /***************** ADC registers sections ***************/
  .adca_regs (NOLOAD):
  {
    KEEP(*(.adca_regs))
    KEEP(*(.adca_regs.*))
  } > MEM_ADCA_REGS
  
  .adcb_regs (NOLOAD):
  {
    KEEP(*(.adcb_regs))
    KEEP(*(.adcb_regs.*))
  } > MEM_ADCB_REGS
  
  .adcc_regs (NOLOAD):
  {
    KEEP(*(.adcc_regs))
    KEEP(*(.adcc_regs.*))
  } > MEM_ADCC_REGS
  
  /***************** ADC result registers sections ***************/
  .adca_result_regs (NOLOAD):
  {
    KEEP(*(.adca_result_regs))
    KEEP(*(.adca_result_regs.*))
  } > MEM_ADCARESULT_REGS
  
  .adcb_result_regs (NOLOAD):
  {
    KEEP(*(.adcb_result_regs))
    KEEP(*(.adcb_result_regs.*))
  } > MEM_ADCBRESULT_REGS
  
  .adcc_result_regs (NOLOAD):
  {
    KEEP(*(.adcc_result_regs))
    KEEP(*(.adcc_result_regs.*))
  } > MEM_ADCCRESULT_REGS
  

  /***************** ECAP registers sections ***************/
  
  .ecap1_regs (NOLOAD):
  {
    KEEP(*(.ecap1_regs))
    KEEP(*(.ecap1_regs.*))
  } > MEM_ECAP1_REGS
  
  .ecap2_regs (NOLOAD):
  {
    KEEP(*(.ecap2_regs))
    KEEP(*(.ecap2_regs.*))
  } > MEM_ECAP2_REGS
  
  .ecap3_regs (NOLOAD):
  {
    KEEP(*(.ecap3_regs))
    KEEP(*(.ecap3_regs.*))
  } > MEM_ECAP3_REGS
  
  .ecap4_regs (NOLOAD):
  {
    KEEP(*(.ecap4_regs))
    KEEP(*(.ecap4_regs.*))
  } > MEM_ECAP4_REGS
  
  .ecap5_regs (NOLOAD):
  {
    KEEP(*(.ecap5_regs))
    KEEP(*(.ecap5_regs.*))
  } > MEM_ECAP5_REGS
  
  .ecap6_regs (NOLOAD):
  {
    KEEP(*(.ecap6_regs))
    KEEP(*(.ecap6_regs.*))
  } > MEM_ECAP6_REGS
  
  .ecap7_regs (NOLOAD):
  {
    KEEP(*(.ecap7_regs))
    KEEP(*(.ecap7_regs.*))
  } > MEM_ECAP7_REGS

   /***************** EQEP registers sections ***************/

  .eqep1_regs (NOLOAD):
  {
    KEEP(*(.eqep1_regs))
    KEEP(*(.eqep1_regs.*))
  } > MEM_EQEP1_REGS
  
  .eqep2_regs (NOLOAD):
  {
    KEEP(*(.eqep2_regs))
    KEEP(*(.eqep2_regs.*))
  } > MEM_EQEP2_REGS

  /***************** DAC registers sections ***************/
  .daca_regs (NOLOAD):
  {
    KEEP(*(.daca_regs))
    KEEP(*(.daca_regs.*))
  } > MEM_DACA_REGS

  .dacb_regs (NOLOAD):
  {
    KEEP(*(.dacb_regs))
    KEEP(*(.dacb_regs.*))
  } > MEM_DACB_REGS

  /***************** SDFM registers sections ***************/
  .sdfm1_regs (NOLOAD):
  {
    KEEP(*(.sdfm1_regs))
    KEEP(*(.sdfm1_regs.*))
  } > MEM_SDFM1_REGS

  .sdfm2_regs (NOLOAD):
  {
    KEEP(*(.sdfm2_regs))
    KEEP(*(.sdfm2_regs.*))
  } > MEM_SDFM2_REGS
  
  /***************** EPG registers sections ***************/
  .epg_regs (NOLOAD):
  {
    KEEP(*(.epg_regs))
    KEEP(*(.epg_regs.*))
  } > MEM_EPG_REGS

  /***************** CPUTIMER registers sections ***************/
  .cputimer0_regs (NOLOAD):
  {
    KEEP(*(.cputimer0_regs))
    KEEP(*(.cputimer0_regs.*))
  } > MEM_CPUTIME0_REGS

  .cputimer1_regs (NOLOAD):
  {
    KEEP(*(.cputimer1_regs))
    KEEP(*(.cputimer1_regs.*))
  } > MEM_CPUTIME1_REGS

  .cputimer2_regs (NOLOAD):
  {
    KEEP(*(.cputimer2_regs))
    KEEP(*(.cputimer2_regs.*))
  } > MEM_CPUTIME2_REGS

  .cputimer3_regs (NOLOAD):
  {
    KEEP(*(.cputimer3_regs))
    KEEP(*(.cputimer3_regs.*))
  } > MEM_CPUTIME3_REGS

  /***************** XBAR registers sections ***************/
  .inputxbar_regs (NOLOAD):
  {
    KEEP(*(.inputxbar_regs))
    KEEP(*(.inputxbar_regs.*))
  } > MEM_INPUTXBAR_REGS

  .xbar_regs (NOLOAD):
  {
    KEEP(*(.xbar_regs))
    KEEP(*(.xbar_regs.*))
  } > MEM_XBAR_REGS

  .clbinputxbar_regs (NOLOAD):
  {
    KEEP(*(.clbinputxbar_regs))
    KEEP(*(.clbinputxbar_regs.*))
  } > MEM_CLBINPUTXBAR_REGS

  .epwmxbar_regs (NOLOAD):
  {
    KEEP(*(.epwmxbar_regs))
    KEEP(*(.epwmxbar_regs.*))
  } > MEM_EPWMXBAR_REGS

  .clbxbar_regs (NOLOAD):
  {
    KEEP(*(.clbxbar_regs))
    KEEP(*(.clbxbar_regs.*))
  } > MEM_CLBXBAR_REGS

  .outputxbar_regs (NOLOAD):
  {
    KEEP(*(.outputxbar_regs))
    KEEP(*(.outputxbar_regs.*))
  } > MEM_OUTPUTXBAR1_REGS

  .outputxbar2_regs (NOLOAD):
  {
    KEEP(*(.outputxbar2_regs))
    KEEP(*(.outputxbar2_regs.*))
  } > MEM_OUTPUTXBAR2_REGS

  .clboutputxbar_regs (NOLOAD):
  {
    KEEP(*(.clboutputxbar_regs))
    KEEP(*(.clboutputxbar_regs.*))
  } > MEM_CLBOUTPUTXBAR1_REGS

  .clboutputxbar2_regs (NOLOAD):
  {
    KEEP(*(.clboutputxbar2_regs))
    KEEP(*(.clboutputxbar2_regs.*))
  } > MEM_CLBOUTPUTXBAR2_REGS

  /***************** GPIO registers sections ***************/
  .gpio_porta_regs (NOLOAD):
  {
    KEEP(*(.gpio_porta_regs))
    KEEP(*(.gpio_porta_regs.*))
  } > MEM_GPIOA_REGS

  .gpio_portb_regs (NOLOAD):
  {
    KEEP(*(.gpio_portb_regs))
    KEEP(*(.gpio_portb_regs.*))
  } > MEM_GPIOB_REGS

  .gpio_portc_regs (NOLOAD):
  {
    KEEP(*(.gpio_portc_regs))
    KEEP(*(.gpio_portc_regs.*))
  } > MEM_GPIOC_REGS

  .gpio_portd_regs (NOLOAD):
  {
    KEEP(*(.gpio_portd_regs))
    KEEP(*(.gpio_portd_regs.*))
  } > MEM_GPIOD_REGS

  .gpio_porte_regs (NOLOAD):
  {
    KEEP(*(.gpio_porte_regs))
    KEEP(*(.gpio_porte_regs.*))
  } > MEM_GPIOE_REGS

  .gpio_portf_regs (NOLOAD):
  {
    KEEP(*(.gpio_portf_regs))
    KEEP(*(.gpio_portf_regs.*))
  } > MEM_GPIOF_REGS

  .gpio_portg_regs (NOLOAD):
  {
    KEEP(*(.gpio_portg_regs))
    KEEP(*(.gpio_portg_regs.*))
  } > MEM_GPIOG_REGS

  /***************** Watchdog 1 registers sections ***************/
  .wd1_regs (NOLOAD):
  {
    KEEP(*(.wd1_regs))
    KEEP(*(.wd1_regs.*))
  } > MEM_WD1_REGS

  /***************** SysCtl registers sections ***************/
  .ahb1commpapa_regs (NOLOAD):
  {
    KEEP(*(.ahb1commpapa_regs))
    KEEP(*(.ahb1commpapa_regs.*))
  } > MEM_AHB1COMMPAPA_REGS

  .anacfg_regs (NOLOAD):
  {
    KEEP(*(.anacfg_regs))
    KEEP(*(.anacfg_regs.*))
  } > MEM_ANACFG_REGS

  .apbcommpara_regs (NOLOAD):
  {
    KEEP(*(.apbcommpara_regs))
    KEEP(*(.apbcommpara_regs.*))
  } > MEM_APBCOMMPARA_REGS

  .crgcfgpapa_regs (NOLOAD):
  {
    KEEP(*(.crgcfgpapa_regs))
    KEEP(*(.crgcfgpapa_regs.*))
  } > MEM_CRGCFGPAPA_REGS

  .io_cfg_regs (NOLOAD):
  {
    KEEP(*(.io_cfg_regs))
    KEEP(*(.io_cfg_regs.*))
  } > MEM_IO_CFG_REGS

  .subcrg_regs (NOLOAD):
  {
    KEEP(*(.subcrg_regs))
    KEEP(*(.subcrg_regs.*))
  } > MEM_SUBCRG_REGS

  .sysctl_regs (NOLOAD):
  {
    KEEP(*(.sysctl_regs))
    KEEP(*(.sysctl_regs.*))
  } > MEM_SYSCTL_REGS

  /***************** DMA channels registers sections ***************/
  .dma1_ch1_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch1_regs))
    KEEP(*(.dma1_ch1_regs.*))
  } > MEM_DMA1_CH1_REGS

  .dma1_ch2_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch2_regs))
    KEEP(*(.dma1_ch2_regs.*))
  } > MEM_DMA1_CH2_REGS

  .dma1_ch3_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch3_regs))
    KEEP(*(.dma1_ch3_regs.*))
  } > MEM_DMA1_CH3_REGS

  .dma1_ch4_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch4_regs))
    KEEP(*(.dma1_ch4_regs.*))
  } > MEM_DMA1_CH4_REGS

  .dma1_ch5_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch5_regs))
    KEEP(*(.dma1_ch5_regs.*))
  } > MEM_DMA1_CH5_REGS

  .dma1_ch6_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch6_regs))
    KEEP(*(.dma1_ch6_regs.*))
  } > MEM_DMA1_CH6_REGS

  .dma1_ch7_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch7_regs))
    KEEP(*(.dma1_ch7_regs.*))
  } > MEM_DMA1_CH7_REGS
  
  .dma1_ch8_regs (NOLOAD):
  {
    KEEP(*(.dma1_ch8_regs))
    KEEP(*(.dma1_ch8_regs.*))
  } > MEM_DMA1_CH8_REGS
  

  .dma2_ch1_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch1_regs))
    KEEP(*(.dma2_ch1_regs.*))
  } > MEM_DMA2_CH1_REGS

  .dma2_ch2_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch2_regs))
    KEEP(*(.dma2_ch2_regs.*))
  } > MEM_DMA2_CH2_REGS

  .dma2_ch3_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch3_regs))
    KEEP(*(.dma2_ch3_regs.*))
  } > MEM_DMA2_CH3_REGS

  .dma2_ch4_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch4_regs))
    KEEP(*(.dma2_ch4_regs.*))
  } > MEM_DMA2_CH4_REGS

  .dma2_ch5_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch5_regs))
    KEEP(*(.dma2_ch5_regs.*))
  } > MEM_DMA2_CH5_REGS

  .dma2_ch6_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch6_regs))
    KEEP(*(.dma2_ch6_regs.*))
  } > MEM_DMA2_CH6_REGS

  .dma2_ch7_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch7_regs))
    KEEP(*(.dma2_ch7_regs.*))
  } > MEM_DMA2_CH7_REGS
  
  .dma2_ch8_regs (NOLOAD):
  {
    KEEP(*(.dma2_ch8_regs))
    KEEP(*(.dma2_ch8_regs.*))
  } > MEM_DMA2_CH8_REGS
  /***************** DMA Multiplexer registers sections ***************/
  .dma_mux_regs (NOLOAD):
  {
    KEEP(*(.dma_mux_regs))
    KEEP(*(.dma_mux_regs.*))
  } > MEM_DMA_MUX_REGS

  /***************** Flash Interface registers sections ***************/
  .flash_icache_regs (NOLOAD):
  {
    KEEP(*(.flash_icache_regs))
    KEEP(*(.flash_icache_regs.*))
  } > MEM_FLASH_ICACHE_REGS

  .flash_dcache_regs (NOLOAD):
  {
    KEEP(*(.flash_dcache_regs))
    KEEP(*(.flash_dcache_regs.*))
  } > MEM_FLASH_DCACHE_REGS

  .flash_efc_regs (NOLOAD):
  {
    KEEP(*(.flash_efc_regs))
    KEEP(*(.flash_efc_regs.*))
  } > MEM_FLASH_EFC_REGS

  .flash_efc2_regs (NOLOAD):
  {
    KEEP(*(.flash_efc2_regs))
    KEEP(*(.flash_efc2_regs.*))
  } > MEM_FLASH_EFC2_REGS

  /***************** CRC registers sections ***************/
  .crc_regs (NOLOAD):
  {
    KEEP(*(.crc_regs))
    KEEP(*(.crc_regs.*))
  } > MEM_CRC_REGS

  /***************** SCI registers sections ***************/
  .scia_regs (NOLOAD):
  {
    KEEP(*(.scia_regs))
    KEEP(*(.scia_regs.*))
  } > MEM_SCIA_REGS

  .scib_regs (NOLOAD):
  {
    KEEP(*(.scib_regs))
    KEEP(*(.scib_regs.*))
  } > MEM_SCIB_REGS

  /***************** SPI registers sections ***************/
  .spia_regs (NOLOAD):
  {
    KEEP(*(.spia_regs))
    KEEP(*(.spia_regs.*))
  } > MEM_SPIA_REGS

  .spib_regs (NOLOAD):
  {
    KEEP(*(.spib_regs))
    KEEP(*(.spib_regs.*))
  } > MEM_SPIB_REGS

  /***************** I2C registers sections ***************/
  .i2ca_regs (NOLOAD):
  {
    KEEP(*(.i2ca_regs))
    KEEP(*(.i2ca_regs.*))
  } > MEM_I2CA_REGS

  .i2cb_regs (NOLOAD):
  {
    KEEP(*(.i2cb_regs))
    KEEP(*(.i2cb_regs.*))
  } > MEM_I2CB_REGS

  .i2cc_regs (NOLOAD):
  {
    KEEP(*(.i2cc_regs))
    KEEP(*(.i2cc_regs.*))
  } > MEM_I2CC_REGS

  /***************** CAN registers sections ***************/
  .cana_regs (NOLOAD):
  {
    KEEP(*(.cana_regs))
    KEEP(*(.cana_regs.*))
  } > MEM_CANA_REGS

  .canb_regs (NOLOAD):
  {
    KEEP(*(.canb_regs))
    KEEP(*(.canb_regs.*))
  } > MEM_CANB_REGS

  /***************** LIN registers sections ***************/
  .lina_regs (NOLOAD):
  {
    KEEP(*(.lina_regs))
    KEEP(*(.lina_regs.*))
  } > MEM_LINA_REGS

  .linb_regs (NOLOAD):
  {
    KEEP(*(.linb_regs))
    KEEP(*(.linb_regs.*))
  } > MEM_LINB_REGS

  /***************** QSPI registers sections ***************/
  .qspi_regs (NOLOAD):
  {
    KEEP(*(.qspi_regs))
    KEEP(*(.qspi_regs.*))
  } > MEM_QSPI_REGS

}

