/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    ecap.c
*   @brief   
*   @details
*
*/

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "gs32_version.h"
#include "ecap.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Constants                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Local Variables                                 */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Prototypes                         */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                          Local Function Definitions                        */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Definitions                       */
/* ========================================================================== */

#if IS_GS32F00xx(0x12) || IS_GS32F3xx(0x22)
// ECAP_setEmulationMode
GS32_DRIVER_INIT_FUNC_T void ECAP_setEmulationMode(uint32_t base,
                                  ECAP_EmulationMode mode)
{
    ASSERT(ECAP_isBaseValid(base));
    HWREGH(base + ECAP_O_DBG) = (HWREGH(base + ECAP_O_DBG) & (~(ECAP_DBG_DSP_MASK_M)));

    // Write to FREE/SOFT bit

    HWREGH(base + ECAP_O_ECCTL1) = ((HWREGH(base + ECAP_O_ECCTL1) & (~ECAP_ECCTL1_FREE_SOFT_M)) |
                                  ((uint16_t)mode << ECAP_ECCTL1_FREE_SOFT_S));
//    HWREGH(base + ECAP_O_DBG) = (HWREGH(base + ECAP_O_DBG) | (ECAP_DBG_DSP_MASK_M));
}
#elif  IS_GS32F00xx(0x30)

GS32_DRIVER_INIT_FUNC_T void ECAP_setEmulationMode(uint32_t base,
                                  ECAP_EmulationMode mode)
{
    ASSERT(ECAP_isBaseValid(base));

    // Write to FREE/SOFT bit

    HWREGH(base + ECAP_O_ECCTL1) = ((HWREGH(base + ECAP_O_ECCTL1) & (~ECAP_ECCTL1_FREE_SOFT_M)) |
                                  ((uint16_t)mode << ECAP_ECCTL1_FREE_SOFT_S));
}

#endif

#ifdef __cplusplus
}
#endif
