/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    epwm_all.h
*   @brief   
*
*   commit history
*   20240521, Jason, change EPWM18_BASE to be EPWM16_BASE because 2.0ES has max 16 EPWMs.
*   20240722, lihao, Separate the XCMP,MINDB,DIODE function from the epwm.h.
*/

#ifndef DEVICE_DRIVERLIB_EPWM_ALL_H_
#define DEVICE_DRIVERLIB_EPWM_ALL_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */
#include "inc/hw_types.h"
#include "gs32_version.h"
#include "inc/hw_memmap.h"

#include "inc/hw_epwm.h"
#include "inc/hw_sysctl_ahb.h"
#include "debug.h"

#include "epwm/epwm_define.h"
#include "epwm/epwm_tb_sync.h"
#include "epwm/epwm_cc_aq.h"
#include "epwm/epwm_link_gld.h"
#include "epwm/epwm_db_et.h"
#include "epwm/epwm_tz_dc.h"
#include "epwm/epwm_top.h"
//#include "epwm/epwm_hrpwm.h"

#if EPWM_VERSION==30
#include "epwm/epwm_de.h"
#include "epwm/epwm_mindb.h"
#include "epwm/epwm_xcmp.h"
#endif

/**
 * @brief Set emulation mode
 * @param [in]  base is the base address of the EPWM module.
 * @param [in]  emulationMode is the emulation mode.
 * @remarks
 *  This function sets the emulation behaviours of the time base counter. Valid
 *  values for emulationMode are:
 *   - EPWM_EMULATION_STOP_AFTER_NEXT_TB    - Stop after next Time Base counter
 *                                            increment or decrement.
 *   - EPWM_EMULATION_STOP_AFTER_FULL_CYCLE - Stop when counter completes whole
 *                                            cycle.
 *   - EPWM_EMULATION_FREE_RUN               - Free run.
 */
extern GS32_DRIVER_INIT_FUNC_T void
EPWM_setEmulationMode(uint32_t base, EPWM_EmulationMode emulationMode);

/**
 * @brief Configures ePWM signal with desired frequency & duty
 * @param [in]  base is the base address of the EPWM module.
 * @param [in]  signalParams is the desired signal parameters.
 * @remarks
 *  This function configures the ePWM module to generate a signal with
 *  desired frequency & duty.
 */
extern GS32_DRIVER_INIT_FUNC_T void
EPWM_configureSignal(uint32_t base, const EPWM_SignalParams *signalParams);

extern GS32_DRIVER_INIT_FUNC_T void
EPWM_deinit(uint32_t base);


#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_EPWM_ALL_H_ */
