/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_aes.h
*   @brief
*	2024.7.12 Fanzhe add
*/

#ifndef HW_AES_H
#define HW_AES_H


//*************************************************************************************************
//
// The following are defines for the AES register offsets
//
//*************************************************************************************************
/*AES_REGSx Registers*/
#define AES_O_IRQ_EN 					0X00U			// Interrupt Enable Register.
#define AES_O_IRQ_STAT 					0X04U           // Interrupt Status Register
#define AES_O_IRQ_CTRL 					0X08U           // Interrupt Control Register.
#define AES_O_FIFO_STAT					0x0CU           // FIFO Status Register
#define AES_O_SDMA_BRST_SZ				0x10U           // SDMA Burst Size Register.
#define AES_O_SRC_PTR					0x20U           // Source Pointer Register.
#define AES_O_DST_PTR					0x24U           // Destination Pointer Register.
#define AES_O_OFFSET					0x28U           // Offset Register.
#define AES_O_PRE_AAD_LEN				0x2CU           // Prefixed AAD Length Register.
#define AES_O_POST_AAD_LEN				0x30U           // Postfixed AAD Length Register.
#define AES_O_PROC_LEN					0x34U           // Packet Length Register.
#define AES_O_ICV_LEN					0x38U           // ICV Length Register.
#define AES_O_ICV_OFFSET				0x3CU           // ICV Offset Register.
#define AES_O_IV_OFFSET					0x40U           // IV Offset Register.
#define AES_O_SW_CTRL					0x44U           // Software Control Register.
#define AES_O_AUX_INFO					0x48U           // Auxiliary Information Register.
#define AES_O_CTRL						0x4CU           // Control Register.
#define AES_O_STAT_POP					0x50U           // Status FIFO POP Register.
#define AES_O_STATUS					0x54U           // Status FIFO Register.
#define AES_O_STAT_WD_CTRL				0x80U           // Status Watchdog Register.
#define AES_O_KEY_SZ					0x100U          // Key Size Register.
#define AES_O_VERSION					0x180U          // Version Register.
#define AES_O_VERSION_EXT				0x184U          // Extended Version Register.
#define AES_O_VERSION_EXT_2				0x190U          // Extended Version 2 Register.
#define AES_O_VERSION_EXT_3				0x194U          // Extended Version 3 Register.
#define AES_O_SECURE_CTRL				0x1C0U          // Secure Bus Control Register.
#define AES_O_SECURE_CTX_RELEASE		0x1C4U          // Secure Context Release Register.
#define AES_O_KEY_CTX					0x4000			// Key storage register.



//*************************************************************************************************
//
// The following are defines for the bit fields in the AES_FIFO_STAT register
//
//*************************************************************************************************
#define AES_FIFO_STAT_EMPTY				(1U << 31)




#endif /* HW_AES_H_ */
