/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_asysctl_v22.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V22_H_
#define DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_V22_H_

#include "gs32_version.h"

#if IS_GS32F3xx(0x22)       //used for 2.2CS

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//*************************************************************************************************
//
// The following are defines for the ANA_SYSCTRL_PARA register offsets
//
//*************************************************************************************************
#define ANA_CFG_O_ANA_CFG_LOCK           0X00U        // lock register

#define ANA_CFG_O_TSNSCTL                0x04C        //Temperature Sensor Control Register
#define ANA_CFG_O_ANAREFCTL              0x0D0        //Analog Reference Control Register
#define ANA_CFG_O_VMONCTL                0x0E0        //Voltage Monitor Control Register
#define ANA_CFG_O_CMPHPMXSEL             0x104        //Bits to select one of the many sources on CmpHP inputs
#define ANA_CFG_O_CMPLPMXSEL             0x108        //Bits to select one of the many sources on CmpLP inputs
#define ANA_CFG_O_CMPHNMXSEL             0x10C        //Bits to select one of the many sources on CmpHN inputs
#define ANA_CFG_O_CMPLNMXSEL             0x10E        //Bits to select one of the many sources on CmpLN inputs
#define ANA_CFG_O_ADCDACLOOPBACK         0x110        //Enable loopback from DAC to ADCs
#define ANA_CFG_O_CMPHPMXSEL1            0x120        //Bits to select one of the many sources on CmpHP inputs
#define ANA_CFG_O_CMPLPMXSEL1            0x124        //Bits to select one of the many sources on CmpLP inputs
#define ANA_CFG_O_ADCSOCFRCGB            0x21C        //ADC Global SOC Force
#define ANA_CFG_O_ADCSOCFRCGBSEL         0x220        //ADC Global SOC Force Select
#define ANA_CFG_O_AGPIOFILTER            0x222        //AGPIO Filter Control Register
#define ANA_CFG_O_AGPIOCTRLG             0x240        //AGPIO Control Register G
#define ANA_CFG_O_AGPIOCTRLH             0x244        //AGPIO Control Register H
#define ANA_CFG_O_GPIOINENACTRL          0x268        //GPIOINENACTRL Control Register

#define ANA_CFG_O_ANA_BOR_CFG            0x304        //BOR config
#define ANA_CFG_O_ANA_LDO_1V1_CFG        0x308        //1V1LDO config
#define ANA_CFG_O_ANA_EFLASH_BOR_CFG     0x30C        //EFLASH_BOR config
#define ANA_CFG_O_ANA_TOP_BG_CFG         0x310        //BG config
#define ANA_CFG_O_ANA_OSC_TRIM           0x314        //OSC TRIM config
#define ANA_CFG_O_ANA_PVM_CFG            0x318        //PVM config
#define ANA_CFG_O_ANA_POR_1V1_CFG        0x31C        //POR_1V1 config
#define ANA_CFG_O_ANA_TOP_POR_CFG        0x320        //TOP_POR config

#define ANA_CFG_O_ADC_RST                0x400        //ADC_RST register
#define ANA_CFG_O_ADC_SAMP_SEL           0x404        //ADC_SAMP_SEL register
#define ANA_CFG_O_ADCA_SPARE             0x408        //ADC_A spare register
#define ANA_CFG_O_ADCB_SPARE             0x40C        //ADC_B spare register
#define ANA_CFG_O_ADCC_SPARE             0x410        //ADC_C spare register
#define ANA_CFG_O_ADCD_SPARE             0x414        //ADC_D spare register
#define ANA_CFG_O_ADC_TOP_SPARE          0x418        //ADC TOP spare register
#define ANA_CFG_O_CMP_EN                 0x41C        //CMP_EN register
#define ANA_CFG_O_CMP_RST                0x420        //CMP_RST register
#define ANA_CFG_O_CMP1_H_TRIM            0x424        //CMPSS1.H trim
#define ANA_CFG_O_CMP1_L_TRIM            0x428        //CMPSS1.L trim
#define ANA_CFG_O_CMP2_H_TRIM            0x42C        //CMPSS2.H trim
#define ANA_CFG_O_CMP2_L_TRIM            0x430        //CMPSS2.L trim
#define ANA_CFG_O_CMP3_H_TRIM            0x434        //CMPSS3.H trim
#define ANA_CFG_O_CMP3_L_TRIM            0x438        //CMPSS3.L trim
#define ANA_CFG_O_CMP4_H_TRIM            0x43C        //CMPSS4.H trim
#define ANA_CFG_O_CMP4_L_TRIM            0x440        //CMPSS4.L trim
#define ANA_CFG_O_CMP5_H_TRIM            0x444        //CMPSS5.H trim
#define ANA_CFG_O_CMP5_L_TRIM            0x448        //CMPSS5.L trim
#define ANA_CFG_O_CMP6_H_TRIM            0x44C        //CMPSS6.H trim
#define ANA_CFG_O_CMP6_L_TRIM            0x450        //CMPSS6.L trim
#define ANA_CFG_O_CMP7_H_TRIM            0x454        //CMPSS7.H trim
#define ANA_CFG_O_CMP7_L_TRIM            0x458        //CMPSS7.L trim
#define ANA_CFG_O_CMP8_H_TRIM            0x45C        //CMPSS8.H trim
#define ANA_CFG_O_CMP8_L_TRIM            0x460        //CMPSS8.L trim
#define ANA_CFG_O_CMP9_H_TRIM            0x464        //CMPSS9.H trim
#define ANA_CFG_O_CMP9_L_TRIM            0x468        //CMPSS9.L trim
#define ANA_CFG_O_CMP10_H_TRIM           0x46C        //CMPSS10.H trim
#define ANA_CFG_O_CMP10_L_TRIM           0x470        //CMPSS10.L trim
#define ANA_CFG_O_CMP11_H_TRIM           0x474        //CMPSS11.H trim
#define ANA_CFG_O_CMP11_L_TRIM           0x478        //CMPSS11.L trim
#define ANA_CFG_O_CMP12_H_TRIM           0x47C        //CMPSS12.H trim
#define ANA_CFG_O_CMP12_L_TRIM           0x480        //CMPSS12.L trim
#define ANA_CFG_O_CMP1_SPARE             0x484        //CMP1 spare register
#define ANA_CFG_O_CMP2_SPARE             0x488        //CMP2 spare register
#define ANA_CFG_O_CMP3_SPARE             0x48C        //CMP3 spare register
#define ANA_CFG_O_CMP4_SPARE             0x490        //CMP4 spare register
#define ANA_CFG_O_CMP5_SPARE             0x494        //CMP5 spare register
#define ANA_CFG_O_CMP6_SPARE             0x498        //CMP6 spare register
#define ANA_CFG_O_CMP7_SPARE             0x49C        //CMP7 spare register
#define ANA_CFG_O_CMP8_SPARE             0x4A0        //CMP8 spare register
#define ANA_CFG_O_CMP9_SPARE             0x4A4        //CMP9 spare register
#define ANA_CFG_O_CMP10_SPARE            0x4A8        //CMP10 spare register
#define ANA_CFG_O_CMP11_SPARE            0x4AC        //CMP11 spare register
#define ANA_CFG_O_CMP12_SPARE            0x4B0        //CMP12 spare register
#define ANA_CFG_O_CMP_TOP_SPARE          0x4B4        //CMP TOP spare register
#define ANA_CFG_O_DAC_TOP_EN             0x4B8        //DAC_TOP_EN config register
#define ANA_CFG_O_DAC_RST                0x4BC        //DAC_RST config register
#define ANA_CFG_O_DACA_BUF_TRIM          0x4C0        //DACA_BUF trim
#define ANA_CFG_O_DACB_BUF_TRIM          0x4C4        //DACB_BUF trim
#define ANA_CFG_O_DACC_BUF_TRIM          0x4C8        //DACC_BUF trim
#define ANA_CFG_O_DACA_SPARE             0x4CC        //DAC A spare register
#define ANA_CFG_O_DACB_SPARE             0x4D0        //DAC B spare register
#define ANA_CFG_O_DACC_SPARE             0x4D4        //DAC C spare register
#define ANA_CFG_O_DAC_TOP_SPARE          0x4D8        //DAC TOP spare register
#define ANA_CFG_O_TMUX                   0x4DC        //TMUX config register
#define ANA_CFG_O_V2I_A                  0x4E0        //V2I_A config register
#define ANA_CFG_O_V2I_B                  0x4E4        //V2I_B config register
#define ANA_CFG_O_BG_REG                 0x4E8        //band gap config register
#define ANA_CFG_O_ANA_CLK_TRIM           0x4EC        //ana_clk trim config register
#define ANA_CFG_O_ANA_CLK_SPARE          0x4F0        //ana_clk_spare config register
#define ANA_CFG_O_ANA_TS_CHOP_EN         0x504        //ana_ts_chop_en config register
#define ANA_CFG_O_ANA_TS_MEAS_EN         0x508        //ana_ts_meas_en config register
#define ANA_CFG_O_ANA_TS_SPARE           0x510        //ana_ts_spare config register
#define ANA_CFG_O_ANA_TEST_MUX_SEL       0x524        //ana_test_mux_sel config register
#define ANA_CFG_O_ANA_TEST_MUX_EN        0x528        //ana_test_mux_en config register
#define ANA_CFG_O_LDO_ANA_TEST_MODE      0x52C        //LDO_ANA_TEST_MODE config
#define ANA_CFG_O_LDO_ANA_TEST_EN        0x530        //LDO_ANA_TEST_EN config
#define ANA_CFG_O_LDO_ANA_VSEL           0x534        //LDO_ANA_VSEL config
#define ANA_CFG_O_LDO_ANA_FASTON         0x538        //LDO_ANA_FASTON config
#define ANA_CFG_O_DACA_ANA_CFG           0x53C        //DACA_ANA_CFG config
#define ANA_CFG_O_DACA_INL_OFF_DLY_TRIM  0x540        //DACA_INL_OFF_DLY_TRIM config
#define ANA_CFG_O_DACB_ANA_CFG           0x544        //DACB_ANA_CFG config
#define ANA_CFG_O_DACB_INL_OFF_DLY_TRIM  0x548        //DACB_INL_OFF_DLY_TRIM config
#define ANA_CFG_O_DACC_ANA_CFG           0x54C        //DACC_ANA_CFG config
#define ANA_CFG_O_DACC_INL_OFF_DLY_TRIM  0x550        //DACC_INL_OFF_DLY_TRIM config
#define ANA_CFG_O_ANA_TOP_SPARE1         0x554        //ANA_TOP_SPARE1 config
#define ANA_CFG_O_ANA_TOP_SPARE2         0x558        //ANA_TOP_SPARE2 config
#define ANA_CFG_O_ANA_TOP_SPARE3         0x55C        //ANA_TOP_SPARE3 config
#define ANA_CFG_O_ANA_TOP_SPARE4         0x560        //ANA_TOP_SPARE4 config
#define ANA_CFG_O_ADCA_BUFDAC2ADC_LBEN   0x564        //ADCA_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCB_BUFDAC2ADC_LBEN   0x568        //ADCB_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCC_BUFDAC2ADC_LBEN   0x56C        //ADCC_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCD_BUFDAC2ADC_LBEN   0x570        //ADCD_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADC_L2H_CFG            0x574        //ADCD_BUFDAC2ADC_LBEN config
#define ANA_CFG_O_ADCA_CH_MAP_CH_SEL     0x578        //ADCA_CH_MAP_CH_SEL register
#define ANA_CFG_O_ADCB_CH_MAP_CH_SEL     0x57C        //ADCB_CH_MAP_CH_SEL register
#define ANA_CFG_O_ADCC_CH_MAP_CH_SEL     0x580        //ADCC_CH_MAP_CH_SEL register
#define ANA_CFG_O_ADCD_CH_MAP_CH_SEL     0x584        //ADCD_CH_MAP_CH_SEL register
#define ANA_CFG_O_ADCA_FRC_CH_SEL        0x588        //ADCA_FRC_CH_SEL register
#define ANA_CFG_O_ADCB_FRC_CH_SEL        0x58C        //ADCB_FRC_CH_SEL register
#define ANA_CFG_O_ADCC_FRC_CH_SEL        0x590        //ADCC_FRC_CH_SEL register
#define ANA_CFG_O_ADCD_FRC_CH_SEL        0x594        //ADCD_FRC_CH_SEL register
#define ANA_CFG_O_DACA_TRIM              0x598        //DACA_TRIM config
#define ANA_CFG_O_DACB_TRIM              0x59C        //DACB_TRIM config
#define ANA_CFG_O_DACC_TRIM              0x5A0        //DACC_TRIM config

#define ANA_CFG_O_ADC_SPARE              ANA_CFG_O_ADCA_SPARE


//*************************************************************************************************
//
// The following are defines for the bit fields in the TSNSCTL register
//
//*************************************************************************************************
#define ASYSCTL_TSNSCTL_ENABLE   0x1U   // Temperature Sensor Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the ANAREFCTL register
//
//*************************************************************************************************
#define ASYSCTL_ANAREFCTL_ANAREFASEL      0x1U     // ADCA Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFBSEL      0x2U     // ADCB Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFCSEL      0x4U     // ADCC Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFDSEL      0x8U     // ADCD Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFA2P5SEL   0x100U   // ADCA Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFB2P5SEL   0x200U   // ADCB Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFC2P5SEL   0x400U   // ADCC Analog Reference Select
#define ASYSCTL_ANAREFCTL_ANAREFD2P5SEL   0x800U   // ADCD Analog Reference Select


//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPHPMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPHPMXSEL_CMP1HPMXSEL_S   0U
#define ASYSCTL_CMPHPMXSEL_CMP1HPMXSEL_M   0x7U     // CMP1HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP2HPMXSEL_S   3U
#define ASYSCTL_CMPHPMXSEL_CMP2HPMXSEL_M   0x38U    // CMP2HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP3HPMXSEL_S   6U
#define ASYSCTL_CMPHPMXSEL_CMP3HPMXSEL_M   0x1C0U   // CMP3HPMXSEL bits
#define ASYSCTL_CMPHPMXSEL_CMP4HPMXSEL_S   9U
#define ASYSCTL_CMPHPMXSEL_CMP4HPMXSEL_M   0xE00U   // CMP4HPMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPLPMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPLPMXSEL_CMP1LPMXSEL_S   0U
#define ASYSCTL_CMPLPMXSEL_CMP1LPMXSEL_M   0x7U     // CMP1LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP2LPMXSEL_S   3U
#define ASYSCTL_CMPLPMXSEL_CMP2LPMXSEL_M   0x38U    // CMP2LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP3LPMXSEL_S   6U
#define ASYSCTL_CMPLPMXSEL_CMP3LPMXSEL_M   0x1C0U   // CMP3LPMXSEL bits
#define ASYSCTL_CMPLPMXSEL_CMP4LPMXSEL_S   9U
#define ASYSCTL_CMPLPMXSEL_CMP4LPMXSEL_M   0xE00U   // CMP4LPMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPHNMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPHNMXSEL_CMP1HNMXSEL   0x1U   // CMP1HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP2HNMXSEL   0x2U   // CMP2HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP3HNMXSEL   0x4U   // CMP3HNMXSEL bits
#define ASYSCTL_CMPHNMXSEL_CMP4HNMXSEL   0x8U   // CMP4HNMXSEL bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CMPLNMXSEL register
//
//*************************************************************************************************
#define ASYSCTL_CMPLNMXSEL_CMP1LNMXSEL   0x1U   // CMP1LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP2LNMXSEL   0x2U   // CMP2LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP3LNMXSEL   0x4U   // CMP3LNMXSEL bits
#define ASYSCTL_CMPLNMXSEL_CMP4LNMXSEL   0x8U   // CMP4LNMXSEL bits




#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_ANA_SYSCTRL_PARA_H_ */
