/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_cputimer.h
*   @brief   
*
*/

#ifndef DEVICE_DRIVERLIB_HW_CPUTIMER_H_
#define DEVICE_DRIVERLIB_HW_CPUTIMER_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//register offset
#define CPUTIMER_O_TIMERXLOAD				0x00
#define CPUTIMER_O_TIMERXVALUE				0x04
#define CPUTIMER_O_TIMERXCONTROL			0x08
#define CPUTIMER_O_TIMERXINTCLR				0x0C
#define CPUTIMER_O_TIMERXRIS				0x10
#define CPUTIMER_O_TIMERXMIS				0x14
#define CPUTIMER_O_TIMERXBGLOAD				0x18
#define CPUTIMER_O_TIMERITCR				0xF00
#define CPUTIMER_O_TIMERITOP				0xF04

//register bit set
#define CPUTIMER_TIMERXLOAD					0x20U
#define CPUTIMER_TIMERXINTCLR				0xFFU
#define CPUTIMER_TIMERXCONTROL_TIMEREN		0x80U
#define CPUTIMER_TIMERXCONTROL_INTREN		0x20U
#define CPUTIMER_TIMERXCONTROL_TIMERPREL	0x04U
#define CPUTIMER_TIMERXCONTROL_TIMERPREH	0x08U
#define CPUTIMER_TIMERXCONTROL_TIMERPRE_MASK    0x0CU
#define CPUTIMER_TIMERXCONTROL_TIMERPRE_SHIFT	2U
#define CPUTIMER_TIMERXCONTROL_TIMERMODE	0x40U
#define CPUTIMER_TIMERXCONTROL_TIMERSIZE	0x02U
#define CPUTIMER_TIMERXCONTROL_ONESHOT		0x01U
#define CPUTIMER_TIMERXRIS_INTR				0x01U
#define CPUTIMER_TIMERXMIS_INTR				0x01U
#define CPUTIMER_TIMERITCR					0x01U
#define CPUTIMER_TIMERITOP1					0x01U
#define CPUTIMER_TIMERITOP2					0x02U


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_HW_CPUTIMER_H_ */
