/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_crc.h
*   @brief   
*   commit history
*   2024/03/18, Xu Haoze, use new macro definitions to control the SDFM Version: \
*  					  		IS_GS32F00xx(...) and IS_GS32F3xx(...)
*  					  		Add Version 3.0 into the macro definitions
*/

#ifndef DEVICE_DRIVERLIB_HW_CRC_H_
#define DEVICE_DRIVERLIB_HW_CRC_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "gs32_version.h"
#include "hw_types.h"

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
#if (IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22))
#define CRC_VERSION 110
#else
#error "unknown crc version"
#endif


// register offset
// CRC_REGS Registers
#define CRC_O_CRC_DR			    	0x00
#define CRC_O_CRC_RESULT			    0x04
#define CRC_O_CRC_CR			        0x08
#define CRC_O_CRC_INIT				    0x0C
#define CRC_O_CRC_POL				    0x10
#define CRC_O_CRC_EN				    0x14
#define CRC_O_CRC_LEN				    0x18
#define CRC_O_CRC_GOLDEN				0x1C

#if (CRC_VERSION == 100)
/* CRC_REGS Registers For 1.0ES 1.1ES and 2.0ES */
#define CRC_O_CRC_INTEN				    0x20
#define CRC_O_CRC_INTFLG				0x24
#define CRC_O_CRC_INTCLR				0x28
#define CRC_O_CRC_INTFRC				0x2C

#elif (CRC_VERSION == 110)
/* CRC_REGS Registers For 1.2ES */
#define CRC_O_CRC_INTR_RAW              0x20
#define CRC_O_CRC_INTR_MASK             0x24
#define CRC_O_CRC_INTR                  0x28
#define CRC_O_CRC_INTFRC                0x2C
#define CRC_O_CRC_LOCK                  0x30

#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_REGS registers
//
//*************************************************************************************************

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_CR register
//
//*************************************************************************************************
#define CRC_CRC_CR_RESET		        	0x00000001U

// new bit fields in 1.2 ES
#if (CRC_VERSION == 110)
#define CRC_CRC_CR_TX						0x00000000U
#define CRC_CRC_CR_RX						0x00000002U
#define CRC_CRC_CR_TX_RX_CFG                0x00000002U	// Configure CRC is currently used in TX mode or RX mode.
														// This bit controls if the result compares with the golden value.
#endif

//#define CRC_CRC_CR_REV_IN_NOTREV			0x00U
//#define CRC_CRC_CR_REV_IN_BYTEREV			0x20U
//#define CRC_CRC_CR_REV_IN_HALFWORDREV		0x40U
//#define CRC_CRC_CR_REV_IN_WORDREV			0x60U
#define CRC_CRC_CR_REV_INL					0x00000020U
#define CRC_CRC_CR_REV_INH					0x00000040U
#define CRC_CR_REV_IN_M                     0x00000060U
#define CRC_CR_REV_IN_S                     5U

//#define CRC_CRC_CR_POLYSIZE_32BIT			0x00U
//#define CRC_CRC_CR_POLYSIZE_24BIT			0x04U
//#define CRC_CRC_CR_POLYSIZE_16BIT			0x08U
//#define CRC_CRC_CR_POLYSIZE_8BIT			0x0CU
//#define CRC_CRC_CR_POLYSIZE_7BIT			0x10U
#define CRC_CRC_CR_POLYSIZEL				0x00000004U
#define CRC_CRC_CR_POLYSIZEM				0x00000008U
#define CRC_CRC_CR_POLYSIZEH				0x00000010U
#define CRC_CR_POLYSIZE_M                   0x0000001CU
#define CRC_CR_POLYSIZE_S                   2U

#define CRC_CRC_CR_REV_OUT					0x00000080U
#define CRC_CR_REV_OUT_M   					0x00000080U
#define CRC_CR_REV_OUT_S					7U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_EN register
//
//*************************************************************************************************
#define CRC_CRC_EN_START					0x00000001U
#define CRC_CRC_EN_FMAT_READY				0x40000000U
#define CRC_CRC_EN_RUN_STS					0x80000000U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_LEN register
//
//*************************************************************************************************
#define CRC_CRC_LEN_7BIT			        0x00000000U
#define CRC_CRC_LEN_8BIT			        0x00000000U
#define CRC_CRC_LEN_16BIT			        0x00000001U
#define CRC_CRC_LEN_24BIT			        0x00000002U
#define CRC_CRC_LEN_32BIT			        0x00000003U

#if (CRC_VERSION == 100)
//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTEN register of 1.0 and 1.1ES
//
//*************************************************************************************************
#define CRC_CRC_INTEN_DONE			        0x00000002U
#define CRC_CRC_INTEN_FAIL			        0x00000004U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTFLG register of 1.0 and 1.1ES
//
//*************************************************************************************************
#define CRC_CRC_INTFLG_INT			        0x00000001U
#define CRC_CRC_INTFLG_DONE			        0x00000002U
#define CRC_CRC_INTFLG_FAIL 		        0x00000004U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTCLR register of 1.0 and 1.1ES
//
//*************************************************************************************************
#define CRC_CRC_INTCLR_INT			        0x00000001U
#define CRC_CRC_INTCLR_DONE			        0x00000002U
#define CRC_CRC_INTCLR_FAIL 		        0x00000004U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTFRC register of 1.0 and 1.1ES
//
//*************************************************************************************************
#define CRC_CRC_INTFRC_DONE			        0x00000002U
#define CRC_CRC_INTFRC_FAIL 		        0x00000004U

#elif (CRC_VERSION == 110)
//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTR_RAW register of 1.2ES
//
//*************************************************************************************************
#define CRC_CRC_INTR_RAW_DONE               0x00000001U
#define CRC_CRC_INTR_RAW_FAIL               0x00000002U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTR_MASK register of 1.2ES
//
//*************************************************************************************************
#define CRC_CRC_INTR_MASK_DONE               0x00000001U
#define CRC_CRC_INTR_MASK_FAIL               0x00000002U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTRregister of 1.2ES
//
//*************************************************************************************************
#define CRC_CRC_INTR_DONE                   0x00000001U
#define CRC_CRC_INTR_FAIL                   0x00000002U

//*************************************************************************************************
//
// The following are defines for the bit fields in the CRC_INTFRC register of 1.2ES
//
//*************************************************************************************************
#define CRC_CRC_INTFRC_DONE                   0x00000001U
#define CRC_CRC_INTFRC_FAIL                   0x00000002U

#endif

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif


#endif /* DEVICE_DRIVERLIB_HW_CRC_H_ */
