/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_dmamux.h
*   @brief   
*
*/
/*
 * commit history
 * 20240313, LYF, verify for chip 3.0
 * 20240319, LYF, Organize XDMA and DMAMUX driver version management
 * 20240612, LYF, move the HkSelect and HardInf configuration inside the driver by force 
 */


#ifndef _HW_DMAMUX_H_
#define _HW_DMAMUX_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                          Version defs                                      */
/* ========================================================================== */
#ifdef DMAMUX_VERSION
#undef DMAMUX_VERSION
#endif 

#if IS_GS32F00xx(0x12)
/*Use standard dammux base, contain 2 ports */
#define DMAMUX_VERSION      (0x12)

#elif IS_GS32F00xx(0x30)
/*Use standard dammux base, contain 1 ports (DSP)*/  
#define DMAMUX_VERSION      (0x30)

#elif IS_GS32F3xx(0x22)
/*Use standard dammux base, contain 2 ports (2XDSP) */ 
#define DMAMUX_VERSION      (0x22)

#elif IS_GS32F3xx(0x23)
/*Use standard dammux base, contain 3 ports (ARM + 2XDSP) */ 
#define DMAMUX_VERSION      (0x23)
#else

#define DMAMUX_VERSION      (0xFF)

#endif

//*****************************************************************************
//
//! The following are defines for the P2P support feature.
//! 0 : Not support DMAMUX P2P trigger case
//!      RGCR0 used for channel0 by force
//!      RGCR1 used for channel1 by force
//!      ................................
//!      RGCR7 used for cahngel7 by force
//! 1 : Support for DMAMUX P2P trigger case
//!      RGCR0~RGCR7 used by the riority in order
//
//*****************************************************************************
#define DMAMUX_RGCR_P2P_SUPPORT (0)

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */


#if (DMAMUX_VERSION == 0x11)  

#define DMAMUX_O_SOF_INT_RAW            0x000U      //WC
#define DMAMUX_O_OF_INT_RAW             0x008U      //WC
#define DMAMUX_O_SOF_INT                0x010U      //RO
#define DMAMUX_O_OF_INT                 0x018U      //RO

#elif (DMAMUX_VERSION == 0x20)

#define DMAMUX_O_SOF_INT_RAW            0x000U      //WC
#define DMAMUX_O_SOF_INT_RAW_EXT        0x004U      //WC
#define DMAMUX_O_SOF_INT                0x008U      //RO
#define DMAMUX_O_SOF_INT_EXT            0x00CU      //RO
#define DMAMUX_O_OF_INT_RAW             0x010U      //WC
#define DMAMUX_O_OF_INT                 0x014U      //RO

#else /* #if(DMAMUX_VERSION == 0x21 || DMAMUX_VERSION == 0x22 || DMAMUX_VERSION == 0x12) */

#define DMAMUX_O_SOF_INT_RAW            0x000U      //WC        
#define DMAMUX_O_SOF_INT_MASK           0x004U      //RW
#define DMAMUX_O_SOF_INT                0x008U      //RO
#define DMAMUX_O_OF_INT_RAW             0x00CU      //WC
#define DMAMUX_O_OF_INT_MASK            0x010U      //RW
#define DMAMUX_O_OF_INT                 0x014U      //RO
#define DMAMUX_O_OVR_INT                0x018U      //RO
#define DMAMUX_O_SOF_TRIG               0x01CU      //W1CR0

#endif /* #if (DMAMUX_VERSION == 0x11) */


// DMA Handshake channel parameter configuration register group.
#define DMAMUX_CCRx(k)              (k * 4U)
// DMA request generator Control parameter configuration register group.
#define DMAMUX_RGCRx(p)             (p * 4U)


#if (DMAMUX_VERSION == 0x20|| DMAMUX_VERSION == 0x11)

//********************************************************************************************
//
//! DMA Configuration(0x800~0x9FF) 
//
//! DMAMUX_CCR DMA Handshake Channel Parameter ConfigurationRegister offset +n*4 n = 0~15
//
//!  Register Field             Field Range
//!  reserved                   31 : 30
//!  sync_id                    29 : 24
//!  nbreq                      23 : 19
//!  spol                       18 : 17
//!  se                         16
//!  reserved                   15 : 10
//!  ege                        9
//!  soie                       8
//!  reserved                   7
//!  dmareq_id                  6  : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the DMAMUX_CCRx register 
#define DMAMUX_CCRx_REQID_S                 (0U)
#define DMAMUX_CCRx_REQID_M                         ((0x7FU) << DMAMUX_CCRx_REQID_S)
#define DMAMUX_CCRx_SOIE                    BIT(8)
#define DMAMUX_CCRx_EGE                     BIT(9)
#define DMAMUX_CCRx_SE                      BIT(16)
#define DMAMUX_CCRx_SPOL_S                  (17U)
#define DMAMUX_CCRx_SPOL_M                          ((0x3U) << DMAMUX_CCRx_SPOL_S)
#define DMAMUX_CCRx_NBREQ_S                 (19U)   
#define DMAMUX_CCRx_NBREQ_M                         ((0x1FU) << DMAMUX_CCRx_NBREQ_S)
#define DMAMUX_CCRx_SYNCID_S                (24U)
#define DMAMUX_CCRx_SYNCID_M                        ((0x3FU) << DMAMUX_CCRx_SYNCID_S)


//********************************************************************************************
//
//! DMAMUX_RGCR DMA Request Generator Control Parameter Configuration Register offset +p*4 p = 0~7
//
//!  Register Field             Field Range
//!  reserved                   31 : 24
//!  gnbreq                     23 : 19
//!  gpol                       18 : 17
//!  ge                         16
//!  reserved                   15 : 9
//!  oie                        8
//!  reserved                   7
//!  sig_id                     6  : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the DMAMUX_RGCRx register
#define DMAMUX_RGCRx_TRGID_S                (0U)
#define DMAMUX_RGCRx_TRGID_M                        ((0x7FU) << DMAMUX_RGCRx_TRGID_S)
#define DMAMUX_RGCRx_OIE                    BIT(8)
#define DMAMUX_RGCRx_GE                     BIT(16)
#define DMAMUX_RGCRx_GPOL_S                 (17U)
#define DMAMUX_RGCRx_GPOL_M                         ((0x3U) << DMAMUX_RGCRx_GPOL_S)
#define DMAMUX_RGCRx_GNBREQ_S               (19U)
#define DMAMUX_RGCRx_GNBREQ_M                       ((0x1FU) << DMAMUX_RGCRx_GNBREQ_S)


#if (DMAMUX_VERSION == 0x20)


//********************************************************************************************
//
//! DMAMUX_SOF_INT_RAW0 DMA MUX Overrun Exception Raw Interrupt Clear Register
//
//! Register Field             Field Range
//! dmamux_sof_int_raw         31 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
//********************************************************************************************
//
//! DMAMUX_SOF_INT_RAW0 DMA MUX Overrun Exception Raw external Interrupt Clear Register
//
//! Register Field             Field Range
//! dmamux_sof_int_raw         31 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT_RAW register 
#define DMAMUX_SOF_INT_RAW_M                (0xFFFFFFFFU)
#define DMAMUX_SOF_INT_RAW_S                (0U)


//********************************************************************************************
//
//! DMAMUX_SOF_INT      DMA MUX Overrun Exception Interrupt Status Register
//
//! Register Field             Field Range
//! dmamux_sof_int             31 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
//********************************************************************************************
//
//! DMAMUX_SOF_INT      DMA MUX Overrun Exception External Interrupt Status Register
//
//! Register Field             Field Range
//! dmamux_sof_int             31 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT register 

#define DMAMUX_SOF_INT_M                    (0xFFFFFFFFU)
#define DMAMUX_SOF_INT_S                    (0U)


#else


//********************************************************************************************
//
//! DMAMUX_SOF_INT_RAW0 DMA MUX Overrun Exception Raw Interrupt Clear Register
//
//! Register Field             Field Range
//! reserved                   31 : 16
//! dmamux_sof_int_raw         15 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT_RAW register 
#define DMAMUX_SOF_INT_RAW_M        (0xFFFFU)
#define DMAMUX_SOF_INT_RAW_S        (0U)


//********************************************************************************************
//
//! DMAMUX_SOF_INT      DMA MUX Overrun Exception Interrupt Status Register
//
//! Register Field             Field Range
//! reserved                   31 : 16
//! dmamux_sof_int             15 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT register 

#define DMAMUX_SOF_INT_M            (0xFFFFU)
#define DMAMUX_SOF_INT_S            (0U)


#endif /* #if (DMAMUX_VERSION == 0x20) */


//********************************************************************************************
//
//! DMAMUX_OF_INT_RAW DMA MUX request generator interrupt Clear Register
//
//! Register Field             Field Range
//! reserved                   31 : 8
//! dmamux_of_int_raw           7 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
// The following are defines for the bit fields in the OF_INT_RAW register 

#define DMAMUX_OF_INT_RAW_M         (0xFFU)
#define DMAMUX_OF_INT_RAW_S         (0U)


//********************************************************************************************
//
//! DMAMUX_OF_INT      DMA MUX request generator interrupt Status Register
//
//! Register Field             Field Range
//! reserved                   31 : 8
//! dmamux_of_int               7 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
// The following are defines for the bit fields in the OF_INT register 

#define DMAMUX_OF_INT_M             (0xFFU)
#define DMAMUX_OF_INT_S             (0U)


#else

//********************************************************************************************
//
//! DMA Configuration(0x800~0x9FF) 
//
//! DMAMUX_CCR DMA Handshake Channel Parameter ConfigurationRegister offset +n*4 n = 0~15
//
//!  Register Field             Field Range
//!  reserved                   31 : 30
//!  sync_id                    29 : 24
//!  nbreq                      23 : 19
//!  spol                       18 : 17
//!  se                         16
//!  reserved                   15 : 10
//!  ege                        9
//!  reserved                   8  : 7
//!  dmareq_id                  6  : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the DMAMUX_CCRx register by sysctl_dig
#define DMAMUX_CCRx_REQID_S                 (0U)
#define DMAMUX_CCRx_REQID_M                         ((0x7FU) << DMAMUX_CCRx_REQID_S)
#define DMAMUX_CCRx_EGE                     BIT(9)
#define DMAMUX_CCRx_SE                      BIT(16)
#define DMAMUX_CCRx_SPOL_S                  (17U)
#define DMAMUX_CCRx_SPOL_M                          ((0x3U) << DMAMUX_CCRx_SPOL_S)
#define DMAMUX_CCRx_NBREQ_S                 (19U)   
#define DMAMUX_CCRx_NBREQ_M                         ((0x1FU) << DMAMUX_CCRx_NBREQ_S)
#define DMAMUX_CCRx_SYNCID_S                (24U)
#define DMAMUX_CCRx_SYNCID_M                        ((0x3FU) << DMAMUX_CCRx_SYNCID_S)


//********************************************************************************************
//
//! DMAMUX_RGCR DMA Request Generator Control Parameter Configuration Register offset +p*4 p = 0~7
//
//!  Register Field             Field Range
//!  reserved                   31 : 24
//!  gnbreq                     23 : 19
//!  gpol                       18 : 17
//!  ge                         16
//!  reserved                   15 : 7
//!  sig_id                     6  : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the DMAMUX_RGCRx register by sysctl_dig
#define DMAMUX_RGCRx_TRGID_S                (0U)
#define DMAMUX_RGCRx_TRGID_M                        ((0x7FU) << DMAMUX_RGCRx_TRGID_S)
#define DMAMUX_RGCRx_GE                     BIT(16)
#define DMAMUX_RGCRx_GPOL_S                 (17U)
#define DMAMUX_RGCRx_GPOL_M                         ((0x3U) << DMAMUX_RGCRx_GPOL_S)
#define DMAMUX_RGCRx_GNBREQ_S               (19U)
#define DMAMUX_RGCRx_GNBREQ_M                       ((0xFFFFFU) << DMAMUX_RGCRx_GNBREQ_S)


//********************************************************************************************
//
//! DMAMUX_SOF_INT_RAW0 DMA MUX Overrun Exception Raw Interrupt Clear Register
//
//! Register Field             Field Range
//! reserved                   31 : 16
//! dmamux_sof_int_raw         15 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT_RAW register 
#define DMAMUX_SOF_INT_RAW_M                (0xFFFFU)
#define DMAMUX_SOF_INT_RAW_S                (0U)


//********************************************************************************************
//
//! DMAMUX_SOF_INT      DMA MUX Overrun Exception Interrupt Status Register
//
//! Register Field             Field Range
//! reserved                   31 : 16
//! dmamux_sof_int             15 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT register 

#define DMAMUX_SOF_INT_M                    (0xFFFFU)
#define DMAMUX_SOF_INT_S                    (0U)


//********************************************************************************************
//
//! DMAMUX_SOF_INT_MASK     DMA MUX Overrun Exception Interrupt MASK Register
//
//! Register Field             Field Range
//! reserved                   31 : 16
//! dmamux_sof_int_mask        15 : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the SOF_INT MASK register 

#define DMAMUX_SOF_INT_MASK_M               (0xFFFFU)
#define DMAMUX_SOF_INT_MASK_S               (0U)


//********************************************************************************************
//
//! DMAMUX_OF_INT_RAW DMA MUX request generator interrupt Clear Register
//
//! Register Field             Field Range
//! reserved                   31 : 8
//! dmamux_of_int_raw           7 : 0
//!
//! The register is WC only. to obtain interrupt status by access the INT register.
//
//********************************************************************************************
// The following are defines for the bit fields in the OF_INT_RAW register 

#define DMAMUX_OF_INT_RAW_M                 (0xFFU)
#define DMAMUX_OF_INT_RAW_S                 (0U)


//********************************************************************************************
//
//! DMAMUX_OF_INT      DMA MUX request generator interrupt Status Register
//
//! Register Field             Field Range
//! reserved                   31 : 8
//! dmamux_of_int               7 : 0
//!
//! The register is RO only. to clear interrupt status by access the INT RAW register.
//
//********************************************************************************************
// The following are defines for the bit fields in the OF_INT register 

#define DMAMUX_OF_INT_M                     (0xFFU)
#define DMAMUX_OF_INT_S                     (0U)



//********************************************************************************************
//
//! DMAMUX_OF_INT_MASK     DMA MUX request generator interrupt MASK Register
//
//! Register Field             Field Range
//! reserved                   31 : 8
//! dmamux_of_int_mask          7 : 0
//
//********************************************************************************************
// The following are defines for the bit fields in the OF_INT MASK register 
    
#define DMAMUX_OF_INT_MASK_M                (0xFFU)
#define DMAMUX_OF_INT_MASK_S                (0U)


//********************************************************************************************
//
//! DMAMUX_OF_INT_MASK     DMA MUX flag of any interrupt MASK Register
//
//! Register Field             Field Range
//! reserved                   31 : 1
//! ovr_int                     0
//
//********************************************************************************************
// The following are defines for the bit fields in the OVR_INT_STATE register (RO)         
#define DMAMUX_OVR_INT                      BIT(0)


//********************************************************************************************
//
//! DMAMUX_OF_INT_MASK     DMA MUX software trigger Register
//
//! Register Field             Field Range
//! reserved                   31 : 1
//! soft_trig                   0
//
//********************************************************************************************
// The following are defines for the bit fields in the SOFT_TRIG register (W1SRO)         
#define DMAMUX_SOFT_TRIG                    BIT(0)

#endif /* #if (DMAMUX_VERSION == 0x20 || DMAMUX_VERSION == 0x11) */



#ifdef __cplusplus
}
#endif


#endif /* _HW_DMAMUX_H_ */

