/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 * hw_enc.h
 *
 *  Created on: 2025 0619
 *      Author: gs32-
 */

#ifndef DRIVERLIB_INC_HW_ENC_H_
#define DRIVERLIB_INC_HW_ENC_H_

#ifdef __cplusplus
extern "C"{
#endif

/*
 * @brief The following are defines for the ENC register offsets
 */
#define ENC_O_PULSE_GEN_CTRL          0x0	/*  */
#define ENC_O_PULSE_GEN_CNT0          0x4   /*  */
#define ENC_O_PULSE_GEN_CNT1          0x8   /*  */
#define ENC_O_PULSE_GEN_CNT2          0xC   /*  */
#define ENC_O_PULSE_GEN_CNT0_REF_RPT  0x10  /*  */
#define ENC_O_PULSE_GEN_CNT1_REF_RPT  0x14  /*  */
#define ENC_O_PULSE_GEN_CNT0_RPT      0x18  /*  */
#define ENC_O_PULSE_GEN_CNT1_RPT      0x1C  /*  */
#define ENC_O_PULSE_GEN_CNT2_RPT      0x20  /*  */

//QEPDIV
#define QEPDIV_CTRL				0x30
#define QEPDIV_DIVIDER			0x34
#define QEPDIV_INDEX_WIDTH		0x38

//ABS2QEP
#define ABS2QEP_CTRL			0x40
#define ABS2QEP_CNT0_REF		0x44
#define ABS2QEP_CNT1_REF		0x48
#define ABS2QEP_CNT2_REF		0x4C
#define ABS2QEP_CNT0_REF_RPT	0x50
#define ABS2QEP_CNT1_REF_RPT	0x54
#define ABS2QEP_CNT2_REF_RPT	0x58
#define ABS2QEP_CNT0_RPT		0x5C
#define ABS2QEP_CNT1_RPT		0x60
#define ABS2QEP_CNT2_RPT		0x64

#define ENC_O_TA_FORMAT_CTRL0         0x70  /* T/A-format Control0 Register */
#define ENC_O_TA_FORMAT_CTRL1         0x74  /* T/A-format Control1 Register */
#define ENC_O_TA_FORMAT_STATUS        0x78  /* T/A-format Status Register */
#define ENC_O_TA_FORMAT_TIMING0       0x7C  /* T/A-format Timing Delay0 Register */
#define ENC_O_TA_FORMAT_TIMING1       0x80  /* T/A-format Timing Delay1 Register */
#define ENC_O_TA_FORMAT_TIMING2       0x84  /* T/A-format Timing Delay2 Register */

#define ENC_O_BISS_CTRL               0x90  /* BISS/SSI Format Control Register */
#define ENC_O_BISS_SPI_CRG            0x94  /* BISS/SSI Format SPI Clock Register*/
#define ENC_O_BISS_TIMING0            0x98  /* BISS/SSI Format Timing Delay0 Register */
#define ENC_O_BISS_TIMING1            0x9C  /* BISS/SSI Format Timing Delay1 Register */
#define ENC_O_BISS_STATUS             0xA0  /* BISS/SSI Format Status Register */

#define ENC_O_ENDAT_CTRL0             0xB0  /* ENDAT Format Control0 Register */
#define ENC_O_ENDAT_CTRL1             0xB4  /* ENDAT Format Control1 Register */
#define ENC_O_ENDAT_SPI_CFG           0xB8  /* ENDAT Format SPI Clock Number Register */
#define ENC_O_ENDAT_TIMING0           0xBC  /* ENDAT Format Timing Delay0 Register */
#define ENC_O_ENDAT_TIMING1           0xD0  /* ENDAT Format Timing Delay1 Register */
#define ENC_O_ENDAT_STATUS            0xD4  /* ENDAT Format Status Register */

#define ENC_O_ENC_OUTPUT_EN           0xE0  /* ENC Clock override SPI Clock Register */
#define ENC_O_ENC_INTR_RAW            0xF0  /* ENC Raw Interrupt Register */
#define ENC_O_ENC_INTR_MASK           0xF4  /* ENC Interrupt Mask Register */
#define ENC_O_ENC_INTR                0xF8  /* ENC Interrupt Register */
#define ENC_O_ENC_LOCK                0x100 /* ENC Lock Register Register */

#define ENC_O_PARA_ICG_BYPASS         0x104
#define ENC_O_CLB_CNT_POS_EN          0x108
#define ENC_O_ENC_BISS_CTRL           0x10C
#define ENC_O_ENC_RESERVED_PARA       0x110
#define ENC_O_CLB_STATE_SEL           0x114

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CTRL register
 */
#define ENC_APB_CFG_PULSE_GEN_M				0x1
#define ENC_APB_CFG_PULSE_GEN_S				0U
#define ENC_APB_CFG_PULSE_GEN_RUN_STOP_M	0x2
#define ENC_APB_CFG_PULSE_GEN_RUN_STOP_S	1U
#define ENC_APB_CFG_PULSE_GEN_DIRECTION_M	0x4
#define ENC_APB_CFG_PULSE_GEN_DIRECTION_S	2U
#define ENC_APB_CFG_PULSE_GEN_IN_SEL_M		0x1F
#define ENC_APB_CFG_PULSE_GEN_IN_SEL_S		8U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT0 register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT1 register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT2 register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT0_REF_RPT register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_RPT_M 0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT1_REF_RPT register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_RPT_M 0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT0_RPT register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT0_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_RPT_S	0U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT1_RPT register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT1_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_RPT_S	0U

/*
 * @brief The following are defines for the bit fields in the PULSE_GEN_CNT2_RPT register
 */
#define ENC_APB_CFG_PULSE_GEN_CNT2_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT2_RPT_S	0U

/*
 * @brief The following are defines for the bit fields in the QEPDIV_CTRL register
 */
#define ENC_APB_CFG_QEPDIV_EN_M		0x1
#define ENC_APB_CFG_QEPDIV_EN_S		0U
#define ENC_APB_CFG_QPEDIV_A_SEL_M	0xF0
#define ENC_APB_CFG_QPEDIV_A_SEL_S	4U
#define ENC_APB_CFG_QPEDIV_B_SEL_M	0xF00
#define ENC_APB_CFG_QPEDIV_B_SEL_S	8U
#define ENC_APB_CFG_QPEDIV_I_SEL_M	0xF000
#define ENC_APB_CFG_QPEDIV_I_SEL_S	12U

/*
 * @brief The following are defines for the bit fields in the QEPDIV_DIVIDER register
 */
#define ENC_APB_CFG_QEPDIV_DIVIDER_M		0xFFFFFFFF

/*
 * @brief The following are defines for the bit fields in the QEPDIV_INDEX_WIDTH register
 */
#define ENC_APB_CFG_QEPDIV_INDEX_WIDTH_M	0xFFFFFFFF

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CTRL register
 */
#define ENC_APB_CFG_ABS2QEP_EN_M			0x1
#define ENC_APB_CFG_ABS2QEP_EN_S			0U
#define ENC_APB_CFG_ABS2QEP_DIRECTION_M		0x2
#define ENC_APB_CFG_ABS2QEP_DIRECTION_S		1U
#define ENC_APB_CFG_ABS2QEP_STATE_M			0x8
#define ENC_APB_CFG_ABS2QEP_STATE_S			4U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT0_REF register
 */
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT1_REF register
 */
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT2_REF register
 */
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT0_REF_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_RPT_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT1_REF_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT2_REF_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_RPT_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT0_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT0_RPT	0xFFFF

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT1_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT1_RPT	0xFFFF

/*
 * @brief The following are defines for the bit fields in the ABS2QEP_CNT2_RPT register
 */
#define ENC_APB_CFG_ABS2QEP_CNT2_RPT	0xFFFF

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_CTRL0 register
 */
#define ENC_TA_FORMAT_CTRL0_EN_M				0x00000001U /* T/A-format Module Enable. */
#define ENC_TA_FORMAT_CTRL0_EN_S				0U
#define ENC_TA_FORMAT_CTRL0_FORMAT_M			0x00000002U /* T/A-format Selection. */
#define ENC_TA_FORMAT_CTRL0_FORMAT_S			1U
#define ENC_TA_FORMAT_CTRL0_RCV_MODE_M			0x00000004U /* T/A-format Trigger RX Clock
															   Mode selection. */
#define ENC_TA_FORMAT_CTRL0_RCV_MODE_S			2U
#define ENC_TA_FORMAT_CTRL0_RXD_IN_SEL_M		0x0000F000U /* T/A-format Data Entry Channel
															   Selection. */
#define ENC_TA_FORMAT_CTRL0_RXD_IN_SEL_S		12U
#define ENC_TA_FORMAT_CTRL0_BAUDRATE_M			0x00FF0000U /* T/A-format Baud Rate. */
#define ENC_TA_FORMAT_CTRL0_BAUDRATE_S			16U

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_CTRL1 register
 */
#define ENC_TA_FORMAT_CTRL1_RX_FRM_LEN_M		0x000000FFU	 /* T/A-format RX One Frame Size */
#define ENC_TA_FORMAT_CTRL1_RX_FRM_LEN_S		0U
#define ENC_TA_FORMAT_CTRL1_TX_FRM_LEN_M		0x0000FF00U  /* T/A-format TX One Frame Size */
#define ENC_TA_FORMAT_CTRL1_TX_FRM_LEN_S		8U
#define ENC_TA_FORMAT_CTRL1_TXRX_FRM_M		0x0000FFFFU
#define ENC_TA_FORMAT_CTRL1_RX_FRM_NUM_M		0x00F000000U /* T/A-format RX Frame Count */
#define ENC_TA_FORMAT_CTRL1_RX_FRM_NUM_S		24U
#define ENC_TA_FORMAT_CTRL1_TX_FRM_NUM_M		0x0F0000000U /* T/A-format TX Frame Count */
#define ENC_TA_FORMAT_CTRL1_TX_FRM_NUM_S		28U

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_STATUS register
 */
#define ENC_TA_FORMAT_STATUS_STATE_M			0x00000007U /* T/A-format Status */
#define ENC_TA_FORMAT_STATUS_STATE_S			0U
#define ENC_TA_FORMAT_STATUS_WAIT_TIME_RPT_M	0XFFFF0000U /* T/A-format Wait Time */
#define ENC_TA_FORMAT_STATUS_WAIT_TIME_RPT_S	16U

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_TIMING0 register
 */
#define ENC_TA_FORMAT_TIMING0_T2_CFG_M	0x0000FFFFU	/* T/A-format The Delay Time Before
														   Sending The Frame */
#define ENC_TA_FORMAT_TIMING0_T2_CFG_S	0U
#define ENC_TA_FORMAT_TIMING0_T3_CFG_M	0xFFFF0000U /* T/A-format The Delay Time After
														   Sending The Frame */
#define ENC_TA_FORMAT_TIMING0_T3_CFG_S	16U

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_TIMING1 register
 */
#define ENC_TA_FORMAT_TIMING1_T4_CFG_M	0x0000FFFFU /* T/A-format The Delay Time Between
														   Sending Frames*/
#define ENC_TA_FORMAT_TIMING1_T4_CFG_S	0U
#define ENC_TA_FORMAT_TIMING1_T5_CFG_M	0xFFFF0000U /* T/A-format The Delay From The End
 	 	 	 	 	 	 	 	 	 	 	 	 	 	   of The Sent Frame to The Arrival of
 	 	 	 	 	 	 	 	 	 	 	 	 	 	   The Received Frame*/
#define ENC_TA_FORMAT_TIMING1_T5_CFG_S	16U

/*
 * @brief The following are defines for the bit fields in the TA_FORMAT_TIMING2 register
 */
#define ENC_TA_FORMAT_TIMING2_T6_CFG_M	0x0000FFFFU /* T/A-format Receiving Frame Time */
#define ENC_TA_FORMAT_TIMING2_T6_CFG_S	0U
#define ENC_TA_FORMAT_TIMING2_T9_CFG_M	0xFFFF0000U /* T/A-format Delay After Receiving
														   The Frame */
#define ENC_TA_FORMAT_TIMING2_T9_CFG_S	16U

/*
 * @brief The following are defines for the bit fields in the BISS_CTRL register
 */
#define ENC_BISS_CTRL_EN_M					0x1
#define ENC_BISS_CTRL_EN_S					0U
#define ENC_BISS_CTRL_SSI_MODE_M			0x2
#define ENC_BISS_CTRL_SSI_MODE_S			1U
#define ENC_BISS_CTRL_RCV_MODE_M			0x4
#define ENC_BISS_CTRL_RCV_MODE_S			2U
#define ENC_BISS_CTRL_CDM_BIT_M				0x8
#define ENC_BISS_CTRL_CDM_BIT_S				3U
#define ENC_BISS_CTRL_SL_IN_SEL_M			0xF0
#define ENC_BISS_CTRL_SL_IN_SEL_S			4U
#define ENC_BISS_CTRL_BAUDRATE_M			0xFFFF00
#define ENC_BISS_CTRL_BAUDRATE_S			8U
#define ENC_BISS_CTRL_TIMEOUT_MODE_M		0xFF000000
#define ENC_BISS_CTRL_RX_TIMEOUT_MODE_S		24U

/*
 * @brief The following are defines for the bit fields in the BISS_SPI_CRG register
 */
#define ENC_BISS_SPI_CRG_SPI_BIT_NUM_M		0xFF
#define ENC_BISS_SPI_CRG_SPI_BIT_NUM_S		0U
#define ENC_BISS_SPI_CRG_RX_BIT_NUM_M		0x0000FF00U
#define ENC_BISS_SPI_CRG_RX_BIT_NUM_S		8U

/*
 * @brief The following are defines for the bit fields in the BISS_TIMING0 register
 */
#define ENC_BISS_TDLY_CFG_M			0xFFFF
#define ENC_BISS_TDLY_CFG_S			0U
#define ENC_BISS_TCAL_CFG_M			0xFFFF0000
#define ENC_BISS_TCAL_CFG_S			16U

/*
 * @brief The following are defines for the bit fields in the BISS_TIMING1 register
 */
#define ENC_BISS_TR_CFG_M			0xFFFF
#define ENC_BISS_TR_CFG_S			0

/*
 * @brief The following are defines for the bit fields in the BISS_STATUS register
 */
#define ENC_BISS_STATE_M			0x7
#define ENC_BISS_STATE_S			0
#define ENC_BISS_WAIT_TIME_RPT_M	0xFFFF0000
#define ENC_BISS_WAIT_TIME_RPT_S	16

/*
 * @brief The following are defines for the bit fields in the ENDAT_CTRL0 register
 */
#define ENC_ENDAT_CTRL0_ENDAT_EN_M		0x1
#define ENC_ENDAT_CTRL0_ENDAT_EN_s		0
#define ENC_ENDAT_CTRL0_RCV_MODE_M		0x2
#define ENC_ENDAT_CTRL0_RCV_MODE_S		1
#define ENC_ENDAT_CTRL0_RXD_IN_SEL_M	0xF
#define ENC_ENDAT_CTRL0_RXD_IN_SEL_S	4
#define ENC_ENDAT_CTRL0_BAUDRATE_M		0xFFFF0000
#define ENC_ENDAT_CTRL0_BAUDRATE_S		16

/*
 * @brief The following are defines for the bit fields in the ENDAT_CTRL1 register
 */
#define ENC_ENDAT_CTRL1_ENDAT_TX_BIT_NUM_M	0xFF
#define ENC_ENDAT_CTRL1_ENDAT_TX_BIT_NUM_S	0
#define ENC_ENDAT_CTRL1_ENDAT_RX_BIT_NUM_M	0xFF00
#define ENC_ENDAT_CTRL1_ENDAT_RX_BIT_NUM_S	8
#define ENC_ENDAT_CTRL1_ENDAT_ADD_BIT_NUM_M	0xFF0000
#define ENC_ENDAT_CTRL1_ENDAT_ADD_BIT_NUM_S	16

/*
 * @brief The following are defines for the bit fields in the ENDAT_SPI_CFG register
 */
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_TX_BIT_NUM_M	0xFF
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_TX_BIT_NUM_S	0
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_RX_BIT_NUM_M	0xFF00
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_RX_BIT_NUM_S	8
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_ADD_BIT_NUM_M	0xFF0000
#define ENC_ENDAT_SPI_CFG_ENDAT_SPI_ADD_BIT_NUM_S	16

/*
 * @brief The following are defines for the bit fields in the ENDAT_TIMING0 register
 */
#define ENC_ENDAT_TIMING0_TDLY_CFG_M		0xFFFF
#define ENC_ENDAT_TIMING0_TDLY_CFG_S		0
#define ENC_ENDAT_TIMING0_ST_CFG_M			0xFFFF0000
#define ENC_ENDAT_TIMING0_ST_CFG_S			16

/*
 * @brief The following are defines for the bit fields in the ENDAT_TIMING1 register
 */
#define ENC_ENDAT_TIMING1_TR_CFG_M			0xFFFF
#define ENC_ENDAT_TIMING1_TR_CFG_S			0
#define ENC_ENDAT_TIMING1_TADD_CFG_M		0xFFFF0000
#define ENC_ENDAT_TIMING1_TADD_CFG_S		16

/*
 * @brief The following are defines for the bit fields in the ENDAT_STATUS register
 */
#define ENC_ENDAT_STATE_M			0x7
#define ENC_ENDAT_STATE_S			0
#define ENC_ENDAT_WAIT_TIME_RPT_M	0xFFFF0000
#define ENC_ENDAT_WAIT_TIME_RPT_S	16

/*
 * @brief The following are defines for the bit fields in the ENC_OUTPUT_EN register
 */
#define ENC_ENC_OUTPUT_EN_ENC_SPI_CLK_EN	0x00000001U	/* ENC Clock Override SPI Clock*/

/*
 * @brief The following are defines for the bit fields in the ENC_INTR_RAW register
 */
#define ENC_PULSE_GEN_EVT0_INTR_RAW		0x1
#define ENC_PULSE_GEN_EVT0_INTR_RAW_S	0
#define ENC_PULSE_GEN_EVT1_INTR_RAW		0x2
#define ENC_PULSE_GEN_EVT1_INTR_RAW_S	1
#define ENC_ABS2QEP_PTO_DONE_INTR_RAW	0x4
#define ENC_ABS2QEP_PTO_DONE_INTR_RAW_S	2

/*
 * @brief The following are defines for the bit fields in the ENC_INTR_MASK register
 */
#define ENC_PULSE_GEN_EVT0_INTR_MASK		0x1
#define ENC_PULSE_GEN_EVT0_INTR_MASK_S		0
#define ENC_PULSE_GEN_EVT1_INTR_MASK		0x2
#define ENC_PULSE_GEN_EVT1_INTR_MASK_S		1
#define ENC_ABS2QEP_PTO_DONE_INTR_MASK	0x4
#define ENC_ABS2QEP_PTO_DONE_INTR_MASK_S	2

/*
 * @brief The following are defines for the bit fields in the ENC_INTR register
 */
#define ENC_PULSE_GEN_EVT0_INTR		0x1
#define ENC_PULSE_GEN_EVT0_INTR_S	0
#define ENC_PULSE_GEN_EVT1_INTR		0x2
#define ENC_PULSE_GEN_EVT1_INTR_S	1
#define ENC_ABS2QEP_PTO_DONE_INTR	0x4
#define ENC_ABS2QEP_PTO_DONE_INTR_S	2

/*
 * @brief The following are defines for the bit fields in the ENC_INTR register
#define ENC_ENC_LOCK	0x5A5A5A5A

/*
 * @brief The following are defines for the bit fields in the PARA_ICG_BYPASS register
 */
#define ENC_PARA_ICG_BYPASS_M	0x1
#define ENC_PARA_ICG_BYPASS_S	0

/*
 * @brief The following are defines for the bit fields in the PARA_ICG_BYPASS register
 */

#ifdef __cplusplus
}
#endif


#endif /* DRIVERLIB_INC_HW_ENC_H_ */
