/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_apb.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_HW_ENCODER_H_
#define DEVICE_HW_ENCODER_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the enc_apb_cfg register offsets

//PULSE
#define PULSE_GEN_CTRL			0x00
#define PULSE_GEN_CNT0			0x04
#define PULSE_GEN_CNT1			0x08
#define PULSE_GEN_CNT2			0x0C
#define PULSE_GEN_CNT0_REF_RPT	0x10
#define PULSE_GEN_CNT1_REF_RPT	0x14
#define PULSE_GEN_CNT0_RPT		0x18
#define PULSE_GEN_CNT1_RPT		0X1c
#define PULSE_GEN_CNT2_RPT		0X20

//QEPDIV
#define QEPDIV_CTRL				0x30
#define QEPDIV_DIVIDER			0x34
#define QEPDIV_INDEX_WIDTH		0x38

//ABS2QEP
#define ABS2QEP_CTRL			0x40
#define ABS2QEP_CNT0_REF		0x44
#define ABS2QEP_CNT1_REF		0x48
#define ABS2QEP_CNT2_REF		0x4C
#define ABS2QEP_CNT0_REF_RPT	0x50
#define ABS2QEP_CNT1_REF_RPT	0x54
#define ABS2QEP_CNT2_REF_RPT	0x58
#define ABS2QEP_CNT0_RPT		0x5C
#define ABS2QEP_CNT1_RPT		0x60
#define ABS2QEP_CNT2_RPT		0x64

//TA_FORMAT
#define TA_FORMAT_CTRL0			0x70
#define TA_FORMAT_CTRL1			0x74
#define TA_FORMAT_STATUS		0x78
#define TA_FORMAT_TIMING0		0x7C
#define TA_FORMAT_TIMING1		0x80
#define TA_FORMAT_TIMING2		0x84

//BISS
#define	BISS_CTRL				0x90
#define BISS_SPI_CRG			0x94
#define BISS_TIMING0			0x98
#define BISS_TIMING1			0x9C
#define BISS_STATUS				0xa0

//ENDAT
#define ENDAT_CTRL0				0xb0
#define ENDAT_CTRL1				0xb4
#define ENDAT_SPI_CFG			0xb8
#define ENDAT_TIMING0			0xbc
#define ENDAT_TIMING1			0xd0
#define ENDAT_STATUS			0xd4

//command
#define ENC_INTR_RAW			0xf0
#define ENC_INTR_MASK			0xf4
#define ENC_INTR				0xf8
#define	ENC_LOCK				0x100
#define	PARA_ICG_BYPASS			0x104


//***********************************PULSE*****************************************//
// The following are defines for the bit fields in the PULSE_GEN_CTRL register 
#define ENC_APB_CFG_PULSE_GEN_M				0x1
#define ENC_APB_CFG_PULSE_GEN_S				0U
#define ENC_APB_CFG_PULSE_GEN_RUN_STOP_M	0x2
#define ENC_APB_CFG_PULSE_GEN_RUN_STOP_S	1U
#define ENC_APB_CFG_PULSE_GEN_DIRECTION_M	0x4
#define ENC_APB_CFG_PULSE_GEN_DIRECTION_S	2U
#define ENC_APB_CFG_PULSE_GEN_IN_SEL_M		0x1F
#define ENC_APB_CFG_PULSE_GEN_IN_SEL_S		8U

// The following are defines for the bit fields in the PULSE_GEN_CNT0 register 
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_S	16U

// The following are defines for the bit fields in the PULSE_GEN_CNT1 register 
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_S	16U

// The following are defines for the bit fields in the PULSE_GEN_CNT2 register 
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH1_REF_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT2_MATCH2_REF_S	16U

// The following are defines for the bit fields in the PULSE_GEN_CNT0_REF_RPT register 
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_RPT_M 0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT0_MATCH2_REF_RPT_S	16U

// The following are defines for the bit fields in the PULSE_GEN_CNT1_REF_RPT register 
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_RPT_M 0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_PULSE_GEN_CNT1_MATCH2_REF_RPT_S	16U

// The following are defines for the bit fields in the PULSE_GEN_CNT0_RPT register 
#define ENC_APB_CFG_PULSE_GEN_CNT0_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT0_RPT_S	0U

// The following are defines for the bit fields in the PULSE_GEN_CNT1_RPT register 
#define ENC_APB_CFG_PULSE_GEN_CNT1_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT1_RPT_S	0U

// The following are defines for the bit fields in the PULSE_GEN_CNT2_RPT register 
#define ENC_APB_CFG_PULSE_GEN_CNT2_RPT_M	0xFFFF
#define ENC_APB_CFG_PULSE_GEN_CNT2_RPT_S	0U

//**********************************QEPDIV*****************************************//
// The following are defines for the bit fields in the QEPDIV_CTRL register 
#define ENC_APB_CFG_QEPDIV_EN_M		0x1
#define ENC_APB_CFG_QEPDIV_EN_S		0U
#define ENC_APB_CFG_QPEDIV_A_SEL_M	0xF0
#define ENC_APB_CFG_QPEDIV_A_SEL_S	4U
#define ENC_APB_CFG_QPEDIV_B_SEL_M	0xF00
#define ENC_APB_CFG_QPEDIV_B_SEL_S	8U
#define ENC_APB_CFG_QPEDIV_I_SEL_M	0xF000
#define ENC_APB_CFG_QPEDIV_I_SEL_S	12U

// The following are defines for the bit fields in the QEPDIV_DIVIDER register 
#define ENC_APB_CFG_QEPDIV_DIVIDER_M		0xFFFFFFFF

// The following are defines for the bit fields in the QEPDIV_INDEX_WIDTH register
#define ENC_APB_CFG_QEPDIV_INDEX_WIDTH_M	0xFFFFFFFF

//**********************************ABS2QEP****************************************//
// The following are defines for the bit fields in the ABS2QEP_CTRL register
#define ENC_APB_CFG_ABS2QEP_EN_M			0x1
#define ENC_APB_CFG_ABS2QEP_EN_S			0U
#define ENC_APB_CFG_ABS2QEP_DIRECTION_M		0x2
#define ENC_APB_CFG_ABS2QEP_DIRECTION_S		1U
#define ENC_APB_CFG_ABS2QEP_STATE_M			0x8
#define ENC_APB_CFG_ABS2QEP_STATE_S			4U

// The following are defines for the bit fields in the ABS2QEP_CNT0_REF register
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT1_REF register
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT2_REF register
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT0_REF_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_RPT_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT0_MATCH2_REF_RPT_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT1_REF_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT1_MATCH2_REF_RPT_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT2_REF_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_RPT_M	0xFFFF
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH1_REF_RPT_S	0U
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ABS2QEP_CNT2_MATCH2_REF_RPT_S	16U

// The following are defines for the bit fields in the ABS2QEP_CNT0_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT0_RPT	0xFFFF

// The following are defines for the bit fields in the ABS2QEP_CNT1_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT1_RPT	0xFFFF

// The following are defines for the bit fields in the ABS2QEP_CNT2_RPT register
#define ENC_APB_CFG_ABS2QEP_CNT2_RPT	0xFFFF

//****************************TA_FORMAT********************************************//
// The following are defines for the bit fields in the TA_FORMAT_CTRL0 register
#define ENC_APB_CFG_TA_EN_M				0x1
#define ENC_APB_CFG_TA_EN_S				0U
#define ENC_APB_CFG_TA_FORMAT_M			0x2
#define ENC_APB_CFG_TA_FORMAT_S			1U
#define ENC_APB_CFG_TA_RCV_MODE_M		0x4
#define ENC_APB_CFG_TA_RCV_MODE_S		2U
#define ENC_APB_CFG_TA_RXD_IN_SEL_M		0xF000
#define ENC_APB_CFG_TA_RXD_IN_SEL_S		12U
#define ENC_APB_CFG_TA_BAUDRATE_M		0xFF0000
#define ENC_APB_CFG_TA_BAUDRATE_S		16U

// The following are defines for the bit fields in the TA_FORMAT_CTRL1 register
#define ENC_APB_CFG_TA_TX_FRM_NUM_M		0xF0000000
#define ENC_APB_CFG_TA_TX_FRM_NUM_S		28U
#define ENC_APB_CFG_TA_RX_FRM_NUM_M		0xF000000
#define ENC_APB_CFG_TA_RX_FRM_NUM_S		24U
#define ENC_APB_CFG_TA_TX_FRM_LEN_M		0xFF00
#define ENC_APB_CFG_TA_TX_FRM_LEN_S		8U
#define ENC_APB_CFG_TA_RX_FRM_LEN_M		0xFF
#define ENC_APB_CFG_TA_RX_FRM_LEN_S		0U

// The following are defines for the bit fields in the TA_FORMAT_STATUS register
#define ENC_APB_CFG_TA_STATE_M			0x7
#define ENC_APB_CFG_TA_STATE_S			0U
#define ENC_APB_CFG_TA_WAIT_TIME_RPT_M	0XFFFF0000
#define ENC_APB_CFG_TA_WAIT_TIME_RPT_S	16U

// The following are defines for the bit fields in the TA_FORMAT_TIMING0 register
#define ENC_APB_CFG_TA_T2_CFG_M			0xFFFF
#define ENC_APB_CFG_TA_T2_CFG_S			0U
#define ENC_APB_CFG_TA_T3_CFG_M			0xFFFF0000
#define ENC_APB_CFG_TA_T3_CFG_S			16U

// The following are defines for the bit fields in the TA_FORMAT_TIMING1 register
#define ENC_APB_CFG_TA_T4_CFG_M			0xFFFF
#define ENC_APB_CFG_TA_T4_CFG_S			0U
#define ENC_APB_CFG_TA_T5_CFG_M			0xFFFF0000
#define ENC_APB_CFG_TA_T5_CFG_S			16U

// The following are defines for the bit fields in the TA_FORMAT_TIMING2 register
#define ENC_APB_CFG_TA_T6_CFG_M			0xFFFF
#define ENC_APB_CFG_TA_T6_CFG_S			0U
#define ENC_APB_CFG_TA_T9_CFG_M			0xFFFF0000
#define ENC_APB_CFG_TA_T9_CFG_S			16U

//***************************BISS**************************************************//
// The following are defines for the bit fields in the BISS_CTRL register
#define ENC_APB_CFG_BISS_EN_M				0x1
#define ENC_APB_CFG_BISS_EN_S				0U
#define ENC_APB_CFG_BISS_SSI_MODE_M			0x2
#define ENC_APB_CFG_BISS_SSI_MODE_S			1U
#define ENC_APB_CFG_BISS_RCV_MODE_M			0x4
#define ENC_APB_CFG_BISS_RCV_MODE_S			2U
#define ENC_APB_CFG_BISS_CDM_BIT_M			0x8
#define ENC_APB_CFG_BISS_CDM_BIT_S			3U
#define ENC_APB_CFG_BISS_SL_IN_SEL_M		0xF0
#define ENC_APB_CFG_BISS_SL_IN_SEL_S		4U
#define ENC_APB_CFG_BISS_BAUDRATE_M			0xFFFF00
#define ENC_APB_CFG_BISS_BAUDRATE_S			8U
#define ENC_APB_CFG_BISS_RX_BIT_NUM_M		0xFF000000
#define ENC_APB_CFG_BISS_RX_BIT_NUM_S		24U

// The following are defines for the bit fields in the BISS_SPI_CRG register
#define ENC_APB_CFG_BISS_SPI_BIT_NUM_M		0xFF
#define ENC_APB_CFG_BISS_SPI_BIT_NUM_S		0U

// The following are defines for the bit fields in the BISS_TIMING0 register
#define ENC_APB_CFG_BISS_TDLY_CFG_M			0xFFFF
#define ENC_APB_CFG_BISS_TDLY_CFG_S			0U
#define ENC_APB_CFG_BISS_TCAL_CFG_M			0xFFFF0000
#define ENC_APB_CFG_BISS_TCAL_CFG_S			16U

// The following are defines for the bit fields in the BISS_TIMING1 register
#define ENC_APB_CFG_BISS_TR_CFG_M			0xFFFF
#define ENC_APB_CFG_BISS_TR_CFG_S			0

// The following are defines for the bit fields in the BISS_STATUS register
#define ENC_APB_CFG_BISS_STATE_M			0x7
#define ENC_APB_CFG_BISS_STATE_S			0
#define ENC_APB_CFG_BISS_WAIT_TIME_RPT_M	0xFFFF0000
#define ENC_APB_CFG_BISS_WAIT_TIME_RPT_S	16

//***************************ENDAT************************************************//
// The following are defines for the bit fields in the ENDAT_CTRL0 register
#define ENC_APB_CFG_ENDAT_CTRL0_ENDAT_EN_M		0x1
#define ENC_APB_CFG_ENDAT_CTRL0_ENDAT_EN_s		0
#define ENC_APB_CFG_ENDAT_CTRL0_RCV_MODE_M		0x2
#define ENC_APB_CFG_ENDAT_CTRL0_RCV_MODE_S		1
#define ENC_APB_CFG_ENDAT_CTRL0_RXD_IN_SEL_M	0xF
#define ENC_APB_CFG_ENDAT_CTRL0_RXD_IN_SEL_S	4
#define ENC_APB_CFG_ENDAT_CTRL0_BAUDRATE_M		0xFFFF0000
#define ENC_APB_CFG_ENDAT_CTRL0_BAUDRATE_S		16

// The following are defines for the bit fields in the ENDAT_CTRL1 register
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_TX_BIT_NUM_M	0xFF
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_TX_BIT_NUM_S	0
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_RX_BIT_NUM_M	0xFF00
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_RX_BIT_NUM_S	8
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_ADD_BIT_NUM_M	0xFF0000
#define ENC_APB_CFG_ENDAT_CTRL1_ENDAT_ADD_BIT_NUM_S	16

// The following are defines for the bit fields in the ENDAT_SPI_CFG register
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_TX_BIT_NUM_M	0xFF
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_TX_BIT_NUM_S	0
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_RX_BIT_NUM_M	0xFF00
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_RX_BIT_NUM_S	8
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_ADD_BIT_NUM_M	0xFF0000
#define ENC_APB_CFG_ENDAT_SPI_CFG_ENDAT_SPI_ADD_BIT_NUM_S	16

// The following are defines for the bit fields in the ENDAT_TIMING0 register
#define ENC_APB_CFG_ENDAT_TIMING0_TDLY_CFG_M		0xFFFF
#define ENC_APB_CFG_ENDAT_TIMING0_TDLY_CFG_S		0
#define ENC_APB_CFG_ENDAT_TIMING0_ST_CFG_M			0xFFFF0000
#define ENC_APB_CFG_ENDAT_TIMING0_ST_CFG_S			16

// The following are defines for the bit fields in the ENDAT_TIMING1 register
#define ENC_APB_CFG_ENDAT_TIMING1_TR_CFG_M			0xFFFF
#define ENC_APB_CFG_ENDAT_TIMING1_TR_CFG_S			0
#define ENC_APB_CFG_ENDAT_TIMING1_TADD_CFG_M		0xFFFF0000
#define ENC_APB_CFG_ENDAT_TIMING1_TADD_CFG_S		16

// The following are defines for the bit fields in the ENDAT_STATUS register
#define ENC_APB_CFG_ENDAT_STATE_M			0x7
#define ENC_APB_CFG_ENDAT_STATE_S			0
#define ENC_APB_CFG_ENDAT_WAIT_TIME_RPT_M	0xFFFF0000
#define ENC_APB_CFG_ENDAT_WAIT_TIME_RPT_S	16

//***************************COMMAND**********************************************//
// The following are defines for the bit fields in the ENC_INTR_RAW register
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR_RAW		0x1
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR_RAW_S	0
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR_RAW		0x2
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR_RAW_S	1
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR_RAW	0x4
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR_RAW_S	2

// The following are defines for the bit fields in the ENC_INTR_MASK register
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR_MASK		0x1
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR_MASK_S		0
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR_MASK		0x2
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR_MASK_S		1
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR_MASK	0x4
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR_MASK_S	2

// The following are defines for the bit fields in the ENC_INTR register
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR		0x1
#define ENC_APB_CFG_PULSE_GEN_EVT0_INTR_S	0
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR		0x2
#define ENC_APB_CFG_PULSE_GEN_EVT1_INTR_S	1
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR	0x4
#define ENC_APB_CFG_ABS2QEP_PTO_DONE_INTR_S	2

// The following are defines for the bit fields in the ENC_INTR register
#define ENC_APB_CFG_ENC_LOCK	0x5A5A5A5A

// The following are defines for the bit fields in the PARA_ICG_BYPASS register
#define ENC_APB_CFG_PARA_ICG_BYPASS_M	0x1
#define ENC_APB_CFG_PARA_ICG_BYPASS_S	0



#ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_SYSCTL_APB_H_ */
