/*

 *
 */


/**
*   @file    hw_erad.h
*   @brief   Definitions for the ERAD registers.
*
*/

#ifndef DEVICE_HW_ERAD_H_
#define DEVICE_HW_ERAD_H_

#include "inc/hw_types.h"

#ifdef __cplusplus
extern "C"{
#endif

//*************************************************************************************************
//
// The following are defines for the ERAD register offsets
//
//*************************************************************************************************
#define ERAD_O_GLBL_EVENT_STAT   0x0U   // Global Event Status Register
#define ERAD_O_GLBL_HALT_STAT    0x4U   // Global Halt Status Register
#define ERAD_O_GLBL_ENABLE       0x8U   // Global Enable Register
#define ERAD_O_GLBL_CTM_RESET    0xcU   // Global Counter Reset
//#define ERAD_O_GLBL_OWNER        0xAU   // Global Ownership

#define ERAD_O_HWBP_MASK     0x0U    // HWBP (EBC) Addr Mask Register
#define ERAD_O_HWBP_REF      0x4U    // HWBP (EBC) Addr Reference Register
#define ERAD_O_HWBP_CLEAR    0x8U   // HWBP (EBC) Clear Register
#define ERAD_O_HWBP_CNTL     0xcU   // HWBP (EBC) Control Register
#define ERAD_O_HWBP_STATUS   0xeU   // HWBP (EBC) Status Register

#define ERAD_O_CTM_CNTL          0x0U    // Counter Control Register
#define ERAD_O_CTM_STATUS        0x2U    // Counter Status Register
#define ERAD_O_CTM_REF           0x4U    // Counter Reference Register
#define ERAD_O_CTM_COUNT         0x8U    // Counter Current Value Register
#define ERAD_O_CTM_MAX_COUNT     0xcU   // Counter Max Count Value Register
#define ERAD_O_CTM_MIN_COUNT     0x18U   // Counter Min Count Value Register
#define ERAD_O_CTM_INPUT_CSSEL   0x10U   // Counter Input Select Register
#define ERAD_O_CTM_CLEAR         0x12U   // Counter Clear Register
#define ERAD_O_CTM_INPUT_ERSEL   0x14U   // Counter Input Select Register


//*************************************************************************************************
//
// The following are defines for the bit fields in the GLBL_EVENT_STAT register
//
//*************************************************************************************************
#define ERAD_GLBL_EVENT_STAT_HWBP1   0x0U     // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_HWBP2   0x1U     // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_HWBP3   0x2U     // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_HWBP4   0x3U     // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_HWBP5   0x4U    // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_HWBP6   0x5U    // Enhanced Bus Comparator (EBC) Module Event Status
#define ERAD_GLBL_EVENT_STAT_CTM1    0x6U   // Counter Module Event Status
#define ERAD_GLBL_EVENT_STAT_CTM2    0x7U   // Counter Module Event Status
#define ERAD_GLBL_EVENT_STAT_CTM3    0x8U   // Counter Module Event Status
#define ERAD_GLBL_EVENT_STAT_CTM4    0x9U   // Counter Module Event Status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GLBL_HALT_STAT register
//
//*************************************************************************************************
#define ERAD_GLBL_HALT_STAT_HWBP1   0x0U     // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_HWBP2   0x1U     // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_HWBP3   0x2U     // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_HWBP4   0x3U     // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_HWBP5   0x4U    // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_HWBP6   0x5U    // Enhanced Bus Comparator (EBC) Module Halt Status
#define ERAD_GLBL_HALT_STAT_CTM1    0x6U   // Counter Module Halt Status
#define ERAD_GLBL_HALT_STAT_CTM2    0x7U   // Counter Module Halt Status
#define ERAD_GLBL_HALT_STAT_CTM3    0x8U   // Counter Module Halt Status
#define ERAD_GLBL_HALT_STAT_CTM4    0x9U   // Counter Module Halt Status

//*************************************************************************************************
//
// The following are defines for the bit fields in the GLBL_ENABLE register
//
//*************************************************************************************************
#define ERAD_GLBL_ENABLE_HWBP1   0x0U     // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_HWBP2   0x1U     // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_HWBP3   0x2U     // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_HWBP4   0x3U     // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_HWBP5   0x4U    // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_HWBP6   0x5U    // Enhanced Bus Comparator (EBC) Module Global Enable
#define ERAD_GLBL_ENABLE_CTM1    0x6U   // Counter Module Global Enable
#define ERAD_GLBL_ENABLE_CTM2    0x7U   // Counter Module Global Enable
#define ERAD_GLBL_ENABLE_CTM3    0x8U   // Counter Module Global Enable
#define ERAD_GLBL_ENABLE_CTM4    0x9U   // Counter Module Global Enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the GLBL_SEC_RESET register
//
//*************************************************************************************************
#define ERAD_GLBL_CTM_RESET_CTM1   0x0U   // Global Reset for the counters
#define ERAD_GLBL_CTM_RESET_CTM2   0x1U   // Global Reset for the counters
#define ERAD_GLBL_CTM_RESET_CTM3   0x2U   // Global Reset for the counters
#define ERAD_GLBL_CTM_RESET_CTM4   0x3U   // Global Reset for the counters

//*************************************************************************************************
//
// The following are defines for the bit fields in the GLBL_OWNER register
//
//*************************************************************************************************
//#define ERAD_GLBL_OWNER_OWNER_S   0U
//#define ERAD_GLBL_OWNER_OWNER_M   0x3U   // Global Ownership Bits


//*************************************************************************************************
//
// The following are defines for the bit fields in the HWBP_CLEAR register
//
//*************************************************************************************************
#define ERAD_HWBP_CLEAR_EVENT_CLR   0x1U   // Event Clear register

//*************************************************************************************************
//
// The following are defines for the bit fields in the HWBP_CNTL register
//
//*************************************************************************************************
#define ERAD_HWBP_CNTL_BUS_SEL_S       0x0U      // Bus select bits
//#define ERAD_HWBP_CNTL_STOP          0x20U    // Stop bit (Halt/No Halt of CPU)
#define ERAD_HWBP_CNTL_RTOSINT         0x3U      // RTOSINT bit
#define ERAD_HWBP_CNTL_DATCOMP_MODE    0x4U      //data compare mode
#define ERAD_HWBP_CNTL_ADDCOMP_MODE    0x7U     // address Compare mode
#define ERAD_HWBP_CNTL_DATCOMP_ENB     0x400U     //  care about address match and data match
#define ERAD_HWBP_CNTL_RWCOMP_MODE     0xbU     // read OR write Compare mode
//*************************************************************************************************
//
// The following are defines for the bit fields in the HWBP_STATUS register
//
//*************************************************************************************************
#define ERAD_HWBP_STATUS_EVENT_FIRED   0x0U      // HWBP (EBC) Event Fired bits
#define ERAD_HWBP_STATUS_MODULE_ID_S   8U
#define ERAD_HWBP_STATUS_MODULE_ID_M   0x3F00U   // Identification bits
#define ERAD_HWBP_STATUS_STATUS_S      14U
#define ERAD_HWBP_STATUS_STATUS_M      0x1U   // Status bits


//*************************************************************************************************
//
// The following are defines for the bit fields in the CTM_CNTL register
//
//*************************************************************************************************
#define ERAD_CTM_CNTL_START_STOP_MODE   0x4U      // Start_stop mode bit
#define ERAD_CTM_CNTL_EVENT_MODE        0x8U      // Event mode bit
#define ERAD_CTM_CNTL_RST_ON_MATCH      0x10U     // Reset_on_match bit
//#define ERAD_CTM_CNTL_STOP              0x40U     // Stop bit (Halt/No Halt of CPU)
#define ERAD_CTM_CNTL_RTOSINT           0x80U     // RTOSINT bit
#define ERAD_CTM_CNTL_cumulative        0x100U     // start_stop_cumulative
#define ERAD_CTM_CNTL_RST_EN            0xc00U    // Enable Reset
#define ERAD_CTM_CNTL_INP_SEL_EN        0x800U    //input sell event enable
#define ERAD_CTM_CNTL_RST_INP_SEL_M     0xF800U   // Reset Input select      // Count input select enable

//*************************************************************************************************
//
// The following are defines for the bit fields in the CTM_STATUS register
//
//*************************************************************************************************
#define ERAD_CTM_STATUS_EVENT_FIRED   0x0U      // Counter Event Fired bits
#define ERAD_CTM_STATUS_OVERFLOW      0x2U      // Counter Overflowed
#define ERAD_CTM_STATUS_MODULE_ID_S   8U
#define ERAD_CTM_STATUS_MODULE_ID_M   0xFFCU    // Identification bits
#define ERAD_CTM_STATUS_STATUS_S      14U
#define ERAD_CTM_STATUS_STATUS_M      0x1U   // Status bits

//*************************************************************************************************
//
// The following are defines for the bit fields in the CTM_INPUT_SEL register
//
//*************************************************************************************************
//#define ERAD_CTM_INPUT_SEL_CTM_INP_SEL_EN   0x1U      // Count input select enable
#define ERAD_CTM_INPUT_SEL_CNT_INP_SEL_S    0U
//#define ERAD_CTM_INPUT_SEL_CNT_INP_SEL_M    0x3EU     // Count input select
#define ERAD_CTM_INPUT_SEL_STA_INP_SEL_S    8U
//#define ERAD_CTM_INPUT_SEL_STA_INP_SEL_M    0x7C0U    // Start input select
#define ERAD_CTM_INPUT_SEL_STO_INP_SEL_S    0U
#define ERAD_CTM_INPUT_SEL_RTS_INP_SEL_r    8U        // Rest input event
//#define ERAD_CTM_INPUT_SEL_STO_INP_SEL_M    0xF800U   // Stop input select

//*************************************************************************************************
//
// The following are defines for the bit fields in the CTM_CLEAR register
//
//*************************************************************************************************
#define ERAD_CTM_CLEAR_EVENT_CLEAR      0x1U   // Clear EVENT_FIRED
#define ERAD_CTM_CLEAR_OVERFLOW_CLEAR   0x2U   // Clear OVERFLOW




//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
}
#endif

#endif //DEVICE_HW_ERAD_H_
