/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_fft.h
*   @brief   
*
*/

#ifndef DEVICE_DRIVERLIB_HW_FFT_H_
#define DEVICE_DRIVERLIB_HW_FFT_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
//register offset
#define FFT_O_FFT_CFG                   0x00
#define FFT_O_FFT_START                 0x04
#define FFT_O_FFT_DSPDMATRIG_CFG        0x0C
#define FFT_O_FFT_AUTOSTART_EN          0x10
#define FFT_O_FFT_STATUS                0x14

#define FFT_O_FFT_INT_RAW               0x18
#define FFT_O_FFT_INT_MASK              0x1C
#define FFT_O_FFT_INT_FLG               0x20
#define FFT_O_FFT_INT_FRC               0x24

#define FFT_O_WIN_INT_RAW               0x28
#define FFT_O_WIN_INT_MASK              0x2C
#define FFT_O_WIN_INT_FLG               0x30
#define FFT_O_WIN_INT_FRC               0x34

//register bit set
//FFT_O_FFT_CFG
#define FFT_CFG_EXCHANGE_EN_S           (3)
#define FFT_CFG_EXCHANGE_EN_M           (1<<3)
#define FFT_CFG_FFT_TYPE_S              (2)
#define FFT_CFG_FFT_TYPE_M              (1<<2)
#define FFT_CFG_FFT_LEN_S               (0)
#define FFT_CFG_FFT_LEN_M               (3<<0)

//FFT_O_FFT_START
#define FFT_START_WIN_SOFT_START        (1<<1)
#define FFT_START_FFT_SOFT_START        (1<<0)

//FFT_O_FFT_DSPDMATRIG_CFG
#define FFT_DSPDMA_TRIG_CHAN(ch)        (1<<ch)

//FFT_O_FFT_AUTOSTART_EN
#define FFT_WIN_BYPASS                  (1<<2)
#define FFT_WIN_AUTOSTART_EN            (1<<1)
#define FFT_FFT_AUTOSTART_EN            (1<<0)

//FFT_O_FFT_STATUS
#define FFT_STATUS_WIN_BUSY             (1<<1)
#define FFT_STATUS_FFT_BUSY             (1<<0)

//FFT_O_FFT_INT_MASK
#define FFT_OVF_INT_MASK                (1<<1)
#define FFT_DONE_INT_MASK               (1<<0)

//FFT_O_FFT_INT_FLG
#define FFT_INT_FLG_OVF_INT             (1<<1)
#define FFT_INT_FLG_DONE_INT            (1<<0)

//FFT_O_FFT_INT_CLR
#define FFT_INT_CLR_OVF_INT_CLR         (1<<1)
#define FFT_INT_CLR_DONE_INT_CLR        (1<<0)

//FFT_O_FFT_INT_FRC
#define FFT_INT_FRC_OVF_INT_FRC         (1<<1)
#define FFT_INT_FRC_DONE_INT_FRC        (1<<0)

//FFT_O_WIN_INT_MASK
#define FFT_WIN_DONE_INT_MASK           (1<<0)

//FFT_O_WIN_INT_FLG
#define FFT_WIN_DONE_INT                (1<<0)

//FFT_O_WIN_INT_CLR
#define FFT_WIN_DONE_INT_CLR            (1<<0)

//FFT_O_WIN_INT_FRC
#define FFT_WIN_DONE_INT_FRC            (1<<0)

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

#ifdef __cplusplus
}
#endif

#endif  /* IS_GS32F00xx(0x12) */

#endif /* DEVICE_DRIVERLIB_HW_CRC_H_ */
