/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef __HW_LIN_H__
#define __HW_LIN_H__

#ifdef __cplusplus
extern "C"{
#endif

/**
 * @brief The following is define of LIN IP register offset.
 *
 */
#define LIN_US_CR				0x0000U			/* Control Register. */
#define LIN_US_MR				0x0004U			/* Mode Register. */
#define LIN_US_IER				0x0008U			/* Interrupt Enable Register. */
#define LIN_US_IDR				0x000CU			/* Interrupt Disable Register. */
#define LIN_US_IMR				0x0010U			/* Interrupt Mask Register. */
#define LIN_US_CSR				0x0014U			/* Channel Status Register. */
#define LIN_US_RHR				0x0018U			/* Receiver Holding Register. */
#define LIN_US_THR				0x001CU			/* Transmitter Holding Register. */
#define LIN_US_BRGR				0x0020U			/* Baud Rate Generator Register. */
#define LIN_US_RTOR				0x0024U			/* Receiver Time-out Register. */
#define LIN_US_TTGR				0x0028U			/* Transmitter Timeguard Register. */
#define LIN_US_FIDI				0x0040U			/* FI DI Ratio Register. */
#define LIN_US_NER				0x0044U			/* Number of Errors Register. */
#define LIN_US_IF				0x004CU			/* IrDA Filter Register. */
#define LIN_US_MAN				0x0050U			/* Manchester Encoder Decoder Register. */
#define LIN_US_LINMR			0x0054U			/* LIN Mode Register. */
#define LIN_US_LINIR			0x0058U			/* LIN Identifier Register. */
#define LIN_US_LINBRR			0x005CU			/* LIN Baud Rate Register. */
#define LIN_US_US_ICDIFF		0x0088U			/* IC DIFF Register. */
#define LIN_US_WPMR				0x00E4U			/* Write Protect Mode Register. */
#define LIN_US_WPSR				0x00E8U			/* Write Protect Status Register. */
#define LIN_US_VERSION			0x00FCU			/* Version Register. */

/**
 * @brief The following are defines for the bit fields in the LIN_US_CR register.
 *
 */
#define LIN_US_CR_RSTRX_M			(0x00000004U)	/* Reset Receiver. */
#define LIN_US_CR_RSTRX_S			(2U)
#define LIN_US_CR_RSTTX_M			(0x00000008U)	/* Reset Transmitter. */
#define LIN_US_CR_RSTTX_S			(3U)
#define LIN_US_CR_RXEN_M			(0x00000010U)	/* Receiver Enable. */
#define LIN_US_CR_RXEN_S			(4U)
#define LIN_US_CR_RXDIS_M			(0x00000020U)	/* Receiver Disable. */
#define LIN_US_CR_RXDIS_S			(5U)
#define LIN_US_CR_TXEN_M			(0x00000040U)	/* Transmitter Enable. */
#define LIN_US_CR_TXEN_S			(6U)
#define LIN_US_CR_TXDIS_M			(0x00000080U)	/* Transmitter Disable. */
#define LIN_US_CR_TXDIS_S			(7U)
#define LIN_US_CR_RSTSTA_M			(0x00000100U)	/* Reset Status Bits. */
#define LIN_US_CR_RSTSTA_S			(8U)
#define LIN_US_CR_STTBRK_M			(0x00000200U)	/* Start Break. */
#define LIN_US_CR_STTBRK_S			(9U)
#define LIN_US_CR_STPBRK_M			(0x00000400U)	/* Stop Break. */
#define LIN_US_CR_STPBRK_S			(10U)
#define LIN_US_CR_STTTO_M			(0x00000800U)	/* Start Time-out. */
#define LIN_US_CR_STTTO_S			(11U)
#define LIN_US_CR_SENDA_M			(0x00001000U)	/* Send Address. In Multidrop Mode
													only, the next character written to
													the US_THR is sent with the address
													bit set. */
#define LIN_US_CR_SENDA_S			(12U)
#define LIN_US_CR_RSTIT_M			(0x00002000U)	/* Reset Iterations. */
#define LIN_US_CR_RSTIT_S			(13U)
#define LIN_US_CR_RSTNACK_M			(0x00004000U)	/* Reset Non Acknowledge. */
#define LIN_US_CR_RSTNACK_S			(14U)
#define LIN_US_CR_RETTO_M			(0x00008000U)	/* Restart Time-out. */
#define LIN_US_CR_RETTO_S			(15U)
#define LIN_US_CR_DTREN_M			(0x00010000U)	/* Data Terminal Ready Enable. */
#define LIN_US_CR_DTREN_S			(16U)
#define LIN_US_CR_DTR_DIS_M			(0x00020000U)	/* Data Terminal Ready Disable. */
#define LIN_US_CR_DTR_DIS_S			(17U)
#define LIN_US_CR_RTSEN_M			(0x00040000U)	/* Request to Send Enable. */
#define LIN_US_CR_RTSEN_S			(18U)
#define LIN_US_CR_RTSDIS_M			(0x00080000U)	/* Request to Send Disable. */
#define LIN_US_CR_RTSDIS_S			(19U)
#define LIN_US_CR_LINABT_M			(0x00100000U)	/* Abort LIN Transmission. */
#define LIN_US_CR_LINABT_S			(20U)
#define LIN_US_CR_LINWKUP_M			(0x00200000U)	/* Send LIN Wakeup Signal. */
#define LIN_US_CR_LINWKUP_S			(21U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_MR register.
 *
 */
#define LIN_US_MR_USART_MODE_M		(0x0000000FU)	/* USART Mode of Operation. */
#define LIN_US_MR_USART_MODE_S		(0U)
#define LIN_US_MR_USCLKS_M			(0x00000030U)	/* Clock Selection. */
#define LIN_US_MR_USCLKS_S			(4U)
#define LIN_US_MR_CHRL_M			(0x000000C0U)	/* Character Length. */
#define LIN_US_MR_CHRL_S			(6U)
#define LIN_US_MR_SYNC_M			(0x00000100U)	/* Synchronous Mode Select. */
#define LIN_US_MR_SYNC_S			(8U)
#define LIN_US_MR_PAR_M				(0x00000E00U)	/* Parity Type. */
#define LIN_US_MR_PAR_S				(9U)
#define LIN_US_MR_NBSTOP_M			(0x00003000U)	/* Number of Stop Bits. */
#define LIN_US_MR_NBSTOP_S			(12U)
#define LIN_US_MR_CHMODE_M			(0x0000C000U)	/* Channel Mode. */
#define LIN_US_MR_CHMODE_S			(14U)
#define LIN_US_MR_MSBF_M			(0x00010000U)	/* Bit Order. */
#define LIN_US_MR_MSBF_S			(16U)
#define LIN_US_MR_MODE9_M			(0x00020000U)	/* 9-bit Character Length. */
#define LIN_US_MR_MODE9_S			(17U)
#define LIN_US_MR_CLKO_M			(0x00040000U)	/* Clock Output Select. */
#define LIN_US_MR_CLKO_S			(18U)
#define LIN_US_MR_OVER_M			(0x00080000U)	/* Oversampling Mode. */
#define LIN_US_MR_OVER_S			(19U)
#define LIN_US_MR_INACK_M			(0x00100000U)	/* Inhibit Non Acknowledge. */
#define LIN_US_MR_INACK_S			(20U)
#define LIN_US_MR_DSNACK_M			(0x00200000U)	/* Disable Successive NACK. */
#define LIN_US_MR_DSNACK_S			(21U)
#define LIN_US_MR_VARSYNC_M			(0x00400000U)	/* Variable Synchronization of
													Command Data Sync Start Frame
													Delimiter. */
#define LIN_US_MR_VARSYNC_S			(22U)
#define LIN_US_MR_INVDATA_M			(0x00800000U)	/* Inverted Data. */
#define LIN_US_MR_INVDATA_S			(23U)
#define LIN_US_MR_MAXITER_M			(0x07000000U)	/* Maximum Number of
													Automatic Iteration. */
#define LIN_US_MR_MAXITER_S			(24U)
#define LIN_US_MR_FILTER_M			(0x10000000U)	/* Infrared Receive Line Filter. */
#define LIN_US_MR_FILTER_S			(28U)
#define LIN_US_MR_MAN_M				(0x20000000U)	/* Manchester Encoder/Decoder
													Enable.*/
#define LIN_US_MR_MAN_S				(29U)
#define LIN_US_MR_MODSYNC_M			(0x40000000U)	/* Manchester Synchronization Mode. */
#define LIN_US_MR_MODSYNC_S			(30U)
#define LIN_US_MR_ONEBIT_M			(0x80000000U)	/* Start Frame Delimiter Selector. */
#define LIN_US_MR_ONEBIT_S			(31U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IER register
 * in USART mode.
 *
 */
#define LIN_US_USART_IER_RXRDY_M	(0x00000001U)	/* RXRDY Interrupt Enable. */
#define LIN_US_USART_IER_RXRDY_S	(0U)
#define LIN_US_USART_IER_TXRDY_M	(0x00000002U)	/* TXRDY Interrupt Enable. */
#define LIN_US_USART_IER_TXRDY_S	(1U)
#define LIN_US_USART_IER_RXBRK_M	(0x00000004U)	/* Receiver Break Interrupt Enable. */
#define LIN_US_USART_IER_RXBRK_S	(2U)
#define LIN_US_USART_IER_ENDRX_M	(0x00000008U)	/* End of Receive Transfer
													Interrupt Enable. */
#define LIN_US_USART_IER_ENDRX_S	(3U)
#define LIN_US_USART_IER_ENDTX_M	(0x00000010U)	/* End of Transmit Interrupt
													Enable. */
#define LIN_US_USART_IER_ENDTX_S	(4U)
#define LIN_US_USART_IER_OVRE_M		(0x00000020U)	/* Overrun Error Interrupt Enable. */
#define LIN_US_USART_IER_OVRE_S		(5U)
#define LIN_US_USART_IER_FRAME_M	(0x00000040U)	/* Framing Error Interrupt Enable. */
#define LIN_US_USART_IER_FRAME_S	(6U)
#define LIN_US_USART_IER_PARE_M		(0x00000080U)	/* Parity Error Interrupt Enable. */
#define LIN_US_USART_IER_PARE_S		(7U)
#define LIN_US_USART_IER_TIMEOUT_M	(0x00000100U)	/* Time-out Interrupt Enable. */
#define LIN_US_USART_IER_TIMEOUT_S	(8U)
#define LIN_US_USART_IER_TXEMPTY_M	(0x00000200U)	/* TXEMPTY Interrupt Enable. */
#define LIN_US_USART_IER_TXEMPTY_S	(9U)
#define LIN_US_USART_IER_ITER_M		(0x00000400U)	/* Iteration Interrupt Enable. */
#define LIN_US_USART_IER_ITER_S		(10U)
#define LIN_US_USART_IER_TXBUFE_M	(0x00000800U)	/* TXBUFE Interrupt Enable. */
#define LIN_US_USART_IER_TXBUFE_S	(11U)
#define LIN_US_USART_IER_RXBUFF_M	(0x00001000U)	/* RXBUFF Interrupt Enable. */
#define LIN_US_USART_IER_RXBUFF_S	(12U)
#define LIN_US_USART_IER_NACK_M		(0x00002000U)	/* Non Acknowledge Interrupt
													Enable. */
#define LIN_US_USART_IER_NACK_S		(13U)
#define LIN_US_USART_IER_RIIC_M		(0x00010000U)	/* Ring Indicator Input Change
													Interrupt Enable. */
#define LIN_US_USART_IER_RIIC_S		(16U)
#define LIN_US_USART_IER_DSRIC_M	(0x00020000U)	/* Data Set Ready Input Change
													Interrupt Enable. */
#define LIN_US_USART_IER_DSRIC_S	(17U)
#define LIN_US_USART_IER_DCDIC_M	(0x00040000U)	/* Data Carrier Detect Input
													Change Interrupt Enable. */
#define LIN_US_USART_IER_DCDIC_S	(18U)
#define LIN_US_USART_IER_CTSIC_M	(0x00080000U)	/* Clear to Send Input Change
													Interrupt Enable. */
#define LIN_US_USART_IER_CTSIC_S	(19U)

#define LIN_US_USART_IER_MANE_M		(0x00100000U)	/* Manchester Error Interrupt
													Enable. */
#define LIN_US_USART_IER_MANE_S		(20U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IER register
 * in LIN mode.
 *
 */
#define LIN_US_LIN_IER_RXRDY_M		(0x00000001U)	/* RXRDY Interrupt Enable. */
#define LIN_US_LIN_IER_RXRDY_S		(0U)
#define LIN_US_LIN_IER_TXRDY_M		(0x00000002U)	/* TXRDY Interrupt Enable. */
#define LIN_US_LIN_IER_TXRDY_S		(1U)
#define LIN_US_LIN_IER_ENDRX_M		(0x00000008U)	/* End of Receive Transfer
													Interrupt Enable. */
#define LIN_US_LIN_IER_ENDRX_S		(3U)
#define LIN_US_LIN_IER_ENDTX_M		(0x00000010U)	/* End of Transmit Interrupt
													Enable. */
#define LIN_US_LIN_IER_ENDTX_S		(4U)
#define LIN_US_LIN_IER_OVER_M		(0x00000020U)	/* Overrun Error Interrupt Enable. */
#define LIN_US_LIN_IER_OVER_S		(5U)
#define LIN_US_LIN_IER_FRAME_M		(0x00000040U)	/* Framing Error Interrupt Enable. */
#define LIN_US_LIN_IER_FRAME_S		(6U)
#define LIN_US_LIN_IER_PARE_M		(0x00000080U)	/* Parity Error Interrupt Enable. */
#define LIN_US_LIN_IER_PARE_S		(7U)
#define LIN_US_LIN_IER_TIMEOUT_M	(0x00000100U)	/* Time-out Interrupt Enable. */
#define LIN_US_LIN_IER_TIMEOUT_S	(8U)
#define LIN_US_LIN_IER_TXEMPTY_M	(0x00000200U)	/* TXEMPTY Interrupt Enable. */
#define LIN_US_LIN_IER_TXEMPTY_S	(9U)
#define LIN_US_LIN_IER_TXBUFE_M		(0x00000800U)	/* TXBUFE Interrupt Enable. */
#define LIN_US_LIN_IER_TXBUFE_S		(11U)
#define LIN_US_LIN_IER_RXBUFF_M		(0x00001000U)	/* RXBUFF Interrupt Enable. */
#define LIN_US_LIN_IER_RXBUFF_S		(12U)
#define LIN_US_LIN_IER_LINBK_M		(0x00002000U)	/* LIN Break Sent or LIN Break
													Detected Interrupt Enable. */
#define LIN_US_LIN_IER_LINBK_S		(13U)
#define LIN_US_LIN_IER_LINID_M		(0x00004000U)	/* LIN Identifier Sent or LIN
													Identifier Received Interrupt
													Enable. */
#define LIN_US_LIN_IER_LINID_S		(14U)
#define LIN_US_LIN_IER_LINTC_M		(0x00008000U)	/* LIN Transfer Completed
													Interrupt Enable. */
#define LIN_US_LIN_IER_LINTC_S		(15U)
#define LIN_US_LIN_IER_LINBE_M		(0x02000000U)	/* LIN Bus Error Interrupt
													Enable. */
#define LIN_US_LIN_IER_LINBE_S		(25U)
#define LIN_US_LIN_IER_LINISFE_M	(0x04000000U)	/* LIN Incident Frame Error
													Interrupt Enable. */
#define LIN_US_LIN_IER_LINISFE_S	(26U)
#define LIN_US_LIN_IER_LINIPE_M		(0x08000000U)	/* LIN Incident Parity Error
													Interrupt Enable. */
#define LIN_US_LIN_IER_LINIPE_S		(27U)
#define LIN_US_LIN_IER_LINCE_M		(0x10000000U)	/* LIN Incident Checksum Error
													Interrupt Enable. */
#define LIN_US_LIN_IER_LINCE_S		(28U)
#define LIN_US_LIN_IER_LINSNRE_M	(0x20000000U)	/* LIN Incident No Response
													Error Interrupt Enable. */
#define LIN_US_LIN_IER_LINSNRE_S	(29U)
#define LIN_US_LIN_IER_LINSTE_M		(0x40000000U)	/* LIN Incident Service
													Timeout Error Interrupt
													Enable. */
#define LIN_US_LIN_IER_LINSTE_S		(30U)
#define LIN_US_LIN_IER_HTE_M		(0x80000000U)	/* Hardware Time-out Interrupt
													Enable. */
#define LIN_US_LIN_IER_HTE_S		(31U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IDR register
 * in USART mode.
 *
 */
#define LIN_US_USART_IDR_RXRDY_M	(0x00000001U)	/* RXRDY Interrupt Disable. */
#define LIN_US_USART_IDR_RXRDY_S	(0U)
#define LIN_US_USART_IDR_TXRDY_M	(0x00000002U)	/* TXRDY Interrupt Disable. */
#define LIN_US_USART_IDR_TXRDY_S	(1U)
#define LIN_US_USART_IDR_RXBRK_M	(0x00000004U)	/* Receiver Break Interrupt
													Disable. */
#define LIN_US_USART_IDR_RXBRK_S	(2U)
#define LIN_US_USART_IDR_ENDRX_M	(0x00000008U)	/* End of Receive Transfer
													Interrupt Disable. */
#define LIN_US_USART_IDR_ENDRX_S	(3U)
#define LIN_US_USART_IDR_ENDTX_M	(0x00000010U)	/* End of Transmit Interrupt
													Disable. */
#define LIN_US_USART_IDR_ENDTX_S	(4U)
#define LIN_US_USART_IDR_OVRE_M		(0x00000020U)	/* Overrun Error Interrupt
													Disable. */
#define LIN_US_USART_IDR_OVRE_S		(5U)
#define LIN_US_USART_IDR_FRAME_M	(0x00000040U)	/* Framing Error Interrupt
													Disable. */
#define LIN_US_USART_IDR_FRAME_S	(6U)
#define LIN_US_USART_IDR_PARE_M		(0x00000080U)	/* Parity Error Interrupt
													Disable. */
#define LIN_US_USART_IDR_PARE_S		(7U)
#define LIN_US_USART_IDR_TIMEOUT_M	(0x00000100U)	/* Time-out Interrupt Disable. */
#define LIN_US_USART_IDR_TIMEOUT_S	(8U)
#define LIN_US_USART_IDR_TXEMPTY_M	(0x00000200U)	/* TXEMPTY Interrupt Disable. */
#define LIN_US_USART_IDR_TXEMPTY_S	(9U)
#define LIN_US_USART_IDR_ITER_M		(0x00000400U)	/* Iterrupt Error Interrupt
													Disable. */
#define LIN_US_USART_IDR_ITER_S		(10U)
#define LIN_US_USART_IDR_TXBUFE_M	(0x00000800U)	/* TXBUFE Interrupt Disable. */
#define LIN_US_USART_IDR_TXBUFE_S	(11U)
#define LIN_US_USART_IDR_RXBUFF_M	(0x00001000U)	/* RXBUFF Interrupt Disable. */
#define LIN_US_USART_IDR_RXBUFF_S	(12U)
#define LIN_US_USART_IDR_NACK_M		(0x00002000U)	/* NACK Received Interrupt
													Disable. */
#define LIN_US_USART_IDR_NACK_S		(13U)
#define LIN_US_USART_IDR_RIIC_M		(0x00010000U)	/* Ring Indicator Input Change
													Interrupt Disable. */
#define LIN_US_USART_IDR_RIIC_S		(16U)
#define LIN_US_USART_IDR_DSRIC_M	(0x00020000U)	/* Data Set Ready Input Change
													Interrupt Disable. */
#define LIN_US_USART_IDR_DSRIC_S	(17U)
#define LIN_US_USART_IDR_DCDIC_M	(0x00040000U)	/* Data Carrier Detect Input
													Change Interrupt Disable. */
#define LIN_US_USART_IDR_DCDIC_S	(18U)
#define LIN_US_USART_IDR_CTSIC_M	(0x00080000U)	/* Clear To Send Input Change
													Interrupt Disable. */
#define LIN_US_USART_IDR_CTSIC_S	(19U)
#define LIN_US_USART_IDR_MANE_M		(0x00100000U)	/* Manchester Error Interrupt
													Disable. */
#define LIN_US_USART_IDR_MANE_S		(20U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IMR register
 * in USART mode.
 *
 */
#define LIN_US_USART_IMR_RXRDY_M	(0x00000001U)	/* RXRDY Interrupt Mask. */
#define LIN_US_USART_IMR_RXRDY_S	(0U)
#define LIN_US_USART_IMR_TXRDY_M	(0x00000002U)	/* TXRDY Interrupt Mask. */
#define LIN_US_USART_IMR_TXRDY_S	(1U)
#define LIN_US_USART_IMR_RXBRK_M	(0x00000004U)	/* Receiver Break Interrupt Mask. */
#define LIN_US_USART_IMR_RXBRK_S	(2U)
#define LIN_US_USART_IMR_ENDRX_M	(0x00000008U)	/* End of Receive Transfer
													Interrupt Mask. */
#define LIN_US_USART_IMR_ENDRX_S	(3U)
#define LIN_US_USART_IMR_ENDTX_M	(0x00000010U)	/* End of Transmit Interrupt Mask. */
#define LIN_US_USART_IMR_ENDTX_S	(4U)
#define LIN_US_USART_IMR_OVRE_M		(0x00000020U)	/* Overrun Error Interrupt Mask. */
#define LIN_US_USART_IMR_OVRE_S		(5U)
#define LIN_US_USART_IMR_FRAME_M	(0x00000040U)	/* Framing Error Interrupt Mask. */
#define LIN_US_USART_IMR_FRAME_S	(6U)
#define LIN_US_USART_IMR_PARE_M		(0x00000080U)	/* Parity Error Interrupt Mask. */
#define LIN_US_USART_IMR_PARE_S		(7U)
#define LIN_US_USART_IMR_TIMEOUT_M	(0x00000100U)	/* Time-out Interrupt Mask. */
#define LIN_US_USART_IMR_TIMEOUT_S	(8U)
#define LIN_US_USART_IMR_TXEMPTY_M	(0x00000200U)	/* TXEMPTY Interrupt Mask. */
#define LIN_US_USART_IMR_TXEMPTY_S	(9U)
#define LIN_US_USART_IMR_ITER_M		(0x00000400U)	/* Iterrupt Error Interrupt Mask. */
#define LIN_US_USART_IMR_ITER_S		(10U)
#define LIN_US_USART_IMR_TXBUFE_M	(0x00000800U)	/* TXBUFE Interrupt Mask. */
#define LIN_US_USART_IMR_TXBUFE_S	(11U)
#define LIN_US_USART_IMR_RXBUFF_M	(0x00001000U)	/* RXBUFF Interrupt Mask. */
#define LIN_US_USART_IMR_RXBUFF_S	(12U)
#define LIN_US_USART_IMR_NACK_M		(0x00002000U)	/* NACK Received Interrupt Mask. */
#define LIN_US_USART_IMR_NACK_S		(13U)
#define LIN_US_USART_IMR_RIIC_M		(0x00010000U)	/* Ring Indicator Input Change
													Interrupt Mask. */
#define LIN_US_USART_IMR_RIIC_S		(16U)
#define LIN_US_USART_IMR_DSRIC_M	(0x00020000U)	/* Data Set Ready Input Change
													Interrupt Mask. */
#define LIN_US_USART_IMR_DSRIC_S	(17U)
#define LIN_US_USART_IMR_DCDIC_M	(0x00040000U)	/* Data Carrier Detect Input
													Change Interrupt Mask. */
#define LIN_US_USART_IMR_DCDIC_S	(18U)
#define LIN_US_USART_IMR_CTSIC_M	(0x00080000U)	/* Clear To Send Input Change
													Interrupt Mask. */
#define LIN_US_USART_IMR_CTSIC_S	(19U)
#define LIN_US_USART_IMR_MANE_M		(0x00100000U)	/* Manchester Error Interrupt Mask. */
#define LIN_US_USART_IMR_MANE_S		(20U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IMR register
 * in LIN mode.
 *
 */
#define LIN_US_LIN_IMR_RXRDY_M		(0x00000001U)	/* RXRDY Interrupt Mask. */
#define LIN_US_LIN_IMR_RXRDY_S		(0U)
#define LIN_US_LIN_IMR_TXRDY_M		(0x00000002U)	/* TXRDY Interrupt Mask. */
#define LIN_US_LIN_IMR_TXRDY_S		(1U)
#define LIN_US_LIN_IMR_RXBRK_M		(0x00000004U)	/* Receiver Break Interrupt Mask. */
#define LIN_US_LIN_IMR_RXBRK_S		(2U)
#define LIN_US_LIN_IMR_ENDRX_M		(0x00000008U)	/* End of Receive Transfer
													Interrupt Mask. */
#define LIN_US_LIN_IMR_ENDRX_S		(3U)
#define LIN_US_LIN_IMR_ENDTX_M		(0x00000010U)	/* End of Transmit Interrupt Mask. */
#define LIN_US_LIN_IMR_ENDTX_S		(4U)
#define LIN_US_LIN_IMR_OVRE_M		(0x00000020U)	/* Overrun Error Interrupt Mask. */
#define LIN_US_LIN_IMR_OVRE_S		(5U)
#define LIN_US_LIN_IMR_FRAME_M		(0x00000040U)	/* Framing Error Interrupt Mask. */
#define LIN_US_LIN_IMR_FRAME_S		(6U)
#define LIN_US_LIN_IMR_PARE_M		(0x00000080U)	/* Parity Error Interrupt Mask. */
#define LIN_US_LIN_IMR_PARE_S		(7U)
#define LIN_US_LIN_IMR_TIMEOUT_M	(0x00000100U)	/* Time-out Interrupt Mask. */
#define LIN_US_LIN_IMR_TIMEOUT_S	(8U)
#define LIN_US_LIN_IMR_TXEMPTY_M	(0x00000200U)	/* TXEMPTY Interrupt Mask. */
#define LIN_US_LIN_IMR_TXEMPTY_S	(9U)
#define LIN_US_LIN_IMR_TXBUFE_M		(0x00000800U)	/* TXBUFE Interrupt Mask. */
#define LIN_US_LIN_IMR_TXBUFE_S		(11U)
#define LIN_US_LIN_IMR_RXBUFF_M		(0x00001000U)	/* RXBUFF Interrupt Mask. */
#define LIN_US_LIN_IMR_RXBUFF_S		(12U)
#define LIN_US_LIN_IMR_LINBK_M		(0x00002000U)	/* LIN Break Sent or LIN Break
													Detected Interrupt Mask. */
#define LIN_US_LIN_IMR_LINBK_S		(13U)
#define LIN_US_LIN_IMR_LINID_M		(0x00004000U)	/* LIN Identifier Sent or LIN
													Identifier Detected Interrupt Mask. */
#define LIN_US_LIN_IMR_LINID_S		(14U)
#define LIN_US_LIN_IMR_LINTC_M		(0x00008000U)	/* LIN Transfer Completed Interrupt
													Mask. */
#define LIN_US_LIN_IMR_LINTC_S		(15U)
#define LIN_US_LIN_IMR_LINBE_M		(0x02000000U)	/* LIN Bus Error Interrupt Mask. */
#define LIN_US_LIN_IMR_LINBE_S		(25U)
#define LIN_US_LIN_IMR_LINISFE_M	(0x04000000U)	/* LIN Incident Frame Error Interrupt
													Mask. */
#define LIN_US_LIN_IMR_LINISFE_S	(26U)
#define LIN_US_LIN_IMR_LINIPE_M		(0x08000000U)	/* LIN Incident Parity Error Interrupt
													Mask. */
#define LIN_US_LIN_IMR_LINIPE_S		(27U)
#define LIN_US_LIN_IMR_LINCE_M		(0x10000000U)	/* LIN Incident Checksum Error
													Interrupt Mask. */
#define LIN_US_LIN_IMR_LINCE_S		(28U)
#define LIN_US_LIN_IMR_LINSNRE_M	(0x20000000U)	/* LIN Incident No Response Error
													Interrupt Mask. */
#define LIN_US_LIN_IMR_LINSNRE_S	(29U)
#define LIN_US_LIN_IMR_LINSTE_M		(0x40000000U)	/* LIN Incident Stuffing Error
													Interrupt Mask. */
#define LIN_US_LIN_IMR_LINSTE_S		(30U)
#define LIN_US_LIN_IMR_LINHTE_M		(0x80000000U)	/* LIN Incident Header Timeout
													Error Interrupt Mask. */
#define LIN_US_LIN_IMR_LINHTE_S		(31U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_CSR register
 * in USART mode.
 *
 */
#define LIN_US_USART_CSR_RXRDY_M	(0x00000001U)	/* Receiver Ready. */
#define LIN_US_USART_CSR_RXRDY_S	(0U)
#define LIN_US_USART_CSR_TXRDY_M	(0x00000002U)	/* Transmitter Ready. */
#define LIN_US_USART_CSR_TXRDY_S	(1U)
#define LIN_US_USART_CSR_RXBRK_M	(0x00000004U)	/* Break Received/End of Break. */
#define LIN_US_USART_CSR_RXBRK_S	(2U)
#define LIN_US_USART_CSR_ENDRX_M	(0x00000008U)	/* End of Receiver Transfer. */
#define LIN_US_USART_CSR_ENDRX_S	(3U)
#define LIN_US_USART_CSR_ENDTX_M	(0x00000010U)	/* End of Transmitter Transfer. */
#define LIN_US_USART_CSR_ENDTX_S	(4U)
#define LIN_US_USART_CSR_OVRE_M		(0x00000020U)	/* Overrun Error. */
#define LIN_US_USART_CSR_OVRE_S		(5U)
#define LIN_US_USART_CSR_FRAME_M	(0x00000040U)	/* Framing Error. */
#define LIN_US_USART_CSR_FRAME_S	(6U)
#define LIN_US_USART_CSR_PARE_M		(0x00000080U)	/* Parity Error. */
#define LIN_US_USART_CSR_PARE_S		(7U)
#define LIN_US_USART_CSR_TIMEOUT_M	(0x00000100U)	/* Time-out. */
#define LIN_US_USART_CSR_TIMEOUT_S	(8U)
#define LIN_US_USART_CSR_TXEMPTY_M	(0x00000200U)	/* Transmitter Empty. */
#define LIN_US_USART_CSR_TXEMPTY_S	(9U)
#define LIN_US_USART_CSR_ITER_M		(0x00000400U)	/* Iteration Error. */
#define LIN_US_USART_CSR_ITER_S		(10U)
#define LIN_US_USART_CSR_TXBUFE_M	(0x00000800U)	/* Transmitter Buffer Empty. */
#define LIN_US_USART_CSR_TXBUFE_S	(11U)
#define LIN_US_USART_CSR_RXBUFF_M	(0x00001000U)	/* Receiver Buffer Full. */
#define LIN_US_USART_CSR_RXBUFF_S	(12U)
#define LIN_US_USART_CSR_NACK_M		(0x00002000U)	/* Not Acknowledged. */
#define LIN_US_USART_CSR_NACK_S		(13U)
#define LIN_US_USART_CSR_RIIC_M		(0x00010000U)	/* Ring Indicator Input Change
													Interrupt. */
#define LIN_US_USART_CSR_RIIC_S		(16U)
#define LIN_US_USART_CSR_DSRIC_M	(0x00020000U)	/* Data Set Ready Input Change
													Interrupt. */
#define LIN_US_USART_CSR_DSRIC_S	(17U)
#define LIN_US_USART_CSR_DCDIC_M	(0x00040000U)	/* Data Carrier Detect Input Change
													Interrupt. */
#define LIN_US_USART_CSR_DCDIC_S	(18U)
#define LIN_US_USART_CSR_CTSIC_M	(0x00080000U)	/* Clear To Send Input Change
													Interrupt. */
#define LIN_US_USART_CSR_CTSIC_S	(19U)
#define LIN_US_USART_CSR_RI_M		(0x00100000U)	/* Ring Indicator. */
#define LIN_US_USART_CSR_RI_S		(20U)
#define LIN_US_USART_CSR_DSR_M		(0x00200000U)	/* Data Set Ready. */
#define LIN_US_USART_CSR_DSR_S		(21U)
#define LIN_US_USART_CSR_DCD_M		(0x00400000U)	/* Data Carrier Detect. */
#define LIN_US_USART_CSR_DCD_S		(22U)
#define LIN_US_USART_CSR_CTS_M		(0x00800000U)	/* Clear To Send. */
#define LIN_US_USART_CSR_CTS_S		(23U)
#define LIN_US_USART_CSR_MANERR_M	(0x01000000U)	/* Manchester Error. */
#define LIN_US_USART_CSR_MANERR_S	(24U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_CSR register
 * in LIN mode.
 *
 */
#define LIN_US_LIN_CSR_RXRDY_M		(0x00000001U)	/* Receiver Ready. */
#define LIN_US_LIN_CSR_RXRDY_S		(0U)
#define LIN_US_LIN_CSR_TXRDY_M		(0x00000002U)	/* Transmitter Ready. */
#define LIN_US_LIN_CSR_TXRDY_S		(1U)
#define LIN_US_LIN_CSR_RXBRK_M		(0x00000004U)	/* Overrun Error. */
#define LIN_US_LIN_CSR_RXBRK_S		(2U)
#define LIN_US_LIN_CSR_ENDRX_M		(0x00000008U)	/* End of Receiver Transfer. */
#define LIN_US_LIN_CSR_ENDRX_S		(3U)
#define LIN_US_LIN_CSR_ENDTX_M		(0x00000010U)	/* End of Transmitter Transfer. */
#define LIN_US_LIN_CSR_ENDTX_S		(4U)
#define LIN_US_LIN_CSR_OVRE_M		(0x00000020U)	/* Overrun Error. */
#define LIN_US_LIN_CSR_OVRE_S		(5U)
#define LIN_US_LIN_CSR_FRAME_M		(0x00000040U)	/* Framing Error. */
#define LIN_US_LIN_CSR_FRAME_S		(6U)
#define LIN_US_LIN_CSR_PARE_M		(0x00000080U)	/* Parity Error. */
#define LIN_US_LIN_CSR_PARE_S		(7U)
#define LIN_US_LIN_CSR_TIMEOUT_M	(0x00000100U)	/* Time-out. */
#define LIN_US_LIN_CSR_TIMEOUT_S	(8U)
#define LIN_US_LIN_CSR_TXEMPTY_M	(0x00000200U)	/* Transmitter Empty. */
#define LIN_US_LIN_CSR_TXEMPTY_S	(9U)
#define LIN_US_LIN_CSR_TXBUFE_M		(0x00000800U)	/* Transmitter Buffer Empty. */
#define LIN_US_LIN_CSR_TXBUFE_S		(11U)
#define LIN_US_LIN_CSR_RXBUFF_M		(0x00001000U)	/* Receiver Buffer Full. */
#define LIN_US_LIN_CSR_RXBUFF_S		(12U)
#define LIN_US_LIN_CSR_LINBK_M		(0x00002000U)	/* LIN Break Sync. */
#define LIN_US_LIN_CSR_LINBK_S		(13U)
#define LIN_US_LIN_CSR_LINID_M		(0x00004000U)	/* LIN Identifier. */
#define LIN_US_LIN_CSR_LINID_S		(14U)
#define LIN_US_LIN_CSR_LINTC_M		(0x00008000U)	/* LIN Transfer Complete. */
#define LIN_US_LIN_CSR_LINTC_S		(15U)
#define LIN_US_LIN_CSR_LINBE_M		(0x02000000U)	/* LIN Incident Bit Error. */
#define LIN_US_LIN_CSR_LINBE_S		(25U)
#define LIN_US_LIN_CSR_LINISFE_M	(0x04000000U)	/* LIN Incident Sync Error. */
#define LIN_US_LIN_CSR_LINISFE_S	(26U)
#define LIN_US_LIN_CSR_LINIPE_M		(0x08000000U)	/* LIN Incident Parity Error. */
#define LIN_US_LIN_CSR_LINIPE_S		(27U)
#define LIN_US_LIN_CSR_LINCE_M		(0x10000000U)	/* LIN Incident Checksum Error. */
#define LIN_US_LIN_CSR_LINCE_S		(28U)
#define LIN_US_LIN_CSR_LINSNRE_M	(0x20000000U)	/* LIN Incident No Response Error. */
#define LIN_US_LIN_CSR_LINSNRE_S	(29U)
#define LIN_US_LIN_CSR_LINSTE_M		(0x40000000U)	/* LIN Incident Stuff Error. */
#define LIN_US_LIN_CSR_LINSTE_S		(30U)
#define LIN_US_LIN_CSR_LINHTE_M		(0x80000000U)	/* LIN Incident Header Error. */
#define LIN_US_LIN_CSR_LINHTE_S		(31U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_RHR register.
 *
 */
#define LIN_US_RHR_RXCHR_M		(0x000001FFU)	/* Received Character. */
#define LIN_US_RHR_RXCHR_S		(0U)
#define LIN_US_RHR_RXSYNH_M		(0x00008000U)	/* Received Sync. */
#define LIN_US_RHR_RXSYNH_S		(15U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_THR register.
 *
 */
#define LIN_US_THR_TXCHR_M		(0x000001FFU)	/* Transmitted Character. */
#define LIN_US_THR_TXCHR_S		(0U)
#define LIN_US_THR_TXSYNH_M		(0x00008000U)	/* Transmitted Sync. */
#define LIN_US_THR_TXSYNH_S		(15U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_BRGR register.
 *
 */
#define LIN_US_BRGR_CD_M		(0x0000FFFFU)	/* Clock Divider. */
#define LIN_US_BRGR_CD_S		(0U)
#define LIN_US_BRGR_FP_M		(0x00070000U)	/* Fractional Part. */
#define LIN_US_BRGR_FP_S		(16U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_RTOR register.
 *
 */
#define LIN_US_RTOR_TO_M		(0x0001FFFFU)	/* Receiver Timeout. */
#define LIN_US_RTOR_TO_S		(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_TTGR register.
 *
 */
#define LIN_US_TTGR_TG_M		(0x000000FFU)	/* Transmit Guard Time. */
#define LIN_US_TTGR_TG_S		(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_FIDI register.
 *
 */
#define LIN_US_FIDI_FI_DI_RATIO_M	(0x0000FFFFU)	/* FI Value. */
#define LIN_US_FIDI_FI_DI_RATIO_S	(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_NER register.
 *
 */
#define LIN_US_NER_NBERR_M		(0x000000FFU)	/* Number of Error. */
#define LIN_US_NER_NBERR_S		(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_IF register.
 *
 */
#define LIN_US_IF_IRDA_FILTER_M	(0x000000FFU)	/* IrDA Filter. */
#define LIN_US_IF_IRDA_FILTER_S	(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_MAN register.
 *
 */
#define LIN_US_MAN_TX_PL_M		(0x0000000FU)	/* Transmitter Preamble Length. */
#define LIN_US_MAN_TX_PL_S		(0U)
#define LIN_US_MAN_TX_PP_M		(0x00000300U)	/* Transmitter Preamble Pattern. */
#define LIN_US_MAN_TX_PP_S		(8U)
#define LIN_US_MAN_TX_MPOL_M	(0x00001000U)	/* Transmitter Manchester Polarity. */
#define LIN_US_MAN_TX_MPOL_S	(12U)
#define LIN_US_MAN_RX_PL_M		(0x0000F000U)	/* Receiver Preamble Length. */
#define LIN_US_MAN_RX_PL_S		(16U)
#define LIN_US_MAN_RX_PP_M		(0x03000000U)	/* Receiver Preamble Pattern detected. */
#define LIN_US_MAN_RX_PP_S		(24U)
#define LIN_US_MAN_RX_MPOL_M	(0x10000000U)	/* Receiver Manchester Polarity. */
#define LIN_US_MAN_RX_MPOL_S	(28U)
#define LIN_US_MAN_ONE_M		(0x20000000U)	/* Bit 29 must always be set to 1
												when programming the US_MAN register. */
#define LIN_US_MAN_ONE_S		(29U)
#define LIN_US_MAN_DRIFT_M		(0x40000000U)	/* Drift Compensation. */
#define LIN_US_MAN_DRIFT_S		(30U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_LINMR register.
 *
 */
#define LIN_US_LINMR_NACT_M		(0x00000003U)	/* Node Action. */
#define LIN_US_LINMR_NACT_S		(0U)
#define LIN_US_LINMR_PARDIS_M	(0x00000004U)	/* Parity Disable. */
#define LIN_US_LINMR_PARDIS_S	(2U)
#define LIN_US_LINMR_CHKDIS_M	(0x00000008U)	/* Check Disable. */
#define LIN_US_LINMR_CHKDIS_S	(3U)
#define LIN_US_LINMR_CHKTYP_M	(0x00000010U)	/* Check Type. */
#define LIN_US_LINMR_CHKTYP_S	(4U)
#define LIN_US_LINMR_DLM_M		(0x00000020U)	/* Data Length Mode. */
#define LIN_US_LINMR_DLM_S		(5U)
#define LIN_US_LINMR_FSDIS_M	(0x00000040U)	/* Frame Slot Disable. */
#define LIN_US_LINMR_FSDIS_S	(6U)
#define LIN_US_LINMR_WKUPTYP_M	(0x00000080U)	/* Wakeup Type. */
#define LIN_US_LINMR_WKUPTYP_S	(7U)
#define LIN_US_LINMR_DLC_M		(0x0000FF00U)	/* Data Length Control. */
#define LIN_US_LINMR_DLC_S		(8U)
#define LIN_US_LINMR_PDCM_M		(0x00010000U)	/* PDC/DMA Mode Enable. */
#define LIN_US_LINMR_PDCM_S		(16U)
#define LIN_US_LINMR_SYNCDIS_M	(0x00020000U)	/* Synchronization Mode. */
#define LIN_US_LINMR_SYNCDIS_S	(17U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_LINIR register.
 *
 */
#define LIN_US_LINIR_IDCHR_M	(0x000000FFU)	/* Identifier Character. */
#define LIN_US_LINIR_IDCHR_S	(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_LINBRR register.
 *
 */
#define LIN_US_LINBRR_LINCD_M	(0x0000FFFFU)	/* LIN Baud Rate Divider. */
#define LIN_US_LINBRR_LINCD_S	(0U)
#define LIN_US_LINBRR_LINFP_M	(0x00070000U)	/* LIN Fractional Part. */
#define LIN_US_LINBRR_LINFP_S	(16U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_ICDIFF register.
 *
 */
#define LIN_US_ICDIFF_ICDIFF_M	(0x0000000FU)	/* IC Differentiator Number. */
#define LIN_US_ICDIFF_ICDIFF_S	(0U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_WPMR register.
 *
 */
#define LIN_US_WPMR_WPEN_M		(0x00000001U)	/* Write Protect Enable. */
#define LIN_US_WPMR_WPEN_S		(0U)
#define LIN_US_WPMR_WPKEY_M		(0xFFFFFF00U)	/* Write Protect Key. */
#define LIN_US_WPMR_WPKEY_S		(8U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_WPSR register.
 *
 */
#define LIN_US_WPSR_WPVS_M		(0x00000001U)	/* Write Protect Violation Status. */
#define LIN_US_WPSR_WPVS_S		(0U)
#define LIN_US_WPSR_WPVSRC_M	(0x00FFFF00U)	/* Write Protect Violation Source. */
#define LIN_US_WPSR_WPVSRC_S	(8U)

/**
 * @brief The following are defines for the bit fields in the LIN_US_VERSION register.
 *
 */
#define LIN_US_VERSION_VERSION_M	(0x00000FFFU)	/* Version of the Hardware Module. */
#define IN_US_VERSION_VERSION_S		(0U)
#define LIN_US_VERSION_MFN_M		(0x00070000U)	/* Metal Fix Number. */
#define LIN_US_VERSION_MFN_S		(16U)

#ifdef __cplusplus
}
#endif

#endif
