/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *  commit history
 *  20240324, Jason, M_CAN_CREL_SUBSTEP_M is changed to M_CAN_CREL_STEP_M
 */

#ifndef DEVICE_DRIVERLIB_HW_MCAN_H_
#define DEVICE_DRIVERLIB_HW_MCAN_H_

#ifdef __cplusplus
extern "C"{
#endif

/* registers definition */
#define M_CAN_CREL			0x0		/* Core Release Register */
#define M_CAN_ENDN			0x4		/* Endian Register */
#define M_CAN_CUST			0x8		/* Customer Register */
#define M_CAN_DBTP			0xc		/* Data Bit Timing & Prescaler Register */
#define M_CAN_TEST			0x10	/* Test Register */
#define M_CAN_RWD			0x14	/* RAM Watchdog */
#define M_CAN_CCCR			0x18	/* CC Control Register */
#define M_CAN_NBTP			0x1c	/* Nominal Bit Timing & Prescaler Register */
#define M_CAN_TSCC			0x20	/* Timestamp Counter Configuration */
#define M_CAN_TSCV			0x24	/* Timestamp Counter Value */
#define M_CAN_TOCC			0x28	/* Timeout Counter Configuration */
#define M_CAN_TOCV			0x2c	/* Timeout Counter Value */
#define M_CAN_ECR			0x40	/* Error Counter Register */
#define M_CAN_PSR			0x44	/* Protocol Status Register */

/* TDCR Register only available for version >=3.1.x */
#define M_CAN_TDCR			0x48	/* Transmitter Delay Compensation Register */
#define M_CAN_IR			0x50	/* Interrupt Register */
#define M_CAN_IE			0x54	/* Interrupt Enable */
#define M_CAN_ILS			0x58	/* Interrupt Line Select */
#define M_CAN_ILE			0x5c	/* Interrupt Line Enable */
#define M_CAN_GFC			0x80	/* Global Filter Configuration */
#define M_CAN_SIDFC			0x84	/* Standard ID Filter Configuration */
#define M_CAN_XIDFC			0x88	/* Extended ID Filter Configuration */
#define M_CAN_XIDAM			0x90	/* Extended ID AND Mask */
#define M_CAN_HPMS			0x94	/* High Priority Message Status */
#define M_CAN_NDAT1			0x98	/* New Data 1 */
#define M_CAN_NDAT2			0x9c	/* New Data 2 */
#define M_CAN_RXF0C			0xa0	/* Rx FIFO 0 Configuration */
#define M_CAN_RXF0S			0xa4	/* Rx FIFO 0 Status */
#define M_CAN_RXF0A			0xa8	/* Rx FIFO 0 Acknowledge */
#define M_CAN_RXBC			0xac	/* Rx Buffer Configuration */
#define M_CAN_RXF1C			0xb0	/* Rx FIFO 1 Configuration */
#define M_CAN_RXF1S			0xb4	/* Rx FIFO 1 Status */
#define M_CAN_RXF1A			0xb8	/* Rx FIFO 1 Acknowledge */
#define M_CAN_RXESC			0xbc	/* Rx Buffer / FIFO Element Size Configuration */
#define M_CAN_TXBC			0xc0	/* Tx Buffer Configuration */
#define M_CAN_TXFQS			0xc4	/* Tx FIFO/Queue Status */
#define M_CAN_TXESC			0xc8	/* Tx Buffer Element Size Configuration */
#define M_CAN_TXBRP			0xcc	/* Tx Buffer Request Pending */
#define M_CAN_TXBAR			0xd0	/* Tx Buffer Add Request */
#define M_CAN_TXBCR			0xd4	/* Tx Buffer Cancellation Request */
#define M_CAN_TXBTO			0xd8	/* Tx Buffer Transmission Occurred */
#define M_CAN_TXBCF			0xdc	/* Tx Buffer Cancellation Finished */
#define M_CAN_TXBTIE		0xe0	/* Tx Buffer Transmission Interrupt Enable */
#define M_CAN_TXBCIE		0xe4	/* Tx Buffer Cancellation Finished Interrupt Enable */
#define M_CAN_TXEFC			0xf0	/* Tx Event FIFO Configuration */
#define M_CAN_TXEFS			0xf4	/* Tx Event FIFO Status */
#define M_CAN_TXEFA			0xf8	/* Tx Event FIFO Acknowledge */

/**
 * @brief The following are defines for the bit fields in the M_CAN_CREL register.
 *
 */
#define M_CAN_CREL_REL_S		28U
#define M_CAN_CREL_REL_M		0xf0000000U		/* Core release version. */
#define M_CAN_CREL_STEP_S		24U
#define M_CAN_CREL_STEP_M		0x0f000000U		/* Core step version. */
#define M_CAN_CREL_SUBSTEP_S	20U
#define M_CAN_CREL_SUBSTEP_M	0x00f00000U		/* Core substep version. */
#define M_CAN_CREL_YEAR_S		16U
#define M_CAN_CREL_YEAR_M		0x000f0000U		/* Release year of IP core. */
#define M_CAN_CREL_MON_S		8U
#define M_CAN_CREL_MON_M		0x0000ff00U		/* Release mounth of IP core. */
#define M_CAN_CREL_DAY_S		8U
#define M_CAN_CREL_DAY_M		0x000000ffU		/* Release date of IP core. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_ENDN register.
 *
 */
#define M_CAN_ENDN_ETV_M		0xffffffffU		/* The endianness test
												value is 0x87654321. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_CUST register.
 *
 */
#define M_CAN_CUST_DATA_M		0xffffffffU		/* User can write any data
												to the register. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_DBTP register.
 *
 */
#define M_CAN_DBTP_TDC_S		23U
#define M_CAN_DBTP_TDC_M		0x00800000U		/* Transmitter Delay
												Compensation enabled. */
#define M_CAN_DBTP_DBRP_S		16U
#define M_CAN_DBTP_DBRP_M		0x001f0000U		/* Data Bit Rate Prescaler. The value by
												which the oscillator frequency is divided
												for generating the bit time quanta. The
												bit time is built up from a multiple of
												this quanta. Valid values for the Bit
												Rate Prescaler are 0 to 31. When TDC = 1,
												the range is limited to 0,1. The actual
												interpretation by the hardware of this
												value is such that one more than the
												value programmed here is used. */
#define M_CAN_DBTP_DTSEG1_S		8U
#define M_CAN_DBTP_DTSEG1_M		0x00001f00U		/* Data time segment before sample point.
												Valid values are 0 to 31. The actual
												interpretation by the hardware of this
												value is such that one more than the
												programmed value is used. */
#define M_CAN_DBTP_DTSEG2_S		4U
#define M_CAN_DBTP_DTSEG2_M		0x000000f0U		/* Data time segment after sample point.
												Valid values are 1 to 15. The actual
												interpretation by the hardware of this
												value is such that one more than the
												programmed value is used. */

#define M_CAN_DBTP_DSJW_M		0x0000000fU		/* Data (Re)Synchronization Jump Width.
												Valid values are 0 to 15. The actual
												interpretation by the hardware of this
												value is such that one more than the
												value programmed here is used. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TEST register.
 *
 */
#define M_CAN_TEST_SVAL_M		0x00200000U		/* Set value of TXBNS valid */
#define M_CAN_TEST_TXBNS_S		16U
#define M_CAN_TEST_TXBNS_M		0x001f0000U		/* Tx Buffer number of message whose
												transmission was started last. Valid when
												SVAL is set. Valid values are 0 to 31. */
#define M_CAN_TEST_PVAL_M		0x00002000U		/* Set value of TXBNP valid. */
#define M_CAN_TEST_TXBNP_S		8U
#define M_CAN_TEST_TXBNP_M		0x00001f00U		/* Tx Buffer number of message that is
												ready for transmission. Valid when PVAL
												is set. Valid values are 0 to 31. */
#define M_CAN_TEST_RX_M			0x00000080U		/* Set CAN bus is dominant or recessive.*/
#define M_CAN_TEST_TX_S			5U
#define M_CAN_TEST_TX_M			0x00000060U		/* Control transmit pin mode. */
#define M_CAN_TEST_LBCK_M		0x00000010U		/* Enable/Disable lookback mdoe. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RWD register.
 *
 */
#define M_CAN_RWD_WDV_S			8U
#define M_CAN_RWD_WDV_M			0x0000ff00U		/* Actual Message RAM Watchdog Counter
												Value. */
#define M_CAN_RWD_WDC_M			0x000000ffU		/* Start value of the Message RAM
												Watchdog Counter. With the reset value of
												0x00 the counter is disabled. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_CCCR register.
 *
 */
#define M_CAN_CCCR_NISO_M		0x00008000U		/* CAN FD frame format. */
#define M_CAN_CCCR_TXP_M		0x00004000U		/* Transmit pause enable/disable. */
#define M_CAN_CCCR_EFBI_M		0x00002000U		/* Edge Filtering during Bus
												Integration.*/
#define M_CAN_CCCR_PXHD_M		0x00001000U		/* Protocol exception handling
												enabled/disable. */
#define M_CAN_CCCR_WMM_M		0x00000800U		/* Wide Message Marker */
#define M_CAN_CCCR_UTSU_M		0x00000400U		/* Select clock source of Timestamp. */
#define M_CAN_CCCR_BRSE_M		0x00000200U		/* Bit Rate Switch Enable/Disable. */
#define M_CAN_CCCR_FDOE_M		0x00000100U		/* FD Operation Enable/Disable. */
#define M_CAN_CCCR_TEST_M		0x00000080U		/* Test Mode Enable/Disable. */
#define M_CAN_CCCR_DAR_M		0x00000040U		/* Disable Automatic Retransmission. */
#define M_CAN_CCCR_MON_M		0x00000020U		/* Bus Monitoring Mode Enable/Disable. */
#define M_CAN_CCCR_CSR_M		0x00000010U		/* Clock Stop Request. */
#define M_CAN_CCCR_CSA_M		0x00000008U		/* Clock Stop Acknowledge. */
#define M_CAN_CCCR_ASM_M		0x00000004U		/* Restricted Operation Mode. */
#define M_CAN_CCCR_CCE_M		0x00000002U		/* Configuration Change Enable. */
#define M_CAN_CCCR_INIT_M		0x00000001U		/* MCAN opration mode. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_NBTP register.
 *
 */
#define M_CAN_NBTP_NSJW_S		25U
#define M_CAN_NBTP_NSJW_M		0xfe000000U		/* Nominal (Re)Synchronization
												Jump Width. */
#define M_CAN_NBTP_NBRP_S		16U
#define M_CAN_NBTP_NBRP_M		0x01ff0000U		/* Nominal Bit Rate Prescaler. */
#define M_CAN_NBTP_NTSEG1_S		8U
#define M_CAN_NBTP_NTSEG1_M		0x0000ff00U		/* Nominal Time segment before
												sample point */
#define M_CAN_NBTP_NTSEG2_M		0x0000007fU		/* Nominal Time segment after
												sample point. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TSCC register.
 *
 */
#define M_CAN_TSCC_TCP_S		16U
#define M_CAN_TSCC_TCP_M		0x000f0000U		/* Timestamp Counter Prescaler. */
#define M_CAN_TSCC_TSS_M		0x00000003U		/* Timestamp Select. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TSCV register.
 *
 */
#define M_CAN_TSCV_TSC_M		0x0000ffffU		/* Timestamp Counter. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TOCC register.
 *
 */
#define M_CAN_TOCC_TOP_S		16U
#define M_CAN_TOCC_TOP_M		0xffff0000U		/* Timeout Period. */
#define M_CAN_TOCC_TOS_S		1U
#define M_CAN_TOCC_TOS_M		0x00000006U		/* Timeout Select. */
#define M_CAN_TOCC_ETOC_M		0x00000001U		/* Enable Timeout Counter. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TOCV register.
 *
 */
#define M_CAN_TOCV_TOC_M		0x0000ffffU		/* Timeout Counter. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_ECR register.
 *
 */
#define M_CAN_ECR_CEL_S			16U
#define M_CAN_ECR_CEL_M			0x00ff0000U		/* CAN Error Logging. */
#define M_CAN_ECR_RP_M			0x00008000U		/* Receive Error Passive. */
#define M_CAN_ECR_REC_S			8U
#define M_CAN_ECR_REC_M			0x00007f00U		/* Receive Error Passive. */
#define M_CAN_ECR_TEC_M			0x000000ffU		/* Receive Error Passive. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_PSR register.
 *
 */
#define M_CAN_PSR_TDCV_S		16U
#define M_CAN_PSR_TDCV_M		0x007f0000U		/* Transmitter Delay Compensation
												Value. */
#define M_CAN_PSR_PXE_M			0x00004000U		/* Protocol Exception Event. */
#define M_CAN_PSR_RFDF_M		0x00002000U		/* Received a CAN FD Message. */
#define M_CAN_PSR_RBRS_M		0x00001000U		/* BRS flag of last received
												CAN FD Message. */
#define M_CAN_PSR_RESI_M		0x00000800U		/* ESI flag of last received
												CAN FD Message. */
#define M_CAN_PSR_DLEC_S		8U
#define M_CAN_PSR_DLEC_M		0x00000700U		/* Data Phase Last Error Code. */
#define M_CAN_PSR_BO_M			0x00000080U		/* Bus_Off Status. */
#define M_CAN_PSR_EW_M			0x00000040U		/* Warning Status. */
#define M_CAN_PSR_EP_M			0x00000020U		/* Error Passive. */
#define M_CAN_PSR_ACT_S			3U
#define M_CAN_PSR_ACT_M			0x00000018U		/* Monitors the module CAN
												communication state. */
#define M_CAN_PSR_LEC_M			0x00000007U		/* Last Error Code. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TDCR register.
 *
 */
#define M_CAN_TDCR_TDCO_S		8U
#define M_CAN_TDCR_TDCO_M		0x00007f00U		/* Transmitter Delay Compensation
												SSP Offset. */
#define M_CAN_TDCR_TDCF_M		0x0000003fU		/* Transmitter Delay Compensation Filter
												Window Length. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_IR register.
 *
 */
#define M_CAN_IR_ARA_M			0x20000000U		/* Access to Reserved Address. */
#define M_CAN_IR_PED_M			0x10000000U		/* Protocol Error in Data Phase
												(Data Bit Time is used). */
#define M_CAN_IR_PEA_M			0x08000000U		/* Protocol Error in Arbitration Phase
												(Nominal Bit Time is used). */
#define M_CAN_IR_WDI_M			0x04000000U		/* Watchdog Interrupt. */
#define M_CAN_IR_BO_M			0x02000000U		/* Bus_Off Status. */
#define M_CAN_IR_EW_M			0x01000000U		/* Warning Status. */
#define M_CAN_IR_EP_M			0x00800000U		/* Error Passive. */
#define M_CAN_IR_ELO_M			0x00400000U		/* Error Logging Overflow. */
#define M_CAN_IR_BEU_M			0x00200000U		/* Bit Error Uncorrected. */
#define M_CAN_IR_BEC_M			0x00100000U		/* Bit Error Corrected. */
#define M_CAN_IR_DRX_M			0x00080000U		/* Message stored to Dedicated Rx
												Buffer. */
#define M_CAN_IR_TOO_M			0x00040000U		/* Timeout Occurred. */
#define M_CAN_IR_MRAF_M			0x00020000U		/* Message RAM Access Failure. */
#define M_CAN_IR_TSW_M			0x00010000U		/* Timestamp Wraparound. */
#define M_CAN_IR_TEFL_M			0x00008000U		/* Tx Event FIFO Element Lost. */
#define M_CAN_IR_TEFF_M			0x00004000U		/* Tx Event FIFO Full. */
#define M_CAN_IR_TEFW_M			0x00002000U		/* Tx Event FIFO Watermark Reached. */
#define M_CAN_IR_TEFN_M			0x00001000U		/* Tx Event FIFO New Entry. */
#define M_CAN_IR_TFE_M			0x00000800U		/* Tx FIFO Empty. */
#define M_CAN_IR_TCF_M			0x00000400U		/* Transmission Cancellation Finished. */
#define M_CAN_IR_TC_M			0x00000200U		/* Transmission Completed. */
#define M_CAN_IR_HPM_M			0x00000100U		/* High Priority Message. */
#define M_CAN_IR_RF1L_M			0x00000080U		/* Rx FIFO 1 Message Lost. */
#define M_CAN_IR_RF1F_M			0x00000040U		/* Rx FIFO 1 Full. */
#define M_CAN_IR_RF1W_M			0x00000020U		/* Rx FIFO 1 Watermark Reached. */
#define M_CAN_IR_RF1N_M			0x00000010U		/* Rx FIFO 1 New Message. */
#define M_CAN_IR_RF0L_M			0x00000008U		/* Rx FIFO 0 Message Lost. */
#define M_CAN_IR_RF0F_M			0x00000004U		/* Rx FIFO 0 Full. */
#define M_CAN_IR_RF0W_M			0x00000002U		/* Rx FIFO 0 Watermark Reached. */
#define M_CAN_IR_RF0N_M			0x00000001U		/* Rx FIFO 0 New Message. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_IE register.
 *
 */
#define M_CAN_IE_ARAE_M			0x20000000U		/* Access to Reserved Address Enable. */
#define M_CAN_IE_PEDE_M			0x10000000U		/* Protocol Error in Data Phase Enable. */
#define M_CAN_IE_PEAE_M			0x08000000U		/* Protocol Error in Arbitration Phase
												Enable. */
#define M_CAN_IE_WDIE_M			0x04000000U		/* Watchdog Interrupt Enable. */
#define M_CAN_IE_BOE_M			0x02000000U		/* Bus_Off Status Interrupt Enable. */
#define M_CAN_IE_EWE_M			0x01000000U		/* Warning Status Interrupt Enable. */
#define M_CAN_IE_EPE_M			0x00800000U		/* Error Passive Interrupt Enable. */
#define M_CAN_IE_ELOE_M			0x00400000U		/* Error Logging Overflow Interrupt
												Enable. */
#define M_CAN_IE_BEUE_M			0x00200000U		/* Bit Error Uncorrected Interrupt
												Enable. */
#define M_CAN_IE_BECE_M			0x00100000U		/* Bit Error Corrected Interrupt
												Enable. */
#define M_CAN_IE_DRXE_M			0x00080000U		/* Message stored to Dedicated Rx Buffer
												Interrupt Enable. */
#define M_CAN_IE_TOOE_M			0x00040000U		/* Timeout Occurred Interrupt Enable. */
#define M_CAN_IE_MRAFE_M		0x00020000U		/* Message RAM Access Failure Interrupt
												Enable. */
#define M_CAN_IE_TSWE_M			0x00010000U		/* Timestamp Wraparound Interrupt
												Enable. */
#define M_CAN_IE_TEFLE_M		0x00008000U		/* Tx Event FIFO Element Lost Interrupt
												Enable. */
#define M_CAN_IE_TEFFE_M		0x00004000U		/* Tx Event FIFO Full Interrupt Enable. */
#define M_CAN_IE_TEFWE_M		0x00002000U		/* Tx Event FIFO Watermark Reached
												Interrupt Enable. */
#define M_CAN_IE_TEFNE_M		0x00001000U		/* Tx Event FIFO New Entry Interrupt
												Enable. */
#define M_CAN_IE_TFEE_M			0x00000800U		/* Tx FIFO Empty Interrupt Enable. */
#define M_CAN_IE_TCFE_M			0x00000400U		/* Transmission Cancellation Finished
												Interrupt Enable. */
#define M_CAN_IE_TCE_M			0x00000200U		/* Transmission Completed Interrupt
												Enable. */
#define M_CAN_IE_HPME_M			0x00000100U		/* High Priority Message Interrupt
												Enable. */
#define M_CAN_IE_RF1LE_M		0x00000080U		/* Rx FIFO 1 Message Lost Interrupt
												Enable. */
#define M_CAN_IE_RF1FE_M		0x00000040U		/* Rx FIFO 1 Full Interrupt Enable. */
#define M_CAN_IE_RF1WE_M		0x00000020U		/* Rx FIFO 1 Watermark Reached Interrupt
												Enable. */
#define M_CAN_IE_RF1NE_M		0x00000010U		/* Rx FIFO 1 New Message Interrupt
												Enable. */
#define M_CAN_IE_RF0LE_M		0x00000008U		/* Rx FIFO 0 Message Lost Interrupt
												Enable. */
#define M_CAN_IE_RF0FE_M		0x00000004U		/* Rx FIFO 0 Full Interrupt Enable. */
#define M_CAN_IE_RF0WE_M		0x00000002U		/* Rx FIFO 0 Watermark Reached Interrupt
												Enable. */
#define M_CAN_IE_RF0NE_M		0x00000001U		/* Rx FIFO 0 New Message Interrupt
												Enable. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_ILS register.
 *
 */
#define M_CAN_ILS_ARAL_M		0x20000000U		/* Access to Reserved Address Line. */
#define M_CAN_ILS_PEDL_M		0x10000000U		/* Protocol Error in Data Phase Line. */
#define M_CAN_ILS_PEAL_M		0x08000000U		/* Protocol Error in Arbitration
												Phase Line. */
#define M_CAN_ILS_WDIL_M		0x04000000U		/* Watchdog Interrupt Line. */
#define M_CAN_ILS_BOL_M			0x02000000U		/* Bus_Off Status Interrupt Line. */
#define M_CAN_ILS_EWL_M			0x01000000U		/* Warning Status Interrupt Line. */
#define M_CAN_ILS_EPL_M			0x00800000U		/* Error Passive Interrupt Line. */
#define M_CAN_ILS_ELOL_M		0x00400000U		/* Error Logging Overflow Interrupt
												Line. */
#define M_CAN_ILS_BEUL_M		0x00200000U		/* Bit Error Uncorrected Interrupt
												Line. */
#define M_CAN_ILS_BECL_M		0x00100000U		/* Bit Error Corrected Interrupt Line. */
#define M_CAN_ILS_DRXL_M		0x00080000U		/* Message stored to Dedicated Rx Buffer
												Interrupt Line. */
#define M_CAN_ILS_TOOL_M		0x00040000U		/* Timeout Occurred Interrupt Line. */
#define M_CAN_ILS_MRAFL_M		0x00020000U		/* Message RAM Access Failure Interrupt
												Line. */
#define M_CAN_ILS_TSWL_M		0x00010000U		/* Timestamp Wraparound Interrupt Line. */
#define M_CAN_ILS_TEFLL_M		0x00008000U		/* Tx Event FIFO Element Lost Interrupt
												Line. */
#define M_CAN_ILS_TEFFL_M		0x00004000U		/* Tx Event FIFO Full Interrupt Line. */
#define M_CAN_ILS_TEFWL_M		0x00002000U		/* Tx Event FIFO Watermark Reached
												Interrupt Line. */
#define M_CAN_ILS_TEFNL_M		0x00001000U		/* Tx Event FIFO New Entry Interrupt
												Line. */
#define M_CAN_ILS_TFEL_M		0x00000800U		/* Tx FIFO Empty Interrupt Line. */
#define M_CAN_ILS_TCFL_M		0x00000400U		/* Transmission Cancellation Finished
												Interrupt Line. */
#define M_CAN_ILS_TCL_M			0x00000200U		/* Transmission Completed Interrupt
												Line. */
#define M_CAN_ILS_HPML_M		0x00000100U		/* High Priority Message Interrupt
												Line. */
#define M_CAN_ILS_RF1LL_M		0x00000080U		/* Rx FIFO 1 Message Lost Interrupt
												Line. */
#define M_CAN_ILS_RF1FL_M		0x00000040U		/* Rx FIFO 1 Full Interrupt Line. */
#define M_CAN_ILS_RF1WL_M		0x00000020U		/* Rx FIFO 1 Watermark Reached Interrupt
												Line. */
#define M_CAN_ILS_RF1NL_M		0x00000010U		/* Rx FIFO 1 New Message Interrupt
												Line. */
#define M_CAN_ILS_RF0LL_M		0x00000008U		/* Rx FIFO 0 Message Lost Interrupt
												Line. */
#define M_CAN_ILS_RF0FL_M		0x00000004U		/* Rx FIFO 0 Full Interrupt Line. */
#define M_CAN_ILS_RF0WL_M		0x00000002U		/* Rx FIFO 0 Watermark Reached Interrupt
												Line. */
#define M_CAN_ILS_RF0NL_M		0x00000001U		/* Rx FIFO 0 New Message Interrupt
												Line. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_ILE register.
 *
 */
#define M_CAN_ILE_EINT1_M		0x00000002U		/* Enable Interrupt Line 1. */
#define M_CAN_ILE_EINT0_M		0x00000001U		/* Enable Interrupt Line 0. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_GFC register.
 *
 */
#define M_CAN_GFC_ANFS_S		4U
#define M_CAN_GFC_ANFS_M		0x00000030U		/* Accept Non-matching Frames Standard. */
#define M_CAN_GFC_ANFE_S		2U
#define M_CAN_GFC_ANFE_M		0x0000000cU		/* Accept Non-matching Frames Extended. */
#define M_CAN_GFC_RRFS_M		0x00000002U		/* Reject Remote Frames Standard. */
#define M_CAN_GFC_RRFE_M		0x00000001U		/* Reject Remote Frames Extended. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_SIDFC register.
 *
 */
#define M_CAN_SIDFC_LSS_S		16U
#define M_CAN_SIDFC_LSS_M		0x00ff0000U		/* List Size Standard. */
#define M_CAN_SIDFC_FLSSA_S		2U
#define M_CAN_SIDFC_FLSSA_M		0x0000fffcU		/* Filter List Standard Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_XIDFC register.
 *
 */
#define M_CAN_XIDFC_LSE_S		16U
#define M_CAN_XIDFC_LSE_M		0x007f0000U		/* List Size Extended. */
#define M_CAN_XIDFC_FLESA_S		2U
#define M_CAN_XIDFC_FLESA_M		0x0000fffcU		/* Filter List Extended Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_XIDAM register.
 *
 */
#define M_CAN_XIDAM_EIDM_M		0x1fffffffU		/* Extended ID Mask. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_HPMS register.
 *
 */
#define M_CAN_HPMS_FLST_S		15U
#define M_CAN_HPMS_FLST_M		0x00008000U		/* Indicates the filter list of the
												matching filter element. */
#define M_CAN_HPMS_FIDX_S		8U
#define M_CAN_HPMS_FIDX_M		0x00007f00U		/* Index of matching filter element.
												Range is 0 to SIDFC.LSS - 1 resp.XIDFC.LSE - 1. */
#define M_CAN_HPMS_MSI_S		6U
#define M_CAN_HPMS_MSI_M		0x000000c0U		/* Message Storage Indicator. */
#define M_CAN_HPMS_BIDX_M		0x0000003fU		/* Index of Rx FIFO element to which the
												message was stored. Only valid when
												MSI[1] = 1. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_NDAT1 register.
 *
 */
#define M_CAN_NDAT1_ND31_M		0x80000000U		/* New Data flags of Rx Buffers 31. */
#define M_CAN_NDAT1_ND30_M		0x40000000U		/* New Data flags of Rx Buffers 30. */
#define M_CAN_NDAT1_ND29_M		0x20000000U		/* New Data flags of Rx Buffers 29. */
#define M_CAN_NDAT1_ND28_M		0x10000000U		/* New Data flags of Rx Buffers 28. */
#define M_CAN_NDAT1_ND27_M		0x08000000U		/* New Data flags of Rx Buffers 27. */
#define M_CAN_NDAT1_ND26_M		0x04000000U		/* New Data flags of Rx Buffers 26. */
#define M_CAN_NDAT1_ND25_M		0x02000000U		/* New Data flags of Rx Buffers 25. */
#define M_CAN_NDAT1_ND24_M		0x01000000U		/* New Data flags of Rx Buffers 24. */
#define M_CAN_NDAT1_ND23_M		0x00800000U		/* New Data flags of Rx Buffers 23. */
#define M_CAN_NDAT1_ND22_M		0x00400000U		/* New Data flags of Rx Buffers 22. */
#define M_CAN_NDAT1_ND21_M		0x00200000U		/* New Data flags of Rx Buffers 21. */
#define M_CAN_NDAT1_ND20_M		0x00100000U		/* New Data flags of Rx Buffers 20. */
#define M_CAN_NDAT1_ND19_M		0x00080000U		/* New Data flags of Rx Buffers 19. */
#define M_CAN_NDAT1_ND18_M		0x00040000U		/* New Data flags of Rx Buffers 18. */
#define M_CAN_NDAT1_ND17_M		0x00020000U		/* New Data flags of Rx Buffers 17. */
#define M_CAN_NDAT1_ND16_M		0x00010000U		/* New Data flags of Rx Buffers 16. */
#define M_CAN_NDAT1_ND15_M		0x00008000U		/* New Data flags of Rx Buffers 15. */
#define M_CAN_NDAT1_ND14_M		0x00004000U		/* New Data flags of Rx Buffers 14. */
#define M_CAN_NDAT1_ND13_M		0x00002000U		/* New Data flags of Rx Buffers 13. */
#define M_CAN_NDAT1_ND12_M		0x00001000U		/* New Data flags of Rx Buffers 12. */
#define M_CAN_NDAT1_ND11_M		0x00000800U		/* New Data flags of Rx Buffers 11. */
#define M_CAN_NDAT1_ND10_M		0x00000400U		/* New Data flags of Rx Buffers 10. */
#define M_CAN_NDAT1_ND9_M		0x00000200U		/* New Data flags of Rx Buffers 9. */
#define M_CAN_NDAT1_ND8_M		0x00000100U		/* New Data flags of Rx Buffers 8. */
#define M_CAN_NDAT1_ND7_M		0x00000080U		/* New Data flags of Rx Buffers 7. */
#define M_CAN_NDAT1_ND6_M		0x00000040U		/* New Data flags of Rx Buffers 6. */
#define M_CAN_NDAT1_ND5_M		0x00000020U		/* New Data flags of Rx Buffers 5. */
#define M_CAN_NDAT1_ND4_M		0x00000010U		/* New Data flags of Rx Buffers 4. */
#define M_CAN_NDAT1_ND3_M		0x00000008U		/* New Data flags of Rx Buffers 3. */
#define M_CAN_NDAT1_ND2_M		0x00000004U		/* New Data flags of Rx Buffers 2. */
#define M_CAN_NDAT1_ND1_M		0x00000002U		/* New Data flags of Rx Buffers 1. */
#define M_CAN_NDAT1_ND0_M		0x00000001U		/* New Data flags of Rx Buffers 0. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_NDAT2 register.
 *
 */
#define M_CAN_NDAT2_ND63_M		0x80000000U		/* New Data flags of Rx Buffers 63. */
#define M_CAN_NDAT2_ND62_M		0x40000000U		/* New Data flags of Rx Buffers 62. */
#define M_CAN_NDAT2_ND61_M		0x20000000U		/* New Data flags of Rx Buffers 61. */
#define M_CAN_NDAT2_ND60_M		0x10000000U		/* New Data flags of Rx Buffers 60. */
#define M_CAN_NDAT2_ND59_M		0x08000000U		/* New Data flags of Rx Buffers 59. */
#define M_CAN_NDAT2_ND58_M		0x04000000U		/* New Data flags of Rx Buffers 58. */
#define M_CAN_NDAT2_ND57_M		0x02000000U		/* New Data flags of Rx Buffers 57. */
#define M_CAN_NDAT2_ND56_M		0x01000000U		/* New Data flags of Rx Buffers 56. */
#define M_CAN_NDAT2_ND55_M		0x00800000U		/* New Data flags of Rx Buffers 55. */
#define M_CAN_NDAT2_ND54_M		0x00400000U		/* New Data flags of Rx Buffers 54. */
#define M_CAN_NDAT2_ND53_M		0x00200000U		/* New Data flags of Rx Buffers 53. */
#define M_CAN_NDAT2_ND52_M		0x00100000U		/* New Data flags of Rx Buffers 52. */
#define M_CAN_NDAT2_ND51_M		0x00080000U		/* New Data flags of Rx Buffers 51. */
#define M_CAN_NDAT2_ND50_M		0x00040000U		/* New Data flags of Rx Buffers 50. */
#define M_CAN_NDAT2_ND49_M		0x00020000U		/* New Data flags of Rx Buffers 49. */
#define M_CAN_NDAT2_ND48_M		0x00010000U		/* New Data flags of Rx Buffers 48. */
#define M_CAN_NDAT2_ND47_M		0x00008000U		/* New Data flags of Rx Buffers 47. */
#define M_CAN_NDAT2_ND46_M		0x00004000U		/* New Data flags of Rx Buffers 46. */
#define M_CAN_NDAT2_ND45_M		0x00002000U		/* New Data flags of Rx Buffers 45. */
#define M_CAN_NDAT2_ND44_M		0x00001000U		/* New Data flags of Rx Buffers 44. */
#define M_CAN_NDAT2_ND43_M		0x00000800U		/* New Data flags of Rx Buffers 43. */
#define M_CAN_NDAT2_ND42_M		0x00000400U		/* New Data flags of Rx Buffers 42. */
#define M_CAN_NDAT2_ND41_M		0x00000200U		/* New Data flags of Rx Buffers 41. */
#define M_CAN_NDAT2_ND40_M		0x00000100U		/* New Data flags of Rx Buffers 40. */
#define M_CAN_NDAT2_ND39_M		0x00000080U		/* New Data flags of Rx Buffers 39. */
#define M_CAN_NDAT2_ND38_M		0x00000040U		/* New Data flags of Rx Buffers 38. */
#define M_CAN_NDAT2_ND37_M		0x00000020U		/* New Data flags of Rx Buffers 37. */
#define M_CAN_NDAT2_ND36_M		0x00000010U		/* New Data flags of Rx Buffers 36. */
#define M_CAN_NDAT2_ND35_M		0x00000008U		/* New Data flags of Rx Buffers 35. */
#define M_CAN_NDAT2_ND34_M		0x00000004U		/* New Data flags of Rx Buffers 34. */
#define M_CAN_NDAT2_ND33_M		0x00000002U		/* New Data flags of Rx Buffers 33. */
#define M_CAN_NDAT2_ND32_M		0x00000001U		/* New Data flags of Rx Buffers 32. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF0C register.
 *
 */
#define M_CAN_RXF0C_F0OM_S		31U
#define M_CAN_RXF0C_F0OM_M		0x80000000U		/* FIFO 0 Operation Mode. */
#define M_CAN_RXF0C_F0WM_S		24U
#define M_CAN_RXF0C_F0WM_M		0x7f000000U		/* Rx FIFO 0 Watermark. */
#define M_CAN_RXF0C_F0S_S		16U
#define M_CAN_RXF0C_F0S_M		0x007f0000U		/* Rx FIFO 0 Size. */
#define M_CAN_RXF0C_F0SA_S		2U
#define M_CAN_RXF0C_F0SA_M		0x0000fffcU		/* Rx FIFO 0 Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF0S register.
 *
 */
#define M_CAN_RXF0S_RF0L_M		0x02000000U		/* Rx FIFO 0 Message Lost. */
#define M_CAN_RXF0S_F0F_M		0x01000000U		/* Rx FIFO 0 Full. */
#define M_CAN_RXF0S_F0PI_S		16U
#define M_CAN_RXF0S_F0PI_M		0x003f0000U		/* Rx FIFO 0 write index pointer,
												range 0 to 63. */
#define M_CAN_RXF0S_F0GI_S		8U
#define M_CAN_RXF0S_F0GI_M		0x00003f00U		/* Rx FIFO 0 read index pointer,
												range 0 to 63. */
#define M_CAN_RXF0S_F0FL_M		0x0000007fU		/* Number of elements stored in Rx FIFO 0,
												range 0 to 64. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF0A register.
 *
 */
#define M_CAN_RXF0A_F0AI_M		0x0000003fU		/* Rx FIFO 0 Acknowledge Index. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXBC register.
 *
 */
#define M_CAN_RXBC_RBSA_S		2U
#define M_CAN_RXBC_RBSA_M		0x0000fffcU		/* Rx Buffer Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF1C register.
 *
 */
#define M_CAN_RXF1C_F1OM_S		31U
#define M_CAN_RXF1C_F1OM_M		0x80000000U		/* FIFO 1 Operation Mode. */
#define M_CAN_RXF1C_F1WM_S		24U
#define M_CAN_RXF1C_F1WM_M		0x7f000000U		/* Rx FIFO 1 Watermark. */
#define M_CAN_RXF1C_F1S_S		16U
#define M_CAN_RXF1C_F1S_M		0x007f0000U		/* Rx FIFO 1 Size. */
#define M_CAN_RXF1C_F1SA_S		2U
#define M_CAN_RXF1C_F1SA_M		0x0000fffcU		/* Rx FIFO 1 Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF1S register.
 *
 */
#define M_CAN_RXF1S_DMS_S		30U
#define M_CAN_RXF1S_DMS_M		0xc0000000U		/* Debug Message Status. */
#define M_CAN_RXF1S_RF1L_M		0x02000000U		/* Rx FIFO 1 Message Lost. */
#define M_CAN_RXF1S_F1F_M		0x01000000U		/* Rx FIFO 1 Full. */
#define M_CAN_RXF1S_F1PI_S		16U
#define M_CAN_RXF1S_F1PI_M		0x003f0000U		/* Rx FIFO 1 Put Index. range 0 to 63. */
#define M_CAN_RXF1S_F1GI_S		8U
#define M_CAN_RXF1S_F1GI_M		0x00003f00U		/* Rx FIFO 0 read index pointer,
												range 0 to 63. */
#define M_CAN_RXF1S_F1FL_M		0x0000007fU		/* Rx FIFO 1 Fill Level. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXF1A register.
 *
 */
#define M_CAN_RXF1A_F1AI_M		0x0000003fU		/* Rx FIFO 1 Acknowledge Index. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_RXESC register.
 *
 */
#define M_CAN_RXESC_RBDS_S		8U
#define M_CAN_RXESC_RBDS_M		0x00000700U		/* Rx Buffer Data Field Size. */
#define M_CAN_RXESC_F1DS_S		4U
#define M_CAN_RXESC_F1DS_M		0x00000070U		/* Rx FIFO 1 Data Field Size. */
#define M_CAN_RXESC_F0DS_M		0x00000007U		/* Rx FIFO 0 Data Field Size. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBC register.
 *
 */
#define M_CAN_TXBC_TFQM_S		30U
#define M_CAN_TXBC_TFQM_M		0x40000000U		/* Tx FIFO/Queue Mode. */
#define M_CAN_TXBC_TFQS_S		24U
#define M_CAN_TXBC_TFQS_M		0x3f000000U		/* Transmit FIFO/Queue Size. */
#define M_CAN_TXBC_NDTB_S		16U
#define M_CAN_TXBC_NDTB_M		0x003f0000U		/* Number of Dedicated Transmit
												Buffers. */
#define M_CAN_TXBC_TBSA_S		2U
#define M_CAN_TXBC_TBSA_M		0x0000fffcU		/* Tx Buffers Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXFQS register.
 *
 */
#define M_CAN_TXFQS_TFQF_M		0x00200000U		/* Tx FIFO/Queue Full. */
#define M_CAN_TXFQS_TFQPI_S		16U
#define M_CAN_TXFQS_TFQPI_M		0x001f0000U		/* Tx FIFO/Queue Put Index. */
#define M_CAN_TXFQS_TFGI_S		8U
#define M_CAN_TXFQS_TFGI_M		0x00001f00U		/* Tx FIFO Get Index. */
#define M_CAN_TXFQS_TFFL_M		0x0000003fU		/* Tx FIFO Free Level. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXESC register.
 *
 */
#define M_CAN_TXESC_TBDS_M		0x00000007U		/* Tx Buffer Data Field Size. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBRP register.
 *
 */
#define M_CAN_TXBRP_TRP31_M		0x80000000U		/* Tx Buffer 31 Request Pending. */
#define M_CAN_TXBRP_TRP30_M		0x40000000U		/* Tx Buffer 30 Request Pending. */
#define M_CAN_TXBRP_TRP29_M		0x20000000U		/* Tx Buffer 29 Request Pending. */
#define M_CAN_TXBRP_TRP28_M		0x10000000U		/* Tx Buffer 28 Request Pending. */
#define M_CAN_TXBRP_TRP27_M		0x08000000U		/* Tx Buffer 27 Request Pending. */
#define M_CAN_TXBRP_TRP26_M		0x04000000U		/* Tx Buffer 26 Request Pending. */
#define M_CAN_TXBRP_TRP25_M		0x02000000U		/* Tx Buffer 25 Request Pending. */
#define M_CAN_TXBRP_TRP24_M		0x01000000U		/* Tx Buffer 24 Request Pending. */
#define M_CAN_TXBRP_TRP23_M		0x00800000U		/* Tx Buffer 23 Request Pending. */
#define M_CAN_TXBRP_TRP22_M		0x00400000U		/* Tx Buffer 22 Request Pending. */
#define M_CAN_TXBRP_TRP21_M		0x00200000U		/* Tx Buffer 21 Request Pending. */
#define M_CAN_TXBRP_TRP20_M		0x00100000U		/* Tx Buffer 20 Request Pending. */
#define M_CAN_TXBRP_TRP19_M		0x00080000U		/* Tx Buffer 19 Request Pending. */
#define M_CAN_TXBRP_TRP18_M		0x00040000U		/* Tx Buffer 18 Request Pending. */
#define M_CAN_TXBRP_TRP17_M		0x00020000U		/* Tx Buffer 17 Request Pending. */
#define M_CAN_TXBRP_TRP16_M		0x00010000U		/* Tx Buffer 16 Request Pending. */
#define M_CAN_TXBRP_TRP15_M		0x00008000U		/* Tx Buffer 15 Request Pending. */
#define M_CAN_TXBRP_TRP14_M		0x00004000U		/* Tx Buffer 14 Request Pending. */
#define M_CAN_TXBRP_TRP13_M		0x00002000U		/* Tx Buffer 13 Request Pending. */
#define M_CAN_TXBRP_TRP12_M		0x00001000U		/* Tx Buffer 12 Request Pending. */
#define M_CAN_TXBRP_TRP11_M		0x00000800U		/* Tx Buffer 11 Request Pending. */
#define M_CAN_TXBRP_TRP10_M		0x00000400U		/* Tx Buffer 10 Request Pending. */
#define M_CAN_TXBRP_TRP9_M		0x00000200U		/* Tx Buffer 9 Request Pending. */
#define M_CAN_TXBRP_TRP8_M		0x00000100U		/* Tx Buffer 8 Request Pending. */
#define M_CAN_TXBRP_TRP7_M		0x00000080U		/* Tx Buffer 7 Request Pending. */
#define M_CAN_TXBRP_TRP6_M		0x00000040U		/* Tx Buffer 6 Request Pending. */
#define M_CAN_TXBRP_TRP5_M		0x00000020U		/* Tx Buffer 5 Request Pending. */
#define M_CAN_TXBRP_TRP4_M		0x00000010U		/* Tx Buffer 4 Request Pending. */
#define M_CAN_TXBRP_TRP3_M		0x00000008U		/* Tx Buffer 3 Request Pending. */
#define M_CAN_TXBRP_TRP2_M		0x00000004U		/* Tx Buffer 2 Request Pending. */
#define M_CAN_TXBRP_TRP1_M		0x00000002U		/* Tx Buffer 1 Request Pending. */
#define M_CAN_TXBRP_TRP0_M		0x00000001U		/* Tx Buffer 0 Request Pending. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBAR register.
 *
 */
#define M_CAN_TXBAR_AR31_M		0x80000000U		/* Tx Buffer 31 Add Request. */
#define M_CAN_TXBAR_AR30_M		0x40000000U		/* Tx Buffer 30 Add Request. */
#define M_CAN_TXBAR_AR29_M		0x20000000U		/* Tx Buffer 29 Add Request. */
#define M_CAN_TXBAR_AR28_M		0x10000000U		/* Tx Buffer 28 Add Request. */
#define M_CAN_TXBAR_AR27_M		0x08000000U		/* Tx Buffer 27 Add Request. */
#define M_CAN_TXBAR_AR26_M		0x04000000U		/* Tx Buffer 26 Add Request. */
#define M_CAN_TXBAR_AR25_M		0x02000000U		/* Tx Buffer 25 Add Request. */
#define M_CAN_TXBAR_AR24_M		0x01000000U		/* Tx Buffer 24 Add Request. */
#define M_CAN_TXBAR_AR23_M		0x00800000U		/* Tx Buffer 23 Add Request. */
#define M_CAN_TXBAR_AR22_M		0x00400000U		/* Tx Buffer 22 Add Request. */
#define M_CAN_TXBAR_AR21_M		0x00200000U		/* Tx Buffer 21 Add Request. */
#define M_CAN_TXBAR_AR20_M		0x00100000U		/* Tx Buffer 20 Add Request. */
#define M_CAN_TXBAR_AR19_M		0x00080000U		/* Tx Buffer 19 Add Request. */
#define M_CAN_TXBAR_AR18_M		0x00040000U		/* Tx Buffer 18 Add Request. */
#define M_CAN_TXBAR_AR17_M		0x00020000U		/* Tx Buffer 17 Add Request. */
#define M_CAN_TXBAR_AR16_M		0x00010000U		/* Tx Buffer 16 Add Request. */
#define M_CAN_TXBAR_AR15_M		0x00008000U		/* Tx Buffer 15 Add Request. */
#define M_CAN_TXBAR_AR14_M		0x00004000U		/* Tx Buffer 14 Add Request. */
#define M_CAN_TXBAR_AR13_M		0x00002000U		/* Tx Buffer 13 Add Request. */
#define M_CAN_TXBAR_AR12_M		0x00001000U		/* Tx Buffer 12 Add Request. */
#define M_CAN_TXBAR_AR11_M		0x00000800U		/* Tx Buffer 11 Add Request. */
#define M_CAN_TXBAR_AR10_M		0x00000400U		/* Tx Buffer 10 Add Request. */
#define M_CAN_TXBAR_AR9_M		0x00000200U		/* Tx Buffer 9 Add Request. */
#define M_CAN_TXBAR_AR8_M		0x00000100U		/* Tx Buffer 8 Add Request. */
#define M_CAN_TXBAR_AR7_M		0x00000080U		/* Tx Buffer 7 Add Request. */
#define M_CAN_TXBAR_AR6_M		0x00000040U		/* Tx Buffer 6 Add Request. */
#define M_CAN_TXBAR_AR5_M		0x00000020U		/* Tx Buffer 5 Add Request. */
#define M_CAN_TXBAR_AR4_M		0x00000010U		/* Tx Buffer 4 Add Request. */
#define M_CAN_TXBAR_AR3_M		0x00000008U		/* Tx Buffer 3 Add Request. */
#define M_CAN_TXBAR_AR2_M		0x00000004U		/* Tx Buffer 2 Add Request. */
#define M_CAN_TXBAR_AR1_M		0x00000002U		/* Tx Buffer 1 Add Request. */
#define M_CAN_TXBAR_AR0_M		0x00000001U		/* Tx Buffer 0 Add Request. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBCR register.
 *
 */
#define M_CAN_TXBCR_CR31_M		0x80000000U		/* Tx Buffer 31 Cancellation Request. */
#define M_CAN_TXBCR_CR30_M		0x40000000U		/* Tx Buffer 30 Cancellation Request. */
#define M_CAN_TXBCR_CR29_M		0x20000000U		/* Tx Buffer 29 Cancellation Request. */
#define M_CAN_TXBCR_CR28_M		0x10000000U		/* Tx Buffer 28 Cancellation Request. */
#define M_CAN_TXBCR_CR27_M		0x08000000U		/* Tx Buffer 27 Cancellation Request. */
#define M_CAN_TXBCR_CR26_M		0x04000000U		/* Tx Buffer 26 Cancellation Request. */
#define M_CAN_TXBCR_CR25_M		0x02000000U		/* Tx Buffer 25 Cancellation Request. */
#define M_CAN_TXBCR_CR24_M		0x01000000U		/* Tx Buffer 24 Cancellation Request. */
#define M_CAN_TXBCR_CR23_M		0x00800000U		/* Tx Buffer 23 Cancellation Request. */
#define M_CAN_TXBCR_CR22_M		0x00400000U		/* Tx Buffer 22 Cancellation Request. */
#define M_CAN_TXBCR_CR21_M		0x00200000U		/* Tx Buffer 21 Cancellation Request. */
#define M_CAN_TXBCR_CR20_M		0x00100000U		/* Tx Buffer 20 Cancellation Request. */
#define M_CAN_TXBCR_CR19_M		0x00080000U		/* Tx Buffer 19 Cancellation Request. */
#define M_CAN_TXBCR_CR18_M		0x00040000U		/* Tx Buffer 18 Cancellation Request. */
#define M_CAN_TXBCR_CR17_M		0x00020000U		/* Tx Buffer 17 Cancellation Request. */
#define M_CAN_TXBCR_CR16_M		0x00010000U		/* Tx Buffer 16 Cancellation Request. */
#define M_CAN_TXBCR_CR15_M		0x00008000U		/* Tx Buffer 15 Cancellation Request. */
#define M_CAN_TXBCR_CR14_M		0x00004000U		/* Tx Buffer 14 Cancellation Request. */
#define M_CAN_TXBCR_CR13_M		0x00002000U		/* Tx Buffer 13 Cancellation Request. */
#define M_CAN_TXBCR_CR12_M		0x00001000U		/* Tx Buffer 12 Cancellation Request. */
#define M_CAN_TXBCR_CR11_M		0x00000800U		/* Tx Buffer 11 Cancellation Request. */
#define M_CAN_TXBCR_CR10_M		0x00000400U		/* Tx Buffer 10 Cancellation Request. */
#define M_CAN_TXBCR_CR9_M		0x00000200U		/* Tx Buffer 9 Cancellation Request. */
#define M_CAN_TXBCR_CR8_M		0x00000100U		/* Tx Buffer 8 Cancellation Request. */
#define M_CAN_TXBCR_CR7_M		0x00000080U		/* Tx Buffer 7 Cancellation Request. */
#define M_CAN_TXBCR_CR6_M		0x00000040U		/* Tx Buffer 6 Cancellation Request. */
#define M_CAN_TXBCR_CR5_M		0x00000020U		/* Tx Buffer 5 Cancellation Request. */
#define M_CAN_TXBCR_CR4_M		0x00000010U		/* Tx Buffer 4 Cancellation Request. */
#define M_CAN_TXBCR_CR3_M		0x00000008U		/* Tx Buffer 3 Cancellation Request. */
#define M_CAN_TXBCR_CR2_M		0x00000004U		/* Tx Buffer 2 Cancellation Request. */
#define M_CAN_TXBCR_CR1_M		0x00000002U		/* Tx Buffer 1 Cancellation Request. */
#define M_CAN_TXBCR_CR0_M		0x00000001U		/* Tx Buffer 0 Cancellation Request. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBTO register.
 *
 */
#define M_CAN_TXBTO_TO31_M		0x80000000U		/* Tx Buffer 31 Transmission Occurred. */
#define M_CAN_TXBTO_TO30_M		0x40000000U		/* Tx Buffer 30 Transmission Occurred. */
#define M_CAN_TXBTO_TO29_M		0x20000000U		/* Tx Buffer 29 Transmission Occurred. */
#define M_CAN_TXBTO_TO28_M		0x10000000U		/* Tx Buffer 28 Transmission Occurred. */
#define M_CAN_TXBTO_TO27_M		0x08000000U		/* Tx Buffer 27 Transmission Occurred. */
#define M_CAN_TXBTO_TO26_M		0x04000000U		/* Tx Buffer 26 Transmission Occurred. */
#define M_CAN_TXBTO_TO25_M		0x02000000U		/* Tx Buffer 25 Transmission Occurred. */
#define M_CAN_TXBTO_TO24_M		0x01000000U		/* Tx Buffer 24 Transmission Occurred. */
#define M_CAN_TXBTO_TO23_M		0x00800000U		/* Tx Buffer 23 Transmission Occurred. */
#define M_CAN_TXBTO_TO22_M		0x00400000U		/* Tx Buffer 22 Transmission Occurred. */
#define M_CAN_TXBTO_TO21_M		0x00200000U		/* Tx Buffer 21 Transmission Occurred. */
#define M_CAN_TXBTO_TO20_M		0x00100000U		/* Tx Buffer 20 Transmission Occurred. */
#define M_CAN_TXBTO_TO19_M		0x00080000U		/* Tx Buffer 19 Transmission Occurred. */
#define M_CAN_TXBTO_TO18_M		0x00040000U		/* Tx Buffer 18 Transmission Occurred. */
#define M_CAN_TXBTO_TO17_M		0x00020000U		/* Tx Buffer 17 Transmission Occurred. */
#define M_CAN_TXBTO_TO16_M		0x00010000U		/* Tx Buffer 16 Transmission Occurred. */
#define M_CAN_TXBTO_TO15_M		0x00008000U		/* Tx Buffer 15 Transmission Occurred. */
#define M_CAN_TXBTO_TO14_M		0x00004000U		/* Tx Buffer 14 Transmission Occurred. */
#define M_CAN_TXBTO_TO13_M		0x00002000U		/* Tx Buffer 13 Transmission Occurred. */
#define M_CAN_TXBTO_TO12_M		0x00001000U		/* Tx Buffer 12 Transmission Occurred. */
#define M_CAN_TXBTO_TO11_M		0x00000800U		/* Tx Buffer 11 Transmission Occurred. */
#define M_CAN_TXBTO_TO10_M		0x00000400U		/* Tx Buffer 10 Transmission Occurred. */
#define M_CAN_TXBTO_TO9_M		0x00000200U		/* Tx Buffer 9 Transmission Occurred. */
#define M_CAN_TXBTO_TO8_M		0x00000100U		/* Tx Buffer 8 Transmission Occurred. */
#define M_CAN_TXBTO_TO7_M		0x00000080U		/* Tx Buffer 7 Transmission Occurred. */
#define M_CAN_TXBTO_TO6_M		0x00000040U		/* Tx Buffer 6 Transmission Occurred. */
#define M_CAN_TXBTO_TO5_M		0x00000020U		/* Tx Buffer 5 Transmission Occurred. */
#define M_CAN_TXBTO_TO4_M		0x00000010U		/* Tx Buffer 4 Transmission Occurred. */
#define M_CAN_TXBTO_TO3_M		0x00000008U		/* Tx Buffer 3 Transmission Occurred. */
#define M_CAN_TXBTO_TO2_M		0x00000004U		/* Tx Buffer 2 Transmission Occurred. */
#define M_CAN_TXBTO_TO1_M		0x00000002U		/* Tx Buffer 1 Transmission Occurred. */
#define M_CAN_TXBTO_TO0_M		0x00000001U		/* Tx Buffer 0 Transmission Occurred. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBCF register.
 *
 */
#define M_CAN_TXBCF_CF31_M		0x80000000U		/* Tx Buffer 31 Cancellation Finished. */
#define M_CAN_TXBCF_CF30_M		0x40000000U		/* Tx Buffer 30 Cancellation Finished. */
#define M_CAN_TXBCF_CF29_M		0x20000000U		/* Tx Buffer 29 Cancellation Finished. */
#define M_CAN_TXBCF_CF28_M		0x10000000U		/* Tx Buffer 28 Cancellation Finished. */
#define M_CAN_TXBCF_CF27_M		0x08000000U		/* Tx Buffer 27 Cancellation Finished. */
#define M_CAN_TXBCF_CF26_M		0x04000000U		/* Tx Buffer 26 Cancellation Finished. */
#define M_CAN_TXBCF_CF25_M		0x02000000U		/* Tx Buffer 25 Cancellation Finished. */
#define M_CAN_TXBCF_CF24_M		0x01000000U		/* Tx Buffer 24 Cancellation Finished. */
#define M_CAN_TXBCF_CF23_M		0x00800000U		/* Tx Buffer 23 Cancellation Finished. */
#define M_CAN_TXBCF_CF22_M		0x00400000U		/* Tx Buffer 22 Cancellation Finished. */
#define M_CAN_TXBCF_CF21_M		0x00200000U		/* Tx Buffer 21 Cancellation Finished. */
#define M_CAN_TXBCF_CF20_M		0x00100000U		/* Tx Buffer 20 Cancellation Finished. */
#define M_CAN_TXBCF_CF19_M		0x00080000U		/* Tx Buffer 19 Cancellation Finished. */
#define M_CAN_TXBCF_CF18_M		0x00040000U		/* Tx Buffer 18 Cancellation Finished. */
#define M_CAN_TXBCF_CF17_M		0x00020000U		/* Tx Buffer 17 Cancellation Finished. */
#define M_CAN_TXBCF_CF16_M		0x00010000U		/* Tx Buffer 16 Cancellation Finished. */
#define M_CAN_TXBCF_CF15_M		0x00008000U		/* Tx Buffer 15 Cancellation Finished. */
#define M_CAN_TXBCF_CF14_M		0x00004000U		/* Tx Buffer 14 Cancellation Finished. */
#define M_CAN_TXBCF_CF13_M		0x00002000U		/* Tx Buffer 13 Cancellation Finished. */
#define M_CAN_TXBCF_CF12_M		0x00001000U		/* Tx Buffer 12 Cancellation Finished. */
#define M_CAN_TXBCF_CF11_M		0x00000800U		/* Tx Buffer 11 Cancellation Finished. */
#define M_CAN_TXBCF_CF10_M		0x00000400U		/* Tx Buffer 10 Cancellation Finished. */
#define M_CAN_TXBCF_CF9_M		0x00000200U		/* Tx Buffer 9 Cancellation Finished. */
#define M_CAN_TXBCF_CF8_M		0x00000100U		/* Tx Buffer 8 Cancellation Finished. */
#define M_CAN_TXBCF_CF7_M		0x00000080U		/* Tx Buffer 7 Cancellation Finished. */
#define M_CAN_TXBCF_CF6_M		0x00000040U		/* Tx Buffer 6 Cancellation Finished. */
#define M_CAN_TXBCF_CF5_M		0x00000020U		/* Tx Buffer 5 Cancellation Finished. */
#define M_CAN_TXBCF_CF4_M		0x00000010U		/* Tx Buffer 4 Cancellation Finished. */
#define M_CAN_TXBCF_CF3_M		0x00000008U		/* Tx Buffer 3 Cancellation Finished. */
#define M_CAN_TXBCF_CF2_M		0x00000004U		/* Tx Buffer 2 Cancellation Finished. */
#define M_CAN_TXBCF_CF1_M		0x00000002U		/* Tx Buffer 1 Cancellation Finished. */
#define M_CAN_TXBCF_CF0_M		0x00000001U		/* Tx Buffer 0 Cancellation Finished. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBTIE register.
 *
 */
#define M_CAN_TXBTIE_TIE31_M	0x80000000U		/* Tx Buffer 31 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE30_M	0x40000000U		/* Tx Buffer 30 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE29_M	0x20000000U		/* Tx Buffer 29 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE28_M	0x10000000U		/* Tx Buffer 28 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE27_M	0x08000000U		/* Tx Buffer 27 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE26_M	0x04000000U		/* Tx Buffer 26 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE25_M	0x02000000U		/* Tx Buffer 25 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE24_M	0x01000000U		/* Tx Buffer 24 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE23_M	0x00800000U		/* Tx Buffer 23 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE22_M	0x00400000U		/* Tx Buffer 22 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE21_M	0x00200000U		/* Tx Buffer 21 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE20_M	0x00100000U		/* Tx Buffer 20 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE19_M	0x00080000U		/* Tx Buffer 19 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE18_M	0x00040000U		/* Tx Buffer 18 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE17_M	0x00020000U		/* Tx Buffer 17 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE16_M	0x00010000U		/* Tx Buffer 16 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE15_M	0x00008000U		/* Tx Buffer 15 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE14_M	0x00004000U		/* Tx Buffer 14 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE13_M	0x00002000U		/* Tx Buffer 13 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE12_M	0x00001000U		/* Tx Buffer 12 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE11_M	0x00000800U		/* Tx Buffer 11 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE10_M	0x00000400U		/* Tx Buffer 10 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE9_M		0x00000200U		/* Tx Buffer 9 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE8_M		0x00000100U		/* Tx Buffer 8 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE7_M		0x00000080U		/* Tx Buffer 7 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE6_M		0x00000040U		/* Tx Buffer 6 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE5_M		0x00000020U		/* Tx Buffer 5 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE4_M		0x00000010U		/* Tx Buffer 4 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE3_M		0x00000008U		/* Tx Buffer 3 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE2_M		0x00000004U		/* Tx Buffer 2 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE1_M		0x00000002U		/* Tx Buffer 1 Transmission Interrupt
												Enable. */
#define M_CAN_TXBTIE_TIE0_M		0x00000001U		/* Tx Buffer 0 Transmission Interrupt
												Enable. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXBCIE register.
 *
 */
#define M_CAN_TXBCIE_CFIE31_M	0x80000000U		/* Tx Buffer 31 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE30_M	0x40000000U		/* Tx Buffer 30 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE29_M	0x20000000U		/* Tx Buffer 29 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE28_M	0x10000000U		/* Tx Buffer 28 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE27_M	0x08000000U		/* Tx Buffer 27 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE26_M	0x04000000U		/* Tx Buffer 26 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE25_M	0x02000000U		/* Tx Buffer 25 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE24_M	0x01000000U		/* Tx Buffer 24 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE23_M	0x00800000U		/* Tx Buffer 23 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE22_M	0x00400000U		/* Tx Buffer 22 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE21_M	0x00200000U		/* Tx Buffer 21 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE20_M	0x00100000U		/* Tx Buffer 20 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE19_M	0x00080000U		/* Tx Buffer 19 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE18_M	0x00040000U		/* Tx Buffer 18 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE17_M	0x00020000U		/* Tx Buffer 17 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE16_M	0x00010000U		/* Tx Buffer 16 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE15_M	0x00008000U		/* Tx Buffer 15 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE14_M	0x00004000U		/* Tx Buffer 14 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE13_M	0x00002000U		/* Tx Buffer 13 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE12_M	0x00001000U		/* Tx Buffer 12 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE11_M	0x00000800U		/* Tx Buffer 11 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE10_M	0x00000400U		/* Tx Buffer 10 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE9_M	0x00000200U		/* Tx Buffer 9 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE8_M	0x00000100U		/* Tx Buffer 8 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE7_M	0x00000080U		/* Tx Buffer 7 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE6_M	0x00000040U		/* Tx Buffer 6 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE5_M	0x00000020U		/* Tx Buffer 5 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE4_M	0x00000010U		/* Tx Buffer 4 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE3_M	0x00000008U		/* Tx Buffer 3 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE2_M	0x00000004U		/* Tx Buffer 2 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE1_M	0x00000002U		/* Tx Buffer 1 Cancellation Finished
												Interrupt Enable. */
#define M_CAN_TXBCIE_CFIE0_M	0x00000001U		/* Tx Buffer 0 Cancellation Finished
												Interrupt Enable. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXEFC register.
 *
 */
#define M_CAN_TXEFC_EFWM_S		24U
#define M_CAN_TXEFC_EFWM_M		0x3f000000U		/* Event FIFO Watermark. */
#define M_CAN_TXEFC_EFS_S		16U
#define M_CAN_TXEFC_EFS_M		0x003f0000U		/* Event FIFO Size. */
#define M_CAN_TXEFC_EFSA_S		2U
#define M_CAN_TXEFC_EFSA_M		0x0000fffcU		/* Event FIFO Start Address. */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXEFS register.
 *
 */
#define M_CAN_TXEFS_TEFL_M		0x02000000U		/* Tx Event FIFO Element Lost. */
#define M_CAN_TXEFS_EFF_M		0x01000000U		/* Tx Event FIFO Full. */
#define M_CAN_TXEFS_EFPI_S		16U
#define M_CAN_TXEFS_EFPI_M		0x001f0000U		/* Tx Event FIFO Put Index. */
#define M_CAN_TXEFS_EFGI_S		8U
#define M_CAN_TXEFS_EFGI_M		0x00001f00U		/* Tx Event FIFO Get Index. */
#define M_CAN_TXEFS_EFFL_M		0x0000003fU		/* Tx Event FIFO Fill Level */

/**
 * @brief The following are defines for the bit fields in the M_CAN_TXEFA register.
 *
 */
#define M_CAN_TXEFA_EFAI_M		0x0000001fU		/* Tx Event FIFO Acknowledge. */

/**
 * @brief Words size of a standard ID filter.
 *
 */
#define M_CAN_WORD_SIZE_OF_STD_FILTER	1U

/**
 * @brief Words size of a extended ID filter.
 *
 */
#define M_CAN_WORD_SIZE_OF_EXT_FILTER	2U

/**
 * @brief Words size of a Tx event fifo.
 *
 */
#define M_CAN_WORD_SIZE_OF_TXEVENT_FIFO	2U

/**
 * @brief Maximum of Rx buffer.
 *
 */
#define MCAN_RX_BUFFER_MAX				64U

/**
 * @brief Maximum of Tx buffer.
 *
 */
#define MCAN_TX_BUFFER_MAX				32U

/**
 * @brief Maximum of Tx event buffer.
 *
 */
#define MCAN_TX_EVENT_BUFFER_MAX		32U

/**
 * @brief Is use TSU as timestamp clock source.
 *
 * MCAN_IS_USE_TSU = 0 Unrealized
 * MCAN_IS_USE_TSU = 1 Realized
 */
#define MCAN_IS_USE_TSU					0U

/**
 * @brief Standard Message ID Filter Element.
 *
 */
#define MCAN_STD_SFT_S			30U
#define MCAN_STD_SFT_M			0xc0000000U		/* Standard Filter Type. */
#define MCAN_STD_SFEC_S			27U
#define MCAN_STD_SFEC_M			0x38000000U		/* Standard Filter Element
												Configuration. */
#define MCAN_STD_SFID1_S		16U
#define MCAN_STD_SFID1_M		0x07ff0000U		/* Standard Filter ID 1. */
#define MCAN_STD_SSYNC_S		15U
#define MCAN_STD_SSYNC_M		0x00008000U		/* Standard Sync Message. */
#define MCAN_STD_SFID2_M		0x000007ffU		/* Standard Filter ID 2. */

/**
 * @brief  Extended Message ID Filter Element.
 *
 */
#define MCAN_EXT_EFEC_S			29U
#define MCAN_EXT_EFEC_M			0xe0000000U		/* Extended Filter Element
												Configuration. */
#define MCAN_EXT_EFID1_S		0U
#define MCAN_EXT_EFID1_M		0x1fffffffU		/* Extended Filter ID 1. */
#define MCAN_EXT_EFT_S			30U
#define MCAN_EXT_EFT_M			0xc0000000U		/* Extended Filter Type. */
#define MCAN_EXT_ESYNC_S		29U
#define MCAN_EXT_ESYNC_M		0x20000000U		/* Extended Sync Message. */
#define MCAN_EXT_EFID2_S		0U
#define MCAN_EXT_EFID2_M		0x1fffffffU		/* Extended Filter ID 2. */

/**
 * @brief The following are defines for the bit fields in the MCANSS_REGS register.
 *
 */
#define MCANSS_PID							0x00U	/* MCAN Subsystem Revision Register
													Go. */
#define MCANSS_CTRL							0x04U	/* MCAN Subsystem Control Register. */
#define MCANSS_STAT							0x08U	/* MCAN Subsystem Status Register */
#define MCANSS_ICS							0x0CU	/* MCAN Subsystem Interrupt
													Clear Shadow Register. */
#define MCANSS_IRS							0x10U	/* MCAN Subsystem Interrupt
													Raw Satus Register */
#define MCANSS_IECS							0x14U	/* MCAN Subsystem Interrupt Enable
													Clear Shadow Register */
#define MCANSS_IE							0x18U	/* MCAN Subsystem Interrupt Enable
													Register. */
#define MCANSS_IES							0x1CU	/* MCAN Subsystem Interrupt Enable
													Status. */
#define MCANSS_EOI							0x20U	/* MCAN Subsystem End of Interrupt. */
#define MCANSS_EXT_TS_PRESCALER				0x24U	/* MCAN Subsystem External Timestamp
													Prescaler 0 */
#define MCANSS_EXT_TS_UNSERVIED_INTR_CNTR	0x28U	/* MCAN Subsystem External Timestamp
													Unserviced Interrupts Counter */

/**
 * @brief The following are defines for the bit fields in the MCANSS_PID register.
 *
 */
#define MCANSS_PID_SCHEME_S					30U
#define MCANSS_PID_SCHEME_M					0xc0000000U
#define MCANSS_PID_MODULE_ID_S				16U
#define MCANSS_PID_MODULE_ID_M				0x0fff0000U
#define MCANSS_PID_MAJOR_S					8U
#define MCANSS_PID_MAJOR_M					0x00000700U
#define MCANSS_PID_MINOR_S					0U
#define MCANSS_PID_MINOR_M					0x0000003fU

/**
 * @brief The following are defines for the bit fields in the MCANSS_CTRL register.
 *
 */
#define MCANSS_CTRL_EXT_TS_CNTR_EN_S		6U
#define MCANSS_CTRL_EXT_TS_CNTR_EN_M		0x00000040U
#define MCANSS_CTRL_AUTOWAKEUP_S			5U
#define MCANSS_CTRL_AUTOWAKEUP_M			0x00000020U
#define MCANSS_CTRL_WAKEUPREQEN_S			4U
#define MCANSS_CTRL_WAKEUPREQEN_M			0x00000010U
#define MCANSS_CTRL_DBGSUSP_FREE_S			3U
#define MCANSS_CTRL_DBGSUSP_FREE_M			0x00000008U

/**
 * @brief The following are defines for the bit fields in the MCANSS_STAT register.
 *
 */
#define MCANSS_STAT_ENABLE_FDOE_S			2U
#define MCANSS_STAT_ENABLE_FDOE_M			0x00000004U
#define MCANSS_STAT_MEM_INIT_DONE_S			1U
#define MCANSS_STAT_MEM_INIT_DONE_M			0x00000002U
#define MCANSS_STAT_RESET_S					0U
#define MCANSS_STAT_RESET_M					0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_ICS register.
 *
 */
#define MCANSS_ICS_EXT_TS_CNTR_OVFL_S		0U
#define MCANSS_ICS_EXT_TS_CNTR_OVFL_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_IRS register.
 *
 */
#define MCANSS_IRS_EXT_TS_CNTR_OVFL_S		0U
#define MCANSS_IRS_EXT_TS_CNTR_OVFL_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_IECS register.
 *
 */
#define MCANSS_IECS_EXT_TS_CNTR_OVFL_S		0U
#define MCANSS_IECS_EXT_TS_CNTR_OVFL_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_IE register.
 *
 */
#define MCANSS_IE_EXT_TS_CNTR_OVFL_S		0U
#define MCANSS_IE_EXT_TS_CNTR_OVFL_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_IES register.
 *
 */
#define MCANSS_IES_EXT_TS_CNTR_OVFL_S		0U
#define MCANSS_IES_EXT_TS_CNTR_OVFL_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANSS_EOI register.
 *
 */
#define MCANSS_EOI_EOI_S					0U
#define MCANSS_EOI_EOI_M					0x000000ffU

/**
 * @brief The following are defines for the bit fields
 * in the MCANSS_EXT_TS_UNSERVIED_INTR_CNTR register.
 *
 */
#define MCANSS_EXT_TS_UNSERVIED_INTR_CNTR_EXT_TS_INTR_CNTR_S			0U
#define MCANSS_EXT_TS_UNSERVIED_INTR_CNTR_EXT_TS_INTR_CNTR_M			0x0000001fU

/* MCANERR_REGS register define. */
#define MCANERR_REV				0x00U	/* MCAN Error Aggregator Revision Register. */
#define MCANERR_VECTOR			0x08U	/* MCAN ECC Vector Register. */
#define MCANERR_STAT			0x0CU	/* MCAN Error Misc Status */
#define MCANERR_WRAP_REV		0x10U	/* MCAN ECC Wrapper Revision Register. */
#define MCANERR_CTRL			0x14U	/* MCAN ECC Control. */
#define MCANERR_ERR_CTRL1		0x18U	/* MCAN ECC Error Control 1 Register. */
#define MCANERR_ERR_CTRL2		0x1CU	/* MCAN ECC Error Control 2 Register. */
#define MCANERR_ERR_STAT1		0x20U	/* MCAN ECC Error Status 1 Register. */
#define MCANERR_ERR_STAT2		0x24U	/* MCAN ECC Error Status 2 Register. */
#define MCANERR_ERR_STAT3		0x28U	/* MCAN ECC Error Status 3 Register. */
#define MCANERR_SEC_EOI			0x3CU	/* MCAN Single Error Corrected End of
										Interrupt Register. */
#define MCANERR_SEC_STATUS		0x40U	/* MCAN Single Error Corrected
										Interrupt Status Register. */
#define MCANERR_SEC_ENABLE_SET	0x80U	/* MCAN Single Error Corrected
										Interrupt Enable Set Register. */
#define MCANERR_SEC_ENABLE_CLR	0xC0U	/* MCAN Single Error Corrected Interrupt
										Enable Clear Register. */
#define MCANERR_DED_EOI			0x13CU	/* MCAN Double Error Detected
										End of Interrupt Register. */
#define MCANERR_DED_STATUS		0x140U	/* MCAN Double Error Detected
										Interrupt Status Register. */
#define MCANERR_DED_ENABLE_SET	0x180U	/* MCAN Double Error Detected
										Interrupt Enable Set Register. */
#define MCANERR_DED_ENABLE_CLR	0x1C0U	/* MCAN Double Error Detected
										Interrupt Enable Clear Register. */
#define MCANERR_AGGR_ENABLE_SET	0x200U	/* MCAN Error Aggregator Enable Set Register. */
#define MCANERR_AGGR_ENABLE_CLR	0x204U	/* MCAN Error Aggregator Enable Clear Register. */
#define MCANERR_AGGR_STATUS_SET	0x208U	/* MCAN Error Aggregator Status Set Register. */
#define MCANERR_AGGR_STATUS_CLR	0x20CU	/* MCAN Error Aggregator Status Clear Register. */

/**
 * @brief The following are defines for the bit fields in the MCANERR_REV register.
 *
 */
#define MCANERR_REV_SCHENE_S				30U
#define MCANERR_REV_SCHENE_M				0xC0000000U
#define MCANERR_REV_MODULE_ID_S				16U
#define MCANERR_REV_MODULE_ID_M				0x0FFF0000U
#define MCANERR_REV_REVMAJ_S				8U
#define MCANERR_REV_REVMAJ_M				0x00000700U
#define MCANERR_REV_REVMIN_S				0U
#define MCANERR_REV_REVMIN_M				0x0000001fU

/**
 * @brief The following are defines for the bit fields in the MCANERR_VECTOR register.
 *
 */
#define MCANERR_VECTOR_RD_SVBUS_DONE_S		24U
#define MCANERR_VECTOR_RD_SVBUS_DONE_M		0x01000000U
#define MCANERR_VECTOR_SVBUS_ADDRESS_S		16U
#define MCANERR_VECTOR_RD_SVBUS_ADDRESS_M	0x00ff0000U
#define MCANERR_VECTOR_RD_SVBUS_S			15U
#define MCANERR_VECTOR_RD_SVBUS_M			0x00008000U
#define MCANERR_VECTOR_ECC_VECTOR_S			0U
#define MCANERR_VECTOR_ECC_VECTOR_M			0x000007ffU

/**
 * @brief The following are defines for the bit fields in the MCANERR_STAT register.
 *
 */
#define MCANERR_STAT_NUM_RAMS_S		0U
#define MCANERR_STAT_NUM_RAMS_M		0x000007ffU

/**
 * @brief The following are defines for the bit fields in the MCANERR_WRAP_REV register.
 *
 */
#define MCANERR_WRAP_REV_SCHENE_S			30U
#define MCANERR_WRAP_REV_SCHENE_M			0xC0000000U
#define MCANERR_WRAP_REV_MODULE_ID_S		16U
#define MCANERR_REV_MODULE_ID_M				0x0FFF0000U
#define MCANERR_WRAP_REV_REVMAJ_S			8U
#define MCANERR_WRAP_REV_REVMAJ_M			0x00000700U
#define MCANERR_WRAP_REV_REVMIN_S			0U
#define MCANERR_WRAP_REV_REVMIN_M			0x0000001fU

/**
 * @brief The following are defines for the bit fields in the MCANERR_CTRL register.
 *
 */
#define MCANERR_CTRL_CHECK_SVBUS_TIMEOUT_S	8U
#define MCANERR_CTRL_CHECK_SVBUS_TIMEOUT_M	0x00000100U
#define MCANERR_CTRL_ERROR_ONCE_S			6U
#define MCANERR_CTRL_ERROR_ONCE_M			0x00000040U
#define MCANERR_CTRL_FORCE_N_ROW_S			5U
#define MCANERR_CTRL_FORCE_N_ROW_M			0x00000020U
#define MCANERR_CTRL_FORCE_DED_S			4U
#define MCANERR_CTRL_FORCE_DED_M			0x00000010U
#define MCANERR_CTRL_FORCE_SEC_S			3U
#define MCANERR_CTRL_FORCE_SEC_M			0x00000008U
#define MCANERR_CTRL_ENABLE_RMW_S			2U
#define MCANERR_CTRL_ENABLE_RMW_M			0x00000004U
#define MCANERR_CTRL_ECC_CHECK_S			1U
#define MCANERR_CTRL_ECC_CHECK_M			0x00000002U
#define MCANERR_CTRL_ECC_ENABLE_S			0U
#define MCANERR_CTRL_ECC_ENABLE_M			0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_ERR_CTRL1 register.
 *
 */
#define MCANERR_ERR_CTRL1_ECC_ROW_S			0U
#define MCANERR_ERR_CTRL1_ECC_ROW_M			0xffffffffU

/**
 * @brief The following are defines for the bit fields in the MCANERR_ERR_CTRL2 register.
 *
 */
#define MCANERR_ERR_CTRL2_ECC_BIT2_S		16U
#define MCANERR_ERR_CTRL2_ECC_BIT2_M		0xffff0000U
#define MCANERR_ERR_CTRL2_ECC_BIT1_S		0U
#define MCANERR_ERR_CTRL2_ECC_BIT1_M		0x0000ffffU

/**
 * @brief The following are defines for the bit fields in the MCANERR_ERR_STAT1 register.
 *
 */
#define MCANERR_ERR_STAT1_ECC_BIT1_S			16U
#define MCANERR_ERR_STAT1_ECC_BIT1_M			0xffff0000U
#define MCANERR_ERR_STAT1_CLR_CTRL_REG_ERROR_S	15U
#define MCANERR_ERR_STAT1_CLR_CTRL_REG_ERROR_M	0x00008000U
#define MCANERR_ERR_STAT1_CLR_ECC_OTHER_S		12U
#define MCANERR_ERR_STAT1_CLR_ECC_OTHER_M		0x00001000U
#define MCANERR_ERR_STAT1_CLR_ECC_DED_S			10U
#define MCANERR_ERR_STAT1_CLR_ECC_DED_M			0x00000c00U
#define MCANERR_ERR_STAT1_CLR_ECC_SEC_S			8U
#define MCANERR_ERR_STAT1_CLR_ECC_SEC_M			0x00000300U
#define MCANERR_ERR_STAT1_CTRL_REG_ERROR_S		7U
#define MCANERR_ERR_STAT1_CTRL_REG_ERROR_M		0x00000080U
#define MCANERR_ERR_STAT1_ECC_OTHER_S			4U
#define MCANERR_ERR_STAT1_ECC_OTHER_M			0x00000010U
#define MCANERR_ERR_STAT1_ECC_DED_S				2U
#define MCANERR_ERR_STAT1_ECC_DED_M				0x0000000cU
#define MCANERR_ERR_STAT1_ECC_SEC_S				0U
#define MCANERR_ERR_STAT1_ECC_SEC_M				0x00000003U

/**
 * @brief The following are defines for the bit fields in the MCANERR_ERR_STAT2 register.
 *
 */
#define MCANERR_ERR_STAT2_ECC_ROW_S			0U
#define MCANERR_ERR_STAT2_ECC_ROW_M			0xffffffffU

/**
 * @brief The following are defines for the bit fields in the MCANERR_ERR_STAT3 register.
 *
 */
#define MCANERR_ERR_STAT3_CLR_SVBUS_TIMEOUT_S	9U
#define MCANERR_ERR_STAT3_CLR_SVBUS_TIMEOUT_M	0x00000200U
#define MCANERR_ERR_STAT3_SVBUS_TIMEOUT_S		1U
#define MCANERR_ERR_STAT3_SVBUS_TIMEOUT_M		0x00000002U
#define MCANERR_ERR_STAT3_WB_PEND_S				0U
#define MCANERR_ERR_STAT3_WB_PEND_M				0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_SEC_EOI register.
 *
 */
#define MCANERR_SEC_EOI_EOI_WR_S			0U
#define MCANERR_SEC_EOI_EOI_WR_M			0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_SEC_STATUS register.
 *
 */
#define MCANERR_SEC_STATUS_MSGMEM_PEND_S	0U
#define MCANERR_SEC_STATUS_MSGMEM_PEND_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_SEC_ENABLE_SET
 * register.
 *
 */
#define MCANERR_SEC_ENABLE_SET_MSGMEM_ENABLE_SET_S	0U
#define MCANERR_SEC_ENABLE_SET_MSGMEM_ENABLE_SET_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_SEC_ENABLE_CLR
 * register.
 *
 */
#define MCANERR_SEC_ENABLE_CLR_MSGMEM_ENABLE_CLR_S	0U
#define MCANERR_SEC_ENABLE_CLR_MSGMEM_ENABLE_CLR_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_DED_EOI register.
 *
 */
#define MCANERR_DED_EOI_EOI_WR_S		0U
#define MCANERR_DED_EOI_EOI_WR_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_DED_STATUS register.
 *
 */
#define MCANERR_DED_STATUS_MSGMEM_PEND_S	0U
#define MCANERR_DED_STATUS_MSGMEM_PEND_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_DED_ENABLE_SET
 * register.
 *
 */
#define MCANERR_DED_ENABLE_SET_MSGMEM_ENABLE_SET_S	0U
#define MCANERR_DED_ENABLE_SET_MSGMEM_ENABLE_SET_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_DED_ENABLE_CLR
 * register.
 *
 */
#define MCANERR_DED_ENABLE_CLR_MSGMEM_ENABLE_CLR_S	0U
#define MCANERR_DED_ENABLE_CLR_MSGMEM_ENABLE_CLR_M	0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_AGGR_ENABLE_SET
 * register.
 *
 */
#define MCANERR_AGGR_ENABLE_SET_ENABLE_TIMEOUT_SET_S	1U
#define MCANERR_AGGR_ENABLE_SET_ENABLE_TIMEOUT_SET_M	0x00000002U
#define MCANERR_AGGR_ENABLE_SET_ENABLE_PARITY_SET_S		0U
#define MCANERR_AGGR_ENABLE_SET_ENABLE_PARITY_SET_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_AGGR_ENABLE_CLR
 * register.
 *
 */
#define MCANERR_AGGR_ENABLE_CLR_ENABLE_TIMEOUT_CLR_S	1U
#define MCANERR_AGGR_ENABLE_CLR_ENABLE_TIMEOUT_CLR_M	0x00000002U
#define MCANERR_AGGR_ENABLE_CLR_ENABLE_PARITY_CLR_S		0U
#define MCANERR_AGGR_ENABLE_CLR_ENABLE_PARITY_CLR_M		0x00000001U

/**
 * @brief The following are defines for the bit fields in the MCANERR_AGGR_STATUS_SET
 * register.
 *
 */
#define MCANERR_AGGR_STATUS_SET_SVBUS_TIMEOUT_S			2U
#define MCANERR_AGGR_STATUS_SET_SVBUS_TIMEOUT_M			0x0000000cU
#define MCANERR_AGGR_STATUS_SET_AGGR_PARITY_ERR_S		0U
#define MCANERR_AGGR_STATUS_SET_AGGR_PARITY_ERR_M		0x00000003U

/**
 * @brief The following are defines for the bit fields in the MCANERR_AGGR_STATUS_CLR
 * register.
 *
 */
#define MCANERR_AGGR_STATUS_CLR_SVBUS_TIMEOUT_S			2U
#define MCANERR_AGGR_STATUS_CLR_SVBUS_TIMEOUT_M			0x0000000cU
#define MCANERR_AGGR_STATUS_CLR_AGGR_PARITY_ERR_S		0U
#define MCANERR_AGGR_STATUS_CLR_AGGR_PARITY_ERR_M		0x00000003U

#ifdef __cplusplus
}
#endif

#endif
