/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_plu.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_PLU_H_
#define DEVICE_DRIVERLIB_HW_PLU_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the plu register offsets
#if IS_GS32F00xx(0x12, 0x30) || IS_GS32F3xx(0x22)
#define EPLU_LC0_LUTCTRL0   0x00
#define EPLU_LC0_LUTCTRL1   0x04
#define EPLU_LC0_LUTCTRL2   0x08
#define EPLU_LC0_LUTCTRL3   0x0C
#define EPLU_LC0_FILT0      0x10
#define EPLU_LC0_FILT1      0x14
#define EPLU_LC0_FILT2      0x18
#define EPLU_LC0_FILT3      0x1C
#define EPLU_LC0_INTDMAEN   0x20
#define EPLU_LC0_STS        0x24
#define EPLU_LC0_OUTPOL     0x28
#define EPLU_LC0_FFILT      0x2C
#define EPLU_LC0_FCTRL      0x30
#define EPLU_LC0_SCTRL      0x34
#define EPLU_LC1_LUTCTRL0   0x40
#define EPLU_LC1_LUTCTRL1   0x44
#define EPLU_LC1_LUTCTRL2   0x48
#define EPLU_LC1_LUTCTRL3   0x4C
#define EPLU_LC1_FILT0      0x50
#define EPLU_LC1_FILT1      0x54
#define EPLU_LC1_FILT2      0x58
#define EPLU_LC1_FILT3      0x5C
#define EPLU_LC1_INTDMAEN   0x60
#define EPLU_LC1_STS        0x64
#define EPLU_LC1_OUTPOL     0x68
#define EPLU_LC1_FFILT      0x6C
#define EPLU_LC1_FCTRL      0x70
#define EPLU_LC1_SCTRL      0x74
#define EPLU_LC2_LUTCTRL0   0x80
#define EPLU_LC2_LUTCTRL1   0x84
#define EPLU_LC2_LUTCTRL2   0x88
#define EPLU_LC2_LUTCTRL3   0x8C
#define EPLU_LC2_FILT0      0x90
#define EPLU_LC2_FILT1      0x94
#define EPLU_LC2_FILT2      0x98
#define EPLU_LC2_FILT3      0x9C
#define EPLU_LC2_INTDMAEN   0xA0
#define EPLU_LC2_STS        0xA4
#define EPLU_LC2_OUTPOL     0xA8
#define EPLU_LC2_FFILT      0xAC
#define EPLU_LC2_FCTRL      0xB0
#define EPLU_LC2_SCTRL      0xB4
#define EPLU_MUXSEL0        0x100
#define EPLU_MUXSEL1        0x104
#define EPLU_MUXSEL2        0x108
#define EPLU_MUXSEL3        0x10C
#define EPLU_MUXSEL4        0x110
#define EPLU_MUXSEL5        0x114
#define EPLU_MUXSEL6        0x118
#define EPLU_MUXSEL7        0x11C
#define EPLU_MUXSEL8        0x120
#define EPLU_MUXSEL9        0x124
#define EPLU_MUXSEL10       0x128
#define EPLU_MUXSEL11       0x12C
#define EPLU_SWEN           0x184
#define EPLU_SWVALUE        0x188
#define EPLU_OUTEN          0x18C
#define EPLU_LCIN           0x190
#define EPLU_SWOUT          0x194
#define EPLU_LCOUT          0x198
#define EPLU_FORCEOUT       0x19C
#define EPLU_FORCESTS       0x1A0
//add base 0x0012
#define EPLU_LC0_SWOUT_0DLY  0xC0
#define EPLU_LC0_SWOUT_1DLY  0xC4
#define EPLU_LC0_SWOUT_2DLY  0xC8
#define EPLU_LC0_SWOUT_3DLY  0xCC
#define EPLU_LC0_FORCE_0DLY  0xD0
#define EPLU_LC0_FORCE_1DLY  0xD4
#define EPLU_LC0_FORCE_2DLY  0xD8
#define EPLU_LC0_FORCE_3DLY  0xDC
#define EPLU_LC1_SWOUT_0DLY  0xE0
#define EPLU_LC1_SWOUT_1DLY  0xE4
#define EPLU_LC1_SWOUT_2DLY  0xE8
#define EPLU_LC1_SWOUT_3DLY  0xEC
#define EPLU_LC1_FORCE_0DLY  0xF0
#define EPLU_LC1_FORCE_1DLY  0xF4
#define EPLU_LC1_FORCE_2DLY  0xF8
#define EPLU_LC1_FORCE_3DLY  0xFC
#define EPLU_LC2_SWOUT_0DLY  0x130
#define EPLU_LC2_SWOUT_1DLY  0x134
#define EPLU_LC2_SWOUT_2DLY  0x138
#define EPLU_LC2_SWOUT_3DLY  0x13C
#define EPLU_LC2_FORCE_0DLY  0x140
#define EPLU_LC2_FORCE_1DLY  0x144
#define EPLU_LC2_FORCE_2DLY  0x148
#define EPLU_LC2_FORCE_3DLY  0x14C
#define EPLU_LC0_FORCE_CFG   0x150
#define EPLU_LC0_STS_DSP     0x154
#define EPLU_LC1_FORCE_CFG   0x160
#define EPLU_LC1_STS_DSP     0x164
#define EPLU_LC2_FORCE_CFG  0x170
#define LC2_STS_DSP          0x174
#define FORCESTS_DSP         0x1B0


#define EPLU_INT_FLAG        0x1B8
#define EPLU_IN_0SEL         0x1C0
#define EPLU_IN_1SEL         0x1C4
#define EPLU_IN_2SEL         0x1C8
#define EPLU_IN_3SEL         0x1CC
#define EPLU_FORCE_0SEL      0x1D0
#define EPLU_FORCE_1SEL      0x1D4
#define EPLU_SYN_0SEL        0x1D8
#define EPLU_SYN_1SEL        0x1DC
#define EPLU_HALT_EN         0x1E0
#define EPLU_INT_REQ_EN		 0X1E4
#endif


// The following are defines for the bit fields in the LC0_LUTCTRL0 register by plu

#define PLU_LC0_LUTCTRL0_LUTCTRL_M		0XFFFFU
#define PLU_LC0_LUTCTRL0_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC0_LUTCTRL1 register by plu

#define PLU_LC0_LUTCTRL1_LUTCTRL_M		0XFFFFU
#define PLU_LC0_LUTCTRL1_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC0_LUTCTRL2 register by plu

#define PLU_LC0_LUTCTRL2_LUTCTRL_M		0XFFFFU
#define PLU_LC0_LUTCTRL2_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC0_LUTCTRL3 register by plu

#define PLU_LC0_LUTCTRL3_LUTCTRL_M		0XFFFFU
#define PLU_LC0_LUTCTRL3_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC0_FILT0 register by plu

#define PLU_LC0_FILT0_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC0_FILT0_LUT_RISE_FILT_S		16U
#define PLU_LC0_FILT0_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC0_FILT0_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC0_FILT1 register by plu

#define PLU_LC0_FILT1_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC0_FILT1_LUT_RISE_FILT_S		16U
#define PLU_LC0_FILT1_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC0_FILT1_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC0_FILT2 register by plu

#define PLU_LC0_FILT2_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC0_FILT2_LUT_RISE_FILT_S		16U
#define PLU_LC0_FILT2_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC0_FILT2_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC0_FILT3 register by plu

#define PLU_LC0_FILT3_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC0_FILT3_LUT_RISE_FILT_S		16U
#define PLU_LC0_FILT3_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC0_FILT3_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC0_INTDMAEN register by plu

#define PLU_LC0_INTDMAEN_FORCE_DMA_EN_M		0XF000000U
#define PLU_LC0_INTDMAEN_FORCE_DMA_EN_S		24U
#define PLU_LC0_INTDMAEN_FORCE_INT_EN_M		0XF0000U
#define PLU_LC0_INTDMAEN_FORCE_INT_EN_S		16U
#define PLU_LC0_INTDMAEN_LUT_DMA_EN_M		0XF00U
#define PLU_LC0_INTDMAEN_LUT_DMA_EN_S		8U
#define PLU_LC0_INTDMAEN_LUT_INT_EN_M		0XFU
#define PLU_LC0_INTDMAEN_LUT_INT_EN_S		0U

// The following are defines for the bit fields in the LC0_STS register by plu

#define PLU_LC0_STS_FORCESTS_M		0XF00U
#define PLU_LC0_STS_FORCESTS_S		8U
#define PLU_LC0_STS_LUT_STS_M		0XFU
#define PLU_LC0_STS_LUT_STS_S		0U

// The following are defines for the bit fields in the LC0_OUTPOL register by plu

#define PLU_LC0_OUTPOL_OUTPOL_M		0XFU
#define PLU_LC0_OUTPOL_OUTPOL_S		0U

// The following are defines for the bit fields in the LC0_FFILT register by plu

#define PLU_LC0_FFILT_COMB_FORCE_M		0XF0000000U
#define PLU_LC0_FFILT_COMB_FORCE_S		28U
#define PLU_LC0_FFILT_COMB_EN_M		0XF000000U
#define PLU_LC0_FFILT_COMB_EN_S		24U
#define PLU_LC0_FFILT_FORCE_POL_M		0XF0000U
#define PLU_LC0_FFILT_FORCE_POL_S		16U
#define PLU_LC0_FFILT_FORCE_FILT_M		0XFFU
#define PLU_LC0_FFILT_FORCE_FILT_S		0U

// The following are defines for the bit fields in the LC0_FCTRL register by plu

#define PLU_LC0_FCTRL_SYNC_SEL3_M		0XC0000000U
#define PLU_LC0_FCTRL_SYNC_SEL3_S		30U
#define PLU_LC0_FCTRL_FORCE_MODE3_M		0X30000000U
#define PLU_LC0_FCTRL_FORCE_MODE3_S		28U
#define PLU_LC0_FCTRL_FORCE_SENSE3_M		0XF000000U
#define PLU_LC0_FCTRL_FORCE_SENSE3_S		24U
#define PLU_LC0_FCTRL_SYNC_SEL2_M		0XC00000U
#define PLU_LC0_FCTRL_SYNC_SEL2_S		22U
#define PLU_LC0_FCTRL_FORCE_MODE2_M		0X300000U
#define PLU_LC0_FCTRL_FORCE_MODE2_S		20U
#define PLU_LC0_FCTRL_FORCE_SENSE2_M		0XF0000U
#define PLU_LC0_FCTRL_FORCE_SENSE2_S		16U
#define PLU_LC0_FCTRL_SYNC_SEL1_M		0XC000U
#define PLU_LC0_FCTRL_SYNC_SEL1_S		14U
#define PLU_LC0_FCTRL_FORCE_MODE1_M		0X3000U
#define PLU_LC0_FCTRL_FORCE_MODE1_S		12U
#define PLU_LC0_FCTRL_FORCE_SENSE1_M		0XF00U
#define PLU_LC0_FCTRL_FORCE_SENSE1_S		8U
#define PLU_LC0_FCTRL_SYNC_SEL0_M		0XC0U
#define PLU_LC0_FCTRL_SYNC_SEL0_S		6U
#define PLU_LC0_FCTRL_FORCE_MODE0_M		0X30U
#define PLU_LC0_FCTRL_FORCE_MODE0_S		4U
#define PLU_LC0_FCTRL_FORCE_SENSE0_M		0XFU
#define PLU_LC0_FCTRL_FORCE_SENSE0_S		0U

// The following are defines for the bit fields in the LC0_SCTRL register by plu

#define PLU_LC0_SCTRL_SW_SYNC_SEL_M		0X300U
#define PLU_LC0_SCTRL_SW_SYNC_SEL_S		8U
#define PLU_LC0_SCTRL_SW_MODE_M		0XFU
#define PLU_LC0_SCTRL_SW_MODE_S		0U

// The following are defines for the bit fields in the LC1_LUTCTRL0 register by plu

#define PLU_LC1_LUTCTRL0_LUTCTRL_M		0XFFFFU
#define PLU_LC1_LUTCTRL0_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC1_LUTCTRL1 register by plu

#define PLU_LC1_LUTCTRL1_LUTCTRL_M		0XFFFFU
#define PLU_LC1_LUTCTRL1_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC1_LUTCTRL2 register by plu

#define PLU_LC1_LUTCTRL2_LUTCTRL_M		0XFFFFU
#define PLU_LC1_LUTCTRL2_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC1_LUTCTRL3 register by plu

#define PLU_LC1_LUTCTRL3_LUTCTRL_M		0XFFFFU
#define PLU_LC1_LUTCTRL3_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC1_FILT0 register by plu

#define PLU_LC1_FILT0_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC1_FILT0_LUT_RISE_FILT_S		16U
#define PLU_LC1_FILT0_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC1_FILT0_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC1_FILT1 register by plu

#define PLU_LC1_FILT1_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC1_FILT1_LUT_RISE_FILT_S		16U
#define PLU_LC1_FILT1_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC1_FILT1_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC1_FILT2 register by plu

#define PLU_LC1_FILT2_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC1_FILT2_LUT_RISE_FILT_S		16U
#define PLU_LC1_FILT2_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC1_FILT2_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC1_FILT3 register by plu

#define PLU_LC1_FILT3_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC1_FILT3_LUT_RISE_FILT_S		16U
#define PLU_LC1_FILT3_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC1_FILT3_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC1_INTDMAEN register by plu

#define PLU_LC1_INTDMAEN_FORCE_DMA_EN_M		0XF000000U
#define PLU_LC1_INTDMAEN_FORCE_DMA_EN_S		24U
#define PLU_LC1_INTDMAEN_FORCE_INT_EN_M		0XF0000U
#define PLU_LC1_INTDMAEN_FORCE_INT_EN_S		16U
#define PLU_LC1_INTDMAEN_LUT_DMA_EN_M		0XF00U
#define PLU_LC1_INTDMAEN_LUT_DMA_EN_S		8U
#define PLU_LC1_INTDMAEN_LUT_INT_EN_M		0XFU
#define PLU_LC1_INTDMAEN_LUT_INT_EN_S		0U

// The following are defines for the bit fields in the LC1_STS register by plu

#define PLU_LC1_STS_FORCESTS_M		0XF00U
#define PLU_LC1_STS_FORCESTS_S		8U
#define PLU_LC1_STS_LUT_STS_M		0XFU
#define PLU_LC1_STS_LUT_STS_S		0U

// The following are defines for the bit fields in the LC1_OUTPOL register by plu

#define PLU_LC1_OUTPOL_OUTPOL_M		0XFU
#define PLU_LC1_OUTPOL_OUTPOL_S		0U

// The following are defines for the bit fields in the LC1_FFILT register by plu

#define PLU_LC1_FFILT_COMB_FORCE_M		0XF0000000U
#define PLU_LC1_FFILT_COMB_FORCE_S		28U
#define PLU_LC1_FFILT_COMB_EN_M		0XF000000U
#define PLU_LC1_FFILT_COMB_EN_S		24U
#define PLU_LC1_FFILT_FORCE_POL_M		0XF0000U
#define PLU_LC1_FFILT_FORCE_POL_S		16U
#define PLU_LC1_FFILT_FORCE_FILT_M		0XFFU
#define PLU_LC1_FFILT_FORCE_FILT_S		0U

// The following are defines for the bit fields in the LC1_FCTRL register by plu

#define PLU_LC1_FCTRL_SYNC_SEL3_M		0XC0000000U
#define PLU_LC1_FCTRL_SYNC_SEL3_S		30U
#define PLU_LC1_FCTRL_FORCE_MODE3_M		0X30000000U
#define PLU_LC1_FCTRL_FORCE_MODE3_S		28U
#define PLU_LC1_FCTRL_FORCE_SENSE3_M		0XF000000U
#define PLU_LC1_FCTRL_FORCE_SENSE3_S		24U
#define PLU_LC1_FCTRL_SYNC_SEL2_M		0XC00000U
#define PLU_LC1_FCTRL_SYNC_SEL2_S		22U
#define PLU_LC1_FCTRL_FORCE_MODE2_M		0X300000U
#define PLU_LC1_FCTRL_FORCE_MODE2_S		20U
#define PLU_LC1_FCTRL_FORCE_SENSE2_M		0XF0000U
#define PLU_LC1_FCTRL_FORCE_SENSE2_S		16U
#define PLU_LC1_FCTRL_SYNC_SEL1_M		0XC000U
#define PLU_LC1_FCTRL_SYNC_SEL1_S		14U
#define PLU_LC1_FCTRL_FORCE_MODE1_M		0X3000U
#define PLU_LC1_FCTRL_FORCE_MODE1_S		12U
#define PLU_LC1_FCTRL_FORCE_SENSE1_M		0XF00U
#define PLU_LC1_FCTRL_FORCE_SENSE1_S		8U
#define PLU_LC1_FCTRL_SYNC_SEL0_M		0XC0U
#define PLU_LC1_FCTRL_SYNC_SEL0_S		6U
#define PLU_LC1_FCTRL_FORCE_MODE0_M		0X30U
#define PLU_LC1_FCTRL_FORCE_MODE0_S		4U
#define PLU_LC1_FCTRL_FORCE_SENSE0_M		0XFU
#define PLU_LC1_FCTRL_FORCE_SENSE0_S		0U

// The following are defines for the bit fields in the LC1_SCTRL register by plu

#define PLU_LC1_SCTRL_SW_SYNC_SEL_M		0X300U
#define PLU_LC1_SCTRL_SW_SYNC_SEL_S		8U
#define PLU_LC1_SCTRL_SW_MODE_M		0XFU
#define PLU_LC1_SCTRL_SW_MODE_S		0U

// The following are defines for the bit fields in the LC2_LUTCTRL0 register by plu

#define PLU_LC2_LUTCTRL0_LUTCTRL_M		0XFFFFU
#define PLU_LC2_LUTCTRL0_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC2_LUTCTRL1 register by plu

#define PLU_LC2_LUTCTRL1_LUTCTRL_M		0XFFFFU
#define PLU_LC2_LUTCTRL1_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC2_LUTCTRL2 register by plu

#define PLU_LC2_LUTCTRL2_LUTCTRL_M		0XFFFFU
#define PLU_LC2_LUTCTRL2_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC2_LUTCTRL3 register by plu

#define PLU_LC2_LUTCTRL3_LUTCTRL_M		0XFFFFU
#define PLU_LC2_LUTCTRL3_LUTCTRL_S		0U

// The following are defines for the bit fields in the LC2_FILT0 register by plu

#define PLU_LC2_FILT0_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC2_FILT0_LUT_RISE_FILT_S		16U
#define PLU_LC2_FILT0_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC2_FILT0_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC2_FILT1 register by plu

#define PLU_LC2_FILT1_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC2_FILT1_LUT_RISE_FILT_S		16U
#define PLU_LC2_FILT1_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC2_FILT1_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC2_FILT2 register by plu

#define PLU_LC2_FILT2_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC2_FILT2_LUT_RISE_FILT_S		16U
#define PLU_LC2_FILT2_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC2_FILT2_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC2_FILT3 register by plu

#define PLU_LC2_FILT3_LUT_RISE_FILT_M		0XFFFF0000U
#define PLU_LC2_FILT3_LUT_RISE_FILT_S		16U
#define PLU_LC2_FILT3_LUT_FALL_FILT_M		0XFFFFU
#define PLU_LC2_FILT3_LUT_FALL_FILT_S		0U

// The following are defines for the bit fields in the LC2_INTDMAEN register by plu

#define PLU_LC2_INTDMAEN_FORCE_DMA_EN_M		0XF000000U
#define PLU_LC2_INTDMAEN_FORCE_DMA_EN_S		24U
#define PLU_LC2_INTDMAEN_FORCE_INT_EN_M		0XF0000U
#define PLU_LC2_INTDMAEN_FORCE_INT_EN_S		16U
#define PLU_LC2_INTDMAEN_LUT_DMA_EN_M		0XF00U
#define PLU_LC2_INTDMAEN_LUT_DMA_EN_S		8U
#define PLU_LC2_INTDMAEN_LUT_INT_EN_M		0XFU
#define PLU_LC2_INTDMAEN_LUT_INT_EN_S		0U

// The following are defines for the bit fields in the LC2_STS register by plu

#define PLU_LC2_STS_FORCESTS_M		0XF00U
#define PLU_LC2_STS_FORCESTS_S		8U
#define PLU_LC2_STS_LUT_STS_M		0XFU
#define PLU_LC2_STS_LUT_STS_S		0U

// The following are defines for the bit fields in the LC2_OUTPOL register by plu

#define PLU_LC2_OUTPOL_OUTPOL_M		0XFU
#define PLU_LC2_OUTPOL_OUTPOL_S		0U

// The following are defines for the bit fields in the LC2_FFILT register by plu

#define PLU_LC2_FFILT_COMB_FORCE_M		0XF0000000U
#define PLU_LC2_FFILT_COMB_FORCE_S		28U
#define PLU_LC2_FFILT_COMB_EN_M		0XF000000U
#define PLU_LC2_FFILT_COMB_EN_S		24U
#define PLU_LC2_FFILT_FORCE_POL_M		0XF0000U
#define PLU_LC2_FFILT_FORCE_POL_S		16U
#define PLU_LC2_FFILT_FORCE_FILT_M		0XFFU
#define PLU_LC2_FFILT_FORCE_FILT_S		0U

// The following are defines for the bit fields in the LC2_FCTRL register by plu

#define PLU_LC2_FCTRL_SYNC_SEL3_M		0XC0000000U
#define PLU_LC2_FCTRL_SYNC_SEL3_S		30U
#define PLU_LC2_FCTRL_FORCE_MODE3_M		0X30000000U
#define PLU_LC2_FCTRL_FORCE_MODE3_S		28U
#define PLU_LC2_FCTRL_FORCE_SENSE3_M		0XF000000U
#define PLU_LC2_FCTRL_FORCE_SENSE3_S		24U
#define PLU_LC2_FCTRL_SYNC_SEL2_M		0XC00000U
#define PLU_LC2_FCTRL_SYNC_SEL2_S		22U
#define PLU_LC2_FCTRL_FORCE_MODE2_M		0X300000U
#define PLU_LC2_FCTRL_FORCE_MODE2_S		20U
#define PLU_LC2_FCTRL_FORCE_SENSE2_M		0XF0000U
#define PLU_LC2_FCTRL_FORCE_SENSE2_S		16U
#define PLU_LC2_FCTRL_SYNC_SEL1_M		0XC000U
#define PLU_LC2_FCTRL_SYNC_SEL1_S		14U
#define PLU_LC2_FCTRL_FORCE_MODE1_M		0X3000U
#define PLU_LC2_FCTRL_FORCE_MODE1_S		12U
#define PLU_LC2_FCTRL_FORCE_SENSE1_M		0XF00U
#define PLU_LC2_FCTRL_FORCE_SENSE1_S		8U
#define PLU_LC2_FCTRL_SYNC_SEL0_M		0XC0U
#define PLU_LC2_FCTRL_SYNC_SEL0_S		6U
#define PLU_LC2_FCTRL_FORCE_MODE0_M		0X30U
#define PLU_LC2_FCTRL_FORCE_MODE0_S		4U
#define PLU_LC2_FCTRL_FORCE_SENSE0_M		0XFU
#define PLU_LC2_FCTRL_FORCE_SENSE0_S		0U

// The following are defines for the bit fields in the LC2_SCTRL register by plu

#define PLU_LC2_SCTRL_SW_SYNC_SEL_M		0X300U
#define PLU_LC2_SCTRL_SW_SYNC_SEL_S		8U
#define PLU_LC2_SCTRL_SW_MODE_M		0XFU
#define PLU_LC2_SCTRL_SW_MODE_S		0U

// The following are defines for the bit fields in the MUXSEL0 register by plu

#define PLU_MUXSEL0_MUXSEL_M		0XFFU
#define PLU_MUXSEL0_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL1 register by plu

#define PLU_MUXSEL1_MUXSEL_M		0XFFU
#define PLU_MUXSEL1_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL2 register by plu

#define PLU_MUXSEL2_MUXSEL_M		0XFFU
#define PLU_MUXSEL2_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL3 register by plu

#define PLU_MUXSEL3_MUXSEL_M		0XFFU
#define PLU_MUXSEL3_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL4 register by plu

#define PLU_MUXSEL4_MUXSEL_M		0XFFU
#define PLU_MUXSEL4_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL5 register by plu

#define PLU_MUXSEL5_MUXSEL_M		0XFFU
#define PLU_MUXSEL5_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL6 register by plu

#define PLU_MUXSEL6_MUXSEL_M		0XFFU
#define PLU_MUXSEL6_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL7 register by plu

#define PLU_MUXSEL7_MUXSEL_M		0XFFU
#define PLU_MUXSEL7_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL8 register by plu

#define PLU_MUXSEL8_MUXSEL_M		0XFFU
#define PLU_MUXSEL8_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL9 register by plu

#define PLU_MUXSEL9_MUXSEL_M		0XFFU
#define PLU_MUXSEL9_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL10 register by plu

#define PLU_MUXSEL10_MUXSEL_M		0XFFU
#define PLU_MUXSEL10_MUXSEL_S		0U

// The following are defines for the bit fields in the MUXSEL11 register by plu

#define PLU_MUXSEL11_MUXSEL_M		0XFFU
#define PLU_MUXSEL11_MUXSEL_S		0U

// The following are defines for the bit fields in the SWEN register by plu

#define PLU_SWEN_SWEN_M		0XFFFU
#define PLU_SWEN_SWEN_S		0U

// The following are defines for the bit fields in the SWVALUE register by plu

#define PLU_SWVALUE_SWVALUE_M		0XFFFU
#define PLU_SWVALUE_SWVALUE_S		0U

// The following are defines for the bit fields in the OUTEN register by plu

#define PLU_OUTEN_OUTEN_M		0XFFFU
#define PLU_OUTEN_OUTEN_S		0U

// The following are defines for the bit fields in the LCIN register by plu

#define PLU_LCIN_LC_INPUTS_M		0XFFFU
#define PLU_LCIN_LC_INPUTS_S		0U

// The following are defines for the bit fields in the SWOUT register by plu

#define PLU_SWOUT_SWOUT_M		0XFFFU
#define PLU_SWOUT_SWOUT_S		0U

// The following are defines for the bit fields in the LCOUT register by plu

#define PLU_LCOUT_LCOUT_M		0XFFFU
#define PLU_LCOUT_LCOUT_S		0U

// The following are defines for the bit fields in the FORCEOUT register by plu

#define PLU_FORCEOUT_FORCEOUT_M		0XFFFU
#define PLU_FORCEOUT_FORCEOUT_S		0U

// The following are defines for the bit fields in the FORCESTS register by plu

#define PLU_FORCESTS_FORCESTS_M		0XFFFU
#define PLU_FORCESTS_FORCESTS_S		0U

// The following are defines for the bit fields in the INT_FLAG register by plu

#define PLU_INT_FLAG_LC_INT_MODE_M		0X1000U
#define PLU_INT_FLAG_LC_INT_MODE_S		12U
#define PLU_INT_FLAG_LC2_FORCE_INT_FLAG_M		0X800U
#define PLU_INT_FLAG_LC2_FORCE_INT_FLAG_S		11U
#define PLU_INT_FLAG_LC2_OUT_INT_FLAG_M		0X400U
#define PLU_INT_FLAG_LC2_OUT_INT_FLAG_S		10U
#define PLU_INT_FLAG_LC2_FORCE_INT_CLR_M		0X200U
#define PLU_INT_FLAG_LC2_FORCE_INT_CLR_S		9U
#define PLU_INT_FLAG_LC2_OUT_INT_CLR_M		0X100U
#define PLU_INT_FLAG_LC2_OUT_INT_CLR_S		8U
#define PLU_INT_FLAG_LC1_FORCE_INT_FLAG_M		0X80U
#define PLU_INT_FLAG_LC1_FORCE_INT_FLAG_S		7U
#define PLU_INT_FLAG_LC1_OUT_INT_FLAG_M		0X40U
#define PLU_INT_FLAG_LC1_OUT_INT_FLAG_S		6U
#define PLU_INT_FLAG_LC1_FORCE_INT_CLR_M		0X20U
#define PLU_INT_FLAG_LC1_FORCE_INT_CLR_S		5U
#define PLU_INT_FLAG_LC1_OUT_INT_CLR_M		0X10U
#define PLU_INT_FLAG_LC1_OUT_INT_CLR_S		4U
#define PLU_INT_FLAG_LC0_FORCE_INT_FLAG_M		0X8U
#define PLU_INT_FLAG_LC0_FORCE_INT_FLAG_S		3U
#define PLU_INT_FLAG_LC0_OUT_INT_FLAG_M		0X4U
#define PLU_INT_FLAG_LC0_OUT_INT_FLAG_S		2U
#define PLU_INT_FLAG_LC0_FORCE_INT_CLR_M		0X2U
#define PLU_INT_FLAG_LC0_FORCE_INT_CLR_S		1U
#define PLU_INT_FLAG_LC0_OUT_INT_CLR_M		0X1U
#define PLU_INT_FLAG_LC0_OUT_INT_CLR_S		0U

// The following are defines for the bit fields in the PLU_IN_0SEL register by plu

#define PLU_PLU_IN_0SEL_PLU_IN_2SEL_M		0X3FF00000U
#define PLU_PLU_IN_0SEL_PLU_IN_2SEL_S		20U
#define PLU_PLU_IN_0SEL_PLU_IN_1SEL_M		0XFFC00U
#define PLU_PLU_IN_0SEL_PLU_IN_1SEL_S		10U
#define PLU_PLU_IN_0SEL_PLU_IN_0SEL_M		0X3FFU
#define PLU_PLU_IN_0SEL_PLU_IN_0SEL_S		0U

// The following are defines for the bit fields in the PLU_IN_1SEL register by plu

#define PLU_PLU_IN_1SEL_PLU_IN_5SEL_M		0X3FF00000U
#define PLU_PLU_IN_1SEL_PLU_IN_5SEL_S		20U
#define PLU_PLU_IN_1SEL_PLU_IN_4SEL_M		0XFFC00U
#define PLU_PLU_IN_1SEL_PLU_IN_4SEL_S		10U
#define PLU_PLU_IN_1SEL_PLU_IN_3SEL_M		0X3FFU
#define PLU_PLU_IN_1SEL_PLU_IN_3SEL_S		0U

// The following are defines for the bit fields in the PLU_IN_2SEL register by plu

#define PLU_PLU_IN_2SEL_PLU_IN_8SEL_M		0X3FF00000U
#define PLU_PLU_IN_2SEL_PLU_IN_8SEL_S		20U
#define PLU_PLU_IN_2SEL_PLU_IN_7SEL_M		0XFFC00U
#define PLU_PLU_IN_2SEL_PLU_IN_7SEL_S		10U
#define PLU_PLU_IN_2SEL_PLU_IN_6SEL_M		0X3FFU
#define PLU_PLU_IN_2SEL_PLU_IN_6SEL_S		0U

// The following are defines for the bit fields in the PLU_IN_3SEL register by plu

#define PLU_PLU_IN_3SEL_PLU_IN_11SEL_M		0X3FF00000U
#define PLU_PLU_IN_3SEL_PLU_IN_11SEL_S		20U
#define PLU_PLU_IN_3SEL_PLU_IN_10SEL_M		0XFFC00U
#define PLU_PLU_IN_3SEL_PLU_IN_10SEL_S		10U
#define PLU_PLU_IN_3SEL_PLU_IN_9SEL_M		0X3FFU
#define PLU_PLU_IN_3SEL_PLU_IN_9SEL_S		0U

// The following are defines for the bit fields in the PLU_FORCE_0SEL register by plu

#define PLU_PLU_FORCE_0SEL_PLU_FORCE_2SEL_M		0X3FF00000U
#define PLU_PLU_FORCE_0SEL_PLU_FORCE_2SEL_S		20U
#define PLU_PLU_FORCE_0SEL_PLU_FORCE_1SEL_M		0XFFC00U
#define PLU_PLU_FORCE_0SEL_PLU_FORCE_1SEL_S		10U
#define PLU_PLU_FORCE_0SEL_PLU_FORCE_0SEL_M		0X3FFU
#define PLU_PLU_FORCE_0SEL_PLU_FORCE_0SEL_S		0U

// The following are defines for the bit fields in the PLU_FORCE_1SEL register by plu

#define PLU_PLU_FORCE_1SEL_PLU_FORCE_3SEL_M		0X3FFU
#define PLU_PLU_FORCE_1SEL_PLU_FORCE_3SEL_S		0U

// The following are defines for the bit fields in the PLU_SYN_0SEL register by plu

#define PLU_PLU_SYN_0SEL_PLU_SYN_2SEL_M		0X3FF00000U
#define PLU_PLU_SYN_0SEL_PLU_SYN_2SEL_S		20U
#define PLU_PLU_SYN_0SEL_PLU_SYN_1SEL_M		0XFFC00U
#define PLU_PLU_SYN_0SEL_PLU_SYN_1SEL_S		10U
#define PLU_PLU_SYN_0SEL_PLU_SYN_0SEL_M		0X3FFU
#define PLU_PLU_SYN_0SEL_PLU_SYN_0SEL_S		0U

// The following are defines for the bit fields in the PLU_SYN_1SEL register by plu

#define PLU_PLU_SYN_1SEL_PLU_SYN_3SEL_M		0X3FFU
#define PLU_PLU_SYN_1SEL_PLU_SYN_3SEL_S		0U

// The following are defines for the bit fields in the PLU_HALT_EN register by plu

#define PLU_PLU_HALT_EN_PLU_HALT_EN_M		0X3U
#define PLU_PLU_HALT_EN_PLU_HALT_EN_S		0U

// The following are defines for the bit fields in the PLU_INT_REQ_EN register by plu

#define PLU_PLU_INT_REQ_EN_PLU_LC3_INT_REQ_EN_M		0X30U
#define PLU_PLU_INT_REQ_EN_PLU_LC3_INT_REQ_EN_S		4U
#define PLU_PLU_INT_REQ_EN_PLU_LC2_INT_REQ_EN_M		0XCU
#define PLU_PLU_INT_REQ_EN_PLU_LC2_INT_REQ_EN_S		2U
#define PLU_PLU_INT_REQ_EN_PLU_LC1_INT_REQ_EN_M		0X3U
#define PLU_PLU_INT_REQ_EN_PLU_LC1_INT_REQ_EN_S		0U


/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

/* None */

/*==================================================================================================
*                                        INCLUDE FILES
* 1) system and project includes
* 2) needed interfaces from external units
* 3) internal and external interfaces from this unit
==================================================================================================*/

/*===============================================================================================
                                       DEFINES AND MACROS
===============================================================================================*/



/*==================================================================================================
*                                             ENUMS
==================================================================================================*/

/*==================================================================================================
*                                STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/



/**************************************************************************************************
       xxxx_LCU.h
***************************************************************************************************/
/* ----------------------------------------------------------------------------
   -- LCU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LCU_Peripheral_Access_Layer LCU Peripheral Access Layer
 * @{
 */

/** LCU - Size of Registers Arrays */
#define LCU_LC_LUTCTRL_COUNT                      4u
#define LCU_LC_FILT_COUNT                         4u
#define LCU_LC_COUNT                              3u
#define LCU_SEL_COUNT                             12u

/** Number of instances of the LCU module. */
#define LCU_INSTANCE_COUNT                       (2u)

/* LCU - Peripheral instance base addresses */
/** Peripheral LCU_0 base address */
#define IP_LCU_0_BASE                            (0x40204000U)
/** Peripheral LCU_0 base pointer */
#define IP_LCU_0                                 ((LCU_Type *)IP_LCU_0_BASE)
/** Peripheral LCU_1 base address */
#define IP_LCU_1_BASE                            (0x40204000U)
/** Peripheral LCU_1 base pointer */
#define IP_LCU_1                                 ((LCU_Type *)IP_LCU_1_BASE)
/** Array initializer of LCU peripheral base addresses */
#define IP_LCU_BASE_ADDRS                        { IP_LCU_0_BASE, IP_LCU_1_BASE }
/** Array initializer of LCU peripheral base pointers */
#define IP_LCU_BASE_PTRS                         { IP_LCU_0, IP_LCU_1 }

/* ----------------------------------------------------------------------------
   -- LCU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup LCU_Register_Masks LCU Register Masks
 * @{
 */

/*! @name LUTCTRL - LC 0 Output 0 LUT Control..LC 2 Output 3 LUT Control */
/*! @{ */

#define LCU_LUTCTRL_LUTCTRL_MASK                 (0xFFFFU)
#define LCU_LUTCTRL_LUTCTRL_SHIFT                (0U)
#define LCU_LUTCTRL_LUTCTRL_WIDTH                (16U)
#define LCU_LUTCTRL_LUTCTRL(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_LUTCTRL_LUTCTRL_SHIFT)) & LCU_LUTCTRL_LUTCTRL_MASK)
/*! @} */

/*! @name FILT - LC 0 Output 0 Filter..LC 2 Output 3 Filter */
/*! @{ */

#define LCU_FILT_LUT_FALL_FILT_MASK              (0xFFFFU)
#define LCU_FILT_LUT_FALL_FILT_SHIFT             (0U)
#define LCU_FILT_LUT_FALL_FILT_WIDTH             (16U)
#define LCU_FILT_LUT_FALL_FILT(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FILT_LUT_FALL_FILT_SHIFT)) & LCU_FILT_LUT_FALL_FILT_MASK)

#define LCU_FILT_LUT_RISE_FILT_MASK              (0xFFFF0000U)
#define LCU_FILT_LUT_RISE_FILT_SHIFT             (16U)
#define LCU_FILT_LUT_RISE_FILT_WIDTH             (16U)
#define LCU_FILT_LUT_RISE_FILT(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FILT_LUT_RISE_FILT_SHIFT)) & LCU_FILT_LUT_RISE_FILT_MASK)
/*! @} */

/*! @name INTDMAEN - LC 0 Interrupt and DMA Enable..LC 2 Interrupt and DMA Enable */
/*! @{ */

#define LCU_INTDMAEN_LUT_INT_EN_MASK             (0xFU)
#define LCU_INTDMAEN_LUT_INT_EN_SHIFT            (0U)
#define LCU_INTDMAEN_LUT_INT_EN_WIDTH            (4U)
#define LCU_INTDMAEN_LUT_INT_EN(x)               (((uint32_t)(((uint32_t)(x)) << LCU_INTDMAEN_LUT_INT_EN_SHIFT)) & LCU_INTDMAEN_LUT_INT_EN_MASK)

#define LCU_INTDMAEN_LUT_DMA_EN_MASK             (0xF00U)
#define LCU_INTDMAEN_LUT_DMA_EN_SHIFT            (8U)
#define LCU_INTDMAEN_LUT_DMA_EN_WIDTH            (4U)
#define LCU_INTDMAEN_LUT_DMA_EN(x)               (((uint32_t)(((uint32_t)(x)) << LCU_INTDMAEN_LUT_DMA_EN_SHIFT)) & LCU_INTDMAEN_LUT_DMA_EN_MASK)

#define LCU_INTDMAEN_FORCE_INT_EN_MASK           (0xF0000U)
#define LCU_INTDMAEN_FORCE_INT_EN_SHIFT          (16U)
#define LCU_INTDMAEN_FORCE_INT_EN_WIDTH          (4U)
#define LCU_INTDMAEN_FORCE_INT_EN(x)             (((uint32_t)(((uint32_t)(x)) << LCU_INTDMAEN_FORCE_INT_EN_SHIFT)) & LCU_INTDMAEN_FORCE_INT_EN_MASK)

#define LCU_INTDMAEN_FORCE_DMA_EN_MASK           (0xF000000U)
#define LCU_INTDMAEN_FORCE_DMA_EN_SHIFT          (24U)
#define LCU_INTDMAEN_FORCE_DMA_EN_WIDTH          (4U)
#define LCU_INTDMAEN_FORCE_DMA_EN(x)             (((uint32_t)(((uint32_t)(x)) << LCU_INTDMAEN_FORCE_DMA_EN_SHIFT)) & LCU_INTDMAEN_FORCE_DMA_EN_MASK)
/*! @} */

/*! @name STS - LC 0 Status..LC 2 Status */
/*! @{ */

#define LCU_STS_LUT_STS_MASK                     (0xFU)
#define LCU_STS_LUT_STS_SHIFT                    (0U)
#define LCU_STS_LUT_STS_WIDTH                    (4U)
#define LCU_STS_LUT_STS(x)                       (((uint32_t)(((uint32_t)(x)) << LCU_STS_LUT_STS_SHIFT)) & LCU_STS_LUT_STS_MASK)

#define LCU_STS_FORCESTS_MASK                    (0xF00U)
#define LCU_STS_FORCESTS_SHIFT                   (8U)
#define LCU_STS_FORCESTS_WIDTH                   (4U)
#define LCU_STS_FORCESTS(x)                      (((uint32_t)(((uint32_t)(x)) << LCU_STS_FORCESTS_SHIFT)) & LCU_STS_FORCESTS_MASK)
/*! @} */

/*! @name OUTPOL - LC 0 Output Polarity Control..LC 2 Output Polarity Control */
/*! @{ */

#define LCU_OUTPOL_OUTPOL_MASK                   (0xFU)
#define LCU_OUTPOL_OUTPOL_SHIFT                  (0U)
#define LCU_OUTPOL_OUTPOL_WIDTH                  (4U)
#define LCU_OUTPOL_OUTPOL(x)                     (((uint32_t)(((uint32_t)(x)) << LCU_OUTPOL_OUTPOL_SHIFT)) & LCU_OUTPOL_OUTPOL_MASK)
/*! @} */

/*! @name FFILT - LC 0 Force Filter..LC 2 Force Filter */
/*! @{ */

#define LCU_FFILT_FORCE_FILT_MASK                (0xFFU)
#define LCU_FFILT_FORCE_FILT_SHIFT               (0U)
#define LCU_FFILT_FORCE_FILT_WIDTH               (8U)
#define LCU_FFILT_FORCE_FILT(x)                  (((uint32_t)(((uint32_t)(x)) << LCU_FFILT_FORCE_FILT_SHIFT)) & LCU_FFILT_FORCE_FILT_MASK)

#define LCU_FFILT_FORCE_POL_MASK                 (0x70000U)
#define LCU_FFILT_FORCE_POL_SHIFT                (16U)
#define LCU_FFILT_FORCE_POL_WIDTH                (3U)
#define LCU_FFILT_FORCE_POL(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_FFILT_FORCE_POL_SHIFT)) & LCU_FFILT_FORCE_POL_MASK)

#define LCU_FFILT_COMB_EN_MASK                   (0x7000000U)
#define LCU_FFILT_COMB_EN_SHIFT                  (24U)
#define LCU_FFILT_COMB_EN_WIDTH                  (3U)
#define LCU_FFILT_COMB_EN(x)                     (((uint32_t)(((uint32_t)(x)) << LCU_FFILT_COMB_EN_SHIFT)) & LCU_FFILT_COMB_EN_MASK)

#define LCU_FFILT_COMB_FORCE_MASK                (0xF0000000U)
#define LCU_FFILT_COMB_FORCE_SHIFT               (28U)
#define LCU_FFILT_COMB_FORCE_WIDTH               (4U)
#define LCU_FFILT_COMB_FORCE(x)                  (((uint32_t)(((uint32_t)(x)) << LCU_FFILT_COMB_FORCE_SHIFT)) & LCU_FFILT_COMB_FORCE_MASK)
/*! @} */

/*! @name FCTRL - LC 0 Force Control..LC 2 Force Control */
/*! @{ */

#define LCU_FCTRL_FORCE_SENSE0_MASK              (0xFU)
#define LCU_FCTRL_FORCE_SENSE0_SHIFT             (0U)
#define LCU_FCTRL_FORCE_SENSE0_WIDTH             (4U)
#define LCU_FCTRL_FORCE_SENSE0(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_SENSE0_SHIFT)) & LCU_FCTRL_FORCE_SENSE0_MASK)

#define LCU_FCTRL_FORCE_MODE0_MASK               (0x30U)
#define LCU_FCTRL_FORCE_MODE0_SHIFT              (4U)
#define LCU_FCTRL_FORCE_MODE0_WIDTH              (2U)
#define LCU_FCTRL_FORCE_MODE0(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_MODE0_SHIFT)) & LCU_FCTRL_FORCE_MODE0_MASK)

#define LCU_FCTRL_SYNC_SEL0_MASK                 (0xC0U)
#define LCU_FCTRL_SYNC_SEL0_SHIFT                (6U)
#define LCU_FCTRL_SYNC_SEL0_WIDTH                (2U)
#define LCU_FCTRL_SYNC_SEL0(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_SYNC_SEL0_SHIFT)) & LCU_FCTRL_SYNC_SEL0_MASK)

#define LCU_FCTRL_FORCE_SENSE1_MASK              (0xF00U)
#define LCU_FCTRL_FORCE_SENSE1_SHIFT             (8U)
#define LCU_FCTRL_FORCE_SENSE1_WIDTH             (4U)
#define LCU_FCTRL_FORCE_SENSE1(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_SENSE1_SHIFT)) & LCU_FCTRL_FORCE_SENSE1_MASK)

#define LCU_FCTRL_FORCE_MODE1_MASK               (0x3000U)
#define LCU_FCTRL_FORCE_MODE1_SHIFT              (12U)
#define LCU_FCTRL_FORCE_MODE1_WIDTH              (2U)
#define LCU_FCTRL_FORCE_MODE1(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_MODE1_SHIFT)) & LCU_FCTRL_FORCE_MODE1_MASK)

#define LCU_FCTRL_SYNC_SEL1_MASK                 (0xC000U)
#define LCU_FCTRL_SYNC_SEL1_SHIFT                (14U)
#define LCU_FCTRL_SYNC_SEL1_WIDTH                (2U)
#define LCU_FCTRL_SYNC_SEL1(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_SYNC_SEL1_SHIFT)) & LCU_FCTRL_SYNC_SEL1_MASK)

#define LCU_FCTRL_FORCE_SENSE2_MASK              (0xF0000U)
#define LCU_FCTRL_FORCE_SENSE2_SHIFT             (16U)
#define LCU_FCTRL_FORCE_SENSE2_WIDTH             (4U)
#define LCU_FCTRL_FORCE_SENSE2(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_SENSE2_SHIFT)) & LCU_FCTRL_FORCE_SENSE2_MASK)

#define LCU_FCTRL_FORCE_MODE2_MASK               (0x300000U)
#define LCU_FCTRL_FORCE_MODE2_SHIFT              (20U)
#define LCU_FCTRL_FORCE_MODE2_WIDTH              (2U)
#define LCU_FCTRL_FORCE_MODE2(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_MODE2_SHIFT)) & LCU_FCTRL_FORCE_MODE2_MASK)

#define LCU_FCTRL_SYNC_SEL2_MASK                 (0xC00000U)
#define LCU_FCTRL_SYNC_SEL2_SHIFT                (22U)
#define LCU_FCTRL_SYNC_SEL2_WIDTH                (2U)
#define LCU_FCTRL_SYNC_SEL2(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_SYNC_SEL2_SHIFT)) & LCU_FCTRL_SYNC_SEL2_MASK)

#define LCU_FCTRL_FORCE_SENSE3_MASK              (0xF000000U)
#define LCU_FCTRL_FORCE_SENSE3_SHIFT             (24U)
#define LCU_FCTRL_FORCE_SENSE3_WIDTH             (4U)
#define LCU_FCTRL_FORCE_SENSE3(x)                (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_SENSE3_SHIFT)) & LCU_FCTRL_FORCE_SENSE3_MASK)

#define LCU_FCTRL_FORCE_MODE3_MASK               (0x30000000U)
#define LCU_FCTRL_FORCE_MODE3_SHIFT              (28U)
#define LCU_FCTRL_FORCE_MODE3_WIDTH              (2U)
#define LCU_FCTRL_FORCE_MODE3(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_FORCE_MODE3_SHIFT)) & LCU_FCTRL_FORCE_MODE3_MASK)

#define LCU_FCTRL_SYNC_SEL3_MASK                 (0xC0000000U)
#define LCU_FCTRL_SYNC_SEL3_SHIFT                (30U)
#define LCU_FCTRL_SYNC_SEL3_WIDTH                (2U)
#define LCU_FCTRL_SYNC_SEL3(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_FCTRL_SYNC_SEL3_SHIFT)) & LCU_FCTRL_SYNC_SEL3_MASK)
/*! @} */

/*! @name SCTRL - LC 0 Sync Control..LC 2 Sync Control */
/*! @{ */

#define LCU_SCTRL_SW_MODE_MASK                   (0xFU)
#define LCU_SCTRL_SW_MODE_SHIFT                  (0U)
#define LCU_SCTRL_SW_MODE_WIDTH                  (4U)
#define LCU_SCTRL_SW_MODE(x)                     (((uint32_t)(((uint32_t)(x)) << LCU_SCTRL_SW_MODE_SHIFT)) & LCU_SCTRL_SW_MODE_MASK)

#define LCU_SCTRL_SW_SYNC_SEL_MASK               (0x300U)
#define LCU_SCTRL_SW_SYNC_SEL_SHIFT              (8U)
#define LCU_SCTRL_SW_SYNC_SEL_WIDTH              (2U)
#define LCU_SCTRL_SW_SYNC_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_SCTRL_SW_SYNC_SEL_SHIFT)) & LCU_SCTRL_SW_SYNC_SEL_MASK)
/*! @} */

/*! @name MUXSEL - Mux Select */
/*! @{ */

#define LCU_MUXSEL_MUXSEL_MASK                   (0xFFU)
#define LCU_MUXSEL_MUXSEL_SHIFT                  (0U)
#define LCU_MUXSEL_MUXSEL_WIDTH                  (8U)
#define LCU_MUXSEL_MUXSEL(x)                     (((uint32_t)(((uint32_t)(x)) << LCU_MUXSEL_MUXSEL_SHIFT)) & LCU_MUXSEL_MUXSEL_MASK)
/*! @} */

/*! @name CFG - Configuration */
/*! @{ */

#define LCU_CFG_WP_MASK                          (0x1U)
#define LCU_CFG_WP_SHIFT                         (0U)
#define LCU_CFG_WP_WIDTH                         (1U)
#define LCU_CFG_WP(x)                            (((uint32_t)(((uint32_t)(x)) << LCU_CFG_WP_SHIFT)) & LCU_CFG_WP_MASK)

#define LCU_CFG_INCL_MUXES_MASK                  (0x80U)
#define LCU_CFG_INCL_MUXES_SHIFT                 (7U)
#define LCU_CFG_INCL_MUXES_WIDTH                 (1U)
#define LCU_CFG_INCL_MUXES(x)                    (((uint32_t)(((uint32_t)(x)) << LCU_CFG_INCL_MUXES_SHIFT)) & LCU_CFG_INCL_MUXES_MASK)

#define LCU_CFG_NUM_SYNCS_MASK                   (0xFF00U)
#define LCU_CFG_NUM_SYNCS_SHIFT                  (8U)
#define LCU_CFG_NUM_SYNCS_WIDTH                  (8U)
#define LCU_CFG_NUM_SYNCS(x)                     (((uint32_t)(((uint32_t)(x)) << LCU_CFG_NUM_SYNCS_SHIFT)) & LCU_CFG_NUM_SYNCS_MASK)

#define LCU_CFG_NUM_FORCES_MASK                  (0xFF0000U)
#define LCU_CFG_NUM_FORCES_SHIFT                 (16U)
#define LCU_CFG_NUM_FORCES_WIDTH                 (8U)
#define LCU_CFG_NUM_FORCES(x)                    (((uint32_t)(((uint32_t)(x)) << LCU_CFG_NUM_FORCES_SHIFT)) & LCU_CFG_NUM_FORCES_MASK)

#define LCU_CFG_NUM_LOGIC_CELLS_MASK             (0xFF000000U)
#define LCU_CFG_NUM_LOGIC_CELLS_SHIFT            (24U)
#define LCU_CFG_NUM_LOGIC_CELLS_WIDTH            (8U)
#define LCU_CFG_NUM_LOGIC_CELLS(x)               (((uint32_t)(((uint32_t)(x)) << LCU_CFG_NUM_LOGIC_CELLS_SHIFT)) & LCU_CFG_NUM_LOGIC_CELLS_MASK)
/*! @} */

/*! @name SWEN - Software Override Enable */
/*! @{ */

#define LCU_SWEN_SWEN_MASK                       (0xFFFU)
#define LCU_SWEN_SWEN_SHIFT                      (0U)
#define LCU_SWEN_SWEN_WIDTH                      (12U)
#define LCU_SWEN_SWEN(x)                         (((uint32_t)(((uint32_t)(x)) << LCU_SWEN_SWEN_SHIFT)) & LCU_SWEN_SWEN_MASK)
/*! @} */

/*! @name SWVALUE - Software Override Value */
/*! @{ */

#define LCU_SWVALUE_SWVALUE_MASK                 (0xFFFU)
#define LCU_SWVALUE_SWVALUE_SHIFT                (0U)
#define LCU_SWVALUE_SWVALUE_WIDTH                (12U)
#define LCU_SWVALUE_SWVALUE(x)                   (((uint32_t)(((uint32_t)(x)) << LCU_SWVALUE_SWVALUE_SHIFT)) & LCU_SWVALUE_SWVALUE_MASK)
/*! @} */

/*! @name OUTEN - Output Enable */
/*! @{ */

#define LCU_OUTEN_OUTEN_MASK                     (0xFFFU)
#define LCU_OUTEN_OUTEN_SHIFT                    (0U)
#define LCU_OUTEN_OUTEN_WIDTH                    (12U)
#define LCU_OUTEN_OUTEN(x)                       (((uint32_t)(((uint32_t)(x)) << LCU_OUTEN_OUTEN_SHIFT)) & LCU_OUTEN_OUTEN_MASK)
/*! @} */

/*! @name LCIN - Logic Inputs */
/*! @{ */

#define LCU_LCIN_LC_INPUTS_MASK                  (0xFFFU)
#define LCU_LCIN_LC_INPUTS_SHIFT                 (0U)
#define LCU_LCIN_LC_INPUTS_WIDTH                 (12U)
#define LCU_LCIN_LC_INPUTS(x)                    (((uint32_t)(((uint32_t)(x)) << LCU_LCIN_LC_INPUTS_SHIFT)) & LCU_LCIN_LC_INPUTS_MASK)
/*! @} */

/*! @name SWOUT - Overridden Inputs */
/*! @{ */

#define LCU_SWOUT_SWOUT_MASK                     (0xFFFU)
#define LCU_SWOUT_SWOUT_SHIFT                    (0U)
#define LCU_SWOUT_SWOUT_WIDTH                    (12U)
#define LCU_SWOUT_SWOUT(x)                       (((uint32_t)(((uint32_t)(x)) << LCU_SWOUT_SWOUT_SHIFT)) & LCU_SWOUT_SWOUT_MASK)
/*! @} */

/*! @name LCOUT - Logic Outputs */
/*! @{ */

#define LCU_LCOUT_LCOUT_MASK                     (0xFFFU)
#define LCU_LCOUT_LCOUT_SHIFT                    (0U)
#define LCU_LCOUT_LCOUT_WIDTH                    (12U)
#define LCU_LCOUT_LCOUT(x)                       (((uint32_t)(((uint32_t)(x)) << LCU_LCOUT_LCOUT_SHIFT)) & LCU_LCOUT_LCOUT_MASK)
/*! @} */

/*! @name FORCEOUT - Forced Outputs */
/*! @{ */

#define LCU_FORCEOUT_FORCEOUT_MASK               (0xFFFU)
#define LCU_FORCEOUT_FORCEOUT_SHIFT              (0U)
#define LCU_FORCEOUT_FORCEOUT_WIDTH              (12U)
#define LCU_FORCEOUT_FORCEOUT(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FORCEOUT_FORCEOUT_SHIFT)) & LCU_FORCEOUT_FORCEOUT_MASK)
/*! @} */

/*! @name FORCESTS - Force Status */
/*! @{ */

#define LCU_FORCESTS_FORCESTS_MASK               (0xFFFU)
#define LCU_FORCESTS_FORCESTS_SHIFT              (0U)
#define LCU_FORCESTS_FORCESTS_WIDTH              (12U)
#define LCU_FORCESTS_FORCESTS(x)                 (((uint32_t)(((uint32_t)(x)) << LCU_FORCESTS_FORCESTS_SHIFT)) & LCU_FORCESTS_FORCESTS_MASK)
/*! @} */

/*! @name DBGEN - Debug Mode Enable */
/*! @{ */

#define LCU_DBGEN_DBGEN_MASK                     (0xFFFU)
#define LCU_DBGEN_DBGEN_SHIFT                    (0U)
#define LCU_DBGEN_DBGEN_WIDTH                    (12U)
#define LCU_DBGEN_DBGEN(x)                       (((uint32_t)(((uint32_t)(x)) << LCU_DBGEN_DBGEN_SHIFT)) & LCU_DBGEN_DBGEN_MASK)
/*! @} */

/*!
 * @}
 */ /* end of group LCU_Register_Masks */

/*!
 * @}
 */ /* end of group LCU_Peripheral_Access_Layer */

/**************************************************************************************************
    Lcu_Ip_Features.h
***************************************************************************************************/
/*==================================================================================================
                                            DEFINES
==================================================================================================*/

/*==================================================================================================
*                                              ENUMS
==================================================================================================*/

/*==================================================================================================
*                                  STRUCTURES AND OTHER TYPEDEFS
==================================================================================================*/


/*==================================================================================================
*                                GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/



/*==================================================================================================
*                                    FUNCTION PROTOTYPES
==================================================================================================*/



/*==================================================================================================
*                                  GLOBAL VARIABLE DECLARATIONS
==================================================================================================*/


/*==================================================================================================
*                                       FUNCTION PROTOTYPES
==================================================================================================*/


#ifdef __cplusplus
}
#endif

#endif /* DEVICE_HEADER_HW_PLU_H_ */

/*==================================================================================================
 *                                        END OF FILE
==================================================================================================*/
