/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_ahb.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_AHB_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_AHB_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the ahb1_comm_para register offsets

#if IS_GS32F00xx()
#if IS_GS32F00xx(0x12)
#define AHB1_COMM_PARA_SYNCSELSYNCOUT             0X0U
#define AHB1_COMM_PARA_ADCSOCOUTSELECT            0x4U
#define AHB1_COMM_PARA_TBCLKSYNC                  0X44U
#define AHB1_COMM_PARA_SMP_EN                     0x80U
#define AHB1_COMM_PARA_SMP_MODE                   0x84U
#define AHB1_COMM_PARA_SMP_GAP                    0x88U
#define AHB1_COMM_PARA_SMP_LEN                    0x8CU

#elif IS_GS32F00xx(0x30)

#define AHB1_COMM_PARA_SYNCSELSYNCOUT             0X0U
#define AHB1_COMM_PARA_ADCSOCOUTSELECT            0x4U
#define AHB1_COMM_PARA_TBCLKSYNC                  0X44U
#define AHB1_COMM_PARA_ADC_SAMPLE_SEL             0x50U
#define AHB1_COMM_PARA_SMP_EN                     0x80U
#define AHB1_COMM_PARA_SMP_MODE                   0x84U
#define AHB1_COMM_PARA_SMP_GAP                    0x88U
#define AHB1_COMM_PARA_SMP_LEN                    0x8CU

#endif
#elif IS_GS32F3xx()
#if IS_GS32F3xx(0x22)
#define AHB1_COMM_PARA_SYNCSELSYNCOUT             0X0U
#define AHB1_COMM_PARA_ADCSOCOUTSELECT            0x4U
#define AHB1_COMM_PARA_ADCSOCOUTSELECT_1          0x8U
#define AHB1_COMM_PARA_TBCLKSYNC                  0X44U
#define AHB1_COMM_PARA_SMP_EN                     0x80U
#define AHB1_COMM_PARA_SMP_MODE                   0x84U
#define AHB1_COMM_PARA_SMP_GAP                    0x88U
#define AHB1_COMM_PARA_SMP_LEN                    0x8CU
#endif
// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_1 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_1_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_1_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_2 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_2_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_2_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_3 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_3_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_3_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_4 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_4_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_4_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_5 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_5_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_5_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_6 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_6_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_6_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_7 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_7_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_7_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_8 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_8_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_8_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_9 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_9_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_9_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_10 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_10_SYNCSELEPWMSYNCIN_M       0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_10_SYNCSELEPWMSYNCIN_S       0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_11 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_11_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_11_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELEPWMSYNCIN_12 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_12_SYNCSELEPWMSYNCIN_M        0X1FU
#define AHB1_COMM_PARA_SYNCSELEPWMSYNCIN_12_SYNCSELEPWMSYNCIN_S        0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_1 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_1_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_1_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_2 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_2_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_2_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_3 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_3_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_3_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_4 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_4_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_4_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_5 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_5_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_5_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_6 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_6_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_6_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELECAPSYNCIN_7 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_7_SYNCSELECAPSYNCIN_M         0X1FU
#define AHB1_COMM_PARA_SYNCSELECAPSYNCIN_7_SYNCSELECAPSYNCIN_S         0U

// The following are defines for the bit fields in the SYNCSELSYNCOUT_0 register by ahb1_comm_para

#define AHB1_COMM_PARA_SYNCSELSYNCOUT_SYNCSELSYNCOUT_M                 0X1FU
#define AHB1_COMM_PARA_SYNCSELSYNCOUT_SYNCSELSYNCOUT_S                 0U

#endif
/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

/* None */

 #ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_HW_SYSCTL_AHB_H_ */
