/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_crg_v12.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V12_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_CRG_V12_H_

#include "gs32_version.h"

#if IS_GS32F00xx(0x12)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define CRG_CFG_O_CRG_CFG_LOCK                      0x000    // Lock control register.
#define CRG_CFG_O_REF_CLK_SEL                       0x004    // PLL reference clock selection.
#define CRG_CFG_O_S2N_CLK_SEL                       0x008    // System clock fast/slow switch.
#define CRG_CFG_O_CAN_CORE_CLK_SEL                  0x00C    // CAN CORE clock switch selection.
#define CRG_CFG_O_CFG_DIV_SLV_SYS                   0x010    // SLV clk division configuration.
#define CRG_CFG_O_CFG_DIV_DSP_SYS                   0x014    // DSP clk division configuration.
#define CRG_CFG_O_CFG_DIV_APB_SYS                   0x018    // APB clk division configuration.
#define CRG_CFG_O_CFG_SYS_DIV_LOAD_POS              0x01C    // System divider configuration update indication.
#define CRG_CFG_O_TRACE_CLK_DIV                     0x020    // Trace clock division configuration.
#define CRG_CFG_O_SMW_CLK_DIV                       0x024    // SMW clock division configuration.
#define CRG_CFG_O_CFG_DIV_CAN                       0x028    // CAN clock division configuration.
#define CRG_CFG_O_CFG_DSP_WDG_CLK_PRE_DIV           0x038    // DSP watchdog clock division configuration.
#define CRG_CFG_O_CFG_DSP_WDG_CLK_SCALER_DIV        0x03C    // DSP watchdog clock scaler division configuration.
#define CRG_CFG_O_CFG_DBG_WDT_HOLD_EN               0x040    // Debug watchdog pause enable.
#define CRG_CFG_O_DSP_WDG_RST_EN                    0x048    // DSP watchdog configuration.
#define CRG_CFG_O_SLAVE_CORE_RST_ON_SYS             0x04C    // Whether to trigger a system reset when the slave core is reset.
#define CRG_CFG_O_CFG_CMD_EN                        0x050    // CMD enable.
#define CRG_CFG_O_CFG_CMD_ST_CLR                    0x054    // CMD status clear enable.
#define CRG_CFG_O_CMD_CHECK_FAIL_RPT                0x058    // CMD check result report.
#define CRG_CFG_O_TEST_MUX_EN                       0x060    // Test MUX enable configuration.
#define CRG_CFG_O_TEST_MUX_SEL                      0x064    // Test MUX selection configuration.
#define CRG_CFG_O_OBS_SIG_SEL                       0x068    // Observation signal selection configuration.
#define CRG_CFG_O_OBS_SIG_DIV                       0x06C    // Observation signal division configuration.
#define CRG_CFG_O_X1_CNT                            0x070    // X1 clock self-test register.
#define CRG_CFG_O_MASTER_CORE_RST_RECORD            0x074    // DSP system reset reason record.

#define CRG_CFG_O_PLL_PD                            0x200    // PLL power-down configuration.
#define CRG_CFG_O_PLL_BYPASS                        0x204    // PLL bypass configuration.
#define CRG_CFG_O_PLL_OTHPD_CFG                     0x208    // PLL function power-down configuration.
#define CRG_CFG_O_PLL_DIV_CFG                       0x20C    // PLL division configuration.
#define CRG_CFG_O_PLL_FBDIV_CFG                     0x210    // PLL feedback divider configuration.
#define CRG_CFG_O_PLL_FRAC_CFG                      0x214    // PLL fractional divider configuration.
#define CRG_CFG_O_PLL_DIVVAL                        0x21C    // PLL spread spectrum division value configuration.
#define CRG_CFG_O_PLL_SPREAD                        0x220    // PLL spread spectrum configuration.
#define CRG_CFG_O_PLL_DOWNSPREAD                    0x224    // PLL down spread configuration.
#define CRG_CFG_O_PLL_EXT_MAXADDR                   0x228    // PLL extended maximum address configuration.
#define CRG_CFG_O_PLL_SEL_EXTWAVE                   0x22C    // PLL external wave selection enable.
#define CRG_CFG_O_PLL_RESETPTR                      0x230    // PLL reset pointer.
#define CRG_CFG_O_PLL_DISABLE_SSCG                  0x234    // PLL spread spectrum disable configuration.
#define CRG_CFG_O_PLL_UNLCK                         0x238    // PLL unlock status.
#define CRG_CFG_O_PLL_LCK                           0x23C    // PLL lock status.

#define CRG_CFG_O_OSC1_TRIM_OSC_EN                  0x300    // OSC1 calibration enable.
#define CRG_CFG_O_OSC1_TRIM_OSC_STEP_NUM            0x304    // OSC1 calibration step configuration.
#define CRG_CFG_O_OSC1_TRIM_OSC_CALC_NUM            0x308    // OSC1 calibration calculation length.
#define CRG_CFG_O_OSC1_TRIM_OSC_WAIT_NUM            0x30C    // OSC1 wait refresh time.
#define CRG_CFG_O_OSC1_TRIM_REF_CALC_NUM            0x310    // OSC1 reference calibration calculation length.
#define CRG_CFG_O_OSC1_TRIM_OVER                    0x314    // OSC1 trim over.
#define CRG_CFG_O_OSC2_TRIM_OSC_EN                  0x320    // OSC2 calibration enable.
#define CRG_CFG_O_OSC2_TRIM_OSC_STEP_NUM            0x324    // OSC2 calibration step configuration.
#define CRG_CFG_O_OSC2_TRIM_OSC_CALC_NUM            0x328    // OSC2 calibration calculation length.
#define CRG_CFG_O_OSC2_TRIM_OSC_WAIT_NUM            0x32C    // OSC2 wait refresh time.
#define CRG_CFG_O_OSC2_TRIM_REF_CALC_NUM            0x330    // OSC2 reference calibration calculation length.
#define CRG_CFG_O_OSC2_TRIM_OVER                    0x334    // OSC2 trim over.
#define CRG_CFG_O_OSC_TRIM_VALUE_RPT                0x340    // OSC trim value report.

#define CRG_CFG_O_SRST_SYS                          0x400    // System soft reset configuration.
#define CRG_CFG_O_SRST_SLV_CORE_N                   0x404    // Slave core software reset configuration.
#define CRG_CFG_O_FORCE_AHB_ISO                     0x408    // Force slave AHB master takeover configuration.
#define CRG_CFG_O_ISO_OVF_CNT_TH                    0x40C    // Over takeover threshold configuration.
#define CRG_CFG_O_SLV_CORE_STOP_WITH_SLV            0x410    // Slave core stop with slave.
#define CRG_CFG_O_SLV_CORE_STOP_ON_SET              0x414    // Slave core stop on set.
#define CRG_CFG_O_SLV_CORE_STOP_ON_CLR              0x418    // Slave core stop on clear.
#define CRG_CFG_O_SLV_CORE_STOP_ON_RPT              0x41C    // Slave core stop on report.
#define CRG_CFG_O_SRST_EFLASH_CTRL_N                0x504    // eFlash control soft reset.
#define CRG_CFG_O_SRST_QSPI_N                       0x508    // QSPI soft reset.
#define CRG_CFG_O_SRST_DMA_N                        0x50C    // DMA soft reset.
#define CRG_CFG_O_SRST_STC_N                        0x510    // STC soft reset.
#define CRG_CFG_O_SRST_AES_N                        0x514    // AES soft reset.

#define CRG_CFG_O_EFLASH_CTRL_CLK_EN                0x600    // eFlash control clock enable configuration register.
#define CRG_CFG_O_QSPI_CLK_ICG_BYPASS               0x604    // QSPI clock automatic CG function bypass configuration.
#define CRG_CFG_O_DMA_CLK_ICG_BYPASS                0x608    // DMA clock automatic CG function bypass configuration.
#define CRG_CFG_O_DSP_CLK_ICG_BYPASS                0x60C    // DSP clock automatic CG function bypass configuration.
#define CRG_CFG_O_CFG_STANDBY                       0x614    // Enter low power mode configuration in standby.
#define CRG_CFG_O_CFG_WDG_WAKE_EN                   0x618    // Main core watchdog wake-up enable.
#define CRG_CFG_O_CFG_GPIO_WAKE_EN                  0x61C    // GPIO wake-up enable.
#define CRG_CFG_O_AES_CLK_EN                        0x620    // AES clock enable configuration register.
#define CRG_CFG_O_PARA_ICG_BYPASS                   0x6FC    // PARA_ICG bypass configuration.

#define CRG_CFG_O_TOP_CRG_SPARE0                    0xF00    // Reserved register.
#define CRG_CFG_O_TOP_CRG_SPARE1                    0xF04    // Reserved register.
#define CRG_CFG_O_TOP_CRG_SPARE2                    0xF08    // Reserved register.



#ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_CRG_CFGIGH_H_ */
