/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    hw_sysctl_dig_v22.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V22_H_
#define DEVICE_DRIVERLIB_HW_SYSCTL_DIG_V22_H_

#include "gs32_version.h"

#if IS_GS32F3xx(0x22)

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */
// The following are defines for the sysctl_dig register offsets

// Lock control register.
#define SYSCTL_O_SYSCTRL_LOCK                 0x0000U

// Memory control signals (0x200~0x2FF)
#define SYSCTL_O_CCM_MEM_CTRL                 0x200      // RAM parameter configuration register.
#define SYSCTL_O_CCM_MEM_PWR_CTRL             0x204      // RAM low-power configuration register.
#define SYSCTL_O_FLASH_MEM_CTRL               0x208      // RAM parameter configuration register.
#define SYSCTL_O_FLASH_MEM_PWR_CTRL           0x20C      // RAM low-power configuration register.
#define SYSCTL_O_GS_MEM_CTRL                  0x210      // RAM parameter configuration register.
#define SYSCTL_O_GS_MEM_PWR_CTRL              0x214      // RAM low-power configuration register.
#define SYSCTL_O_MSG_MEM_CTRL                 0x218      // RAM parameter configuration register.
#define SYSCTL_O_MSG_MEM_PWR_CTRL             0x21C      // RAM low-power configuration register.
#define SYSCTL_O_DSP_CORE_MEM_CTRL            0x220      // RAM parameter configuration register.
#define SYSCTL_O_DSP_CORE_MEM_PWR_CTRL        0x224      // RAM low-power configuration register.
#define SYSCTL_O_DSP_SYS_MEM_CTRL             0x228      // RAM parameter configuration register.
#define SYSCTL_O_DSP_SYS_MEM_PWR_CTRL         0x22C      // RAM low-power configuration register.

// Error check report (0x300~0x3FF)
#define SYSCTL_O_CCM_ECC_ERR_RPT              0x300      // ECC error report.
#define SYSCTL_O_SRAM0_PARITY_RPT             0x304      // SRAM0 odd parity error report.
#define SYSCTL_O_SRAM1_PARITY_RPT             0x308      // SRAM1 odd parity error report.
#define SYSCTL_O_FLEX_PARITY_RPT              0x30C      // FLEX odd parity error report.
#define SYSCTL_O_GS_PARITY_RPT                0x310      // GS RAM odd parity error report.
#define SYSCTL_O_MSG0_PARITY_RPT              0x314      // DSP LM odd parity error report.
#define SYSCTL_O_MSG1_PARITY_RPT              0x318      // DSP LM odd parity error report.
#define SYSCTL_O_FLASH_ICACHE_ECC_ERR_RPT     0x31C      // ECC error report.
#define SYSCTL_O_PVM_INT_RPT                  0x320      // PVM report.

// GS RAM configuration (0x400~0x4FF)
#define SYSCTL_O_GS_SRAM_SMP_MODE             0x400      // GS RAM sampling mode configuration register.

// BOOT CTRL (0x400~0x4FF)
#define SYSCTL_O_BOOT_PIN_LATCH_MSK           0x500      // Boot pin latch affected by system reset or not.
#define SYSCTL_O_BOOT_PIN_LATCH_RPT           0x504      // Boot pin latch value.
#define SYSCTL_O_DSP_CPU2_RESET_VECTOR        0x50C      // DSP reset vector report.
#define SYSCTL_O_DSP_CPU1_RESET_VECTOR_RPT    0x514      // CPU1 reset vector report.
#define SYSCTL_O_DSP_CPU2_RESET_VECTOR_RPT    0x518      // CPU2 reset vector report.

// System control (0x600~0x6FF)
#define SYSCTL_O_DSP_STAT_REG                 0x608      // DSP core status report register.
#define SYSCTL_O_DSP_HALT_RPT                 0x610      // DSP halt report.
#define SYSCTL_O_SLV_CORE_JTAG_CFG            0x618      // Slave core JTAG configuration register.
#define SYSCTL_O_EFC_BIST_ENABLE              0x620      // BIST enable.
#define SYSCTL_O_TAP_EN_CFG                   0x624      // TAP_EN_CFG configuration.
#define SYSCTL_O_BUS_AUSER_ID_CFG             0x628      // BUS_USER_ID configuration.
#define SYSCTL_O_SEMA_BUS_AUSER_ID_CFG        0x62C      // SEMA_USER_ID configuration.
#define SYSCTL_O_DSP_SYS_ERR_MASK             0x650      // System error interrupt mask.
#define SYSCTL_O_PWM_ECCERR_MASK              0x658      // PWM ECC error mask.
#define SYSCTL_O_PWM_SYSFAULT_MASK            0x65C      // PWM system fault mask.
#define SYSCTL_O_ERRORTS_MASK                 0x660      // ERRORTS mask indicator.
#define SYSCTL_O_AXI_CLUSTER_QOS_CFG          0x664      // Cluster configuration.
#define SYSCTL_O_AXI_DMA0_QOS_CFG             0x668      // DMA0 configuration.
#define SYSCTL_O_AXI_DMA1_QOS_CFG             0x66C      // DMA1 configuration.
#define SYSCTL_O_AXI_SRAM_CACHEABLE           0x670      // AXI SRAM cacheable configuration.

// MEM initialization (0x700~0x7FF)
#define SYSCTL_O_MEM_INI_REQ                  0x700      // MEM_INI_REQ configuration.
#define SYSCTL_O_MEM_INI_DONE_RPT             0x704      // Initialization complete report.

// Others
#define SYSCTL_O_PMBUS_CTL_OEN                0x708      // PMBUS_CTL_OEN.
#define SYSCTL_O_SDFM_TYPE_CFG                0x70C      // SDFM_TYPE_CFG.
#define SYSCTL_O_TSENSOR_RPT                  0x718      // Temperature sensor report.
#define SYSCTL_O_FSMC_CFG                     0x71C      // FSMC configuration.

// Reserved registers (0xF00~0xFFF) (POR)
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE0        0xF00      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE1        0xF04      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_POR_SPARE2        0xF08      // Reserved register.

// Reserved registers (0xF00~0xFFF) (SYS)
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE0        0xF10      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE1        0xF14      // Reserved register.
#define SYSCTL_O_DIG_SYSCTL_SYS_SPARE2        0xF18      // Reserved register.



 #ifdef __cplusplus
}
#endif

#endif

#endif /* DEVICE_DRIVERLIB_HW_SYSCTL_DIG_H_ */
