//###########################################################################
//
// FILE:    hw_xbar.h
//
// TITLE:   Definitions for the XBAR registers.
//
//###########################################################################

#ifndef HW_XBAR_H
#define HW_XBAR_H

#include "gs32_version.h"

//*************************************************************************************************
//
// The following are defines for the XBAR register offsets
//
//*************************************************************************************************
#if IS_GS32F00xx(0x12)
#define XBAR_O_FLG1   0x00
#define XBAR_O_FLG2   0x04
#define XBAR_O_FLG3   0x08
#define XBAR_O_FLG4   0x0C
#define XBAR_O_FLG5   0x20
#define XBAR_O_FLG6   0x24
#define XBAR_O_CLR1   0x10
#define XBAR_O_CLR2   0x14
#define XBAR_O_CLR3   0x18
#define XBAR_O_CLR4   0x1C
#define XBAR_O_CLR5   0x28
#define XBAR_O_CLR6   0x2C
#elif IS_GS32F3xx(0x22)
#define XBAR_O_FLG1   0x0
#define XBAR_O_FLG2   0x4
#define XBAR_O_FLG3   0x8
#define XBAR_O_FLG4   0xC
#define XBAR_O_FLG11  0x28
#define XBAR_O_FLG12  0x2C
#define XBAR_O_FLG13  0x30
#define XBAR_O_FLG14  0x34
#define XBAR_O_FLG15  0x38
#define XBAR_O_FLG16  0x3C
#define XBAR_O_CLR1   0x10
#define XBAR_O_CLR2   0x14
#define XBAR_O_CLR3   0x18
#define XBAR_O_CLR4   0x1C
#define XBAR_O_CLR11  0x68
#define XBAR_O_CLR12  0x6C
#define XBAR_O_CLR13  0x70
#define XBAR_O_CLR14  0x74
#define XBAR_O_CLR15  0x78
#define XBAR_O_CLR16  0x7C
#elif IS_GS32F00xx(0x30)
#define XBAR_O_FLG1   0x0    
#define XBAR_O_FLG2   0x4    
#define XBAR_O_FLG3   0x8    
#define XBAR_O_FLG4   0xC    
#define XBAR_O_FLG5   0x40   
#define XBAR_O_FLG6   0x44   
#define XBAR_O_FLG7   0x48   
#define XBAR_O_FLG8   0x4C   
#define XBAR_O_FLG9   0x20   
#define XBAR_O_FLG10  0x24   
#define XBAR_O_FLG11  0x28   
#define XBAR_O_FLG12  0x2C   
#define XBAR_O_FLG13  0x30   
#define XBAR_O_FLG14  0x34   
#define XBAR_O_FLG15  0x38   
#define XBAR_O_FLG16  0x3C   
#define XBAR_O_CLR1   0x10   
#define XBAR_O_CLR2   0x14   
#define XBAR_O_CLR3   0x18   
#define XBAR_O_CLR4   0x1C   
#define XBAR_O_CLR5   0x50   
#define XBAR_O_CLR6   0x54   
#define XBAR_O_CLR7   0x58   
#define XBAR_O_CLR8   0x5C   
#define XBAR_O_CLR9   0x60   
#define XBAR_O_CLR10  0x64   
#define XBAR_O_CLR11  0x68   
#define XBAR_O_CLR12  0x6C   
#define XBAR_O_CLR13  0x70   
#define XBAR_O_CLR14  0x74   
#define XBAR_O_CLR15  0x78   
#define XBAR_O_CLR16  0x7C   


#endif


//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARFLG1 register
//
//*************************************************************************************************
#define XBAR_FLG1_CMPSS1_CTRIPL       0x1U                
#define XBAR_FLG1_CMPSS1_CTRIPH       0x2U                
#define XBAR_FLG1_CMPSS2_CTRIPL       0x4U                
#define XBAR_FLG1_CMPSS2_CTRIPH       0x8U                
#define XBAR_FLG1_CMPSS3_CTRIPL       0x10U               
#define XBAR_FLG1_CMPSS3_CTRIPH       0x20U               
#define XBAR_FLG1_CMPSS4_CTRIPL       0x40U               
#define XBAR_FLG1_CMPSS4_CTRIPH       0x80U               
#define XBAR_FLG1_CMPSS5_CTRIPL       0x100U              
#define XBAR_FLG1_CMPSS5_CTRIPH       0x200U              
#define XBAR_FLG1_CMPSS6_CTRIPL       0x400U              
#define XBAR_FLG1_CMPSS6_CTRIPH       0x800U              
#define XBAR_FLG1_CMPSS7_CTRIPL       0x1000U             
#define XBAR_FLG1_CMPSS7_CTRIPH       0x2000U             
#define XBAR_FLG1_CMPSS1_CTRIPOUTL    0x10000U            
#define XBAR_FLG1_CMPSS1_CTRIPOUTH    0x20000U            
#define XBAR_FLG1_CMPSS2_CTRIPOUTL    0x40000U            
#define XBAR_FLG1_CMPSS2_CTRIPOUTH    0x80000U            
#define XBAR_FLG1_CMPSS3_CTRIPOUTL    0x100000U           
#define XBAR_FLG1_CMPSS3_CTRIPOUTH    0x200000U           
#define XBAR_FLG1_CMPSS4_CTRIPOUTL    0x400000U           
#define XBAR_FLG1_CMPSS4_CTRIPOUTH    0x800000U           
#define XBAR_FLG1_CMPSS5_CTRIPOUTL    0x1000000U          
#define XBAR_FLG1_CMPSS5_CTRIPOUTH    0x2000000U          
#define XBAR_FLG1_CMPSS6_CTRIPOUTL    0x4000000U          
#define XBAR_FLG1_CMPSS6_CTRIPOUTH    0x8000000U          
#define XBAR_FLG1_CMPSS7_CTRIPOUTL    0x10000000U         
#define XBAR_FLG1_CMPSS7_CTRIPOUTH    0x20000000U 

#if IS_GS32F3xx()

#define XBAR_FLG1_CMPSS8_CTRIPL       0x4000U             
#define XBAR_FLG1_CMPSS8_CTRIPH       0x8000U

#define XBAR_FLG1_CMPSS8_CTRIPOUTL    0x40000000U         
#define XBAR_FLG1_CMPSS8_CTRIPOUTH    0x80000000U  

#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARFLG2 register
//
//*************************************************************************************************
#define XBAR_FLG2_INPUT1              0x1U                
#define XBAR_FLG2_INPUT2              0x2U                
#define XBAR_FLG2_INPUT3              0x4U                
#define XBAR_FLG2_INPUT4              0x8U                
#define XBAR_FLG2_INPUT5              0x10U               
#define XBAR_FLG2_INPUT6              0x20U               
#define XBAR_FLG2_ADCSOCA             0x40U               
#define XBAR_FLG2_ADCSOCB             0x80U               
#define XBAR_FLG2_INPUT7              0x100U              
#define XBAR_FLG2_INPUT8              0x200U              
#define XBAR_FLG2_INPUT9              0x400U              
#define XBAR_FLG2_INPUT10             0x800U              
#define XBAR_FLG2_INPUT11             0x1000U             
#define XBAR_FLG2_INPUT12             0x2000U             
#define XBAR_FLG2_INPUT13             0x4000U             
#define XBAR_FLG2_INPUT14             0x8000U             
#define XBAR_FLG2_ECAP1_OUT           0x10000U            
#define XBAR_FLG2_ECAP2_OUT           0x20000U            
#define XBAR_FLG2_ECAP3_OUT           0x40000U            
#define XBAR_FLG2_ECAP4_OUT           0x80000U            
#define XBAR_FLG2_ECAP5_OUT           0x100000U           
#define XBAR_FLG2_ECAP6_OUT           0x200000U           
#define XBAR_FLG2_EXTSYNCOUT          0x400000U           
#define XBAR_FLG2_ADCAEVT1            0x800000U           
#define XBAR_FLG2_ADCAEVT2            0x1000000U          
#define XBAR_FLG2_ADCAEVT3            0x2000000U          
#define XBAR_FLG2_ADCAEVT4            0x4000000U          
#define XBAR_FLG2_ADCBEVT1            0x8000000U          
#define XBAR_FLG2_ADCBEVT2            0x10000000U         
#define XBAR_FLG2_ADCBEVT3            0x20000000U         
#define XBAR_FLG2_ADCBEVT4            0x40000000U         
#define XBAR_FLG2_ADCCEVT1            0x80000000U

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARFLG3 register
//
//*************************************************************************************************
#define XBAR_FLG3_ADCCEVT2            0x1U                
#define XBAR_FLG3_ADCCEVT3            0x2U                
#define XBAR_FLG3_ADCCEVT4            0x4U                            
#define XBAR_FLG3_ECAP7_OUT           0x800000U
#define XBAR_FLG3_SSI_INTR            0x40000000U
#define XBAR_FLG3_CPU_HALT            0x80000000U

#if IS_GS32F3xx()

#define XBAR_FLG3_ADCDEVT1            0x8U                
#define XBAR_FLG3_ADCDEVT2            0x10U               
#define XBAR_FLG3_ADCDEVT3            0x20U               
#define XBAR_FLG3_ADCDEVT4            0x40U

#define XBAR_FLG3_ENET0_PPS0_O        0x80000U            
#define XBAR_FLG3_ENET0_PPS1_O        0x100000U           
#define XBAR_FLG3_ENET1_PPS0_O        0x200000U           
#define XBAR_FLG3_ENET1_PPS1_O        0x400000U 

#define XBAR_FLG3_CAN2_HOST_IRQ       0x1000000U          
#define XBAR_FLG3_CAN2_HOST_IF        0x2000000U          
#define XBAR_FLG3_CAN3_HOST_IRQ       0x4000000U          
#define XBAR_FLG3_CAN3_HOST_IF        0x8000000U          
#define XBAR_FLG3_SPI2_INTR           0x10000000U         
#define XBAR_FLG3_SPI3_INTR           0x20000000U 

#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARFLG4 register
//
//*************************************************************************************************
#define XBAR_FLG4_CAN0_HOST_IRQ       0x1U                
#define XBAR_FLG4_CAN0_HOST_IF        0x2U                
#define XBAR_FLG4_CAN1_HOST_IRQ       0x4U                
#define XBAR_FLG4_CAN1_HOST_IF        0x8U                
#define XBAR_FLG4_INPUT15             0x10U               
#define XBAR_FLG4_INPUT16             0x20U               
#define XBAR_FLG4_SPI0_INTR           0x40U               
#define XBAR_FLG4_SPI1_INTR           0x80U               
#define XBAR_FLG4_PLU_LC1_OUT0         0x100U              
#define XBAR_FLG4_PLU_LC1_OUT1         0x200U              
#define XBAR_FLG4_PLU_LC1_OUT2         0x400U              
#define XBAR_FLG4_PLU_LC1_OUT3         0x800U              
#define XBAR_FLG4_PLU_LC2_OUT0         0x1000U             
#define XBAR_FLG4_PLU_LC2_OUT1         0x2000U             
#define XBAR_FLG4_PLU_LC2_OUT2         0x4000U             
#define XBAR_FLG4_PLU_LC2_OUT3         0x8000U             
#define XBAR_FLG4_PLU_LC3_OUT0         0x10000U            
#define XBAR_FLG4_PLU_LC3_OUT1         0x20000U            
#define XBAR_FLG4_PLU_LC3_OUT2         0x40000U            
#define XBAR_FLG4_PLU_LC3_OUT3         0x80000U            
#define XBAR_FLG4_I2C0_INTR           0x100000U           
#define XBAR_FLG4_I2C1_INTR           0x200000U           
#define XBAR_FLG4_I2C2_INTR           0x400000U           
#define XBAR_FLG4_SCIA_INTR          0x800000U           
#define XBAR_FLG4_SCIB_INTR          0x1000000U          
#define XBAR_FLG4_SCIC_INTR          0x2000000U          
#define XBAR_FLG4_SCID_INTR          0x4000000U

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARCLR1 register
//
//*************************************************************************************************
#define XBAR_CLR1_CMPSS1_CTRIPL       0x1U                
#define XBAR_CLR1_CMPSS1_CTRIPH       0x2U                
#define XBAR_CLR1_CMPSS2_CTRIPL       0x4U                
#define XBAR_CLR1_CMPSS2_CTRIPH       0x8U                
#define XBAR_CLR1_CMPSS3_CTRIPL       0x10U               
#define XBAR_CLR1_CMPSS3_CTRIPH       0x20U               
#define XBAR_CLR1_CMPSS4_CTRIPL       0x40U               
#define XBAR_CLR1_CMPSS4_CTRIPH       0x80U               
#define XBAR_CLR1_CMPSS5_CTRIPL       0x100U              
#define XBAR_CLR1_CMPSS5_CTRIPH       0x200U              
#define XBAR_CLR1_CMPSS6_CTRIPL       0x400U              
#define XBAR_CLR1_CMPSS6_CTRIPH       0x800U              
#define XBAR_CLR1_CMPSS7_CTRIPL       0x1000U             
#define XBAR_CLR1_CMPSS7_CTRIPH       0x2000U             
#define XBAR_CLR1_CMPSS1_CTRIPOUTL    0x10000U            
#define XBAR_CLR1_CMPSS1_CTRIPOUTH    0x20000U            
#define XBAR_CLR1_CMPSS2_CTRIPOUTL    0x40000U            
#define XBAR_CLR1_CMPSS2_CTRIPOUTH    0x80000U            
#define XBAR_CLR1_CMPSS3_CTRIPOUTL    0x100000U           
#define XBAR_CLR1_CMPSS3_CTRIPOUTH    0x200000U           
#define XBAR_CLR1_CMPSS4_CTRIPOUTL    0x400000U           
#define XBAR_CLR1_CMPSS4_CTRIPOUTH    0x800000U           
#define XBAR_CLR1_CMPSS5_CTRIPOUTL    0x1000000U          
#define XBAR_CLR1_CMPSS5_CTRIPOUTH    0x2000000U          
#define XBAR_CLR1_CMPSS6_CTRIPOUTL    0x4000000U          
#define XBAR_CLR1_CMPSS6_CTRIPOUTH    0x8000000U          
#define XBAR_CLR1_CMPSS7_CTRIPOUTL    0x10000000U         
#define XBAR_CLR1_CMPSS7_CTRIPOUTH    0x20000000U

#if IS_GS32F3xx()

#define XBAR_CLR1_CMPSS8_CTRIPL       0x4000U             
#define XBAR_CLR1_CMPSS8_CTRIPH       0x8000U

#define XBAR_CLR1_CMPSS8_CTRIPOUTL    0x40000000U         
#define XBAR_CLR1_CMPSS8_CTRIPOUTH    0x80000000U 

#endif
//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARCLR2 register
//
//*************************************************************************************************
#define XBAR_CLR2_INPUT1              0x1U                
#define XBAR_CLR2_INPUT2              0x2U                
#define XBAR_CLR2_INPUT3              0x4U                
#define XBAR_CLR2_INPUT4              0x8U                
#define XBAR_CLR2_INPUT5              0x10U               
#define XBAR_CLR2_INPUT6              0x20U               
#define XBAR_CLR2_ADCSOCA             0x40U               
#define XBAR_CLR2_ADCSOCB             0x80U               
#define XBAR_CLR2_INPUT7              0x100U              
#define XBAR_CLR2_INPUT8              0x200U              
#define XBAR_CLR2_INPUT9              0x400U              
#define XBAR_CLR2_INPUT10             0x800U              
#define XBAR_CLR2_INPUT11             0x1000U             
#define XBAR_CLR2_INPUT12             0x2000U             
#define XBAR_CLR2_INPUT13             0x4000U             
#define XBAR_CLR2_INPUT14             0x8000U             
#define XBAR_CLR2_ECAP1_OUT           0x10000U            
#define XBAR_CLR2_ECAP2_OUT           0x20000U            
#define XBAR_CLR2_ECAP3_OUT           0x40000U            
#define XBAR_CLR2_ECAP4_OUT           0x80000U            
#define XBAR_CLR2_ECAP5_OUT           0x100000U           
#define XBAR_CLR2_ECAP6_OUT           0x200000U           
#define XBAR_CLR2_EXTSYNCOUT          0x400000U           
#define XBAR_CLR2_ADCAEVT1            0x800000U           
#define XBAR_CLR2_ADCAEVT2            0x1000000U          
#define XBAR_CLR2_ADCAEVT3            0x2000000U          
#define XBAR_CLR2_ADCAEVT4            0x4000000U          
#define XBAR_CLR2_ADCBEVT1            0x8000000U          
#define XBAR_CLR2_ADCBEVT2            0x10000000U         
#define XBAR_CLR2_ADCBEVT3            0x20000000U         
#define XBAR_CLR2_ADCBEVT4            0x40000000U         
#define XBAR_CLR2_ADCCEVT1            0x80000000U

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARCLR3 register
//
//*************************************************************************************************
#define XBAR_CLR3_ADCCEVT2            0x1U                
#define XBAR_CLR3_ADCCEVT3            0x2U                
#define XBAR_CLR3_ADCCEVT4            0x4U                           
#define XBAR_CLR3_ECAP7_OUT           0x800000U
#define XBAR_CLR3_SSI_INTR            0x40000000U
#define XBAR_CLR3_CPU_HALT            0x80000000U     

#if IS_GS32F3xx()

#define XBAR_CLR3_ADCDEVT1            0x8U                
#define XBAR_CLR3_ADCDEVT2            0x10U               
#define XBAR_CLR3_ADCDEVT3            0x20U               
#define XBAR_CLR3_ADCDEVT4            0x40U

#define XBAR_CLR3_ENET0_PPS0_O        0x80000U            
#define XBAR_CLR3_ENET0_PPS1_O        0x100000U           
#define XBAR_CLR3_ENET1_PPS0_O        0x200000U           
#define XBAR_CLR3_ENET1_PPS1_O        0x400000U 

#define XBAR_CLR3_CAN2_HOST_IRQ       0x1000000U          
#define XBAR_CLR3_CAN2_HOST_IF        0x2000000U          
#define XBAR_CLR3_CAN3_HOST_IRQ       0x4000000U          
#define XBAR_CLR3_CAN3_HOST_IF        0x8000000U          
#define XBAR_CLR3_SPI2_INTR           0x10000000U         
#define XBAR_CLR3_SPI3_INTR           0x20000000U 

#endif

//*************************************************************************************************
//
// The following are defines for the bit fields in the XBARCLR4 register
//
//*************************************************************************************************
#define XBAR_CLR4_CAN0_HOST_IRQ       0x1U                
#define XBAR_CLR4_CAN0_HOST_IF        0x2U                
#define XBAR_CLR4_CAN1_HOST_IRQ       0x4U                
#define XBAR_CLR4_CAN1_HOST_IF        0x8U                
#define XBAR_CLR4_INPUT15             0x10U               
#define XBAR_CLR4_INPUT16             0x20U               
#define XBAR_CLR4_SPI0_INTR           0x40U               
#define XBAR_CLR4_SPI1_INTR           0x80U               
#define XBAR_CLR4_PLU_LC1_OUT0         0x100U              
#define XBAR_CLR4_PLU_LC1_OUT1         0x200U              
#define XBAR_CLR4_PLU_LC1_OUT2         0x400U              
#define XBAR_CLR4_PLU_LC1_OUT3         0x800U              
#define XBAR_CLR4_PLU_LC2_OUT0         0x1000U             
#define XBAR_CLR4_PLU_LC2_OUT1         0x2000U             
#define XBAR_CLR4_PLU_LC2_OUT2         0x4000U             
#define XBAR_CLR4_PLU_LC2_OUT3         0x8000U             
#define XBAR_CLR4_PLU_LC3_OUT0         0x10000U            
#define XBAR_CLR4_PLU_LC3_OUT1         0x20000U            
#define XBAR_CLR4_PLU_LC3_OUT2         0x40000U            
#define XBAR_CLR4_PLU_LC3_OUT3         0x80000U           
#define XBAR_CLR4_I2CA_INTR           0x100000U           
#define XBAR_CLR4_I2CB_INTR           0x200000U           
#define XBAR_CLR4_I2CD_INTR           0x400000U           
#define XBAR_CLR4_SCIA_INTR          0x800000U           
#define XBAR_CLR4_SCIB_INTR          0x1000000U          
#define XBAR_CLR4_SCIC_INTR          0x2000000U          
#define XBAR_CLR4_SCID_INTR          0x4000000U



#endif


