/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
*   @file    hw_xdma.h
*   @brief   DMA registers definitions
*
*/
/*
 * commit history
 * 20240308, LYF, verify for chip 2.0 and provide IP version.
 */


#ifndef DEVICE_DRIVERLIB_HW_XDMA_H_
#define DEVICE_DRIVERLIB_HW_XDMA_H_

#ifdef __cplusplus
extern "C"{
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"
#include "hw_memmap.h"
#include "hw_xdma.h"
#include "gs32_version.h"


/* ========================================================================== */
/*                          Version defs                                      */
/* ========================================================================== */

//*****************************************************************************
//
//! The following are defines for the AXI DMAC VERSION.
//
//*****************************************************************************


#ifdef XDMAC_VERSION
#undef XDMAC_VERSION
#endif 

#if IS_GS32F3xx(0x22, 0x23)
#define XDMAC_VERSION            (0x22)
#else
#define XDMAC_VERSION            (0xFF)  // Not support.
#endif

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

#define XDMA_O_XCOMID                       0x00
#define XDMA_O_XVER                         0x08
#define XDMA_O_XCOMCFG                      0x10
#define XDMA_O_XCHNEN                       0x18
#define XDMA_O_XCHNINTS                     0x30
#define XDMA_0_XCLRCOMINTS                  0x38
#define XDMA_O_XENCOMINTS                   0x40
#define XDMA_O_XENCOMINTSIGL                0x48
#define XDMA_O_XCOMINTS                     0x50
#define XDMA_O_XRESET                       0x58
#define XDMA_O_XCFGLOWP                     0x60
#define XDMA_O_XCOMPAR                      0x70
#define XDMA_O_XCOMECC                      0x78
#define XDMA_O_XCOMERRINJSFTY               0x80

#define XDMA_O_XSAR                         0x00
#define XDMA_O_XDAR                         0x08
#define XDMA_O_XBLOCK                       0x10
#define XDMA_O_XCTL                         0x18
#define XDMA_O_XCFG                         0x20
#define XDMA_O_XLLP                         0x28
#define XDMA_O_XSTATUS                      0x30
#define XDMA_O_XSWHSSRC                     0x38
#define XDMA_O_XSWHSDST                     0x40
#define XDMA_O_XBTFRREQ                     0x48
#define XDMA_O_XID                          0x50
#define XDMA_O_XQOS                         0x58
#define XDMA_O_XSSTAT                       0x60
#define XDMA_O_XDSTAT                       0x68
#define XDMA_O_XSSTATAR                     0x70
#define XDMA_O_XDSTATAR                     0x78
#define XDMA_O_XENINTS                      0x80
#define XDMA_O_XINTS                        0x88
#define XDMA_O_XENINTSIGL                   0x90
#define XDMA_O_XCLRINTS                     0x98
#define XDMA_O_XCFGEXTD                     0xA0
#define XDMA_CTL_L_M						0x3FFF50
#define XDNA_CFG_H_M						0xEF79F
#define XDNA_CFG_L_M						0xF
//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_IDREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_DMAC_IDREG_S                           (0U)
#define XDMA_DMAC_IDREG_M                           ((0xFFFFFFFF) << XDMA_DMAC_IDREG_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_COMPVERREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_DMAC_COMPVER_S                         (0U)
#define XDMA_DMAC_COMPVER_M                         ((0xFFFFFFFF) << XDMA_DMAC_COMPVER_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_CFGREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_INT_EN                                 BIT(1)
#define XDMA_DMAC_EN                                BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_CHENREG registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_CHX_ABORT_WE_S                         (8U)
#define XDMA_CHX_ABORT_WE_M                         ((0xFF) << XDMA_CHX_ABORT_WE_S)
#define XDMA_CHX_ABORT_S                            (0U)
#define XDMA_CHX_ABORT_M                            ((0xFF) << XDMA_CHX_ABORT_S)
// Low 32 bits
#define XDMA_CHX_SUSP_WE_S                          (24U)
#define XDMA_CHX_SUSP_WE_M                          ((0xFF) << XDMA_CHX_SUSP_WE_S)
#define XDMA_CHX_SUSP_S                             (16U)
#define XDMA_CHX_SUSP_M                             ((0xFF) << XDMA_CHX_SUSP_S)
#define XDMA_CHX_EN_WE_S                            (8U)
#define XDMA_CHX_EN_WE_M                            ((0xFF) << XDMA_CHX_EN_WE_S)
#define XDMA_CHX_EN_S                               (0U)
#define XDMA_CHX_EN_M                               ((0xFF) << XDMA_CHX_EN_S)
//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_INTSTATUSREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_CommonReg_FLG                          BIT(16)
#define XDMA_CHX_FLG_S                              (0U)
#define XDMA_CHX_FLG_M                              ((0xF) << XDMA_CHX_FLG_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the below registers
//  DMAC_COMMONREG_INTCLEARREG                  (WRITE ONLY)
//  DMAC_COMMONREG_INTSTATUS_ENABLEREG          (R/W or READ ONLY by VVaries)
//  DMAC_COMMONREG_INTSIGNAL_ENABLEREG          (R/W or READ ONLY by VVaries)
//  DMAC_COMMONREG_INTSTATUSREG                 (READ ONLY) 
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_MXIF2_BCH_PROT_BVALID_ParErr           BIT(30)
#define XDMA_MXIF2_RCH_PROT_RVALID_ParErr           BIT(29)
#define XDMA_MXIF2_WCH_PROT_WREADY_ParErr           BIT(28)
#define XDMA_MXIF2_AWCH_PROT_AWREADY_ParErr         BIT(27)
#define XDMA_MXIF2_ARCH_PROT_ARREADY_ParErr         BIT(26)
#define XDMA_MXIF1_BCH_PROT_BVALID_ParErr           BIT(25)
#define XDMA_MXIF1_RCH_PROT_RVALID_ParErr           BIT(24)
#define XDMA_MXIF1_WCH_PROT_WREADY_ParErr           BIT(23)
#define XDMA_MXIF1_AWCH_PROT_AWREADY_ParErr         BIT(22)
#define XDMA_MXIF1_ARCH_PROT_ARREADY_ParErr         BIT(21)
#define XDMA_MXIF2_BCH_PROT_UnCorrERR               BIT(20)
#define XDMA_MXIF2_BCH_PROT_CorrERR                 BIT(19)
#define XDMA_MXIF2_RCH1_PROT_UnCorrERR              BIT(18)
#define XDMA_MXIF2_RCH1_PROT_CorrERR                BIT(17)
#define XDMA_MXIF2_RCH0_PROT_UnCorrERR              BIT(16)
#define XDMA_MXIF2_RCH0_PROT_CorrERR                BIT(15)
#define XDMA_MXIF1_BCH_PROT_UnCorrERR               BIT(14)
#define XDMA_MXIF1_BCH_PROT_CorrERR                 BIT(13)
#define XDMA_MXIF1_RCH1_PROT_UnCorrERR              BIT(12)
#define XDMA_MXIF1_RCH1_PROT_CorrERR                BIT(11)
#define XDMA_MXIF1_RCH0_PROT_UnCorrERR              BIT(10)
#define XDMA_MXIF1_RCH0_PROT_CorrERR                BIT(9)
#define XDMA_SLVIF_UndefinedReg_DEC_ERR             BIT(8)
#define XDMA_SLVIF_CommonReg_WRPARITY_ERR           BIT(7)
#define XDMA_SLVIF_CommonReg_ADDRPARITY_ERR         BIT(6)
#define XDMA_SLVIF_CommonReg_WrOnHold_ERR           BIT(3)
#define XDMA_SLVIF_CommonReg_RD2WO_ERR              BIT(2)
#define XDMA_SLVIF_CommonReg_WR2RO_ERR              BIT(1)
#define XDMA_SLVIF_CommonReg_DEC_ERR                BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_RESETREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_DMAC_RST                               BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_LOWPOWER_CFGREG registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_MXIF_LPDLY_S                           (16U)
#define XDMA_MXIF_LPDLY_M                           ((0xFF) << XDMA_MXIF_LPDLY_S)
#define XDMA_SBIU_LPDLY_S                           (8U)
#define XDMA_SBIU_LPDLY_M                           ((0xFF) << XDMA_SBIU_LPDLY_S)
#define XDMA_GLCH_LPDLY_S                           (0U)
#define XDMA_GLCH_LPDLY_M                           ((0xFF) << XDMA_GLCH_LPDLY_S)
// Low 32 bits
#define XDMA_MXIF_CSLP_EN                           BIT(3)
#define XDMA_SBIU_CSLP_EN                           BIT(2)
#define XDMA_CHNL_CSLP_EN                           BIT(1)
#define XMDA_GBL_CSLP_EN                            BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_COMMON_PARCTLREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_PARITY_MODE                            BIT(1)
#define XDMA_PARITY_EN                              BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_COMMON_ECCCTLSTATUSREG registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_ECC_UNCORR_ERR_COUNT_S                 (0U)
#define XDMA_ECC_UNCORR_ERR_COUNT_M                 ((0x3FF) << XDMA_ECC_UNCORR_ERR_COUNT_S)
// Low 32 bits
#define XDMA_ECC_CORR_ERR_COUNT_S                   (16U)
#define XDMA_ECC_CORR_ERR_COUNT_M                   ((0x3FF) << XDMA_ECC_CORR_ERR_COUNT_S)
#define XDMA_ECC_INTFC_NO_S                         (7U)
#define XDMA_ECC_INTFC_NO_M                         ((0x1F) << XDMA_ECC_INTFC_NO_S)
#define XDMA_ECC_INTFC_TYPE_S                       (5U)
#define XDMA_ECC_INTFC_TYPE_M                       ((0x3) << XDMA_ECC_INTFC_TYPE_S)
#define XDMA_ECC_ERR_COUNT_RST                      BIT(4)

//*************************************************************************************************
//
// The following are defines for the bit fields in the DMAC_SFTY_ERR_INJ_CTRL registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_SFTY_BIT_SEL_S                         (14U)
#define XDMA_SFTY_BIT_SEL_M                         ((0x1FF) << XDMA_SFTY_BIT_SEL_S)
#define XDMA_ECC_EI_POINTS_S                        (11u)
#define XDMA_ECC_EI_POINTS_M                        ((0x7) << XDMA_ECC_EI_POINTS_S)
#define XDMA_ECC_EI_TYPE                            BIT(10)
#define XDMA_SFTY_EI_CH_S                           (5U)
#define XDMA_SFTY_EI_CH_M                           ((0x7) << XDMA_SFTY_EI_CH_S)
#define XDMA_SFTY_EI_FEATURE_S                      (1U)
#define XDMA_SFTY_EI_FEATURE_M                      ((0xF) << XDMA_SFTY_EI_FEATURE_S)
#define XDMA_SFTY_EI_EN                             BIT(0)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_SAR registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_SAR_H_S                                (0U)
#define XDMA_SAR_H_M                                ((0xFFFFFFFF) << XDMA_SAR_H_S)
// Low 32 bits
#define XDMA_SAR_L_S                                (0U)
#define XDMA_SAR_L_M                                ((0xFFFFFFFF) << XDMA_SAR_L_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_DAR registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_DAR_H_S                                (0U)
#define XDMA_DAR_H_M                                ((0xFFFFFFFF) << XDMA_DAR_H_S)
// Low 32 bits
#define XDMA_DAR_L_S                                (0U)
#define XDMA_DAR_L_M                                ((0xFFFFFFFF) << XDMA_DAR_L_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_BLOCK_TS registers
//
//*************************************************************************************************
#define XDMA_BLOCK_TS_BLOCK_TS_S                    (0U)
#define XDMA_BLOCK_TS_BLOCK_TS_M                    ((0x3FFFFFF) << XDMA_BLOCK_TS_BLOCK_TS_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_CTL registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_SHADOWREG_OR_LLI_VALID                 BIT(31)
#define XDMA_SHADOWREG_OR_LLI_LAST                  BIT(30)
#define XDMA_IOC_BlkTfr                             BIT(26)
#define XDMA_DST_STAT_EN                            BIT(25)
#define XDMA_SRC_STAT_EN                            BIT(24)
#define XDMA_AWLEN_S                                (16U)
#define XDMA_AWLEN_M                                ((0xFF) << XDMA_AWLEN_S)
#define XDMA_AWLEN_EN                               BIT(15)
#define XDMA_ARLEN_S                                (7U)
#define XDMA_ARLEN_M                                ((0xFF) << XDMA_ARLEN_S)
#define XDMA_ARLEN_EN                               BIT(6)
#define XDMA_AW_PPOT_S                              (3U)
#define XDMA_AW_PPOT_M                              ((0x3) << XDMA_AW_PPOT_S)
#define XDMA_AR_PPOT_S                              (0U)
#define XDMA_AR_PPOT_M                              ((0x3) << XDMA_AR_PPOT_S)
// Low 32 bits
#define XDMA_NonPosted_LastWrite_En                 BIT(30)
#define XDMA_AW_CACHE_S                             (26U)
#define XDMA_AW_CACHE_M                             ((0xF) << XDMA_AW_CACHE_S)
#define XDMA_AR_CACHE_S                             (22U)
#define XDMA_AR_CACHE_M                             ((0xF) << XDMA_AR_CACHE_S)
#define XDMA_DST_MSIZE_S                            (18U)
#define XDMA_DST_MSIZE_M                            ((0xF) << XDMA_DST_MSIZE_S)
#define XDMA_SRC_MSIZE_S                            (14U)
#define XDMA_SRC_MSIZE_M                            ((0xF) << XDMA_SRC_MSIZE_S)
#define XDMA_DST_TR_WIDTH_S                         (11U)
#define XDMA_DST_TR_WIDTH_M                         ((0x7) << XDMA_DST_TR_WIDTH_S)
#define XDMA_SRC_TR_WIDTH_S                         (8U)
#define XDMA_SRC_TR_WIDTH_M                         ((0x7) << XDMA_SRC_TR_WIDTH_S)
#define XDMA_DINC                                   BIT(6)
#define XDMA_DINC_S                                   (6U)
#define XDMA_SINC                                   BIT(4)
#define XDMA_SINC_S									(4U)
#define XDMA_DMS                                    BIT(2)
#define XDMA_SMS                                    BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_CTL registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_DST_OSR_LMT_S                          (27U)
#define XDMA_DST_OSR_LMT_M                          ((0xF) << XDMA_DST_OSR_LMT_S)
#define XDMA_SRC_OSR_LMT_S                          (23U)
#define XDMA_SRC_OSR_LMT_M                          ((0xF) << XDMA_SRC_OSR_LMT_S)
#define XDMA_LOCK_CH_LVL_S                          (21U)
#define XDMA_LOCK_CH_LVL_M                          ((0x3) << XDMA_LOCK_CH_LVL_S)
#define XDMA_LOCK_CH                                BIT(20)
#define XDMA_CH_PRIOR_S                             (17)
#define XDMA_CH_PRIOR_M                             ((0x3) << XDMA_CH_PRIOR_S)
#define XDMA_DST_PER_S                              (12)
#define XDMA_DST_PER_M                              ((0xF) << XDMA_DST_PER_S)
#define XDMA_SRC_PER_S                              (7)
#define XDMA_SRC_PER_M                              ((0xF) << XDMA_SRC_PER_S)
#define XDMA_DST_HWHS_POL                           BIT(6)
#define XDMA_SRC_HWHS_POL                           BIT(5)
#define XDMA_HS_SEL_DST                             BIT(4)
#define XDMA_HS_SEL_DST_S							(4U)
#define XDMA_HS_SEL_SRC                             BIT(3)
#define XDMA_HS_SEL_SRC_S                          	(3U)
#define XDMA_TT_FC_S                                (0U)
#define XDMA_TT_FC_M                                ((0x7) << XDMA_TT_FC_S)
// low 32 bits
#define XDMA_WR_UID_S                               (25U)
#define XDMA_WR_UID_M                               ((0xF) << XDMA_WR_UID_S)
#define XDMA_RD_UID_S                               (18U)
#define XDMA_RD_UID_M                               ((0xF) << XDMA_RD_UID_S)
#define XDMA_DST_MULTBLK_TYPE_S                     (2U)
#define XDMA_DST_MULTBLK_TYPE_M                     ((0x3) << XDMA_DST_MULTBLK_TYPE_S)
#define XDMA_SRC_MULTBLK_TYPE_S                     (0U)
#define XDMA_SRC_MULTBLK_TYPE_M                     ((0x3) << XDMA_SRC_MULTBLK_TYPE_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_LLP registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_LOC_H_S                                (0U)
#define XDMA_LOC_H_M                                ((0xFFFFFFFF) << XDMA_LOC_H_S)
// Low 32 bits
#define XDMA_LOC_L_S                                (6U)
#define XDMA_LOC_L_M                                ((0x3FFFFFF)) << XDMA_LOC_L_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_STATUSREG registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_DATA_LEFT_IN_FIFO_S                    (0U)
#define XDMA_DATA_LEFT_IN_FIFO_M                    ((0x1F) << XDMA_DATA_LEFT_IN_FIFO_S)    
// Low 32 bits
#define XDMA_CMPLTD_BLK_TFR_SIZE_S                  (0U)
#define XDMA_CMPLTD_BLK_TFR_SIZE_M                  ((0x3FFFFF) << XDMA_CMPLTD_BLK_TFR_SIZE_S)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_SWHSSRCREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_SWHS_LST_SRC_WE                        BIT(5)
#define XDMA_SWHS_LST_SRC                           BIT(4)
#define XDMA_SWHS_SGLREQ_SRC_WE                     BIT(3)
#define XDMA_SWHS_SGLREQ_SRC                        BIT(2)
#define XDMA_SWHS_REQ_SRC_WE                        BIT(1)
#define XDMA_SWHS_REQ_SRC                           BIT(0)
//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_SWHSDSTREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_SWHS_LST_DST_WE                        BIT(5)
#define XDMA_SWHS_LST_DST                           BIT(4)
#define XDMA_SWHS_SGLREQ_DST_WE                     BIT(3)
#define XDMA_SWHS_SGLREQ_DST                        BIT(2)
#define XDMA_SWHS_REQ_DST_WE                        BIT(1)
#define XDMA_SWHS_REQ_DST                           BIT(0)

//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_BTFRREQ registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_BLK_TFR_RESUMEREQ                      BIT(0)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_AXI_IDREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_AXI_WRITE_ID_SUFFIX_S                  (16U)
#define XDMA_AXI_WRITE_ID_SUFFIX_M                  ((0xF) << XDMA_AXI_WRITE_ID_SUFFIX_S)
#define XDMA_AXI_READ_ID_SUFFIX_S                   (0U)
#define XDMA_AXI_READ_ID_SUFFIX_M                   ((0xF) << XDMA_AXI_READ_ID_SUFFIX_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_AXI_QOSREG registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_AXI_ARQOS_S                            (4U)
#define XDMA_AXI_ARQOS_M                            ((0xF) << XDMA_AXI_ARQOS_S)
#define XDMA_AXI_AWQOS_S                            (0U)
#define XDMA_AXI_AWQOS_M                            ((0xF) << XDMA_AXI_AWQOS_S)



//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_SSTAT registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_SSTAT_S                                (0U)
#define XDMA_SSTAT_M                                ((0xFFFFFFFF) << XDMA_SSTAT_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_DSTAT registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_DSTAT_S                                (0X0u)
#define XDMA_DSTAT_M                                ((0xFFFFFFFF) << XDMA_DSTAT_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_SSTATAR registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_SSTATAR_H_S                            (0U)
#define XDMA_SSTATAR_H_M                            ((0xFFFFFFFF) << XDMA_SSTATAR_H_S)
// Low 32 bits
#define XDMA_SSTATAR_L_S                            (0U)
#define XDMA_SSTATAR_L_M                            ((0xFFFFFFFF) << XDMA_SSTATAR_L_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the CHx_DSTATAR registers
//
//*************************************************************************************************
// High 32 bits
#define XDMA_DSTATAR_H_S                            (0U)
#define XDMA_DSTATAR_H_M                            ((0xFFFFFFFF) << XDMA_DSTATAR_H_S)
// Low 32 bits
#define XDMA_DSTATAR_L_S                            (0U)
#define XDMA_DSTATAR_L_M                            ((0xFFFFFFFF) << XDMA_DSTATAR_L_S)


//*************************************************************************************************
//
// The following are defines for the bit fields in the below registers
//  CHx_INTSTATUS_ENABLEREG     
//  CHx_INTSTATUS                               (READ ONLY)
//  CHx_INTSIGNAL_ENABLEREG 
//  CHx_INTCLEARREG                             (WRITE ONLY)
//
//*************************************************************************************************
// High 32 bits 
#define XDMA_ECC_PROT_UIDMem_UnCorrERR              BIT(3)
#define XDMA_ECC_PROT_UIDMem_CorrERR                BIT(2)
#define XDMA_ECC_PROT_CHMem_UnCorrERR               BIT(1)
#define XDMA_ECC_PROT_CHMem_CorrERR                 BIT(0)      
// total CHx High ERR INTS mask
#define XDMA_CHX_ERR_INTS_H_M                       (0xFU)      

// Low 32 bits
#define XDMA_CH_ABORTED                             BIT(31)
#define XDMA_CH_DISABLED                            BIT(30)
#define XDMA_CH_SUSPENDED                           BIT(29)
#define XDMA_CH_SRC_SUSPENDED                       BIT(28)
#define XDMA_CH_LOCK_CLEARED                        BIT(27)
#define XDMA_DMAC_CHx_INTCLEARREG                   BIT(26)
#define XDMA_SLVIF_WRPARITY_ERR                     BIT(25)
#define XDMA_SLVIF_ADDRPARITY_ERR                   BIT(24)
#define XDMA_SLVIF_WRONHOLD_ERR                     BIT(21)
#define XDMA_SLVIF_SHADOWREG_WRON_VALID_ERR         BIT(20)
#define XDMA_SLVIF_WRONCHEN_ERR                     BIT(19)
#define XDMA_SLVIF_RD2RWO_ERR                       BIT(18)
#define XDMA_SLVIF_WR2RO_ERR                        BIT(17)
#define XDMA_SLVIF_DEC_ERR                          BIT(16)
#define XDMA_SLVIF_MULTIBLKTYPE_ERR                 BIT(14)
#define XDMA_SHADOWREG_OR_LLI_INVALID               BIT(13)
#define XDMA_LLI_WR_SLV_ERR                         BIT(12)
#define XDMA_LLI_RD_SLV_ERR                         BIT(11)
#define XDMA_LLI_WR_DEC_ERR                         BIT(10)
#define XDMA_LLI_RD_DEC_ERR                         BIT(9)
#define XDMA_DST_SLV_ERR                            BIT(8)
#define XDMA_SRC_SLV_ERR                            BIT(7)
#define XDMA_DST_DEC_ERR                            BIT(6)
#define XDMA_SRC_DEC_ERR                            BIT(5)
#define XDMA_DST_TRANSCOMP                          BIT(4)
#define XDMA_SRC_TRANSCOMP                          BIT(3)
#define XDMA_DMA_TFR_DONE                           BIT(1)
#define XDMA_BLOCK_TFR_DONE                         BIT(0)
// total CHx Low INTS mask
#define XDMA_CHX_ERR_INTS_L_M                       (0xFFFFFFE0U)    


//*************************************************************************************************
//
// The following are defines for the bit fields in the LLI_AXCACHE registers
//
//*************************************************************************************************
// High 32 bits
// Low 32 bits
#define XDMA_LLI_AXCACHE_S                          (3U)
#define XDMA_LLI_AXCACHE_M                          ((0xF) << XDMA_LLI_AXCACHE_S)
#define XDMA_LLI_AXPROT_S                           (0U)
#define XDMA_LLI_AXPROT_M                           ((0xF) << XDMA_LLI_AXPROT_S)

#ifdef __cplusplus
}
#endif

#endif /* DEVICE_DRIVERLIB_HW_XDMA_H_ */
