/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    pinmap_gs32f0013x.h
 *   @brief
 *
 */

#ifndef PINMAP_GS32F0013x_H_
#define PINMAP_GS32F0013x_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx()

#if GS32_PART_NUM == 0x00137

/*****************************************************************************
 *
 * Values that can be passed to GPIO_setPinConfig() as the pinConfig parameter.
 *
 * Note: Refer to the corresponding data manual for detailed information
 * on each pin's reuse functions and configurations.
 *
 *****************************************************************************/
#define GPIO_0_GPIO0            0x000C0000U /* 137 */
#define GPIO_0_EPWM1_A          0x000C0001U /* 137 */
#define GPIO_0_CANA_RX          0x000C0002U /* 137 */
#define GPIO_0_OUTPUTXBAR7      0x000C0003U /* 137 */
#define GPIO_0_SCIA_RX          0x000C0005U /* 137 */
#define GPIO_0_I2CA_SDA         0x000C0006U /* 137 */
#define GPIO_0_SPIA_STE         0x000C0007U /* 137 */
#define GPIO_0_CLB_OUTPUTXBAR8  0x000C000BU /* 137 */
#define GPIO_0_EQEP1_INDEX      0x000C000DU /* 137 */
#define GPIO_0_EPWM3_A          0x000C000FU /* 137 */

#define GPIO_1_GPIO1            0x000C0200U /* 137 */
#define GPIO_1_EPWM1_B          0x000C0201U /* 137 */
#define GPIO_1_SCIA_TX          0x000C0205U /* 137 */
#define GPIO_1_I2CA_SCL         0x000C0206U /* 137 */
#define GPIO_1_SPIA_SOMI        0x000C0207U /* 137 */
#define GPIO_1_EQEP1_STROBE     0x000C0209U /* 137 */
#define GPIO_1_CLB_OUTPUTXBAR7  0x000C020BU /* 137 */
#define GPIO_1_EPWM3_B          0x000C020FU /* 137 */

#define GPIO_2_GPIO2            0x000C0400U /* 137 */
#define GPIO_2_EPWM2_A          0x000C0401U /* 137 */
#define GPIO_2_OUTPUTXBAR1      0x000C0405U /* 137 */
#define GPIO_2_SPIA_SIMO        0x000C0407U /* 137 */
#define GPIO_2_SCIA_TX          0x000C0409U /* 137 */
#define GPIO_2_I2CB_SDA         0x000C040BU /* 137 */
#define GPIO_2_CANA_TX          0x000C040EU /* 137 */
#define GPIO_2_EPWM4_A          0x000C040FU /* 137 */

#define GPIO_3_GPIO3            0x000C0600U /* 137 */
#define GPIO_3_EPWM2_B          0x000C0601U /* 137 */
#define GPIO_3_OUTPUTXBAR2      0x000C0602U /* 137 */
#define GPIO_3_SPIA_CLK         0x000C0607U /* 137 */
#define GPIO_3_SCIA_RX          0x000C0609U /* 137 */
#define GPIO_3_I2CB_SCL         0x000C060BU /* 137 */
#define GPIO_3_CANA_RX          0x000C060EU /* 137 */
#define GPIO_3_EPWM4_B          0x000C060FU /* 137 */

#define GPIO_4_GPIO4            0x000C0800U /* 137 */
#define GPIO_4_EPWM3_A          0x000C0801U /* 137 */
#define GPIO_4_I2CA_SCL         0x000C0802U /* 137 */
#define GPIO_4_OUTPUTXBAR3      0x000C0805U /* 137 */
#define GPIO_4_CANA_TX          0x000C0806U /* 137 */
#define GPIO_4_SPIB_CLK         0x000C0807U /* 137 */
#define GPIO_4_EQEP2_STROBE     0x000C0809U /* 137 */
#define GPIO_4_CLB_OUTPUTXBAR6  0x000C080BU /* 137 */
#define GPIO_4_SPIA_SOMI        0x000C080EU /* 137 */
#define GPIO_4_EPWM1_A          0x000C080FU /* 137 */

#define GPIO_5_GPIO5            0x000C0A00U /* 137 */
#define GPIO_5_EPWM3_B          0x000C0A01U /* 137 */
#define GPIO_5_I2CA_SDA         0x000C0A02U /* 137 */
#define GPIO_5_OUTPUTXBAR3      0x000C0A03U /* 137 */
#define GPIO_5_CANA_RX          0x000C0A06U /* 137 */
#define GPIO_5_SPIA_STE         0x000C0A07U /* 137 */
#define GPIO_5_CLB_OUTPUTXBAR5  0x000C0A0AU /* 137 */
#define GPIO_5_SCIA_RX          0x000C0A0BU /* 137 */
#define GPIO_5_EPWM1_B          0x000C0A0FU /* 137 */

#define GPIO_6_GPIO6            0x000C0C00U /* 137 */
#define GPIO_6_EPWM4_A          0x000C0C01U /* 137 */
#define GPIO_6_OUTPUTXBAR4      0x000C0C02U /* 137 */
#define GPIO_6_SYNCOUT          0x000C0C03U /* 137 */
#define GPIO_6_EQEP1_A          0x000C0C05U /* 137 */
#define GPIO_6_SPIB_SOMI        0x000C0C07U /* 137 */
#define GPIO_6_CLB_OUTPUTXBAR8  0x000C0C0EU /* 137 */
#define GPIO_6_EPWM2_A          0x000C0C0FU /* 137 */

#define GPIO_7_GPIO7            0x000C0E00U /* 137 */
#define GPIO_7_EPWM4_B          0x000C0E01U /* 137 */
#define GPIO_7_EPWM2_A          0x000C0E02U /* 137 */
#define GPIO_7_OUTPUTXBAR5      0x000C0E03U /* 137 */
#define GPIO_7_EQEP1_B          0x000C0E05U /* 137 */
#define GPIO_7_SPIA_SIMO        0x000C0E07U /* 137 */
#define GPIO_7_CLB_OUTPUTXBAR2  0x000C0E0AU /* 137 */
#define GPIO_7_SCIA_TX          0x000C0E0BU /* 137 */
#define GPIO_7_CANA_TX          0x000C0E0EU /* 137 */
#define GPIO_7_EPWM2_B          0x000C0E0FU /* 137 */

#define GPIO_8_GPIO8            0x000C1000U /* 137 */
#define GPIO_8_EPWM5_A          0x000C1001U /* 137 */
#define GPIO_8_ADCSOCAO         0x000C1003U /* 137 */
#define GPIO_8_EQEP1_STROBE     0x000C1005U /* 137 */
#define GPIO_8_SCIA_TX          0x000C1006U /* 137 */
#define GPIO_8_SPIA_SIMO        0x000C1007U /* 137 */
#define GPIO_8_I2CA_SCL         0x000C1009U /* 137 */
#define GPIO_8_CLB_OUTPUTXBAR5  0x000C100BU /* 137 */

#define GPIO_9_GPIO9            0x000C1200U /* 137 */
#define GPIO_9_EPWM5_B          0x000C1201U /* 137 */
#define GPIO_9_SCIB_TX          0x000C1202U /* 137 */
#define GPIO_9_OUTPUTXBAR6      0x000C1203U /* 137 */
#define GPIO_9_EQEP1_INDEX      0x000C1205U /* 137 */
#define GPIO_9_SCIA_RX          0x000C1206U /* 137 */
#define GPIO_9_SPIA_CLK         0x000C1207U /* 137 */
#define GPIO_9_I2CB_SCL         0x000C120EU /* 137 */

#define GPIO_10_GPIO10          0x000C1400U /* 137 */
#define GPIO_10_EPWM6_A         0x000C1401U /* 137 */
#define GPIO_10_ADCSOCBO        0x000C1403U /* 137 */
#define GPIO_10_EQEP1_A         0x000C1405U /* 137 */
#define GPIO_10_SCIB_TX         0x000C1406U /* 137 */
#define GPIO_10_SPIA_SOMI       0x000C1407U /* 137 */
#define GPIO_10_I2CA_SDA        0x000C1409U /* 137 */

#define GPIO_11_GPIO11          0x000C1600U /* 137 */
#define GPIO_11_EPWM6_B         0x000C1601U /* 137 */
#define GPIO_11_CANA_RX         0x000C1602U /* 137 */
#define GPIO_11_OUTPUTXBAR7     0x000C1603U /* 137 */
#define GPIO_11_EQEP1_B         0x000C1605U /* 137 */
#define GPIO_11_SCIB_RX         0x000C1606U /* 137 */
#define GPIO_11_SPIA_STE        0x000C1607U /* 137 */
#define GPIO_11_EQEP2_A         0x000C160BU /* 137 */
#define GPIO_11_SPIA_SIMO       0x000C160DU /* 137 */

#define GPIO_12_GPIO12          0x000C1800U /* 137 */
#define GPIO_12_EPWM7_A         0x000C1801U /* 137 */
#define GPIO_12_EQEP1_STROBE    0x000C1805U /* 137 */
#define GPIO_12_SCIB_TX         0x000C1806U /* 137 */
#define GPIO_12_SPIA_CLK        0x000C180BU /* 137 */
#define GPIO_12_CANA_RX         0x000C180DU /* 137 */

#define GPIO_13_GPIO13          0x000C1A00U /* 137 */
#define GPIO_13_EPWM7_B         0x000C1A01U /* 137 */
#define GPIO_13_EQEP1_INDEX     0x000C1A05U /* 137 */
#define GPIO_13_SCIB_RX         0x000C1A06U /* 137 */
#define GPIO_13_SPIA_SOMI       0x000C1A0BU /* 137 */
#define GPIO_13_CANA_TX         0x000C1A0DU /* 137 */

#define GPIO_16_GPIO16          0x00100000U /* 137 */
#define GPIO_16_SPIA_SIMO       0x00100001U /* 137 */
#define GPIO_16_OUTPUTXBAR7     0x00100003U /* 137 */
#define GPIO_16_EPWM5_A         0x00100005U /* 137 */
#define GPIO_16_SCIA_TX         0x00100006U /* 137 */
#define GPIO_16_SD1_D1          0x00100007U /* 137 */
#define GPIO_16_EQEP1_STROBE    0x00100009U /* 137 */
#define GPIO_16_XCLKOUT         0x0010000BU /* 137 */
#define GPIO_16_EQEP2_B         0x0010000DU /* 137 */
#define GPIO_16_SPIB_SOMI       0x0010000EU /* 137 */

#define GPIO_17_GPIO17          0x00100200U /* 137 */
#define GPIO_17_SPIA_SOMI       0x00100201U /* 137 */
#define GPIO_17_OUTPUTXBAR8     0x00100203U /* 137 */
#define GPIO_17_EPWM5_B         0x00100205U /* 137 */
#define GPIO_17_SCIA_RX         0x00100206U /* 137 */
#define GPIO_17_SD1_C1          0x00100207U /* 137 */
#define GPIO_17_EQEP1_INDEX     0x00100209U /* 137 */
#define GPIO_17_CANA_TX         0x0010020BU /* 137 */
#define GPIO_17_EPWM6_A         0x0010020EU /* 137 */

#define GPIO_18_GPIO18          0x00100400U /* 137 */
#define GPIO_18_SPIA_CLK        0x00100401U /* 137 */
#define GPIO_18_SCIB_TX         0x00100402U /* 137 */
#define GPIO_18_CANA_RX         0x00100403U /* 137 */
#define GPIO_18_EPWM6_A         0x00100405U /* 137 */
#define GPIO_18_I2CA_SCL        0x00100406U /* 137 */
#define GPIO_18_SD1_D2          0x00100407U /* 137 */
#define GPIO_18_EQEP2_A         0x00100409U /* 137 */
#define GPIO_18_XCLKOUT         0x0010040BU /* 137 */

#define GPIO_19_GPIO19          0x00100600U /* 137 */
#define GPIO_19_SPIA_STE        0x00100601U /* 137 */
#define GPIO_19_SCIB_RX         0x00100602U /* 137 */
#define GPIO_19_CANA_TX         0x00100603U /* 137 */
#define GPIO_19_EPWM6_B         0x00100605U /* 137 */
#define GPIO_19_I2CA_SDA        0x00100606U /* 137 */
#define GPIO_19_SD1_C2          0x00100607U /* 137 */
#define GPIO_19_EQEP2_B         0x00100609U /* 137 */
#define GPIO_19_CLB_OUTPUTXBAR1 0x0010060DU /* 137 */

#define GPIO_20_GPIO20          0x00100800U /* 137 */
#define GPIO_20_EQEP1_A         0x00100801U /* 137 */
#define GPIO_20_CANA_TX         0x00100803U /* 137 */
#define GPIO_20_SPIA_SIMO       0x00100806U /* 137 */
#define GPIO_20_SD1_D3          0x00100807U /* 137 */
#define GPIO_20_I2CA_SCL        0x0010080BU /* 137 */
#define GPIO_20_SCIC_TX         0x0010080FU /* 137 */

#define GPIO_21_GPIO21          0x00100A00U /* 137 */
#define GPIO_21_EQEP1_B         0x00100A01U /* 137 */
#define GPIO_21_CANA_RX         0x00100A03U /* 137 */
#define GPIO_21_SPIA_SOMI       0x00100A06U /* 137 */
#define GPIO_21_SD1_C3          0x00100A07U /* 137 */
#define GPIO_21_I2CA_SDA        0x00100A0BU /* 137 */
#define GPIO_21_SCIC_RX         0x00100A0FU /* 137 */

#define GPIO_22_GPIO22          0x00100C00U /* 137 */
#define GPIO_22_EQEP1_STROBE    0x00100C01U /* 137 */
#define GPIO_22_SCIB_TX         0x00100C03U /* 137 */
#define GPIO_22_SPIB_CLK        0x00100C06U /* 137 */
#define GPIO_22_SD1_D4          0x00100C07U /* 137 */
#define GPIO_22_SCIC_TX         0x00100C09U /* 137 */
#define GPIO_22_CLB_OUTPUTXBAR1 0x00100C0AU /* 137 */
#define GPIO_22_EPWM4_A         0x00100C0EU /* 137 */

#define GPIO_23_GPIO23          0x00100E00U /* 137 */
#define GPIO_23_EQEP1_INDEX     0x00100E01U /* 137 */
#define GPIO_23_SCIB_RX         0x00100E03U /* 137 */
#define GPIO_23_SPIB_STE        0x00100E06U /* 137 */
#define GPIO_23_SD1_C4          0x00100E07U /* 137 */
#define GPIO_23_SCIC_RX         0x00100E09U /* 137 */
#define GPIO_23_CLB_OUTPUTXBAR3 0x00100E0AU /* 137 */
#define GPIO_23_EPWM4_B         0x00100E0EU /* 137 */

#define GPIO_24_GPIO24          0x00101000U /* 137 */
#define GPIO_24_OUTPUTXBAR1     0x00101001U /* 137 */
#define GPIO_24_EQEP2_A         0x00101002U /* 137 */
#define GPIO_24_SPIA_STE        0x00101003U /* 137 */
#define GPIO_24_EPWM4_A         0x00101005U /* 137 */
#define GPIO_24_SPIA_SIMO       0x00101006U /* 137 */
#define GPIO_24_SCIA_TX         0x0010100BU /* 137 */
#define GPIO_24_ERRORSTS        0x0010100DU /* 137 */

#define GPIO_28_GPIO28          0x00101800U /* 137 */
#define GPIO_28_SCIA_RX         0x00101801U /* 137 */
#define GPIO_28_EPWM7_A         0x00101803U /* 137 */
#define GPIO_28_OUTPUTXBAR5     0x00101805U /* 137 */
#define GPIO_28_EQEP1_A         0x00101806U /* 137 */
#define GPIO_28_EQEP2_STROBE    0x00101809U /* 137 */
#define GPIO_28_SCIC_TX         0x0010180AU /* 137 */
#define GPIO_28_SPIA_CLK        0x0010180BU /* 137 */
#define GPIO_28_ERRORSTS        0x0010180DU /* 137 */
#define GPIO_28_I2CB_SDA        0x0010180EU /* 137 */

#define GPIO_29_GPIO29          0x00101A00U /* 137 */
#define GPIO_29_SCIA_TX         0x00101A01U /* 137 */
#define GPIO_29_EPWM7_B         0x00101A03U /* 137 */
#define GPIO_29_OUTPUTXBAR6     0x00101A05U /* 137 */
#define GPIO_29_EQEP1_B         0x00101A06U /* 137 */
#define GPIO_29_EQEP2_INDEX     0x00101A09U /* 137 */
#define GPIO_29_SCIC_RX         0x00101A0AU /* 137 */
#define GPIO_29_SPIA_STE        0x00101A0BU /* 137 */
#define GPIO_29_ERRORSTS        0x00101A0DU /* 137 */
#define GPIO_29_I2CB_SCL        0x00101A0EU /* 137 */

#define GPIO_32_GPIO32          0x008C0000U /* 137 */
#define GPIO_32_I2CA_SDA        0x008C0001U /* 137 */
#define GPIO_32_EQEP1_INDEX     0x008C0002U /* 137 */
#define GPIO_32_SPIA_CLK        0x008C0003U /* 137 */
#define GPIO_32_EPWM4_B         0x008C0005U /* 137 */
#define GPIO_32_SCIC_TX         0x008C0006U /* 137 */
#define GPIO_32_SD1_D2          0x008C0007U /* 137 */
#define GPIO_32_CANA_TX         0x008C000AU /* 137 */
#define GPIO_32_ADCSOCBO        0x008C000DU /* 137 */

#define GPIO_33_GPIO33          0x008C0200U /* 137 */
#define GPIO_33_I2CA_SCL        0x008C0201U /* 137 */
#define GPIO_33_SPIB_STE        0x008C0203U /* 137 */
#define GPIO_33_OUTPUTXBAR4     0x008C0205U /* 137 */
#define GPIO_33_SCIC_RX         0x008C0206U /* 137 */
#define GPIO_33_SD1_C2          0x008C0207U /* 137 */
#define GPIO_33_CANA_RX         0x008C020AU /* 137 */
#define GPIO_33_EQEP2_B         0x008C020BU /* 137 */
#define GPIO_33_ADCSOCAO        0x008C020DU /* 137 */
#define GPIO_33_SD1_C1          0x008C020EU /* 137 */

#define GPIO_35_GPIO35          0x008C0600U /* 137 */
#define GPIO_35_SCIA_RX         0x008C0601U /* 137 */
#define GPIO_35_SPIA_SOMI       0x008C0602U /* 137 */
#define GPIO_35_I2CA_SDA        0x008C0603U /* 137 */
#define GPIO_35_CANA_RX         0x008C0605U /* 137 */
#define GPIO_35_SCIC_RX         0x008C0607U /* 137 */
#define GPIO_35_EQEP1_A         0x008C0609U /* 137 */
#define GPIO_35_EPWM5_B         0x008C060BU /* 137 */
#define GPIO_35_TDI             0x008C060FU /* 137 */

#define GPIO_37_GPIO37          0x008C0A00U /* 137 */
#define GPIO_37_OUTPUTXBAR2     0x008C0A01U /* 137 */
#define GPIO_37_SPIA_STE        0x008C0A02U /* 137 */
#define GPIO_37_I2CA_SCL        0x008C0A03U /* 137 */
#define GPIO_37_SCIA_TX         0x008C0A05U /* 137 */
#define GPIO_37_CANA_TX         0x008C0A06U /* 137 */
#define GPIO_37_SCIC_TX         0x008C0A07U /* 137 */
#define GPIO_37_EQEP1_B         0x008C0A09U /* 137 */
#define GPIO_37_EPWM5_A         0x008C0A0BU /* 137 */
#define GPIO_37_TDO             0x008C0A0FU /* 137 */

#define GPIO_39_GPIO39          0x008C0E00U /* 137 */
#define GPIO_39_EQEP2_INDEX     0x008C0E09U /* 137 */
#define GPIO_39_CLB_OUTPUTXBAR2 0x008C0E0BU /* 137 */
#define GPIO_39_SYNCOUT         0x008C0E0DU /* 137 */
#define GPIO_39_EQEP1_INDEX     0x008C0E0EU /* 137 */

#define GPIO_40_GPIO40          0x008C1000U /* 137 */
#define GPIO_40_SPIB_SIMO       0x008C1001U /* 137 */
#define GPIO_40_EPWM2_B         0x008C1005U /* 137 */
#define GPIO_40_SCIB_TX         0x008C1009U /* 137 */
#define GPIO_40_EQEP1_A         0x008C100AU /* 137 */

#define GPIO_41_GPIO41          0x008C1200U /* 137 */
#define GPIO_41_EPWM7_A         0x008C1201U /* 137 */
#define GPIO_41_EPWM2_A         0x008C1205U /* 137 */
#define GPIO_41_SCIB_RX         0x008C1209U /* 137 */
#define GPIO_41_EQEP1_B         0x008C120AU /* 137 */
#define GPIO_41_SPIB_SOMI       0x008C120EU /* 137 */

#define GPIO_224_GPIO224        0x038C0000U /* 137 */
#define GPIO_224_OUTPUTXBAR3    0x038C0005U /* 137 */
#define GPIO_224_SPIA_SIMO      0x038C0006U /* 137 */
#define GPIO_224_EPWM1_A        0x038C0007U /* 137 */
#define GPIO_224_CANA_TX        0x038C000AU /* 137 */
#define GPIO_224_EQEP1_A        0x038C000BU /* 137 */
#define GPIO_224_SCIC_TX        0x038C000EU /* 137 */

#define GPIO_225_GPIO225        0x038C0200U /* 137 */

#define GPIO_226_GPIO226        0x038C0400U /* 137 */
#define GPIO_226_EPWM6_A        0x038C0405U /* 137 */
#define GPIO_226_SPIA_CLK       0x038C0406U /* 137 */
#define GPIO_226_EPWM1_B        0x038C0409U /* 137 */
#define GPIO_226_EQEP1_STROBE   0x038C040BU /* 137 */
#define GPIO_226_SCIC_RX        0x038C040EU /* 137 */

#define GPIO_227_GPIO227        0x038C0600U /* 137 */
#define GPIO_227_I2CB_SCL       0x038C0601U /* 137 */
#define GPIO_227_SD1_C3         0x038C0602U /* 137 */
#define GPIO_227_EPWM3_A        0x038C0603U /* 137 */
#define GPIO_227_OUTPUTXBAR1    0x038C0605U /* 137 */
#define GPIO_227_EPWM2_B        0x038C0606U /* 137 */

#define GPIO_228_GPIO228        0x038C0800U /* 137 */
#define GPIO_228_ADCSOCAO       0x038C0803U /* 137 */
#define GPIO_228_CANA_TX        0x038C0805U /* 137 */
#define GPIO_228_SPIA_SOMI      0x038C0806U /* 137 */
#define GPIO_228_EPWM2_B        0x038C0809U /* 137 */
#define GPIO_228_EQEP1_B        0x038C080BU /* 137 */

#define GPIO_230_GPIO230        0x038C0C00U /* 137 */
#define GPIO_230_I2CB_SDA       0x038C0C01U /* 137 */
#define GPIO_230_SD1_C4         0x038C0C02U /* 137 */
#define GPIO_230_EPWM3_B        0x038C0C03U /* 137 */
#define GPIO_230_CANA_RX        0x038C0C05U /* 137 */
#define GPIO_230_EPWM2_A        0x038C0C06U /* 137 */
#define GPIO_230_I2CA_SDA       0x038C0C07U /* 137 */

#define GPIO_231_GPIO231        0x038C0E00U /* 137 */
#define GPIO_231_SD1_C1         0x038C0E02U /* 137 */

#define GPIO_232_GPIO232        0x038C1000U /* 137 */
#define GPIO_232_SD1_D4         0x038C1002U /* 137 */

#define GPIO_233_GPIO233        0x038C1200U /* 137 */

#define GPIO_237_GPIO237        0x038C1A00U /* 137 */
#define GPIO_237_SD1_D2         0x038C1A02U /* 137 */

#define GPIO_238_GPIO238        0x038C1C00U /* 137 */

#define GPIO_239_GPIO239        0x038C1E00U /* 137 */
#define GPIO_239_SD1_D1         0x038C1E02U /* 137 */

#define GPIO_241_GPIO241        0x03900200U /* 137 */

#define GPIO_242_GPIO242        0x03900400U /* 137 */
#define GPIO_242_OUTPUTXBAR2    0x03900405U /* 137 */
#define GPIO_242_SPIA_STE       0x03900406U /* 137 */
#define GPIO_242_EPWM4_A        0x03900409U /* 137 */
#define GPIO_242_CANA_RX        0x0390040AU /* 137 */
#define GPIO_242_EQEP1_INDEX    0x0390040BU /* 137 */

#define GPIO_244_GPIO244        0x03900800U /* 137 */
#define GPIO_244_SD1_D3         0x03900802U /* 137 */

#define GPIO_245_GPIO245        0x03900A00U /* 137 */
#define GPIO_245_SD1_C2         0x03900A02U /* 137 */


#endif /* GS32_PART_NUM == 0x00137 */

#endif /* IS_GS32F00xx() */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32F0013x_H_ */
