/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
 *   @file    pinmap_gs32f0015x.h
 *   @brief
 *
 */

#ifndef PINMAP_GS32FP55A_H_
#define PINMAP_GS32FP55A_H_

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif

#if IS_GS32F00xx()

#if GS32_PART_NUM == 0x0550

/*****************************************************************************
 *
 * Values that can be passed to GPIO_setPinConfig() as the pinConfig parameter.
 *
 * Note: Refer to the corresponding data manual for detailed information
 * on each pin's reuse functions and configurations.
 *
 *****************************************************************************/
#define GPIO_0_GPIO0                     0x000C0000U   /* P55A */
#define GPIO_0_EPWM1_A                   0x000C0001U   /* P55A */
#define GPIO_0_CANA_RX                   0x000C0002U   /* P55A */
#define GPIO_0_OUTPUTXBAR7               0x000C0003U   /* P55A */
#define GPIO_0_SCIA_RX                   0x000C0005U   /* P55A */
#define GPIO_0_I2CA_SDA                  0x000C0006U   /* P55A */
#define GPIO_0_SPIA_STE                  0x000C0007U   /* P55A */
//#define GPIO_0_CANA_RX                   0x000C000AU   /* P55A */
#define GPIO_0_CLB_OUTPUTXBAR8           0x000C000BU   /* P55A */
#define GPIO_0_EQEP1_INDEX               0x000C000DU   /* P55A */
#define GPIO_0_EPWM3_A                   0x000C000FU   /* P55A */

#define GPIO_1_GPIO1                     0x000C0200U   /* P55A */
#define GPIO_1_EPWM1_B                   0x000C0201U   /* P55A */
#define GPIO_1_SCIA_TX                   0x000C0205U   /* P55A */
#define GPIO_1_I2CA_SCL                  0x000C0206U   /* P55A */
#define GPIO_1_SPIA_SOMI                 0x000C0207U   /* P55A */
#define GPIO_1_EQEP1_STROBE              0x000C0209U   /* P55A */
#define GPIO_1_CANA_TX                   0x000C020AU   /* P55A */
#define GPIO_1_CLB_OUTPUTXBAR7           0x000C020BU   /* P55A */
#define GPIO_1_EPWM3_B                   0x000C020FU   /* P55A */

#define GPIO_2_GPIO2                     0x000C0400U   /* P55A */
#define GPIO_2_EPWM2_A                   0x000C0401U   /* P55A */
#define GPIO_2_OUTPUTXBAR1               0x000C0405U   /* P55A */
#define GPIO_2_PMBUSA_SDA                0x000C0406U   /* P55A */
#define GPIO_2_SPIA_SIMO                 0x000C0407U   /* P55A */
#define GPIO_2_SCIA_TX                   0x000C0409U   /* P55A */
#define GPIO_2_I2CB_SDA                  0x000C040BU   /* P55A */
#define GPIO_2_CANB_TX                   0x000C040EU   /* P55A */
#define GPIO_2_EPWM4_A                   0x000C040FU   /* P55A */

#define GPIO_3_GPIO3                     0x000C0600U   /* P55A */
#define GPIO_3_EPWM2_B                   0x000C0601U   /* P55A */
#define GPIO_3_OUTPUTXBAR2               0x000C0602U   /* P55A */
#define GPIO_3_PMBUSA_SCL                0x000C0606U   /* P55A */
#define GPIO_3_SPIA_CLK                  0x000C0607U   /* P55A */
#define GPIO_3_SCIA_RX                   0x000C0609U   /* P55A */
#define GPIO_3_I2CB_SCL                  0x000C060BU   /* P55A */
#define GPIO_3_CANB_RX                   0x000C060EU   /* P55A */
#define GPIO_3_EPWM4_B                   0x000C060FU   /* P55A */

#define GPIO_4_GPIO4                     0x000C0800U   /* P55A */
#define GPIO_4_EPWM3_A                   0x000C0801U   /* P55A */
#define GPIO_4_I2CA_SCL                  0x000C0802U   /* P55A */
#define GPIO_4_CANA_TX                   0x000C0803U   /* P55A */
#define GPIO_4_OUTPUTXBAR3               0x000C0805U   /* P55A */
//#define GPIO_4_CANA_TX                   0x000C0806U   /* P55A */
#define GPIO_4_SPIB_CLK                  0x000C0807U   /* P55A */
#define GPIO_4_EQEP2_STROBE              0x000C0809U   /* P55A */
#define GPIO_4_CLB_OUTPUTXBAR6           0x000C080BU   /* P55A */
#define GPIO_4_SPIA_SOMI                 0x000C080EU   /* P55A */
#define GPIO_4_EPWM1_A                   0x000C080FU   /* P55A */

#define GPIO_5_GPIO5                     0x000C0A00U   /* P55A */
#define GPIO_5_EPWM3_B                   0x000C0A01U   /* P55A */
#define GPIO_5_I2CA_SDA                  0x000C0A02U   /* P55A */
#define GPIO_5_OUTPUTXBAR3               0x000C0A03U   /* P55A */
#define GPIO_5_CANA_RX                   0x000C0A05U   /* P55A */
//#define GPIO_5_CANA_RX                   0x000C0A06U   /* P55A */
#define GPIO_5_SPIA_STE                  0x000C0A07U   /* P55A */
#define GPIO_5_CLB_OUTPUTXBAR5           0x000C0A0AU   /* P55A */
#define GPIO_5_SCIA_RX                   0x000C0A0BU   /* P55A */
#define GPIO_5_EPWM1_B                   0x000C0A0FU   /* P55A */

#define GPIO_6_GPIO6                     0x000C0C00U   /* P55A */
#define GPIO_6_EPWM4_A                   0x000C0C01U   /* P55A */
#define GPIO_6_OUTPUTXBAR4               0x000C0C02U   /* P55A */
#define GPIO_6_SYNCOUT                   0x000C0C03U   /* P55A */
#define GPIO_6_EQEP1_A                   0x000C0C05U   /* P55A */
#define GPIO_6_CANB_TX                   0x000C0C06U   /* P55A */
#define GPIO_6_SPIB_SOMI                 0x000C0C07U   /* P55A */
#define GPIO_6_CLB_OUTPUTXBAR8           0x000C0C0EU   /* P55A */
#define GPIO_6_EPWM2_A                   0x000C0C0FU   /* P55A */

#define GPIO_7_GPIO7                     0x000C0E00U   /* P55A */
#define GPIO_7_EPWM4_B                   0x000C0E01U   /* P55A */
#define GPIO_7_EPWM2_A                   0x000C0E02U   /* P55A */
#define GPIO_7_OUTPUTXBAR5               0x000C0E03U   /* P55A */
#define GPIO_7_EQEP1_B                   0x000C0E05U   /* P55A */
#define GPIO_7_CANB_RX                   0x000C0E06U   /* P55A */
#define GPIO_7_SPIB_SIMO                 0x000C0E07U   /* P55A */
#define GPIO_7_CLB_OUTPUTXBAR2           0x000C0E0AU   /* P55A */
#define GPIO_7_SCIA_TX                   0x000C0E0BU   /* P55A */
#define GPIO_7_CANA_TX                   0x000C0E0EU   /* P55A */
#define GPIO_7_EPWM2_B                   0x000C0E0FU   /* P55A */

#define GPIO_8_GPIO8                     0x000C1000U   /* P55A */
#define GPIO_8_EPWM5_A                   0x000C1001U   /* P55A */
#define GPIO_8_CANB_TX                   0x000C1002U   /* P55A */
#define GPIO_8_ADCSOCAO                  0x000C1003U   /* P55A */
#define GPIO_8_EQEP1_STROBE              0x000C1005U   /* P55A */
#define GPIO_8_SCIA_TX                   0x000C1006U   /* P55A */
#define GPIO_8_SPIA_SIMO                 0x000C1007U   /* P55A */
#define GPIO_8_I2CA_SCL                  0x000C1009U   /* P55A */
#define GPIO_8_CLB_OUTPUTXBAR5           0x000C100BU   /* P55A */

#define GPIO_9_GPIO9                     0x000C1200U   /* P55A */
#define GPIO_9_EPWM5_B                   0x000C1201U   /* P55A */
#define GPIO_9_SCIB_TX                   0x000C1202U   /* P55A */
#define GPIO_9_OUTPUTXBAR6               0x000C1203U   /* P55A */
#define GPIO_9_EQEP1_INDEX               0x000C1205U   /* P55A */
#define GPIO_9_SCIA_RX                   0x000C1206U   /* P55A */
#define GPIO_9_SPIA_CLK                  0x000C1207U   /* P55A */
#define GPIO_9_I2CA_SCL                  0x000C1209U   /* P55A */
#define GPIO_9_LINA_RX                   0x000C120BU   /* P55A */
#define GPIO_9_I2CB_SCL                  0x000C120EU   /* P55A */
#define GPIO_9_EQEP3_B                   0x000C120FU   /* P55A */

#define GPIO_10_GPIO10                    0x000C1400U  /* P55A */
#define GPIO_10_EPWM6_A                   0x000C1401U  /* P55A */
#define GPIO_10_CANB_RX                   0x000C1402U  /* P55A */
#define GPIO_10_ADCSOCBO                  0x000C1403U  /* P55A */
#define GPIO_10_EQEP1_A                   0x000C1405U  /* P55A */
#define GPIO_10_SCIB_TX                   0x000C1406U  /* P55A */
#define GPIO_10_SPIA_SOMI                 0x000C1407U  /* P55A */
#define GPIO_10_I2CA_SDA                  0x000C1409U  /* P55A */
#define GPIO_10_LINA_TX                   0x000C140BU  /* P55A */
#define GPIO_10_EQEP3_STROBE              0x000C140DU  /* P55A */
#define GPIO_10_CLB_OUTPUTXBAR4           0x000C140FU  /* P55A */

#define GPIO_11_GPIO11                    0x000C1600U  /* P55A */
#define GPIO_11_EPWM6_B                   0x000C1601U  /* P55A */
#define GPIO_11_CANA_RX                   0x000C1602U  /* P55A */
#define GPIO_11_OUTPUTXBAR7               0x000C1603U  /* P55A */
#define GPIO_11_EQEP1_B                   0x000C1605U  /* P55A */
#define GPIO_11_SCIB_RX                   0x000C1606U  /* P55A */
#define GPIO_11_SPIA_STE                  0x000C1607U  /* P55A */
#define GPIO_11_LINA_RX                   0x000C160AU  /* P55A */
#define GPIO_11_EQEP2_A                   0x000C160BU  /* P55A */
#define GPIO_11_SPIA_SIMO                 0x000C160DU  /* P55A */
#define GPIO_11_EQEP3_INDEX               0x000C160FU  /* P55A */

#define GPIO_12_GPIO12                    0x000C1800U  /* P55A */
#define GPIO_12_CANB_TX                   0x000C1802U  /* P55A */
#define GPIO_12_CANA_RX                   0x000C1803U  /* P55A */
#define GPIO_12_EQEP1_STROBE              0x000C1805U  /* P55A */
#define GPIO_12_SCIB_TX                   0x000C1806U  /* P55A */
#define GPIO_12_PMBUSA_CTL                0x000C1807U  /* P55A */
#define GPIO_12_LINA_TX                   0x000C180AU  /* P55A */
#define GPIO_12_SPIA_CLK                  0x000C180BU  /* P55A */
//#define GPIO_12_CANA_RX                   0x000C180DU  /* P55A */

#define GPIO_13_GPIO13                    0x000C1A00U  /* P55A */
#define GPIO_13_CANB_RX                   0x000C1A02U  /* P55A */
#define GPIO_13_CANA_TX                   0x000C1A03U  /* P55A */
#define GPIO_13_EQEP1_INDEX               0x000C1A05U  /* P55A */
#define GPIO_13_SCIB_RX                   0x000C1A06U  /* P55A */
#define GPIO_13_PMBUSA_ALERT              0x000C1A07U  /* P55A */
#define GPIO_13_LINA_RX                   0x000C1A0AU  /* P55A */
#define GPIO_13_SPIA_SOMI                 0x000C1A0BU  /* P55A */
//#define GPIO_13_CANA_TX                   0x000C1A0DU  /* P55A */

#define GPIO_14_GPIO14                    0x000C1C00U  /* P55A */
#define GPIO_14_SCIB_TX                   0x000C1C02U  /* P55A */
#define GPIO_14_I2CB_SDA                  0x000C1C05U  /* P55A */
#define GPIO_14_OUTPUTXBAR3               0x000C1C06U  /* P55A */
#define GPIO_14_PMBUSA_SDA                0x000C1C07U  /* P55A */
#define GPIO_14_SPIB_CLK                  0x000C1C09U  /* P55A */
#define GPIO_14_EQEP2_A                   0x000C1C0AU  /* P55A */
#define GPIO_14_LINA_TX                   0x000C1C0BU  /* P55A */
#define GPIO_14_EPWM3_A                   0x000C1C0DU  /* P55A */
#define GPIO_14_CLB_OUTPUTXBAR7           0x000C1C0EU  /* P55A */

#define GPIO_15_GPIO15                    0x000C1E00U  /* P55A */
#define GPIO_15_SCIB_RX                   0x000C1E02U  /* P55A */
#define GPIO_15_I2CB_SCL                  0x000C1E05U  /* P55A */
#define GPIO_15_OUTPUTXBAR4               0x000C1E06U  /* P55A */
#define GPIO_15_PMBUSA_SCL                0x000C1E07U  /* P55A */
#define GPIO_15_SPIB_STE                  0x000C1E09U  /* P55A */
#define GPIO_15_EQEP2_B                   0x000C1E0AU  /* P55A */
#define GPIO_15_LINA_RX                   0x000C1E0BU  /* P55A */
#define GPIO_15_EPWM3_B                   0x000C1E0DU  /* P55A */
#define GPIO_15_CLB_OUTPUTXBAR6           0x000C1E0EU  /* P55A */

#define GPIO_16_GPIO16                    0x00100000U  /* P55A */
#define GPIO_16_SPIA_SIMO                 0x00100001U  /* P55A */
#define GPIO_16_CANB_TX                   0x00100002U  /* P55A */
#define GPIO_16_OUTPUTXBAR7               0x00100003U  /* P55A */
#define GPIO_16_EPWM5_A                   0x00100005U  /* P55A */
#define GPIO_16_SCIA_TX                   0x00100006U  /* P55A */
#define GPIO_16_SD1_D1                    0x00100007U  /* P55A */
#define GPIO_16_EQEP1_STROBE              0x00100009U  /* P55A */
#define GPIO_16_PMBUSA_SCL                0x0010000AU  /* P55A */
#define GPIO_16_XCLKOUT                   0x0010000BU  /* P55A */
#define GPIO_16_EQEP2_B                   0x0010000DU  /* P55A */
#define GPIO_16_SPIB_SOMI                 0x0010000EU  /* P55A */
#define GPIO_16_EQEP3_STROBE              0x0010000FU  /* P55A */

#define GPIO_17_GPIO17                    0x00100200U  /* P55A */
#define GPIO_17_SPIA_SOMI                 0x00100201U  /* P55A */
#define GPIO_17_CANB_RX                   0x00100202U  /* P55A */
#define GPIO_17_OUTPUTXBAR8               0x00100203U  /* P55A */
#define GPIO_17_EPWM5_B                   0x00100205U  /* P55A */
#define GPIO_17_SCIA_RX                   0x00100206U  /* P55A */
#define GPIO_17_SD1_C1                    0x00100207U  /* P55A */
#define GPIO_17_EQEP1_INDEX               0x00100209U  /* P55A */
#define GPIO_17_PMBUSA_SDA                0x0010020AU  /* P55A */
#define GPIO_17_CANA_TX                   0x0010020BU  /* P55A */
#define GPIO_17_EPWM6_A                   0x0010020EU  /* P55A */

#define GPIO_18_GPIO18                    0x00100400U  /* P55A */
#define GPIO_18_SPIA_CLK                  0x00100401U  /* P55A */
#define GPIO_18_SCIB_TX                   0x00100402U  /* P55A */
#define GPIO_18_CANB_RX                   0x00100403U  /* P55A */
#define GPIO_18_EPWM6_A                   0x00100405U  /* P55A */
#define GPIO_18_I2CA_SCL                  0x00100406U  /* P55A */
#define GPIO_18_SD1_D2                    0x00100407U  /* P55A */
#define GPIO_18_EQEP2_A                   0x00100409U  /* P55A */
#define GPIO_18_PMBUSA_CTL                0x0010040AU  /* P55A */
#define GPIO_18_XCLKOUT                   0x0010040BU  /* P55A */
#define GPIO_18_LINA_TX                   0x0010040DU  /* P55A */
#define GPIO_18_EQEP3_INDEX               0x0010040FU  /* P55A */

#define GPIO_19_GPIO19                    0x00100600U  /* P55A */
#define GPIO_19_SPIA_STE                  0x00100601U  /* P55A */
#define GPIO_19_SCIB_RX                   0x00100602U  /* P55A */
#define GPIO_19_CANB_TX                   0x00100603U  /* P55A */
#define GPIO_19_EPWM6_B                   0x00100605U  /* P55A */
#define GPIO_19_I2CA_SDA                  0x00100606U  /* P55A */
#define GPIO_19_SD1_C2                    0x00100607U  /* P55A */
#define GPIO_19_EQEP2_B                   0x00100609U  /* P55A */
#define GPIO_19_PMBUSA_ALERT              0x0010060AU  /* P55A */
#define GPIO_19_CLB_OUTPUTXBAR1           0x0010060BU  /* P55A */
#define GPIO_19_LINA_RX                   0x0010060DU  /* P55A */

#define GPIO_20_GPIO20                    0x00100800U  /* P55A */
#define GPIO_20_EQEP1_A                   0x00100801U  /* P55A */
#define GPIO_20_CANA_TX                   0x00100803U  /* P55A */
#define GPIO_20_SPIB_SIMO                 0x00100806U  /* P55A */
#define GPIO_20_SD1_D3                    0x00100807U  /* P55A */
//#define GPIO_20_CANA_TX                   0x00100809U  /* P55A */
#define GPIO_20_ADC_EXTMUXSEL0            0x0010080AU  /* P55A */
#define GPIO_20_I2CA_SCL                  0x0010080BU  /* P55A */
#define GPIO_20_SCIC_TX                   0x0010080FU  /* P55A */

#define GPIO_21_GPIO21                    0x00100A00U  /* P55A */
#define GPIO_21_EQEP1_B                   0x00100A01U  /* P55A */
#define GPIO_21_CANA_RX                   0x00100A03U  /* P55A */
#define GPIO_21_SPIB_SOMI                 0x00100A06U  /* P55A */
#define GPIO_21_SD1_C3                    0x00100A07U  /* P55A */
//#define GPIO_21_CANA_RX                   0x00100A09U  /* P55A */
#define GPIO_21_ADCC_EXTMUXSEL1           0x00100A0AU  /* P55A */
#define GPIO_21_I2CA_SDA                  0x00100A0BU  /* P55A */
#define GPIO_21_SCIC_RX                   0x00100A0FU  /* P55A */

#define GPIO_22_GPIO22                    0x00100C00U  /* P55A */
#define GPIO_22_EQEP1_STROBE              0x00100C01U  /* P55A */
#define GPIO_22_SCIB_TX                   0x00100C03U  /* P55A */
#define GPIO_22_SPIB_CLK                  0x00100C06U  /* P55A */
#define GPIO_22_SD1_D4                    0x00100C07U  /* P55A */
#define GPIO_22_LINA_TX                   0x00100C09U  /* P55A */
#define GPIO_22_CLB_OUTPUTXBAR1           0x00100C0AU  /* P55A */
//#define GPIO_22_LINA_TX                   0x00100C0BU  /* P55A */
#define GPIO_22_ADCA_EXTMUXSEL3           0x00100C0DU  /* P55A */
#define GPIO_22_EPWM4_A                   0x00100C0EU  /* P55A */
#define GPIO_22_EQEP3_A                   0x00100C0FU  /* P55A */

#define GPIO_23_GPIO23                    0x00100E00U  /* P55A */
#define GPIO_23_EQEP1_INDEX               0x00100E01U  /* P55A */
#define GPIO_23_SCIB_RX                   0x00100E03U  /* P55A */
#define GPIO_23_SPIB_STE                  0x00100E06U  /* P55A */
#define GPIO_23_SD1_C4                    0x00100E07U  /* P55A */
#define GPIO_23_LINA_RX                   0x00100E09U  /* P55A */
#define GPIO_23_CLB_OUTPUTXBAR3           0x00100E0AU  /* P55A */
//#define GPIO_23_LINA_RX                   0x00100E0BU  /* P55A */
#define GPIO_23_ADCA_EXTMUXSEL2           0x00100E0DU  /* P55A */
#define GPIO_23_EPWM4_B                   0x00100E0EU  /* P55A */

#define GPIO_24_GPIO24                    0x00101000U  /* P55A */
#define GPIO_24_OUTPUTXBAR1               0x00101001U  /* P55A */
#define GPIO_24_EQEP2_A                   0x00101002U  /* P55A */
#define GPIO_24_SPIA_STE                  0x00101003U  /* P55A */
#define GPIO_24_SPIA_SIMO                 0x00101006U  /* P55A */
#define GPIO_24_SD2_D1                    0x00101007U  /* P55A */
#define GPIO_24_PMBUSA_SCL                0x0010100AU  /* P55A */
#define GPIO_24_SCIA_TX                   0x0010100BU  /* P55A */
#define GPIO_24_ERRORSTS                  0x0010100DU  /* P55A */
#define GPIO_24_ADCA_EXTMUXSEL1           0x0010100EU  /* P55A */

#define GPIO_25_GPIO25                    0x00101200U  /* P55A */
#define GPIO_25_OUTPUTXBAR2               0x00101201U  /* P55A */
#define GPIO_25_EQEP2_B                   0x00101202U  /* P55A */
#define GPIO_25_EQEP1_A                   0x00101205U  /* P55A */
#define GPIO_25_SPIB_SOMI                 0x00101206U  /* P55A */
#define GPIO_25_SD2_C1                    0x00101207U  /* P55A */
#define GPIO_25_PMBUSA_SDA                0x0010120AU  /* P55A */
#define GPIO_25_SCIA_RX                   0x0010120BU  /* P55A */
#define GPIO_25_ADCA_EXTMUXSEL0           0x0010120EU  /* P55A */

#define GPIO_26_GPIO26                    0x00101400U  /* P55A */
#define GPIO_26_OUTPUTXBAR3               0x00101401U  /* P55A */
#define GPIO_26_EQEP2_INDEX               0x00101402U  /* P55A */
#define GPIO_26_SPIB_CLK                  0x00101406U  /* P55A */
#define GPIO_26_SD2_D2                    0x00101407U  /* P55A */
#define GPIO_26_PMBUSA_CTL                0x0010140AU  /* P55A */
#define GPIO_26_I2CA_SDA                  0x0010140BU  /* P55A */

#define GPIO_27_GPIO27                    0x00101600U  /* P55A */
#define GPIO_27_OUTPUTXBAR4               0x00101601U  /* P55A */
#define GPIO_27_EQEP2_STROBE              0x00101602U  /* P55A */
#define GPIO_27_SPIB_STE                  0x00101606U  /* P55A */
#define GPIO_27_SD2_C2                    0x00101607U  /* P55A */
#define GPIO_27_PMBUSA_ALERT              0x0010160AU  /* P55A */
#define GPIO_27_I2CA_SCL                  0x0010160BU  /* P55A */

#define GPIO_28_GPIO28                    0x00101800U  /* P55A */
#define GPIO_28_SCIA_RX                   0x00101801U  /* P55A */
#define GPIO_28_OUTPUTXBAR5               0x00101805U  /* P55A */
#define GPIO_28_EQEP1_A                   0x00101806U  /* P55A */
#define GPIO_28_SD2_D3                    0x00101807U  /* P55A */
#define GPIO_28_EQEP2_STROBE              0x00101809U  /* P55A */
#define GPIO_28_LINA_TX                   0x0010180AU  /* P55A */
#define GPIO_28_SPIB_CLK                  0x0010180BU  /* P55A */
#define GPIO_28_ERRORSTS                  0x0010180DU  /* P55A */
#define GPIO_28_I2CB_SDA                  0x0010180EU  /* P55A */

#define GPIO_29_GPIO29                    0x00101A00U  /* P55A */
#define GPIO_29_SCIA_TX                   0x00101A01U  /* P55A */
#define GPIO_29_OUTPUTXBAR6               0x00101A05U  /* P55A */
#define GPIO_29_EQEP1_B                   0x00101A06U  /* P55A */
#define GPIO_29_SD2_C3                    0x00101A07U  /* P55A */
#define GPIO_29_EQEP2_INDEX               0x00101A09U  /* P55A */
#define GPIO_29_LINA_RX                   0x00101A0AU  /* P55A */
#define GPIO_29_SPIB_STE                  0x00101A0BU  /* P55A */
#define GPIO_29_ERRORSTS                  0x00101A0DU  /* P55A */
#define GPIO_29_I2CB_SCL                  0x00101A0EU  /* P55A */

#define GPIO_30_GPIO30                    0x00101C00U  /* P55A */
#define GPIO_30_CANA_RX                   0x00101C01U  /* P55A */
#define GPIO_30_SPIB_SIMO                 0x00101C03U  /* P55A */
#define GPIO_30_OUTPUTXBAR7               0x00101C05U  /* P55A */
#define GPIO_30_EQEP1_STROBE              0x00101C06U  /* P55A */
#define GPIO_30_SD2_D4                    0x00101C07U  /* P55A */
//#define GPIO_30_CANA_RX                   0x00101C0AU  /* P55A */
#define GPIO_30_EPWM1_A                   0x00101C0BU  /* P55A */
#define GPIO_30_EQEP3_INDEX               0x00101C0DU  /* P55A */

#define GPIO_31_GPIO31                    0x00101E00U  /* P55A */
#define GPIO_31_CANA_TX                   0x00101E01U  /* P55A */
#define GPIO_31_SPIB_SOMI                 0x00101E03U  /* P55A */
#define GPIO_31_OUTPUTXBAR8               0x00101E05U  /* P55A */
#define GPIO_31_EQEP1_INDEX               0x00101E06U  /* P55A */
#define GPIO_31_SD2_C4                    0x00101E07U  /* P55A */
//#define GPIO_31_CANA_TX                   0x00101E0AU  /* P55A */
#define GPIO_31_EPWM1_B                   0x00101E0BU  /* P55A */

#define GPIO_32_GPIO32                    0x008C0000U  /* P55A */
#define GPIO_32_I2CA_SDA                  0x008C0001U  /* P55A */
#define GPIO_32_EQEP1_INDEX               0x008C0002U  /* P55A */
#define GPIO_32_SPIB_CLK                  0x008C0003U  /* P55A */
#define GPIO_32_LINA_TX                   0x008C0006U  /* P55A */
#define GPIO_32_SD1_D2                    0x008C0007U  /* P55A */
#define GPIO_32_CANB_TX                   0x008C000AU  /* P55A */
#define GPIO_32_PMBUSA_SDA                0x008C000BU  /* P55A */
#define GPIO_32_ADCSOCBO                  0x008C000DU  /* P55A */

#define GPIO_33_GPIO33                    0x008C0200U  /* P55A */
#define GPIO_33_I2CA_SCL                  0x008C0201U  /* P55A */
#define GPIO_33_SPIB_STE                  0x008C0203U  /* P55A */
#define GPIO_33_OUTPUTXBAR4               0x008C0205U  /* P55A */
#define GPIO_33_LINA_RX                   0x008C0206U  /* P55A */
#define GPIO_33_SD1_C2                    0x008C0207U  /* P55A */
#define GPIO_33_CANB_RX                   0x008C020AU  /* P55A */
#define GPIO_33_EQEP2_B                   0x008C020BU  /* P55A */
#define GPIO_33_ADCSOCAO                  0x008C020DU  /* P55A */
#define GPIO_33_SD1_C1                    0x008C020EU  /* P55A */
#define GPIO_33_SCIC_RX                   0x008C020FU  /* P55A */

#define GPIO_34_GPIO34                    0x008C0400U  /* P55A */
#define GPIO_34_OUTPUTXBAR1               0x008C0401U  /* P55A */
#define GPIO_34_PMBUSA_SDA                0x008C0406U  /* P55A */
#define GPIO_34_I2C1_SDA                  0x008C040EU  /* P55A */

#define GPIO_35_GPIO35                    0x008C0600U  /* P55A */
#define GPIO_35_SCIA_RX                   0x008C0601U  /* P55A */
#define GPIO_35_SPIA_SOMI                 0x008C0602U  /* P55A */
#define GPIO_35_I2CA_SDA                  0x008C0603U  /* P55A */
#define GPIO_35_CANB_RX                   0x008C0605U  /* P55A */
#define GPIO_35_PMBUSA_SCL                0x008C0606U  /* P55A */
#define GPIO_35_LINA_RX                   0x008C0607U  /* P55A */
#define GPIO_35_EQEP1_A                   0x008C0609U  /* P55A */
#define GPIO_35_PMBUSA_CTL                0x008C060AU  /* P55A */
#define GPIO_35_EPWM5_B                   0x008C060BU  /* P55A */
#define GPIO_35_TDI                       0x008C060FU  /* P55A */

#define GPIO_37_GPIO37                    0x008C0A00U  /* P55A */
#define GPIO_37_OUTPUTXBAR2               0x008C0A01U  /* P55A */
#define GPIO_37_SPIA_STE                  0x008C0A02U  /* P55A */
#define GPIO_37_I2CA_SCL                  0x008C0A03U  /* P55A */
#define GPIO_37_SCIA_TX                   0x008C0A05U  /* P55A */
#define GPIO_37_CANA_TX                   0x008C0A06U  /* P55A */
#define GPIO_37_LINA_TX                   0x008C0A07U  /* P55A */
#define GPIO_37_EQEP1_B                   0x008C0A09U  /* P55A */
#define GPIO_37_PMBUSA_ALERT              0x008C0A0AU  /* P55A */
#define GPIO_37_EPWM5_A                   0x008C0A0BU  /* P55A */
#define GPIO_37_TDO                       0x008C0A0FU  /* P55A */

#define GPIO_40_GPIO40                    0x008C1000U  /* P55A */
#define GPIO_40_SPIB_SIMO                 0x008C1001U  /* P55A */
#define GPIO_40_EPWM2_B                   0x008C1005U  /* P55A */
#define GPIO_40_PMBUSA_SDA                0x008C1006U  /* P55A */
#define GPIO_40_SCIB_TX                   0x008C1009U  /* P55A */
#define GPIO_40_EQEP1_A                   0x008C100AU  /* P55A */
#define GPIO_40_LINA_TX                   0x008C100BU  /* P55A */
#define GPIO_40_CLB_OUTPUTXBAR4           0x008C100EU  /* P55A */
#define GPIO_40_EQEP3_STROBE              0x008C100FU  /* P55A */

#define GPIO_41_GPIO41                    0x008C1200U  /* P55A */
#define GPIO_41_EPWM7_A                   0x008C1201U  /* P55A */
#define GPIO_41_EPWM2_A                   0x008C1205U  /* P55A */
#define GPIO_41_PMBUSA_SCL                0x008C1206U  /* P55A */
#define GPIO_41_SCIB_RX                   0x008C1209U  /* P55A */
#define GPIO_41_EQEP1_B                   0x008C120AU  /* P55A */
#define GPIO_41_LINA_RX                   0x008C120BU  /* P55A */
#define GPIO_41_SPIB_SOMI                 0x008C120EU  /* P55A */

#define GPIO_42_GPIO42                    0x008C1400U  /* P55A */
#define GPIO_42_LINA_RX                   0x008C1402U  /* P55A */
#define GPIO_42_OUTPUTXBAR5               0x008C1403U  /* P55A */
#define GPIO_42_PMBUSA_CTL                0x008C1405U  /* P55A */
#define GPIO_42_I2CA_SDA                  0x008C1406U  /* P55A */
#define GPIO_42_SCIC_RX                   0x008C1407U  /* P55A */
#define GPIO_42_EQEP1_STROBE              0x008C140AU  /* P55A */
#define GPIO_42_CLB_OUTPUTXBAR3           0x008C140BU  /* P55A */

#define GPIO_43_GPIO43                    0x008C1600U  /* P55A */
#define GPIO_43_OUTPUTXBAR6               0x008C1603U  /* P55A */
#define GPIO_43_PMBUSA_ALERT              0x008C1605U  /* P55A */
#define GPIO_43_I2CA_SCL                  0x008C1606U  /* P55A */
#define GPIO_43_SCIC_TX                   0x008C1607U  /* P55A */
#define GPIO_43_EQEP1_INDEX               0x008C160AU  /* P55A */
#define GPIO_43_CLB_OUTPUTXBAR4           0x008C160BU  /* P55A */
#define GPIO_43_SD2_D3                    0x008C160DU  /* P55A */

#define GPIO_44_GPIO44                    0x008C1800U  /* P55A */
#define GPIO_44_OUTPUTXBAR7               0x008C1803U  /* P55A */
#define GPIO_44_EQEP1_A                   0x008C1805U  /* P55A */
#define GPIO_44_PMBUSA_SDA                0x008C1806U  /* P55A */
#define GPIO_44_PMBUSA_CTL                0x008C1809U  /* P55A */
#define GPIO_44_CLB_OUTPUTXBAR3           0x008C180AU  /* P55A */
#define GPIO_44_LINA_TX                   0x008C180EU  /* P55A */

#define GPIO_45_GPIO45                    0x008C1A00U  /* P55A */
#define GPIO_45_OUTPUTXBAR8               0x008C1A03U  /* P55A */
#define GPIO_45_PMBUSA_ALERT              0x008C1A09U  /* P55A */
#define GPIO_45_CLB_OUTPUTXBAR4           0x008C1A0AU  /* P55A */
#define GPIO_45_SD2_C3                    0x008C1A0DU  /* P55A */

#define GPIO_46_GPIO46                    0x008C1C00U  /* P55A */
#define GPIO_46_LINA_TX                   0x008C1C03U  /* P55A */
#define GPIO_46_CANA_TX                   0x008C1C05U  /* P55A */
#define GPIO_46_PMBUSA_SDA                0x008C1C09U  /* P55A */
#define GPIO_46_SD2_C4                    0x008C1C0DU  /* P55A */

#define GPIO_62_GPIO62                    0x00901C00U  /* P55A */
#define GPIO_62_OUTPUTXBAR3               0x00901C02U  /* P55A */
#define GPIO_62_CANA_TX                   0x00901C05U  /* P55A */
#define GPIO_62_SCIA_TX                   0x00901C06U  /* P55A */
#define GPIO_62_PMBUSA_SDA                0x00901C09U  /* P55A */

#define GPIO_63_GPIO63                    0x00901E00U  /* P55A */
#define GPIO_63_OUTPUTXBAR4               0x00901E02U  /* P55A */
#define GPIO_63_CANA_RX                   0x00901E05U  /* P55A */
#define GPIO_63_SCIA_RX                   0x00901E06U  /* P55A */
#define GPIO_63_LINA_RX                   0x00901E09U  /* P55A */

#define GPIO_224_GPIO224                   0x038C0000U   /* P55A */
#define GPIO_224_SD2_D3                    0x038C0002U   /* P55A */
#define GPIO_224_OUTPUTXBAR3               0x038C0005U   /* P55A */
#define GPIO_224_SPIA_SIMO                 0x038C0006U   /* P55A */
#define GPIO_224_EPWM1_A                   0x038C0007U   /* P55A */
#define GPIO_224_CANA_TX                   0x038C000AU   /* P55A */
#define GPIO_224_EQEP1_A                   0x038C000BU   /* P55A */
#define GPIO_224_ADCC_EXTMUXSEL3           0x038C000DU   /* P55A */
#define GPIO_224_SCIC_TX                   0x038C000EU   /* P55A */

#define GPIO_225_GPIO225                   0x038C0200U   /* P55A */

#define GPIO_226_GPIO226                   0x038C0400U   /* P55A */
#define GPIO_226_SD2_D4                    0x038C0402U   /* P55A */
#define GPIO_226_LINA_RX                   0x038C0403U   /* P55A */
#define GPIO_226_EPWM6_A                   0x038C0405U   /* P55A */
#define GPIO_226_SPIA_CLK                  0x038C0406U   /* P55A */
#define GPIO_226_EPWM1_B                   0x038C0409U   /* P55A */
#define GPIO_226_EQEP1_STROBE              0x038C040BU   /* P55A */
#define GPIO_226_ADCC_EXTMUXSEL1           0x038C040DU   /* P55A */
#define GPIO_226_SCIC_RX                   0x038C040EU   /* P55A */

#define GPIO_227_GPIO227                   0x038C0600U   /* P55A */
#define GPIO_227_I2CB_SCL                  0x038C0601U   /* P55A */
#define GPIO_227_SD1_C3                    0x038C0602U   /* P55A */
#define GPIO_227_EPWM3_A                   0x038C0603U   /* P55A */
#define GPIO_227_OUTPUTXBAR1               0x038C0605U   /* P55A */
#define GPIO_227_EPWM2_B                   0x038C0606U   /* P55A */

#define GPIO_228_GPIO228                   0x038C0800U   /* P55A */
#define GPIO_228_SD2_C1                    0x038C0802U   /* P55A */
#define GPIO_228_ADCSOCAO                  0x038C0803U   /* P55A */
#define GPIO_228_CANA_TX                   0x038C0805U   /* P55A */
#define GPIO_228_SPIA_SOMI                 0x038C0806U   /* P55A */
#define GPIO_228_EPWM2_B                   0x038C0809U   /* P55A */
#define GPIO_228_EQEP1_B                   0x038C080BU   /* P55A */
#define GPIO_228_ADCC_EXTMUXSEL0           0x038C080DU   /* P55A */

#define GPIO_230_GPIO230                   0x038C0C00U   /* P55A */
#define GPIO_230_I2CB_SDA                  0x038C0C01U   /* P55A */
#define GPIO_230_SD1_C4                    0x038C0C02U   /* P55A */
#define GPIO_230_EPWM3_B                   0x038C0C03U   /* P55A */
#define GPIO_230_CANA_RX                   0x038C0C05U   /* P55A */
#define GPIO_230_EPWM2_A                   0x038C0C06U   /* P55A */
#define GPIO_230_I2CA_SDA                  0x038C0C07U   /* P55A */
#define GPIO_230_PMBUSA_SCL                0x038C0C09U   /* P55A */

#define GPIO_231_GPIO231                   0x038C0E00U   /* P55A */

#define GPIO_232_GPIO232                   0x038C1000U   /* P55A */

#define GPIO_233_GPIO233                   0x038C1200U   /* P55A */

#define GPIO_237_GPIO237                   0x038C1A00U   /* P55A */

#define GPIO_238_GPIO238                   0x038C1C00U   /* P55A */

#define GPIO_239_GPIO239                   0x038C1E00U   /* P55A */

#define GPIO_241_GPIO241                   0x03900200U   /* P55A */

#define GPIO_242_GPIO242                   0x03900400U   /* P55A */
#define GPIO_242_SD2_D2                    0x03900402U   /* P55A */
#define GPIO_242_OUTPUTXBAR2               0x03900405U   /* P55A */
#define GPIO_242_SPIA_STE                  0x03900406U   /* P55A */
#define GPIO_242_EPWM4_A                   0x03900409U   /* P55A */
#define GPIO_242_CANA_RX                   0x0390040AU   /* P55A */
#define GPIO_242_EQEP1_INDEX               0x0390040BU   /* P55A */
#define GPIO_242_ADCC_EXTMUXSEL2           0x0390040DU   /* P55A */

#define GPIO_244_GPIO244                   0x03900800U   /* P55A */

#define GPIO_245_GPIO245                   0x03900A00U   /* P55A */


#endif /* GS32_PART_NUM == 0x0550 */

#endif /* IS_GS32F00xx() */

#ifdef __cplusplus
}
#endif

#endif /* PINMAP_GS32FP55A_H_ */
