/* ========================================================================== */
/**
*   @file    regs_ahb1_comm_para.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the script to generate]
*
*/
/* ========================================================================== */
/**
 *  Copyright (C) Gejian Semiconductors 2023
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without 
 *  modification, are permitted provided that the following conditions 
 *  are met:
 * 
 *    Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer.
 * 
 *    Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the   
 *    distribution.
 * 
 *    Neither the name of Gejian Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
*/
/* ========================================================================== */

#ifndef REGS_AHB1_COMM_PARA_H
#define REGS_AHB1_COMM_PARA_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

// AHB1_COMM_PARA Individual Register Bit Definitions:

#if (EPWM_VERSION == 12) || (EPWM_VERSION == 22)
//
// Output sync signal selection
//
struct SYNCSELECT_BITS {			// bits   description
	uint32_t	rsvd1:18;			// 17:0   Reserved
	uint32_t	rsvd2:6;			// 23:18   Reserved
	uint32_t	SYNCSELSYNCOUT:5;			// 28:24   Select Syncout Source:
	uint32_t	rsvd3:3;			// 31:29   Reserved
};

union SYNCSELECT_REG {
	uint32_t 		 all;
	struct SYNCSELECT_BITS 		 bit;
};

//
// External ADCSOC Select Register
//
struct ADCSOCOUTSELECT_BITS {			// bits   description
	uint32_t	PWM1SOCAEN_25C_39C:1;			// 0:0   ADCSOCAOn source select:
	uint32_t	PWM2SOCAEN_25C_39C:1;			// 1:1   ADCSOCAOn source select:
	uint32_t	PWM3SOCAEN_25C_39C:1;			// 2:2   ADCSOCAOn source select:
	uint32_t	PWM4SOCAEN_25C_39C:1;			// 3:3   ADCSOCAOn source select:
	uint32_t	PWM5SOCAEN_25C_39C:1;			// 4:4   ADCSOCAOn source select:
	uint32_t	PWM6SOCAEN_25C_39C:1;			// 5:5   ADCSOCAOn source select:
	uint32_t	PWM7SOCAEN_25C_39C:1;			// 6:6   ADCSOCAOn source select:
	uint32_t	PWM8SOCAEN_25C_39C:1;			// 7:7   ADCSOCAOn source select:
	uint32_t	PWM9SOCAEN_25C_39C:1;			// 8:8   ADCSOCAOn source select:
	uint32_t	PWM10SOCAEN_25C_39C:1;			// 9:9   ADCSOCAOn source select:
	uint32_t	PWM11SOCAEN_25C_39C:1;			// 10:10   ADCSOCAOn source select:
	uint32_t	PWM12SOCAEN_25C_39C:1;			// 11:11   ADCSOCAOn source select:
	uint32_t	rsvd1:4;			// 15:12   Reserved
	uint32_t	PWM1SOCBEN_25C_39C:1;			// 16:16   ADCSOCBOn source select:
	uint32_t	PWM2SOCBEN_25C_39C:1;			// 17:17   ADCSOCBOn source select:
	uint32_t	PWM3SOCBEN_25C_39C:1;			// 18:18   ADCSOCBOn source select:
	uint32_t	PWM4SOCBEN_25C_39C:1;			// 19:19   ADCSOCBOn source select:
	uint32_t	PWM5SOCBEN_25C_39C:1;			// 20:20   ADCSOCBOn source select:
	uint32_t	PWM6SOCBEN_25C_39C:1;			// 21:21   ADCSOCBOn source select:
	uint32_t	PWM7SOCBEN_25C_39C:1;			// 22:22   ADCSOCBOn source select:
	uint32_t	PWM8SOCBEN_25C_39C:1;			// 23:23   ADCSOCBOn source select:
	uint32_t	PWM9SOCBEN_25C_39C:1;			// 24:24   ADCSOCBOn source select:
	uint32_t	PWM10SOCBEN_25C_39C:1;			// 25:25   ADCSOCBOn source select:
	uint32_t	PWM11SOCBEN_25C_39C:1;			// 26:26   ADCSOCBOn source select:
	uint32_t	PWM12SOCBEN_25C_39C:1;			// 27:27   ADCSOCBOn source select:
	uint32_t	rsvd2:4;			// 31:28   Reserved
};

union ADCSOCOUTSELECT_REG {
	uint32_t 		 all;
	struct ADCSOCOUTSELECT_BITS 		 bit;
};

#endif

//
// EPWM Time Base Clock sync
//
struct AHB_TBCLKSYNC_BITS {			// bits   description
	uint32_t	rsvd1:18;			// 17:0   Reserved
	uint32_t	TBCLKSYNC:1;			// 18:18   EPWM Time Base Clock sync: When set PWM time bases of 
	uint32_t	rsvd2:13;			// 31:19   Reserved
};

union AHB_TBCLKSYNC_REG {
	uint32_t 		 all;
	struct AHB_TBCLKSYNC_BITS 		 bit;
};

//
// SMP Data collection enable
//
struct SMP_EN_BITS {			// bits   description
	uint32_t	SMP_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union SMP_EN_REG {
	uint32_t 		 all;
	struct SMP_EN_BITS 		 bit;
};

//
// SMP Data collection Mode
//
struct SMP_MODE_BITS {			// bits   description
	uint32_t	SMP_MODE:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union SMP_MODE_REG {
	uint32_t 		 all;
	struct SMP_MODE_BITS 		 bit;
};

//
// SMP Data collection interval
//
struct SMP_GAP_BITS {			// bits   description
	uint32_t	SMP_GAP:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   Reserved
};

union SMP_GAP_REG {
	uint32_t 		 all;
	struct SMP_GAP_BITS 		 bit;
};

//
// SMP Data collection depth
//
struct SMP_LEN_BITS {			// bits   description
	uint32_t	SMP_LEN:14;			// 13:0   
	uint32_t	rsvd1:18;			// 31:14   Reserved
};

union SMP_LEN_REG {
	uint32_t 		 all;
	struct SMP_LEN_BITS 		 bit;
};


// AHB1_COMM_PARA Register Definitions:

struct AHB1_COMM_PARA_CFG_REGS {
#if (EPWM_VERSION == 12) || (EPWM_VERSION == 22)
	union  SYNCSELECT_REG			SYNCSELECT;
	union  ADCSOCOUTSELECT_REG			ADCSOCOUTSELECT;
#else
	uint32_t	RSVD1;
	uint32_t	RSVD2;
#endif
	uint32_t 						rsvd1[15]; 		 // Reserved
	union  AHB_TBCLKSYNC_REG		TBCLKSYNC;
	uint32_t 						rsvd2[14]; 		 // Reserved
	union  SMP_EN_REG			SMP_EN;
	union  SMP_MODE_REG			SMP_MODE;
	union  SMP_GAP_REG			SMP_GAP;
	union  SMP_LEN_REG			SMP_LEN;
};


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */

// AHB1_COMM_PARA External References & Function Declarations

extern volatile struct AHB1_COMM_PARA_CFG_REGS AHB1COMMPARACFGRegs;


#ifdef __cplusplus
}
#endif      /* extern "C" */


#endif      // end of REGS_AHB1_COMM_PARA_H definition

/* ========================================================================== */
/*                                  End of file                               */
/* ========================================================================== */
