/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_clbxbar.h
*   @brief
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef __REGS_CLBXBAR_H__
#define __REGS_CLBXBAR_H__

#include "gs32_version.h"

#ifdef __cplusplus
extern "C" {
#endif


//---------------------------------------------------------------------------
// CLBXBAR Individual Register Bit Definitions:

struct AUXSIG0MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG0 of CLB-XBAR
};

union AUXSIG0MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG0MUX0TO15CFG_BITS  bit;
};

struct AUXSIG0MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG0 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG0 of CLB-XBAR
};

union AUXSIG0MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG0MUX16TO31CFG_BITS  bit;
};

struct AUXSIG1MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG1 of CLB-XBAR
};

union AUXSIG1MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG1MUX0TO15CFG_BITS  bit;
};

struct AUXSIG1MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG1 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG1 of CLB-XBAR
};

union AUXSIG1MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG1MUX16TO31CFG_BITS  bit;
};

struct AUXSIG2MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG2 of CLB-XBAR
};

union AUXSIG2MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG2MUX0TO15CFG_BITS  bit;
};

struct AUXSIG2MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG2 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG2 of CLB-XBAR
};

union AUXSIG2MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG2MUX16TO31CFG_BITS  bit;
};

struct AUXSIG3MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG3 of CLB-XBAR
};

union AUXSIG3MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG3MUX0TO15CFG_BITS  bit;
};

struct AUXSIG3MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG3 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG3 of CLB-XBAR
};

union AUXSIG3MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG3MUX16TO31CFG_BITS  bit;
};

struct AUXSIG4MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG4 of CLB-XBAR
};

union AUXSIG4MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG4MUX0TO15CFG_BITS  bit;
};

struct AUXSIG4MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG4 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG4 of CLB-XBAR
};

union AUXSIG4MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG4MUX16TO31CFG_BITS  bit;
};

struct AUXSIG5MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG5 of CLB-XBAR
};

union AUXSIG5MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG5MUX0TO15CFG_BITS  bit;
};

struct AUXSIG5MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG5 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG5 of CLB-XBAR
};

union AUXSIG5MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG5MUX16TO31CFG_BITS  bit;
};

struct AUXSIG6MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG6 of CLB-XBAR
};

union AUXSIG6MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG6MUX0TO15CFG_BITS  bit;
};

struct AUXSIG6MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG6 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG6 of CLB-XBAR
};

union AUXSIG6MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG6MUX16TO31CFG_BITS  bit;
};

struct AUXSIG7MUX0TO15CFG_BITS {        // bits description
    uint32_t MUX0:2;                      // 1:0 MUX0 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX1:2;                      // 3:2 MUX1 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX2:2;                      // 5:4 MUX2 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX3:2;                      // 7:6 MUX3 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX4:2;                      // 9:8 MUX4 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX5:2;                      // 11:10 MUX5 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX6:2;                      // 13:12 MUX6 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX7:2;                      // 15:14 MUX7 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX8:2;                      // 17:16 MUX8 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX9:2;                      // 19:18 MUX9 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX10:2;                     // 21:20 MUX10 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX11:2;                     // 23:22 MUX11 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX12:2;                     // 25:24 MUX12 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX13:2;                     // 27:26 MUX13 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX14:2;                     // 29:28 MUX14 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX15:2;                     // 31:30 MUX15 Configuration for AUXSIG7 of CLB-XBAR
};

union AUXSIG7MUX0TO15CFG_REG {
    uint32_t  all;
    struct  AUXSIG7MUX0TO15CFG_BITS  bit;
};

struct AUXSIG7MUX16TO31CFG_BITS {       // bits description
    uint32_t MUX16:2;                     // 1:0 MUX16 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX17:2;                     // 3:2 MUX17 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX18:2;                     // 5:4 MUX18 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX19:2;                     // 7:6 MUX19 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX20:2;                     // 9:8 MUX20 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX21:2;                     // 11:10 MUX21 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX22:2;                     // 13:12 MUX22 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX23:2;                     // 15:14 MUX23 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX24:2;                     // 17:16 MUX24 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX25:2;                     // 19:18 MUX25 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX26:2;                     // 21:20 MUX26 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX27:2;                     // 23:22 MUX27 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX28:2;                     // 25:24 MUX28 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX29:2;                     // 27:26 MUX29 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX30:2;                     // 29:28 MUX30 Configuration for AUXSIG7 of CLB-XBAR
    uint32_t MUX31:2;                     // 31:30 MUX31 Configuration for AUXSIG7 of CLB-XBAR
};

union AUXSIG7MUX16TO31CFG_REG {
    uint32_t  all;
    struct  AUXSIG7MUX16TO31CFG_BITS  bit;
};

struct AUXSIG0MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG0 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG0 of CLB-XBAR
};

union AUXSIG0MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG0MUXENABLE_BITS  bit;
};

struct AUXSIG1MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG1 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG1 of CLB-XBAR
};

union AUXSIG1MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG1MUXENABLE_BITS  bit;
};

struct AUXSIG2MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG2 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG2 of CLB-XBAR
};

union AUXSIG2MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG2MUXENABLE_BITS  bit;
};

struct AUXSIG3MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG3 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG3 of CLB-XBAR
};

union AUXSIG3MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG3MUXENABLE_BITS  bit;
};

struct AUXSIG4MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG4 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG4 of CLB-XBAR
};

union AUXSIG4MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG4MUXENABLE_BITS  bit;
};

struct AUXSIG5MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG5 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG5 of CLB-XBAR
};

union AUXSIG5MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG5MUXENABLE_BITS  bit;
};

struct AUXSIG6MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG6 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG6 of CLB-XBAR
};

union AUXSIG6MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG6MUXENABLE_BITS  bit;
};

struct AUXSIG7MUXENABLE_BITS {          // bits description
    uint32_t MUX0:1;                      // 0 mux0 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX1:1;                      // 1 MUX1 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX2:1;                      // 2 MUX2 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX3:1;                      // 3 MUX3 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX4:1;                      // 4 MUX4 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX5:1;                      // 5 MUX5 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX6:1;                      // 6 MUX6 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX7:1;                      // 7 MUX7 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX8:1;                      // 8 MUX8 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX9:1;                      // 9 MUX9 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX10:1;                     // 10 MUX10 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX11:1;                     // 11 MUX11 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX12:1;                     // 12 MUX12 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX13:1;                     // 13 MUX13 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX14:1;                     // 14 MUX14 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX15:1;                     // 15 MUX15 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX16:1;                     // 16 MUX16 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX17:1;                     // 17 MUX17 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX18:1;                     // 18 MUX18 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX19:1;                     // 19 MUX19 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX20:1;                     // 20 MUX20 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX21:1;                     // 21 MUX21 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX22:1;                     // 22 MUX22 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX23:1;                     // 23 MUX23 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX24:1;                     // 24 MUX24 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX25:1;                     // 25 MUX25 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX26:1;                     // 26 MUX26 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX27:1;                     // 27 MUX27 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX28:1;                     // 28 MUX28 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX29:1;                     // 29 MUX29 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX30:1;                     // 30 MUX30 to drive AUXSIG7 of CLB-XBAR
    uint32_t MUX31:1;                     // 31 MUX31 to drive AUXSIG7 of CLB-XBAR
};

union AUXSIG7MUXENABLE_REG {
    uint32_t  all;
    struct  AUXSIG7MUXENABLE_BITS  bit;
};

struct AUXSIG8MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union AUXSIG8MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct AUXSIG8MUX0TO15CFG_BITS 		 bit;
};

struct AUXSIG8MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union AUXSIG8MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct AUXSIG8MUX16TO31CFG_BITS 		 bit;
};

struct AUXSIG9MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union AUXSIG9MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct AUXSIG9MUX0TO15CFG_BITS 		 bit;
};

struct AUXSIG9MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union AUXSIG9MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct AUXSIG9MUX16TO31CFG_BITS 		 bit;
};

struct AUXSIG10MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union AUXSIG10MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct AUXSIG10MUX0TO15CFG_BITS 		 bit;
};

struct AUXSIG10MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union AUXSIG10MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct AUXSIG10MUX16TO31CFG_BITS 		 bit;
};

struct AUXSIG11MUX0TO15CFG_BITS {			// bits   description
	uint32_t	MUX0:2;			// 1:0   
	uint32_t	MUX1:2;			// 3:2   
	uint32_t	MUX2:2;			// 5:4   
	uint32_t	MUX3:2;			// 7:6   
	uint32_t	MUX4:2;			// 9:8   
	uint32_t	MUX5:2;			// 11:10   
	uint32_t	MUX6:2;			// 13:12   
	uint32_t	MUX7:2;			// 15:14   
	uint32_t	MUX8:2;			// 17:16   
	uint32_t	MUX9:2;			// 19:18   
	uint32_t	MUX10:2;			// 21:20   
	uint32_t	MUX11:2;			// 23:22   
	uint32_t	MUX12:2;			// 25:24   
	uint32_t	MUX13:2;			// 27:26   
	uint32_t	MUX14:2;			// 29:28   
	uint32_t	MUX15:2;			// 31:30   
};

union AUXSIG11MUX0TO15CFG_REG {
	uint32_t 		 all;
	struct AUXSIG11MUX0TO15CFG_BITS 		 bit;
};

struct AUXSIG11MUX16TO31CFG_BITS {			// bits   description
	uint32_t	MUX16:2;			// 1:0   
	uint32_t	MUX17:2;			// 3:2   
	uint32_t	MUX18:2;			// 5:4   
	uint32_t	MUX19:2;			// 7:6   
	uint32_t	MUX20:2;			// 9:8   
	uint32_t	MUX21:2;			// 11:10   
	uint32_t	MUX22:2;			// 13:12   
	uint32_t	MUX23:2;			// 15:14   
	uint32_t	MUX24:2;			// 17:16   
	uint32_t	MUX25:2;			// 19:18   
	uint32_t	MUX26:2;			// 21:20   
	uint32_t	MUX27:2;			// 23:22   
	uint32_t	MUX28:2;			// 25:24   
	uint32_t	MUX29:2;			// 27:26   
	uint32_t	MUX30:2;			// 29:28   
	uint32_t	MUX31:2;			// 31:30   
};

union AUXSIG11MUX16TO31CFG_REG {
	uint32_t 		 all;
	struct AUXSIG11MUX16TO31CFG_BITS 		 bit;
};

struct AUXSIG8MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union AUXSIG8MUXENABLE_REG {
	uint32_t 		 all;
	struct AUXSIG8MUXENABLE_BITS 		 bit;
};

struct AUXSIG9MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union AUXSIG9MUXENABLE_REG {
	uint32_t 		 all;
	struct AUXSIG9MUXENABLE_BITS 		 bit;
};

struct AUXSIG10MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union AUXSIG10MUXENABLE_REG {
	uint32_t 		 all;
	struct AUXSIG10MUXENABLE_BITS 		 bit;
};

struct AUXSIG11MUXENABLE_BITS {			// bits   description
	uint32_t	MUX0:1;			// 0:0   
	uint32_t	MUX1:1;			// 1:1   
	uint32_t	MUX2:1;			// 2:2   
	uint32_t	MUX3:1;			// 3:3   
	uint32_t	MUX4:1;			// 4:4   
	uint32_t	MUX5:1;			// 5:5   
	uint32_t	MUX6:1;			// 6:6   
	uint32_t	MUX7:1;			// 7:7   
	uint32_t	MUX8:1;			// 8:8   
	uint32_t	MUX9:1;			// 9:9   
	uint32_t	MUX10:1;			// 10:10   
	uint32_t	MUX11:1;			// 11:11   
	uint32_t	MUX12:1;			// 12:12   
	uint32_t	MUX13:1;			// 13:13   
	uint32_t	MUX14:1;			// 14:14   
	uint32_t	MUX15:1;			// 15:15   
	uint32_t	MUX16:1;			// 16:16   
	uint32_t	MUX17:1;			// 17:17   
	uint32_t	MUX18:1;			// 18:18   
	uint32_t	MUX19:1;			// 19:19   
	uint32_t	MUX20:1;			// 20:20   
	uint32_t	MUX21:1;			// 21:21   
	uint32_t	MUX22:1;			// 22:22   
	uint32_t	MUX23:1;			// 23:23   
	uint32_t	MUX24:1;			// 24:24   
	uint32_t	MUX25:1;			// 25:25   
	uint32_t	MUX26:1;			// 26:26   
	uint32_t	MUX27:1;			// 27:27   
	uint32_t	MUX28:1;			// 28:28   
	uint32_t	MUX29:1;			// 29:29   
	uint32_t	MUX30:1;			// 30:30   
	uint32_t	MUX31:1;			// 31:31   
};

union AUXSIG11MUXENABLE_REG {
	uint32_t 		 all;
	struct AUXSIG11MUXENABLE_BITS 		 bit;
};

/**add mux32-mux64 base GS32F3xx*/
struct AUXSIG0MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG0MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG0MUX32TO47CFG_BITS  bit;
};

struct AUXSIG0MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG0MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG0MUX48TO63CFG_BITS  bit;
};

struct AUXSIG1MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG1MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG1MUX32TO47CFG_BITS  bit;
};

struct AUXSIG1MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG1MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG1MUX48TO63CFG_BITS  bit;
};

struct AUXSIG2MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG2MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG2MUX32TO47CFG_BITS  bit;
};

struct AUXSIG2MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG2MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG2MUX48TO63CFG_BITS  bit;
};

struct AUXSIG3MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG3MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG3MUX32TO47CFG_BITS  bit;
};

struct AUXSIG3MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                   
};

union AUXSIG3MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG3MUX48TO63CFG_BITS  bit;
};

struct AUXSIG4MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG4MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG4MUX32TO47CFG_BITS  bit;
};

struct AUXSIG4MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG4MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG4MUX48TO63CFG_BITS  bit;
};

struct AUXSIG5MUX32TO47CFG_BITS {          
    uint32_t MUX32:2;                    
    uint32_t MUX33:2;                    
    uint32_t MUX34:2;                    
    uint32_t MUX35:2;                    
    uint32_t MUX36:2;                    
    uint32_t MUX37:2;                    
    uint32_t MUX38:2;                    
    uint32_t MUX39:2;                    
    uint32_t MUX40:2;                    
    uint32_t MUX41:2;                    
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG5MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG5MUX32TO47CFG_BITS  bit;
};

struct AUXSIG5MUX48TO63CFG_BITS {        
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG5MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG5MUX48TO63CFG_BITS  bit;
};

struct AUXSIG6MUX32TO47CFG_BITS {        
    uint32_t MUX32:2;                   
    uint32_t MUX33:2;                   
    uint32_t MUX34:2;                   
    uint32_t MUX35:2;                   
    uint32_t MUX36:2;                   
    uint32_t MUX37:2;                   
    uint32_t MUX38:2;                   
    uint32_t MUX39:2;                   
    uint32_t MUX40:2;                
    uint32_t MUX41:2;                
    uint32_t MUX42:2;                
    uint32_t MUX43:2;                
    uint32_t MUX44:2;                
    uint32_t MUX45:2;                
    uint32_t MUX46:2;                
    uint32_t MUX47:2;                
};

union AUXSIG6MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG6MUX32TO47CFG_BITS  bit;
};

struct AUXSIG6MUX48TO63CFG_BITS {      
    uint32_t MUX48:2;                    
    uint32_t MUX49:2;                    
    uint32_t MUX50:2;                    
    uint32_t MUX51:2;                    
    uint32_t MUX52:2;                    
    uint32_t MUX53:2;                    
    uint32_t MUX54:2;                    
    uint32_t MUX55:2;                    
    uint32_t MUX56:2;                    
    uint32_t MUX57:2;                    
    uint32_t MUX58:2;                    
    uint32_t MUX59:2;                    
    uint32_t MUX60:2;                    
    uint32_t MUX61:2;                    
    uint32_t MUX62:2;                    
    uint32_t MUX63:2;                    
};

union AUXSIG6MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG6MUX48TO63CFG_BITS  bit;
};

struct AUXSIG7MUX32TO47CFG_BITS {         
    uint32_t MUX32:2;                     
    uint32_t MUX33:2;                     
    uint32_t MUX34:2;                     
    uint32_t MUX35:2;                     
    uint32_t MUX36:2;                     
    uint32_t MUX37:2;                     
    uint32_t MUX38:2;                     
    uint32_t MUX39:2;                     
    uint32_t MUX40:2;                     
    uint32_t MUX41:2;                     
    uint32_t MUX42:2;                    
    uint32_t MUX43:2;                    
    uint32_t MUX44:2;                    
    uint32_t MUX45:2;                    
    uint32_t MUX46:2;                    
    uint32_t MUX47:2;                    
};

union AUXSIG7MUX32TO47CFG_REG {
    uint32_t  all;
    struct  AUXSIG7MUX32TO47CFG_BITS  bit;
};

struct AUXSIG7MUX48TO63CFG_BITS {       
    uint32_t MUX48:2;                     
    uint32_t MUX49:2;                     
    uint32_t MUX50:2;                     
    uint32_t MUX51:2;                     
    uint32_t MUX52:2;                     
    uint32_t MUX53:2;                     
    uint32_t MUX54:2;                     
    uint32_t MUX55:2;                     
    uint32_t MUX56:2;                     
    uint32_t MUX57:2;                     
    uint32_t MUX58:2;                     
    uint32_t MUX59:2;                     
    uint32_t MUX60:2;                     
    uint32_t MUX61:2;                     
    uint32_t MUX62:2;                     
    uint32_t MUX63:2;                     
};

union AUXSIG7MUX48TO63CFG_REG {
    uint32_t  all;
    struct  AUXSIG7MUX48TO63CFG_BITS  bit;
};

//MUX ENABLE
struct AUXSIG0MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG0MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG0MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG1MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG1MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG1MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG2MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG2MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG2MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG3MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG3MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG3MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG4MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG4MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG4MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG5MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG5MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG5MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG6MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG6MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG6MUXENABLE32TO64_BITS  bit;
};

struct AUXSIG7MUXENABLE32TO64_BITS {      
    uint32_t MUX32:1;                     
    uint32_t MUX33:1;                     
    uint32_t MUX34:1;                     
    uint32_t MUX35:1;                     
    uint32_t MUX36:1;                     
    uint32_t MUX37:1;                     
    uint32_t MUX38:1;                     
    uint32_t MUX39:1;                     
    uint32_t MUX40:1;                     
    uint32_t MUX41:1;                     
    uint32_t MUX42:1;                     
    uint32_t MUX43:1;                     
    uint32_t MUX44:1;                     
    uint32_t MUX45:1;                     
    uint32_t MUX46:1;                     
    uint32_t MUX47:1;                     
    uint32_t MUX48:1;                     
    uint32_t MUX49:1;                     
    uint32_t MUX50:1;                     
    uint32_t MUX51:1;                     
    uint32_t MUX52:1;                     
    uint32_t MUX53:1;                     
    uint32_t MUX54:1;                     
    uint32_t MUX55:1;                     
    uint32_t MUX56:1;                     
    uint32_t MUX57:1;                     
    uint32_t MUX58:1;                     
    uint32_t MUX59:1;                     
    uint32_t MUX60:1;                     
    uint32_t MUX61:1;                     
    uint32_t MUX62:1;                     
    uint32_t MUX63:1;                     
};

union AUXSIG7MUXENABLE32TO64_REG {
    uint32_t  all;
    struct  AUXSIG7MUXENABLE32TO64_BITS  bit;
};


struct AUXSIGOUTINV_BITS {              // bits description
    uint32_t OUT0:1;                      // 0 Selects polarity for AUXSIG0 of CLB-XBAR
    uint32_t OUT1:1;                      // 1 Selects polarity for AUXSIG1 of CLB-XBAR
    uint32_t OUT2:1;                      // 2 Selects polarity for AUXSIG2 of CLB-XBAR
    uint32_t OUT3:1;                      // 3 Selects polarity for AUXSIG3 of CLB-XBAR
    uint32_t OUT4:1;                      // 4 Selects polarity for AUXSIG4 of CLB-XBAR
    uint32_t OUT5:1;                      // 5 Selects polarity for AUXSIG5 of CLB-XBAR
    uint32_t OUT6:1;                      // 6 Selects polarity for AUXSIG6 of CLB-XBAR
    uint32_t OUT7:1;                      // 7 Selects polarity for AUXSIG7 of CLB-XBAR
    uint32_t rsvd1:8;                     // 15:8 Reserved
    uint32_t rsvd2:16;                    // 31:16 Reserved
};

union AUXSIGOUTINV_REG {
    uint32_t  all;
    struct  AUXSIGOUTINV_BITS  bit;
};

struct AUXSIGLOCK_BITS {                // bits description
    uint32_t LOCK:1;                      // 0 Locks the configuration for CLB-XBAR
    uint32_t rsvd1:15;                    // 15:1 Reserved
    uint32_t KEY:16;                      // 31:16 Write Protection KEY
};

union AUXSIGLOCK_REG {
    uint32_t  all;
    struct  AUXSIGLOCK_BITS  bit;
};

struct CLB_XBAR_REGS {
    union  AUXSIG0MUX0TO15CFG_REG			AUXSIG0MUX0TO15CFG;
	union  AUXSIG0MUX16TO31CFG_REG			AUXSIG0MUX16TO31CFG;
	union  AUXSIG1MUX0TO15CFG_REG			AUXSIG1MUX0TO15CFG;
	union  AUXSIG1MUX16TO31CFG_REG			AUXSIG1MUX16TO31CFG;
	union  AUXSIG2MUX0TO15CFG_REG			AUXSIG2MUX0TO15CFG;
	union  AUXSIG2MUX16TO31CFG_REG			AUXSIG2MUX16TO31CFG;
	union  AUXSIG3MUX0TO15CFG_REG			AUXSIG3MUX0TO15CFG;
	union  AUXSIG3MUX16TO31CFG_REG			AUXSIG3MUX16TO31CFG;
	union  AUXSIG4MUX0TO15CFG_REG			AUXSIG4MUX0TO15CFG;
	union  AUXSIG4MUX16TO31CFG_REG			AUXSIG4MUX16TO31CFG;
	union  AUXSIG5MUX0TO15CFG_REG			AUXSIG5MUX0TO15CFG;
	union  AUXSIG5MUX16TO31CFG_REG			AUXSIG5MUX16TO31CFG;
	union  AUXSIG6MUX0TO15CFG_REG			AUXSIG6MUX0TO15CFG;
	union  AUXSIG6MUX16TO31CFG_REG			AUXSIG6MUX16TO31CFG;
	union  AUXSIG7MUX0TO15CFG_REG			AUXSIG7MUX0TO15CFG;
	union  AUXSIG7MUX16TO31CFG_REG			AUXSIG7MUX16TO31CFG;
	union  AUXSIG0MUXENABLE_REG			    AUXSIG0MUXENABLE;
	union  AUXSIG1MUXENABLE_REG			    AUXSIG1MUXENABLE;
	union  AUXSIG2MUXENABLE_REG			    AUXSIG2MUXENABLE;
	union  AUXSIG3MUXENABLE_REG			    AUXSIG3MUXENABLE;
	union  AUXSIG4MUXENABLE_REG			    AUXSIG4MUXENABLE;
	union  AUXSIG5MUXENABLE_REG			    AUXSIG5MUXENABLE;
	union  AUXSIG6MUXENABLE_REG			    AUXSIG6MUXENABLE;
	union  AUXSIG7MUXENABLE_REG			    AUXSIG7MUXENABLE;
    union  AUXSIGOUTINV_REG			        AUXSIGOUTINV;
    uint32_t                                   rsvd1[3];
    union   AUXSIG0MUX32TO47CFG_REG         AUXSIG0MUX32TO47CFG;
    union   AUXSIG0MUX48TO63CFG_REG         AUXSIG0MUX48TO63CFG;
    union   AUXSIG1MUX32TO47CFG_REG         AUXSIG1MUX32TO47CFG;
    union   AUXSIG1MUX48TO63CFG_REG         AUXSIG1MUX48TO63CFG;
    union   AUXSIG2MUX32TO47CFG_REG         AUXSIG2MUX32TO47CFG;
    union   AUXSIG2MUX48TO63CFG_REG         AUXSIG2MUX48TO63CFG;
    union   AUXSIG3MUX32TO47CFG_REG         AUXSIG3MUX32TO47CFG;
    union   AUXSIG3MUX48TO63CFG_REG         AUXSIG3MUX48TO63CFG;
    union   AUXSIG4MUX32TO47CFG_REG         AUXSIG4MUX32TO47CFG;
    union   AUXSIG4MUX48TO63CFG_REG         AUXSIG4MUX48TO63CFG;
    union   AUXSIG5MUX32TO47CFG_REG         AUXSIG5MUX32TO47CFG;
    union   AUXSIG5MUX48TO63CFG_REG         AUXSIG5MUX48TO63CFG;
    union   AUXSIG6MUX32TO47CFG_REG         AUXSIG6MUX32TO47CFG;
    union   AUXSIG6MUX48TO63CFG_REG         AUXSIG6MUX48TO63CFG;
    union   AUXSIG7MUX32TO47CFG_REG         AUXSIG7MUX32TO47CFG;
    union   AUXSIG7MUX48TO63CFG_REG         AUXSIG7MUX48TO63CFG;
    union   AUXSIG0MUXENABLE32TO64_REG      AUXSIG0MUXENABLE32TO64; 
    union   AUXSIG1MUXENABLE32TO64_REG      AUXSIG1MUXENABLE32TO64; 
    union   AUXSIG2MUXENABLE32TO64_REG      AUXSIG2MUXENABLE32TO64; 
    union   AUXSIG3MUXENABLE32TO64_REG      AUXSIG3MUXENABLE32TO64; 
    union   AUXSIG4MUXENABLE32TO64_REG      AUXSIG4MUXENABLE32TO64; 
    union   AUXSIG5MUXENABLE32TO64_REG      AUXSIG5MUXENABLE32TO64; 
    union   AUXSIG6MUXENABLE32TO64_REG      AUXSIG6MUXENABLE32TO64; 
    union   AUXSIG7MUXENABLE32TO64_REG      AUXSIG7MUXENABLE32TO64; 

	uint32_t 						        rsvd2[7]; 		 // reserved
    union   AUXSIGLOCK_REG                  AUXSIGLOCK;                   // ClbXbar Configuration Lock register
    
};

//---------------------------------------------------------------------------
// CLBXBAR External References & Function Declarations:
//
extern volatile struct CLB_XBAR_REGS PluXbarRegs;
#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif

/*===========================================================================
 * End of file.
 *===========================================================================*/
