/*
 *   Copyright (c) Gejian Semiconductors 2025
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_cmpss.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_CMPSS_LITE_H
#define REGS_CMPSS_LITE_H
#include "gs32_version.h"
#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
//---------------------------------------------------------------------------
// CMPSS_LITE Individual Register Bit Definitions:
#if IS_GS32F00xx(0x30)
struct COMPCTL_LITE_BITS {                   // bits description
    uint16_t COMPHSOURCE:1;               // 0 High Comparator Source Select
    uint16_t COMPHINV:1;                  // 1 High Comparator Invert Select
    uint16_t CTRIPHSEL:2;                 // 3:2 High Comparator Trip Select
    uint16_t CTRIPOUTHSEL:2;              // 5:4 High Comparator Trip Output Select
    uint16_t ASYNCHEN:1;                  // 6 High Comparator Asynchronous Path Enable
    uint16_t rsvd1:1;                     // 7 Reserved
    uint16_t COMPLSOURCE:1;               // 8 Low Comparator Source Select
    uint16_t COMPLINV:1;                  // 9 Low Comparator Invert Select
    uint16_t CTRIPLSEL:2;                 // 11:10 Low Comparator Trip Select
    uint16_t CTRIPOUTLSEL:2;              // 13:12 Low Comparator Trip Output Select
    uint16_t ASYNCLEN:1;                  // 14 Low Comparator Asynchronous Path Enable
    uint16_t COMPDACE:1;                  // 15 Comparator/DAC Enable
};

union COMPCTL_LITE_REG {
    uint16_t  all;
    struct  COMPCTL_LITE_BITS  bit;
};

struct COMPHYSCTL_LITE_BITS {                // bits description
    uint16_t COMPHYS:4;                   // 3:0 Comparator Hysteresis Trim
    uint16_t rsvd1:12;                    // 15:4 Reserved
};

union COMPHYSCTL_LITE_REG {
    uint16_t  all;
    struct  COMPHYSCTL_LITE_BITS  bit;
};

struct COMPSTS_LITE_BITS {                   // bits description
    uint16_t COMPHSTS:1;                  // 0 High Comparator Status
    uint16_t COMPHLATCH:1;                // 1 High Comparator Latched Status
    uint16_t rsvd1:6;                     // 7:2 Reserved
    uint16_t COMPLSTS:1;                  // 8 Low Comparator Status
    uint16_t COMPLLATCH:1;                // 9 Low Comparator Latched Status
    uint16_t rsvd2:6;                     // 15:10 Reserved
};

union COMPSTS_LITE_REG {
    uint16_t  all;
    struct  COMPSTS_LITE_BITS  bit;
};

struct COMPSTSCLR_LITE_BITS {                // bits description
    uint16_t rsvd1:1;                     // 0 Reserved
    uint16_t HLATCHCLR:1;                 // 1 High Comparator Latched Status Clear
    uint16_t HSYNCCLREN:1;                // 2 High Comparator EPWMSYNCPER Clear Enable
    uint16_t rsvd2:6;                     // 8:3 Reserved
    uint16_t LLATCHCLR:1;                 // 9 Low Comparator Latched Status Clear
    uint16_t LSYNCCLREN:1;                // 10 Low Comparator EPWMSYNCPER Clear Enable
    uint16_t rsvd3:5;                     // 15:11 Reserved
};

union COMPSTSCLR_LITE_REG {
    uint16_t  all;
    struct  COMPSTSCLR_LITE_BITS  bit;
};

struct COMPDACHCTL_LITE_BITS {                // bits description
	uint16_t DACSOURCE:1;                 // 0 DAC Source Control
	uint16_t RAMPSOURCE:4;                // 4:1 Ramp Generator Source Control
	uint16_t SELREF:1;                    // 5 DAC Reference Select
	uint16_t RAMPLOADSEL:1;               // 6 Ramp Load Select
	uint16_t SWLOADSEL:1;                 // 7 Software Load Select
	uint16_t BLANKSOURCE:4;               // 11:8 EPWMBLANK Source Select
	uint16_t BLANKEN:1;                   // 12 EPWMBLANK Enable
	uint16_t RAMPDIR:1;                     //13 High Ramp Generator Direction control bit. 0 Decrementing Ramp.1 Incrementing Ramp.
	uint16_t FREESOFT:2;                  // 15:14 Free/Soft Emulation Bits
};
union COMPDACHCTL_LITE_REG{
	uint16_t  all;
    struct  COMPDACHCTL_LITE_BITS  bit;
};

struct DACHVALS_LITE_BITS {                  // bits description
    uint16_t DACVAL:12;                   // 11:0 DAC Value Control
    uint16_t rsvd1:4;                     // 15:12 Reserved
};

union DACHVALS_LITE_REG {
    uint16_t  all;
    struct  DACHVALS_LITE_BITS  bit;
};

struct DACHVALA_LITE_BITS {                  // bits description
    uint16_t DACVAL:12;                   // 11:0 DAC Value Control
    uint16_t rsvd1:4;                     // 15:12 Reserved
};

union DACHVALA_LITE_REG {
    uint16_t  all;
    struct  DACHVALA_LITE_BITS  bit;
};

struct DACLVALS_LITE_BITS {                  // bits description
    uint16_t DACVAL:12;                   // 11:0 DAC Value Control
    uint16_t rsvd1:4;                     // 15:12 Reserved
};

union DACLVALS_LITE_REG {
    uint16_t  all;
    struct  DACLVALS_LITE_BITS  bit;
};

struct DACLVALA_LITE_BITS {                  // bits description
    uint16_t DACVAL:12;                   // 11:0 DAC Value Control
    uint16_t rsvd1:4;                     // 15:12 Reserved
};

union DACLVALA_LITE_REG {
    uint16_t  all;
    struct  DACLVALA_LITE_BITS  bit;
};

struct CTRIPLFILCTL_LITE_BITS {              // bits description
	uint16_t FILTINSEL:3;                     // 2:0 0 Selects the COMPL output as the filter input 1 Selects the external signal EXT_FILTIN_L[1] as the filter input   7....
	uint16_t SAMPWIN:6;                   // 8:3 Low filter sample window size. Number of samples to monitor is SAMPWIN+1.
	uint16_t THRESH:6;                    // 14:9 Low filter majority voting threshold. At least THRESH samples of the opposite state must appear within the sample window in order for the output to change state. Threshold used is THRESH+1.
	uint16_t FILINIT:1;                      // 15 Filter Initialization Bit
};

union CTRIPLFILCTL_LITE_REG {
    uint16_t  all;
    struct  CTRIPLFILCTL_LITE_BITS  bit;
};

struct CTRIPHFILCTL_LITE_BITS {              // bits description
	uint16_t FILTINSEL:3;                   // 2:0 Reserved
    uint16_t SAMPWIN:6;               // 8:3 Sample Window
	uint16_t THRESH:6;                      // 14:9 Majority Voting Threshold
	uint16_t FILINIT:1;                   // 15 Filter InQitialization Bit
};

union CTRIPHFILCTL_LITE_REG {
    uint16_t  all;
    struct  CTRIPHFILCTL_LITE_BITS  bit;
};



struct CMPSS_LITE_REGS {
    union   COMPCTL_LITE_REG                 COMPCTL;                      // CMPSS Comparator Control Register
    union   COMPHYSCTL_LITE_REG              COMPHYSCTL;                   // CMPSS Comparator Hysteresis Control Register
    union   COMPSTS_LITE_REG                 COMPSTS;                      // CMPSS Comparator Status Register
    union   COMPSTSCLR_LITE_REG              COMPSTSCLR;                   // CMPSS Comparator Status Clear Register
    union   COMPDACHCTL_LITE_REG             COMPDACHCTL;                  // CMPSS High DAC Control Register
    uint16_t                                   rsvd1;                        // Reserved
    union   DACHVALS_LITE_REG                DACHVALS;                     // CMPSS High DAC Value Shadow Register
    union   DACHVALA_LITE_REG                DACHVALA;                     // CMPSS High DAC Value Active Register
    uint16_t                                   rsvd2[10];                    // Reserved
    union   DACLVALS_LITE_REG                DACLVALS;                     // CMPSS Low DAC Value Shadow Register
    union   DACLVALA_LITE_REG                DACLVALA;                     // CMPSS Low DAC Value Active Register
    uint16_t                                   rsvd3[2];                     // Reserved
    union   CTRIPLFILCTL_LITE_REG            CTRIPLFILCTL;                 // CTRIPL Filter Control Register
    uint16_t                                   CTRIPLFILCLKCTL;              // CTRIPL Filter Clock Control Register
    union   CTRIPHFILCTL_LITE_REG            CTRIPHFILCTL;                 // CTRIPH Filter Control Register
    uint16_t                                   CTRIPHFILCLKCTL;              // CTRIPH Filter Clock Control Register
    uint32_t                                  COMPLOCK;                     // CMPSS Lock Register
};

//---------------------------------------------------------------------------
// CMPSS_LITE External References & Function Declarations:
//
extern volatile struct CMPSS_LITE_REGS CmpssLite2Regs;
extern volatile struct CMPSS_LITE_REGS CmpssLite3Regs;
extern volatile struct CMPSS_LITE_REGS CmpssLite4Regs;
#endif
#ifdef __cplusplus
}
#endif                                  /* extern "C" */

#endif
