/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_dig_sysctl_para.h
*   @brief   
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_DIG_SYSCTL_PARA_H
#define REGS_DIG_SYSCTL_PARA_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// DIG_SYSCTL_PARA Individual Register Bit Definitions:

//
// lock control register.
//
struct DIG_SYSCTRL_LOCK_BITS {			// bits   description
	uint32_t	DIG_SYSCTRL_LOCK:32;			// 31:0   Lock register. After writing the unlock value to this register, all registers protected by lock can be written. Writing other values will lock all registers protected by lock;
};

union DIG_SYSCTRL_LOCK_REG {
	uint32_t 		 all;
	struct DIG_SYSCTRL_LOCK_BITS 		 bit;
};

//
// AP core status report register.
//
struct AP_STAT_REG_BITS {			// bits   description
	uint32_t	AP_SYSCTL_HALTED:1;			// 0:0   
	uint32_t	AP_SYSCTL_LOCKUP:1;			// 1:1   
	uint32_t	rsvd1:2;			// 3:2   reserved
	uint32_t	AP_SYSCTL_FPUSTA:6;			// 9:4   
	uint32_t	rsvd2:22;			// 31:10   reserved
};

union AP_STAT_REG_REG {
	uint32_t 		 all;
	struct AP_STAT_REG_BITS 		 bit;
};

//
// CCM status report register.
//
struct CCM_STAT0_REG_BITS {			// bits   description
	uint32_t	CCM_RAM_REAL_BAD_RD_ERR:4;			// 3:0   
	uint32_t	CCM_RAM_RD_ERR:4;			// 7:4   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union CCM_STAT0_REG_REG {
	uint32_t 		 all;
	struct CCM_STAT0_REG_BITS 		 bit;
};

//
// CCM status report register.
//
struct CCM_STAT1_REG_BITS {			// bits   description
	uint32_t	CCM_RAM_ERR_SYNDROME:32;			// 31:0   reserved
};

union CCM_STAT1_REG_REG {
	uint32_t 		 all;
	struct CCM_STAT1_REG_BITS 		 bit;
};

//
// GS status report register.
//
struct GS_STAT0_REG_BITS {			// bits   description
	uint32_t	GS_RAM_REAL_BAD_RD_ERR:4;			// 3:0   
	uint32_t	GS_RAM_RD_ERR:4;			// 7:4   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union GS_STAT0_REG_REG {
	uint32_t 		 all;
	struct GS_STAT0_REG_BITS 		 bit;
};

//
// GS status report register.
//
struct GS_STAT1_REG_BITS {			// bits   description
	uint32_t	GS_RAM_ERR_SYNDROME:32;			// 31:0   reserved
};

union GS_STAT1_REG_REG {
	uint32_t 		 all;
	struct GS_STAT1_REG_BITS 		 bit;
};

//
// AP core history status report register.
//
struct AP_STAT_WC_REG_BITS {			// bits   description
	uint32_t	AP_SYSCTL_HALTED_HIS:1;			// 0:0   
	uint32_t	AP_SYSCTL_LOCKUP_HIS:1;			// 1:1   
	uint32_t	rsvd1:30;			// 31:2   reserved
};

union AP_STAT_WC_REG_REG {
	uint32_t 		 all;
	struct AP_STAT_WC_REG_BITS 		 bit;
};

//
// CCM history status report register.
//
struct CCM_STAT_WC_REG_BITS {			// bits   description
	uint32_t	CCM_RAM_REAL_BAD_RD_ERR_HIS:4;			// 3:0   
	uint32_t	CCM_RAM_RD_ERR_HIS:4;			// 7:4   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union CCM_STAT_WC_REG_REG {
	uint32_t 		 all;
	struct CCM_STAT_WC_REG_BITS 		 bit;
};

//
// GS history status report register.
//
struct GS_STAT_WC_REG_BITS {			// bits   description
	uint32_t	GS_RAM_REAL_BAD_RD_ERR_HIS:4;			// 3:0   
	uint32_t	GS_RAM_RD_ERR_HIS:4;			// 7:4   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union GS_STAT_WC_REG_REG {
	uint32_t 		 all;
	struct GS_STAT_WC_REG_BITS 		 bit;
};

//
// CCM memory RAM parameter configuration register.
//
struct CCM_MEM_CTRL_BITS {			// bits   description
	uint32_t	CCM_MEM_CTRL:32;			// 31:0   
};

union CCM_MEM_CTRL_REG {
	uint32_t 		 all;
	struct CCM_MEM_CTRL_BITS 		 bit;
};

//
// CCM memory RAM low-power configuration register.
//
struct CCM_MEM_PWR_CTRL_BITS {			// bits   description
	uint32_t	CCM_MEM_PWR_CTRL:32;			// 31:0   
};

union CCM_MEM_PWR_CTRL_REG {
	uint32_t 		 all;
	struct CCM_MEM_PWR_CTRL_BITS 		 bit;
};

//
// GS memory RAM parameter configuration register.
//
struct GS_MEM_CTRL_BITS {			// bits   description
	uint32_t	GS_MEM_CTRL:32;			// 31:0   
};

union GS_MEM_CTRL_REG {
	uint32_t 		 all;
	struct GS_MEM_CTRL_BITS 		 bit;
};

//
// GS memory RAM low-power configuration register.
//
struct GS_MEM_PWR_CTRL_BITS {			// bits   description
	uint32_t	GS_MEM_PWR_CTRL:32;			// 31:0   
};

union GS_MEM_PWR_CTRL_REG {
	uint32_t 		 all;
	struct GS_MEM_PWR_CTRL_BITS 		 bit;
};

//
// eFlash cache memory RAM parameter configuration register.
//
struct EFLASH_CACHE_MEM_CTRL_BITS {			// bits   description
	uint32_t	EFLASH_CACHE_MEM_CTRL:32;			// 31:0   
};

union EFLASH_CACHE_MEM_CTRL_REG {
	uint32_t 		 all;
	struct EFLASH_CACHE_MEM_CTRL_BITS 		 bit;
};

//
// eFlash cache memory RAM low-power configuration register.
//
struct EFLASH_CACHE_MEM_PWR_CTRL_BITS {			// bits   description
	uint32_t	EFLASH_CACHE_MEM_PWR_CTRL:32;			// 31:0   
};

union EFLASH_CACHE_MEM_PWR_CTRL_REG {
	uint32_t 		 all;
	struct EFLASH_CACHE_MEM_PWR_CTRL_BITS 		 bit;
};

//
// DSP memory RAM parameter configuration register.
//
struct DSP_MEM_CTRL_BITS {			// bits   description
	uint32_t	DSP_MEM_CTRL:32;			// 31:0   
};

union DSP_MEM_CTRL_REG {
	uint32_t 		 all;
	struct DSP_MEM_CTRL_BITS 		 bit;
};

//
// DSP memory RAM low-power configuration register.
//
struct DSP_MEM_PWR_CTRL_BITS {			// bits   description
	uint32_t	DSP_MEM_PWR_CTRL:32;			// 31:0   
};

union DSP_MEM_PWR_CTRL_REG {
	uint32_t 		 all;
	struct DSP_MEM_PWR_CTRL_BITS 		 bit;
};

//
// AP core NMI interrupt mask configuration register.
//
struct AP_SYS_NMI_MASK_BITS {			// bits   description
	uint32_t	AP_SYS_NMI_MASK:32;			// 31:0   
};

union AP_SYS_NMI_MASK_REG {
	uint32_t 		 all;
	struct AP_SYS_NMI_MASK_BITS 		 bit;
};

//
// DSP STOP ON RESET configuration register.
//
struct DSP_STOP_ON_RESET_BITS {			// bits   description
	uint32_t	DSP_STOP_ON_RESET:1;			// 0:0   Stop DSP subsystem after reset, allowing ILM/DLM contents to be loaded by external master.
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union DSP_STOP_ON_RESET_REG {
	uint32_t 		 all;
	struct DSP_STOP_ON_RESET_BITS 		 bit;
};

//
// eFlash BIST enable configuration register.
//
struct EFC_BIST_ENABLE_BITS {			// bits   description
	uint32_t	EFC_BIST_ENABLE:1;			// 0:0   eFlash BIST enable configuration
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union EFC_BIST_ENABLE_REG {
	uint32_t 		 all;
	struct EFC_BIST_ENABLE_BITS 		 bit;
};

//
// EBC module mode.
//
struct EBC_MODE_BITS {			// bits   description
	uint32_t	EBC_MODE:3;			// 2:0   [0]: 0=disable, 1=enable
	uint32_t	rsvd1:29;			// 31:3   reserved
};

union EBC_MODE_REG {
	uint32_t 		 all;
	struct EBC_MODE_BITS 		 bit;
};

//
// EBC module bus source.
//
struct EBC_SRC_SEL_BITS {			// bits   description
	uint32_t	EBC_SRC_SEL:3;			// 2:0   Bus source:
	uint32_t	rsvd1:29;			// 31:3   reserved
};

union EBC_SRC_SEL_REG {
	uint32_t 		 all;
	struct EBC_SRC_SEL_BITS 		 bit;
};

//
// EBC match address.
//
struct EBC_EXP_ADDR_BITS {			// bits   description
	uint32_t	EBC_EXP_ADDR:32;			// 31:0   
};

union EBC_EXP_ADDR_REG {
	uint32_t 		 all;
	struct EBC_EXP_ADDR_BITS 		 bit;
};

//
// EBC match write data.
//
struct EBC_EXP_WDATA_BITS {			// bits   description
	uint32_t	EBC_EXP_WDATA:32;			// 31:0   
};

union EBC_EXP_WDATA_REG {
	uint32_t 		 all;
	struct EBC_EXP_WDATA_BITS 		 bit;
};

//
// SEC module enable and source selection.
//
struct SEC__EN_BITS {			// bits   description
	uint32_t	EVT_A_SEL:5;			// 4:0   evt source selection:
	uint32_t	rsvd1:11;			// 15:5   reserved
	uint32_t	EVT_B_SEL:5;			// 20:16   evt source selection:
	uint32_t	rsvd2:3;			// 23:21   reserved
	uint32_t	SEC_MODE:2;			// 25:24   SEC mode
	uint32_t	rsvd3:2;			// 27:26   reserved
	uint32_t	SEC_EN:1;			// 28:28   SEC enable
	uint32_t	rsvd4:3;			// 31:29   reserved
};

union SEC__EN_REG {
	uint32_t 		 all;
	struct SEC__EN_BITS 		 bit;
};

//
// SEC module detection time length configuration.
//
struct SEC_EVT_SEL_BITS {			// bits   description
	uint32_t	SEC_TIME_CFG:16;			// 15:0   SEC module detection time length configuration
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union SEC_EVT_SEL_REG {
	uint32_t 		 all;
	struct SEC_EVT_SEL_BITS 		 bit;
};

//
// SEC interrupt report.
//
struct SEC_RT_CNT_BITS {			// bits   description
	uint32_t	SEC_RT_CNT:16;			// 15:0   When configured as evt count mode, this report is meaningless.
	uint32_t	ERAD_SEC_INT:1;			// 16:16   Module interrupt, cleared when module is disabled
	uint32_t	rsvd1:15;			// 31:17   reserved
};

union SEC_RT_CNT_REG {
	uint32_t 		 all;
	struct SEC_RT_CNT_BITS 		 bit;
};

//
// SEC event interval report.
//
struct SEC_HIS_CNT_BITS {			// bits   description
	uint32_t	SEC_MAX_CNT:16;			// 15:0   When configured as evt count mode, evt_a count value
	uint32_t	SEC_MIN_CNT:16;			// 31:16   When configured as evt count mode, evt_b count value
};

union SEC_HIS_CNT_REG {
	uint32_t 		 all;
	struct SEC_HIS_CNT_BITS 		 bit;
};

//
// AP core event input mask configuration.
//
struct AP_SYS_RXEV_MASK_BITS {			// bits   description
	uint32_t	AP_SYS_RXEV_MASK:32;			// 31:0   
};

union AP_SYS_RXEV_MASK_REG {
	uint32_t 		 all;
	struct AP_SYS_RXEV_MASK_BITS 		 bit;
};

//
// AP core trigger DSP interrupt configuration register.
//
struct SW_TRIG_BITS {			// bits   description
	uint32_t	SW_TRIG:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union SW_TRIG_REG {
	uint32_t 		 all;
	struct SW_TRIG_BITS 		 bit;
};

//
// DSP interrupt mapping configuration register.
//
struct DSP_IRQ_SEL_BITS {			// bits   description
	uint32_t	DSP_IRQ_SEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union DSP_IRQ_SEL_REG {
	uint32_t 		 all;
	struct DSP_IRQ_SEL_BITS 		 bit;
};

//
// Exception masking signal in NICE.
//
struct CFG_NICE2CORE_EXCP_MSK_BITS {			// bits   description
	uint32_t	CFG_NICE2CORE_EXCP_MSK:32;			// 31:0   
};

union CFG_NICE2CORE_EXCP_MSK_REG {
	uint32_t 		 all;
	struct CFG_NICE2CORE_EXCP_MSK_BITS 		 bit;
};

//
// Rounding mode encoding register in NICE.
//
struct CFG_NICE_FP_RND_BITS {			// bits   description
	uint32_t	CFG_NICE_FP_RND:3;			// 2:0   000: round to the nearest value, prefer "even" values;
	uint32_t	rsvd1:29;			// 31:3   reserved
};

union CFG_NICE_FP_RND_REG {
	uint32_t 		 all;
	struct CFG_NICE_FP_RND_BITS 		 bit;
};

//
// Data collection enable configuration register.
//
struct SMP_EN_BITS {			// bits   description
	uint32_t	SMP_EN:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union SMP_EN_REG {
	uint32_t 		 all;
	struct SMP_EN_BITS 		 bit;
};

//
// Data collection mode configuration register.
//
struct SMP_MODE_BITS {			// bits   description
	uint32_t	SMP_MODE:1;			// 0:0   
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union SMP_MODE_REG {
	uint32_t 		 all;
	struct SMP_MODE_BITS 		 bit;
};

//
// Data collection sampling interval configuration register.
//
struct SMP_GAP_BITS {			// bits   description
	uint32_t	SMP_GAP:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union SMP_GAP_REG {
	uint32_t 		 all;
	struct SMP_GAP_BITS 		 bit;
};

//
// Data collection length configuration register.
//
struct SMP_LEN_BITS {			// bits   description
	uint32_t	SMP_LEN:14;			// 13:0   
	uint32_t	rsvd1:18;			// 31:14   reserved
};

union SMP_LEN_REG {
	uint32_t 		 all;
	struct SMP_LEN_BITS 		 bit;
};

//
// GS RAM data collection mode configuration register.
//
struct GS_RAM_SMP_MODE_BITS {			// bits   description
	uint32_t	GS_RAM_SMP_MODE:1;			// 0:0   0: functional mode
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union GS_RAM_SMP_MODE_REG {
	uint32_t 		 all;
	struct GS_RAM_SMP_MODE_BITS 		 bit;
};

//
// Message memory RAM configuration register.
//
struct MSG_MEM_CTRL_BITS {			// bits   description
	uint32_t	MSG_MEM_CTRL:32;			// 31:0   
};

union MSG_MEM_CTRL_REG {
	uint32_t 		 all;
	struct MSG_MEM_CTRL_BITS 		 bit;
};

//
// Message memory RAM low power configuration register.
//
struct MSG_MEM_PWR_CTRL_BITS {			// bits   description
	uint32_t	MSG_MEM_PWR_CTRL:32;			// 31:0   
};

union MSG_MEM_PWR_CTRL_REG {
	uint32_t 		 all;
	struct MSG_MEM_PWR_CTRL_BITS 		 bit;
};

//
// Corresponding sys_err mask configuration register.
//
struct SYS_ERR_MASK_BITS {			// bits   description
	uint32_t	SYS_ERR_MASK:8;			// 7:0   Corresponding sys_err mask configuration register, setting bit to 1 means masked
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union SYS_ERR_MASK_REG {
	uint32_t 		 all;
	struct SYS_ERR_MASK_BITS 		 bit;
};

//
// Corresponding ecc_err mask configuration register.
//
struct ECC_ERR_MASK_BITS {			// bits   description
	uint32_t	ECC_ERR_MASK:8;			// 7:0   Corresponding ecc_err mask configuration register, setting bit to 1 means masked
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union ECC_ERR_MASK_REG {
	uint32_t 		 all;
	struct ECC_ERR_MASK_BITS 		 bit;
};

//
// DSP reset initial vector.
//
struct DSP_RESET_VECTOR_BITS {			// bits   description
	uint32_t	DSP_RESET_VECTOR:32;			// 31:0    
};

union DSP_RESET_VECTOR_REG {
	uint32_t 		 all;
	struct DSP_RESET_VECTOR_BITS 		 bit;
};

//
// DMA handshake channel parameter configuration register.
//
struct DMAMUX_CCR_BITS {			// bits   description
	uint32_t	DMAMUX_CCR:32;			// 31:0   
};

//union DMAMUX_CCR_REG {
//	uint32_t 		 all;
//	struct DMAMUX_CCR_BITS 		 bit;
//};

//
// DMA request generator control parameter configuration register.
//
struct DMAMUX_RGCR_BITS {			// bits   description
	uint32_t	DMAMUX_RGCR:32;			// 31:0   
};

union DMAMUX_RGCR_REG {
	uint32_t 		 all;
	struct DMAMUX_RGCR_BITS 		 bit;
};

//
// DMA MUX overrun raw interrupt.
//
struct SOF_INT_RAW_BITS {			// bits   description
	uint32_t	SOF_INT_RAW:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union SOF_INT_RAW_REG {
	uint32_t 		 all;
	struct SOF_INT_RAW_BITS 		 bit;
};

//
// DMA request generation overrun raw interrupt.
//
struct OF_INT_RAW_BITS {			// bits   description
	uint32_t	OF_INT_RAW:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union OF_INT_RAW_REG {
	uint32_t 		 all;
	struct OF_INT_RAW_BITS 		 bit;
};

//
// DMA MUX overrun interrupt after masking.
//
struct SOF_INT_BITS {			// bits   description
	uint32_t	SOF_INT:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union SOF_INT_REG {
	uint32_t 		 all;
	struct SOF_INT_BITS 		 bit;
};

//
// DMA request generation overrun interrupt after masking.
//
struct OF_INT_BITS {			// bits   description
	uint32_t	OF_INT:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union OF_INT_REG {
	uint32_t 		 all;
	struct OF_INT_BITS 		 bit;
};

//
// Reserved register.
//
struct DIG_SYSCTL_SPARE0_BITS {			// bits   description
	uint32_t	DIG_SYSCTRL_SPARE0:32;			// 31:0   
};

union DIG_SYSCTL_SPARE0_REG {
	uint32_t 		 all;
	struct DIG_SYSCTL_SPARE0_BITS 		 bit;
};

//
// Reserved register.
//
struct DIG_SYSCTL_SPARE1_BITS {			// bits   description
	uint32_t	DIG_SYSCTRL_SPARE1:32;			// 31:0   Reserved for DSP interrupt triggering, each of the 32 bits represents a task completion interrupt.
};

union DIG_SYSCTL_SPARE1_REG {
	uint32_t 		 all;
	struct DIG_SYSCTL_SPARE1_BITS 		 bit;
};

//
// Reserved register.
//
struct DIG_SYSCTL_SPARE2_BITS {			// bits   description
	uint32_t	DIG_SYSCTRL_SPARE2:32;			// 31:0   Reserved for DSP interrupt triggering, bits [4:1] represent the RSIC-V core fcsr {NV, DZ, OF, UF}
};

union DIG_SYSCTL_SPARE2_REG {
	uint32_t 		 all;
	struct DIG_SYSCTL_SPARE2_BITS 		 bit;
};

//
// Reserved register.
//
struct DIG_SYSCTL_APP_SPARE_BITS {			// bits   description
	uint32_t	DIG_SYSCTL_APP_SPARE:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union DIG_SYSCTL_APP_SPARE_REG {
	uint32_t 		 all;
	struct DIG_SYSCTL_APP_SPARE_BITS 		 bit;
};


// DIG_SYSCTL_PARA Register Definitions:

struct SYSCTL_DIG_REGS {
	union  DIG_SYSCTRL_LOCK_REG			DIG_SYSCTRL_LOCK;
	union  AP_STAT_REG_REG			AP_STAT_REG;
	union  CCM_STAT0_REG_REG			CCM_STAT0_REG;
	union  CCM_STAT1_REG_REG			CCM_STAT1_REG;
	union  GS_STAT0_REG_REG			GS_STAT0_REG;
	union  GS_STAT1_REG_REG			GS_STAT1_REG;
	union  AP_STAT_WC_REG_REG			AP_STAT_WC_REG;
	union  CCM_STAT_WC_REG_REG			CCM_STAT_WC_REG;
	union  GS_STAT_WC_REG_REG			GS_STAT_WC_REG;
	union  CCM_MEM_CTRL_REG			CCM_MEM_CTRL;
	union  CCM_MEM_PWR_CTRL_REG			CCM_MEM_PWR_CTRL;
	union  GS_MEM_CTRL_REG			GS_MEM_CTRL;
	union  GS_MEM_PWR_CTRL_REG			GS_MEM_PWR_CTRL;
	union  EFLASH_CACHE_MEM_CTRL_REG			EFLASH_CACHE_MEM_CTRL;
	union  EFLASH_CACHE_MEM_PWR_CTRL_REG			EFLASH_CACHE_MEM_PWR_CTRL;
	union  DSP_MEM_CTRL_REG			DSP_MEM_CTRL;
	union  DSP_MEM_PWR_CTRL_REG			DSP_MEM_PWR_CTRL;
	union  AP_SYS_NMI_MASK_REG			AP_SYS_NMI_MASK;
	union  DSP_STOP_ON_RESET_REG			DSP_STOP_ON_RESET;
	union  EFC_BIST_ENABLE_REG			EFC_BIST_ENABLE;
	uint32_t 						rsvd1[20]; 		 // reserved
	union  EBC_MODE_REG			EBC_MODE_0;
	uint32_t 						rsvd2[3]; 		 // reserved
	union  EBC_MODE_REG			EBC_MODE_1;
	uint32_t 						rsvd3[3]; 		 // reserved
	union  EBC_MODE_REG			EBC_MODE_2;
	uint32_t 						rsvd4[3]; 		 // reserved
	union  EBC_MODE_REG			EBC_MODE_3;
	union  EBC_SRC_SEL_REG			EBC_SRC_SEL_0;
	uint32_t 						rsvd5[3]; 		 // reserved
	union  EBC_SRC_SEL_REG			EBC_SRC_SEL_1;
	uint32_t 						rsvd6[3]; 		 // reserved
	union  EBC_SRC_SEL_REG			EBC_SRC_SEL_2;
	uint32_t 						rsvd7[3]; 		 // reserved
	union  EBC_SRC_SEL_REG			EBC_SRC_SEL_3;
	union  EBC_EXP_ADDR_REG			EBC_EXP_ADDR_0;
	uint32_t 						rsvd8[3]; 		 // reserved
	union  EBC_EXP_ADDR_REG			EBC_EXP_ADDR_1;
	uint32_t 						rsvd9[3]; 		 // reserved
	union  EBC_EXP_ADDR_REG			EBC_EXP_ADDR_2;
	uint32_t 						rsvd10[3]; 		 // reserved
	union  EBC_EXP_ADDR_REG			EBC_EXP_ADDR_3;
	union  EBC_EXP_WDATA_REG			EBC_EXP_WDATA_0;
	uint32_t 						rsvd11[3]; 		 // reserved
	union  EBC_EXP_WDATA_REG			EBC_EXP_WDATA_1;
	uint32_t 						rsvd12[3]; 		 // reserved
	union  EBC_EXP_WDATA_REG			EBC_EXP_WDATA_2;
	uint32_t 						rsvd13[3]; 		 // reserved
	union  EBC_EXP_WDATA_REG			EBC_EXP_WDATA_3;
	union  SEC__EN_REG			SEC__EN_0;
	uint32_t 						rsvd14[3]; 		 // reserved
	union  SEC__EN_REG			SEC__EN_1;
	union  SEC_EVT_SEL_REG			SEC_EVT_SEL_0;
	uint32_t 						rsvd15[3]; 		 // reserved
	union  SEC_EVT_SEL_REG			SEC_EVT_SEL_1;
	union  SEC_RT_CNT_REG			SEC_RT_CNT_0;
	uint32_t 						rsvd16[3]; 		 // reserved
	union  SEC_RT_CNT_REG			SEC_RT_CNT_1;
	union  SEC_HIS_CNT_REG			SEC_HIS_CNT_0;
	uint32_t 						rsvd17[3]; 		 // reserved
	union  SEC_HIS_CNT_REG			SEC_HIS_CNT_1;
	union  AP_SYS_RXEV_MASK_REG			AP_SYS_RXEV_MASK;
	union  SW_TRIG_REG			SW_TRIG;
	uint32_t 						rsvd18[2]; 		 // reserved
	union  DSP_IRQ_SEL_REG			DSP_IRQ_SEL[32];
	uint32_t 						rsvd19[28]; 		 // reserved
	union  CFG_NICE2CORE_EXCP_MSK_REG			CFG_NICE2CORE_EXCP_MSK;
	union  CFG_NICE_FP_RND_REG			CFG_NICE_FP_RND;
	uint32_t 						rsvd20[62]; 		 // reserved
	union  SMP_EN_REG			SMP_EN;
	union  SMP_MODE_REG			SMP_MODE;
	union  SMP_GAP_REG			SMP_GAP;
	union  SMP_LEN_REG			SMP_LEN;
	union  GS_RAM_SMP_MODE_REG			GS_RAM_SMP_MODE;
	uint32_t 						rsvd21[27]; 		 // reserved
	union  MSG_MEM_CTRL_REG			MSG_MEM_CTRL;
	union  MSG_MEM_PWR_CTRL_REG			MSG_MEM_PWR_CTRL;
	uint32_t 						rsvd22[6]; 		 // reserved
	union  SYS_ERR_MASK_REG			SYS_ERR_MASK;
	union  ECC_ERR_MASK_REG			ECC_ERR_MASK;
	uint32_t 						rsvd23[22]; 		 // reserved
	union  DSP_RESET_VECTOR_REG			DSP_RESET_VECTOR;
	uint32_t 						rsvd24[19]; 		 // reserved
	union  DMAMUX_CCR_REG			DMAMUX_CCR[16];
	uint32_t 						rsvd25[4]; 		 // reserved
	union  DMAMUX_RGCR_REG			DMAMUX_RGCR[8];
	union  SOF_INT_RAW_REG			SOF_INT_RAW;
	uint32_t 						rsvd26; 		 // reserved
	union  OF_INT_RAW_REG			OF_INT_RAW;
	uint32_t 						rsvd27; 		 // reserved
	union  SOF_INT_REG			SOF_INT;
	uint32_t 						rsvd28; 		 // reserved
	union  OF_INT_REG			OF_INT;
	uint32_t 						rsvd29[9]; 		 // reserved
	union  DIG_SYSCTL_SPARE0_REG			DIG_SYSCTL_SPARE0;
	union  DIG_SYSCTL_SPARE1_REG			DIG_SYSCTL_SPARE1;
	union  DIG_SYSCTL_SPARE2_REG			DIG_SYSCTL_SPARE2;
	uint32_t 						rsvd30[61]; 		 // reserved
	union  DIG_SYSCTL_APP_SPARE_REG			DIG_SYSCTL_APP_SPARE[16];
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// DIG_SYSCTL_PARA External References & Function Declarations

extern volatile struct SYSCTL_DIG_REGS SysctlDigRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_DIG_SYSCTL_PARA_H definition
