/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_epwm.h
*   @brief
*   [note: This file is automatically generated and does not need to be
*   manually edited. If you want to modify it, use the py script to generate]
*
*/
/*
*  commit history
*  20240324, Jason, remove unused registers structure var.
*/
/*
*  commit history
*  20240909, WangWenZhuo, Updated struct definitions and consolidated versions.
*/

#ifndef REGS_EPWM_H
#define REGS_EPWM_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

#include "inc/hw_types.h"
#include "gs32_version.h"
/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */
#define ENABLE_XCMP_EXTENSION  0

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */

// EPWM Individual Register Bit Definitions:

struct TBCTL_BITS {			// bits   description
	uint16_t	CTRMODE:2;			// 1:0
	uint16_t	PHSEN:1;			// 2:2
	uint16_t	PRDLD:1;			// 3:3
	uint16_t	rsvd1:2;			// 5:4   reserved
	uint16_t	SWFSYNC:1;			// 6:6
	uint16_t	HSPCLKDIV:3;			// 9:7
	uint16_t	CLKDIV:3;			// 12:10
	uint16_t	PHSDIR:1;			// 13:13
	uint16_t	FREE_SOFT:2;			// 15:14
};

union TBCTL_REG {
	uint16_t 		 all;
	struct TBCTL_BITS 		 bit;
};


#if (EPWM_VERSION==12) ||(EPWM_VERSION==22)
struct TBCTL2_BITS {			// bits   description
	uint16_t	rsvd1:5;			// 4:0   reserved
	uint16_t	rsvd2:1;			// 5:5   reserved
	uint16_t	OSHTSYNCMODE:1;			// 6:6
	uint16_t	OSHTSYNC:1;			// 7:7
	uint16_t	rsvd3:4;			// 11:8   reserved
	uint16_t	rsvd4:2;			// 13:12   reserved
	uint16_t	PRDLDSYNC:2;			// 15:14
};

union TBCTL2_REG {
	uint16_t 		 all;
	struct TBCTL2_BITS 		 bit;
};

#elif (EPWM_VERSION==30)
struct TBCTL2_BITS {			// bits   description
	uint16_t	clkdiv_in:2;			// 1:0   reserved
	uint16_t	rsvd1:3;			// 4:2   reserved
	uint16_t	rsvd2:1;			// 5:5   reserved
	uint16_t	OSHTSYNCMODE:1;			// 6:6
	uint16_t	OSHTSYNC:1;			// 7:7
	uint16_t	rsvd3:4;			// 11:8   reserved
	uint16_t	rsvd4:2;			// 13:12   reserved
	uint16_t	PRDLDSYNC:2;			// 15:14
};

union TBCTL2_REG {
	uint16_t 		 all;
	struct TBCTL2_BITS 		 bit;
};
#endif


struct TBCTR_BITS {			// bits   description
	uint16_t	TBCTR:16;			// 15:0
};

union TBCTR_REG {
	uint16_t 		 all;
	struct TBCTR_BITS 		 bit;
};

//
// EPWMxSYNCIN Source Select Register
//
#if IS_GS32F00xx(0x12)||IS_GS32F00xx(0x30)
struct EPWMSYNCINSEL_BITS {			// bits   description
	uint16_t	SEL:5;			// 4:0   These bits determine the source of the EPWMxSYNCI signal.
	uint16_t	rsvd1:11;			// 15:5   Reserved
};

union EPWMSYNCINSEL_REG {
	uint16_t 		 all;
	struct EPWMSYNCINSEL_BITS 		 bit;
};

#elif IS_GS32F3xx(0x22)
struct EPWMSYNCINSEL_BITS {			// bits   description
	uint16_t	SEL:7;			// 6:0   These bits determine the source of the EPWMxSYNCI signal.
	uint16_t	rsvd1:9;			// 15:7   Reserved
};

union EPWMSYNCINSEL_REG {
	uint16_t 		 all;
	struct EPWMSYNCINSEL_BITS 		 bit;
};
#endif


struct TBSTS_BITS {			// bits   description
	uint16_t	CTRDIR:1;			// 0:0
	uint16_t	SYNCI:1;			// 1:1
	uint16_t	CTRMAX:1;			// 2:2
	uint16_t	rsvd1:13;			// 15:3   reserved
};

union TBSTS_REG {
	uint16_t 		 all;
	struct TBSTS_BITS 		 bit;
};

struct EPWMSYNCOUTEN_BITS {			// bits   description
	uint16_t	SWEN:1;			// 0:0
	uint16_t	ZEROEN:1;			// 1:1
	uint16_t	CMPBEN:1;			// 2:2
	uint16_t	CMPCEN:1;			// 3:3
	uint16_t	CMPDEN:1;			// 4:4
	uint16_t	DCAEVT1EN:1;			// 5:5
	uint16_t	DCBEVT1EN:1;			// 6:6
	uint16_t	rsvd1:1;			// 7:7   reserved
	uint16_t	rsvd2:8;			// 15:8   reserved
};

union EPWMSYNCOUTEN_REG {
	uint16_t 		 all;
	struct EPWMSYNCOUTEN_BITS 		 bit;
};

struct TBCTL3_BITS {			// bits   description
	uint16_t	OSSFRCEN:1;			// 0:0
	uint16_t	rsvd1:15;			// 15:1   reserved
};

union TBCTL3_REG {
	uint16_t 		 all;
	struct TBCTL3_BITS 		 bit;
};

struct CMPCTL_BITS {			// bits   description
	uint16_t	LOADAMODE:2;			// 1:0
	uint16_t	LOADBMODE:2;			// 3:2
	uint16_t	SHDWAMODE:1;			// 4:4
	uint16_t	rsvd1:1;			// 5:5   reserved
	uint16_t	SHDWBMODE:1;			// 6:6
	uint16_t	rsvd2:1;			// 7:7   reserved
	uint16_t	SHDWAFULL:1;			// 8:8
	uint16_t	SHDWBFULL:1;			// 9:9
	uint16_t	LOADASYNC:2;			// 11:10
	uint16_t	LOADBSYNC:2;			// 13:12
	uint16_t	rsvd3:2;			// 15:14   reserved
};

union CMPCTL_REG {
	uint16_t 		 all;
	struct CMPCTL_BITS 		 bit;
};

struct CMPCTL2_BITS {			// bits   description
	uint16_t	LOADCMODE:2;			// 1:0
	uint16_t	LOADDMODE:2;			// 3:2
	uint16_t	SHDWCMODE:1;			// 4:4
	uint16_t	rsvd1:1;			// 5:5   reserved
	uint16_t	SHDWDMODE:1;			// 6:6
	uint16_t	rsvd2:3;			// 9:7   reserved
	uint16_t	LOADCSYNC:2;			// 11:10
	uint16_t	LOADDSYNC:2;			// 13:12
	uint16_t	rsvd3:2;			// 15:14   reserved
};

union CMPCTL2_REG {
	uint16_t 		 all;
	struct CMPCTL2_BITS 		 bit;
};

struct CMPCTL3_BITS {			// bits   description
	uint16_t	LOADA1MODE:2;			// 1:0
	uint16_t	LOADB1MODE:2;			// 3:2
	uint16_t	SHDWA1MODE:1;			// 4:4
	uint16_t	rsvd1:1;			// 5:5   reserved
	uint16_t	SHDWB1MODE:1;			// 6:6
	uint16_t	rsvd2:1;			// 7:7   reserved
	uint16_t	SHDWA1FULL:1;			// 8:8
	uint16_t	SHDWB1FULL:1;			// 9:9
	uint16_t	LOADA1SYNC:2;			// 11:10
	uint16_t	LOADB1SYNC:2;			// 13:12
	uint16_t	rsvd3:2;			// 15:14   reserved
};

union CMPCTL3_REG {
	uint16_t 		 all;
	struct CMPCTL3_BITS 		 bit;
};

struct DBCTL_BITS {			// bits   description
	uint16_t	OUT_MODE:2;			// 1:0
	uint16_t	POLSEL:2;			// 3:2
	uint16_t	IN_MODE:2;			// 5:4
	uint16_t	LOADREDMODE:2;			// 7:6
	uint16_t	LOADFEDMODE:2;			// 9:8
	uint16_t	SHDWDBREDMODE:1;			// 10:10
	uint16_t	SHDWDBFEDMODE:1;			// 11:11
	uint16_t	OUTSWAP:2;			// 13:12
	uint16_t	DEDB_MODE:1;			// 14:14
	uint16_t	HALFCYCLE:1;			// 15:15
};

union DBCTL_REG {
	uint16_t 		 all;
	struct DBCTL_BITS 		 bit;
};

struct DBCTL2_BITS {			// bits   description
	uint16_t	LOADDBCTLMODE:2;			// 1:0
	uint16_t	SHDWDBCTLMODE:1;			// 2:2
	uint16_t	rsvd1:13;			// 15:3   reserved
};

union DBCTL2_REG {
	uint16_t 		 all;
	struct DBCTL2_BITS 		 bit;
};

struct AQCTL_BITS {			// bits   description
	uint16_t	LDAQAMODE:2;			// 1:0
	uint16_t	LDAQBMODE:2;			// 3:2
	uint16_t	SHDWAQAMODE:1;			// 4:4
	uint16_t	rsvd1:1;			// 5:5   reserved
	uint16_t	SHDWAQBMODE:1;			// 6:6
	uint16_t	rsvd2:1;			// 7:7   reserved
	uint16_t	LDAQASYNC:2;			// 9:8
	uint16_t	LDAQBSYNC:2;			// 11:10
	uint16_t	rsvd3:4;			// 15:12   reserved
};

union AQCTL_REG {
	uint16_t 		 all;
	struct AQCTL_BITS 		 bit;
};

struct AQTSRCSEL_BITS {			// bits   description
	uint16_t	T1SEL:4;			// 3:0
	uint16_t	T2SEL:4;			// 7:4
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union AQTSRCSEL_REG {
	uint16_t 		 all;
	struct AQTSRCSEL_BITS 		 bit;
};

struct PCCTL_BITS {			// bits   description
	uint16_t	CHPEN:1;			// 0:0
	uint16_t	OSHTWTH:4;			// 4:1
	uint16_t	CHPFREQ:3;			// 7:5
	uint16_t	CHPDUTY:3;			// 10:8
	uint16_t	OSHTWTH_EXP:2;			// 12:11
	uint16_t	CHPFREQ_EXP:2;			// 14:13
	uint16_t	rsvd1:1;			// 15:15   reserved
};

union PCCTL_REG {
	uint16_t 		 all;
	struct PCCTL_BITS 		 bit;
};

struct VCAPCTL_BITS {			// bits   description
	uint16_t	VCAPE:1;			// 0:0
	uint16_t	VCAPSTART:1;			// 1:1
	uint16_t	TRIGSEL:3;			// 4:2
	uint16_t	rsvd1:2;			// 6:5   reserved
	uint16_t	VDELAYDIV:3;			// 9:7
	uint16_t	EDGEFILTDLYSEL:1;			// 10:10
	uint16_t	rsvd2:5;			// 15:11   reserved
};

union VCAPCTL_REG {
	uint16_t 		 all;
	struct VCAPCTL_BITS 		 bit;
};

struct VCNTCFG_BITS {			// bits   description
	uint16_t	STARTEDGE:4;			// 3:0
	uint16_t	rsvd1:3;			// 6:4   reserved
	uint16_t	STARTEDGESTS:1;			// 7:7
	uint16_t	STOPEDGE:4;			// 11:8
	uint16_t	rsvd2:3;			// 14:12   reserved
	uint16_t	STOPEDGESTS:1;			// 15:15
};

union VCNTCFG_REG {
	uint16_t 		 all;
	struct VCNTCFG_BITS 		 bit;
};

struct HRCNFG_BITS {			// bits   description
	uint16_t	EDGMODE:2;			// 1:0
	uint16_t	CTLMODE:1;			// 2:2
	uint16_t	HRLOAD:2;			// 4:3
	uint16_t	SELOUTB:1;			// 5:5
	uint16_t	AUTOCONV:1;			// 6:6
	uint16_t	SWAPAB:1;			// 7:7
	uint16_t	EDGMODEB:2;			// 9:8
	uint16_t	CTLMODEB:1;			// 10:10
	uint16_t	HRLOADB:2;			// 12:11
	uint16_t	rsvd1:1;			// 13:13   reserved
	uint16_t	rsvd2:2;			// 15:14   reserved
};

union HRCNFG_REG {
	uint16_t 		 all;
	struct HRCNFG_BITS 		 bit;
};

struct HRPWR_BITS {			// bits   description
	uint16_t	rsvd1:2;			// 1:0   reserved
	uint16_t	rsvd2:1;			// 2:2   reserved
	uint16_t	rsvd3:1;			// 3:3   reserved
	uint16_t	rsvd4:1;			// 4:4   reserved
	uint16_t	rsvd5:1;			// 5:5   reserved
	uint16_t	rsvd6:4;			// 9:6   reserved
	uint16_t	rsvd7:5;			// 14:10   reserved
	uint16_t	CALPWRON:1;			// 15:15
};

union HRPWR_REG {
	uint16_t 		 all;
	struct HRPWR_BITS 		 bit;
};

//the following bit-field is modified to avoid byte access instruction
struct HRMSTEP_BITS {			// bits   description
	uint16_t	HRMSTEP:8;			// 7:0
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union HRMSTEP_REG {
	uint16_t 		 all;
	struct HRMSTEP_BITS 		 bit;
};

struct HRCNFG2_BITS {			// bits   description
	uint16_t	EDGMODEDB:2;			// 1:0
	uint16_t	CTLMODEDBRED:2;			// 3:2
	uint16_t	CTLMODEDBFED:2;			// 5:4
	uint16_t	rsvd1:8;			// 13:6   reserved
	uint16_t	rsvd2:1;			// 14:14   reserved
	uint16_t	rsvd3:1;			// 15:15   reserved
};

union HRCNFG2_REG {
	uint16_t 		 all;
	struct HRCNFG2_BITS 		 bit;
};

struct HRPCTL_BITS {			// bits   description
	uint16_t	HRPE:1;			// 0:0
	uint16_t	PWMSYNCSEL:1;			// 1:1
	uint16_t	TBPHSHRLOADE:1;			// 2:2
	uint16_t	rsvd1:1;			// 3:3   reserved
	uint16_t	PWMSYNCSELX:3;			// 6:4
	uint16_t	rsvd2:9;			// 15:7   reserved
};

union HRPCTL_REG {
	uint16_t 		 all;
	struct HRPCTL_BITS 		 bit;
};

struct TRREM_BITS {			// bits   description
	uint16_t	TRREM:11;			// 10:0
	uint16_t	rsvd1:5;			// 15:11   reserved
};

union TRREM_REG {
	uint16_t 		 all;
	struct TRREM_BITS 		 bit;
};

struct GLDCTL_BITS {			// bits   description
	uint16_t	GLD:1;			// 0:0
	uint16_t	GLDMODE:4;			// 4:1
	uint16_t	OSHTMODE:1;			// 5:5
	uint16_t	rsvd1:1;			// 6:6   reserved
	uint16_t	GLDPRD:3;			// 9:7
	uint16_t	GLDCNT:3;			// 12:10
	uint16_t	rsvd2:3;			// 15:13   reserved
};

union GLDCTL_REG {
	uint16_t 		 all;
	struct GLDCTL_BITS 		 bit;
};

struct GLDCFG_BITS {			// bits   description
	uint16_t	TBPRD_TBPRDHR:1;			// 0:0
	uint16_t	CMPA_CMPAHR:1;			// 1:1
	uint16_t	CMPB_CMPBHR:1;			// 2:2
	uint16_t	CMPC:1;			// 3:3
	uint16_t	CMPD:1;			// 4:4
	uint16_t	DBRED_DBREDHR:1;			// 5:5
	uint16_t	DBFED_DBFEDHR:1;			// 6:6
	uint16_t	DBCTL:1;			// 7:7
	uint16_t	AQCTLA_AQCTLA2:1;			// 8:8
	uint16_t	AQCTLB_AQCTLB2:1;			// 9:9
	uint16_t	AQCSFRC:1;			// 10:10
	uint16_t	CMPA1:1;			// 11:11
	uint16_t	CMPB1:1;			// 12:12
	uint16_t	rsvd1:3;			// 15:13   reserved
};

union GLDCFG_REG {
	uint16_t 		 all;
	struct GLDCFG_BITS 		 bit;
};

#if (EPWM_VERSION==12)
struct EPWMXLINK_BITS {			// bits   description
	uint32_t	TBPRDLINK:4;			// 3:0
	uint32_t	CMPALINK:4;			// 7:4
	uint32_t	CMPBLINK:4;			// 11:8
	uint32_t	CMPCLINK:4;			// 15:12
	uint32_t	CMPDLINK:4;			// 19:16
	uint32_t	CMPA1LINK:4;			// 23:20
	uint32_t	CMPB1LINK:4;			// 27:24
	uint32_t	GLDCTL2LINK:4;			// 31:28
};

union EPWMXLINK_REG {
	uint32_t 		 all;
	struct EPWMXLINK_BITS 		 bit;
};

struct EPWMXLINK2_BITS {			// bits   description
	uint32_t	rsvd1:32;			// 31:0
};

union EPWMXLINK2_REG {
	uint32_t 		 all;
	struct EPWMXLINK2_BITS 		 bit;
};

//
// EPWMx Link Register
//
struct EPWMXLINK3_BITS {			// bits   description
	uint32_t	TBPHSLINK:4;			// 3:0   TBPHS  Link  Bits
	uint32_t	DBLINK:4;			// 7:4   DB  Link  Bits
	uint32_t	AQCTLLINK:4;			// 11:8   AQCTL  Link  Bits
	uint32_t	AQCSFRCLINK:4;			// 15:12   AQCSFRC Link Bits
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union EPWMXLINK3_REG {
	uint32_t 		 all;
	struct EPWMXLINK3_BITS 		 bit;
};

#elif(EPWM_VERSION==30)
struct EPWMXLINK_BITS {			// bits   description
	uint32_t	TBPRDLINK:4;			// 3:0
	uint32_t	CMPALINK:4;			// 7:4
	uint32_t	CMPBLINK:4;			// 11:8
	uint32_t	CMPCLINK:4;			// 15:12
	uint32_t	CMPDLINK:4;			// 19:16
	uint32_t	CMPA1LINK:4;			// 23:20
	uint32_t	CMPB1LINK:4;			// 27:24
	uint32_t	GLDCTL2LINK:4;			// 31:28
};

union EPWMXLINK_REG {
	uint32_t 		 all;
	struct EPWMXLINK_BITS 		 bit;
};

struct EPWMXLINK2_BITS {			// bits   description
	uint32_t	DBREDLINK:4;			// 3:0
	uint32_t	DBFEDLINK:4;			// 7:4
	uint32_t	rsvd1:24;			// 31:8
};

union EPWMXLINK2_REG {
	uint32_t 		 all;
	struct EPWMXLINK2_BITS 		 bit;
};

//
// EPWMx Link Register
//
struct EPWMXLINK3_BITS {			// bits   description
	uint32_t	TBPHSLINK:4;			// 3:0   TBPHS  Link  Bits
	uint32_t	rsvd1:4;			// 7:4   Reserved
	uint32_t	AQCTLLINK:4;			// 11:8   AQCTL  Link  Bits
	uint32_t	AQCSFRCLINK:4;			// 15:12   AQCSFRC Link Bits
	uint32_t	rsvd2:16;			// 31:16   Reserved
};

union EPWMXLINK3_REG {
	uint32_t 		 all;
	struct EPWMXLINK3_BITS 		 bit;
};

#elif (EPWM_VERSION==22)
struct EPWMXLINK_BITS {			// bits   description
	uint32_t	TBPRDLINK:5;			// 4:0
	uint32_t	CMPALINK:5;			// 9:5
	uint32_t	CMPBLINK:5;			// 14:10
	uint32_t	rsvd1:1;			// 15
	uint32_t	CMPCLINK:5;			// 20:16
	uint32_t	CMPDLINK:5;			// 25:21
	uint32_t	GLDCTL2LINK:5;			// 30:26
	uint32_t	rsvd2:1;			// 31
};

union EPWMXLINK_REG {
	uint32_t 		 all;
	struct EPWMXLINK_BITS 		 bit;
};

struct EPWMXLINK2_BITS {			// bits   description
	uint32_t	rsvd1:22;			// 21:0
	uint32_t	CMPA1LINK:5;			// 26:22
	uint32_t	CMPB2LINK:5;			// 31:27
};

union EPWMXLINK2_REG {
	uint32_t 		 all;
	struct EPWMXLINK2_BITS 		 bit;
};

//
// EPWMx Link Register
//
struct EPWMXLINK3_BITS {			// bits   description
	uint32_t	TBPHSLINK:5;			// 4:0   TBPRD TBPRDHR  Link  Bits
	uint32_t	DBLINK:5;			// 9:5   CMPA CMPAHR  Link  Bits
	uint32_t	AQCTLLINK:5;			// 14:10   CMPB CMPBHR  Link  Bits
	uint32_t	AQCSFRCLINK:5;			// 19:15   CMPC Link Bits
	uint32_t	rsvd1:12;			// 31:20   Reserved
};

union EPWMXLINK3_REG {
	uint32_t 		 all;
	struct EPWMXLINK3_BITS 		 bit;
};
#endif

struct AQCTLA_BITS {			// bits   description
	uint16_t	ZRO:2;			// 1:0
	uint16_t	PRD:2;			// 3:2
	uint16_t	CAU:2;			// 5:4
	uint16_t	CAD:2;			// 7:6
	uint16_t	CBU:2;			// 9:8
	uint16_t	CBD:2;			// 11:10
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union AQCTLA_REG {
	uint16_t 		 all;
	struct AQCTLA_BITS 		 bit;
};

struct AQCTLA2_BITS {			// bits   description
	uint16_t	T1U:2;			// 1:0
	uint16_t	T1D:2;			// 3:2
	uint16_t	T2U:2;			// 5:4
	uint16_t	T2D:2;			// 7:6
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union AQCTLA2_REG {
	uint16_t 		 all;
	struct AQCTLA2_BITS 		 bit;
};

struct AQCTLB_BITS {			// bits   description
	uint16_t	ZRO:2;			// 1:0
	uint16_t	PRD:2;			// 3:2
	uint16_t	CAU:2;			// 5:4
	uint16_t	CAD:2;			// 7:6
	uint16_t	CBU:2;			// 9:8
	uint16_t	CBD:2;			// 11:10
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union AQCTLB_REG {
	uint16_t 		 all;
	struct AQCTLB_BITS 		 bit;
};

struct AQCTLB2_BITS {			// bits   description
	uint16_t	T1U:2;			// 1:0
	uint16_t	T1D:2;			// 3:2
	uint16_t	T2U:2;			// 5:4
	uint16_t	T2D:2;			// 7:6
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union AQCTLB2_REG {
	uint16_t 		 all;
	struct AQCTLB2_BITS 		 bit;
};

struct AQSFRC_BITS {			// bits   description
	uint16_t	ACTSFA:2;			// 1:0
	uint16_t	OTSFA:1;			// 2:2
	uint16_t	ACTSFB:2;			// 4:3
	uint16_t	OTSFB:1;			// 5:5
	uint16_t	RLDCSF:2;			// 7:6
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union AQSFRC_REG {
	uint16_t 		 all;
	struct AQSFRC_BITS 		 bit;
};

struct AQCSFRC_BITS {			// bits   description
	uint16_t	CSFA:2;			// 1:0
	uint16_t	CSFB:2;			// 3:2
	uint16_t	rsvd1:12;			// 15:4   reserved
};

union AQCSFRC_REG {
	uint16_t 		 all;
	struct AQCSFRC_BITS 		 bit;
};

struct DBREDHR_BITS {			// bits   description
	uint16_t	rsvd1:1;			// 0:0   reserved
	uint16_t	rsvd2:7;			// 7:1   reserved
	uint16_t	rsvd3:1;			// 8:8   reserved
	uint16_t	DBREDHR:7;			// 15:9
};

union DBREDHR_REG {
	uint16_t 		 all;
	struct DBREDHR_BITS 		 bit;
};

struct DBRED_BITS {			// bits   description
	uint16_t	DBRED:14;			// 13:0
	uint16_t	rsvd1:2;			// 15:14   reserved
};

union DBRED_REG {
	uint16_t 		 all;
	struct DBRED_BITS 		 bit;
};

struct DBFEDHR_BITS {			// bits   description
	uint16_t	rsvd1:1;			// 0:0   reserved
	uint16_t	rsvd2:7;			// 7:1   reserved
	uint16_t	rsvd3:1;			// 8:8   reserved
	uint16_t	DBFEDHR:7;			// 15:9
};

union DBFEDHR_REG {
	uint16_t 		 all;
	struct DBFEDHR_BITS 		 bit;
};

struct DBFED_BITS {			// bits   description
	uint16_t	DBFED:14;			// 13:0
	uint16_t	rsvd1:2;			// 15:14   reserved
};

union DBFED_REG {
	uint16_t 		 all;
	struct DBFED_BITS 		 bit;
};

struct TBPHS_BITS {			// bits   description
	uint32_t	TBPHSHR:16;			// 15:0
	uint32_t	TBPHS:16;			// 31:16
};

union TBPHS_REG {
	uint32_t 		 all;
#if(GS32_PART_NUM == 0x035)
	struct TBPHS_BITS 		 half;
#else
	struct TBPHS_BITS 		 bit;
#endif
};

struct TBPRDHR_BITS {			// bits   description
	uint16_t	TBPRDHR:16;			// 15:0
};

union TBPRDHR_REG {
	uint16_t 		 all;
	struct TBPRDHR_BITS 		 bit;
};

struct TBPRD_BITS {			// bits   description
	uint16_t	TBPRD:16;			// 15:0
};

union TBPRD_REG {
	uint16_t 		 all;
	struct TBPRD_BITS 		 bit;
};
#if(EPWM_VERSION == 30)
struct CMPA1_BITS {			// bits   description
	uint32_t	CMPA1HR:16;			// 15:0
	uint32_t	CMPA1:16;			// 31:16
};

union CMPA1_REG {
	uint32_t 		 all;
	struct CMPA1_BITS 		 bit;
};

struct CMPB1_BITS {			// bits   description
	uint32_t	CMPB1HR:16;			// 15:0
	uint32_t	CMPB1:16;			// 31:16
};

union CMPB1_REG {
	uint32_t 		 all;
	struct CMPB1_BITS 		 bit;
};
#endif

struct CMPSEL_BITS {			// bits   description
	uint16_t	CMPSEL:1;			// 0:0
	uint16_t	CMPMODE:1;			// 1:1
	uint16_t	CMPHRSEL:1;			// 1:1
	uint16_t	rsvd1:13;			// 15:3   reserved
};

union CMPSEL_REG {
	uint16_t 		 all;
	struct CMPSEL_BITS 		 bit;
};

struct CMPA_BITS {			// bits   description
	uint32_t	CMPAHR:16;			// 15:0
	uint32_t	CMPA:16;			// 31:16
};

union CMPA_REG {
	uint32_t 		 all;
#if(GS32_PART_NUM == 0x035)
	struct CMPA_BITS 		 half;
#else
	struct CMPA_BITS 		 bit;
#endif
};

struct CMPB_BITS {			// bits   description
	uint32_t	CMPBHR:16;			// 15:0
	uint32_t	CMPB:16;			// 31:16
};

union CMPB_REG {
	uint32_t 		 all;
	struct CMPB_BITS 		 bit;
};

struct CMPC_BITS {			// bits   description
	uint16_t	CMPC:16;			// 15:0
};

union CMPC_REG {
	uint16_t 		 all;
	struct CMPC_BITS 		 bit;
};

struct CMPD_BITS {			// bits   description
	uint16_t	CMPD:16;			// 15:0
};

union CMPD_REG {
	uint16_t 		 all;
	struct CMPD_BITS 		 bit;
};

struct CMPRO_BITS {			// bits   description
	uint32_t	CMPA_ACTIVE_IN:16;			// 15:0
	uint32_t	CMPB_ACTIVE_IN:16;			// 31:16
};

union CMPRO_REG {
	uint32_t 		 all;
	struct CMPRO_BITS 		 bit;
};

struct GLDCTL2_BITS {			// bits   description
	uint16_t	OSHTLD:1;			// 0:0
	uint16_t	GFRCLD:1;			// 1:1
	uint16_t	rsvd1:14;			// 15:2   reserved
};

union GLDCTL2_REG {
	uint16_t 		 all;
	struct GLDCTL2_BITS 		 bit;
};

struct SWVDELVAL_BITS {			// bits   description
	uint16_t	SWVDELVAL:16;			// 15:0
};

union SWVDELVAL_REG {
	uint16_t 		 all;
	struct SWVDELVAL_BITS 		 bit;
};
#if (EPWM_VERSION==12)||(EPWM_VERSION==22)
struct TZSEL2_BITS {			// bits   description
	uint32_t	CBC7:1;			// 0:0
	uint32_t	CBC8:1;			// 1:1
	uint32_t	CBC9:1;			// 2:2
	uint32_t	OSHT7:1;			// 3:3
	uint32_t	OSHT8:1;			// 4:4
	uint32_t	OSHT9:1;			// 5:5
	uint32_t	rsvd1:26;			// 31:6   reserved
};

union TZSEL2_REG {
	uint32_t 		 all;
	struct TZSEL2_BITS 		 bit;
};

#elif (EPWM_VERSION==30)
struct TZSEL_EXP_BITS {			// bits   description
	uint32_t	CBC7:1;			// 0:0
	uint32_t	CBC8:1;			// 1:1
	uint32_t	CBC9:1;			// 2:2
	uint32_t	OSHT7:1;			// 3:3
	uint32_t	OSHT8:1;			// 4:4
	uint32_t	OSHT9:1;			// 5:5
	uint32_t	rsvd1:26;			// 31:6   reserved
};

union TZSEL_EXP_REG {
	uint32_t 		 all;
	struct TZSEL_EXP_BITS 		 bit;
};

struct TZSEL2_BITS {			// bits   description
	uint16_t	CAPEVT_CBCSEL:1;			// 0:0
	uint16_t	rsvd1:7;			// 7:1   reserved
	uint16_t	CAPEVT_OUTSEL:1;			// 8:8
	uint16_t	rsvd2:7;			// 15:9
};

union TZSEL2_REG {
	uint16_t 		 all;
	struct TZSEL2_BITS 		 bit;
};
#endif


struct TZSEL_BITS {			// bits   description
	uint16_t	CBC1:1;			// 0:0
	uint16_t	CBC2:1;			// 1:1
	uint16_t	CBC3:1;			// 2:2
	uint16_t	CBC4:1;			// 3:3
	uint16_t	CBC5:1;			// 4:4
	uint16_t	CBC6:1;			// 5:5
	uint16_t	DCAEVT2:1;			// 6:6
	uint16_t	DCBEVT2:1;			// 7:7
	uint16_t	OSHT1:1;			// 8:8
	uint16_t	OSHT2:1;			// 9:9
	uint16_t	OSHT3:1;			// 10:10
	uint16_t	OSHT4:1;			// 11:11
	uint16_t	OSHT5:1;			// 12:12
	uint16_t	OSHT6:1;			// 13:13
	uint16_t	DCAEVT1:1;			// 14:14
	uint16_t	DCBEVT1:1;			// 15:15
};

union TZSEL_REG {
	uint16_t 		 all;
	struct TZSEL_BITS 		 bit;
};

struct TZDCSEL_BITS {			// bits   description
	uint16_t	DCAEVT1:3;			// 2:0
	uint16_t	DCAEVT2:3;			// 5:3
	uint16_t	DCBEVT1:3;			// 8:6
	uint16_t	DCBEVT2:3;			// 11:9
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union TZDCSEL_REG {
	uint16_t 		 all;
	struct TZDCSEL_BITS 		 bit;
};

struct TZCTL_BITS {			// bits   description
	uint16_t	TZA:2;			// 1:0
	uint16_t	TZB:2;			// 3:2
	uint16_t	DCAEVT1:2;			// 5:4
	uint16_t	DCAEVT2:2;			// 7:6
	uint16_t	DCBEVT1:2;			// 9:8
	uint16_t	DCBEVT2:2;			// 11:10
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union TZCTL_REG {
	uint16_t 		 all;
	struct TZCTL_BITS 		 bit;
};

struct TZCTL2_BITS {			// bits   description
	uint16_t	TZAU:3;			// 2:0
	uint16_t	TZAD:3;			// 5:3
	uint16_t	TZBU:3;			// 8:6
	uint16_t	TZBD:3;			// 11:9
	uint16_t	rsvd1:3;			// 14:12   reserved
	uint16_t	ETZE:1;			// 15:15
};

union TZCTL2_REG {
	uint16_t 		 all;
	struct TZCTL2_BITS 		 bit;
};

struct TZCTLDCA_BITS {			// bits   description
	uint16_t	DCAEVT1U:3;			// 2:0
	uint16_t	DCAEVT1D:3;			// 5:3
	uint16_t	DCAEVT2U:3;			// 8:6
	uint16_t	DCAEVT2D:3;			// 11:9
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union TZCTLDCA_REG {
	uint16_t 		 all;
	struct TZCTLDCA_BITS 		 bit;
};

struct TZCTLDCB_BITS {			// bits   description
	uint16_t	DCBEVT1U:3;			// 2:0
	uint16_t	DCBEVT1D:3;			// 5:3
	uint16_t	DCBEVT2U:3;			// 8:6
	uint16_t	DCBEVT2D:3;			// 11:9
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union TZCTLDCB_REG {
	uint16_t 		 all;
	struct TZCTLDCB_BITS 		 bit;
};

struct TZEINT_BITS {			// bits   description
	uint16_t	rsvd1:1;			// 0:0   reserved
	uint16_t	CBC:1;			// 1:1
	uint16_t	OST:1;			// 2:2
	uint16_t	DCAEVT1:1;			// 3:3
	uint16_t	DCAEVT2:1;			// 4:4
	uint16_t	DCBEVT1:1;			// 5:5
	uint16_t	DCBEVT2:1;			// 6:6
	uint16_t	rsvd2:9;			// 15:7   reserved
};

union TZEINT_REG {
	uint16_t 		 all;
	struct TZEINT_BITS 		 bit;
};

#if (EPWM_VERSION==12) || (EPWM_VERSION==22)
struct TZEINT_CON_BITS {			// bits   description
	uint16_t	TZEINT2_TZ1:1;			// 0:0
	uint16_t	TZEINT2_TZ2:1;			// 1:1
	uint16_t	TZEINT2_TZ3:1;			// 2:2
	uint16_t	TZEINT2_TZ4:1;			// 3:3
	uint16_t	TZEINT2_TZ5:1;			// 4:4
	uint16_t	TZEINT2_TZ6:1;			// 5:5
	uint16_t	TZEINT2_TZ7:1;			// 6:6
	uint16_t	TZEINT2_TZ8:1;			// 7:7
	uint16_t	TZEINT2_TZ9:1;			// 8:8
	uint16_t	TZEINT2_DCAEVT1:1;			// 9:9
	uint16_t	TZEINT2_DCBEVT1:1;			// 10:10
	uint16_t	TZEINT2_FRC:1;			// 11:11
	uint16_t	rsvd1:4;			// 12:15   reserved
};

union TZEINT_CON_REG {
	uint16_t 		 all;
	struct TZEINT_CON_BITS 		 bit;
};

struct TZFLG_CON_BITS {			// bits   description
	uint16_t	TZFLG2_TZ1:1;			// 0:0
	uint16_t	TZFLG2_TZ2:1;			// 1:1
	uint16_t	TZFLG2_TZ3:1;			// 2:2
	uint16_t	TZFLG2_TZ4:1;			// 3:3
	uint16_t	TZFLG2_TZ5:1;			// 4:4
	uint16_t	TZFLG2_TZ6:1;			// 5:5
	uint16_t	TZFLG2_TZ7:1;			// 6:6
	uint16_t	TZFLG2_TZ8:1;			// 7:7
	uint16_t	TZFLG2_TZ9:1;			// 8:8
	uint16_t	TZFLG2_DCAEVT1:1;			// 9:9
	uint16_t	TZFLG2_DCBEVT1:1;			// 10:10
	uint16_t	TZFLG2_FRC:1;			// 11:11
	uint16_t	rsvd1:4;			// 12:15   reserved
};

union TZFLG_CON_REG {
	uint16_t 		 all;
	struct TZFLG_CON_BITS 		 bit;
};

#elif (EPWM_VERSION==30)
struct TZEINT_CON_BITS {			// bits   description
	uint16_t	TZEINT2_TZ1:1;			// 0:0
	uint16_t	TZEINT2_TZ2:1;			// 1:1
	uint16_t	TZEINT2_TZ3:1;			// 2:2
	uint16_t	TZEINT2_TZ4:1;			// 3:3
	uint16_t	TZEINT2_TZ5:1;			// 4:4
	uint16_t	TZEINT2_TZ6:1;			// 5:5
	uint16_t	TZEINT2_TZ7:1;			// 6:6
	uint16_t	TZEINT2_TZ8:1;			// 7:7
	uint16_t	TZEINT2_TZ9:1;			// 8:8
	uint16_t	TZEINT2_DCAEVT1:1;			// 9:9
	uint16_t	TZEINT2_DCBEVT1:1;			// 10:10
	uint16_t	TZEINT2_FRC:1;			// 11:11
	uint16_t	TZEINT2_CAPEVT:1;			// 12:12
	uint16_t	rsvd1:3;			// 13:15   reserved
};

union TZEINT_CON_REG {
	uint16_t 		 all;
	struct TZEINT_CON_BITS 		 bit;
};

struct TZFLG_CON_BITS {			// bits   description
	uint16_t	TZFLG2_TZ1:1;			// 0:0
	uint16_t	TZFLG2_TZ2:1;			// 1:1
	uint16_t	TZFLG2_TZ3:1;			// 2:2
	uint16_t	TZFLG2_TZ4:1;			// 3:3
	uint16_t	TZFLG2_TZ5:1;			// 4:4
	uint16_t	TZFLG2_TZ6:1;			// 5:5
	uint16_t	TZFLG2_TZ7:1;			// 6:6
	uint16_t	TZFLG2_TZ8:1;			// 7:7
	uint16_t	TZFLG2_TZ9:1;			// 8:8
	uint16_t	TZFLG2_DCAEVT1:1;			// 9:9
	uint16_t	TZFLG2_DCBEVT1:1;			// 10:10
	uint16_t	TZFLG2_FRC:1;			// 11:11
	uint16_t	TZFLG2_CAPEVT:1;			// 12:12
	uint16_t	rsvd1:3;			// 13:15   reserved
};

union TZFLG_CON_REG {
	uint16_t 		 all;
	struct TZFLG_CON_BITS 		 bit;
};
#endif

struct TZFLG_BITS {			// bits   description
	uint16_t	INT:1;			// 0:0
	uint16_t	CBC:1;			// 1:1
	uint16_t	OST:1;			// 2:2
	uint16_t	DCAEVT1:1;			// 3:3
	uint16_t	DCAEVT2:1;			// 4:4
	uint16_t	DCBEVT1:1;			// 5:5
	uint16_t	DCBEVT2:1;			// 6:6
	uint16_t    CAPEVT:1;			// 7:7
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union TZFLG_REG {
	uint16_t 		 all;
	struct TZFLG_BITS 		 bit;
};

struct TZCBCFLG_BITS {			// bits   description
	uint16_t	CBC1:1;			// 0:0
	uint16_t	CBC2:1;			// 1:1
	uint16_t	CBC3:1;			// 2:2
	uint16_t	CBC4:1;			// 3:3
	uint16_t	CBC5:1;			// 4:4
	uint16_t	CBC6:1;			// 5:5
	uint16_t	DCAEVT2:1;		// 6:6
	uint16_t	DCBEVT2:1;		// 7:7
	uint16_t 	CAPEVT:1;		// 8 Capture Event Flag
	uint16_t 	rsvd1:7;		// 15:9 Reserved
};

union TZCBCFLG_REG {
	uint16_t 		 all;
	struct TZCBCFLG_BITS 		 bit;
};

struct TZOSTFLG_BITS {			// bits   description
	uint16_t	OST1:1;			// 0:0
	uint16_t	OST2:1;			// 1:1
	uint16_t	OST3:1;			// 2:2
	uint16_t	OST4:1;			// 3:3
	uint16_t	OST5:1;			// 4:4
	uint16_t	OST6:1;			// 5:5
	uint16_t	DCAEVT1:1;		// 6:6
	uint16_t	DCBEVT1:1;		// 7:7
	uint16_t 	CAPEVT:1;		// 8 Capture Event Flag
	uint16_t 	rsvd1:7;		// 15:9 Reserved
};

union TZOSTFLG_REG {
	uint16_t 		 all;
	struct TZOSTFLG_BITS 		 bit;
};

struct TZCLR_BITS {			// bits   description
	uint16_t	INT:1;			// 0:0
	uint16_t	CBC:1;			// 1:1
	uint16_t	OST:1;			// 2:2
	uint16_t	DCAEVT1:1;			// 3:3
	uint16_t	DCAEVT2:1;			// 4:4
	uint16_t	DCBEVT1:1;			// 5:5
	uint16_t	DCBEVT2:1;			// 6:6
	uint16_t 	CAPEVT:1;           // 7 Capture Event Clear
	uint16_t 	rsvd1:6;            // 13:8 Reserved
	uint16_t	CBCPULSE:2;			// 15:14
};

union TZCLR_REG {
	uint16_t 		 all;
	struct TZCLR_BITS 		 bit;
};

struct TZCBCCLR_BITS {			// bits   description
	uint16_t	CBC1:1;			// 0:0
	uint16_t	CBC2:1;			// 1:1
	uint16_t	CBC3:1;			// 2:2
	uint16_t	CBC4:1;			// 3:3
	uint16_t	CBC5:1;			// 4:4
	uint16_t	CBC6:1;			// 5:5
	uint16_t	DCAEVT2:1;		// 6:6
	uint16_t	DCBEVT2:1;		// 7:7
	uint16_t 	CAPEVT:1;       // 8 Clear Flag for CAPEVT selected for CBC
	uint16_t 	rsvd1:7;        // 15:9 Reserved
};

union TZCBCCLR_REG {
	uint16_t 		 all;
	struct TZCBCCLR_BITS 		 bit;
};

struct TZOSTCLR_BITS {			// bits   description
	uint16_t	OST1:1;			// 0:0
	uint16_t	OST2:1;			// 1:1
	uint16_t	OST3:1;			// 2:2
	uint16_t	OST4:1;			// 3:3
	uint16_t	OST5:1;			// 4:4
	uint16_t	OST6:1;			// 5:5
	uint16_t	DCAEVT1:1;		// 6:6
	uint16_t	DCBEVT1:1;		// 7:7
	uint16_t 	CAPEVT:1;       // 8 Clear Flag for CAPEVT selected for OST
	uint16_t 	rsvd1:7;        // 15:9 Reserved
};

union TZOSTCLR_REG {
	uint16_t 		 all;
	struct TZOSTCLR_BITS 		 bit;
};

struct TZFRC_BITS {			// bits   description
	uint16_t	rsvd1:1;			// 0:0   reserved
	uint16_t	CBC:1;			// 1:1
	uint16_t	OST:1;			// 2:2
	uint16_t	DCAEVT1:1;			// 3:3
	uint16_t	DCAEVT2:1;			// 4:4
	uint16_t	DCBEVT1:1;			// 5:5
	uint16_t	DCBEVT2:1;			// 6:6
	uint16_t 	CAPEVT:1;			// 7 Force Capture Event
	uint16_t 	rsvd2:8;			// 15:8 Reserved
};

union TZFRC_REG {
	uint16_t 		 all;
	struct TZFRC_BITS 		 bit;
};

struct TZCLR2_BITS {			// bits   description
	uint16_t	CBC7:1;			// 0:0
	uint16_t	CBC8:1;			// 1:1
	uint16_t	CBC9:1;			// 2:2
	uint16_t	OSHT7:1;			// 3:3
	uint16_t	OSHT8:1;			// 4:4
	uint16_t	OSHT9:1;			// 5:5
	uint16_t	rsvd1:10;			// 15:6   reserved
};

union TZCLR2_REG {
	uint16_t 		 all;
	struct TZCLR2_BITS 		 bit;
};

struct TZFLG2_BITS {			// bits   description
	uint16_t	CBC7:1;			// 0:0
	uint16_t	CBC8:1;			// 1:1
	uint16_t	CBC9:1;			// 2:2
	uint16_t	OSHT7:1;			// 3:3
	uint16_t	OSHT8:1;			// 4:4
	uint16_t	OSHT9:1;			// 5:5
	uint16_t	rsvd1:10;			// 15:6   reserved
};

union TZFLG2_REG {
	uint16_t 		 all;
	struct TZFLG2_BITS 		 bit;
};

struct ETSEL_BITS {			// bits   description
	uint16_t	INTSEL:3;			// 2:0
	uint16_t	INTEN:1;			// 3:3
	uint16_t	SOCASELCMP:1;			// 4:4
	uint16_t	SOCBSELCMP:1;			// 5:5
	uint16_t	INTSELCMP:1;			// 6:6
	uint16_t	rsvd1:1;			// 7:7   reserved
	uint16_t	SOCASEL:3;			// 10:8
	uint16_t	SOCAEN:1;			// 11:11
	uint16_t	SOCBSEL:3;			// 14:12
	uint16_t	SOCBEN:1;			// 15:15
};

union ETSEL_REG {
	uint16_t 		 all;
	struct ETSEL_BITS 		 bit;
};

struct ETPS_BITS {			// bits   description
	uint16_t	INTPRD:2;			// 1:0
	uint16_t	INTCNT:2;			// 3:2
	uint16_t	INTPSSEL:1;			// 4:4
	uint16_t	SOCPSSEL:1;			// 5:5
	uint16_t	rsvd1:2;			// 7:6   reserved
	uint16_t	SOCAPRD:2;			// 9:8
	uint16_t	SOCACNT:2;			// 11:10
	uint16_t	SOCBPRD:2;			// 13:12
	uint16_t	SOCBCNT:2;			// 15:14
};

union ETPS_REG {
	uint16_t 		 all;
	struct ETPS_BITS 		 bit;
};

struct ETFLG_BITS {			// bits   description
	uint16_t	INT:1;			// 0:0
	uint16_t	rsvd1:1;			// 1:1   reserved
	uint16_t	SOCA:1;			// 2:2
	uint16_t	SOCB:1;			// 3:3
	uint16_t	rsvd2:12;			// 15:4   reserved
};

union ETFLG_REG {
	uint16_t 		 all;
	struct ETFLG_BITS 		 bit;
};

struct ETCLR_BITS {			// bits   description
	uint16_t	INT:1;			// 0:0
	uint16_t	rsvd1:1;			// 1:1   reserved
	uint16_t	SOCA:1;			// 2:2
	uint16_t	SOCB:1;			// 3:3
	uint16_t	rsvd2:12;			// 15:4   reserved
};

union ETCLR_REG {
	uint16_t 		 all;
	struct ETCLR_BITS 		 bit;
};

struct ETFRC_BITS {			// bits   description
	uint16_t	INT:1;			// 0:0
	uint16_t	rsvd1:1;			// 1:1   reserved
	uint16_t	SOCA:1;			// 2:2
	uint16_t	SOCB:1;			// 3:3
	uint16_t	rsvd2:12;			// 15:4   reserved
};

union ETFRC_REG {
	uint16_t 		 all;
	struct ETFRC_BITS 		 bit;
};

struct ETINTPS_BITS {			// bits   description
	uint16_t	INTPRD2:4;			// 3:0
	uint16_t	INTCNT2:4;			// 7:4
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union ETINTPS_REG {
	uint16_t 		 all;
	struct ETINTPS_BITS 		 bit;
};

struct ETSOCPS_BITS {			// bits   description
	uint16_t	SOCAPRD2:4;			// 3:0
	uint16_t	SOCACNT2:4;			// 7:4
	uint16_t	SOCBPRD2:4;			// 11:8
	uint16_t	SOCBCNT2:4;			// 15:12
};

union ETSOCPS_REG {
	uint16_t 		 all;
	struct ETSOCPS_BITS 		 bit;
};

struct ETCNTINITCTL_BITS {			// bits   description
	uint16_t	rsvd1:10;			// 9:0   reserved
	uint16_t	INTINITFRC:1;			// 10:10
	uint16_t	SOCAINITFRC:1;			// 11:11
	uint16_t	SOCBINITFRC:1;			// 12:12
	uint16_t	INTINITEN:1;			// 13:13
	uint16_t	SOCAINITEN:1;			// 14:14
	uint16_t	SOCBINITEN:1;			// 15:15
};

union ETCNTINITCTL_REG {
	uint16_t 		 all;
	struct ETCNTINITCTL_BITS 		 bit;
};

struct ETCNTINIT_BITS {			// bits   description
	uint16_t	INTINIT:4;			// 3:0
	uint16_t	SOCAINIT:4;			// 7:4
	uint16_t	SOCBINIT:4;			// 11:8
	uint16_t	rsvd1:4;			// 15:12   reserved
};

union ETCNTINIT_REG {
	uint16_t 		 all;
	struct ETCNTINIT_BITS 		 bit;
};

struct DCTRIPSEL_BITS {			// bits   description
	uint16_t	DCAHCOMPSEL:4;			// 3:0
	uint16_t	DCALCOMPSEL:4;			// 7:4
	uint16_t	DCBHCOMPSEL:4;			// 11:8
	uint16_t	DCBLCOMPSEL:4;			// 15:12
};

union DCTRIPSEL_REG {
	uint16_t 		 all;
	struct DCTRIPSEL_BITS 		 bit;
};

#if (EPWM_VERSION==12) || (EPWM_VERSION==30)
struct DCTRIPSELEXP_BITS {			// bits   description
	uint16_t	DCAHCOMPSEL_EXP:1;			// 0:0
	uint16_t	DCALCOMPSEL_EXP:1;			// 1:1
	uint16_t	DCBHCOMPSEL_EXP:1;			// 2:2
	uint16_t	DCBLCOMPSEL_EXP:1;			// 3:3
	uint16_t	rsvd1:12;			// 15:4   reserved
};

union DCTRIPSELEXP_REG {
	uint16_t 		 all;
	struct DCTRIPSELEXP_BITS 		 bit;
};

#elif (EPWM_VERSION==22)
struct DCTRIPSELEXP_BITS {			// bits   description
	uint16_t	DCAHCOMPSEL_EXP:2;			// 0:1
	uint16_t	DCALCOMPSEL_EXP:2;			// 2:3
	uint16_t	DCBHCOMPSEL_EXP:2;			// 4:5
	uint16_t	DCBLCOMPSEL_EXP:2;			// 6:7
	uint16_t	rsvd1:8;			// 15:8   reserved
};

union DCTRIPSELEXP_REG {
	uint16_t 		 all;
	struct DCTRIPSELEXP_BITS 		 bit;
};
#endif

struct DCACTL_BITS {			// bits   description
	uint16_t	EVT1SRCSEL:1;			// 0:0
	uint16_t	EVT1FRCSYNCSEL:1;			// 1:1
	uint16_t	EVT1SOCE:1;			// 2:2
	uint16_t	EVT1SYNCE:1;			// 3:3
	uint16_t	EVT1LATSEL:1;			// 4:4
	uint16_t	EVT1LATCLRSEL:2;			// 6:5
	uint16_t	EVT1LAT:1;			// 7:7
	uint16_t	EVT2SRCSEL:1;			// 8:8
	uint16_t	EVT2FRCSYNCSEL:1;			// 9:9
	uint16_t	rsvd1:2;			// 11:10   reserved
	uint16_t	EVT2LATSEL:1;			// 12:12
	uint16_t	EVT2LATCLRSEL:2;			// 14:13
	uint16_t	EVT2LAT:1;			// 15:15
};

union DCACTL_REG {
	uint16_t 		 all;
	struct DCACTL_BITS 		 bit;
};

struct DCBCTL_BITS {			// bits   description
	uint16_t	EVT1SRCSEL:1;			// 0:0
	uint16_t	EVT1FRCSYNCSEL:1;			// 1:1
	uint16_t	EVT1SOCE:1;			// 2:2
	uint16_t	EVT1SYNCE:1;			// 3:3
	uint16_t	EVT1LATSEL:1;			// 4:4
	uint16_t	EVT1LATCLRSEL:2;			// 6:5
	uint16_t	EVT1LAT:1;			// 7:7
	uint16_t	EVT2SRCSEL:1;			// 8:8
	uint16_t	EVT2FRCSYNCSEL:1;			// 9:9
	uint16_t	rsvd1:2;			// 11:10   reserved
	uint16_t	EVT2LATSEL:1;			// 12:12
	uint16_t	EVT2LATCLRSEL:2;			// 14:13
	uint16_t	EVT2LAT:1;			// 15:15
};

union DCBCTL_REG {
	uint16_t 		 all;
	struct DCBCTL_BITS 		 bit;
};

struct DCFCTL_BITS {			// bits   description
	uint16_t	SRCSEL:2;			// 1:0
	uint16_t	BLANKE:1;			// 2:2
	uint16_t	BLANKINV:1;			// 3:3
	uint16_t	PULSESEL:2;			// 5:4
	uint16_t	EDGEFILTSEL:1;			// 6:6
	uint16_t	rsvd1:1;			// 7:7   reserved
	uint16_t	EDGEMODE:2;			// 9:8
	uint16_t	EDGECOUNT:3;			// 12:10
	uint16_t	EDGESTATUS:3;			// 15:13
};

union DCFCTL_REG {
	uint16_t 		 all;
	struct DCFCTL_BITS 		 bit;
};

struct DCCAPCTL_BITS {			// bits   description
	uint16_t	CAPE:1;			// 0:0
	uint16_t	SHDWMODE:1;			// 1:1
	uint16_t	rsvd1:11;			// 12:2   reserved
	uint16_t	CAPSTS:1;			// 13:13
	uint16_t	CAPCLR:1;			// 14:14
	uint16_t	CAPMODE:1;			// 15:15
};

union DCCAPCTL_REG {
	uint16_t 		 all;
	struct DCCAPCTL_BITS 		 bit;
};

struct DCFOFFSET_BITS {			// bits   description
	uint16_t	DCFOFFSET:16;			// 15:0
};

union DCFOFFSET_REG {
	uint16_t 		 all;
	struct DCFOFFSET_BITS 		 bit;
};

struct DCFOFFSETCNT_BITS {			// bits   description
	uint16_t	DCFOFFSETCNT:16;			// 15:0
};

union DCFOFFSETCNT_REG {
	uint16_t 		 all;
	struct DCFOFFSETCNT_BITS 		 bit;
};

struct DCFWINDOW_BITS {			// bits   description
	uint16_t	DCFWINDOW:16;			// 15:0
};

union DCFWINDOW_REG {
	uint16_t 		 all;
	struct DCFWINDOW_BITS 		 bit;
};

struct DCFWINDOWCNT_BITS {			// bits   description
	uint16_t	DCFWINDOWCNT:16;			// 15:0
};

union DCFWINDOWCNT_REG {
	uint16_t 		 all;
	struct DCFWINDOWCNT_BITS 		 bit;
};

struct BLANKPULSEMIXSEL_BITS {			// bits   description
	uint16_t	ZRO:1;			// 0:0
	uint16_t	PRD:1;			// 1:1
	uint16_t	CAU:1;			// 2:2
	uint16_t	CAD:1;			// 3:3
	uint16_t	CBU:1;			// 4:4
	uint16_t	CBD:1;			// 5:5
	uint16_t	CCU:1;			// 6:6
	uint16_t	CCD:1;			// 7:7
	uint16_t	CDU:1;			// 8:8
	uint16_t	CDD:1;			// 9:9
	uint16_t	CA1U:1;			// 10:10
	uint16_t	CA1D:1;			// 11:11
	uint16_t	CB1U:1;			// 12:12
	uint16_t	CB1D:1;			// 13:13
	uint16_t	rsvd1:2;			// 15:14   reserved
};

union BLANKPULSEMIXSEL_REG {
	uint16_t 		 all;
	struct BLANKPULSEMIXSEL_BITS 		 bit;
};

struct DCCAP_BITS {			// bits   description
	uint16_t	DCCAP:16;			// 15:0
};

union DCCAP_REG {
	uint16_t 		 all;
	struct DCCAP_BITS 		 bit;
};

struct DCAHTRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0
	uint16_t	TRIPINPUT2:1;			// 1:1
	uint16_t	TRIPINPUT3:1;			// 2:2
	uint16_t	TRIPINPUT4:1;			// 3:3
	uint16_t	TRIPINPUT5:1;			// 4:4
	uint16_t	TRIPINPUT6:1;			// 5:5
	uint16_t	TRIPINPUT7:1;			// 6:6
	uint16_t	TRIPINPUT8:1;			// 7:7
	uint16_t	TRIPINPUT9:1;			// 8:8
	uint16_t	TRIPINPUT10:1;			// 9:9
	uint16_t	TRIPINPUT11:1;			// 10:10
	uint16_t	TRIPINPUT12:1;			// 11:11
	uint16_t	rsvd1:1;			// 12:12   reserved
	uint16_t	TRIPINPUT14:1;			// 13:13
	uint16_t	TRIPINPUT15:1;			// 14:14
	uint16_t	rsvd2:1;			// 15:15   reserved
};

union DCAHTRIPSEL_REG {
	uint16_t 		 all;
	struct DCAHTRIPSEL_BITS 		 bit;
};

struct DCALTRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0
	uint16_t	TRIPINPUT2:1;			// 1:1
	uint16_t	TRIPINPUT3:1;			// 2:2
	uint16_t	TRIPINPUT4:1;			// 3:3
	uint16_t	TRIPINPUT5:1;			// 4:4
	uint16_t	TRIPINPUT6:1;			// 5:5
	uint16_t	TRIPINPUT7:1;			// 6:6
	uint16_t	TRIPINPUT8:1;			// 7:7
	uint16_t	TRIPINPUT9:1;			// 8:8
	uint16_t	TRIPINPUT10:1;			// 9:9
	uint16_t	TRIPINPUT11:1;			// 10:10
	uint16_t	TRIPINPUT12:1;			// 11:11
	uint16_t	rsvd1:1;			// 12:12   reserved
	uint16_t	TRIPINPUT14:1;			// 13:13
	uint16_t	TRIPINPUT15:1;			// 14:14
	uint16_t	rsvd2:1;			// 15:15   reserved
};

union DCALTRIPSEL_REG {
	uint16_t 		 all;
	struct DCALTRIPSEL_BITS 		 bit;
};

struct DCBHTRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0
	uint16_t	TRIPINPUT2:1;			// 1:1
	uint16_t	TRIPINPUT3:1;			// 2:2
	uint16_t	TRIPINPUT4:1;			// 3:3
	uint16_t	TRIPINPUT5:1;			// 4:4
	uint16_t	TRIPINPUT6:1;			// 5:5
	uint16_t	TRIPINPUT7:1;			// 6:6
	uint16_t	TRIPINPUT8:1;			// 7:7
	uint16_t	TRIPINPUT9:1;			// 8:8
	uint16_t	TRIPINPUT10:1;			// 9:9
	uint16_t	TRIPINPUT11:1;			// 10:10
	uint16_t	TRIPINPUT12:1;			// 11:11
	uint16_t	rsvd1:1;			// 12:12   reserved
	uint16_t	TRIPINPUT14:1;			// 13:13
	uint16_t	TRIPINPUT15:1;			// 14:14
	uint16_t	rsvd2:1;			// 15:15   reserved
};

union DCBHTRIPSEL_REG {
	uint16_t 		 all;
	struct DCBHTRIPSEL_BITS 		 bit;
};

struct DCBLTRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0
	uint16_t	TRIPINPUT2:1;			// 1:1
	uint16_t	TRIPINPUT3:1;			// 2:2
	uint16_t	TRIPINPUT4:1;			// 3:3
	uint16_t	TRIPINPUT5:1;			// 4:4
	uint16_t	TRIPINPUT6:1;			// 5:5
	uint16_t	TRIPINPUT7:1;			// 6:6
	uint16_t	TRIPINPUT8:1;			// 7:7
	uint16_t	TRIPINPUT9:1;			// 8:8
	uint16_t	TRIPINPUT10:1;			// 9:9
	uint16_t	TRIPINPUT11:1;			// 10:10
	uint16_t	TRIPINPUT12:1;			// 11:11
	uint16_t	rsvd1:1;			// 12:12   reserved
	uint16_t	TRIPINPUT14:1;			// 13:13
	uint16_t	TRIPINPUT15:1;			// 14:14
	uint16_t	rsvd2:1;			// 15:15   reserved
};

union DCBLTRIPSEL_REG {
	uint16_t 		 all;
	struct DCBLTRIPSEL_BITS 		 bit;
};

struct EPWM_REGS_LOCK_BITS {			// bits   description
	uint32_t	EPWM_REGS_LOCK:1;			// 0:0
};

union EPWM_REGS_LOCK_REG {
	uint32_t 		 all;
	struct EPWM_REGS_LOCK_BITS 		 bit;
};

struct HWVDELVAL_BITS {			// bits   description
	uint16_t	HWVDELVAL:16;			// 15:0
};

union HWVDELVAL_REG {
	uint16_t 		 all;
	struct HWVDELVAL_BITS 		 bit;
};

struct VCNTVAL_BITS {			// bits   description
	uint16_t	VCNTVAL:16;			// 15:0
};

union VCNTVAL_REG {
	uint16_t 		 all;
	struct VCNTVAL_BITS 		 bit;
};

//
// EPWM Tbctr Change Control Register
//
struct EPWM_TBCTR_CHG_BITS {			// bits   description
	uint32_t	EPWMA_TBCTR_CHG_EN:1;			// 0:0   EPWMA Tbctr change enable Register
	uint32_t	EPWMA_TBCTR_CHG_SFT:1;			// 1:1   EPWMA Tbctr change software force register
	uint32_t	EPWMA_TBCTR_CHG_MODE:2;			// 3:2   EPWMA Tbctr Select the configuration register at the recovery time point after the change
	uint32_t	EPWMB_TBCTR_CHG_EN:1;			// 4:4   EPWMB Tbctr change enable Register
	uint32_t	EPWMB_TBCTR_CHG_SFT:1;			// 5:5   EPWMB Tbctr change software force register
	uint32_t	EPWMB_TBCTR_CHG_MODE:2;			// 7:6   EPWMB Tbctr Select the configuration register at the recovery time point after the change
	uint32_t	rsvd1:24;			// 31:8   Reserved
};

union EPWM_TBCTR_CHG_REG {
	uint32_t 		 all;
	struct EPWM_TBCTR_CHG_BITS 		 bit;
};

//
// Event Trigger Selection Register 2
//
struct ETSELEXP_BITS {			// bits   description
	uint32_t	ETSEL2_EN:1;			// 0:0
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	INTSEL2:4;			// 7:4
	uint32_t	SOCASEL2:4;			// 11:8
	uint32_t	SOCBSEL2:4;			// 15:12
	uint32_t	rsvd2:16;			// 31:16   Reserved
};

union ETSELEXP_REG {
	uint32_t 		 all;
	struct ETSELEXP_BITS 		 bit;
};

//
// EPWM Enable Control Register
//
struct EPWM_EN_BITS {			// bits   description
	uint32_t	CHP_DUTY_EN:1;			// 0:0
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	TBPRD_UPDATE_EN:1;			// 4:4
	uint32_t	rsvd2:3;			// 7:5   Reserved
	uint32_t	TBCTR_EXP_EN:1;			// 8:8
	uint32_t	rsvd3:3;			// 11:9   Reserved
	uint32_t	AQ_TOGGLE_EN:1;			// 12:12
	uint32_t	rsvd4:3;			// 15:13   Reserved
	uint32_t	DC_EDGECOUNT_EN:1;			// 16:16
	uint32_t	rsvd5:3;			// 19:17   Reserved
	uint32_t	ET_INT_MODE:1;			// 20:20
	uint32_t	rsvd6:3;			// 23:21   Reserved
	uint32_t	CMP_SHADOW_EN:1;			// 24:24
	uint32_t	rsvd7:7;			// 31:25   Reserved
};

union EPWM_EN_REG {
	uint32_t 		 all;
	struct EPWM_EN_BITS 		 bit;
};

//
// Digital Compare AL Trip Select 2
//
#if (EPWM_VERSION==12) || (EPWM_VERSION==30)
struct DCTRIPSEL2_DCAL_BITS {			// bits   description
	uint16_t	TRIPINPUT16_DCAL:1;			// 0:0   TRIP Input TZ7
	uint16_t	TRIPINPUT17_DCAL:1;			// 1:1   TRIP Input TZ8
	uint16_t	TRIPINPUT18_DCAL:1;			// 2:2   TRIP Input TZ9
	uint16_t	TRIPINPUT19_DCAL:1;			// 3:3   TRIP Input 19
	uint16_t	TRIPINPUT20_DCAL:1;			// 4:4   TRIP Input 20
	uint16_t	TRIPINPUT21_DCAL:1;			// 5:5   TRIP Input 21
	uint16_t	TRIPINPUT22_DCAL:1;			// 6:6   TRIP Input 22
	uint16_t	TRIPINPUT23_DCAL:1;			// 7:7   TRIP Input 23
	uint16_t	TRIPINPUT24_DCAL:1;			// 8:8   TRIP Input 24
	uint16_t	rsvd1:7;			// 15:9   Reserved
};

union DCTRIPSEL2_DCAL_REG {
	uint16_t 		 all;
	struct DCTRIPSEL2_DCAL_BITS 		 bit;
};

//
// Digital Compare AH Trip Select 2
//
struct DCTRIPSEL2_DCAH_BITS {			// bits   description
	uint16_t	TRIPINPUT16_DCAH:1;			// 0:0   TRIP Input TZ7
	uint16_t	TRIPINPUT17_DCAH:1;			// 1:1   TRIP Input TZ8
	uint16_t	TRIPINPUT18_DCAH:1;			// 2:2   TRIP Input TZ9
	uint16_t	TRIPINPUT19_DCAH:1;			// 3:3   TRIP Input 19
	uint16_t	TRIPINPUT20_DCAH:1;			// 4:4   TRIP Input 20
	uint16_t	TRIPINPUT21_DCAH:1;			// 5:5   TRIP Input 21
	uint16_t	TRIPINPUT22_DCAH:1;			// 6:6   TRIP Input 22
	uint16_t	TRIPINPUT23_DCAH:1;			// 7:7   TRIP Input 23
	uint16_t	TRIPINPUT24_DCAH:1;			// 8:8   TRIP Input 24
	uint16_t	rsvd1:7;			// 15:9   Reserved
};

union DCTRIPSEL2_DCAH_REG {
	uint16_t 		 all;
	struct DCTRIPSEL2_DCAH_BITS 		 bit;
};

//
// Digital Compare BL Trip Select 2
//
struct DCTRIPSEL2_DCBL_BITS {			// bits   description
	uint16_t	TRIPINPUT16_DCBL:1;			// 0:0   TRIP Input TZ7
	uint16_t	TRIPINPUT17_DCBL:1;			// 1:1   TRIP Input TZ8
	uint16_t	TRIPINPUT18_DCBL:1;			// 2:2   TRIP Input TZ9
	uint16_t	TRIPINPUT19_DCBL:1;			// 3:3   TRIP Input 19
	uint16_t	TRIPINPUT20_DCBL:1;			// 4:4   TRIP Input 20
	uint16_t	TRIPINPUT21_DCBL:1;			// 5:5   TRIP Input 21
	uint16_t	TRIPINPUT22_DCBL:1;			// 6:6   TRIP Input 22
	uint16_t	TRIPINPUT23_DCBL:1;			// 7:7   TRIP Input 23
	uint16_t	TRIPINPUT24_DCBL:1;			// 8:8   TRIP Input 24
	uint16_t	rsvd1:7;			// 15:9   Reserved
};

union DCTRIPSEL2_DCBL_REG {
	uint16_t 		 all;
	struct DCTRIPSEL2_DCBL_BITS 		 bit;
};

//
// Digital Compare BH Trip Select 2
//
struct DCTRIPSEL2_DCBH_BITS {			// bits   description
	uint16_t	TRIPINPUT16_DCBH:1;			// 0:0   TRIP Input TZ7
	uint16_t	TRIPINPUT17_DCBH:1;			// 1:1   TRIP Input TZ8
	uint16_t	TRIPINPUT18_DCBH:1;			// 2:2   TRIP Input TZ9
	uint16_t	TRIPINPUT19_DCBH:1;			// 3:3   TRIP Input 19
	uint16_t	TRIPINPUT20_DCBH:1;			// 4:4   TRIP Input 20
	uint16_t	TRIPINPUT21_DCBH:1;			// 5:5   TRIP Input 21
	uint16_t	TRIPINPUT22_DCBH:1;			// 6:6   TRIP Input 22
	uint16_t	TRIPINPUT23_DCBH:1;			// 7:7   TRIP Input 23
	uint16_t	TRIPINPUT24_DCBH:1;			// 8:8   TRIP Input 24
	uint16_t	rsvd1:7;			// 15:9   Reserved
};

union DCTRIPSEL2_DCBH_REG {
	uint16_t 		 all;
	struct DCTRIPSEL2_DCBH_BITS 		 bit;
};

#elif (EPWM_VERSION==22)
struct DCTRIPSEL2_DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT16_DCAL:1;			// 0:0   TRIP Input TZ7
	uint32_t	TRIPINPUT17_DCAL:1;			// 1:1   TRIP Input TZ8
	uint32_t	TRIPINPUT18_DCAL:1;			// 2:2   TRIP Input TZ9
	uint32_t	TRIPINPUT19_DCAL:1;			// 3:3   TRIP Input 19
	uint32_t	TRIPINPUT20_DCAL:1;			// 4:4   TRIP Input 20
	uint32_t	TRIPINPUT21_DCAL:1;			// 5:5   TRIP Input 21
	uint32_t	TRIPINPUT22_DCAL:1;			// 6:6   TRIP Input 22
	uint32_t	TRIPINPUT23_DCAL:1;			// 7:7   TRIP Input 23
	uint32_t	TRIPINPUT24_DCAL:1;			// 8:8   TRIP Input 24
	uint32_t	TRIPINPUT25_DCAL:1;			// 9:9   TRIP Input 25
	uint32_t	TRIPINPUT26_DCAL:1;			// 10:10   TRIP Input 26
	uint32_t	TRIPINPUT27_DCAL:1;			// 11:11   TRIP Input 27
	uint32_t	TRIPINPUT28_DCAL:1;			// 12:12   TRIP Input 28
	uint32_t	TRIPINPUT29_DCAL:1;			// 13:13   TRIP Input 29
	uint32_t	TRIPINPUT30_DCAL:1;			// 14:14   TRIP Input 30
	uint32_t	TRIPINPUT31_DCAL:1;			// 15:15   TRIP Input 31
	uint32_t	TRIPINPUT32_DCAL:1;			// 16:16   TRIP Input 32
	uint32_t	TRIPINPUT33_DCAL:1;			// 17:17   TRIP Input 33
	uint32_t	TRIPINPUT34_DCAL:1;			// 18:18   TRIP Input 34
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union DCTRIPSEL2_DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_DCAL_BITS 		 bit;
};

//
// Digital Compare AH Trip Select 2
//
struct DCTRIPSEL2_DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT16_DCAH:1;			// 0:0   TRIP Input TZ7
	uint32_t	TRIPINPUT17_DCAH:1;			// 1:1   TRIP Input TZ8
	uint32_t	TRIPINPUT18_DCAH:1;			// 2:2   TRIP Input TZ9
	uint32_t	TRIPINPUT19_DCAH:1;			// 3:3   TRIP Input 19
	uint32_t	TRIPINPUT20_DCAH:1;			// 4:4   TRIP Input 20
	uint32_t	TRIPINPUT21_DCAH:1;			// 5:5   TRIP Input 21
	uint32_t	TRIPINPUT22_DCAH:1;			// 6:6   TRIP Input 22
	uint32_t	TRIPINPUT23_DCAH:1;			// 7:7   TRIP Input 23
	uint32_t	TRIPINPUT24_DCAH:1;			// 8:8   TRIP Input 24
	uint32_t	TRIPINPUT25_DCAH:1;			// 9:9   TRIP Input 25
	uint32_t	TRIPINPUT26_DCAH:1;			// 10:10   TRIP Input 26
	uint32_t	TRIPINPUT27_DCAH:1;			// 11:11   TRIP Input 27
	uint32_t	TRIPINPUT28_DCAH:1;			// 12:12   TRIP Input 28
	uint32_t	TRIPINPUT29_DCAH:1;			// 13:13   TRIP Input 29
	uint32_t	TRIPINPUT30_DCAH:1;			// 14:14   TRIP Input 30
	uint32_t	TRIPINPUT31_DCAH:1;			// 15:15   TRIP Input 31
	uint32_t	TRIPINPUT32_DCAH:1;			// 16:16   TRIP Input 32
	uint32_t	TRIPINPUT33_DCAH:1;			// 17:17   TRIP Input 33
	uint32_t	TRIPINPUT34_DCAH:1;			// 18:18   TRIP Input 34
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union DCTRIPSEL2_DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_DCAH_BITS 		 bit;
};

//
// Digital Compare BL Trip Select 2
//
struct DCTRIPSEL2_DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT16_DCBL:1;			// 0:0   TRIP Input TZ7
	uint32_t	TRIPINPUT17_DCBL:1;			// 1:1   TRIP Input TZ8
	uint32_t	TRIPINPUT18_DCBL:1;			// 2:2   TRIP Input TZ9
	uint32_t	TRIPINPUT19_DCBL:1;			// 3:3   TRIP Input 19
	uint32_t	TRIPINPUT20_DCBL:1;			// 4:4   TRIP Input 20
	uint32_t	TRIPINPUT21_DCBL:1;			// 5:5   TRIP Input 21
	uint32_t	TRIPINPUT22_DCBL:1;			// 6:6   TRIP Input 22
	uint32_t	TRIPINPUT23_DCBL:1;			// 7:7   TRIP Input 23
	uint32_t	TRIPINPUT24_DCBL:1;			// 8:8   TRIP Input 24
	uint32_t	TRIPINPUT25_DCBL:1;			// 9:9   TRIP Input 25
	uint32_t	TRIPINPUT26_DCBL:1;			// 10:10   TRIP Input 26
	uint32_t	TRIPINPUT27_DCBL:1;			// 11:11   TRIP Input 27
	uint32_t	TRIPINPUT28_DCBL:1;			// 12:12   TRIP Input 28
	uint32_t	TRIPINPUT29_DCBL:1;			// 13:13   TRIP Input 29
	uint32_t	TRIPINPUT30_DCBL:1;			// 14:14   TRIP Input 30
	uint32_t	TRIPINPUT31_DCBL:1;			// 15:15   TRIP Input 31
	uint32_t	TRIPINPUT32_DCBL:1;			// 16:16   TRIP Input 32
	uint32_t	TRIPINPUT33_DCBL:1;			// 17:17   TRIP Input 33
	uint32_t	TRIPINPUT34_DCBL:1;			// 18:18   TRIP Input 34
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union DCTRIPSEL2_DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_DCBL_BITS 		 bit;
};

//
// Digital Compare BH Trip Select 2
//
struct DCTRIPSEL2_DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT16_DCBH:1;			// 0:0   TRIP Input TZ7
	uint32_t	TRIPINPUT17_DCBH:1;			// 1:1   TRIP Input TZ8
	uint32_t	TRIPINPUT18_DCBH:1;			// 2:2   TRIP Input TZ9
	uint32_t	TRIPINPUT19_DCBH:1;			// 3:3   TRIP Input 19
	uint32_t	TRIPINPUT20_DCBH:1;			// 4:4   TRIP Input 20
	uint32_t	TRIPINPUT21_DCBH:1;			// 5:5   TRIP Input 21
	uint32_t	TRIPINPUT22_DCBH:1;			// 6:6   TRIP Input 22
	uint32_t	TRIPINPUT23_DCBH:1;			// 7:7   TRIP Input 23
	uint32_t	TRIPINPUT24_DCBH:1;			// 8:8   TRIP Input 24
	uint32_t	TRIPINPUT25_DCBH:1;			// 9:9   TRIP Input 25
	uint32_t	TRIPINPUT26_DCBH:1;			// 10:10   TRIP Input 26
	uint32_t	TRIPINPUT27_DCBH:1;			// 11:11   TRIP Input 27
	uint32_t	TRIPINPUT28_DCBH:1;			// 12:12   TRIP Input 28
	uint32_t	TRIPINPUT29_DCBH:1;			// 13:13   TRIP Input 29
	uint32_t	TRIPINPUT30_DCBH:1;			// 14:14   TRIP Input 30
	uint32_t	TRIPINPUT31_DCBH:1;			// 15:15   TRIP Input 31
	uint32_t	TRIPINPUT32_DCBH:1;			// 16:16   TRIP Input 32
	uint32_t	TRIPINPUT33_DCBH:1;			// 17:17   TRIP Input 33
	uint32_t	TRIPINPUT34_DCBH:1;			// 18:18   TRIP Input 34
	uint32_t	rsvd1:13;			// 31:19   Reserved
};

union DCTRIPSEL2_DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_DCBH_BITS 		 bit;
};
#endif


//
// Digital Compare AL Trip Select New1
//
struct DCTRIPSEL_1DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_1DCAL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_1DCAL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_1DCAL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_1DCAL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_1DCAL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_1DCAL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_1DCAL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_1DCAL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_1DCAL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_1DCAL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_1DCAL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_1DCAL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_1DCAL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_1DCAL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_1DCAL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_1DCAL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_1DCAL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_1DCAL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_1DCAL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_1DCAL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_1DCAL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_1DCAL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_1DCAL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_1DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_1DCAL_BITS 		 bit;
};

//
// Digital Compare AL Trip Select New2
//
struct DCTRIPSEL_2DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_2DCAL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_2DCAL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_2DCAL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_2DCAL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_2DCAL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_2DCAL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_2DCAL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_2DCAL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_2DCAL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_2DCAL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_2DCAL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_2DCAL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_2DCAL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_2DCAL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_2DCAL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_2DCAL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_2DCAL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_2DCAL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_2DCAL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_2DCAL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_2DCAL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_2DCAL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_2DCAL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_2DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_2DCAL_BITS 		 bit;
};

//
// Digital Compare AL Trip Select New3
//
struct DCTRIPSEL_3DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_3DCAL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_3DCAL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_3DCAL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_3DCAL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_3DCAL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_3DCAL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_3DCAL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_3DCAL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_3DCAL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_3DCAL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_3DCAL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_3DCAL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_3DCAL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_3DCAL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_3DCAL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_3DCAL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_3DCAL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_3DCAL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_3DCAL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_3DCAL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_3DCAL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_3DCAL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_3DCAL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_3DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_3DCAL_BITS 		 bit;
};

//
// Digital Compare AH Trip Select New1
//
struct DCTRIPSEL_1DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_1DCAH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_1DCAH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_1DCAH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_1DCAH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_1DCAH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_1DCAH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_1DCAH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_1DCAH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_1DCAH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_1DCAH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_1DCAH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_1DCAH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_1DCAH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_1DCAH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_1DCAH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_1DCAH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_1DCAH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_1DCAH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_1DCAH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_1DCAH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_1DCAH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_1DCAH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_1DCAH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_1DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_1DCAH_BITS 		 bit;
};

//
// Digital Compare AH Trip Select New2
//
struct DCTRIPSEL_2DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_2DCAH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_2DCAH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_2DCAH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_2DCAH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_2DCAH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_2DCAH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_2DCAH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_2DCAH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_2DCAH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_2DCAH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_2DCAH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_2DCAH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_2DCAH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_2DCAH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_2DCAH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_2DCAH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_2DCAH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_2DCAH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_2DCAH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_2DCAH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_2DCAH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_2DCAH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_2DCAH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_2DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_2DCAH_BITS 		 bit;
};

//
// Digital Compare AH Trip Select New3
//
struct DCTRIPSEL_3DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_3DCAH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_3DCAH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_3DCAH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_3DCAH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_3DCAH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_3DCAH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_3DCAH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_3DCAH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_3DCAH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_3DCAH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_3DCAH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_3DCAH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_3DCAH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_3DCAH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_3DCAH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_3DCAH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_3DCAH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_3DCAH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_3DCAH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_3DCAH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_3DCAH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_3DCAH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_3DCAH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_3DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_3DCAH_BITS 		 bit;
};

//
// Digital Compare BL Trip Select New1
//
struct DCTRIPSEL_1DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_1DCBL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_1DCBL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_1DCBL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_1DCBL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_1DCBL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_1DCBL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_1DCBL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_1DCBL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_1DCBL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_1DCBL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_1DCBL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_1DCBL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_1DCBL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_1DCBL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_1DCBL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_1DCBL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_1DCBL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_1DCBL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_1DCBL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_1DCBL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_1DCBL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_1DCBL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_1DCBL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_1DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_1DCBL_BITS 		 bit;
};

//
// Digital Compare BL Trip Select New2
//
struct DCTRIPSEL_2DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_2DCBL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_2DCBL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_2DCBL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_2DCBL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_2DCBL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_2DCBL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_2DCBL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_2DCBL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_2DCBL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_2DCBL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_2DCBL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_2DCBL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_2DCBL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_2DCBL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_2DCBL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_2DCBL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_2DCBL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_2DCBL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_2DCBL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_2DCBL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_2DCBL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_2DCBL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_2DCBL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_2DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_2DCBL_BITS 		 bit;
};

//
// Digital Compare BL Trip Select New3
//
struct DCTRIPSEL_3DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT1_3DCBL:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_3DCBL:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_3DCBL:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_3DCBL:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_3DCBL:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_3DCBL:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_3DCBL:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_3DCBL:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_3DCBL:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_3DCBL:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_3DCBL:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_3DCBL:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_3DCBL:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_3DCBL:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_3DCBL:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_3DCBL:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_3DCBL:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_3DCBL:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_3DCBL:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_3DCBL:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_3DCBL:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_3DCBL:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_3DCBL:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_3DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_3DCBL_BITS 		 bit;
};

//
// Digital Compare BH Trip Select New1
//
struct DCTRIPSEL_1DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_1DCBH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_1DCBH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_1DCBH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_1DCBH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_1DCBH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_1DCBH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_1DCBH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_1DCBH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_1DCBH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_1DCBH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_1DCBH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_1DCBH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_1DCBH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_1DCBH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_1DCBH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_1DCBH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_1DCBH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_1DCBH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_1DCBH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_1DCBH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_1DCBH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_1DCBH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_1DCBH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_1DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_1DCBH_BITS 		 bit;
};

//
// Digital Compare BH Trip Select New2
//
struct DCTRIPSEL_2DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_2DCBH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_2DCBH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_2DCBH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_2DCBH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_2DCBH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_2DCBH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_2DCBH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_2DCBH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_2DCBH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_2DCBH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_2DCBH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_2DCBH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_2DCBH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_2DCBH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_2DCBH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_2DCBH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_2DCBH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_2DCBH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_2DCBH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_2DCBH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_2DCBH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_2DCBH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_2DCBH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_2DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_2DCBH_BITS 		 bit;
};

//
// Digital Compare BH Trip Select New3
//
struct DCTRIPSEL_3DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT1_3DCBH:1;			// 0:0   TRIP Input 1
	uint32_t	TRIPINPUT2_3DCBH:1;			// 1:1   TRIP Input 2
	uint32_t	TRIPINPUT3_3DCBH:1;			// 2:2   TRIP Input 3
	uint32_t	TRIPINPUT4_3DCBH:1;			// 3:3   TRIP Input 4
	uint32_t	TRIPINPUT5_3DCBH:1;			// 4:4   TRIP Input 5
	uint32_t	TRIPINPUT6_3DCBH:1;			// 5:5   TRIP Input 6
	uint32_t	TRIPINPUT7_3DCBH:1;			// 6:6   TRIP Input 7
	uint32_t	TRIPINPUT8_3DCBH:1;			// 7:7   TRIP Input 8
	uint32_t	TRIPINPUT9_3DCBH:1;			// 8:8   TRIP Input 9
	uint32_t	TRIPINPUT10_3DCBH:1;			// 9:9   TRIP Input 10
	uint32_t	TRIPINPUT11_3DCBH:1;			// 10:10   TRIP Input 11
	uint32_t	TRIPINPUT12_3DCBH:1;			// 11:11   TRIP Input 12
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIPINPUT14_3DCBH:1;			// 13:13   TRIP Input 14
	uint32_t	TRIPINPUT15_3DCBH:1;			// 14:14   TRIP Input 15
	uint32_t	TRIPINPUT16_3DCBH:1;			// 15:15   TRIP Input TZ7
	uint32_t	TRIPINPUT17_3DCBH:1;			// 16:16   TRIP Input TZ8
	uint32_t	TRIPINPUT18_3DCBH:1;			// 17:17   TRIP Input TZ9
	uint32_t	TRIPINPUT19_3DCBH:1;			// 18:18   TRIP Input 19
	uint32_t	TRIPINPUT20_3DCBH:1;			// 19:19   TRIP Input 20
	uint32_t	TRIPINPUT21_3DCBH:1;			// 20:20   TRIP Input 21
	uint32_t	TRIPINPUT22_3DCBH:1;			// 21:21   TRIP Input 22
	uint32_t	TRIPINPUT23_3DCBH:1;			// 22:22   TRIP Input 23
	uint32_t	TRIPINPUT24_3DCBH:1;			// 23:23   TRIP Input 24
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DCTRIPSEL_3DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL_3DCBH_BITS 		 bit;
};

//
// Trip Zone Clear Mode Register
//
#if (EPWM_VERSION==12) || (EPWM_VERSION==22)
struct TZ_CLR_MODE_BITS {			// bits   description
	uint32_t	TZ1_CLR_MODE:2;			// 1:0   tz1 clear mode
	uint32_t	TZ2_CLR_MODE:2;			// 3:2   tz2 clear mode
	uint32_t	TZ3_CLR_MODE:2;			// 5:4   tz3 clear mode
	uint32_t	TZ4_CLR_MODE:2;			// 7:6   tz4 clear mode
	uint32_t	TZ5_CLR_MODE:2;			// 9:8   tz6 clear mode
	uint32_t	TZ6_CLR_MODE:2;			// 11:10   tz6 clear mode
	uint32_t	TZ7_CLR_MODE:2;			// 13:12   tz7 clear mode
	uint32_t	TZ8_CLR_MODE:2;			// 15:14   tz8 clear mode
	uint32_t	TZ9_CLR_MODE:2;			// 17:16   tz9 clear mode
	uint32_t	DCAEVT1_FORCE_CLR_MODE:2;			// 19:18   dcaevt1_force clear mode
	uint32_t	DCBEVT1_FORCE_CLR_MODE:2;			// 21:20   dcbevt1_force clear mode
	uint32_t	TZFRC_OST_CLR_MODE:2;			// 23:22   tzfrc_ost clear mode
	uint32_t	TZ_CLR_SEL:1;			// 24:24   TZ clear select Register
	uint32_t	rsvd1:7;			// 31:25   Reserved
};

union TZ_CLR_MODE_REG {
	uint32_t 		 all;
	struct TZ_CLR_MODE_BITS 		 bit;
};

//
// Trip Zone Clear ARM Register
//
struct TZ_CLR_ARM_BITS {			// bits   description
	uint32_t	TZ1_CLR_ARM:1;			// 0:0   ARM clear tz1
	uint32_t	TZ2_CLR_ARM:1;			// 1:1   ARM clear tz2
	uint32_t	TZ3_CLR_ARM:1;			// 2:2   ARM clear tz3
	uint32_t	TZ4_CLR_ARM:1;			// 3:3   ARM clear tz4
	uint32_t	TZ5_CLR_ARM:1;			// 4:4   ARM clear tz5
	uint32_t	TZ6_CLR_ARM:1;			// 5:5   ARM clear tz6
	uint32_t	TZ7_CLR_ARM:1;			// 6:6   ARM clear tz7
	uint32_t	TZ8_CLR_ARM:1;			// 7:7   ARM clear tz8
	uint32_t	TZ9_CLR_ARM:1;			// 8:8   ARM clear tz9
	uint32_t	DCAEVT1_FORCE_CLR_ARM:1;			// 9:9   ARM clear dcaevt1_force
	uint32_t	DCBEVT1_FORCE_CLR_ARM:1;			// 10:10   ARM clear dcbevt1_force
	uint32_t	TZFRC_OST_CLR_ARM:1;			// 11:11   ARM clear tzfrc_ost
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union TZ_CLR_ARM_REG {
	uint32_t 		 all;
	struct TZ_CLR_ARM_BITS 		 bit;
};

//
// Trip Zone Clear DSP Register
//
struct TZ_CLR_DSP_BITS {			// bits   description
	uint32_t	TZ1_CLR_DSP:1;			// 0:0   DSP clear tz1
	uint32_t	TZ2_CLR_DSP:1;			// 1:1   DSP clear tz2
	uint32_t	TZ3_CLR_DSP:1;			// 2:2   DSP clear tz3
	uint32_t	TZ4_CLR_DSP:1;			// 3:3   DSP clear tz4
	uint32_t	TZ5_CLR_DSP:1;			// 4:4   DSP clear tz5
	uint32_t	TZ6_CLR_DSP:1;			// 5:5   DSP clear tz6
	uint32_t	TZ7_CLR_DSP:1;			// 6:6   DSP clear tz7
	uint32_t	TZ8_CLR_DSP:1;			// 7:7   DSP clear tz8
	uint32_t	TZ9_CLR_DSP:1;			// 8:8   DSP clear tz9
	uint32_t	DCAEVT1_FORCE_CLR_DSP:1;			// 9:9   DSP clear dcaevt1_force
	uint32_t	DCBEVT1_FORCE_CLR_DSP:1;			// 10:10   DSP clear dcbevt1_force
	uint32_t	TZFRC_OST_CLR_DSP:1;			// 11:11   DSP clear tzfrc_ost
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union TZ_CLR_DSP_REG {
	uint32_t 		 all;
	struct TZ_CLR_DSP_BITS 		 bit;
};

#elif (EPWM_VERSION==30)
//
// Trip Zone Force Register
//
struct TZTRIPOUTSEL_BITS {			// bits   description
	uint16_t	OST_TRIPOUT:1;			// 0:0   Clear Flag for Oneshot (OST1) Trip Latch
	uint16_t	CBC_TRIPOUT:1;			// 1:1   Clear Flag for Oneshot (OST2) Trip Latch
	uint16_t	TZ1_TRIPOUT:1;			// 2:2   Clear Flag for Oneshot (OST3) Trip Latch
	uint16_t	TZ2_TRIPOUT:1;			// 3:3   Clear Flag for Oneshot (OST4) Trip Latch
	uint16_t	TZ3_TRIPOUT:1;			// 4:4   Clear Flag for Oneshot (OST5) Trip Latch
	uint16_t	TZ4_TRIPOUT:1;			// 5:5   Clear Flag for Oneshot (OST6) Trip Latch
	uint16_t	TZ5_TRIPOUT:1;			// 6:6   Clear Flag for Digital Compare Output A Event 1 selected for OST
	uint16_t	TZ6_TRIPOUT:1;			// 7:7   Clear Flag for Digital Compare Output B Event 1 selected for OST
	uint16_t	DCA1EVT_TRIPOUT:1;			// 8:8   Clear Flag for Oneshot (OST5) Trip Latch
	uint16_t	DCA2EVT_TRIPOUT:1;			// 9:9   Clear Flag for Oneshot (OST6) Trip Latch
	uint16_t	DCB1EVT_TRIPOUT:1;			// 10:10   Clear Flag for Digital Compare Output A Event 1 selected for OST
	uint16_t	DCB2EVT_TRIPOUT:1;			// 11:11   Clear Flag for Digital Compare Output B Event 1 selected for OST
	uint16_t	CAPEVT_TRIPOUT:1;			// 12:12   Clear Flag for Digital Compare Output B Event 1 selected for OST
	uint16_t	TZ7_TRIPOUT:1;			// 13:13   Clear Flag for Oneshot (OST3) Trip Latch
	uint16_t	TZ8_TRIPOUT:1;			// 14:14   Clear Flag for Oneshot (OST4) Trip Latch
	uint16_t	TZ9_TRIPOUT:1;			// 15:15   Reserved
};

union TZTRIPOUTSEL_REG {
	uint16_t 		 all;
	struct TZTRIPOUTSEL_BITS 		 bit;
};

//
// Trip Zone Clear Register 2
//
struct TZCLR_EXP_BITS {			// bits   description
	uint16_t	TZCBCCLR_7CBC:1;			// 0:0   Clear Flag for Cycle-By-Cycle (CBC7) Trip Latch
	uint16_t	TZCBCCLR_8CBC:1;			// 1:1   Clear Flag for Cycle-By-Cycle (CBC8) Trip Latch
	uint16_t	TZCBCCLR_9CBC:1;			// 2:2   Clear Flag for Cycle-By-Cycle (CBC9) Trip Latch
	uint16_t	TZOSTCLR_7OST:1;			// 3:3   Clear Flag for Oneshot (OST7) Trip Latch
	uint16_t	TZOSTCLR_8OST:1;			// 4:4   Clear Flag for Oneshot (OST8) Trip Latch
	uint16_t	TZOSTCLR_9OST:1;			// 5:5   Clear Flag for Oneshot (OST9) Trip Latch
	uint16_t	rsvd1:10;			// 15:6   Reserved
};

union TZCLR_EXP_REG {
	uint16_t 		 all;
	struct TZCLR_EXP_BITS 		 bit;
};

//
// Trip Zone Flag Register 2
//
struct TZFLG_EXP_BITS {			// bits   description
	uint16_t	TZCBCFLG_7CBC:1;			// 0:0   Latched Status Flag for CBC7 Trip Latch
	uint16_t	TZCBCFLG_8CBC:1;			// 1:1   Latched Status Flag for CBC8 Trip Latch
	uint16_t	TZCBCFLG_9CBC:1;			// 2:2   Latched Status Flag for CBC9 Trip Latch
	uint16_t	TZOSTFLG_7OST:1;			// 3:3   Latched Status Flag for OST7 Trip Latch
	uint16_t	TZOSTFLG_8OST:1;			// 4:4   Latched Status Flag for OST8 Trip Latch
	uint16_t	TZOSTFLG_9OST:1;			// 5:5   Latched Status Flag for OST9 Trip Latch
	uint16_t	rsvd1:10;			// 15:6   Reserved
};

union TZFLG_EXP_REG {
	uint16_t 		 all;
	struct TZFLG_EXP_BITS 		 bit;
};

struct TZ_CLR_MODE_BITS {			// bits   description
	uint32_t	TZ1_CLR_MODE:2;			// 1:0   tz1 clear mode
	uint32_t	TZ2_CLR_MODE:2;			// 3:2   tz2 clear mode
	uint32_t	TZ3_CLR_MODE:2;			// 5:4   tz3 clear mode
	uint32_t	TZ4_CLR_MODE:2;			// 7:6   tz4 clear mode
	uint32_t	TZ5_CLR_MODE:2;			// 9:8   tz6 clear mode
	uint32_t	TZ6_CLR_MODE:2;			// 11:10   tz6 clear mode
	uint32_t	TZ7_CLR_MODE:2;			// 13:12   tz7 clear mode
	uint32_t	TZ8_CLR_MODE:2;			// 15:14   tz8 clear mode
	uint32_t	TZ9_CLR_MODE:2;			// 17:16   tz9 clear mode
	uint32_t	DCAEVT1_FORCE_CLR_MODE:2;			// 19:18   dcaevt1_force clear mode
	uint32_t	DCBEVT1_FORCE_CLR_MODE:2;			// 21:20   dcbevt1_force clear mode
	uint32_t	TZFRC_OST_CLR_MODE:2;			// 23:22   tzfrc_ost clear mode
	uint32_t	CAPEVT_CLR_MODE:2;		// 25:24
	uint32_t	rsvd1:2;					// 27:26
	uint32_t	TZ_CLR_SEL:1;			// 28:28   TZ clear select Register
	uint32_t	rsvd2:3;			// 31:29   Reserved
};

union TZ_CLR_MODE_REG {
	uint32_t 		 all;
	struct TZ_CLR_MODE_BITS 		 bit;
};

//
// Trip Zone Clear ARM Register
//
struct TZ_CLR_ARM_BITS {			// bits   description
	uint32_t	TZ1_CLR_ARM:1;			// 0:0   ARM clear tz1
	uint32_t	TZ2_CLR_ARM:1;			// 1:1   ARM clear tz2
	uint32_t	TZ3_CLR_ARM:1;			// 2:2   ARM clear tz3
	uint32_t	TZ4_CLR_ARM:1;			// 3:3   ARM clear tz4
	uint32_t	TZ5_CLR_ARM:1;			// 4:4   ARM clear tz5
	uint32_t	TZ6_CLR_ARM:1;			// 5:5   ARM clear tz6
	uint32_t	TZ7_CLR_ARM:1;			// 6:6   ARM clear tz7
	uint32_t	TZ8_CLR_ARM:1;			// 7:7   ARM clear tz8
	uint32_t	TZ9_CLR_ARM:1;			// 8:8   ARM clear tz9
	uint32_t	DCAEVT1_FORCE_CLR_ARM:1;			// 9:9   ARM clear dcaevt1_force
	uint32_t	DCBEVT1_FORCE_CLR_ARM:1;			// 10:10   ARM clear dcbevt1_force
	uint32_t	TZFRC_OST_CLR_ARM:1;			// 11:11   ARM clear tzfrc_ost
	uint32_t	CAPEVT_CLR_ARM:1;	// 12:12
	uint32_t	rsvd1:19;			// 31:13   Reserved
};

union TZ_CLR_ARM_REG {
	uint32_t 		 all;
	struct TZ_CLR_ARM_BITS 		 bit;
};

//
// Trip Zone Clear DSP Register
//
struct TZ_CLR_DSP_BITS {			// bits   description
	uint32_t	TZ1_CLR_DSP:1;			// 0:0   DSP clear tz1
	uint32_t	TZ2_CLR_DSP:1;			// 1:1   DSP clear tz2
	uint32_t	TZ3_CLR_DSP:1;			// 2:2   DSP clear tz3
	uint32_t	TZ4_CLR_DSP:1;			// 3:3   DSP clear tz4
	uint32_t	TZ5_CLR_DSP:1;			// 4:4   DSP clear tz5
	uint32_t	TZ6_CLR_DSP:1;			// 5:5   DSP clear tz6
	uint32_t	TZ7_CLR_DSP:1;			// 6:6   DSP clear tz7
	uint32_t	TZ8_CLR_DSP:1;			// 7:7   DSP clear tz8
	uint32_t	TZ9_CLR_DSP:1;			// 8:8   DSP clear tz9
	uint32_t	DCAEVT1_FORCE_CLR_DSP:1;			// 9:9   DSP clear dcaevt1_force
	uint32_t	DCBEVT1_FORCE_CLR_DSP:1;			// 10:10   DSP clear dcbevt1_force
	uint32_t	TZFRC_OST_CLR_DSP:1;			// 11:11   DSP clear tzfrc_ost
	uint32_t	CAPEVT_CLR_DSP:1;	// 12:12
	uint32_t	rsvd1:19;			// 31:13   Reserved
};

union TZ_CLR_DSP_REG {
	uint32_t 		 all;
	struct TZ_CLR_DSP_BITS 		 bit;
};


//
// Event-Trigger Counter Initialization Register
//
struct ETINTMIXEN_BITS {			// bits   description
	uint16_t	ZRO:1;			// 0:0   Enable event time-base counter equal to zero (TBCTR = 0x00) to the
	uint16_t	PRD:1;			// 1:1   Enable event time-base counter equal to period (TBCTR = TBPRD)
	uint16_t	CAU:1;			// 2:2   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CAD:1;			// 3:3   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CBU:1;			// 4:4   Enable event time-base counter equal to CMPB when the
	uint16_t	CBD:1;			// 5:5   Enable event time-base counter equal to CMPB when the timer is
	uint16_t	CCU:1;			// 6:6   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CCD:1;			// 7:7   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CDU:1;			// 8:8   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	CDD:1;			// 9:9   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	DCAEVT1:1;		// 10:10   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1U:1;		// 11:11   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1D:1;		// 12:12   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CB1U:1;		// 13:13   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	CB1D:1;		// 14:14   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	rsvd1:1;			// 15:15   Reserved
};

union ETINTMIXEN_REG {
	uint16_t 		 all;
	struct ETINTMIXEN_BITS 		 bit;
};

//
// Event-Trigger Counter Initialization Register
//
struct ETSOCAMIXEN_BITS {			// bits   description
	uint16_t	ZRO:1;			// 0:0   Enable event time-base counter equal to zero (TBCTR = 0x00) to the
	uint16_t	PRD:1;			// 1:1   Enable event time-base counter equal to period (TBCTR = TBPRD)
	uint16_t	CAU:1;			// 2:2   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CAD:1;			// 3:3   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CBU:1;			// 4:4   Enable event time-base counter equal to CMPB when the
	uint16_t	CBD:1;			// 5:5   Enable event time-base counter equal to CMPB when the timer is
	uint16_t	CCU:1;			// 6:6   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CCD:1;			// 7:7   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CDU:1;			// 8:8   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	CDD:1;			// 9:9   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	DCAEVT1:1;			// 10:10   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1U:1;			// 11:11   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1D:1;			// 12:12   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CB1U:1;			// 13:13   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	CB1D:1;			// 14:14   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	rsvd1:1;			// 15:15   Reserved
};

union ETSOCAMIXEN_REG {
	uint16_t 		 all;
	struct ETSOCAMIXEN_BITS 		 bit;
};

//
// Event-Trigger Counter Initialization Register
//
struct ETSOCBMIXEN_BITS {			// bits   description
	uint16_t	ZRO:1;			// 0:0   Enable event time-base counter equal to zero (TBCTR = 0x00) to the
	uint16_t	PRD:1;			// 1:1   Enable event time-base counter equal to period (TBCTR = TBPRD)
	uint16_t	CAU:1;			// 2:2   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CAD:1;			// 3:3   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CBU:1;			// 4:4   Enable event time-base counter equal to CMPB when the
	uint16_t	CBD:1;			// 5:5   Enable event time-base counter equal to CMPB when the timer is
	uint16_t	CCU:1;			// 6:6   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CCD:1;			// 7:7   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CDU:1;			// 8:8   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	CDD:1;			// 9:9   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	DCBEVT1:1;		// 10:10   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1U:1;			// 11:11   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1D:1;			// 12:12   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CB1U:1;			// 13:13   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	CB1D:1;			// 14:14   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	rsvd1:1;		// 15:15   Reserved
};

union ETSOCBMIXEN_REG {
	uint16_t 		 all;
	struct ETSOCBMIXEN_BITS 		 bit;
};

//
// Digital Compare Counter Capture Register
//
struct DCCAPMIXSEL_BITS {			// bits   description
	uint16_t	ZRO:1;			// 0:0   Enable event time-base counter equal to zero (TBCTR = 0x00) to the
	uint16_t	PRD:1;			// 1:1   Enable event time-base counter equal to period (TBCTR = TBPRD)
	uint16_t	CAU:1;			// 2:2   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CAD:1;			// 3:3   Enable event time-base counter equal to CMPA when the timer is
	uint16_t	CBU:1;			// 4:4   Enable event time-base counter equal to CMPB when the
	uint16_t	CBD:1;			// 5:5   Enable event time-base counter equal to CMPB when the timer is
	uint16_t	CCU:1;			// 6:6   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CCD:1;			// 7:7   Enable event time-base counter equal to CMPC when the timer is
	uint16_t	CDU:1;			// 8:8   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	CDD:1;			// 9:9   Enable event time-base counter equal to CMPD when the timer is
	uint16_t	CA1U:1;			// 10:10   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CA1D:1;			// 11:11   Enable event time-base counter equal to CMPA1 when the timer is
	uint16_t	CB1U:1;			// 12:12   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	CB1D:1;			// 13:13   Enable event time-base counter equal to CMPB1 when the timer is
	uint16_t	rsvd1:2;			// 15:14   Reserved
};

union DCCAPMIXSEL_REG {
	uint16_t 		 all;
	struct DCCAPMIXSEL_BITS 		 bit;
};

//
// EPWM Lock Register
//
struct CAPCTL_BITS {			// bits   description
	uint16_t	CAP_SRCSEL:1;			// 0:0   TRIP Input 15
	uint16_t	CAPGATEPOL:2;			// 2:1   TRIP Input 15
	uint16_t	CAPINPOL:1;			// 3:3   TRIP Input 15
	uint16_t	PULSECTL:1;			// 4:4   TRIP Input 15
	uint16_t	rsvd1:3;			// 7:5   Reserved
	uint16_t	FRCLOAD:1;			// 8:8   TRIP Input 15
	uint16_t	rsvd2:7;			// 15:9   Reserved
};

union CAPCTL_REG {
	uint16_t 		 all;
	struct CAPCTL_BITS 		 bit;
};

//
// EPWM Lock Register
//
struct CAPGATETRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0   TRIP Input 1
	uint16_t	TRIPINPUT2:1;			// 1:1   TRIP Input 2
	uint16_t	TRIPINPUT3:1;			// 2:2   TRIP Input 3
	uint16_t	TRIPINPUT4:1;			// 3:3   TRIP Input 4
	uint16_t	TRIPINPUT5:1;			// 4:4   TRIP Input 5
	uint16_t	TRIPINPUT6:1;			// 5:5   TRIP Input 6
	uint16_t	TRIPINPUT7:1;			// 6:6   TRIP Input 7
	uint16_t	TRIPINPUT8:1;			// 7:7   TRIP Input 8
	uint16_t	TRIPINPUT9:1;			// 8:8   TRIP Input 9
	uint16_t	TRIPINPUT10:1;			// 9:9   TRIP Input 10
	uint16_t	TRIPINPUT11:1;			// 10:10   TRIP Input 11
	uint16_t	TRIPINPUT12:1;			// 11:11   TRIP Input 12
	uint16_t	rsvd1:1;			// 12:12   Reserved
	uint16_t	TRIPINPUT14:1;			// 13:13   TRIP Input 14
	uint16_t	TRIPINPUT15:1;			// 14:14   TRIP Input 15
	uint16_t	rsvd2:1;			// 15:15   Reserved
};

union CAPGATETRIPSEL_REG {
	uint16_t 		 all;
	struct CAPGATETRIPSEL_BITS 		 bit;
};

//
// EPWM Lock Register
//
struct CAPINTRIPSEL_BITS {			// bits   description
	uint16_t	TRIPINPUT1:1;			// 0:0   TRIP Input 1
	uint16_t	TRIPINPUT2:1;			// 1:1   TRIP Input 2
	uint16_t	TRIPINPUT3:1;			// 2:2   TRIP Input 3
	uint16_t	TRIPINPUT4:1;			// 3:3   TRIP Input 4
	uint16_t	TRIPINPUT5:1;			// 4:4   TRIP Input 5
	uint16_t	TRIPINPUT6:1;			// 5:5   TRIP Input 6
	uint16_t	TRIPINPUT7:1;			// 6:6   TRIP Input 7
	uint16_t	TRIPINPUT8:1;			// 7:7   TRIP Input 8
	uint16_t	TRIPINPUT9:1;			// 8:8   TRIP Input 9
	uint16_t	TRIPINPUT10:1;			// 9:9   TRIP Input 10
	uint16_t	TRIPINPUT11:1;			// 10:10   TRIP Input 11
	uint16_t	TRIPINPUT12:1;			// 11:11   TRIP Input 12
	uint16_t	rsvd1:1;			// 12:12   Reserved
	uint16_t	TRIPINPUT14:1;			// 13:13   TRIP Input 14
	uint16_t	TRIPINPUT15:1;			// 14:14   TRIP Input 15
	uint16_t	rsvd2:1;			// 15:15   Reserved
};

union CAPINTRIPSEL_REG {
	uint16_t 		 all;
	struct CAPINTRIPSEL_BITS 		 bit;
};

//
// EPWM Lock Register
//
struct CAPTRIPSEL_BITS {			// bits   description
	uint16_t	CAPIN:4;			// 3:0   TRIP Input 15
	uint16_t	CAPGATE:4;			// 7:4   TRIP Input 15
	uint16_t	rsvd1:6;			// 13:8   Reserved
	uint16_t	CAPIN_COMPSEL_EXP:1;			// 14:14   TRIP Input 15
	uint16_t	CAPGATE_COMPSEL_EXP:1;			// 15:15   Reserved
};

union CAPTRIPSEL_REG {
	uint16_t 		 all;
	struct CAPTRIPSEL_BITS 		 bit;
};

#endif



//
// Trip Zone ARM Force Register
//
struct TZFRC_ARM_BITS {			// bits   description
	uint16_t	TZFRC_ARM_OST:1;			// 0:0
	uint16_t	rsvd1:15;			// 15:1   Reserved
};

union TZFRC_ARM_REG {
	uint16_t 		 all;
	struct TZFRC_ARM_BITS 		 bit;
};

//
// Trip Zone DSP Force Register
//
struct TZFRC_DSP_BITS {			// bits   description
	uint16_t	TZFRC_DSP_OST:1;			// 0:0
	uint16_t	rsvd1:15;			// 15:1   Reserved
};

union TZFRC_DSP_REG {
	uint16_t 		 all;
	struct TZFRC_DSP_BITS 		 bit;
};

//
// EPWM Enable Control Register
//
struct HRPWM_CTRL_BITS {			// bits   description
	uint16_t	HRPWM_OVF_EN:1;			// 0:0   Reserved
	uint16_t	rsvd2:3;			// 3:1   Reserved
	uint16_t	HRPWM_TZ_EN:1;			// 4:4
	uint16_t	rsvd3:11;			// 15:5   Reserved
};

union HRPWM_CTRL_REG {
	uint16_t 		 all;
	struct HRPWM_CTRL_BITS 		 bit;
};




#if (EPWM_VERSION==22)
//
// DC Trip Register
//
struct DCTRIPSEL2_1DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_1DCAL:1;			// 0:0
	uint32_t	TRIPINPUT26_1DCAL:1;			// 1:1
	uint32_t	TRIPINPUT27_1DCAL:1;			// 2:2
	uint32_t	TRIPINPUT28_1DCAL:1;			// 3:3
	uint32_t	TRIPINPUT29_1DCAL:1;			// 4:4
	uint32_t	TRIPINPUT30_1DCAL:1;			// 5:5
	uint32_t	TRIPINPUT31_1DCAL:1;			// 6:6
	uint32_t	TRIPINPUT32_1DCAL:1;			// 7:7
	uint32_t	TRIPINPUT33_1DCAL:1;			// 8:8
	uint32_t	TRIPINPUT34_1DCAL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_1DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_1DCAL_BITS 		 bit;
};

struct DCTRIPSEL2_2DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_2DCAL:1;			// 0:0
	uint32_t	TRIPINPUT26_2DCAL:1;			// 1:1
	uint32_t	TRIPINPUT27_2DCAL:1;			// 2:2
	uint32_t	TRIPINPUT28_2DCAL:1;			// 3:3
	uint32_t	TRIPINPUT29_2DCAL:1;			// 4:4
	uint32_t	TRIPINPUT30_2DCAL:1;			// 5:5
	uint32_t	TRIPINPUT31_2DCAL:1;			// 6:6
	uint32_t	TRIPINPUT32_2DCAL:1;			// 7:7
	uint32_t	TRIPINPUT33_2DCAL:1;			// 8:8
	uint32_t	TRIPINPUT34_2DCAL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_2DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_2DCAL_BITS 		 bit;
};

struct DCTRIPSEL2_3DCAL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_3DCAL:1;			// 0:0
	uint32_t	TRIPINPUT26_3DCAL:1;			// 1:1
	uint32_t	TRIPINPUT27_3DCAL:1;			// 2:2
	uint32_t	TRIPINPUT28_3DCAL:1;			// 3:3
	uint32_t	TRIPINPUT29_3DCAL:1;			// 4:4
	uint32_t	TRIPINPUT30_3DCAL:1;			// 5:5
	uint32_t	TRIPINPUT31_3DCAL:1;			// 6:6
	uint32_t	TRIPINPUT32_3DCAL:1;			// 7:7
	uint32_t	TRIPINPUT33_3DCAL:1;			// 8:8
	uint32_t	TRIPINPUT34_3DCAL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_3DCAL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_3DCAL_BITS 		 bit;
};

struct DCTRIPSEL2_1DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_1DCAH:1;			// 0:0
	uint32_t	TRIPINPUT26_1DCAH:1;			// 1:1
	uint32_t	TRIPINPUT27_1DCAH:1;			// 2:2
	uint32_t	TRIPINPUT28_1DCAH:1;			// 3:3
	uint32_t	TRIPINPUT29_1DCAH:1;			// 4:4
	uint32_t	TRIPINPUT30_1DCAH:1;			// 5:5
	uint32_t	TRIPINPUT31_1DCAH:1;			// 6:6
	uint32_t	TRIPINPUT32_1DCAH:1;			// 7:7
	uint32_t	TRIPINPUT33_1DCAH:1;			// 8:8
	uint32_t	TRIPINPUT34_1DCAH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_1DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_1DCAH_BITS 		 bit;
};

struct DCTRIPSEL2_2DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_2DCAH:1;			// 0:0
	uint32_t	TRIPINPUT26_2DCAH:1;			// 1:1
	uint32_t	TRIPINPUT27_2DCAH:1;			// 2:2
	uint32_t	TRIPINPUT28_2DCAH:1;			// 3:3
	uint32_t	TRIPINPUT29_2DCAH:1;			// 4:4
	uint32_t	TRIPINPUT30_2DCAH:1;			// 5:5
	uint32_t	TRIPINPUT31_2DCAH:1;			// 6:6
	uint32_t	TRIPINPUT32_2DCAH:1;			// 7:7
	uint32_t	TRIPINPUT33_2DCAH:1;			// 8:8
	uint32_t	TRIPINPUT34_2DCAH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_2DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_2DCAH_BITS 		 bit;
};

struct DCTRIPSEL2_3DCAH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_3DCAH:1;			// 0:0
	uint32_t	TRIPINPUT26_3DCAH:1;			// 1:1
	uint32_t	TRIPINPUT27_3DCAH:1;			// 2:2
	uint32_t	TRIPINPUT28_3DCAH:1;			// 3:3
	uint32_t	TRIPINPUT29_3DCAH:1;			// 4:4
	uint32_t	TRIPINPUT30_3DCAH:1;			// 5:5
	uint32_t	TRIPINPUT31_3DCAH:1;			// 6:6
	uint32_t	TRIPINPUT32_3DCAH:1;			// 7:7
	uint32_t	TRIPINPUT33_3DCAH:1;			// 8:8
	uint32_t	TRIPINPUT34_3DCAH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_3DCAH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_3DCAH_BITS 		 bit;
};

struct DCTRIPSEL2_1DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_1DCBL:1;			// 0:0
	uint32_t	TRIPINPUT26_1DCBL:1;			// 1:1
	uint32_t	TRIPINPUT27_1DCBL:1;			// 2:2
	uint32_t	TRIPINPUT28_1DCBL:1;			// 3:3
	uint32_t	TRIPINPUT29_1DCBL:1;			// 4:4
	uint32_t	TRIPINPUT30_1DCBL:1;			// 5:5
	uint32_t	TRIPINPUT31_1DCBL:1;			// 6:6
	uint32_t	TRIPINPUT32_1DCBL:1;			// 7:7
	uint32_t	TRIPINPUT33_1DCBL:1;			// 8:8
	uint32_t	TRIPINPUT34_1DCBL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_1DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_1DCBL_BITS 		 bit;
};

struct DCTRIPSEL2_2DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_2DCBL:1;			// 0:0
	uint32_t	TRIPINPUT26_2DCBL:1;			// 1:1
	uint32_t	TRIPINPUT27_2DCBL:1;			// 2:2
	uint32_t	TRIPINPUT28_2DCBL:1;			// 3:3
	uint32_t	TRIPINPUT29_2DCBL:1;			// 4:4
	uint32_t	TRIPINPUT30_2DCBL:1;			// 5:5
	uint32_t	TRIPINPUT31_2DCBL:1;			// 6:6
	uint32_t	TRIPINPUT32_2DCBL:1;			// 7:7
	uint32_t	TRIPINPUT33_2DCBL:1;			// 8:8
	uint32_t	TRIPINPUT34_2DCBL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_2DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_2DCBL_BITS 		 bit;
};

struct DCTRIPSEL2_3DCBL_BITS {			// bits   description
	uint32_t	TRIPINPUT25_3DCBL:1;			// 0:0
	uint32_t	TRIPINPUT26_3DCBL:1;			// 1:1
	uint32_t	TRIPINPUT27_3DCBL:1;			// 2:2
	uint32_t	TRIPINPUT28_3DCBL:1;			// 3:3
	uint32_t	TRIPINPUT29_3DCBL:1;			// 4:4
	uint32_t	TRIPINPUT30_3DCBL:1;			// 5:5
	uint32_t	TRIPINPUT31_3DCBL:1;			// 6:6
	uint32_t	TRIPINPUT32_3DCBL:1;			// 7:7
	uint32_t	TRIPINPUT33_3DCBL:1;			// 8:8
	uint32_t	TRIPINPUT34_3DCBL:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_3DCBL_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_3DCBL_BITS 		 bit;
};

struct DCTRIPSEL2_1DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_1DCBH:1;			// 0:0
	uint32_t	TRIPINPUT26_1DCBH:1;			// 1:1
	uint32_t	TRIPINPUT27_1DCBH:1;			// 2:2
	uint32_t	TRIPINPUT28_1DCBH:1;			// 3:3
	uint32_t	TRIPINPUT29_1DCBH:1;			// 4:4
	uint32_t	TRIPINPUT30_1DCBH:1;			// 5:5
	uint32_t	TRIPINPUT31_1DCBH:1;			// 6:6
	uint32_t	TRIPINPUT32_1DCBH:1;			// 7:7
	uint32_t	TRIPINPUT33_1DCBH:1;			// 8:8
	uint32_t	TRIPINPUT34_1DCBH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_1DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_1DCBH_BITS 		 bit;
};

struct DCTRIPSEL2_2DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_2DCBH:1;			// 0:0
	uint32_t	TRIPINPUT26_2DCBH:1;			// 1:1
	uint32_t	TRIPINPUT27_2DCBH:1;			// 2:2
	uint32_t	TRIPINPUT28_2DCBH:1;			// 3:3
	uint32_t	TRIPINPUT29_2DCBH:1;			// 4:4
	uint32_t	TRIPINPUT30_2DCBH:1;			// 5:5
	uint32_t	TRIPINPUT31_2DCBH:1;			// 6:6
	uint32_t	TRIPINPUT32_2DCBH:1;			// 7:7
	uint32_t	TRIPINPUT33_2DCBH:1;			// 8:8
	uint32_t	TRIPINPUT34_2DCBH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_2DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_2DCBH_BITS 		 bit;
};

struct DCTRIPSEL2_3DCBH_BITS {			// bits   description
	uint32_t	TRIPINPUT25_3DCBH:1;			// 0:0
	uint32_t	TRIPINPUT26_3DCBH:1;			// 1:1
	uint32_t	TRIPINPUT27_3DCBH:1;			// 2:2
	uint32_t	TRIPINPUT28_3DCBH:1;			// 3:3
	uint32_t	TRIPINPUT29_3DCBH:1;			// 4:4
	uint32_t	TRIPINPUT30_3DCBH:1;			// 5:5
	uint32_t	TRIPINPUT31_3DCBH:1;			// 6:6
	uint32_t	TRIPINPUT32_3DCBH:1;			// 7:7
	uint32_t	TRIPINPUT33_3DCBH:1;			// 8:8
	uint32_t	TRIPINPUT34_3DCBH:1;			// 9:9
	uint32_t	rsvd1:22;			// 31:10
};

union DCTRIPSEL2_3DCBH_REG {
	uint32_t 		 all;
	struct DCTRIPSEL2_3DCBH_BITS 		 bit;
};
#endif

#if (EPWM_VERSION==22) || (EPWM_VERSION==12)
struct XCMP_EN_BITS {			// bits   description
	uint32_t	XCMP_TBPRD_EN:1;			// 0:0
	uint32_t	XCMP_CMPA_EN:1;			// 1:1
	uint32_t	XCMP_CMPB_EN:1;			// 2:2
	uint32_t	XCMP_CMPC_EN:1;			// 3:3
	uint32_t	XCMP_CMPD_EN:1;			// 4:4
	uint32_t	XCMP_CMPA1_EN:1;			// 5:5
	uint32_t	XCMP_CMPB1_EN:1;			// 6:6
	uint32_t	rsvd1:25;			// 31:7   Reserved
};

union XCMP_EN_REG {
	uint32_t 		 all;
	struct XCMP_EN_BITS 		 bit;
};

struct XCMP_SEL_BITS {			// bits   description
	uint32_t	XCMP_TBPRD_SEL:4;			// 3:0
	uint32_t	XCMP_CMPA_SEL:4;			// 7:4
	uint32_t	XCMP_CMPB_SEL:4;			// 11:8
	uint32_t	XCMP_CMPC_SEL:4;			// 15:12
	uint32_t	XCMP_CMPD_SEL:4;			// 19:16
	uint32_t	XCMP_CMPA1_SEL:4;			// 23:20
	uint32_t	XCMP_CMPB1_SEL:4;			// 27:24
	uint32_t	rsvd1:4;			// 31:28   Reserved
};

union XCMP_SEL_REG {
	uint32_t 		 all;
	struct XCMP_SEL_BITS 		 bit;
};

struct XCMP_PERIOD_BITS {			// bits   description
	uint32_t	XCMP_TBPRD_PRD:8;			// 7:0
	uint32_t	XCMP_CMPA_PRD:8;			// 15:8
	uint32_t	XCMP_CMPB_PRD:8;			// 23:16
	uint32_t	XCMP_CMPC_PRD:8;			// 31:24
};

union XCMP_PERIOD_REG {
	uint32_t 		 all;
	struct XCMP_PERIOD_BITS 		 bit;
};

struct XCMP_PERIOD2_BITS {			// bits   description
	uint32_t	XCMP_CMPD_PRD:8;			// 7:0
	uint32_t	XCMP_CMPA1_PRD:8;			// 15:8
	uint32_t	XCMP_CMPB1_PRD:8;			// 23:16
	uint32_t	rsvd1:8;			// 31:24   Reserved
};

union XCMP_PERIOD2_REG {
	uint32_t 		 all;
	struct XCMP_PERIOD2_BITS 		 bit;
};

struct XCMP_UPDATE_BITS {			// bits   description
	uint32_t	XCMP_TBPRD_UPDATE:1;			// 0:0
	uint32_t	XCMP_CMPA_UPDATE:1;			// 1:1
	uint32_t	XCMP_CMPB_UPDATE:1;			// 2:2
	uint32_t	XCMP_CMPC_UPDATE:1;			// 3:3
	uint32_t	XCMP_CMPD_UPDATE:1;			// 4:4
	uint32_t	XCMP_CMPA1_UPDATE:1;			// 5:5
	uint32_t	XCMP_CMPB1_UPDATE:1;			// 6:6
	uint32_t	rsvd1:25;			// 31:7   Reserved
};

union XCMP_UPDATE_REG {
	uint32_t 		 all;
	struct XCMP_UPDATE_BITS 		 bit;
};

struct TBPRD_XCMP_BITS {			// bits   description
	uint32_t	TBPRD_XCMP:16;			// 0:15
};

union TBPRD_XCMP_REG {
	uint16_t 		 all;
	struct TBPRD_XCMP_BITS 		 bit;
};

struct CMPA_XCMP_BITS {			// bits   description
	uint32_t	CMPA_XCMP:16;			// 0:15
};

union CMPA_XCMP_REG {
	uint16_t 		 all;
	struct CMPA_XCMP_BITS 		 bit;
};

struct CMPB_XCMP_BITS {			// bits   description
	uint32_t	CMPB_XCMP:16;			// 0:15
};

union CMPB_XCMP_REG {
	uint16_t 		 all;
	struct CMPB_XCMP_BITS 		 bit;
};

struct CMPC_XCMP_BITS {			// bits   description
	uint32_t	CMPC_XCMP:16;			// 0:15
};

union CMPC_XCMP_REG {
	uint16_t 		 all;
	struct CMPC_XCMP_BITS 		 bit;
};

struct CMPD_XCMP_BITS {			// bits   description
	uint32_t	CMPD_XCMP:16;			// 0:15
};

union CMPD_XCMP_REG {
	uint16_t 		 all;
	struct CMPD_XCMP_BITS 		 bit;
};

struct CMPA1_XCMP_BITS {			// bits   description
	uint32_t	CMPA1_XCMP:16;			// 0:15
};

union CMPA1_XCMP_REG {
	uint16_t 		 all;
	struct CMPA1_XCMP_BITS 		 bit;
};

struct CMPB1_XCMP_BITS {			// bits   description
	uint32_t	CMPB1_XCMP:16;			// 0:15
};

union CMPB1_XCMP_REG {
	uint16_t 		 all;
	struct CMPB1_XCMP_BITS 		 bit;
};

#endif

//
// Global PWM Load Config Register
//
struct GLDCFG2_BITS {			// bits   description
	uint16_t	rsvd1:1;			// 0:0   Reserved
	uint16_t	CMPAHR_CFG:1;			// 1:1   Global load event configuration for CMPA CMPAHR
	uint16_t	CMPBHR_CFG:1;			// 2:2   Global load event configuration for CMPB CMPBHR
	uint16_t	rsvd2:1;			// 3:3   Reserved
	uint16_t	rsvd3:1;			// 4:4   Reserved
	uint16_t	DBREDHR_CFG:1;			// 5:5   Global load event configuration for DBRED DBREDHR
	uint16_t	DBFEDHR_CFG:1;			// 6:6   Global load event configuration for DBFED DBFEDHR
	uint16_t	rsvd4:4;			// 10:7   Reserved
	uint16_t	HRCFG_GLD_MODE:1;			// 11:11
	uint16_t	rsvd5:4;			// 15:12   Reserved
};

union GLDCFG2_REG {
	uint16_t 		 all;
	struct GLDCFG2_BITS 		 bit;
};

#if (EPWM_VERSION==22)||(EPWM_VERSION==30)
struct HRPWM_INT_BITS {			// bits   description
	uint32_t	CMPAHR_INT:4;			// 3:0
	uint32_t	CMPBHR_INT:4;			// 7:4
	uint32_t	TBPHSHR_INT:4;			// 11:8
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union HRPWM_INT_REG {
	uint32_t 		 all;
	struct HRPWM_INT_BITS 		 bit;
};
#endif


#if (EPWM_VERSION==30)
struct EPWMA_EN_CTRL_BITS {			// bits   description
	uint16_t	EPWMA_BURST_EN:1;			// 0:0
	uint16_t	EPWMA_BURST_SEL:1;			// 1:1
	uint16_t	rsvd1:2;			// 3:2   Reserved
	uint16_t	EPWMA_EN_LOAD_MODE:4;			// 7:4
	uint16_t	rsvd2:8;			// 15:8
};

union EPWMA_EN_CTRL_REG {
	uint16_t 		 all;
	struct EPWMA_EN_CTRL_BITS 		 bit;
};

struct EPWMB_EN_CTRL_BITS {			// bits   description
	uint16_t	EPWMB_BURST_EN:1;			// 0:0
	uint16_t	EPWMB_BURST_SEL:1;			// 1:1
	uint16_t	rsvd1:2;			// 3:2   Reserved
	uint16_t	EPWMB_EN_LOAD_MODE:4;			// 7:4
	uint16_t	rsvd2:8;			// 15:8
};

union EPWMB_EN_CTRL_REG {
	uint16_t 		 all;
	struct EPWMB_EN_CTRL_BITS 		 bit;
};

struct SOC_PERIOD_BITS {			// bits   description
	uint32_t	SOCA_PERIOD:16;			// 15:0
	uint32_t	SOCB_PERIOD:16;			// 31:16
};

union SOC_PERIOD_REG {
	uint32_t 		 all;
	struct SOC_PERIOD_BITS 		 bit;
};

struct SOC_SYNC_EN_BITS {			// bits   description
	uint32_t	SOCA_SYNC_EN:1;			// 0:0
	uint32_t	SOCB_SYNC_EN:1;			// 1:1
	uint32_t	rsvd1:30;			// 31:2
};

union SOC_SYNC_EN_REG {
	uint32_t 		 all;
	struct SOC_SYNC_EN_BITS 		 bit;
};
#endif

#if EPWM_VERSION == 12

struct ADCSOCOUTSELECT_TOP_BITS {			// bits   description
	uint32_t	PWM1SOCAEN:1;			// 0:0
	uint32_t	PWM2SOCAEN:1;			// 1:1
	uint32_t	PWM3SOCAEN:1;			// 2:2
	uint32_t	PWM4SOCAEN:1;			// 3:3
	uint32_t	PWM5SOCAEN:1;			// 4:4
	uint32_t	PWM6SOCAEN:1;			// 5:5
	uint32_t	PWM7SOCAEN:1;			// 6:6
	uint32_t	PWM8SOCAEN:1;			// 7:7
	uint32_t	PWM9SOCAEN:1;			// 8:8
	uint32_t	PWM10SOCAEN:1;			// 9:9
	uint32_t	PWM11SOCAEN:1;			// 10:10
	uint32_t	PWM12SOCAEN:1;			// 11:11
	uint32_t	rsvd1:4;			// 15:12   reserved
	uint32_t	PWM1SOCBEN:1;			// 16:16
	uint32_t	PWM2SOCBEN:1;			// 17:17
	uint32_t	PWM3SOCBEN:1;			// 18:18
	uint32_t	PWM4SOCBEN:1;			// 19:19
	uint32_t	PWM5SOCBEN:1;			// 20:20
	uint32_t	PWM6SOCBEN:1;			// 21:21
	uint32_t	PWM7SOCBEN:1;			// 22:22
	uint32_t	PWM8SOCBEN:1;			// 23:23
	uint32_t	PWM9SOCBEN:1;			// 24:24
	uint32_t	PWM10SOCBEN:1;			// 25:25
	uint32_t	PWM11SOCBEN:1;			// 26:26
	uint32_t	PWM12SOCBEN:1;			// 27:27
	uint32_t	rsvd2:4;			// 31:28   reserved
};

union ADCSOCOUTSELECT_TOP_REG {
	uint32_t 		 all;
	struct ADCSOCOUTSELECT_TOP_BITS 		 bit;
};

//
// ePWM_TOP_TRANS processing mode
//
struct TRANS_MODE_BITS {			// bits   description
	uint32_t	CTR_MODE:3;			// 2:0   CTR counting mode
	uint32_t	rsvd1:5;			// 7:3   Reserved
	uint32_t	ALIGN_MODE:2;			// 9:8 alignment mode
	uint32_t	rsvd2:6;			// 15:10   Reserved
	uint32_t	TRANS_BYPASS:1;			// 16:16   ePWM_TOP_TRANS bypass enable
	uint32_t	rsvd3:15;			// 31:17   Reserved
};

union TRANS_MODE_REG {
	uint32_t 		 all;
	struct TRANS_MODE_BITS 		 bit;
};

//
// Period
//
struct PERIOD_BITS {			// bits   description
	uint32_t	rsvd1:10;			// 9:0   Reserved
	uint32_t	PERIOD:22;			// 31:10  reserved
};

union PERIOD_REG {
	uint32_t 		 all;
	struct PERIOD_BITS 		 bit;
};

//
// Duty Cycle
//
struct DUTYCYCLE1_BITS {			// bits   description
	uint32_t	rsvd1:10;			// 9:0   Reserved
	uint32_t	DUTYCYCLE1:22;			// 31:10   duty cycle of the lagging bridge arm
};

union DUTYCYCLE1_REG {
	uint32_t 		 all;
	struct DUTYCYCLE1_BITS 		 bit;
};

//
// Duty Cycle
//
struct DUTYCYCLE2_BITS {			// bits   description
	uint32_t	rsvd1:10;			// 9:0   Reserved
	uint32_t	DUTYCYCLE2:22;			// 31:10   original phase shift of the leading bridge arm
};

union DUTYCYCLE2_REG {
	uint32_t 		 all;
	struct DUTYCYCLE2_BITS 		 bit;
};

//
// phase shift
//
struct PHASESHIFT_BITS {			// bits   description
	uint32_t	rsvd1:10;			// 9:0   Reserved
	uint32_t	PHASESHIFT:22;			// 31:10    duty cycle of the lagging bridge arm
};

union PHASESHIFT_REG {
	uint32_t 		 all;
	struct PHASESHIFT_BITS 		 bit;
};

struct PHASESHIFT_INI_BITS {			// bits   description
	uint32_t	rsvd1:10;			// 9:0   Reserved
	uint32_t	PHASESHIFT_INI:22;			// 31:10   original phase shift of the leading bridge arm
};

union PHASESHIFT_INI_REG {
	uint32_t 		 all;
	struct PHASESHIFT_INI_BITS 		 bit;
};

struct EPWM_MUX_SEL_BITS {			// bits   description
	uint32_t	EPWM1_MUX:1;			// 0:0
	uint32_t	EPWM2_MUX:1;			// 1:1
	uint32_t	EPWM3_MUX:1;			// 2:2
	uint32_t	EPWM4_MUX:1;			// 3:3
	uint32_t	EPWM5_MUX:1;			// 4:4
	uint32_t	EPWM6_MUX:1;			// 5:5
	uint32_t	EPWM7_MUX:1;			// 6:6
	uint32_t	EPWM8_MUX:1;			// 7:7
	uint32_t	EPWM9_MUX:1;			// 8:8
	uint32_t	EPWM10_MUX:1;			// 9:9
	uint32_t	EPWM11_MUX:1;			// 10:10
	uint32_t	EPWM12_MUX:1;			// 11:11
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union EPWM_MUX_SEL_REG {
	uint32_t 		 all;
	struct EPWM_MUX_SEL_BITS 		 bit;
};

struct TRIPIN_INV_CFG_BITS {			// bits   description
	uint32_t	TRIP1IN_INV_CFG:1;			// 0:0
	uint32_t	TRIP2IN_INV_CFG:1;			// 1:1
	uint32_t	TRIP3IN_INV_CFG:1;			// 2:2
	uint32_t	TRIP4IN_INV_CFG:1;			// 3:3
	uint32_t	TRIP5IN_INV_CFG:1;			// 4:4
	uint32_t	TRIP6IN_INV_CFG:1;			// 5:5
	uint32_t	TRIP7IN_INV_CFG:1;			// 6:6
	uint32_t	TRIP8IN_INV_CFG:1;			// 7:7
	uint32_t	TRIP9IN_INV_CFG:1;			// 8:8
	uint32_t	TRIP10IN_INV_CFG:1;			// 9:9
	uint32_t	TRIP11IN_INV_CFG:1;			// 10:10
	uint32_t	TRIP12IN_INV_CFG:1;			// 11:11
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIP14IN_INV_CFG:1;			// 13:13
	uint32_t	TRIP15IN_INV_CFG:1;			// 14:14
	uint32_t	TRIP16IN_INV_CFG:1;			// 15:15
	uint32_t	TRIP17IN_INV_CFG:1;			// 16:16
	uint32_t	TRIP18IN_INV_CFG:1;			// 17:17
	uint32_t	TRIP19IN_INV_CFG:1;			// 18:18
	uint32_t	TRIP20IN_INV_CFG:1;			// 19:19
	uint32_t	TRIP21IN_INV_CFG:1;			// 20:20
	uint32_t	rsvd2:11;			// 31:21   Reserved
};

union TRIPIN_INV_CFG_REG {
	uint32_t 		 all;
	struct TRIPIN_INV_CFG_BITS 		 bit;
};

struct PWM_HALT_EN_BITS {			// bits   description
	uint32_t	PWM_HALT_EN:2;			// 1:0
	uint32_t	rsvd1:2;			// 3:2   reserved
	uint32_t	PWM_LOCK_EN:2;			// 5:4
	uint32_t	rsvd2:26;			// 31:6   reserved
};

union PWM_HALT_EN_REG {
	uint32_t 		 all;
	struct PWM_HALT_EN_BITS 		 bit;
};

struct HRPWM_1CFG_BITS {			// bits   description
	uint32_t	HRPWM_1CFG:32;			// 31:0
};

union HRPWM_1CFG_REG {
	uint32_t 		 all;
	struct HRPWM_1CFG_BITS 		 bit;
};

struct DLL_LOCKFLAG_BITS {			// bits   description
	uint32_t	DLL_LOCKFLAG:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union DLL_LOCKFLAG_REG {
	uint32_t 		 all;
	struct DLL_LOCKFLAG_BITS 		 bit;
};

struct HRPWM_BYPASS_BITS {			// bits   description
	uint32_t	HRPWM_BYPASS:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union HRPWM_BYPASS_REG {
	uint32_t 		 all;
	struct HRPWM_BYPASS_BITS 		 bit;
};


#elif (EPWM_VERSION==22)
struct ADCSOCOUTSELECT_TOP_BITS {			// bits   description
	uint32_t	PWM1SOCAEN:1;			// 0:0
	uint32_t	PWM2SOCAEN:1;			// 1:1
	uint32_t	PWM3SOCAEN:1;			// 2:2
	uint32_t	PWM4SOCAEN:1;			// 3:3
	uint32_t	PWM5SOCAEN:1;			// 4:4
	uint32_t	PWM6SOCAEN:1;			// 5:5
	uint32_t	PWM7SOCAEN:1;			// 6:6
	uint32_t	PWM8SOCAEN:1;			// 7:7
	uint32_t	PWM9SOCAEN:1;			// 8:8
	uint32_t	PWM10SOCAEN:1;			// 9:9
	uint32_t	PWM11SOCAEN:1;			// 10:10
	uint32_t	PWM12SOCAEN:1;			// 11:11
	uint32_t	PWM13SOCAEN:1;			// 12:12
	uint32_t	PWM14SOCAEN:1;			// 13:13
	uint32_t	PWM15SOCAEN:1;			// 14:14
	uint32_t	PWM16SOCAEN:1;			// 15:15
	uint32_t	PWM1SOCBEN:1;			// 16:16
	uint32_t	PWM2SOCBEN:1;			// 17:17
	uint32_t	PWM3SOCBEN:1;			// 18:18
	uint32_t	PWM4SOCBEN:1;			// 19:19
	uint32_t	PWM5SOCBEN:1;			// 20:20
	uint32_t	PWM6SOCBEN:1;			// 21:21
	uint32_t	PWM7SOCBEN:1;			// 22:22
	uint32_t	PWM8SOCBEN:1;			// 23:23
	uint32_t	PWM9SOCBEN:1;			// 24:24
	uint32_t	PWM10SOCBEN:1;			// 25:25
	uint32_t	PWM11SOCBEN:1;			// 26:26
	uint32_t	PWM12SOCBEN:1;			// 27:27
	uint32_t	PWM13SOCBEN:1;			// 28:28
	uint32_t	PWM14SOCBEN:1;			// 29:29
	uint32_t	PWM15SOCBEN:1;			// 30:30
	uint32_t	PWM16SOCBEN:1;			// 31:31
};

union ADCSOCOUTSELECT_TOP_REG {
	uint32_t 		 all;
	struct ADCSOCOUTSELECT_TOP_BITS 		 bit;
};

struct ADCSOCOUTSELECT1_TOP_BITS {			// bits   description
	uint32_t	PWM17SOCAEN:1;			// 0:0
	uint32_t	PWM18SOCAEN:1;			// 1:1
	uint32_t	rsvd1:14;			// 15:2
	uint32_t	PWM17SOCBEN:1;			// 16:16
	uint32_t	PWM18SOCBEN:1;			// 17:17
	uint32_t	rsvd2:14;			// 31:18
};

union ADCSOCOUTSELECT1_TOP_REG {
	uint32_t 		 all;
	struct ADCSOCOUTSELECT1_TOP_BITS 		 bit;
};

//
// ePWM_TOP_TRANS processing mode
//
struct TRANS_MODE_BITS {			// bits  description
	uint32_t	CTR_MODE:2;			// 1:0   CTR counting mode
	uint32_t	rsvd1:6;			// 7:2   Reserved
	uint32_t	ALIGN_MODE:2;			// 9:8 alignment mode
	uint32_t	rsvd2:6;			// 15:10   Reserved
	uint32_t	TRANS_BYPASS:1;			// 16:16  ePWM_TOP_TRANS bypass enable
	uint32_t	rsvd3:15;			// 31:17   Reserved
};

union TRANS_MODE_REG {
	uint32_t 		 all;
	struct TRANS_MODE_BITS 		 bit;
};

//
// Period
//
struct PERIOD_BITS {			// bits   description
	uint32_t	rsvd1:9;			// 8:0   Reserved
	uint32_t	PERIOD:23;			// 31:9  Reserved
};

union PERIOD_REG {
	uint32_t 		 all;
	struct PERIOD_BITS 		 bit;
};

//
// Duty cycle
//
struct DUTYCYCLE1_BITS {			// bits   description
	uint32_t	rsvd1:9;			// 8:0   Reserved
	uint32_t	DUTYCYCLE1:23;			// 31:9 duty cycle of the lagging bridge arm
};

union DUTYCYCLE1_REG {
	uint32_t 		 all;
	struct DUTYCYCLE1_BITS 		 bit;
};

//
// Duty cycle
//
struct DUTYCYCLE2_BITS {			// bits   description
	uint32_t	rsvd1:9;			// 8:0   Reserved
	uint32_t	DUTYCYCLE2:23;			// 31:9  original phase shift of the leading bridge arm
};

union DUTYCYCLE2_REG {
	uint32_t 		 all;
	struct DUTYCYCLE2_BITS 		 bit;
};

//
// Phase shift
//
struct PHASESHIFT_BITS {			// bits   description
	uint32_t	rsvd1:9;			// 8:0   Reserved
	uint32_t	PHASESHIFT:23;			// 31:9 duty cycle of the lagging bridge arm
};

union PHASESHIFT_REG {
	uint32_t 		 all;
	struct PHASESHIFT_BITS 		 bit;
};

struct PHASESHIFT_INI_BITS {			// bits   description
	uint32_t	rsvd1:9;			// 8:0   Reserved
	uint32_t	PHASESHIFT_INI:23;			// 31:9 original phase shift of the leading bridge arm
};

union PHASESHIFT_INI_REG {
	uint32_t 		 all;
	struct PHASESHIFT_INI_BITS 		 bit;
};

struct EPWM_MUX_SEL_BITS {			// bits   description
	uint32_t	EPWM1_MUX:1;			// 0:0
	uint32_t	EPWM2_MUX:1;			// 1:1
	uint32_t	EPWM3_MUX:1;			// 2:2
	uint32_t	EPWM4_MUX:1;			// 3:3
	uint32_t	EPWM5_MUX:1;			// 4:4
	uint32_t	EPWM6_MUX:1;			// 5:5
	uint32_t	EPWM7_MUX:1;			// 6:6
	uint32_t	EPWM8_MUX:1;			// 7:7
	uint32_t	EPWM9_MUX:1;			// 8:8
	uint32_t	EPWM10_MUX:1;			// 9:9
	uint32_t	EPWM11_MUX:1;			// 10:10
	uint32_t	EPWM12_MUX:1;			// 11:11
	uint32_t	EPWM13_MUX:1;			// 12:12
	uint32_t	EPWM14_MUX:1;			// 13:13
	uint32_t	EPWM15_MUX:1;			// 14:14
	uint32_t	EPWM16_MUX:1;			// 15:15
	uint32_t	EPWM17_MUX:1;			// 16:16
	uint32_t	EPWM18_MUX:1;			// 17:17
	uint32_t	rsvd1:14;			// 31:18  reserved
};

union EPWM_MUX_SEL_REG {
	uint32_t 		 all;
	struct EPWM_MUX_SEL_BITS 		 bit;
};

struct TRIPIN_INV_CFG_BITS {			// bits   description
	uint32_t	TRIP1IN_INV_CFG:1;			// 0:0
	uint32_t	TRIP2IN_INV_CFG:1;			// 1:1
	uint32_t	TRIP3IN_INV_CFG:1;			// 2:2
	uint32_t	TRIP4IN_INV_CFG:1;			// 3:3
	uint32_t	TRIP5IN_INV_CFG:1;			// 4:4
	uint32_t	TRIP6IN_INV_CFG:1;			// 5:5
	uint32_t	TRIP7IN_INV_CFG:1;			// 6:6
	uint32_t	TRIP8IN_INV_CFG:1;			// 7:7
	uint32_t	TRIP9IN_INV_CFG:1;			// 8:8
	uint32_t	TRIP10IN_INV_CFG:1;			// 9:9
	uint32_t	TRIP11IN_INV_CFG:1;			// 10:10
	uint32_t	TRIP12IN_INV_CFG:1;			// 11:11
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIP14IN_INV_CFG:1;			// 13:13
	uint32_t	TRIP15IN_INV_CFG:1;			// 14:14
	uint32_t	TRIP16IN_INV_CFG:1;			// 15:15
	uint32_t	TRIP17IN_INV_CFG:1;			// 16:16
	uint32_t	TRIP18IN_INV_CFG:1;			// 17:17
	uint32_t	TRIP19IN_INV_CFG:1;			// 18:18
	uint32_t	TRIP20IN_INV_CFG:1;			// 19:19
	uint32_t	TRIP21IN_INV_CFG:1;			// 20:20
	uint32_t	TRIP22IN_INV_CFG:1;			// 21:21
	uint32_t	TRIP23IN_INV_CFG:1;			// 22:22
	uint32_t	TRIP24IN_INV_CFG:1;			// 23:23
	uint32_t	TRIP25IN_INV_CFG:1;			// 24:24
	uint32_t	TRIP26IN_INV_CFG:1;			// 25:25
	uint32_t	TRIP27IN_INV_CFG:1;			// 26:26
	uint32_t	TRIP28IN_INV_CFG:1;			// 27:27
	uint32_t	TRIP29IN_INV_CFG:1;			// 28:28
	uint32_t	TRIP30IN_INV_CFG:1;			// 29:29
	uint32_t	TRIP31IN_INV_CFG:1;			// 30:30
	uint32_t	rsvd2:1;			// 31:31   Reserved
};

union TRIPIN_INV_CFG_REG {
	uint32_t 		 all;
	struct TRIPIN_INV_CFG_BITS 		 bit;
};

struct PWM_HALT_EN_BITS {			// bits   description
	uint32_t	PWM_HALT_EN:3;			// 2:0
	uint32_t	rsvd2:29;			// 31:3   reserved
};

union PWM_HALT_EN_REG {
	uint32_t 		 all;
	struct PWM_HALT_EN_BITS 		 bit;
};

struct HRPWM_CYCLE_NUM_BITS {			// bits   description
	uint32_t	HRPWM_CYCLE_NUM:8;			// 7:0
	uint32_t	CALPWR_M:4;			// 11:8
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union HRPWM_CYCLE_NUM_REG {
	uint32_t 		 all;
	struct HRPWM_CYCLE_NUM_BITS 		 bit;
};

#elif (EPWM_VERSION==30)
struct ADCSOCOUTSELECT_TOP_BITS {			// bits   description
	uint32_t	PWM1SOCAEN:1;			// 0:0
	uint32_t	PWM2SOCAEN:1;			// 1:1
	uint32_t	PWM3SOCAEN:1;			// 2:2
	uint32_t	PWM4SOCAEN:1;			// 3:3
	uint32_t	PWM5SOCAEN:1;			// 4:4
	uint32_t	PWM6SOCAEN:1;			// 5:5
	uint32_t	PWM7SOCAEN:1;			// 6:6
	uint32_t	PWM8SOCAEN:1;			// 7:7
	uint32_t	rsvd1:1;			// 8:8
	uint32_t	rsvd2:1;			// 9:9
	uint32_t	rsvd3:1;			// 10:10
	uint32_t	rsvd4:1;			// 11:11
	uint32_t	rsvd5:4;			// 15:12   reserved
	uint32_t	PWM1SOCBEN:1;			// 16:16
	uint32_t	PWM2SOCBEN:1;			// 17:17
	uint32_t	PWM3SOCBEN:1;			// 18:18
	uint32_t	PWM4SOCBEN:1;			// 19:19
	uint32_t	PWM5SOCBEN:1;			// 20:20
	uint32_t	PWM6SOCBEN:1;			// 21:21
	uint32_t	PWM7SOCBEN:1;			// 22:22
	uint32_t	PWM8SOCBEN:1;			// 23:23
	uint32_t	rsvd6:1;			// 24:24
	uint32_t	rsvd7:1;			// 25:25
	uint32_t	rsvd8:1;			// 26:26
	uint32_t	rsvd9:1;			// 27:27
	uint32_t	rsvd10:4;			// 31:28   reserved
};

union ADCSOCOUTSELECT_TOP_REG {
	uint32_t 		 all;
	struct ADCSOCOUTSELECT_TOP_BITS 		 bit;
};

//
// ePWM_TOP_trans processing mode
//
struct TRANS_MODE_BITS {			// bits  description
	uint32_t	CTR_MODE:2;			// 1:0   CTR counting mode
	uint32_t	rsvd1:6;			// 7:2   Reserved
	uint32_t	ALIGN_MODE:2;			// 9:8  alignment mode
	uint32_t	rsvd2:6;			// 15:10   Reserved
	uint32_t	TRANS_BYPASS:1;			// 16:16 ePWM_TOP_TRANS bypass enable
	uint32_t	rsvd3:15;			// 31:17   Reserved
};

union TRANS_MODE_REG {
	uint32_t 		 all;
	struct TRANS_MODE_BITS 		 bit;
};

//
// Period
//
struct PERIOD_BITS {			// bits   description
	uint32_t	rsvd1:8;			// 7:0   Reserved
	uint32_t	PERIOD:24;			// 31:8  Reserved
};

union PERIOD_REG {
	uint32_t 		 all;
	struct PERIOD_BITS 		 bit;
};

//
// Duty cycle
//
struct DUTYCYCLE1_BITS {			// bits   description
	uint32_t	rsvd1:8;			// 7:0   Reserved
	uint32_t	DUTYCYCLE1:24;			// 31:8 duty cycle of the lagging bridge arm
};

union DUTYCYCLE1_REG {
	uint32_t 		 all;
	struct DUTYCYCLE1_BITS 		 bit;
};

//
// Duty cycle
//
struct DUTYCYCLE2_BITS {			// bits   description
	uint32_t	rsvd1:8;			// 7:0   Reserved
	uint32_t	DUTYCYCLE2:24;			// 31:8  original phase shift of the leading bridge arm
};

union DUTYCYCLE2_REG {
	uint32_t 		 all;
	struct DUTYCYCLE2_BITS 		 bit;
};

//
// Phase shift
//
struct PHASESHIFT_BITS {			// bits   description
	uint32_t	rsvd1:8;			// 7:0   Reserved
	uint32_t	PHASESHIFT:24;			// 31:8 duty cycle of the lagging bridge arm
};

union PHASESHIFT_REG {
	uint32_t 		 all;
	struct PHASESHIFT_BITS 		 bit;
};

struct PHASESHIFT_INI_BITS {			// bits   description
	uint32_t	rsvd1:8;			// 7:0   Reserved
	uint32_t	PHASESHIFT_INI:24;			// 31:8 original phase shift of the leading bridge arm
};

union PHASESHIFT_INI_REG {
	uint32_t 		 all;
	struct PHASESHIFT_INI_BITS 		 bit;
};

struct EPWM_MUX_SEL_BITS {			// bits   description
	uint32_t	EPWM1_MUX:1;			// 0:0
	uint32_t	EPWM2_MUX:1;			// 1:1
	uint32_t	EPWM3_MUX:1;			// 2:2
	uint32_t	EPWM4_MUX:1;			// 3:3
	uint32_t	EPWM5_MUX:1;			// 4:4
	uint32_t	EPWM6_MUX:1;			// 5:5
	uint32_t	EPWM7_MUX:1;			// 6:6
	uint32_t	EPWM8_MUX:1;			// 7:7
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union EPWM_MUX_SEL_REG {
	uint32_t 		 all;
	struct EPWM_MUX_SEL_BITS 		 bit;
};

struct TRIPIN_INV_CFG_BITS {			// bits   description
	uint32_t	TRIP1IN_INV_CFG:1;			// 0:0
	uint32_t	TRIP2IN_INV_CFG:1;			// 1:1
	uint32_t	TRIP3IN_INV_CFG:1;			// 2:2
	uint32_t	TRIP4IN_INV_CFG:1;			// 3:3
	uint32_t	TRIP5IN_INV_CFG:1;			// 4:4
	uint32_t	TRIP6IN_INV_CFG:1;			// 5:5
	uint32_t	TRIP7IN_INV_CFG:1;			// 6:6
	uint32_t	TRIP8IN_INV_CFG:1;			// 7:7
	uint32_t	TRIP9IN_INV_CFG:1;			// 8:8
	uint32_t	TRIP10IN_INV_CFG:1;			// 9:9
	uint32_t	TRIP11IN_INV_CFG:1;			// 10:10
	uint32_t	TRIP12IN_INV_CFG:1;			// 11:11
	uint32_t	rsvd1:1;			// 12:12   Reserved
	uint32_t	TRIP14IN_INV_CFG:1;			// 13:13
	uint32_t	TRIP15IN_INV_CFG:1;			// 14:14
	uint32_t	TRIP16IN_INV_CFG:1;			// 15:15
	uint32_t	TRIP17IN_INV_CFG:1;			// 16:16
	uint32_t	TRIP18IN_INV_CFG:1;			// 17:17
	uint32_t	TRIP19IN_INV_CFG:1;			// 18:18
	uint32_t	TRIP20IN_INV_CFG:1;			// 19:19
	uint32_t	TRIP21IN_INV_CFG:1;			// 20:20
	uint32_t	rsvd2:11;			// 31:21   Reserved
};

union TRIPIN_INV_CFG_REG {
	uint32_t 		 all;
	struct TRIPIN_INV_CFG_BITS 		 bit;
};

struct PWM_HALT_EN_BITS {			// bits   description
	uint32_t	PWM_HALT_EN:3;			// 2:0
	uint32_t	rsvd2:29;			// 31:3   reserved
};

union PWM_HALT_EN_REG {
	uint32_t 		 all;
	struct PWM_HALT_EN_BITS 		 bit;
};
struct HRPWM_CYCLE_NUM_BITS {			// bits   description
	uint32_t	HRPWM_CYCLE_NUM:8;			// 7:0
	uint32_t	CALPWR_M:4;			// 11:8
	uint32_t	rsvd1:20;			// 31:12   Reserved
};

union HRPWM_CYCLE_NUM_REG {
	uint32_t 		 all;
	struct HRPWM_CYCLE_NUM_BITS 		 bit;
};

struct EPWM_EN_CFG1_BITS {			// bits   description
	uint32_t	EPWM1A_EN:1;		// 0:0
	uint32_t	EPWM1B_EN:1;		// 1:1
	uint32_t	EPWM2A_EN:1;		// 2:2
	uint32_t	EPWM2B_EN:1;		// 3:3
	uint32_t	EPWM3A_EN:1;		// 4:4
	uint32_t	EPWM3B_EN:1;		// 5:5
	uint32_t	EPWM4A_EN:1;		// 6:6
	uint32_t	EPWM4B_EN:1;		// 7:7
	uint32_t	EPWM5A_EN:1;		// 8:8
	uint32_t	EPWM5B_EN:1;		// 9:9
	uint32_t	EPWM6A_EN:1;		// 10:10
	uint32_t	EPWM6B_EN:1;		// 11:11
	uint32_t	EPWM7A_EN:1;		// 12:12
	uint32_t	EPWM7B_EN:1;		// 13:13
	uint32_t	EPWM8A_EN:1;		// 14:14
	uint32_t	EPWM8B_EN:1;		// 15:15
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union EPWM_EN_CFG1_REG {
	uint32_t 		 all;
	struct EPWM_EN_CFG1_BITS 		 bit;
};

struct EPWM_DISABLE_CFG1_BITS {			// bits   description
	uint32_t	EPWM1A_DISABLE:1;		// 0:0
	uint32_t	EPWM1B_DISABLE:1;		// 1:1
	uint32_t	EPWM2A_DISABLE:1;		// 2:2
	uint32_t	EPWM2B_DISABLE:1;		// 3:3
	uint32_t	EPWM3A_DISABLE:1;		// 4:4
	uint32_t	EPWM3B_DISABLE:1;		// 5:5
	uint32_t	EPWM4A_DISABLE:1;		// 6:6
	uint32_t	EPWM4B_DISABLE:1;		// 7:7
	uint32_t	EPWM5A_DISABLE:1;		// 8:8
	uint32_t	EPWM5B_DISABLE:1;		// 9:9
	uint32_t	EPWM6A_DISABLE:1;		// 10:10
	uint32_t	EPWM6B_DISABLE:1;		// 11:11
	uint32_t	EPWM7A_DISABLE:1;		// 12:12
	uint32_t	EPWM7B_DISABLE:1;		// 13:13
	uint32_t	EPWM8A_DISABLE:1;		// 14:14
	uint32_t	EPWM8B_DISABLE:1;		// 15:15
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union EPWM_DISABLE_CFG1_REG {
	uint32_t 		 all;
	struct EPWM_DISABLE_CFG1_BITS 		 bit;
};

struct EPWM_EN_RO1_BITS {			// bits   description
	uint32_t	EPWM1A_EN_FLAG:1;		// 0:0
	uint32_t	EPWM1B_EN_FLAG:1;		// 1:1
	uint32_t	EPWM2A_EN_FLAG:1;		// 2:2
	uint32_t	EPWM2B_EN_FLAG:1;		// 3:3
	uint32_t	EPWM3A_EN_FLAG:1;		// 4:4
	uint32_t	EPWM3B_EN_FLAG:1;		// 5:5
	uint32_t	EPWM4A_EN_FLAG:1;		// 6:6
	uint32_t	EPWM4B_EN_FLAG:1;		// 7:7
	uint32_t	EPWM5A_EN_FLAG:1;		// 8:8
	uint32_t	EPWM5B_EN_FLAG:1;		// 9:9
	uint32_t	EPWM6A_EN_FLAG:1;		// 10:10
	uint32_t	EPWM6B_EN_FLAG:1;		// 11:11
	uint32_t	EPWM7A_EN_FLAG:1;		// 12:12
	uint32_t	EPWM7B_EN_FLAG:1;		// 13:13
	uint32_t	EPWM8A_EN_FLAG:1;		// 14:14
	uint32_t	EPWM8B_EN_FLAG:1;		// 15:15
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union EPWM_EN_RO1_REG {
	uint32_t 		 all;
	struct EPWM_EN_RO1_BITS 		 bit;
};

struct EPWM_BURST_CFG1_BITS {			// bits   description
	uint32_t	EPWM_BURST1_PERIOD:8;		// 7:0
	uint32_t	EPWM_BURST1_START:8;		// 15:8
	uint32_t	EPWM_BURST1_END:8;		// 23:16
	uint32_t	EPWM_BURST1_TRIG_SEL:4;		// 27:24
	uint32_t	EPWM_BURST1_EN:1;		// 28
	uint32_t	EPWM_BURST2_EN:1;		// 29
	uint32_t	rsvd1:2;			// 31:30   Reserved
};

union EPWM_BURST_CFG1_REG {
	uint32_t 		 all;
	struct EPWM_BURST_CFG1_BITS 		 bit;
};

struct EPWM_BURST_CFG2_BITS {			// bits   description
	uint32_t	EPWM_BURST2_PERIOD:8;		// 7:0
	uint32_t	EPWM_BURST2_START:8;		// 15:8
	uint32_t	EPWM_BURST2_END:8;		// 23:16
	uint32_t	EPWM_BURST2_TRIG_SEL:4;		// 27:24
	uint32_t	rsvd1:2;			// 31:28   Reserved
};

union EPWM_BURST_CFG2_REG {
	uint32_t 		 all;
	struct EPWM_BURST_CFG2_BITS 		 bit;
};

struct EPWM_EN_MUX1_BITS {			// bits   description
	uint32_t	EPWM1A_EN_MUX:1;		// 0:0
	uint32_t	EPWM1B_EN_MUX:1;		// 1:1
	uint32_t	EPWM2A_EN_MUX:1;		// 2:2
	uint32_t	EPWM2B_EN_MUX:1;		// 3:3
	uint32_t	EPWM3A_EN_MUX:1;		// 4:4
	uint32_t	EPWM3B_EN_MUX:1;		// 5:5
	uint32_t	EPWM4A_EN_MUX:1;		// 6:6
	uint32_t	EPWM4B_EN_MUX:1;		// 7:7
	uint32_t	EPWM5A_EN_MUX:1;		// 8:8
	uint32_t	EPWM5B_EN_MUX:1;		// 9:9
	uint32_t	EPWM6A_EN_MUX:1;		// 10:10
	uint32_t	EPWM6B_EN_MUX:1;		// 11:11
	uint32_t	EPWM7A_EN_MUX:1;		// 12:12
	uint32_t	EPWM7B_EN_MUX:1;		// 13:13
	uint32_t	EPWM8A_EN_MUX:1;		// 14:14
	uint32_t	EPWM8B_EN_MUX:1;		// 15:15
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union EPWM_EN_MUX1_REG {
	uint32_t 		 all;
	struct EPWM_EN_MUX1_BITS 		 bit;
};

#endif

struct SYNCSELECT_TOP_BITS {				// bits   description
	uint32_t	EPWM4SYNCIN:3;			// 2:0
	uint32_t	EPWM7SYNCIN:3;			// 5:3
	uint32_t	EPWM10SYNCIN:3;		// 8:6
	uint32_t	ECAP1SYNCIN:3;			// 11:9
	uint32_t	ECAP4SYNCIN:3;			// 14:12
	uint32_t	rsvd1:12;				// 26:15
	uint32_t	SYNCOUT:2;				// 28:27
	uint32_t	rsvd2:3;				// 31:29
};

union SYNCSELECT_TOP_REG {
	uint32_t 		 all;
	struct SYNCSELECT_TOP_BITS 		 bit;
};

//
// Dead-Band configuration of ePWMxA for the leading bridge arm
//
struct DEADZONE_A1_BITS {			// bits   description
	uint32_t	REDXA1:14;			// 13:0   Rising edge dead band of ePWMxA for the lagging bridge arm? Rising edge delay value
	uint32_t	rsvd1:2;			// 15:14   Reserved
	uint32_t	FEDXA1:14;			// 29:16   Falling edge dead band of ePWMxA for the lagging bridge arm? Falling edge delay value
	uint32_t	rsvd2:2;			// 31:30   Reserved
};

union DEADZONE_A1_REG {
	uint32_t 		 all;
	struct DEADZONE_A1_BITS 		 bit;
};

//
// Dead-band configuration of ePWMxB for the lagging bridge arm
//
struct DEADZONE_B1_BITS {			// bits   description
	uint32_t	REDXB1:14;			// 13:0   Rising edge dead band of ePWMxB for the lagging bridge arm? Rising edge delay value
	uint32_t	rsvd1:2;			// 15:14   Reserved
	uint32_t	FEDXB1:14;			// 29:16  Falling edge dead band of ePWMxB for the lagging bridge arm? Falling edge delay value
	uint32_t	rsvd2:2;			// 31:30   Reserved
};

union DEADZONE_B1_REG {
	uint32_t 		 all;
	struct DEADZONE_B1_BITS 		 bit;
};

//
// Dead-Band configuration of ePWMxA for the lagging bridge arm
//
struct DEADZONE_A2_BITS {			// bits   description
	uint32_t	REDXA2:14;			// 13:0   Rising edge dead band of ePWMxA for the lagging bridge arm? Rising edge delay value
	uint32_t	rsvd1:2;			// 15:14   Reserved
	uint32_t	FEDXA2:14;			// 29:16  Falling edge dead band of ePWMxA for the lagging bridge arm? Falling edge delay value
	uint32_t	rsvd2:2;			// 31:30   Reserved
};

union DEADZONE_A2_REG {
	uint32_t 		 all;
	struct DEADZONE_A2_BITS 		 bit;
};

//
// Dead-Band configuration of ePWMxB for the lagging bridge arm
//
struct DEADZONE_B2_BITS {			// bits   description
	uint32_t	REDXB2:14;			// 13:0   Rising edge dead band of ePWMxB for the lagging bridge arm? Rising edge delay value
	uint32_t	rsvd1:2;			// 15:14   Reserved
	uint32_t	FEDXB2:14;			// 29:16  Falling edge dead band of ePWMxB for the lagging bridge arm? Falling edge delay value
	uint32_t	rsvd2:2;			// 31:30   Reserved
};

union DEADZONE_B2_REG {
	uint32_t 		 all;
	struct DEADZONE_B2_BITS 		 bit;
};

struct AQCSFRC_TOP_BITS {			// bits   description
	uint32_t	AQCSFRC_CSFA:2;			// 1:0
	uint32_t	rsvd1:14;			// 15:2   Reserved
	uint32_t	AQCSFRC_CSFB:2;			// 17:16
	uint32_t	rsvd2:14;			// 31:18   Reserved
};

union AQCSFRC_TOP_REG {
	uint32_t 		 all;
	struct AQCSFRC_TOP_BITS 		 bit;
};

struct EPWM_TOP_REGS_LOCK_BITS {			// bits   description
	uint32_t	EPWM_TOP_REGS_LOCK:32;			// 31:0
};

union EPWM_TOP_REGS_LOCK_REG {
	uint32_t 		 all;
	struct EPWM_TOP_REGS_LOCK_BITS 		 bit;
};

struct TZ_INV_CFG_BITS {			// bits   description
	uint32_t	TZ1_INV_CFG:1;			// 0:0
	uint32_t	TZ2_INV_CFG:1;			// 1:1
	uint32_t	TZ3_INV_CFG:1;			// 2:2
	uint32_t	TZ4_INV_CFG:1;			// 3:3
	uint32_t	TZ5_INV_CFG:1;			// 4:4
	uint32_t	TZ6_INV_CFG:1;			// 5:5
	uint32_t	TZ7_INV_CFG:1;			// 6:6
	uint32_t	TZ8_INV_CFG:1;			// 7:7
	uint32_t	TZ9_INV_CFG:1;			// 8:8
	uint32_t	rsvd1:23;			// 31:9   Reserved
};

union TZ_INV_CFG_REG {
	uint32_t 		 all;
	struct TZ_INV_CFG_BITS 		 bit;
};

struct HRPWM_0CFG_BITS {			// bits   description
	uint32_t	HRPWM_0CFG:32;			// 31:0
};

union HRPWM_0CFG_REG {
	uint32_t 		 all;
	struct HRPWM_0CFG_BITS 		 bit;
};



#if(EPWM_VERSION==30)

//
// EPWM XCMP Register
//
struct XCMPCTL1_BITS {			// bits   description
	uint32_t	XCMPEN:1;			// 0:0
	uint32_t	XCMPSPLIT:1;			// 1:1
	uint32_t	rsvd1:2;			// 3:2   Reserved
	uint32_t	XCMPA_ALLOC:4;			// 7:4
	uint32_t	XCMPB_ALLOC:4;			// 11:8
	uint32_t	rsvd2:20;			// 31:12   Reserved
};

union XCMPCTL1_REG {
	uint32_t 		 all;
	struct XCMPCTL1_BITS 		 bit;
};

struct XLOADCTL_BITS {			// bits   description
	uint32_t	rsvd1:2;			// 1:0   Reserved
	uint32_t	LOADMODE:1;			// 2:2
	uint32_t	rsvd2:1;			// 3:3   Reserved
	uint32_t	SHDWLEVEL:2;			// 5:4
	uint32_t	rsvd3:2;			// 7:6   Reserved
	uint32_t	SHDWBUFPTR_LOADONCE:2;			// 9:8
	uint32_t	SHDWBUFPTR_LOADMULTIPLE:2;			// 11:10
	uint32_t	rsvd4:4;			// 15:12   Reserved
	uint32_t	RPTBUF2PRD:3;			// 18:16
	uint32_t	rsvd5:1;			// 19:19   Reserved
	uint32_t	RPTBUF2CNT:3;			// 22:20
	uint32_t	rsvd6:1;			// 23:23   Reserved
	uint32_t	RPTBUF3PRD:3;			// 26:24
	uint32_t	rsvd7:1;			// 27:27   Reserved
	uint32_t	RPTBUF3CNT:3;			// 30:28
	uint32_t	rsvd8:1;			// 31:31   Reserved
};

union XLOADCTL_REG {
	uint32_t 		 all;
	struct XLOADCTL_BITS 		 bit;
};

struct XLOAD_BITS {			// bits   description
	uint32_t	STARTLD:1;			// 0:0
	uint32_t	FRCLD:1;			// 1:1
	uint32_t	rsvd1:30;			// 31:2   Reserved
};

union XLOAD_REG {
	uint32_t 		 all;
	struct XLOAD_BITS 		 bit;
};

struct EPWMXLINKXLOAD_BITS {			// bits   description
	uint32_t	XLOADLINK:4;			// 3:0
	uint32_t	rsvd1:28;			// 31:4   Reserved
};

union EPWMXLINKXLOAD_REG {
	uint32_t 		 all;
	struct EPWMXLINKXLOAD_BITS 		 bit;
};

struct XREGSHDW1STS_BITS {			// bits   description
	uint32_t	XCMP1_SHDW1FULL:1;			// 0:0
	uint32_t	XCMP2_SHDW1FULL:1;			// 1:1
	uint32_t	XCMP3_SHDW1FULL:1;			// 2:2
	uint32_t	XCMP4_SHDW1FULL:1;			// 3:3
	uint32_t	XCMP5_SHDW1FULL:1;			// 4:4
	uint32_t	XCMP6_SHDW1FULL:1;			// 5:5
	uint32_t	XCMP7_SHDW1FULL:1;			// 6:6
	uint32_t	XCMP8_SHDW1FULL:1;			// 7:7
	uint32_t	XTBPRD_SHDW1FULL:1;			// 8:8
	uint32_t	CMPC_SHDW1FULL:1;			// 9:9
	uint32_t	CMPD_SHDW1FULL:1;			// 10:10
	uint32_t	XAQCTLA_SHDW1FULL:1;			// 11:11
	uint32_t	XAQCTLB_SHDW1FULL:1;			// 12:12
	uint32_t	XMAX_SHDW1FULL:1;			// 13:13
	uint32_t	XMIN_SHDW1FULL:1;			// 14:14
	uint32_t	rsvd1:17;			// 31:15   Reserved
};

union XREGSHDW1STS_REG {
	uint32_t 		 all;
	struct XREGSHDW1STS_BITS 		 bit;
};

struct XREGSHDW2STS_BITS {			// bits   description
	uint32_t	XCMP1_SHDW2FULL:1;			// 0:0
	uint32_t	XCMP2_SHDW2FULL:1;			// 1:1
	uint32_t	XCMP3_SHDW2FULL:1;			// 2:2
	uint32_t	XCMP4_SHDW2FULL:1;			// 3:3
	uint32_t	XCMP5_SHDW2FULL:1;			// 4:4
	uint32_t	XCMP6_SHDW2FULL:1;			// 5:5
	uint32_t	XCMP7_SHDW2FULL:1;			// 6:6
	uint32_t	XCMP8_SHDW2FULL:1;			// 7:7
	uint32_t	XTBPRD_SHDW2FULL:1;			// 8:8
	uint32_t	CMPC_SHDW2FULL:1;			// 9:9
	uint32_t	CMPD_SHDW2FULL:1;			// 10:10
	uint32_t	XAQCTLA_SHDW2FULL:1;			// 11:11
	uint32_t	XAQCTLB_SHDW2FULL:1;			// 12:12
	uint32_t	XMAX_SHDW2FULL:1;			// 13:13
	uint32_t	XMIN_SHDW2FULL:1;			// 14:14
	uint32_t	rsvd1:17;			// 31:15   Reserved
};

union XREGSHDW2STS_REG {
	uint32_t 		 all;
	struct XREGSHDW2STS_BITS 		 bit;
};

struct XREGSHDW3STS_BITS {			// bits   description
	uint32_t	XCMP1_SHDW3FULL:1;			// 0:0
	uint32_t	XCMP2_SHDW3FULL:1;			// 1:1
	uint32_t	XCMP3_SHDW3FULL:1;			// 2:2
	uint32_t	XCMP4_SHDW3FULL:1;			// 3:3
	uint32_t	XCMP5_SHDW3FULL:1;			// 4:4
	uint32_t	XCMP6_SHDW3FULL:1;			// 5:5
	uint32_t	XCMP7_SHDW3FULL:1;			// 6:6
	uint32_t	XCMP8_SHDW3FULL:1;			// 7:7
	uint32_t	XTBPRD_SHDW3FULL:1;			// 8:8
	uint32_t	CMPC_SHDW3FULL:1;			// 9:9
	uint32_t	CMPD_SHDW3FULL:1;			// 10:10
	uint32_t	XAQCTLA_SHDW3FULL:1;			// 11:11
	uint32_t	XAQCTLB_SHDW3FULL:1;			// 12:12
	uint32_t	XMAX_SHDW3FULL:1;			// 13:13
	uint32_t	XMIN_SHDW3FULL:1;			// 14:14
	uint32_t	rsvd1:17;			// 31:15   Reserved
};

union XREGSHDW3STS_REG {
	uint32_t 		 all;
	struct XREGSHDW3STS_BITS 		 bit;
};

struct XCMP1_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP1HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP1_ACTIVE:16;			// 31:16
};

union XCMP1_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP1_ACTIVE_BITS 		 bit;
};

struct XCMP2_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP2HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP2_ACTIVE:16;			// 31:16
};

union XCMP2_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP2_ACTIVE_BITS 		 bit;
};

struct XCMP3_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP3HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP3_ACTIVE:16;			// 31:16
};

union XCMP3_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP3_ACTIVE_BITS 		 bit;
};

struct XCMP4_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP4HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP4_ACTIVE:16;			// 31:16
};

union XCMP4_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP4_ACTIVE_BITS 		 bit;
};

struct XCMP5_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP5HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP5_ACTIVE:16;			// 31:16
};

union XCMP5_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP5_ACTIVE_BITS 		 bit;
};

struct XCMP6_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP6HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP6_ACTIVE:16;			// 31:16
};

union XCMP6_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP6_ACTIVE_BITS 		 bit;
};

struct XCMP7_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP7HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP7_ACTIVE:16;			// 31:16
};

union XCMP7_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP7_ACTIVE_BITS 		 bit;
};

struct XCMP8_ACTIVE_BITS {			// bits   description
	uint32_t	XCMP8HR_ACTIVE:16;			// 15:0
	uint32_t	XCMP8_ACTIVE:16;			// 31:16
};

union XCMP8_ACTIVE_REG {
	uint32_t 		 all;
	struct XCMP8_ACTIVE_BITS 		 bit;
};

struct XTBPRD_ACTIVE_BITS {			// bits   description
	uint32_t	XTBPRDHR_ACTIVE:16;			// 15:0
	uint32_t	XTBPRD_ACTIVE:16;			// 31:16
};

union XTBPRD_ACTIVE_REG {
	uint32_t 		 all;
	struct XTBPRD_ACTIVE_BITS 		 bit;
};

struct XAQCTLA_ACTIVE_BITS {			// bits   description
	uint16_t	XCMP1_AQCTLA_ACTIVE:2;			// 1:0
	uint16_t	XCMP2_AQCTLA_ACTIVE:2;			// 3:2
	uint16_t	XCMP3_AQCTLA_ACTIVE:2;			// 5:4
	uint16_t	XCMP4_AQCTLA_ACTIVE:2;			// 7:6
	uint16_t	XCMP5_AQCTLA_ACTIVE:2;			// 9:8
	uint16_t	XCMP6_AQCTLA_ACTIVE:2;			// 11:10
	uint16_t	XCMP7_AQCTLA_ACTIVE:2;			// 13:12
	uint16_t	XCMP8_AQCTLA_ACTIVE:2;			// 15:14
};

union XAQCTLA_ACTIVE_REG {
	uint16_t 		 all;
	struct XAQCTLA_ACTIVE_BITS 		 bit;
};

struct XAQCTLB_ACTIVE_BITS {			// bits   description
	uint16_t	rsvd1:8;			// 7:0   Reserved
	uint16_t	XCMP5_AQCTLB_ACTIVE:2;			// 9:8
	uint16_t	XCMP6_AQCTLB_ACTIVE:2;			// 11:10
	uint16_t	XCMP7_AQCTLB_ACTIVE:2;			// 13:12
	uint16_t	XCMP8_AQCTLB_ACTIVE:2;			// 15:14
};

union XAQCTLB_ACTIVE_REG {
	uint16_t 		 all;
	struct XAQCTLB_ACTIVE_BITS 		 bit;
};

struct XMINMAX_ACTIVE_BITS {			// bits   description
	uint32_t	XMAX_ACTIVE:16;			// 15:0
	uint32_t	XMIN_ACTIVE:16;			// 31:16
};

union XMINMAX_ACTIVE_REG {
	uint32_t 		 all;
	struct XMINMAX_ACTIVE_BITS 		 bit;
};

struct XCMP1_SHDW1_BITS {			// bits   description
	uint32_t	XCMP1HR_SHDW1:16;			// 15:0
	uint32_t	XCMP1_SHDW1:16;			// 31:16
};

union XCMP1_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP1_SHDW1_BITS 		 bit;
};

struct XCMP2_SHDW1_BITS {			// bits   description
	uint32_t	XCMP2HR_SHDW1:16;			// 15:0
	uint32_t	XCMP2_SHDW1:16;			// 31:16
};

union XCMP2_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP2_SHDW1_BITS 		 bit;
};

struct XCMP3_SHDW1_BITS {			// bits   description
	uint32_t	XCMP3HR_SHDW1:16;			// 15:0
	uint32_t	XCMP3_SHDW1:16;			// 31:16
};

union XCMP3_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP3_SHDW1_BITS 		 bit;
};

struct XCMP4_SHDW1_BITS {			// bits   description
	uint32_t	XCMP4HR_SHDW1:16;			// 15:0
	uint32_t	XCMP4_SHDW1:16;			// 31:16
};

union XCMP4_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP4_SHDW1_BITS 		 bit;
};

struct XCMP5_SHDW1_BITS {			// bits   description
	uint32_t	XCMP5HR_SHDW1:16;			// 15:0
	uint32_t	XCMP5_SHDW1:16;			// 31:16
};

union XCMP5_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP5_SHDW1_BITS 		 bit;
};

struct XCMP6_SHDW1_BITS {			// bits   description
	uint32_t	XCMP6HR_SHDW1:16;			// 15:0
	uint32_t	XCMP6_SHDW1:16;			// 31:16
};

union XCMP6_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP6_SHDW1_BITS 		 bit;
};

struct XCMP7_SHDW1_BITS {			// bits   description
	uint32_t	XCMP7HR_SHDW1:16;			// 15:0
	uint32_t	XCMP7_SHDW1:16;			// 31:16
};

union XCMP7_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP7_SHDW1_BITS 		 bit;
};

struct XCMP8_SHDW1_BITS {			// bits   description
	uint32_t	XCMP8HR_SHDW1:16;			// 15:0
	uint32_t	XCMP8_SHDW1:16;			// 31:16
};

union XCMP8_SHDW1_REG {
	uint32_t 		 all;
	struct XCMP8_SHDW1_BITS 		 bit;
};

struct XTBPRD_SHDW1_BITS {			// bits   description
	uint32_t	XTBPRDHR_SHDW1:16;			// 15:0
	uint32_t	XTBPRD_SHDW1:16;			// 31:16
};

union XTBPRD_SHDW1_REG {
	uint32_t 		 all;
	struct XTBPRD_SHDW1_BITS 		 bit;
};

struct XAQCTLA_SHDW1_BITS {			// bits   description
	uint16_t	XCMP1_AQCTLA_SHDW1:2;			// 1:0
	uint16_t	XCMP2_AQCTLA_SHDW1:2;			// 3:2
	uint16_t	XCMP3_AQCTLA_SHDW1:2;			// 5:4
	uint16_t	XCMP4_AQCTLA_SHDW1:2;			// 7:6
	uint16_t	XCMP5_AQCTLA_SHDW1:2;			// 9:8
	uint16_t	XCMP6_AQCTLA_SHDW1:2;			// 11:10
	uint16_t	XCMP7_AQCTLA_SHDW1:2;			// 13:12
	uint16_t	XCMP8_AQCTLA_SHDW1:2;			// 15:14
};

union XAQCTLA_SHDW1_REG {
	uint16_t 		 all;
	struct XAQCTLA_SHDW1_BITS 		 bit;
};

struct XAQCTLB_SHDW1_BITS {			// bits   description
	uint16_t	rsvd1:8;			// 7:0   Reserved
	uint16_t	XCMP5_AQCTLB_SHDW1:2;			// 9:8
	uint16_t	XCMP6_AQCTLB_SHDW1:2;			// 11:10
	uint16_t	XCMP7_AQCTLB_SHDW1:2;			// 13:12
	uint16_t	XCMP8_AQCTLB_SHDW1:2;			// 15:14
};

union XAQCTLB_SHDW1_REG {
	uint16_t 		 all;
	struct XAQCTLB_SHDW1_BITS 		 bit;
};

struct XMINMAX_SHDW1_BITS {			// bits   description
	uint32_t	XMAX_SHDW1:16;			// 15:0
	uint32_t	XMIN_SHDW1:16;			// 31:16
};

union XMINMAX_SHDW1_REG {
	uint32_t 		 all;
	struct XMINMAX_SHDW1_BITS 		 bit;
};

struct XCMP1_SHDW2_BITS {			// bits   description
	uint32_t	XCMP1HR_SHDW2:16;			// 15:0
	uint32_t	XCMP1_SHDW2:16;			// 31:16
};

union XCMP1_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP1_SHDW2_BITS 		 bit;
};

struct XCMP2_SHDW2_BITS {			// bits   description
	uint32_t	XCMP2HR_SHDW2:16;			// 15:0
	uint32_t	XCMP2_SHDW2:16;			// 31:16
};

union XCMP2_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP2_SHDW2_BITS 		 bit;
};

struct XCMP3_SHDW2_BITS {			// bits   description
	uint32_t	XCMP3HR_SHDW2:16;			// 15:0
	uint32_t	XCMP3_SHDW2:16;			// 31:16
};

union XCMP3_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP3_SHDW2_BITS 		 bit;
};

struct XCMP4_SHDW2_BITS {			// bits   description
	uint32_t	XCMP4HR_SHDW2:16;			// 15:0
	uint32_t	XCMP4_SHDW2:16;			// 31:16
};

union XCMP4_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP4_SHDW2_BITS 		 bit;
};

struct XCMP5_SHDW2_BITS {			// bits   description
	uint32_t	XCMP5HR_SHDW2:16;			// 15:0
	uint32_t	XCMP5_SHDW2:16;			// 31:16
};

union XCMP5_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP5_SHDW2_BITS 		 bit;
};

struct XCMP6_SHDW2_BITS {			// bits   description
	uint32_t	XCMP6HR_SHDW2:16;			// 15:0
	uint32_t	XCMP6_SHDW2:16;			// 31:16
};

union XCMP6_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP6_SHDW2_BITS 		 bit;
};

struct XCMP7_SHDW2_BITS {			// bits   description
	uint32_t	XCMP7HR_SHDW2:16;			// 15:0
	uint32_t	XCMP7_SHDW2:16;			// 31:16
};

union XCMP7_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP7_SHDW2_BITS 		 bit;
};

struct XCMP8_SHDW2_BITS {			// bits   description
	uint32_t	XCMP8HR_SHDW2:16;			// 15:0
	uint32_t	XCMP8_SHDW2:16;			// 31:16
};

union XCMP8_SHDW2_REG {
	uint32_t 		 all;
	struct XCMP8_SHDW2_BITS 		 bit;
};

struct XTBPRD_SHDW2_BITS {			// bits   description
	uint32_t	XTBPRDHR_SHDW2:16;			// 15:0
	uint32_t	XTBPRD_SHDW2:16;			// 31:16
};

union XTBPRD_SHDW2_REG {
	uint32_t 		 all;
	struct XTBPRD_SHDW2_BITS 		 bit;
};

struct XAQCTLA_SHDW2_BITS {			// bits   description
	uint16_t	XCMP1_AQCTLA_SHDW2:2;			// 1:0
	uint16_t	XCMP2_AQCTLA_SHDW2:2;			// 3:2
	uint16_t	XCMP3_AQCTLA_SHDW2:2;			// 5:4
	uint16_t	XCMP4_AQCTLA_SHDW2:2;			// 7:6
	uint16_t	XCMP5_AQCTLA_SHDW2:2;			// 9:8
	uint16_t	XCMP6_AQCTLA_SHDW2:2;			// 11:10
	uint16_t	XCMP7_AQCTLA_SHDW2:2;			// 13:12
	uint16_t	XCMP8_AQCTLA_SHDW2:2;			// 15:14
};

union XAQCTLA_SHDW2_REG {
	uint16_t 		 all;
	struct XAQCTLA_SHDW2_BITS 		 bit;
};

struct XAQCTLB_SHDW2_BITS {			// bits   description
	uint16_t	rsvd1:8;			// 7:0   Reserved
	uint16_t	XCMP5_AQCTLB_SHDW2:2;			// 9:8
	uint16_t	XCMP6_AQCTLB_SHDW2:2;			// 11:10
	uint16_t	XCMP7_AQCTLB_SHDW2:2;			// 13:12
	uint16_t	XCMP8_AQCTLB_SHDW2:2;			// 15:14
};

union XAQCTLB_SHDW2_REG {
	uint16_t 		 all;
	struct XAQCTLB_SHDW2_BITS 		 bit;
};

struct XMINMAX_SHDW2_BITS {			// bits   description
	uint32_t	XMAX_SHDW2:16;			// 15:0
	uint32_t	XMIN_SHDW2:16;			// 31:16
};

union XMINMAX_SHDW2_REG {
	uint32_t 		 all;
	struct XMINMAX_SHDW2_BITS 		 bit;
};

struct XCMP1_SHDW3_BITS {			// bits   description
	uint32_t	XCMP1HR_SHDW3:16;			// 15:0
	uint32_t	XCMP1_SHDW3:16;			// 31:16
};

union XCMP1_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP1_SHDW3_BITS 		 bit;
};

struct XCMP2_SHDW3_BITS {			// bits   description
	uint32_t	XCMP2HR_SHDW3:16;			// 15:0
	uint32_t	XCMP2_SHDW3:16;			// 31:16
};

union XCMP2_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP2_SHDW3_BITS 		 bit;
};

struct XCMP3_SHDW3_BITS {			// bits   description
	uint32_t	XCMP3HR_SHDW3:16;			// 15:0
	uint32_t	XCMP3_SHDW3:16;			// 31:16
};

union XCMP3_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP3_SHDW3_BITS 		 bit;
};

struct XCMP4_SHDW3_BITS {			// bits   description
	uint32_t	XCMP4HR_SHDW3:16;			// 15:0
	uint32_t	XCMP4_SHDW3:16;			// 31:16
};

union XCMP4_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP4_SHDW3_BITS 		 bit;
};

struct XCMP5_SHDW3_BITS {			// bits   description
	uint32_t	XCMP5HR_SHDW3:16;			// 15:0
	uint32_t	XCMP5_SHDW3:16;			// 31:16
};

union XCMP5_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP5_SHDW3_BITS 		 bit;
};

struct XCMP6_SHDW3_BITS {			// bits   description
	uint32_t	XCMP6HR_SHDW3:16;			// 15:0
	uint32_t	XCMP6_SHDW3:16;			// 31:16
};

union XCMP6_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP6_SHDW3_BITS 		 bit;
};

struct XCMP7_SHDW3_BITS {			// bits   description
	uint32_t	XCMP7HR_SHDW3:16;			// 15:0
	uint32_t	XCMP7_SHDW3:16;			// 31:16
};

union XCMP7_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP7_SHDW3_BITS 		 bit;
};

struct XCMP8_SHDW3_BITS {			// bits   description
	uint32_t	XCMP8HR_SHDW3:16;			// 15:0
	uint32_t	XCMP8_SHDW3:16;			// 31:16
};

union XCMP8_SHDW3_REG {
	uint32_t 		 all;
	struct XCMP8_SHDW3_BITS 		 bit;
};

struct XTBPRD_SHDW3_BITS {			// bits   description
	uint32_t	XTBPRDHR_SHDW3:16;			// 15:0
	uint32_t	XTBPRD_SHDW3:16;			// 31:16
};

union XTBPRD_SHDW3_REG {
	uint32_t 		 all;
	struct XTBPRD_SHDW3_BITS 		 bit;
};

struct XAQCTLA_SHDW3_BITS {			// bits   description
	uint16_t	XCMP1_AQCTLA_SHDW3:2;			// 1:0
	uint16_t	XCMP2_AQCTLA_SHDW3:2;			// 3:2
	uint16_t	XCMP3_AQCTLA_SHDW3:2;			// 5:4
	uint16_t	XCMP4_AQCTLA_SHDW3:2;			// 7:6
	uint16_t	XCMP5_AQCTLA_SHDW3:2;			// 9:8
	uint16_t	XCMP6_AQCTLA_SHDW3:2;			// 11:10
	uint16_t	XCMP7_AQCTLA_SHDW3:2;			// 13:12
	uint16_t	XCMP8_AQCTLA_SHDW3:2;			// 15:14
};

union XAQCTLA_SHDW3_REG {
	uint16_t 		 all;
	struct XAQCTLA_SHDW3_BITS 		 bit;
};

struct XAQCTLB_SHDW3_BITS {			// bits   description
	uint16_t	rsvd1:8;			// 7:0   Reserved
	uint16_t	XCMP5_AQCTLB_SHDW3:2;			// 9:8
	uint16_t	XCMP6_AQCTLB_SHDW3:2;			// 11:10
	uint16_t	XCMP7_AQCTLB_SHDW3:2;			// 13:12
	uint16_t	XCMP8_AQCTLB_SHDW3:2;			// 15:14
};

union XAQCTLB_SHDW3_REG {
	uint16_t 		 all;
	struct XAQCTLB_SHDW3_BITS 		 bit;
};

struct XMINMAX_SHDW3_BITS {			// bits   description
	uint32_t	XMAX_SHDW3:16;			// 15:0
	uint32_t	XMIN_SHDW3:16;			// 31:16
};

union XMINMAX_SHDW3_REG {
	uint32_t 		 all;
	struct XMINMAX_SHDW3_BITS 		 bit;
};



//
// EPWM DE Register
//
struct DECTL_BITS {			// bits   description
	uint32_t	DE_ENABLE:1;			// 0:0
	uint32_t	DE_MODE:1;			// 1:1
	uint32_t	rsvd1:6;			// 7:2   Reserved
	uint32_t	DE_REENTRYDLY:8;			// 15:8
	uint32_t	rsvd2:16;			// 31:16   Reserved
};

union DECTL_REG {
	uint32_t 		 all;
	struct DECTL_BITS 		 bit;
};

struct DECOMPSEL_BITS {			// bits   description
	uint32_t	DE_TRIPL:6;			// 5:0
	uint32_t	rsvd1:10;			// 15:6   Reserved
	uint32_t	DE_TRIPH:6;			// 21:16
	uint32_t	rsvd2:10;			// 31:22   Reserved
};

union DECOMPSEL_REG {
	uint32_t 		 all;
	struct DECOMPSEL_BITS 		 bit;
};

struct DEACTCTL_BITS {			// bits   description
	uint32_t	DE_PWMA:2;			// 1:0
	uint32_t	DE_TRIPSELA:1;			// 2:2
	uint32_t	rsvd1:1;			// 3:3   Reserved
	uint32_t	DE_PWMB:2;			// 5:4
	uint32_t	DE_TRIPSELB:1;			// 6:6
	uint32_t	rsvd2:9;			// 15:7   Reserved
	uint32_t	DE_TRIPENABLE:1;			// 16:16
	uint32_t	rsvd3:15;			// 31:17   Reserved
};

union DEACTCTL_REG {
	uint32_t 		 all;
	struct DEACTCTL_BITS 		 bit;
};

struct DESTS_BITS {			// bits   description
	uint32_t	DEACTIVE:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DESTS_REG {
	uint32_t 		 all;
	struct DESTS_BITS 		 bit;
};

struct DEFRC_BITS {			// bits   description
	uint32_t	DEACTIVE_FRC:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DEFRC_REG {
	uint32_t 		 all;
	struct DEFRC_BITS 		 bit;
};

struct DECLR_BITS {			// bits   description
	uint32_t	DEACTIVE_CLR:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DECLR_REG {
	uint32_t 		 all;
	struct DECLR_BITS 		 bit;
};

struct DEMONCNT_BITS {			// bits   description
	uint32_t	DEMONCNT:16;			// 15:0
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union DEMONCNT_REG {
	uint32_t 		 all;
	struct DEMONCNT_BITS 		 bit;
};

struct DEMONCTL_BITS {			// bits   description
	uint32_t	DEMON_ENABLE:1;			// 0:0
	uint32_t	rsvd1:31;			// 31:1   Reserved
};

union DEMONCTL_REG {
	uint32_t 		 all;
	struct DEMONCTL_BITS 		 bit;
};

struct DEMONSTEP_BITS {			// bits   description
	uint32_t	DEMON_INCSTEP:8;			// 7:0
	uint32_t	rsvd1:8;			// 15:8   Reserved
	uint32_t	DEMON_DECSTEP:8;			// 23:16
	uint32_t	rsvd2:8;			// 31:24   Reserved
};

union DEMONSTEP_REG {
	uint32_t 		 all;
	struct DEMONSTEP_BITS 		 bit;
};

struct DEMONTHRES_BITS {			// bits   description
	uint32_t	DEMON_THRESHOLD:16;			// 15:0
	uint32_t	rsvd1:16;			// 31:16   Reserved
};

union DEMONTHRES_REG {
	uint32_t 		 all;
	struct DEMONTHRES_BITS 		 bit;
};



//
// EPWM MINDB Register
//
struct MINDBCFG_BITS {			// bits   description
	uint32_t	MINDB_ENABLEA:1;			// 0:0
	uint32_t	rsvd1:1;			// 1:1   Reserved
	uint32_t	MINDB_INVERTA:1;			// 2:2
	uint32_t	MINDB_SELBLOCKA:1;			// 3:3
	uint32_t	MINDB_SELA:4;			// 7:4
	uint32_t	MINDB_POLSELA:1;			// 8:8
	uint32_t	rsvd2:7;			// 15:9   Reserved
	uint32_t	MINDB_ENABLEB:1;			// 16:16
	uint32_t	rsvd3:1;			// 17:17   Reserved
	uint32_t	MINDB_INVERTB:1;			// 18:18
	uint32_t	MINDB_SELBLOCKB:1;			// 19:19
	uint32_t	MINDB_SELB:4;			// 23:20
	uint32_t	MINDB_POLSELB:1;			// 24:24
	uint32_t	rsvd4:7;			// 31:25   Reserved
};

union MINDBCFG_REG {
	uint32_t 		 all;
	struct MINDBCFG_BITS 		 bit;
};

struct MINDBDLY_BITS {			// bits   description
	uint32_t	MINDB_DELAYA:16;			// 15:0
	uint32_t	MINDB_DELAYB:16;			// 31:16
};

union MINDBDLY_REG {
	uint32_t 		 all;
	struct MINDBDLY_BITS 		 bit;
};

struct LUTCTLA_BITS {			// bits   description
	uint32_t	MINDBA_BYPASS:1;			// 0:0
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	MINDBA_SELXBAR:4;			// 7:4
	uint32_t	rsvd2:8;			// 15:8   Reserved
	uint32_t	MINDBA_LUTDEC0:1;			// 16:16
	uint32_t	MINDBA_LUTDEC1:1;			// 17:17
	uint32_t	MINDBA_LUTDEC2:1;			// 18:18
	uint32_t	MINDBA_LUTDEC3:1;			// 19:19
	uint32_t	MINDBA_LUTDEC4:1;			// 20:20
	uint32_t	MINDBA_LUTDEC5:1;			// 21:21
	uint32_t	MINDBA_LUTDEC6:1;			// 22:22
	uint32_t	MINDBA_LUTDEC7:1;			// 23:23
	uint32_t	rsvd3:8;			// 31:24   Reserved
};

union LUTCTLA_REG {
	uint32_t 		 all;
	struct LUTCTLA_BITS 		 bit;
};

struct LUTCTLB_BITS {			// bits   description
	uint32_t	MINDBB_BYPASS:1;			// 0:0
	uint32_t	rsvd1:3;			// 3:1   Reserved
	uint32_t	MINDBB_SELXBAR:4;			// 7:4
	uint32_t	rsvd2:8;			// 15:8   Reserved
	uint32_t	MINDBB_LUTDEC0:1;			// 16:16
	uint32_t	MINDBB_LUTDEC1:1;			// 17:17
	uint32_t	MINDBB_LUTDEC2:1;			// 18:18
	uint32_t	MINDBB_LUTDEC3:1;			// 19:19
	uint32_t	MINDBB_LUTDEC4:1;			// 20:20
	uint32_t	MINDBB_LUTDEC5:1;			// 21:21
	uint32_t	MINDBB_LUTDEC6:1;			// 22:22
	uint32_t	MINDBB_LUTDEC7:1;			// 23:23
	uint32_t	rsvd3:8;			// 31:24   Reserved
};

union LUTCTLB_REG {
	uint32_t 		 all;
	struct LUTCTLB_BITS 		 bit;
};


#endif





// ePWM Register Definitions:
#if (EPWM_VERSION==22)
struct EPWM_REGS {
	union  TBCTL_REG			TBCTL;                //offset 0 ,sub_offset 2
	union  TBCTL2_REG			TBCTL2;               //offset 2 ,sub_offset 2
	uint16_t 						rsvd1; 		      // reserved //offset 4 ,sub_offset 2
	union  EPWMSYNCINSEL_REG			EPWMSYNCINSEL;           //offset 6 ,sub_offset 2
	uint16_t			        TBCTR;                           //offset 8 ,sub_offset 2
	union  TBSTS_REG			TBSTS;                           //offset A ,sub_offset 2
	union  EPWMSYNCOUTEN_REG			EPWMSYNCOUTEN;           //offset C ,sub_offset 2
	union  TBCTL3_REG			TBCTL3;                          //offset E ,sub_offset 2
	union  CMPCTL_REG			CMPCTL;                          //offset 10 ,sub_offset 2
	union  CMPCTL2_REG			CMPCTL2;                         //offset 12 ,sub_offset 2
	union  CMPCTL3_REG			CMPCTL3;                         //offset 14 ,sub_offset 2
	uint16_t 						rsvd2; 		 // reserved     //offset 16 ,sub_offset 2
	union  DBCTL_REG			DBCTL;                           //offset 18 ,sub_offset 2
	union  DBCTL2_REG			DBCTL2;                          //offset 1A ,sub_offset 2
	uint16_t 						rsvd3[2]; 		 // reserved //offset 1C ,sub_offset 4
	union  AQCTL_REG			AQCTL;                           //offset 20 ,sub_offset 2
	union  AQTSRCSEL_REG			AQTSRCSEL;                   //offset 22 ,sub_offset 2
	uint16_t 						rsvd4[2]; 		 // reserved //offset 24 ,sub_offset 4
	union  PCCTL_REG			PCCTL;                           //offset 28 ,sub_offset 2
	uint16_t 						rsvd5[3]; 		 // reserved //offset 2A ,sub_offset 6
	union  VCAPCTL_REG			VCAPCTL;                         //offset 30 ,sub_offset 2
	union  VCNTCFG_REG			VCNTCFG;                         //offset 32 ,sub_offset 2
	uint16_t 						rsvd6[6]; 		 // reserved //offset 34 ,sub_offset 12
	union  HRCNFG_REG			HRCNFG;                          //offset 40 ,sub_offset 2
	union  HRPWR_REG			HRPWR;                           //offset 42 ,sub_offset 2
	uint16_t 						rsvd7[4]; 		 // reserved //offset 44 ,sub_offset 8
	union  HRMSTEP_REG			HRMSTEP;                         //offset 4C ,sub_offset 2
	union  HRCNFG2_REG			HRCNFG2;                         //offset 4E ,sub_offset 2
	uint16_t 						rsvd8[5]; 		 // reserved //offset 50 ,sub_offset 10
	union  HRPCTL_REG			HRPCTL;                          //offset 5A ,sub_offset 2
	union  TRREM_REG			TRREM;                           //offset 5C ,sub_offset 2
	uint16_t 						rsvd9[5]; 		 // reserved //offset 5E ,sub_offset 10
	union  GLDCTL_REG			GLDCTL;                          //offset 68 ,sub_offset 2
	union  GLDCFG_REG			GLDCFG;                          //offset 6A ,sub_offset 2
	uint16_t 						rsvd10[2]; 		 // reserved //offset 6C ,sub_offset 4
	union  EPWMXLINK_REG			EPWMXLINK;                   //offset 70 ,sub_offset 4
	union  EPWMXLINK2_REG			EPWMXLINK2;	                 //offset 74 ,sub_offset 4
	union  EPWMXLINK3_REG			EPWMXLINK3;                  //offset 78 ,sub_offset 4
	uint16_t 						rsvd11[2];		 // reserved //offset 7C ,sub_offset 4
	union  AQCTLA_REG			AQCTLA;                          //offset 80 ,sub_offset 2
	union  AQCTLA2_REG			AQCTLA2;                         //offset 82 ,sub_offset 2
	union  AQCTLB_REG			AQCTLB;                          //offset 84 ,sub_offset 2
	union  AQCTLB2_REG			AQCTLB2;                         //offset 86 ,sub_offset 2
	uint16_t 						rsvd12[3]; 		 // reserved //offset 88 ,sub_offset 6
	union  AQSFRC_REG			AQSFRC;                          //offset 8E ,sub_offset 2
	uint16_t 						rsvd13; 		 // reserved //offset 90 ,sub_offset 2
	union  AQCSFRC_REG			AQCSFRC;                         //offset 92 ,sub_offset 2
	uint16_t 						rsvd14[6]; 		 // reserved //offset 94 ,sub_offset 12
	union  DBREDHR_REG			DBREDHR;                         //offset A0 ,sub_offset 2
	union  DBRED_REG			DBRED;                           //offset A2 ,sub_offset 2
	union  DBFEDHR_REG			DBFEDHR;                         //offset A4 ,sub_offset 2
	union  DBFED_REG			DBFED;                           //offset A6 ,sub_offset 2
	uint16_t 						rsvd15[12]; 		 // reserved //offset A8 ,sub_offset 24
	union  TBPHS_REG			TBPHS;                               //offset C0 ,sub_offset 4
	uint16_t					TBPRDHR;                             //offset C4 ,sub_offset 2
	uint16_t			        TBPRD;                               //offset C6 ,sub_offset 2
	uint16_t 						rsvd16; 		 // reserved     //offset C8 ,sub_offset 2
	uint16_t					CMPA1;                               //offset CA ,sub_offset 2
	uint16_t 						rsvd17; 		 // reserved     //offset CC ,sub_offset 2
	uint16_t					CMPB1;                               //offset CE ,sub_offset 2
	uint16_t 						rsvd18; 		 // reserved     //offset D0 ,sub_offset 2
	union  CMPSEL_REG			CMPSEL;                              //offset D2 ,sub_offset 2
	union  CMPA_REG			CMPA;                                    //offset D4 ,sub_offset 4
	union  CMPB_REG			CMPB;                                    //offset D8 ,sub_offset 4
	uint16_t 						rsvd19; 		 // reserved     //offset DC ,sub_offset 2
	uint16_t				CMPC;                                    //offset DE ,sub_offset 2
	uint16_t 						rsvd20; 		 // reserved     //offset E0 ,sub_offset 2
	uint16_t				CMPD;                                    //offset E2 ,sub_offset 2
	union  CMPRO_REG			CMPRO;                               //offset E4 ,sub_offset 4
	union  GLDCTL2_REG			GLDCTL2;                             //offset E8 ,sub_offset 2
	uint16_t 						rsvd21[2]; 		 // reserved     //offset EA ,sub_offset 4
	union  SWVDELVAL_REG			SWVDELVAL;                       //offset EE ,sub_offset 2
	uint16_t 						rsvd22[6]; 		 // reserved     //offset F0 ,sub_offset 12
	union  TZSEL2_REG			TZSEL2;                              //offset FC ,sub_offset 4
	union  TZSEL_REG			TZSEL;                               //offset 100 ,sub_offset 2
	uint16_t 						rsvd23; 		 // reserved     //offset 102 ,sub_offset 2
	union  TZDCSEL_REG			TZDCSEL;                             //offset 104 ,sub_offset 2
	uint16_t 						rsvd24; 		 // reserved     //offset 106 ,sub_offset 2
	union  TZCTL_REG			TZCTL;                               //offset 108 ,sub_offset 2
	union  TZCTL2_REG			TZCTL2;                              //offset 10A ,sub_offset 2
	union  TZCTLDCA_REG			TZCTLDCA;                            //offset 10C ,sub_offset 2
	union  TZCTLDCB_REG			TZCTLDCB;                            //offset 10E ,sub_offset 2
	uint16_t 						rsvd25[5]; 		 // reserved     //offset 110 ,sub_offset 10
	union  TZEINT_REG			TZEINT;                              //offset 11A ,sub_offset 2
	uint16_t 						rsvd26[2]; 		 // reserved     //offset 11C ,sub_offset 4
	union  TZEINT_CON_REG		TZEINT_CON;                          //offset 120 ,sub_offset 2
	union  TZFLG_CON_REG		TZEFLG_CON;                          //offset 122 ,sub_offset 2
	uint16_t 						rsvd27; 		 // reserved     //offset 124 ,sub_offset 2
	union  TZFLG_REG			TZFLG;                               //offset 126 ,sub_offset 2
	union  TZCBCFLG_REG			TZCBCFLG;                            //offset 128 ,sub_offset 2
	union  TZOSTFLG_REG			TZOSTFLG;                            //offset 12A ,sub_offset 2
	uint16_t 						rsvd28; 		 // reserved     //offset 12C ,sub_offset 2
	union  TZCLR_REG			TZCLR;                               //offset 12E ,sub_offset 2
	union  TZCBCCLR_REG			TZCBCCLR;                            //offset 130 ,sub_offset 2
	union  TZOSTCLR_REG			TZOSTCLR;                            //offset 132 ,sub_offset 2
	uint16_t 						rsvd29; 		 // reserved     //offset 134 ,sub_offset 2
	union  TZFRC_REG			TZFRC;                               //offset 136 ,sub_offset 2
	union  TZCLR2_REG			TZCLR2;                              //offset 138 ,sub_offset 2
	union  TZFLG2_REG			TZFLG2;                              //offset 13A ,sub_offset 2
	uint16_t 						rsvd30[6]; 		 // reserved     //offset 13C ,sub_offset 12
	union  ETSEL_REG			ETSEL;                               //offset 148 ,sub_offset 2
	uint16_t 						rsvd31; 		 // reserved     //offset 14A ,sub_offset 2
	union  ETPS_REG			ETPS;                                    //offset 14C ,sub_offset 2
	uint16_t 						rsvd32; 		 // reserved     //offset 14E ,sub_offset 2
	union  ETFLG_REG			ETFLG;                               //offset 150 ,sub_offset 2
	uint16_t 						rsvd33; 		 // reserved     //offset 152 ,sub_offset 2
	union  ETCLR_REG			ETCLR;                               //offset 154 ,sub_offset 2
	uint16_t 						rsvd34; 		 // reserved     //offset 156 ,sub_offset 2
	union  ETFRC_REG			ETFRC;                               //offset 158 ,sub_offset 2
	uint16_t 						rsvd35; 		 // reserved     //offset 15A ,sub_offset 2
	union  ETINTPS_REG			ETINTPS;                             //offset 15C ,sub_offset 2
	uint16_t 						rsvd36; 		 // reserved     //offset 15E ,sub_offset 2
	union  ETSOCPS_REG			ETSOCPS;                             //offset 160 ,sub_offset 2
	uint16_t 						rsvd37; 		 // reserved     //offset 162 ,sub_offset 2
	union  ETCNTINITCTL_REG			ETCNTINITCTL;                    //offset 164 ,sub_offset 2
	uint16_t 						rsvd38; 		 // reserved     //offset 166 ,sub_offset 2
	union  ETCNTINIT_REG			ETCNTINIT;                       //offset 168 ,sub_offset 2
	uint16_t 						rsvd39[11]; 		 // reserved //offset 16A ,sub_offset 22
	union  DCTRIPSEL_REG			DCTRIPSEL;                       //offset 180 ,sub_offset 2
	union  DCTRIPSELEXP_REG			DCTRIPSELEXP;                    //offset 182 ,sub_offset 2
	uint16_t 						rsvd40; 		 // reserved     //offset 184 ,sub_offset 2
	union  DCACTL_REG			    DCACTL;                          //offset 186 ,sub_offset 2
	union  DCBCTL_REG			    DCBCTL;                          //offset 188 ,sub_offset 2
	uint16_t 						rsvd41[2]; 		 // reserved     //offset 18A ,sub_offset 4
	union  DCFCTL_REG			    DCFCTL;                          //offset 18E ,sub_offset 2
	union  DCCAPCTL_REG			    DCCAPCTL;                        //offset 190 ,sub_offset 2
	uint16_t						DCFOFFSET;                       //offset 192 ,sub_offset 2
	uint16_t						DCFOFFSETCNT;                    //offset 194 ,sub_offset 2
	uint16_t						DCFWINDOW;                       //offset 196 ,sub_offset 2
	uint16_t						DCFWINDOWCNT;                    //offset 198 ,sub_offset 2
	union  BLANKPULSEMIXSEL_REG			BLANKPULSEMIXSEL;            //offset 19A ,sub_offset 2
	uint16_t 						rsvd42; 		 // reserved     //offset 19C ,sub_offset 2
	uint16_t					    DCCAP;                           //offset 19E ,sub_offset 2
	uint16_t 						rsvd43[2]; 		 // reserved     //offset 1A0 ,sub_offset 4
	union  DCAHTRIPSEL_REG			DCAHTRIPSEL;                     //offset 1A4 ,sub_offset 2
	union  DCALTRIPSEL_REG			DCALTRIPSEL;                     //offset 1A6 ,sub_offset 2
	union  DCBHTRIPSEL_REG			DCBHTRIPSEL;                     //offset 1A8 ,sub_offset 2
	union  DCBLTRIPSEL_REG			DCBLTRIPSEL;                     //offset 1AA ,sub_offset 2
	uint16_t 						rsvd44[39]; 		 // reserved //offset 1AC ,sub_offset 78
	uint16_t						HWVDELVAL;                       //offset 1FA ,sub_offset 2
	uint16_t					    VCNTVAL;                         //offset 1FC ,sub_offset 2
};

struct EPWM_EXTEND_REGS {
	//uint16_t 						rsvd45[255]; 		 // reserved //offset 1FE ,sub_offset 510
	union  EPWM_REGS_LOCK_REG		EPWM_REGS_LOCK;					 //offset 3FC ,sub_offset 4
	union  EPWM_TBCTR_CHG_REG		EPWM_TBCTR_CHG;					 //offset 400 ,sub_offset 4
	union  ETSELEXP_REG				ETSELEXP;					 	 //offset 404 ,sub_offset 4
	union  EPWM_EN_REG				EPWM_EN;					 	 //offset 408 ,sub_offset 4
	uint16_t 						rsvd46[6]; 			 // reserved //offset 40C ,sub_offset 12
	union  DCTRIPSEL_1DCAL_REG		DCTRIPSEL_1DCAL;				 //offset 418 ,sub_offset 4
	union  DCTRIPSEL_2DCAL_REG		DCTRIPSEL_2DCAL;				 //offset 41C ,sub_offset 4
	union  DCTRIPSEL_3DCAL_REG		DCTRIPSEL_3DCAL;				 //offset 420 ,sub_offset 4
	union  DCTRIPSEL_1DCAH_REG		DCTRIPSEL_1DCAH;				 //offset 424 ,sub_offset 4
	union  DCTRIPSEL_2DCAH_REG		DCTRIPSEL_2DCAH;				 //offset 428 ,sub_offset 4
	union  DCTRIPSEL_3DCAH_REG		DCTRIPSEL_3DCAH;				 //offset 42C ,sub_offset 4
	union  DCTRIPSEL_1DCBL_REG		DCTRIPSEL_1DCBL;				 //offset 430 ,sub_offset 4
	union  DCTRIPSEL_2DCBL_REG		DCTRIPSEL_2DCBL;				 //offset 434 ,sub_offset 4
	union  DCTRIPSEL_3DCBL_REG		DCTRIPSEL_3DCBL;				 //offset 438 ,sub_offset 4
	union  DCTRIPSEL_1DCBH_REG		DCTRIPSEL_1DCBH;				 //offset 43C ,sub_offset 4
	union  DCTRIPSEL_2DCBH_REG		DCTRIPSEL_2DCBH;				 //offset 440 ,sub_offset 4
	union  DCTRIPSEL_3DCBH_REG		DCTRIPSEL_3DCBH;				 //offset 444 ,sub_offset 4
	union  TZ_CLR_MODE_REG			TZ_CLR_MODE;					 //offset 448 ,sub_offset 4
	union  TZ_CLR_ARM_REG			TZ_CLR_ARM;						 //offset 44C ,sub_offset 4
	union  TZ_CLR_DSP_REG			TZ_CLR_DSP;						 //offset 450 ,sub_offset 4
	union  TZFRC_ARM_REG			TZFRC_ARM;						 //offset 454 ,sub_offset 2
	uint16_t 						rsvd47; 		 	 // reserved //offset 456 ,sub_offset 2
	union  TZFRC_DSP_REG			TZFRC_DSP;						 //offset 458 ,sub_offset 2
	uint16_t 						rsvd48; 		 	 // reserved //offset 45A ,sub_offset 2
	union  HRPWM_CTRL_REG			HRPWM_CTRL;						 //offset 45C ,sub_offset 2
	uint16_t 						rsvd49; 		 	 // reserved //offset 45E ,sub_offset 2
	union  DCTRIPSEL2_1DCAL_REG		DCTRIPSEL2_1DCAL;				 //offset 460 ,sub_offset 4
	union  DCTRIPSEL2_2DCAL_REG		DCTRIPSEL2_2DCAL;				 //offset 464 ,sub_offset 4
	union  DCTRIPSEL2_3DCAL_REG		DCTRIPSEL2_3DCAL;				 //offset 468 ,sub_offset 4
	union  DCTRIPSEL2_1DCAH_REG		DCTRIPSEL2_1DCAH;				 //offset 46C ,sub_offset 4
	union  DCTRIPSEL2_2DCAH_REG		DCTRIPSEL2_2DCAH;				 //offset 470 ,sub_offset 4
	union  DCTRIPSEL2_3DCAH_REG		DCTRIPSEL2_3DCAH;				 //offset 474 ,sub_offset 4
	union  DCTRIPSEL2_1DCBL_REG		DCTRIPSEL2_1DCBL;				 //offset 478 ,sub_offset 4
	union  DCTRIPSEL2_2DCBL_REG		DCTRIPSEL2_2DCBL;				 //offset 47C ,sub_offset 4
	union  DCTRIPSEL2_3DCBL_REG		DCTRIPSEL2_3DCBL;				 //offset 480 ,sub_offset 4
	union  DCTRIPSEL2_1DCBH_REG		DCTRIPSEL2_1DCBH;				 //offset 484 ,sub_offset 4
	union  DCTRIPSEL2_2DCBH_REG		DCTRIPSEL2_2DCBH;				 //offset 488 ,sub_offset 4
	union  DCTRIPSEL2_3DCBH_REG		DCTRIPSEL2_3DCBH;				 //offset 48C ,sub_offset 4
	uint16_t 						rsvd50[2]; 		 	 // reserved //offset 490 ,sub_offset 4
	union  XCMP_EN_REG				XCMP_EN;						 //offset 494 ,sub_offset 4
	union  XCMP_SEL_REG				XCMP_SEL;						 //offset 498 ,sub_offset 4
	uint16_t 						rsvd51[2]; 		 	 // reserved //offset 49C ,sub_offset 4
	union  XCMP_PERIOD_REG			XCMP_PERIOD;					 //offset 4A0 ,sub_offset 4
	union  XCMP_PERIOD2_REG			XCMP_PERIOD2;					 //offset 4A4 ,sub_offset 4
	union  XCMP_UPDATE_REG			XCMP_UPDATE;					 //offset 4A8 ,sub_offset 4
	union  GLDCFG2_REG				GLDCFG2;						 //offset 4AC ,sub_offset 2
	uint16_t 						rsvd52; 		 	 // reserved //offset 4AE ,sub_offset 2
	union  DCTRIPSEL2_DCAL_REG		DCTRIPSEL2_DCAL;				 //offset 4B0 ,sub_offset 4
	union  DCTRIPSEL2_DCAH_REG		DCTRIPSEL2_DCAH;				 //offset 4B4 ,sub_offset 4
	union  DCTRIPSEL2_DCBL_REG		DCTRIPSEL2_DCBL;				 //offset 4B8 ,sub_offset 4
	union  DCTRIPSEL2_DCBH_REG		DCTRIPSEL2_DCBH;				 //offset 4BC ,sub_offset 4
	union  HRPWM_INT_REG			HRPWM_INT;						 //offset 4C0 ,sub_offset 4
	uint16_t 						rsvd53[30]; 		 // reserved //offset 4C4 ,sub_offset 60
	uint16_t						TBPRD_XCMP;						 //offset 500 ,sub_offset 2
	uint16_t 						rsvd54[15]; 			 // reserved //offset 502 ,sub_offset 30
	uint16_t						CMPA_XCMP;						 //offset 520 ,sub_offset 2
	uint16_t 						rsvd55[15]; 			 // reserved //offset 522 ,sub_offset 30
	uint16_t						CMPB_XCMP;						 //offset 540 ,sub_offset 2
	uint16_t 						rsvd56[15]; 			 // reserved //offset 542 ,sub_offset 30
	uint16_t						CMPC_XCMP;						 //offset 560 ,sub_offset 2
	uint16_t 						rsvd57[15]; 			 // reserved //offset 562 ,sub_offset 30
	uint16_t						CMPD_XCMP;						 //offset 580 ,sub_offset 2
	uint16_t 						rsvd58[15]; 			 // reserved //offset 582 ,sub_offset 30
	uint16_t						CMPA1_XCMP;						 //offset 5A0 ,sub_offset 2
	uint16_t 						rsvd59[15]; 			 // reserved //offset 5A2 ,sub_offset 30
	uint16_t						CMPB1_XCMP;						 //offset 5C0 ,sub_offset 2
};



struct EPWM_TOP_REGS {
	union  SYNCSELECT_TOP_REG		SYNCSELECT_TOP;				//offset 0 ,sub_offset 4
	union  ADCSOCOUTSELECT_TOP_REG	ADCSOCOUTSELECT_TOP;		//offset 4 ,sub_offset 4
	union  ADCSOCOUTSELECT1_TOP_REG	ADCSOCOUTSELECT1_TOP;		//offset 8 ,sub_offset 4
	uint16_t 						rsvd1[26]; 		 // reserved //offset C ,sub_offset 52
	union  TRANS_MODE_REG			TRANS_MODE_1;				//offset 40 ,sub_offset 4
	union  PERIOD_REG				PERIOD_1;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_1;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_1;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_1;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_1;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_1;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_1;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_1;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_1;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_1;				//offset 68 ,sub_offset 4
	uint16_t 						rsvd2[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_2;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_2;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_2;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_2;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_2;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_2;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_2;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_2;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_2;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_2;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_2;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd3[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_3;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_3;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_3;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_3;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_3;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_3;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_3;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_3;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_3;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_3;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_3;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd4[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_4;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_4;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_4;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_4;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_4;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_4;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_4;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_4;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_4;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_4;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_4;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd5[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_5;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_5;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_5;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_5;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_5;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_5;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_5;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_5;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_5;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_5;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_5;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd6[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_6;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_6;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_6;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_6;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_6;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_6;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_6;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_6;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_6;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_6;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_6;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd7[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_7;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_7;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_7;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_7;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_7;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_7;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_7;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_7;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_7;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_7;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_7;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd8[10]; 		 // reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_8;				//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_8;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_8;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_8;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_8;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_8;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_8;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_8;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_8;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_8;			//offset 64 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_8;				//offset 68 ,sub_offset 4

	uint16_t 						rsvd9[10]; 		 // reserved //offset 22C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_9;				//offset 240 ,sub_offset 4
	union  PERIOD_REG				PERIOD_9;					//offset 244 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_9;				//offset 248 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_9;				//offset 24C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_9;			//offset 250 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_9;			//offset 254 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_9;			//offset 258 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_9;			//offset 25C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_9;				//offset 260 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_9;			//offset 264 ,sub_offset 4
	union  AQCSFRC_REG				AQCSFRC_9;				//offset 268 ,sub_offset 4

	uint16_t 						rsvd10[72]; 		 // reserved //offset 26C ,sub_offset 144
	uint32_t						EPWM_TOP_REGS_LOCK;		//offset 2FC ,sub_offset 4
	uint16_t 						rsvd11[6]; 		 // reserved //offset 300 ,sub_offset 12
	union  EPWM_MUX_SEL_REG			EPWM_MUX_SEL;			//offset 30C ,sub_offset 4
	uint16_t 						rsvd12[2]; 		 // reserved //offset 310 ,sub_offset 4
	union  TZ_INV_CFG_REG			TZ_INV_CFG;				//offset 314 ,sub_offset 4
	union  TRIPIN_INV_CFG_REG		TRIPIN_INV_CFG;			//offset 318 ,sub_offset 4
	union  PWM_HALT_EN_REG			PWM_HALT_EN;			//offset 31C ,sub_offset 4
	union  HRPWM_CYCLE_NUM_REG		HRPWM_CYCLE_NUM;		//offset 320 ,sub_offset 4
	uint16_t 						rsvd13[6]; 		 // reserved //offset 324 ,sub_offset 12
	uint32_t						HRPWM_0CFG;				//offset 330 ,sub_offset 4
};

#elif(EPWM_VERSION==12)
struct EPWM_TOP_REGS {

	union  SYNCSELECT_TOP_REG		SYNCSELECT_TOP;				//offset 0 ,sub_offset 4
	union  ADCSOCOUTSELECT_TOP_REG	ADCSOCOUTSELECT_TOP;	//offset 4 ,sub_offset 4
	uint16_t 						rsvd1[28]; 		 // Reserved //offset 8 ,sub_offset 56
	union  TRANS_MODE_REG			TRANS_MODE_1;			//offset 40 ,sub_offset 4
	union  PERIOD_REG				PERIOD_1;				//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_1;			//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_1;			//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_1;			//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_1;			//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_1;			//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_1;			//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_1;			//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_1;		//offset 64 ,sub_offset 4
	union  AQCSFRC_TOP_REG			AQCSFRC_1;				//offset 68 ,sub_offset 4
	uint16_t 						rsvd2[10]; 		 // Reserved //offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_2;			//offset 80 ,sub_offset 4
	union  PERIOD_REG				PERIOD_2;				//offset 84 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_2;			//offset 88 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_2;			//offset 8C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_2;			//offset 90 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_2;			//offset 94 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_2;			//offset 98 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_2;			//offset 9C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_2;			//offset a0 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_2;		//offset a4 ,sub_offset 4
	union  AQCSFRC_TOP_REG			AQCSFRC_2;				//offset a8 ,sub_offset 4
	uint16_t 						rsvd3[10]; 		 // Reserved //offset aC ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_3;			//offset C0 ,sub_offset 4
	union  PERIOD_REG				PERIOD_3;				//offset C4 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_3;			//offset C8 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_3;			//offset CC ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_3;			//offset D0 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_3;			//offset D4 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_3;			//offset D8 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_3;			//offset DC ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_3;			//offset E0 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_3;		//offset E4 ,sub_offset 4
	union  AQCSFRC_TOP_REG			AQCSFRC_3;				//offset E8 ,sub_offset 4
	uint16_t 						rsvd4[10]; 		 // Reserved //offset EC ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_4;			//offset 100 ,sub_offset 4
	union  PERIOD_REG				PERIOD_4;				//offset 104 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_4;			//offset 108 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_4;			//offset 10C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_4;			//offset 110 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_4;			//offset 114 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_4;			//offset 118 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_4;			//offset 11C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_4;			//offset 120 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_4;		//offset 12C ,sub_offset 4
	union  AQCSFRC_TOP_REG			AQCSFRC_4;				//offset 128 ,sub_offset 4
	uint16_t 						rsvd5[10]; 		 // Reserved //offset 12C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_5;
	union  PERIOD_REG				PERIOD_5;
	union  DUTYCYCLE1_REG			DUTYCYCLE1_5;
	union  DUTYCYCLE2_REG			DUTYCYCLE2_5;
	union  DEADZONE_A1_REG			DEADZONE_A1_5;
	union  DEADZONE_B1_REG			DEADZONE_B1_5;
	union  DEADZONE_A2_REG			DEADZONE_A2_5;
	union  DEADZONE_B2_REG			DEADZONE_B2_5;
	union  PHASESHIFT_REG			PHASESHIFT_5;
	union  PHASESHIFT_INI_REG			PHASESHIFT_INI_5;
	union  AQCSFRC_TOP_REG			AQCSFRC_5;
	uint16_t 						rsvd6[10]; 		 // Reserved
	union  TRANS_MODE_REG			TRANS_MODE_6;
	union  PERIOD_REG				PERIOD_6;
	union  DUTYCYCLE1_REG			DUTYCYCLE1_6;
	union  DUTYCYCLE2_REG			DUTYCYCLE2_6;
	union  DEADZONE_A1_REG			DEADZONE_A1_6;
	union  DEADZONE_B1_REG			DEADZONE_B1_6;
	union  DEADZONE_A2_REG			DEADZONE_A2_6;
	union  DEADZONE_B2_REG			DEADZONE_B2_6;
	union  PHASESHIFT_REG			PHASESHIFT_6;
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_6;
	union  AQCSFRC_TOP_REG			AQCSFRC_6;				//offset 1A8 ,sub_offset 4
	uint16_t 						rsvd7[168]; 		 // Reserved //offset 1AC ,sub_offset 336
	uint32_t			 		  	EPWM_TOP_REGS_LOCK;		//offset 2FC ,sub_offset 4
	uint16_t 						rsvd8[6]; 		 // Reserved //offset 300 ,sub_offset 12
	union  EPWM_MUX_SEL_REG			EPWM_MUX_SEL;			//offset 30C ,sub_offset 4
	uint16_t 						rsvd9[2]; 		 	 // Reserved //offset 310 ,sub_offset 4
	union  TZ_INV_CFG_REG			TZ_INV_CFG;				//offset 314 ,sub_offset 4
	union  TRIPIN_INV_CFG_REG		TRIPIN_INV_CFG;			//offset 318 ,sub_offset 4
	union  PWM_HALT_EN_REG			PWM_HALT_EN;			//offset 31C ,sub_offset 4
	uint16_t 						rsvd10[8]; 		 // Reserved //offset 320 ,sub_offset 16
	uint32_t			 			HRPWM_0CFG;				//offset 330 ,sub_offset 4
	uint32_t			   			HRPWM_1CFG;				//offset 334 ,sub_offset 4
	union  DLL_LOCKFLAG_REG			DLL_LOCKFLAG;			//offset 338 ,sub_offset 4
	union  HRPWM_BYPASS_REG			HRPWM_BYPASS;			//offset 33C ,sub_offset 4
};

struct EPWM_REGS {
	union  TBCTL_REG			TBCTL;						//offset 0 ,sub_offset 2
	union  TBCTL2_REG			TBCTL2;						//offset 2 ,sub_offset 2
	uint16_t 					rsvd1; 		 // Reserved //offset 4 ,sub_offset 2
	union  EPWMSYNCINSEL_REG	EPWMSYNCINSEL;				//offset 6 ,sub_offset 2
	uint16_t 		 					TBCTR;						//offset 8 ,sub_offset 2
	union  TBSTS_REG			TBSTS;						//offset A ,sub_offset 2
	union  EPWMSYNCOUTEN_REG	EPWMSYNCOUTEN;				//offset C ,sub_offset 2
	union  TBCTL3_REG			TBCTL3;						//offset E ,sub_offset 2
	union  CMPCTL_REG			CMPCTL;						//offset 10 ,sub_offset 2
	union  CMPCTL2_REG			CMPCTL2;					//offset 12 ,sub_offset 2
	union  CMPCTL3_REG			CMPCTL3;					//offset 14 ,sub_offset 2
	uint16_t 					rsvd2; 		 // Reserved //offset 16 ,sub_offset 2
	union  DBCTL_REG			DBCTL;						//offset 18 ,sub_offset 2
	union  DBCTL2_REG			DBCTL2;						//offset 1A ,sub_offset 2
	uint16_t 					rsvd3[2]; 		 // Reserved //offset 1C ,sub_offset 4
	union  AQCTL_REG			AQCTL;						//offset 20 ,sub_offset 2
	union  AQTSRCSEL_REG		AQTSRCSEL;					//offset 22 ,sub_offset 2
	uint16_t 					rsvd4[2]; 		 // Reserved //offset 24 ,sub_offset 4
	union  PCCTL_REG			PCCTL;						//offset 28 ,sub_offset 2
	uint16_t 					rsvd5[3]; 		 // Reserved //offset 2A ,sub_offset 6
	union  VCAPCTL_REG			VCAPCTL;					//offset 30 ,sub_offset 2
	union  VCNTCFG_REG			VCNTCFG;					//offset 32 ,sub_offset 2
	uint16_t 					rsvd6[6]; 		 // Reserved//offset 34 ,sub_offset 12
	union  HRCNFG_REG			HRCNFG;						//offset 40 ,sub_offset 2
	union  HRPWR_REG			HRPWR;						//offset 42 ,sub_offset 2
	uint16_t 					rsvd7[4]; 		 // Reserved //offset 44 ,sub_offset 8
	union  HRMSTEP_REG			HRMSTEP;					//offset 4C ,sub_offset 2
	union  HRCNFG2_REG			HRCNFG2;					//offset 4E ,sub_offset 2
	uint16_t 					rsvd8[5]; 		 // Reserved //offset 50 ,sub_offset 10
	union  HRPCTL_REG			HRPCTL;						//offset 5A ,sub_offset 2
	union  TRREM_REG			TRREM;						//offset 5C ,sub_offset 2
	uint16_t 					rsvd9[5]; 		 // Reserved //offset 5E ,sub_offset 10
	union  GLDCTL_REG			GLDCTL;						//offset 68 ,sub_offset 2
	union  GLDCFG_REG			GLDCFG;						//offset 6A ,sub_offset 2
	uint16_t 					rsvd10[2]; 		 // Reserved //offset 6C ,sub_offset 4
	union  EPWMXLINK_REG		EPWMXLINK;					//offset 70 ,sub_offset 4
	uint16_t 					rsvd11[2]; 		 // Reserved//offset 74 ,sub_offset 4
	union  EPWMXLINK3_REG		EPWMXLINK3;					//offset 78 ,sub_offset 4
	uint16_t 					rsvd12[2]; 		 // Reserved//offset 7C ,sub_offset 4
	union  AQCTLA_REG			AQCTLA;						//offset 80 ,sub_offset 2
	union  AQCTLA2_REG			AQCTLA2;					//offset 82 ,sub_offset 2
	union  AQCTLB_REG			AQCTLB;						//offset 84 ,sub_offset 2
	union  AQCTLB2_REG			AQCTLB2;					//offset 86 ,sub_offset 2
	uint16_t 					rsvd13[3]; 		 // Reserved //offset 88 ,sub_offset 6
	union  AQSFRC_REG			AQSFRC;						//offset 8E ,sub_offset 2
	uint16_t 					rsvd14; 		 // Reserved //offset 90 ,sub_offset 2
	union  AQCSFRC_REG			AQCSFRC;					//offset 92 ,sub_offset 2
	uint16_t 					rsvd15[6]; 		 // Reserved //offset 94 ,sub_offset 12
	union  DBREDHR_REG			DBREDHR;					//offset A0 ,sub_offset 2
	union  DBRED_REG			DBRED;						//offset A2 ,sub_offset 2
	union  DBFEDHR_REG			DBFEDHR;					//offset A4 ,sub_offset 2
	union  DBFED_REG			DBFED;						//offset A6 ,sub_offset 2
	uint16_t 					rsvd16[12]; 		 // Reserved //offset A8 ,sub_offset 24
	union  TBPHS_REG			TBPHS;						//offset C0 ,sub_offset 4
	uint16_t 					TBPRDHR;					//offset C4 ,sub_offset 2
	uint16_t 					TBPRD;						//offset C6 ,sub_offset 2
	uint16_t 					rsvd17; 		 // Reserved //offset C8 ,sub_offset 2
	uint16_t 					CMPA1;						//offset CA ,sub_offset 2
	uint16_t 					rsvd18; 		 // Reserved //offset CC ,sub_offset 2
	uint16_t 					CMPB1;						//offset CE ,sub_offset 2
	uint16_t 					rsvd19; 		 // Reserved //offset D0 ,sub_offset 2
	union  CMPSEL_REG			CMPSEL;						//offset D2 ,sub_offset 2
	union  CMPA_REG				CMPA;						//offset D4 ,sub_offset 4
	union  CMPB_REG				CMPB;						//offset D8 ,sub_offset 4
	uint16_t 					rsvd20; 		 // reserved //offset DC ,sub_offset 2
	uint16_t 					CMPC;						//offset DE ,sub_offset 2
	uint16_t 					rsvd21; 		 // Reserved //offset E0 ,sub_offset 2
	uint16_t 					CMPD;						//offset E2 ,sub_offset 2
	union  CMPRO_REG			CMPRO;						//offset E4 ,sub_offset 4
	union  GLDCTL2_REG			GLDCTL2;					//offset E8 ,sub_offset 2
	uint16_t 					rsvd22[2]; 		 // Reserved //offset EA ,sub_offset 4
	uint16_t 						SWVDELVAL;					//offset EE ,sub_offset 2
	uint16_t 					rsvd23[6]; 		 // Reserved //offset F0 ,sub_offset 12
	union  TZSEL2_REG			TZSEL2;						//offset FC ,sub_offset 4
	union  TZSEL_REG			TZSEL;						//offset 100 ,sub_offset 2
	uint16_t 					rsvd24; 		 // Reserved //offset 102 ,sub_offset 2
	union  TZDCSEL_REG			TZDCSEL;					//offset 104 ,sub_offset 2
	uint16_t 					rsvd25; 		 // Reserved //offset 106 ,sub_offset 2
	union  TZCTL_REG			TZCTL;						//offset 108 ,sub_offset 2
	union  TZCTL2_REG			TZCTL2;						//offset 10A ,sub_offset 2
	union  TZCTLDCA_REG			TZCTLDCA;					//offset 10C ,sub_offset 2
	union  TZCTLDCB_REG			TZCTLDCB;					//offset 10E ,sub_offset 2
	uint16_t 					rsvd26[5]; 		 // Reserved	//offset 110 ,sub_offset 10
	union  TZEINT_REG			TZEINT;						//offset 11A ,sub_offset 2
	uint16_t 					rsvd27[2]; 		 // Reserved	//offset 11C ,sub_offset 4
	union  TZEINT_CON_REG		TZEINT_CON;					//offset 120 ,sub_offset 2
	union  TZFLG_CON_REG		TZFLG_CON;					//offset 122 ,sub_offset 2
	uint16_t 					rsvd28; 		 // Reserved	//offset 124 ,sub_offset 2
	union  TZFLG_REG			TZFLG;						//offset 126 ,sub_offset 2
	union  TZCBCFLG_REG			TZCBCFLG;					//offset 128 ,sub_offset 2
	union  TZOSTFLG_REG			TZOSTFLG;					//offset 12A ,sub_offset 2
	uint16_t 					rsvd29; 		 // Reserved	//offset 12C ,sub_offset 2
	union  TZCLR_REG			TZCLR;						//offset 12E ,sub_offset 2
	union  TZCBCCLR_REG			TZCBCCLR;					//offset 130 ,sub_offset 2
	union  TZOSTCLR_REG			TZOSTCLR;					//offset 132 ,sub_offset 2
	uint16_t 					rsvd30; 		 // Reserved	//offset 134 ,sub_offset 2
	union  TZFRC_REG			TZFRC;						//offset 136 ,sub_offset 2
	union  TZCLR2_REG			TZCLR2;						//offset 138 ,sub_offset 2
	union  TZFLG2_REG			TZFLG2;						//offset 13A ,sub_offset 2
	uint16_t 					rsvd31[6]; 		 // Reserved	//offset 13C ,sub_offset 12
	union  ETSEL_REG			ETSEL;						//offset 148 ,sub_offset 2
	uint16_t 					rsvd32; 		 // Reserved	//offset 14A ,sub_offset 2
	union  ETPS_REG				ETPS;						//offset 14C ,sub_offset 2
	uint16_t 					rsvd33; 		 // Reserved	//offset 14E ,sub_offset 2
	union  ETFLG_REG			ETFLG;						//offset 150 ,sub_offset 2
	uint16_t 					rsvd34; 		 // Reserved	//offset 152 ,sub_offset 2
	union  ETCLR_REG			ETCLR;						//offset 154 ,sub_offset 2
	uint16_t 					rsvd35; 		 // Reserved	//offset 156 ,sub_offset 2
	union  ETFRC_REG			ETFRC;						//offset 158 ,sub_offset 2
	uint16_t 					rsvd36; 		 // Reserved	//offset 15A ,sub_offset 2
	union  ETINTPS_REG			ETINTPS;					//offset 15C ,sub_offset 2
	uint16_t 					rsvd37; 		 // Reserved	//offset 15E ,sub_offset 2
	union  ETSOCPS_REG			ETSOCPS;					//offset 160 ,sub_offset 2
	uint16_t 					rsvd38; 		 // Reserved	//offset 162 ,sub_offset 2
	union  ETCNTINITCTL_REG		ETCNTINITCTL;				//offset 164 ,sub_offset 2
	uint16_t 					rsvd39; 		 // Reserved	//offset 166 ,sub_offset 2
	union  ETCNTINIT_REG		ETCNTINIT;					//offset 168 ,sub_offset 2
	uint16_t 					rsvd40[11];		 // Reserved	//offset 16A ,sub_offset 22
	union  DCTRIPSEL_REG		DCTRIPSEL;					//offset 180 ,sub_offset 2
	union  DCTRIPSELEXP_REG		DCTRIPSELEXP;				//offset 182 ,sub_offset 2
	uint16_t 					rsvd41; 		 // Reserved	//offset 184 ,sub_offset 2
	union  DCACTL_REG			DCACTL;						//offset 186 ,sub_offset 2
	union  DCBCTL_REG			DCBCTL;						//offset 188 ,sub_offset 2
	uint16_t 					rsvd42[2]; 		 // Reserved	//offset 18A ,sub_offset 4
	union  DCFCTL_REG			DCFCTL;						//offset 18E ,sub_offset 2
	union  DCCAPCTL_REG			DCCAPCTL;					//offset 190 ,sub_offset 2
	uint16_t 					DCFOFFSET;					//offset 192 ,sub_offset 2
	uint16_t 					DCFOFFSETCNT;				//offset 194 ,sub_offset 2
	uint16_t 					DCFWINDOW;					//offset 196 ,sub_offset 2
	uint16_t 					DCFWINDOWCNT;				//offset 198 ,sub_offset 2
	union  BLANKPULSEMIXSEL_REG	BLANKPULSEMIXSEL;	//offset 19A ,sub_offset 2
	uint16_t 					rsvd43; 		 // Reserved	//offset 19C ,sub_offset 2
	uint16_t 					DCCAP;						//offset 19E ,sub_offset 2
	uint16_t 					rsvd44[2]; 		 // Reserved	//offset 1A0 ,sub_offset 4
	union  DCAHTRIPSEL_REG		DCAHTRIPSEL;				//offset 1A4 ,sub_offset 2
	union  DCALTRIPSEL_REG		DCALTRIPSEL;				//offset 1A6 ,sub_offset 2
	union  DCBHTRIPSEL_REG		DCBHTRIPSEL;				//offset 1A8 ,sub_offset 2
	union  DCBLTRIPSEL_REG		DCBLTRIPSEL;				//offset 1AA ,sub_offset 2
	uint16_t 					rsvd45[39]; 		 // Reserved	//offset 1AC ,sub_offset 78
	uint16_t 					HWVDELVAL;					//offset 1FA ,sub_offset 2
	uint16_t 					VCNTVAL;					//offset 1FC ,sub_offset 2
};

struct	EPWM_EXTEND_REGS{
	//uint16_t 					rsvd46[255]; 		 // Reserved	//offset 1FE ,sub_offset 510
	union  EPWM_REGS_LOCK_REG  	EPWM_REGS_LOCK;				//offset 3FC ,sub_offset 4
	union  EPWM_TBCTR_CHG_REG	EPWM_TBCTR_CHG;				//offset 400 ,sub_offset 4
	union  ETSELEXP_REG			ETSELEXP;					//offset 404 ,sub_offset 4
	union  EPWM_EN_REG			EPWM_EN;					//offset 408 ,sub_offset 4
	uint16_t 						rsvd47[2]; 		 // Reserved	//offset 40C ,sub_offset 4
	union  DCTRIPSEL2_DCAL_REG			DCTRIPSEL2_DCAL;	//offset 410 ,sub_offset 2
	union  DCTRIPSEL2_DCAH_REG			DCTRIPSEL2_DCAH;	//offset 412 ,sub_offset 2
	union  DCTRIPSEL2_DCBL_REG			DCTRIPSEL2_DCBL;	//offset 414 ,sub_offset 2
	union  DCTRIPSEL2_DCBH_REG			DCTRIPSEL2_DCBH;	//offset 416 ,sub_offset 2
	union  DCTRIPSEL_1DCAL_REG			DCTRIPSEL_1DCAL;	//offset 418 ,sub_offset 4
	union  DCTRIPSEL_2DCAL_REG			DCTRIPSEL_2DCAL;	//offset 41C ,sub_offset 4
	union  DCTRIPSEL_3DCAL_REG			DCTRIPSEL_3DCAL;	//offset 420 ,sub_offset 4
	union  DCTRIPSEL_1DCAH_REG			DCTRIPSEL_1DCAH;	//offset 424 ,sub_offset 4
	union  DCTRIPSEL_2DCAH_REG			DCTRIPSEL_2DCAH;	//offset 428 ,sub_offset 4
	union  DCTRIPSEL_3DCAH_REG			DCTRIPSEL_3DCAH;	//offset 42C ,sub_offset 4
	union  DCTRIPSEL_1DCBL_REG			DCTRIPSEL_1DCBL;	//offset 430 ,sub_offset 4
	union  DCTRIPSEL_2DCBL_REG			DCTRIPSEL_2DCBL;	//offset 434 ,sub_offset 4
	union  DCTRIPSEL_3DCBL_REG			DCTRIPSEL_3DCBL;	//offset 438 ,sub_offset 4
	union  DCTRIPSEL_1DCBH_REG			DCTRIPSEL_1DCBH;	//offset 43C ,sub_offset 4
	union  DCTRIPSEL_2DCBH_REG			DCTRIPSEL_2DCBH;	//offset 440 ,sub_offset 4
	union  DCTRIPSEL_3DCBH_REG			DCTRIPSEL_3DCBH;	//offset 444 ,sub_offset 4
	union  TZ_CLR_MODE_REG			TZ_CLR_MODE;			//offset 448 ,sub_offset 4
	union  TZ_CLR_ARM_REG			TZ_CLR_ARM;				//offset 44C ,sub_offset 4
	union  TZ_CLR_DSP_REG			TZ_CLR_DSP;				//offset 450 ,sub_offset 4
	union  TZFRC_ARM_REG			TZFRC_ARM;				//offset 454 ,sub_offset 2
	uint16_t 						rsvd48; 		 // Reserved	//offset 456 ,sub_offset 2
	union  TZFRC_DSP_REG			TZFRC_DSP;				//offset 458 ,sub_offset 2
	uint16_t 						rsvd49; 		 // Reserved	//offset 45A ,sub_offset 2
	union  HRPWM_CTRL_REG			HRPWM_CTRL;				//offset 45C ,sub_offset 2
	uint16_t 						rsvd50[27]; 		 // Reserved	//offset 45E ,sub_offset 54
	union  XCMP_EN_REG				XCMP_EN;				//offset 494 ,sub_offset 4
	union  XCMP_SEL_REG				XCMP_SEL;				//offset 498 ,sub_offset 4
	uint16_t 						rsvd51[2]; 		 // Reserved	//offset 49C ,sub_offset 4
	union  XCMP_PERIOD_REG			XCMP_PERIOD;			//offset 4A0 ,sub_offset 4
	union  XCMP_PERIOD2_REG			XCMP_PERIOD2;			//offset 4A4 ,sub_offset 4
	union  XCMP_UPDATE_REG			XCMP_UPDATE;			//offset 4A8 ,sub_offset 4
	union  GLDCFG2_REG				GLDCFG2;				//offset 4AC ,sub_offset 4
	uint16_t 						rsvd52[43]; 		 // Reserved	//offset 4B0 ,sub_offset 84
	uint16_t 						TBPRD_XCMP;				//offset 504 ,sub_offset 2
	uint16_t 						rsvd53[15]; 		 // Reserved	//offset 506 ,sub_offset 30
	uint16_t 						CMPA_XCMP;				//offset 524 ,sub_offset 2
	uint16_t 						rsvd54[15]; 		 // Reserved	//offset 526 ,sub_offset 30
	uint16_t 						CMPB_XCMP;				//offset 544 ,sub_offset 2
	uint16_t 						rsvd55[15]; 		 // Reserved	//offset 546 ,sub_offset 30
	uint16_t 						CMPC_XCMP;				//offset 564 ,sub_offset 2
	uint16_t 						rsvd56[15]; 		 // Reserved	//offset 566 ,sub_offset 30
	uint16_t 						CMPD_XCMP;				//offset 584 ,sub_offset 2
	uint16_t 						rsvd57[15]; 		 // Reserved	//offset 586 ,sub_offset 30
	uint16_t 						CMPA1_XCMP;				//offset 5A4 ,sub_offset 2
	uint16_t 						rsvd58[15]; 		 // Reserved	//offset 5A6 ,sub_offset 30
	uint16_t 						CMPB1_XCMP;				//offset 5C4 ,sub_offset 2
};


#elif (EPWM_VERSION==30)

// EPWM Register Definitions:

struct EPWM_TOP_REGS {
	union  SYNCSELECT_TOP_REG			SYNCSELECT;				//offset 0 ,sub_offset 4
	union  ADCSOCOUTSELECT_TOP_REG			ADCSOCOUTSELECT;	//offset 4 ,sub_offset 4
	uint16_t 						rsvd1[28]; 		 // Reserved//offset 8 ,sub_offset 56
	union  TRANS_MODE_REG			TRANS_MODE_1;				//offset 40 ,sub_offset 4
	union  PERIOD_REG				PERIOD_1;					//offset 44 ,sub_offset 4
	union  DUTYCYCLE1_REG			DUTYCYCLE1_1;				//offset 48 ,sub_offset 4
	union  DUTYCYCLE2_REG			DUTYCYCLE2_1;				//offset 4C ,sub_offset 4
	union  DEADZONE_A1_REG			DEADZONE_A1_1;				//offset 50 ,sub_offset 4
	union  DEADZONE_B1_REG			DEADZONE_B1_1;				//offset 54 ,sub_offset 4
	union  DEADZONE_A2_REG			DEADZONE_A2_1;				//offset 58 ,sub_offset 4
	union  DEADZONE_B2_REG			DEADZONE_B2_1;				//offset 5C ,sub_offset 4
	union  PHASESHIFT_REG			PHASESHIFT_1;				//offset 60 ,sub_offset 4
	union  PHASESHIFT_INI_REG		PHASESHIFT_INI_1;			//offset 64 ,sub_offset 4
	union  AQCSFRC_TOP_REG			AQCSFRC_1;					//offset 68 ,sub_offset 4
	uint16_t 						rsvd2[10]; 		 // Reserved//offset 6C ,sub_offset 20
	union  TRANS_MODE_REG			TRANS_MODE_2;				//offset 80 ,sub_offset 4
	union  PERIOD_REG			PERIOD_2;
	union  DUTYCYCLE1_REG			DUTYCYCLE1_2;
	union  DUTYCYCLE2_REG			DUTYCYCLE2_2;
	union  DEADZONE_A1_REG			DEADZONE_A1_2;
	union  DEADZONE_B1_REG			DEADZONE_B1_2;
	union  DEADZONE_A2_REG			DEADZONE_A2_2;
	union  DEADZONE_B2_REG			DEADZONE_B2_2;
	union  PHASESHIFT_REG			PHASESHIFT_2;
	union  PHASESHIFT_INI_REG			PHASESHIFT_INI_2;
	union  AQCSFRC_TOP_REG			AQCSFRC_2;
	uint16_t 						rsvd3[10]; 		 // Reserved
	union  TRANS_MODE_REG			TRANS_MODE_3;
	union  PERIOD_REG			PERIOD_3;
	union  DUTYCYCLE1_REG			DUTYCYCLE1_3;
	union  DUTYCYCLE2_REG			DUTYCYCLE2_3;
	union  DEADZONE_A1_REG			DEADZONE_A1_3;
	union  DEADZONE_B1_REG			DEADZONE_B1_3;
	union  DEADZONE_A2_REG			DEADZONE_A2_3;
	union  DEADZONE_B2_REG			DEADZONE_B2_3;
	union  PHASESHIFT_REG			PHASESHIFT_3;
	union  PHASESHIFT_INI_REG			PHASESHIFT_INI_3;
	union  AQCSFRC_TOP_REG			AQCSFRC_3;
	uint16_t 						rsvd4[10]; 		 // Reserved
	union  TRANS_MODE_REG			TRANS_MODE_4;
	union  PERIOD_REG			PERIOD_4;
	union  DUTYCYCLE1_REG			DUTYCYCLE1_4;
	union  DUTYCYCLE2_REG			DUTYCYCLE2_4;
	union  DEADZONE_A1_REG			DEADZONE_A1_4;
	union  DEADZONE_B1_REG			DEADZONE_B1_4;
	union  DEADZONE_A2_REG			DEADZONE_A2_4;
	union  DEADZONE_B2_REG			DEADZONE_B2_4;
	union  PHASESHIFT_REG			PHASESHIFT_4;
	union  PHASESHIFT_INI_REG			PHASESHIFT_INI_4;
	union  AQCSFRC_TOP_REG			AQCSFRC_4;					//offset 128 ,sub_offset 4
	uint16_t 						rsvd5[232]; 		 // Reserved//offset 12C ,sub_offset 464
	uint32_t  						EPWM_TOP_REGS_LOCK;			//offset 2FC ,sub_offset 4
	uint16_t 						rsvd6[6]; 		 	// Reserved//offset 300 ,sub_offset 12
	union  EPWM_MUX_SEL_REG			EPWM_MUX_SEL;				//offset 30C ,sub_offset 4
	uint16_t 						rsvd7[2]; 		 	// Reserved//offset 310 ,sub_offset 4
	union  TZ_INV_CFG_REG			TZ_INV_CFG;					//offset 314 ,sub_offset 4
	union  TRIPIN_INV_CFG_REG			TRIPIN_INV_CFG;			//offset 318 ,sub_offset 4
	union  PWM_HALT_EN_REG			PWM_HALT_EN;				//offset 31C ,sub_offset 4
	union  HRPWM_CYCLE_NUM_REG			HRPWM_CYCLE_NUM;		//offset 320 ,sub_offset 4
	uint16_t 						rsvd8[6]; 		 	// Reserved//offset 324 ,sub_offset 12
	uint32_t  						HRPWM_0CFG;					//offset 330 ,sub_offset 4
	uint16_t 						rsvd9[6]; 		 	// Reserved//offset 334 ,sub_offset 12
	union  EPWM_EN_CFG1_REG			EPWM_EN_CFG1;				//offset 340 ,sub_offset 4
	uint16_t 						rsvd10[2]; 		 	// Reserved//offset 344 ,sub_offset 4
	union  EPWM_DISABLE_CFG1_REG	EPWM_DISABLE_CFG1;			//offset 348 ,sub_offset 4
	uint16_t 						rsvd11[2]; 		 	// Reserved//offset 34C ,sub_offset 4
	union  EPWM_EN_RO1_REG			EPWM_EN_RO1;				//offset 350 ,sub_offset 4
	uint16_t 						rsvd12[2]; 		 	// Reserved//offset 354 ,sub_offset 4
	union  EPWM_BURST_CFG1_REG		EPWM_BURST_CFG1;			//offset 358 ,sub_offset 4
	union  EPWM_BURST_CFG2_REG		EPWM_BURST_CFG2;			//offset 35C ,sub_offset 4
	union  EPWM_EN_MUX1_REG			EPWM_EN_MUX1;				//offset 360 ,sub_offset 4
};


struct EPWM_REGS {
	union  TBCTL_REG			TBCTL;
	union  TBCTL2_REG			TBCTL2;
	uint16_t 						rsvd1; 		 // Reserved //offset 0x4 ,sub_offset 2
	union  EPWMSYNCINSEL_REG			EPWMSYNCINSEL;		 	//offset 0x6
	uint16_t  						TBCTR;					 	//offset 0x8
	union  TBSTS_REG			TBSTS;						 	//offset 0xA
	union  EPWMSYNCOUTEN_REG			EPWMSYNCOUTEN; 			//offset 0xC
	union  TBCTL3_REG			TBCTL3;							 //offset 0xE
	union  CMPCTL_REG			CMPCTL;						 	//offset 0x10
	union  CMPCTL2_REG			CMPCTL2;						//offset 0x12
	union  CMPCTL3_REG			CMPCTL3;						//offset 0x14
	uint16_t 						rsvd2; 		 // Reserved//offset 0x16,sub_offset 2
	union  DBCTL_REG			DBCTL;							//offset 0x18
	union  DBCTL2_REG			DBCTL2;							//offset 0x1A
	uint16_t 						rsvd3[2]; 		 // Reserved//offset 0x1C,sub_offset 4
	union  AQCTL_REG			AQCTL;							//offset 0x20
	union  AQTSRCSEL_REG			AQTSRCSEL;					//offset 0x22
	uint16_t 						rsvd4[2]; 		 // Reserved//offset 0x24,sub_offset 4
	union  PCCTL_REG			PCCTL;							//offset 0x28
	uint16_t 						rsvd5[3]; 		 // Reserved//offset 0x2A,sub_offset 6
	union  VCAPCTL_REG			VCAPCTL;						//offset 0x30
	union  VCNTCFG_REG			VCNTCFG;						//offset 0x32
	uint16_t 						rsvd6[6]; 		 // Reserved//offset 0x34,sub_offset 12
	union  HRCNFG_REG			HRCNFG;							//offset 0x40
	union  HRPWR_REG			HRPWR;							//offset 0x42
	uint16_t 						rsvd7[4]; 		 // Reserved//offset 0x44,sub_offset 8
	union  HRMSTEP_REG			HRMSTEP;						//offset 0x4C
	union  HRCNFG2_REG			HRCNFG2;						//offset 0x4E
	uint16_t 						rsvd8[5]; 		 // Reserved//offset 0x50,sub_offset 10
	union  HRPCTL_REG			HRPCTL;							//offset 0x5A
	union  TRREM_REG			TRREM;							//offset 0x5C
	uint16_t 						rsvd9[5]; 		 // Reserved//offset 0x5E,sub_offset 10
	union  GLDCTL_REG			GLDCTL;							//offset 0x68
	union  GLDCFG_REG			GLDCFG;							//offset 0x6A
	uint16_t 						rsvd10[2]; 		 // Reserved//offset 0x6C,sub_offset 4
	union  EPWMXLINK_REG			EPWMXLINK;					//offset 0x70
	union  EPWMXLINK2_REG			EPWMXLINK2;					//offset 0x74
	union  EPWMXLINK3_REG			EPWMXLINK3;					//offset 0x78
	uint16_t 						rsvd11[2]; 		 // Reserved//offset 0x7C,sub_offset 4
	union  AQCTLA_REG			AQCTLA;							//offset 0x80
	union  AQCTLA2_REG			AQCTLA2;						//offset 0x82
	union  AQCTLB_REG			AQCTLB;							//offset 0x84
	union  AQCTLB2_REG			AQCTLB2;						//offset 0x86
	uint16_t 						rsvd12[3]; 		 // Reserved//offset 0x88,sub_offset 6
	union  AQSFRC_REG			AQSFRC;							//offset 0x8E
	uint16_t 						rsvd13; 		 // Reserved//offset 0x90,sub_offset 2
	union  AQCSFRC_REG			AQCSFRC;						//offset 0x92
	uint16_t 						rsvd14[6]; 		 // Reserved//offset 0x94,sub_offset 12
	union  DBREDHR_REG			DBREDHR;						//offset 0xA0
	union  DBRED_REG			DBRED;							//offset 0xA2
	union  DBFEDHR_REG			DBFEDHR;						//offset 0xA4
	union  DBFED_REG			DBFED;							//offset 0xA6
	uint16_t 						rsvd15[12]; 		 // Reserved//offset 0xA8,sub_offset 24
	union  TBPHS_REG			TBPHS;							//offset 0xC0
	uint16_t  						TBPRDHR;					//offset 0xC4
	uint16_t  						TBPRD;						//offset 0xC6
	union  CMPA1_REG	  						CMPA1;						//offset 0xC8
	union  CMPB1_REG	  						CMPB1;						//offset 0xCC
	uint16_t 						rsvd18; 		 // Reserved//offset 0xD0,sub_offset 2
	union  CMPSEL_REG			CMPSEL;							//offset 0xD2
	union  CMPA_REG			CMPA;								//offset 0xD4
	union  CMPB_REG			CMPB;								//offset 0xD8
	uint16_t 						rsvd19; 		 // Reserved//offset 0xDC,sub_offset 2
	uint16_t  						CMPC;						//offset 0xDE
	uint16_t 						rsvd20; 		 // Reserved//offset 0xE0,sub_offset 2
	uint16_t  						CMPD;						//offset 0xE2
	union  CMPRO_REG			CMPRO;							//offset 0xE4
	union  GLDCTL2_REG			GLDCTL2;						//offset 0xE8
	uint16_t 						rsvd21[2]; 		 // Reserved//offset 0xEA,sub_offset 4
	uint16_t  						SWVDELVAL;					//offset 0xEE
	uint16_t 						rsvd22[6]; 		 // Reserved//offset 0xF0,sub_offset 12
	union  TZSEL_EXP_REG			TZSEL_EXP;					//offset 0xFC
	union  TZSEL_REG			TZSEL;							//offset 0x100
	union  TZSEL2_REG			TZSEL2;							//offset 0x102
	union  TZDCSEL_REG			TZDCSEL;						//offset 0x104
	uint16_t 						rsvd23; 		 // Reserved//offset 0x106,sub_offset 2
	union  TZCTL_REG			TZCTL;							//offset 0x108
	union  TZCTL2_REG			TZCTL2;							//offset 0x10A
	union  TZCTLDCA_REG			TZCTLDCA;						//offset 0x10C
	union  TZCTLDCB_REG			TZCTLDCB;						//offset 0x10E
	uint16_t 						rsvd24[5]; 		 // Reserved//offset 0x110,sub_offset 10
	union  TZEINT_REG			TZEINT;							//offset 0x11A
	uint16_t 						rsvd25[2]; 		 // Reserved//offset 0x11C,sub_offset 4
	union  TZEINT_CON_REG			TZEINT_CON;					//offset 0x120
	union  TZFLG_CON_REG			TZFLG_CON;					//offset 0x122
	uint16_t 						rsvd26; 		 // Reserved//offset 0x124,sub_offset 2
	union  TZFLG_REG			TZFLG;							//offset 0x126
	union  TZCBCFLG_REG			TZCBCFLG;						//offset 0x128
	union  TZOSTFLG_REG			TZOSTFLG;						//offset 0x12A
	uint16_t 						rsvd27; 		 // Reserved//offset 0x12C,sub_offset 2
	union  TZCLR_REG			TZCLR;							//offset 0x12E
	union  TZCBCCLR_REG			TZCBCCLR;						//offset 0x130
	union  TZOSTCLR_REG			TZOSTCLR;						//offset 0x132
	uint16_t 						rsvd28; 		 // Reserved//offset 0x134,sub_offset 2
	union  TZFRC_REG			TZFRC;							//offset 0x136
	uint16_t 						rsvd29; 		 // Reserved//offset 0x138,sub_offset 2
	union  TZTRIPOUTSEL_REG			TZTRIPOUTSEL;				//offset 0x13A
	union  TZCLR_EXP_REG			TZCLR_EXP;					//offset 0x13C
	union  TZFLG_EXP_REG			TZFLG_EXP;					//offset 0x13E
	uint16_t 						rsvd30[4]; 		 // Reserved//offset 0x140,sub_offset 8
	union  ETSEL_REG			ETSEL;							//offset 0x148
	uint16_t 						rsvd31; 		 // Reserved//offset 0x14A,sub_offset 2
	union  ETPS_REG				ETPS;							//offset 0x14C
	uint16_t 						rsvd32; 		 // Reserved//offset 0x14E,sub_offset 2
	union  ETFLG_REG			ETFLG;							//offset 0x150
	uint16_t 						rsvd33; 		 // Reserved//offset 0x152,sub_offset 2
	union  ETCLR_REG			ETCLR;							//offset 0x154
	uint16_t 						rsvd34; 		 // Reserved//offset 0x156,sub_offset 2
	union  ETFRC_REG			ETFRC;							//offset 0x158
	uint16_t 						rsvd35; 		 // Reserved//offset 0x15A,sub_offset 2
	union  ETINTPS_REG			ETINTPS;						//offset 0x15C
	uint16_t 						rsvd36; 		 // Reserved//offset 0x15E,sub_offset 2
	union  ETSOCPS_REG			ETSOCPS;						//offset 0x160
	uint16_t 						rsvd37; 		 // Reserved//offset 0x162,sub_offset 2
	union  ETCNTINITCTL_REG			ETCNTINITCTL;				//offset 0x164
	uint16_t 						rsvd38; 		 // Reserved//offset 0x166,sub_offset 2
	union  ETCNTINIT_REG			ETCNTINIT;					//offset 0x168
	uint16_t 						rsvd39; 		 // Reserved//offset 0x16A,sub_offset 2
	union  ETINTMIXEN_REG			ETINTMIXEN;					//offset 0x16C
	uint16_t 						rsvd40; 		 // Reserved//offset 0x16E,sub_offset 2
	union  ETSOCAMIXEN_REG			ETSOCAMIXEN;				//offset 0x170
	uint16_t 						rsvd41; 		 // Reserved//offset 0x172,sub_offset 2
	union  ETSOCBMIXEN_REG			ETSOCBMIXEN;				//offset 0x174
	uint16_t 						rsvd42[5]; 		 // Reserved//offset 0x176,sub_offset 10
	union  DCTRIPSEL_REG			DCTRIPSEL;					//offset 0x180
	union  DCTRIPSELEXP_REG			DCTRIPSELEXP;				//offset 0x182
	uint16_t 						rsvd43; 		 // Reserved//offset 0x184,sub_offset 2
	union  DCACTL_REG			DCACTL;							//offset 0x186
	union  DCBCTL_REG			DCBCTL;							//offset 0x188
	uint16_t 						rsvd44[2]; 		 // Reserved//offset 0x18A,sub_offset 4
	union  DCFCTL_REG			DCFCTL;							//offset 0x18E
	union  DCCAPCTL_REG			DCCAPCTL;						//offset 0x190
	uint16_t  						DCFOFFSET;					//offset 0x192
	uint16_t  						DCFOFFSETCNT;				//offset 0x194
	uint16_t  						DCFWINDOW;					//offset 0x196
	uint16_t  						DCFWINDOWCNT;				//offset 0x198
	union  BLANKPULSEMIXSEL_REG			BLANKPULSEMIXSEL;		//offset 0x19A
	union  DCCAPMIXSEL_REG			DCCAPMIXSEL;				//offset 0x19C
	uint16_t  						DCCAP;						//offset 0x19E
	uint16_t 						rsvd45[2]; 		 // Reserved//offset 0x1A0,sub_offset 4
	union  DCAHTRIPSEL_REG			DCAHTRIPSEL;				//offset 0x1A4
	union  DCALTRIPSEL_REG			DCALTRIPSEL;				//offset 0x1A6
	union  DCBHTRIPSEL_REG			DCBHTRIPSEL;				//offset 0x1A8
	union  DCBLTRIPSEL_REG			DCBLTRIPSEL;				//offset 0x1AA
	union  CAPCTL_REG				CAPCTL;						//offset 0x1AC
	union  CAPGATETRIPSEL_REG		CAPGATETRIPSEL;				//offset 0x1AE
	union  CAPINTRIPSEL_REG			CAPINTRIPSEL;				//offset 0x1B0
	union  CAPTRIPSEL_REG			CAPTRIPSEL;					//offset 0x1B2
	uint16_t 						rsvd46[35]; 		 // Reserved//offset 0x1B4,sub_offset 70
	uint16_t  						HWVDELVAL;					//offset 0x1FA
	uint16_t  						VCNTVAL;					//offset 0x1FC
};

struct EPWM_EXTEND_REGS{
	//uint16_t 						rsvd47[129]; 		 // Reserved//offset 0x1FE,sub_offset 258
	union  EPWM_TBCTR_CHG_REG			EPWM_TBCTR_CHG;			//offset 0x300
	union  ETSELEXP_REG			ETSELEXP;						//offset 0x304
	union  EPWM_EN_REG			EPWM_EN;						//offset 0x308
	uint16_t 						rsvd48[2]; 		 // Reserved//offset 0x30C,sub_offset 4
	union  DCTRIPSEL2_DCAL_REG			DCTRIPSEL2_DCAL;		//offset 0x310
	union  DCTRIPSEL2_DCAH_REG			DCTRIPSEL2_DCAH;		//offset 0x312
	union  DCTRIPSEL2_DCBL_REG			DCTRIPSEL2_DCBL;		//offset 0x314
	union  DCTRIPSEL2_DCBH_REG			DCTRIPSEL2_DCBH;		//offset 0x316
	union  DCTRIPSEL_1DCAL_REG			DCTRIPSEL_1DCAL;		//offset 0x318
	union  DCTRIPSEL_2DCAL_REG			DCTRIPSEL_2DCAL;		//offset 0x31C
	union  DCTRIPSEL_3DCAL_REG			DCTRIPSEL_3DCAL;		//offset 0x320
	union  DCTRIPSEL_1DCAH_REG			DCTRIPSEL_1DCAH;		//offset 0x324
	union  DCTRIPSEL_2DCAH_REG			DCTRIPSEL_2DCAH;		//offset 0x328
	union  DCTRIPSEL_3DCAH_REG			DCTRIPSEL_3DCAH;		//offset 0x32C
	union  DCTRIPSEL_1DCBL_REG			DCTRIPSEL_1DCBL;		//offset 0x330
	union  DCTRIPSEL_2DCBL_REG			DCTRIPSEL_2DCBL;		//offset 0x334
	union  DCTRIPSEL_3DCBL_REG			DCTRIPSEL_3DCBL;		//offset 0x338
	union  DCTRIPSEL_1DCBH_REG			DCTRIPSEL_1DCBH;		//offset 0x33C
	union  DCTRIPSEL_2DCBH_REG			DCTRIPSEL_2DCBH;		//offset 0x340
	union  DCTRIPSEL_3DCBH_REG			DCTRIPSEL_3DCBH;		//offset 0x344
	union  TZ_CLR_MODE_REG			TZ_CLR_MODE;				//offset 0x348
	union  TZ_CLR_ARM_REG			TZ_CLR_ARM;					//offset 0x34C
	union  TZ_CLR_DSP_REG			TZ_CLR_DSP;					//offset 0x350
	union  TZFRC_ARM_REG			TZFRC_ARM;					//offset 0x354
	uint16_t 						rsvd49; 		 // Reserved//offset 0x356,sub_offset 2
	union  TZFRC_DSP_REG			TZFRC_DSP;					//offset 0x358
	uint16_t 						rsvd50; 		 // Reserved//offset 0x35A,sub_offset 2
	union  HRPWM_CTRL_REG			HRPWM_CTRL;					//offset 0x35C
	uint16_t 						rsvd51[39]; 		 // Reserved//offset 0x35E,sub_offset 78
	union  GLDCFG2_REG			GLDCFG2;						//offset 0x3AC
	uint16_t 						rsvd52[9]; 		 // Reserved//offset 0x3AE,sub_offset 18
	union  HRPWM_INT_REG			HRPWM_INT;					//offset 0x3C0
	uint16_t 						rsvd53[6]; 		 // Reserved//offset 0x3C4,sub_offset 12
	union  EPWMA_EN_CTRL_REG		EPWMA_EN_CTRL;				//offset 0x3D0
	union  EPWMB_EN_CTRL_REG		EPWMB_EN_CTRL;				//offset 0x3D2
	union  SOC_PERIOD_REG			SOC_PERIOD;					//offset 0x3D4
	union  SOC_SYNC_EN_REG			SOC_SYNC_EN;				//offset 0x3D8
	uint16_t 						rsvd54[16]; 		 // Reserved//offset 0x3DC,sub_offset 32
	uint16_t  						EPWM_REGS_LOCK;				//offset 0x3FC
};

struct EPWM_XCMP_REGS {
	union  XCMPCTL1_REG			XCMPCTL1;						//offset 0x0
	uint16_t 						rsvd1[6]; 		 // Reserved//offset 0x4,sub_offset 12
	union  XLOADCTL_REG			XLOADCTL;						//offset 0x10
	uint16_t 						rsvd2[2]; 		 // Reserved//offset 0x14,sub_offset 4
	union  XLOAD_REG			XLOAD;							//offset 0x18
	union  EPWMXLINKXLOAD_REG			EPWMXLINKXLOAD;			//offset 0x1C
	union  XREGSHDW1STS_REG			XREGSHDW1STS;				//offset 0x20
	uint16_t 						rsvd3[2]; 		 // Reserved//offset 0x24,sub_offset 4
	union  XREGSHDW2STS_REG			XREGSHDW2STS;				//offset 0x28
	uint16_t 						rsvd4[2]; 		 // Reserved//offset 0x2C,sub_offset 4
	union  XREGSHDW3STS_REG			XREGSHDW3STS;				//offset 0x30
	uint16_t 						rsvd5[6]; 		 // Reserved//offset 0x34,sub_offset 12
	union  XCMP1_ACTIVE_REG			XCMP1_ACTIVE;				//offset 0x40
	union  XCMP2_ACTIVE_REG			XCMP2_ACTIVE;				//offset 0x44
	union  XCMP3_ACTIVE_REG			XCMP3_ACTIVE;				//offset 0x48
	union  XCMP4_ACTIVE_REG			XCMP4_ACTIVE;				//offset 0x4C
	union  XCMP5_ACTIVE_REG			XCMP5_ACTIVE;				//offset 0x50
	union  XCMP6_ACTIVE_REG			XCMP6_ACTIVE;				//offset 0x54
	union  XCMP7_ACTIVE_REG			XCMP7_ACTIVE;				//offset 0x58
	union  XCMP8_ACTIVE_REG			XCMP8_ACTIVE;				//offset 0x5C
	union  XTBPRD_ACTIVE_REG			XTBPRD_ACTIVE;				//offset 60
	uint16_t 						rsvd6[2]; 		 // Reserved//offset 0x64,sub_offset 4
	union  XAQCTLA_ACTIVE_REG			XAQCTLA_ACTIVE;				//offset 0x68
	union  XAQCTLB_ACTIVE_REG			XAQCTLB_ACTIVE;				//offset 0x6A
	uint16_t 						rsvd7[8]; 		 // Reserved//offset 0x6C,sub_offset 16
	union  XMINMAX_ACTIVE_REG			XMINMAX_ACTIVE;				//offset 0x7C
	union  XCMP1_SHDW1_REG			XCMP1_SHDW1;				//offset 0x80
	union  XCMP2_SHDW1_REG			XCMP2_SHDW1;				//offset 0x84
	union  XCMP3_SHDW1_REG			XCMP3_SHDW1;				//offset 0x88
	union  XCMP4_SHDW1_REG			XCMP4_SHDW1;				//offset 0x8C
	union  XCMP5_SHDW1_REG			XCMP5_SHDW1;				//offset 0x90
	union  XCMP6_SHDW1_REG			XCMP6_SHDW1;				//offset 0x94
	union  XCMP7_SHDW1_REG			XCMP7_SHDW1;				//offset 0x98
	union  XCMP8_SHDW1_REG			XCMP8_SHDW1;				//offset 0x9C
	union  XTBPRD_SHDW1_REG			XTBPRD_SHDW1;				//offset 0xA0
	uint32_t 						rsvd8; 		 // Reserved//offset 0xA4,sub_offset 4
	union  XAQCTLA_SHDW1_REG			XAQCTLA_SHDW1;			//offset 0xA8
	union  XAQCTLB_SHDW1_REG			XAQCTLB_SHDW1;			//offset 0xAA
	uint16_t 						rsvd9; 		 // Reserved//offset 0xAC,sub_offset 2
	uint16_t  						CMPC_SHDW1;				//offset 0xAE
	uint16_t 						rsvd10; 		 // Reserved//offset 0xB0,sub_offset 2
	uint16_t  						CMPD_SHDW1;				//offset 0xB2
	uint16_t 						rsvd11[4]; 		 // Reserved//offset 0xB4,sub_offset 8
	union  XMINMAX_SHDW1_REG			XMINMAX_SHDW1;				//offset 0xBC
	union  XCMP1_SHDW2_REG			XCMP1_SHDW2;
	union  XCMP2_SHDW2_REG			XCMP2_SHDW2;
	union  XCMP3_SHDW2_REG			XCMP3_SHDW2;
	union  XCMP4_SHDW2_REG			XCMP4_SHDW2;
	union  XCMP5_SHDW2_REG			XCMP5_SHDW2;
	union  XCMP6_SHDW2_REG			XCMP6_SHDW2;
	union  XCMP7_SHDW2_REG			XCMP7_SHDW2;
	union  XCMP8_SHDW2_REG			XCMP8_SHDW2;
	union  XTBPRD_SHDW2_REG			XTBPRD_SHDW2;
	uint32_t 						rsvd12; 		 // Reserved
	union  XAQCTLA_SHDW2_REG			XAQCTLA_SHDW2;
	union  XAQCTLB_SHDW2_REG			XAQCTLB_SHDW2;
	uint16_t 						rsvd13; 		 // Reserved
	uint16_t  						CMPC_SHDW2;
	uint16_t 						rsvd14; 		 // Reserved
	uint16_t  						CMPD_SHDW2;
	uint16_t 						rsvd15[4]; 		 // Reserved
	union  XMINMAX_SHDW2_REG			XMINMAX_SHDW2;
	union  XCMP1_SHDW3_REG			XCMP1_SHDW3;
	union  XCMP2_SHDW3_REG			XCMP2_SHDW3;
	union  XCMP3_SHDW3_REG			XCMP3_SHDW3;
	union  XCMP4_SHDW3_REG			XCMP4_SHDW3;
	union  XCMP5_SHDW3_REG			XCMP5_SHDW3;
	union  XCMP6_SHDW3_REG			XCMP6_SHDW3;
	union  XCMP7_SHDW3_REG			XCMP7_SHDW3;
	union  XCMP8_SHDW3_REG			XCMP8_SHDW3;
	union  XTBPRD_SHDW3_REG			XTBPRD_SHDW3;
	uint32_t 						rsvd16; 		 // Reserved
	union  XAQCTLA_SHDW3_REG			XAQCTLA_SHDW3;
	union  XAQCTLB_SHDW3_REG			XAQCTLB_SHDW3;
	uint16_t 						rsvd17; 		 // Reserved
	uint16_t  						CMPC_SHDW3;
	uint16_t 						rsvd18; 		 // Reserved
	uint16_t  						CMPD_SHDW3;
	uint16_t 						rsvd19[4]; 		 // Reserved
	union  XMINMAX_SHDW3_REG			XMINMAX_SHDW3;
};

struct EPWM_DE_REGS {
	union  DECTL_REG			DECTL;
	union  DECOMPSEL_REG		DECOMPSEL;
	union  DEACTCTL_REG			DEACTCTL;
	union  DESTS_REG			DESTS;
	union  DEFRC_REG			DEFRC;
	union  DECLR_REG			DECLR;
	uint16_t 					rsvd1[4]; 		 // Reserved
	union  DEMONCNT_REG			DEMONCNT;
	union  DEMONCTL_REG			DEMONCTL;
	union  DEMONSTEP_REG		DEMONSTEP;
	union  DEMONTHRES_REG		DEMONTHRES;
};

struct EPWM_MINDB_LUT_REGS {
	union  MINDBCFG_REG			MINDBCFG;
	union  MINDBDLY_REG			MINDBDLY;
	uint16_t 						rsvd1[12]; 		 // Reserved
	union  LUTCTLA_REG			LUTCTLA;
	union  LUTCTLB_REG			LUTCTLB;
};


#endif









/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

//
// TBCTL (Time-Base Control) Register
//

//
// CTRMODE bits
//
#define TB_COUNT_UP      0x0
#define TB_COUNT_DOWN    0x1
#define TB_COUNT_UPDOWN  0x2
#define TB_FREEZE        0x3

//
// PHSEN bit
//
#define TB_DISABLE  0x0
#define TB_ENABLE   0x1

//
// PRDLD bit
//
#define TB_SHADOW     0x0
#define TB_IMMEDIATE  0x1

//
// HSPCLKDIV and CLKDIV bits
//
#define TB_DIV1   0x0
#define TB_DIV2   0x1
#define TB_DIV4   0x2

//
// PHSDIR bit
//
#define TB_DOWN   0x0
#define TB_UP     0x1

//
// EPWMSYNINSEL (EPWMxSYNCIN Source Select) Register
//

//
// SEL bits
//
#if (EPWM_VERSION == 12)|| (EPWM_VERSION == 0) ||(EPWM_VERSION == 11) || (EPWM_VERSION == 21)
#define SYNC_IN_SRC_DISABLE_ALL      0x0
#define SYNC_IN_SRC_SYNCOUT_EPWM1    0x1
#define SYNC_IN_SRC_SYNCOUT_EPWM2    0x2
#define SYNC_IN_SRC_SYNCOUT_EPWM3    0x3
#define SYNC_IN_SRC_SYNCOUT_EPWM4    0x4
#define SYNC_IN_SRC_SYNCOUT_EPWM5    0x5
#define SYNC_IN_SRC_SYNCOUT_EPWM6    0x6
#define SYNC_IN_SRC_SYNCOUT_EPWM7    0x7
#define SYNC_IN_SRC_SYNCOUT_EPWM11   0xB
#define SYNC_IN_SRC_SYNCOUT_EPWM12   0xC
#define SYNC_IN_SRC_SYNCOUT_ECAP1    0x11
#define SYNC_IN_SRC_SYNCOUT_ECAP2    0x12
#define SYNC_IN_SRC_SYNCOUT_ECAP3    0x13
#define SYNC_IN_SRC_SYNCOUT_ECAP4    0x14
#define SYNC_IN_SRC_SYNCOUT_ECAP5    0x15
#define SYNC_IN_SRC_SYNCOUT_ECAP6    0x16
#define SYNC_IN_SRC_SYNCOUT_ECAP7    0x17
#define SYNC_IN_SRC_INPUTXBAR_OUT5   0x18
#define SYNC_IN_SRC_INPUTXBAR_OUT6   0x19

#elif (EPWM_VERSION == 22)|| (EPWM_VERSION == 30)
#define SYNC_IN_SRC_DISABLE_ALL      0x0
#define SYNC_IN_SRC_SYNCOUT_EPWM1    0x1
#define SYNC_IN_SRC_SYNCOUT_EPWM2    0x2
#define SYNC_IN_SRC_SYNCOUT_EPWM3    0x3
#define SYNC_IN_SRC_SYNCOUT_EPWM4    0x4
#define SYNC_IN_SRC_SYNCOUT_EPWM5    0x5
#define SYNC_IN_SRC_SYNCOUT_EPWM6    0x6
#define SYNC_IN_SRC_SYNCOUT_EPWM7    0x7
#define SYNC_IN_SRC_SYNCOUT_EPWM8    0x8
#define SYNC_IN_SRC_SYNCOUT_EPWM9    0x9
#define SYNC_IN_SRC_SYNCOUT_EPWM10   0xA
#define SYNC_IN_SRC_SYNCOUT_EPWM11   0xB
#define SYNC_IN_SRC_SYNCOUT_EPWM12   0xC
#define SYNC_IN_SRC_SYNCOUT_EPWM13   0xD
#define SYNC_IN_SRC_SYNCOUT_EPWM14   0xE
#define SYNC_IN_SRC_SYNCOUT_EPWM15   0xF
#define SYNC_IN_SRC_SYNCOUT_EPWM16   0x10
#define SYNC_IN_SRC_SYNCOUT_ECAP1    0x11
#define SYNC_IN_SRC_SYNCOUT_ECAP2    0x12
#define SYNC_IN_SRC_SYNCOUT_ECAP3    0x13
#define SYNC_IN_SRC_SYNCOUT_ECAP4    0x14
#define SYNC_IN_SRC_SYNCOUT_ECAP5    0x15
#define SYNC_IN_SRC_SYNCOUT_ECAP6    0x16
#define SYNC_IN_SRC_SYNCOUT_ECAP7    0x17
#define SYNC_IN_SRC_INPUTXBAR_OUT5   0x18
#define SYNC_IN_SRC_INPUTXBAR_OUT6   0x19
#define SYNC_IN_SRC_SYNCOUT_EPWM17   0x1C
#define SYNC_IN_SRC_SYNCOUT_EPWM18   0x1D

#endif
//
// EPWMSYNOUTEN (EPWMxSYNCOUT Source Enable) Register
//

#define SYNC_OUT_SRC_DISABLE_ALL     0x0
#define SYNC_OUT_SRC_ENABLE_ALL      0x7F

//
// SWEN, ZEROEN, CMPBEN, CMPCEN, CMPCEN, DCAEVT1EN & DCBEVT1EN  bits
//
#define SYNC_OUT_SRC_ENABLE       0x1
#define SYNC_OUT_SRC_DISABLE      0x0

//
// CMPCTL (Compare Control) Register
//

//
// LOADAMODE and LOADBMODE bits
//
#define CC_CTR_ZERO      0x0
#define CC_CTR_PRD       0x1
#define CC_CTR_ZERO_PRD  0x2
#define CC_LD_DISABLE    0x3

//
// SHDWAMODE and SHDWBMODE bits
//
#define CC_SHADOW     0x0
#define CC_IMMEDIATE  0x1

//
// AQCTLA and AQCTLB (Action Qualifier Control)
//

//
// ZRO, PRD, CAU, CAD, CBU, CBD bits
//
#define AQ_NO_ACTION  0x0
#define AQ_CLEAR      0x1
#define AQ_SET        0x2
#define AQ_TOGGLE     0x3

//
// DBCTL (Dead-Band Control) Register
//

//
// OUT MODE bits
//
#define DB_DISABLE      0x0
#define DBB_ENABLE      0x1
#define DBA_ENABLE      0x2
#define DB_FULL_ENABLE  0x3

//
// POLSEL bits
//
#define DB_ACTV_HI   0x0
#define DB_ACTV_LOC  0x1
#define DB_ACTV_HIC  0x2
#define DB_ACTV_LO   0x3

//
// IN MODE bits
//
#define DBA_ALL          0x0
#define DBB_RED_DBA_FED  0x1
#define DBA_RED_DBB_FED  0x2
#define DBB_ALL          0x3

//
// PCCTL (PWM chopper control) Register
//

//
// CHPEN bit
//
#define CHP_DISABLE  0x0
#define CHP_ENABLE   0x1

//
// CHPFREQ bits
//
#define CHP_DIV1  0x0
#define CHP_DIV2  0x1
#define CHP_DIV3  0x2
#define CHP_DIV4  0x3
#define CHP_DIV5  0x4
#define CHP_DIV6  0x5
#define CHP_DIV7  0x6
#define CHP_DIV8  0x7

//
// CHPDUTY bits
//
#define CHP1_8TH  0x0
#define CHP2_8TH  0x1
#define CHP3_8TH  0x2
#define CHP4_8TH  0x3
#define CHP5_8TH  0x4
#define CHP6_8TH  0x5
#define CHP7_8TH  0x6

//
// TZSEL (Trip Zone Select) Register
//

//
// CBCn and OSHTn bits
//
#define TZ_DISABLE  0x0
#define TZ_ENABLE   0x1

//
// TZCTL (Trip Zone Control) Register
//

//
// TZA and TZB bits
//
#define TZ_HIZ       0x0
#define TZ_FORCE_HI  0x1
#define TZ_FORCE_LO  0x2
#define TZ_NO_CHANGE 0x3

//
// TZDCSEL (Trip Zone Digital Compare) Register
//

//
// DCAEVT1, DCAEVT2, DCBEVT1, DCBEVT2 bits
//
#define TZ_EVT_DISABLE      0x0
#define TZ_DCAH_LOW         0x1
#define TZ_DCAH_HI          0x2
#define TZ_DCAL_LOW         0x3
#define TZ_DCAL_HI          0x4
#define TZ_DCAL_HI_DCAH_LOW 0x5

#define TZ_DCBH_LOW         0x1
#define TZ_DCBH_HI          0x2
#define TZ_DCBL_LOW         0x3
#define TZ_DCBL_HI          0x4
#define TZ_DCBL_HI_DCBH_LOW 0x5

//
// ETSEL (Event Trigger Select) Register
//

//
// INTEN
//
#define EPWMx_INT_ENABLE     0x1
#define EPWMx_INT_DISENABLE  0x0

//
////INTPSSEL
//
#define INTPSSEL_ETPS_SEL 0x0
#define INTPSSEL_ETINTPS_SEL 0x1

//
// INTSEL bits
//
#define ET_DCAEVT1SOC   0x0
#define ET_CTR_ZERO     0x1
#define ET_CTR_PRD      0x2
#define ET_CTR_PRDZERO  0x3
#define ET_CTRU_CMPA    0x4
#define ET_CTRD_CMPA    0x5
#define ET_CTRU_CMPB    0x6
#define ET_CTRD_CMPB    0x7

//
// ETPS (Event Trigger Pre-scale) Register
//

//
// INTPRD, SOCAPRD, SOCBPRD bits
//
#define ET_DISABLE  0x0
#define ET_1ST      0x1
#define ET_2ND      0x2
#define ET_3RD      0x3

//
// HRPWM (High Resolution PWM)
//

//
// HRCNFG Register
//

//
// EDGEMODE, EDGEMODEB bits
//
#define HR_DISABLE        0x0
#define HR_REP            0x1
#define HR_FEP            0x2
#define HR_BEP            0x3

//
// CTLMODE, CTLMODEB bits
//
#define HR_CMP            0x0
#define HR_PHS            0x1

//
// HRLOAD, HRLOADB bits
//
#define HR_CTR_ZERO       0x0
#define HR_CTR_PRD        0x1
#define HR_CTR_ZERO_PRD   0x2

//
// SELOUTB bit
//
#define HR_NORM_B         0x0
#define HR_INVERT_B       0x1

//
// SWAPAB bit
//
#define HR_NORM_AB        0x0
#define HR_SWAP_AB        0x1

//
// DC (Digital Compare)
//

//
// DCTRIPSEL Register
//
#define DC_TZ1           0x0
#define DC_TZ2           0x1
#define DC_TZ3           0x2
#define DC_TRIPIN1       0x0
#define DC_TRIPIN2       0x1
#define DC_TRIPIN3       0x2
#define DC_TRIPIN4       0x3
#define DC_TRIPIN5       0x4
#define DC_TRIPIN6       0x5
#define DC_TRIPIN7       0x6
#define DC_TRIPIN8       0x7
#define DC_TRIPIN9       0x8
#define DC_TRIPIN10      0x9
#define DC_TRIPIN11      0xA
#define DC_TRIPIN12      0xB
//      Reserved         0xC
#define DC_TRIPIN14      0xD
#define DC_TRIPIN15      0xE
#define DC_COMBINATION   0xF

//
// DCFCTL Register
//

//
// SRCSEL bits
//
#define DC_SRC_DCAEVT1   0x0
#define DC_SRC_DCAEVT2   0x1
#define DC_SRC_DCBEVT1   0x2
#define DC_SRC_DCBEVT2   0x3

//
// PULSESEL bits
//
#define DC_PULSESEL_PRD      0x0
#define DC_PULSESEL_ZERO     0x1
#define DC_PULSESEL_ZERO_PRD 0x2

//
// BLANKE bit
//
#define DC_BLANK_DISABLE 0x0
#define DC_BLANK_ENABLE  0x1

//
// BLANKINV bit
//
#define DC_BLANK_NOTINV  0x0
#define DC_BLANK_INV     0x1

//
// DCACTL/DCBCTL Register
//

//
// EVT1SRCSEL, EVT2SRCSEL bits
//
#define DC_EVT1          0x0
#define DC_EVT2          0x0
#define DC_EVT_FLT       0x1

//
// EVT1SYNCE bit
//
#define DC_EVT_SYNC      0x0
#define DC_EVT_ASYNC     0x1

//
// EVT1SOCE bit
//
#define DC_SOC_DISABLE   0x0
#define DC_SOC_ENABLE    0x1

//
//TZCLR
//
#define TZCLR_FLAG       0x1

//
//ETCLR
//
#define ETCLR_FLAG       0x1

//
//GLDCTL2
//
#define GLDCTL2_OSHTLD_ENABLE    0x1

//
//GLDCTL
//
#define GLDCTL_OSHTMODE_ENABLE  0x1
#define GLDCTL_GLD_ENABLE  0x1
//
//TZEINT
//
#define TZEINT_OST_ENABLE  0x1
#define TZEINT_OST_DISABLE  0x0

//
//TZSEL
//
#define TZSEL_OSHT1_ENABLE  0x1
#define TZSEL_OSHT1_DISABLE  0x0

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

// EPWM External References & Function Declarations

//extern volatile struct EPWM_REGS epwmRegs;
//extern volatile struct EPWM_TOP_REGS epwmtopRegs;
//---------------------------------------------------------------------------
// EPWM External References & Function Declarations:
//
//extern volatile struct EPWM_REGS EPwm1Regs;
//extern volatile struct EPWM_REGS EPwm2Regs;
//extern volatile struct EPWM_REGS EPwm3Regs;
//extern volatile struct EPWM_REGS EPwm4Regs;
//extern volatile struct EPWM_REGS EPwm5Regs;
//extern volatile struct EPWM_REGS EPwm6Regs;
//extern volatile struct EPWM_REGS EPwm7Regs;
//extern volatile struct EPWM_REGS EPwm8Regs;


#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_EPWM_H definition
