/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_plu.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_PLU_H
#define REGS_PLU_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// PLU Individual Register Bit Definitions:

struct LC0_LUTCTRL0_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC0_LUTCTRL0_REG {
	uint32_t 		 all;
	struct LC0_LUTCTRL0_BITS 		 bit;
};

struct LC0_LUTCTRL1_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC0_LUTCTRL1_REG {
	uint32_t 		 all;
	struct LC0_LUTCTRL1_BITS 		 bit;
};

struct LC0_LUTCTRL2_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC0_LUTCTRL2_REG {
	uint32_t 		 all;
	struct LC0_LUTCTRL2_BITS 		 bit;
};

struct LC0_LUTCTRL3_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC0_LUTCTRL3_REG {
	uint32_t 		 all;
	struct LC0_LUTCTRL3_BITS 		 bit;
};

struct LC0_FILT0_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC0_FILT0_REG {
	uint32_t 		 all;
	struct LC0_FILT0_BITS 		 bit;
};

struct LC0_FILT1_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC0_FILT1_REG {
	uint32_t 		 all;
	struct LC0_FILT1_BITS 		 bit;
};

struct LC0_FILT2_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC0_FILT2_REG {
	uint32_t 		 all;
	struct LC0_FILT2_BITS 		 bit;
};

struct LC0_FILT3_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC0_FILT3_REG {
	uint32_t 		 all;
	struct LC0_FILT3_BITS 		 bit;
};

struct LC0_INTDMAEN_BITS {			// bits   description
	uint32_t	LUT_INT_EN:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	LUT_DMA_EN:4;			// 11:8   
	uint32_t	rsvd2:4;			// 15:12   reserved
	uint32_t	FORCE_INT_EN:4;			// 19:16   
	uint32_t	rsvd3:4;			// 23:20   reserved
	uint32_t	FORCE_DMA_EN:4;			// 27:24   
	uint32_t	rsvd4:4;			// 31:28   reserved
};

union LC0_INTDMAEN_REG {
	uint32_t 		 all;
	struct LC0_INTDMAEN_BITS 		 bit;
};

struct LC0_STS_BITS {			// bits   description
	uint32_t	LUT_STS:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	FORCESTS:4;			// 11:8   
	uint32_t	rsvd2:20;			// 31:12   reserved
};

union LC0_STS_REG {
	uint32_t 		 all;
	struct LC0_STS_BITS 		 bit;
};

struct LC0_OUTPOL_BITS {			// bits   description
	uint32_t	OUTPOL:4;			// 3:0   
	uint32_t	rsvd1:28;			// 31:4   reserved
};

union LC0_OUTPOL_REG {
	uint32_t 		 all;
	struct LC0_OUTPOL_BITS 		 bit;
};

struct LC0_FFILT_BITS {			// bits   description
	uint32_t	FORCE_FILT:8;			// 7:0   
	uint32_t	rsvd1:8;			// 15:8   reserved
	uint32_t	FORCE_POL:4;			// 19:16   
	uint32_t	rsvd2:4;			// 23:20   reserved
	uint32_t	COMB_EN:4;			// 27:24   
	uint32_t	COMB_FORCE:4;			// 31:28   
};

union LC0_FFILT_REG {
	uint32_t 		 all;
	struct LC0_FFILT_BITS 		 bit;
};

struct LC0_FCTRL_BITS {			// bits   description
	uint32_t	FORCE_SENSE0:4;			// 3:0   
	uint32_t	FORCE_MODE0:2;			// 5:4   
	uint32_t	SYNC_SEL0:2;			// 7:6   
	uint32_t	FORCE_SENSE1:4;			// 11:8   
	uint32_t	FORCE_MODE1:2;			// 13:12   
	uint32_t	SYNC_SEL1:2;			// 15:14   
	uint32_t	FORCE_SENSE2:4;			// 19:16   
	uint32_t	FORCE_MODE2:2;			// 21:20   
	uint32_t	SYNC_SEL2:2;			// 23:22   
	uint32_t	FORCE_SENSE3:4;			// 27:24   
	uint32_t	FORCE_MODE3:2;			// 29:28   
	uint32_t	SYNC_SEL3:2;			// 31:30   
};

union LC0_FCTRL_REG {
	uint32_t 		 all;
	struct LC0_FCTRL_BITS 		 bit;
};

struct LC0_SCTRL_BITS {			// bits   description
	uint32_t	SW_MODE:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	SW_SYNC_SEL:2;			// 9:8   
	uint32_t	rsvd2:22;			// 31:10   reserved
};

union LC0_SCTRL_REG {
	uint32_t 		 all;
	struct LC0_SCTRL_BITS 		 bit;
};

struct LC1_LUTCTRL0_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC1_LUTCTRL0_REG {
	uint32_t 		 all;
	struct LC1_LUTCTRL0_BITS 		 bit;
};

struct LC1_LUTCTRL1_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC1_LUTCTRL1_REG {
	uint32_t 		 all;
	struct LC1_LUTCTRL1_BITS 		 bit;
};

struct LC1_LUTCTRL2_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC1_LUTCTRL2_REG {
	uint32_t 		 all;
	struct LC1_LUTCTRL2_BITS 		 bit;
};

struct LC1_LUTCTRL3_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC1_LUTCTRL3_REG {
	uint32_t 		 all;
	struct LC1_LUTCTRL3_BITS 		 bit;
};

struct LC1_FILT0_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC1_FILT0_REG {
	uint32_t 		 all;
	struct LC1_FILT0_BITS 		 bit;
};

struct LC1_FILT1_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC1_FILT1_REG {
	uint32_t 		 all;
	struct LC1_FILT1_BITS 		 bit;
};

struct LC1_FILT2_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC1_FILT2_REG {
	uint32_t 		 all;
	struct LC1_FILT2_BITS 		 bit;
};

struct LC1_FILT3_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC1_FILT3_REG {
	uint32_t 		 all;
	struct LC1_FILT3_BITS 		 bit;
};

struct LC1_INTDMAEN_BITS {			// bits   description
	uint32_t	LUT_INT_EN:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	LUT_DMA_EN:4;			// 11:8   
	uint32_t	rsvd2:4;			// 15:12   reserved
	uint32_t	FORCE_INT_EN:4;			// 19:16   
	uint32_t	rsvd3:4;			// 23:20   reserved
	uint32_t	FORCE_DMA_EN:4;			// 27:24   
	uint32_t	rsvd4:4;			// 31:28   reserved
};

union LC1_INTDMAEN_REG {
	uint32_t 		 all;
	struct LC1_INTDMAEN_BITS 		 bit;
};

struct LC1_STS_BITS {			// bits   description
	uint32_t	LUT_STS:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	FORCESTS:4;			// 11:8   
	uint32_t	rsvd2:20;			// 31:12   reserved
};

union LC1_STS_REG {
	uint32_t 		 all;
	struct LC1_STS_BITS 		 bit;
};

struct LC1_OUTPOL_BITS {			// bits   description
	uint32_t	OUTPOL:4;			// 3:0   
	uint32_t	rsvd1:28;			// 31:4   reserved
};

union LC1_OUTPOL_REG {
	uint32_t 		 all;
	struct LC1_OUTPOL_BITS 		 bit;
};

struct LC1_FFILT_BITS {			// bits   description
	uint32_t	FORCE_FILT:8;			// 7:0   
	uint32_t	rsvd1:8;			// 15:8   reserved
	uint32_t	FORCE_POL:4;			// 19:16   
	uint32_t	rsvd2:4;			// 23:20   reserved
	uint32_t	COMB_EN:4;			// 27:24   
	uint32_t	COMB_FORCE:4;			// 31:28   
};

union LC1_FFILT_REG {
	uint32_t 		 all;
	struct LC1_FFILT_BITS 		 bit;
};

struct LC1_FCTRL_BITS {			// bits   description
	uint32_t	FORCE_SENSE0:4;			// 3:0   
	uint32_t	FORCE_MODE0:2;			// 5:4   
	uint32_t	SYNC_SEL0:2;			// 7:6   
	uint32_t	FORCE_SENSE1:4;			// 11:8   
	uint32_t	FORCE_MODE1:2;			// 13:12   
	uint32_t	SYNC_SEL1:2;			// 15:14   
	uint32_t	FORCE_SENSE2:4;			// 19:16   
	uint32_t	FORCE_MODE2:2;			// 21:20   
	uint32_t	SYNC_SEL2:2;			// 23:22   
	uint32_t	FORCE_SENSE3:4;			// 27:24   
	uint32_t	FORCE_MODE3:2;			// 29:28   
	uint32_t	SYNC_SEL3:2;			// 31:30   
};

union LC1_FCTRL_REG {
	uint32_t 		 all;
	struct LC1_FCTRL_BITS 		 bit;
};

struct LC1_SCTRL_BITS {			// bits   description
	uint32_t	SW_MODE:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	SW_SYNC_SEL:2;			// 9:8   
	uint32_t	rsvd2:22;			// 31:10   reserved
};

union LC1_SCTRL_REG {
	uint32_t 		 all;
	struct LC1_SCTRL_BITS 		 bit;
};

struct LC2_LUTCTRL0_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC2_LUTCTRL0_REG {
	uint32_t 		 all;
	struct LC2_LUTCTRL0_BITS 		 bit;
};

struct LC2_LUTCTRL1_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC2_LUTCTRL1_REG {
	uint32_t 		 all;
	struct LC2_LUTCTRL1_BITS 		 bit;
};

struct LC2_LUTCTRL2_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC2_LUTCTRL2_REG {
	uint32_t 		 all;
	struct LC2_LUTCTRL2_BITS 		 bit;
};

struct LC2_LUTCTRL3_BITS {			// bits   description
	uint32_t	LUTCTRL:16;			// 15:0   
	uint32_t	rsvd1:16;			// 31:16   reserved
};

union LC2_LUTCTRL3_REG {
	uint32_t 		 all;
	struct LC2_LUTCTRL3_BITS 		 bit;
};

struct LC2_FILT0_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC2_FILT0_REG {
	uint32_t 		 all;
	struct LC2_FILT0_BITS 		 bit;
};

struct LC2_FILT1_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC2_FILT1_REG {
	uint32_t 		 all;
	struct LC2_FILT1_BITS 		 bit;
};

struct LC2_FILT2_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC2_FILT2_REG {
	uint32_t 		 all;
	struct LC2_FILT2_BITS 		 bit;
};

struct LC2_FILT3_BITS {			// bits   description
	uint32_t	LUT_FALL_FILT:16;			// 15:0   
	uint32_t	LUT_RISE_FILT:16;			// 31:16   
};

union LC2_FILT3_REG {
	uint32_t 		 all;
	struct LC2_FILT3_BITS 		 bit;
};

struct LC2_INTDMAEN_BITS {			// bits   description
	uint32_t	LUT_INT_EN:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	LUT_DMA_EN:4;			// 11:8   
	uint32_t	rsvd2:4;			// 15:12   reserved
	uint32_t	FORCE_INT_EN:4;			// 19:16   
	uint32_t	rsvd3:4;			// 23:20   reserved
	uint32_t	FORCE_DMA_EN:4;			// 27:24   
	uint32_t	rsvd4:4;			// 31:28   reserved
};

union LC2_INTDMAEN_REG {
	uint32_t 		 all;
	struct LC2_INTDMAEN_BITS 		 bit;
};

struct LC2_STS_BITS {			// bits   description
	uint32_t	LUT_STS:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	FORCESTS:4;			// 11:8   
	uint32_t	rsvd2:20;			// 31:12   reserved
};

union LC2_STS_REG {
	uint32_t 		 all;
	struct LC2_STS_BITS 		 bit;
};

struct LC2_OUTPOL_BITS {			// bits   description
	uint32_t	OUTPOL:4;			// 3:0   
	uint32_t	rsvd1:28;			// 31:4   reserved
};

union LC2_OUTPOL_REG {
	uint32_t 		 all;
	struct LC2_OUTPOL_BITS 		 bit;
};

struct LC2_FFILT_BITS {			// bits   description
	uint32_t	FORCE_FILT:8;			// 7:0   
	uint32_t	rsvd1:8;			// 15:8   reserved
	uint32_t	FORCE_POL:4;			// 19:16   
	uint32_t	rsvd2:4;			// 23:20   reserved
	uint32_t	COMB_EN:4;			// 27:24   
	uint32_t	COMB_FORCE:4;			// 31:28   
};

union LC2_FFILT_REG {
	uint32_t 		 all;
	struct LC2_FFILT_BITS 		 bit;
};

struct LC2_FCTRL_BITS {			// bits   description
	uint32_t	FORCE_SENSE0:4;			// 3:0   
	uint32_t	FORCE_MODE0:2;			// 5:4   
	uint32_t	SYNC_SEL0:2;			// 7:6   
	uint32_t	FORCE_SENSE1:4;			// 11:8   
	uint32_t	FORCE_MODE1:2;			// 13:12   
	uint32_t	SYNC_SEL1:2;			// 15:14   
	uint32_t	FORCE_SENSE2:4;			// 19:16   
	uint32_t	FORCE_MODE2:2;			// 21:20   
	uint32_t	SYNC_SEL2:2;			// 23:22   
	uint32_t	FORCE_SENSE3:4;			// 27:24   
	uint32_t	FORCE_MODE3:2;			// 29:28   
	uint32_t	SYNC_SEL3:2;			// 31:30   
};

union LC2_FCTRL_REG {
	uint32_t 		 all;
	struct LC2_FCTRL_BITS 		 bit;
};

struct LC2_SCTRL_BITS {			// bits   description
	uint32_t	SW_MODE:4;			// 3:0   
	uint32_t	rsvd1:4;			// 7:4   reserved
	uint32_t	SW_SYNC_SEL:2;			// 9:8   
	uint32_t	rsvd2:22;			// 31:10   reserved
};

union LC2_SCTRL_REG {
	uint32_t 		 all;
	struct LC2_SCTRL_BITS 		 bit;
};

struct MUXSEL0_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL0_REG {
	uint32_t 		 all;
	struct MUXSEL0_BITS 		 bit;
};

struct MUXSEL1_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL1_REG {
	uint32_t 		 all;
	struct MUXSEL1_BITS 		 bit;
};

struct MUXSEL2_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL2_REG {
	uint32_t 		 all;
	struct MUXSEL2_BITS 		 bit;
};

struct MUXSEL3_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL3_REG {
	uint32_t 		 all;
	struct MUXSEL3_BITS 		 bit;
};

struct MUXSEL4_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL4_REG {
	uint32_t 		 all;
	struct MUXSEL4_BITS 		 bit;
};

struct MUXSEL5_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL5_REG {
	uint32_t 		 all;
	struct MUXSEL5_BITS 		 bit;
};

struct MUXSEL6_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL6_REG {
	uint32_t 		 all;
	struct MUXSEL6_BITS 		 bit;
};

struct MUXSEL7_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL7_REG {
	uint32_t 		 all;
	struct MUXSEL7_BITS 		 bit;
};

struct MUXSEL8_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL8_REG {
	uint32_t 		 all;
	struct MUXSEL8_BITS 		 bit;
};

struct MUXSEL9_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL9_REG {
	uint32_t 		 all;
	struct MUXSEL9_BITS 		 bit;
};

struct MUXSEL10_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL10_REG {
	uint32_t 		 all;
	struct MUXSEL10_BITS 		 bit;
};

struct MUXSEL11_BITS {			// bits   description
	uint32_t	MUXSEL:8;			// 7:0   
	uint32_t	rsvd1:24;			// 31:8   reserved
};

union MUXSEL11_REG {
	uint32_t 		 all;
	struct MUXSEL11_BITS 		 bit;
};

struct SWEN_BITS {			// bits   description
	uint32_t	SWEN:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union SWEN_REG {
	uint32_t 		 all;
	struct SWEN_BITS 		 bit;
};

struct SWVALUE_BITS {			// bits   description
	uint32_t	SWVALUE:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union SWVALUE_REG {
	uint32_t 		 all;
	struct SWVALUE_BITS 		 bit;
};

struct OUTEN_BITS {			// bits   description
	uint32_t	OUTEN:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union OUTEN_REG {
	uint32_t 		 all;
	struct OUTEN_BITS 		 bit;
};

struct LCIN_BITS {			// bits   description
	uint32_t	LC_INPUTS:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union LCIN_REG {
	uint32_t 		 all;
	struct LCIN_BITS 		 bit;
};

struct SWOUT_BITS {			// bits   description
	uint32_t	SWOUT:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union SWOUT_REG {
	uint32_t 		 all;
	struct SWOUT_BITS 		 bit;
};

struct LCOUT_BITS {			// bits   description
	uint32_t	LCOUT:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union LCOUT_REG {
	uint32_t 		 all;
	struct LCOUT_BITS 		 bit;
};

struct FORCEOUT_BITS {			// bits   description
	uint32_t	FORCEOUT:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union FORCEOUT_REG {
	uint32_t 		 all;
	struct FORCEOUT_BITS 		 bit;
};

struct FORCESTS_BITS {			// bits   description
	uint32_t	FORCESTS:12;			// 11:0   
	uint32_t	rsvd1:20;			// 31:12   reserved
};

union FORCESTS_REG {
	uint32_t 		 all;
	struct FORCESTS_BITS 		 bit;
};

struct INT_FLAG_BITS {			// bits   description
	uint32_t	LC0_OUT_INT_CLR:1;			// 0:0   
	uint32_t	LC0_FORCE_INT_CLR:1;			// 1:1   
	uint32_t	LC0_OUT_INT_FLAG:1;			// 2:2   
	uint32_t	LC0_FORCE_INT_FLAG:1;			// 3:3   
	uint32_t	LC1_OUT_INT_CLR:1;			// 4:4   
	uint32_t	LC1_FORCE_INT_CLR:1;			// 5:5   
	uint32_t	LC1_OUT_INT_FLAG:1;			// 6:6   
	uint32_t	LC1_FORCE_INT_FLAG:1;			// 7:7   
	uint32_t	LC2_OUT_INT_CLR:1;			// 8:8   
	uint32_t	LC2_FORCE_INT_CLR:1;			// 9:9   
	uint32_t	LC2_OUT_INT_FLAG:1;			// 10:10   
	uint32_t	LC2_FORCE_INT_FLAG:1;			// 11:11   
	uint32_t	LC_INT_MODE:1;			// 12:12   
	uint32_t	rsvd1:19;			// 31:13   reserved
};

union INT_FLAG_REG {
	uint32_t 		 all;
	struct INT_FLAG_BITS 		 bit;
};

struct PLU_IN_0SEL_BITS {			// bits   description
	uint32_t	PLU_IN_0SEL:10;			// 9:0   
	uint32_t	PLU_IN_1SEL:10;			// 19:10   
	uint32_t	PLU_IN_2SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_IN_0SEL_REG {
	uint32_t 		 all;
	struct PLU_IN_0SEL_BITS 		 bit;
};

struct PLU_IN_1SEL_BITS {			// bits   description
	uint32_t	PLU_IN_3SEL:10;			// 9:0   
	uint32_t	PLU_IN_4SEL:10;			// 19:10   
	uint32_t	PLU_IN_5SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_IN_1SEL_REG {
	uint32_t 		 all;
	struct PLU_IN_1SEL_BITS 		 bit;
};

struct PLU_IN_2SEL_BITS {			// bits   description
	uint32_t	PLU_IN_6SEL:10;			// 9:0   
	uint32_t	PLU_IN_7SEL:10;			// 19:10   
	uint32_t	PLU_IN_8SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_IN_2SEL_REG {
	uint32_t 		 all;
	struct PLU_IN_2SEL_BITS 		 bit;
};

struct PLU_IN_3SEL_BITS {			// bits   description
	uint32_t	PLU_IN_9SEL:10;			// 9:0   
	uint32_t	PLU_IN_10SEL:10;			// 19:10   
	uint32_t	PLU_IN_11SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_IN_3SEL_REG {
	uint32_t 		 all;
	struct PLU_IN_3SEL_BITS 		 bit;
};

struct PLU_FORCE_0SEL_BITS {			// bits   description
	uint32_t	PLU_FORCE_0SEL:10;			// 9:0   
	uint32_t	PLU_FORCE_1SEL:10;			// 19:10   
	uint32_t	PLU_FORCE_2SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_FORCE_0SEL_REG {
	uint32_t 		 all;
	struct PLU_FORCE_0SEL_BITS 		 bit;
};

struct PLU_FORCE_1SEL_BITS {			// bits   description
	uint32_t	PLU_FORCE_3SEL:10;			// 9:0   
	uint32_t	rsvd1:22;			// 31:10   reserved
};

union PLU_FORCE_1SEL_REG {
	uint32_t 		 all;
	struct PLU_FORCE_1SEL_BITS 		 bit;
};

struct PLU_SYN_0SEL_BITS {			// bits   description
	uint32_t	PLU_SYN_0SEL:10;			// 9:0   
	uint32_t	PLU_SYN_1SEL:10;			// 19:10   
	uint32_t	PLU_SYN_2SEL:10;			// 29:20   
	uint32_t	rsvd1:2;			// 31:30   reserved
};

union PLU_SYN_0SEL_REG {
	uint32_t 		 all;
	struct PLU_SYN_0SEL_BITS 		 bit;
};

struct PLU_SYN_1SEL_BITS {			// bits   description
	uint32_t	PLU_SYN_3SEL:10;			// 9:0   
	uint32_t	rsvd1:22;			// 31:10   reserved
};

union PLU_SYN_1SEL_REG {
	uint32_t 		 all;
	struct PLU_SYN_1SEL_BITS 		 bit;
};

struct PLU_HALT_EN_BITS {			// bits   description
	uint32_t	PLU_HALT_EN:2;			// 1:0   
	uint32_t	rsvd1:30;			// 31:2   reserved
};

union PLU_HALT_EN_REG {
	uint32_t 		 all;
	struct PLU_HALT_EN_BITS 		 bit;
};

struct PLU_INT_REQ_EN_BITS {			// bits   description
	uint32_t	PLU_LC1_INT_REQ_EN:2;			// 1:0   
	uint32_t	PLU_LC2_INT_REQ_EN:2;			// 3:2   
	uint32_t	PLU_LC3_INT_REQ_EN:2;			// 5:4   
	uint32_t	rsvd1:26;			// 31:6   reserved
};

union PLU_INT_REQ_EN_REG {
	uint32_t 		 all;
	struct PLU_INT_REQ_EN_BITS 		 bit;
};


// PLU Register Definitions:

struct PLU_REGS {
	union  LC0_LUTCTRL0_REG			LC0_LUTCTRL0;
	union  LC0_LUTCTRL1_REG			LC0_LUTCTRL1;
	union  LC0_LUTCTRL2_REG			LC0_LUTCTRL2;
	union  LC0_LUTCTRL3_REG			LC0_LUTCTRL3;
	union  LC0_FILT0_REG			LC0_FILT0;
	union  LC0_FILT1_REG			LC0_FILT1;
	union  LC0_FILT2_REG			LC0_FILT2;
	union  LC0_FILT3_REG			LC0_FILT3;
	union  LC0_INTDMAEN_REG			LC0_INTDMAEN;
	union  LC0_STS_REG			LC0_STS;
	union  LC0_OUTPOL_REG			LC0_OUTPOL;
	union  LC0_FFILT_REG			LC0_FFILT;
	union  LC0_FCTRL_REG			LC0_FCTRL;
	union  LC0_SCTRL_REG			LC0_SCTRL;
	uint32_t 						rsvd1[2]; 		 // reserved
	union  LC1_LUTCTRL0_REG			LC1_LUTCTRL0;
	union  LC1_LUTCTRL1_REG			LC1_LUTCTRL1;
	union  LC1_LUTCTRL2_REG			LC1_LUTCTRL2;
	union  LC1_LUTCTRL3_REG			LC1_LUTCTRL3;
	union  LC1_FILT0_REG			LC1_FILT0;
	union  LC1_FILT1_REG			LC1_FILT1;
	union  LC1_FILT2_REG			LC1_FILT2;
	union  LC1_FILT3_REG			LC1_FILT3;
	union  LC1_INTDMAEN_REG			LC1_INTDMAEN;
	union  LC1_STS_REG			LC1_STS;
	union  LC1_OUTPOL_REG			LC1_OUTPOL;
	union  LC1_FFILT_REG			LC1_FFILT;
	union  LC1_FCTRL_REG			LC1_FCTRL;
	union  LC1_SCTRL_REG			LC1_SCTRL;
	uint32_t 						rsvd2[2]; 		 // reserved
	union  LC2_LUTCTRL0_REG			LC2_LUTCTRL0;
	union  LC2_LUTCTRL1_REG			LC2_LUTCTRL1;
	union  LC2_LUTCTRL2_REG			LC2_LUTCTRL2;
	union  LC2_LUTCTRL3_REG			LC2_LUTCTRL3;
	union  LC2_FILT0_REG			LC2_FILT0;
	union  LC2_FILT1_REG			LC2_FILT1;
	union  LC2_FILT2_REG			LC2_FILT2;
	union  LC2_FILT3_REG			LC2_FILT3;
	union  LC2_INTDMAEN_REG			LC2_INTDMAEN;
	union  LC2_STS_REG			LC2_STS;
	union  LC2_OUTPOL_REG			LC2_OUTPOL;
	union  LC2_FFILT_REG			LC2_FFILT;
	union  LC2_FCTRL_REG			LC2_FCTRL;
	union  LC2_SCTRL_REG			LC2_SCTRL;
	uint32_t 						rsvd3[18]; 		 // reserved
	union  MUXSEL0_REG			MUXSEL0;
	union  MUXSEL1_REG			MUXSEL1;
	union  MUXSEL2_REG			MUXSEL2;
	union  MUXSEL3_REG			MUXSEL3;
	union  MUXSEL4_REG			MUXSEL4;
	union  MUXSEL5_REG			MUXSEL5;
	union  MUXSEL6_REG			MUXSEL6;
	union  MUXSEL7_REG			MUXSEL7;
	union  MUXSEL8_REG			MUXSEL8;
	union  MUXSEL9_REG			MUXSEL9;
	union  MUXSEL10_REG			MUXSEL10;
	union  MUXSEL11_REG			MUXSEL11;
	uint32_t 						rsvd4[21]; 		 // reserved
	union  SWEN_REG			SWEN;
	union  SWVALUE_REG			SWVALUE;
	union  OUTEN_REG			OUTEN;
	union  LCIN_REG			LCIN;
	union  SWOUT_REG			SWOUT;
	union  LCOUT_REG			LCOUT;
	union  FORCEOUT_REG			FORCEOUT;
	union  FORCESTS_REG			FORCESTS;
	uint32_t 						rsvd5[3]; 		 // reserved
	union  INT_FLAG_REG			INT_FLAG;
	uint32_t 						rsvd6[3]; 		 // reserved
	union  PLU_IN_0SEL_REG			PLU_IN_0SEL;
	union  PLU_IN_1SEL_REG			PLU_IN_1SEL;
	union  PLU_IN_2SEL_REG			PLU_IN_2SEL;
	union  PLU_IN_3SEL_REG			PLU_IN_3SEL;
	union  PLU_FORCE_0SEL_REG			PLU_FORCE_0SEL;
	union  PLU_FORCE_1SEL_REG			PLU_FORCE_1SEL;
	union  PLU_SYN_0SEL_REG			PLU_SYN_0SEL;
	union  PLU_SYN_1SEL_REG			PLU_SYN_1SEL;
	union  PLU_HALT_EN_REG			PLU_HALT_EN;
	union  PLU_INT_REQ_EN_REG			PLU_INT_REQ_EN;
};

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */
// PLU External References & Function Declarations
extern volatile struct PLU_REGS pluRegs;

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_PLU_H definition
