/*
 *   Copyright (c) Gejian Semiconductors 2023
 *   All rights reserved.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/**
*   @file    regs_wd.h
*   @brief   
*   [note: This file is automatically generated and does not need to be 
*   manually edited. If you want to modify it, use the py script to generate]
*
*/

#ifndef REGS_WD_H
#define REGS_WD_H

#ifdef __cplusplus
extern "C" {
#endif

/* ========================================================================== */
/*                             Include Files                                  */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                           Macros & Typedefs                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Structures and Enums                               */
/* ========================================================================== */
// WD Individual Register Bit Definitions:

struct LOAD0_BITS {			// bits   description
	uint32_t	LOAD:32;			// 31:0   When this register is written to, the count is immediately restarted from the new value. The minimum
};

union LOAD0_REG {
	uint32_t 		 all;
	struct LOAD0_BITS 		 bit;
};

struct VALUE0_BITS {			// bits   description
	uint32_t	VALUE:32;			// 31:0   The WDVALUE Register gives the current value of the decrementing counter.
};

union VALUE0_REG {
	uint32_t 		 all;
	struct VALUE0_BITS 		 bit;
};

struct CONTROL0_BITS {				// bits   description
	uint32_t	INTEN:1;			// 0:0   Enable the interrupt event, WDINT. Set HIGH to enable the counter and the interrupt, or LOW to disable
	uint32_t	RESEN:1;			// 1:1   Enable watchdog reset output, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,
	uint32_t	rsvd1:30;			// 31:2   reserved
};

union CONTROL0_REG {
	uint32_t 		 all;
	struct CONTROL0_BITS 		 bit;
};

struct INTCLR0_BITS {			// bits   description
	uint32_t	INTCLR:32;			// 31:0   A write of any value to the WDINTCLR Register clears the watchdog interrupt, and reloads the counter
};

union INTCLR0_REG {
	uint32_t 		 all;
	struct INTCLR0_BITS 		 bit;
};

struct RIS0_BITS {			// bits   description
	uint32_t	RINT:1;			// 0:0   Raw interrupt status from the counter
	uint32_t	rsvd1:31;		// 31:1   reserved
};

union RIS0_REG {
	uint32_t 		 all;
	struct RIS0_BITS 		 bit;
};

struct MIS0_BITS {			// bits   description
	uint32_t	MINT:1;			// 0:0   Enabled interrupt status from the counter
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union MIS0_REG {
	uint32_t 		 all;
	struct MIS0_BITS 		 bit;
};

struct LOAD1_BITS {			// bits   description
	uint32_t	LOAD:32;			// 31:0   When this register is written to, the count is immediately restarted from the new value. The minimum
};

union LOAD1_REG {
	uint32_t 		 all;
	struct LOAD1_BITS 		 bit;
};

struct VALUE1_BITS {			// bits   description
	uint32_t	VALUE:31;			// 31:1   The WDVALUE Register gives the current value of the decrementing counter.
};

union VALUE1_REG {
	uint32_t 		 all;
	struct VALUE1_BITS 		 bit;
};

struct CONTROL1_BITS {			// bits   description
	uint32_t	INTEN:1;			// 0:0   Enable the interrupt event, WDINT. Set HIGH to enable the counter and the interrupt, or LOW to disable
	uint32_t	RESEN:1;			// 1:1   Enable watchdog reset output, WDRES. Acts as a mask for the reset output. Set HIGH to enable the reset,
	uint32_t	rsvd1:30;			// 31:2   reserved
};

union CONTROL1_REG {
	uint32_t 		 all;
	struct CONTROL1_BITS 		 bit;
};

struct INTCLR1_BITS {			// bits   description
	uint32_t	INTCLR:32;			// 31:0   A write of any value to the WDINTCLR Register clears the watchdog interrupt, and reloads the counter
};

union INTCLR1_REG {
	uint32_t 		 all;
	struct INTCLR1_BITS 		 bit;
};

struct RIS1_BITS {			// bits   description
	uint32_t	RINT:1;			// 0:0   Raw interrupt status from the counter
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union RIS1_REG {
	uint32_t 		 all;
	struct RIS1_BITS 		 bit;
};

struct MIS1_BITS {			// bits   description
	uint32_t	MINT:1;			// 0:0   Enabled interrupt status from the counter
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union MIS1_REG {
	uint32_t 		 all;
	struct MIS1_BITS 		 bit;
};

struct WINVALUE1_BITS {			// bits   description
	uint32_t	VALUE:32;			// 31:0   The windowed value.
};

union WINVALUE1_REG {
	uint32_t 		 all;
	struct WINVALUE1_BITS 		 bit;
};

struct LOCK_BITS {			// bits   description
	uint32_t	KEY:1;			// 0:0   Write access to all other registers, 0 is enabled,1 is disabled.
	uint32_t	STAT:31;			// 31:1   Enable write access to all other registers by writing 0x1ACCE551. Disable write access by writing any
};

union LOCK_REG {
	uint32_t 		 all;
	struct LOCK_BITS 		 bit;
};

struct ITCR_BITS {			// bits   description
	uint32_t	MODE:1;			// 0:0   When set HIGH, places the watchdog into integration test mode
	uint32_t	rsvd1:31;			// 31:1   reserved
};

union ITCR_REG {
	uint32_t 		 all;
	struct ITCR_BITS 		 bit;
};

struct ITOP_BITS {			// bits   description
	uint32_t	RES:1;			// 0:0   Value output on WDRES when in Integration Test Mode
	uint32_t	INT:1;			// 1:1   Value output on WDINT when in Integration Test Mode
	uint32_t	rsvd1:30;			// 31:2   reserved
};

union ITOP_REG {
	uint32_t 		 all;
	struct ITOP_BITS 		 bit;
};


// WD Register Definitions:

struct WD_REGS {
	union  LOAD0_REG			LOAD0;
	union  VALUE0_REG			VALUE0;
	union  CONTROL0_REG			CONTROL0;
	union  INTCLR0_REG			INTCLR0;
	union  RIS0_REG			RIS0;
	union  MIS0_REG			MIS0;
//	uint32_t 						rsvd1[2]; 		 // reserved
//	union  LOAD1_REG			LOAD1;
//	union  VALUE1_REG			VALUE1;
//	union  CONTROL1_REG			CONTROL1;
//	union  INTCLR1_REG			INTCLR1;
//	union  RIS1_REG			RIS1;
//	union  MIS1_REG			MIS1;
//	union  WINVALUE1_REG			WINVALUE1;
//	uint32_t 						rsvd2[753]; 		 // reserved
//	union  LOCK_REG			LOCK;
//	uint32_t 						rsvd3[191]; 		 // reserved
//	union  ITCR_REG			ITCR;
//	union  ITOP_REG			ITOP;
};


/* ========================================================================== */
/*                            Global Constants                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                            Global Variables                                */
/* ========================================================================== */

/* None */

/* ========================================================================== */
/*                         Global Functions Declarations                      */
/* ========================================================================== */
// WD External References & Function Declarations

extern volatile struct WD_REGS wdRegs;

/**
 * \brief   add brief
 *
 * \param   parameter1   description of parameter1
 * \param   parameter2   description of parameter2
 *
 * \retval  None
 */

#ifdef __cplusplus
}
#endif /* extern "C" */


#endif  // end of REGS_WD_H definition
